/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import com.aelitis.azureus.plugins.net.buddy.swt.columns.ColumnChatFavorite;
import com.aelitis.azureus.plugins.net.buddy.swt.columns.ColumnChatMessageCount;
import com.aelitis.azureus.plugins.net.buddy.swt.columns.ColumnChatMsgOutstanding;
import com.aelitis.azureus.plugins.net.buddy.swt.columns.ColumnChatName;
import com.aelitis.azureus.plugins.net.buddy.swt.columns.ColumnChatStatus;
import com.aelitis.azureus.plugins.net.buddy.swt.columns.ColumnChatUserCount;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.columns.tag.ColumnTagName;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.InfoBarUtil;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_ChatOverview
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<BuddyPluginBeta.ChatInstance>,
BuddyPluginBeta.ChatManagerListener,
TableViewSWTMenuFillListener,
TableSelectionListener {
    private static final String TABLE_CHAT = "ChatsView";
    TableViewSWT<BuddyPluginBeta.ChatInstance> tv;
    private Text txtFilter;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean listener_added;

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        Object[] datasources;
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if (item.getID().equals("remove") && (datasources = this.tv.getSelectedDataSources().toArray()).length > 0) {
            for (Object object : datasources) {
                if (!(object instanceof BuddyPluginBeta.ChatInstance)) continue;
                BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)object;
                chat.destroy();
            }
            return true;
        }
        return false;
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            for (Object object : datasources) {
                if (!(object instanceof BuddyPluginBeta.ChatInstance)) continue;
            }
        }
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return "TagsView";
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        new InfoBarUtil(skinObject, "chatsview.infobar", false, "chats.infobar", "chats.view.infobar"){

            public boolean allowShow() {
                return true;
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_ChatOverview> clazz = SBC_ChatOverview.class;
        synchronized (SBC_ChatOverview.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatName.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatName(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatMessageCount.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatMessageCount(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatUserCount.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatUserCount(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatFavorite.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatFavorite(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatMsgOutstanding.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatMsgOutstanding(column);
                }
            });
            tableManager.registerColumn(BuddyPluginBeta.ChatInstance.class, ColumnChatStatus.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnChatStatus(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_CHAT, new String[]{ColumnChatName.COLUMN_ID, ColumnChatMessageCount.COLUMN_ID, ColumnChatUserCount.COLUMN_ID, ColumnChatFavorite.COLUMN_ID, ColumnChatMsgOutstanding.COLUMN_ID, ColumnChatStatus.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_CHAT, ColumnTagName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
        if (beta != null) {
            beta.removeListener(this);
            this.listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("chats-list");
        if (so_list == null) {
            System.out.println("NO chats-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
        if (beta != null && !this.listener_added) {
            this.listener_added = true;
            beta.addListener(this, true);
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.listener_added) {
            this.listener_added = false;
            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
            if (beta != null) {
                beta.removeListener(this);
            }
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(BuddyPluginBeta.ChatInstance.class, TABLE_CHAT, TABLE_CHAT, new TableColumnCore[0], ColumnTagName.COLUMN_ID, 0x10010002);
            if (this.txtFilter != null) {
                this.tv.enableFilterCheck(this.txtFilter, this);
            }
            this.tv.setRowDefaultHeight(16);
            this.table_parent = new Composite(control, 2048);
            this.table_parent.setLayoutData((Object)Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
        }
        control.layout(true);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        ArrayList<BuddyPluginBeta.ChatInstance> chats = new ArrayList<BuddyPluginBeta.ChatInstance>();
        for (Object obj : ds) {
            if (!(obj instanceof BuddyPluginBeta.ChatInstance)) continue;
            chats.add((BuddyPluginBeta.ChatInstance)obj);
        }
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        Object obj;
        if (rows.length == 1 && (obj = rows[0].getDataSource()) instanceof BuddyPluginBeta.ChatInstance) {
            BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)obj;
            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
            if (beta != null) {
                try {
                    beta.showChat(chat);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public void chatAdded(BuddyPluginBeta.ChatInstance chat) {
        this.tv.addDataSource(chat);
    }

    public void chatChanged(BuddyPluginBeta.ChatInstance chat) {
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        TableRowCore row = this.tv.getRow(chat);
        if (row != null) {
            row.invalidate(true);
        }
    }

    @Override
    public void chatRemoved(BuddyPluginBeta.ChatInstance chat) {
        this.tv.removeDataSource(chat);
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean filterCheck(BuddyPluginBeta.ChatInstance ds, String filter2, boolean regex) {
        return false;
    }
}

