/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTransferAutoSpeedBeta
implements UISWTConfigSection {
    private Group commentGroup;
    private Group uploadCapGroup;
    private Group dhtGroup;
    private IntParameter adjustmentInterval;
    private BooleanParameter skipAfterAdjustment;

    public String configSectionGetParentSection() {
        return "transfer.select";
    }

    public String configSectionGetName() {
        return "transfer.select.v2";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout subPanel = new GridLayout();
        subPanel.numColumns = 3;
        cSection.setLayout((Layout)subPanel);
        this.commentGroup = new Group(cSection, 0);
        Messages.setLanguageText((Widget)this.commentGroup, "ConfigTransferAutoSpeed.add.comment.to.log.group");
        GridLayout commentLayout = new GridLayout();
        commentLayout.numColumns = 3;
        this.commentGroup.setLayout((Layout)commentLayout);
        gridData = new GridData(768);
        this.commentGroup.setLayoutData((Object)gridData);
        Label commentLabel = new Label((Composite)this.commentGroup, 0);
        Messages.setLanguageText((Widget)commentLabel, "ConfigTransferAutoSpeed.add.comment.to.log");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        commentLabel.setLayoutData((Object)gridData);
        final Text commentBox = new Text((Composite)this.commentGroup, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        commentBox.setText("");
        commentBox.setLayoutData((Object)gridData);
        Button commentButton = new Button((Composite)this.commentGroup, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        commentButton.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)commentButton, "ConfigTransferAutoSpeed.log.button");
        commentButton.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                AEDiagnosticsLogger dLog = AEDiagnostics.getLogger("AutoSpeed");
                String comment = commentBox.getText();
                if (comment != null && comment.length() > 0) {
                    dLog.log("user-comment:" + comment);
                    commentBox.setText("");
                }
            }
        });
        Label commentSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        commentSpacer.setLayoutData((Object)gridData);
        this.uploadCapGroup = new Group(cSection, 0);
        Messages.setLanguageText((Widget)this.uploadCapGroup, "ConfigTransferAutoSpeed.upload.capacity.usage");
        GridLayout uCapLayout = new GridLayout();
        uCapLayout.numColumns = 2;
        this.uploadCapGroup.setLayout((Layout)uCapLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.uploadCapGroup.setLayoutData((Object)gridData);
        Label upCapModeLbl = new Label((Composite)this.uploadCapGroup, 0);
        gridData = new GridData();
        upCapModeLbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)upCapModeLbl, "ConfigTransferAutoSpeed.mode");
        Label ucSetLbl = new Label((Composite)this.uploadCapGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        Messages.setLanguageText((Widget)ucSetLbl, "ConfigTransferAutoSpeed.capacity.used");
        Label dlModeLbl = new Label((Composite)this.uploadCapGroup, 0);
        gridData = new GridData();
        Messages.setLanguageText((Widget)dlModeLbl, "ConfigTransferAutoSpeed.while.downloading");
        String[] downloadModeNames = new String[]{" 80%", " 70%", " 60%", " 50%"};
        int[] downloadModeValues = new int[]{80, 70, 60, 50};
        new IntListParameter((Composite)this.uploadCapGroup, "SpeedLimitMonitor.setting.upload.used.download.mode", downloadModeNames, downloadModeValues);
        Label cSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        cSpacer.setLayoutData((Object)gridData);
        this.dhtGroup = new Group(cSection, 0);
        Messages.setLanguageText((Widget)this.dhtGroup, "ConfigTransferAutoSpeed.data.update.frequency");
        this.dhtGroup.setLayout((Layout)subPanel);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.dhtGroup.setLayoutData((Object)gridData);
        Label iCount = new Label((Composite)this.dhtGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 1;
        iCount.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)iCount, "ConfigTransferAutoSpeed.adjustment.interval");
        this.adjustmentInterval = new IntParameter((Composite)this.dhtGroup, "SpeedManagerAlgorithmProviderV2.intervals.between.adjust");
        gridData = new GridData();
        this.adjustmentInterval.setLayoutData(gridData);
        cSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        cSpacer.setLayoutData((Object)gridData);
        Label skip = new Label((Composite)this.dhtGroup, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 1;
        skip.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)skip, "ConfigTransferAutoSpeed.skip.after.adjust");
        this.skipAfterAdjustment = new BooleanParameter((Composite)this.dhtGroup, "SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust");
        gridData = new GridData();
        this.skipAfterAdjustment.setLayoutData(gridData);
        cSpacer = new Label(cSection, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        cSpacer.setLayoutData((Object)gridData);
        return cSection;
    }

    void enableGroups(String strategyListValue) {
        if (strategyListValue == null) {
            return;
        }
        boolean isBothEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
        boolean isSeedingEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
        long version = COConfigurationManager.getLongParameter("Auto Upload Speed Version");
        boolean isV2Enabled = false;
        if ((isBothEnabled || isSeedingEnabled) && version == 2L) {
            isV2Enabled = true;
        }
        if (this.commentGroup != null) {
            if (isV2Enabled) {
                this.commentGroup.setEnabled(true);
                this.commentGroup.setVisible(true);
            } else {
                this.commentGroup.setEnabled(false);
                this.commentGroup.setVisible(false);
            }
        }
    }

    class GroupModeChangeListener
    implements ParameterChangeListener {
        GroupModeChangeListener() {
        }

        public void parameterChanged(Parameter p, boolean caused_internally) {
        }

        public void intParameterChanging(Parameter p, int toValue) {
        }

        public void booleanParameterChanging(Parameter p, boolean toValue) {
        }

        public void stringParameterChanging(Parameter p, String toValue) {
        }

        public void floatParameterChanging(Parameter owner, double toValue) {
        }
    }

    class RestoreDefaultsListener
    implements Listener {
        RestoreDefaultsListener() {
        }

        public void handleEvent(Event event2) {
            ConfigurationDefaults configDefs = ConfigurationDefaults.getInstance();
            try {
                long downMax = configDefs.getLongParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
                String downConf = configDefs.getStringParameter("SpeedLimitMonitor.setting.download.limit.conf");
                long upMax = configDefs.getLongParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
                String upConf = configDefs.getStringParameter("SpeedLimitMonitor.setting.upload.limit.conf");
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", downMax);
                COConfigurationManager.setParameter("SpeedLimitMonitor.setting.download.limit.conf", downConf);
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", upMax);
                COConfigurationManager.setParameter("SpeedLimitMonitor.setting.upload.limit.conf", upConf);
            }
            catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
                // empty catch block
            }
        }
    }
}

