/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus;

import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTester;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class NetStatusPlugin
implements Plugin {
    public static final String VIEW_ID = "aznetstatus";
    private PluginInterface plugin_interface;
    private LoggerChannel logger;
    private BooleanParameter logging_detailed;
    private ActionParameter test_button;
    private StringParameter test_address;
    private NetStatusProtocolTester protocol_tester;
    private AESemaphore protocol_tester_sem = new AESemaphore("ProtTestSem");

    public static void load(PluginInterface plugin_interface) {
        String name = plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("Views.plugins.aznetstatus.title");
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", name);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.logger = this.plugin_interface.getLogger().getChannel("NetStatus");
        this.logger.setDiagnostic();
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("Views.plugins.aznetstatus.title");
        this.logging_detailed = config.addBooleanParameter2("plugin.aznetstatus.logfull", "plugin.aznetstatus.logfull", false);
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance.getUIType() == 1) {
                    try {
                        Class.forName("com.aelitis.azureus.plugins.net.netstatus.swt.NetStatusPluginView").getConstructor(NetStatusPlugin.class, UIInstance.class, String.class).newInstance(NetStatusPlugin.this, instance, NetStatusPlugin.VIEW_ID);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                new AEThread2("NetstatusPlugin:init", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NetStatusPlugin.this.protocol_tester = new NetStatusProtocolTester(NetStatusPlugin.this, NetStatusPlugin.this.plugin_interface);
                            if (NetStatusPlugin.this.test_button != null) {
                                NetStatusPlugin.this.test_button.setEnabled(true);
                            }
                            Object var2_1 = null;
                            NetStatusPlugin.this.protocol_tester_sem.releaseForever();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            NetStatusPlugin.this.protocol_tester_sem.releaseForever();
                            throw throwable;
                        }
                    }
                }.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    public boolean isDetailedLogging() {
        return this.logging_detailed.getValue();
    }

    public NetStatusProtocolTester getProtocolTester() {
        this.protocol_tester_sem.reserve();
        return this.protocol_tester;
    }

    public void setBooleanParameter(String name, boolean value) {
        this.plugin_interface.getPluginconfig().setPluginParameter(name, value);
    }

    public boolean getBooleanParameter(String name, boolean def) {
        return this.plugin_interface.getPluginconfig().getPluginBooleanParameter(name, def);
    }

    public void log(String str) {
        this.logger.log(str);
    }

    public void log(String str, Throwable e) {
        this.logger.log(str);
        this.logger.log(e);
    }
}

