/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMDI
extends SkinView
implements MultipleDocumentInterfaceSWT,
UIUpdatable {
    protected MdiEntrySWT currentEntry;
    private Map<String, MdiEntryCreationListener> mapIdToCreationListener = new LightHashMap<String, MdiEntryCreationListener>();
    private Map<String, MdiEntryCreationListener2> mapIdToCreationListener2 = new LightHashMap<String, MdiEntryCreationListener2>();
    protected Map<String, MdiEntrySWT> mapIdToEntry = new LightHashMap<String, MdiEntrySWT>();
    private List<MdiListener> listeners = new ArrayList<MdiListener>();
    private List<MdiEntryLoadedListener> listLoadListeners = new ArrayList<MdiEntryLoadedListener>();
    private static LinkedHashMap<String, Object> mapAutoOpen = new LinkedHashMap();
    private String[] preferredOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLoadedListener l) {
        MdiEntry[] entries;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            if (this.listLoadListeners.contains(l)) {
                return;
            }
            this.listLoadListeners.add(l);
        }
        for (MdiEntry entry : entries = this.getEntries()) {
            if (!entry.isAdded()) continue;
            l.mdiEntryLoaded(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLoadedListener l) {
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            this.listLoadListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerSelectionListener(MdiEntry newEntry, MdiEntry oldEntry) {
        MdiListener[] array;
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            array = this.listeners.toArray(new MdiListener[0]);
        }
        for (MdiListener l : array) {
            try {
                l.mdiEntrySelected(newEntry, oldEntry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEntryLoadedListeners(MdiEntry entry) {
        MdiEntryLoadedListener[] array;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            array = this.listLoadListeners.toArray(new MdiEntryLoadedListener[0]);
        }
        for (MdiEntryLoadedListener l : array) {
            try {
                l.mdiEntryLoaded(entry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void closeEntry(String id) {
        MdiEntry entry = this.getEntry(id);
        if (entry != null) {
            entry.close(false);
        } else {
            this.removeEntryAutoOpen(id);
        }
    }

    @Override
    public abstract MdiEntry createEntryFromEventListener(String var1, UISWTViewEventListener var2, String var3, boolean var4, Object var5, String var6);

    @Override
    public abstract MdiEntry createEntryFromView(String var1, UISWTViewCore var2, String var3, Object var4, boolean var5, boolean var6, boolean var7);

    @Override
    public abstract MdiEntry createEntryFromSkinRef(String var1, String var2, String var3, String var4, ViewTitleInfo var5, Object var6, boolean var7, String var8);

    @Override
    public MdiEntry getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public MdiEntrySWT getCurrentEntrySWT() {
        return this.currentEntry;
    }

    @Override
    public MdiEntry[] getEntries() {
        return this.mapIdToEntry.values().toArray(new MdiEntry[0]);
    }

    public MdiEntrySWT[] getEntriesSWT() {
        return this.mapIdToEntry.values().toArray(new MdiEntrySWT[0]);
    }

    @Override
    public MdiEntry getEntry(String id) {
        if ("browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        MdiEntry entry = this.mapIdToEntry.get(id);
        return entry;
    }

    @Override
    public MdiEntrySWT getEntrySWT(String id) {
        if ("browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        MdiEntrySWT entry = this.mapIdToEntry.get(id);
        return entry;
    }

    @Override
    public MdiEntry getEntryBySkinView(Object skinView) {
        SWTSkinObject so = ((SkinView)skinView).getMainSkinObject();
        Object[] sideBarEntries = this.mapIdToEntry.values().toArray();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            SWTSkinObject entrySOParent;
            BaseMdiEntry entry = (BaseMdiEntry)sideBarEntries[i];
            SWTSkinObject entrySO = entry.getSkinObject();
            SWTSkinObject sWTSkinObject = entrySOParent = entrySO == null ? entrySO : entrySO.getParent();
            if (entrySO != so && entrySO != so.getParent() && entrySOParent != so) continue;
            return entry;
        }
        return null;
    }

    @Override
    public UISWTViewCore getCoreViewFromID(String id) {
        if (id == null) {
            return null;
        }
        MdiEntrySWT entry = this.getEntrySWT(id);
        if (entry == null) {
            return null;
        }
        return entry.getCoreView();
    }

    @Override
    public String getUpdateUIName() {
        if (this.currentEntry == null || this.currentEntry.getView() == null) {
            return "MDI";
        }
        return this.currentEntry.getView().getViewID();
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener2 l) {
        this.mapIdToCreationListener2.put(id, l);
        this.createIfAutoOpen(id);
    }

    private boolean createIfAutoOpen(String id) {
        Object o = mapAutoOpen.get(id);
        if (o instanceof Map) {
            Map autoOpenMap = (Map)o;
            return this.createEntryByCreationListener(id, autoOpenMap.get("datasource"), autoOpenMap) != null;
        }
        return false;
    }

    private MdiEntry createEntryByCreationListener(String id, Object ds, Map<?, ?> autoOpenMap) {
        MdiEntryCreationListener mdiEntryCreationListener = null;
        for (String key : this.mapIdToCreationListener.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener = this.mapIdToCreationListener.get(key);
            break;
        }
        if (mdiEntryCreationListener != null) {
            try {
                MdiEntry mdiEntry = mdiEntryCreationListener.createMDiEntry(id);
                if (mdiEntry != null && ds != null) {
                    mdiEntry.setDatasource(ds);
                }
                return mdiEntry;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        MdiEntryCreationListener2 mdiEntryCreationListener2 = null;
        for (String key : this.mapIdToCreationListener2.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener2 = this.mapIdToCreationListener2.get(key);
            break;
        }
        if (mdiEntryCreationListener2 != null) {
            try {
                MdiEntry mdiEntry = mdiEntryCreationListener2.createMDiEntry(this, id, ds, autoOpenMap);
                if (mdiEntry == null) {
                    this.removeEntryAutoOpen(id);
                }
                return mdiEntry;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        this.setEntryAutoOpen(id, ds);
        return null;
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener l) {
        this.mapIdToCreationListener.put(id, l);
        this.createIfAutoOpen(id);
    }

    @Override
    public boolean showEntryByID(String id) {
        return this.loadEntryByID(id, true);
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        MdiEntry entry = this.getCurrentEntry();
        if (entry != null) {
            COConfigurationManager.setParameter("v3.StartTab", entry.getId());
            String ds = entry.getExportableDatasource();
            COConfigurationManager.setParameter("v3.StartTab.ds", ds == null ? null : ds.toString());
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public void updateUI() {
        MdiEntry currentEntry = this.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.updateUI();
        }
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate) {
        return this.loadEntryByID(id, activate, false, null);
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate, boolean onlyLoadOnce, Object datasource) {
        if (id == null) {
            return false;
        }
        MdiEntry entry = this.getEntry(id);
        if (entry != null) {
            if (datasource != null) {
                entry.setDatasource(datasource);
            }
            if (activate) {
                this.showEntry(entry);
            }
            return true;
        }
        boolean loadedOnce = this.wasEntryLoadedOnce(id);
        if (loadedOnce && onlyLoadOnce) {
            return false;
        }
        MdiEntry mdiEntry = this.createEntryByCreationListener(id, datasource, null);
        if (mdiEntry != null) {
            if (onlyLoadOnce) {
                this.setEntryLoadedOnce(id);
            }
            if (activate) {
                this.showEntry(mdiEntry);
            }
            return true;
        }
        return false;
    }

    protected abstract void setEntryLoadedOnce(String var1);

    protected abstract boolean wasEntryLoadedOnce(String var1);

    @Override
    public boolean entryExists(String id) {
        MdiEntry entry;
        if ("browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        if ((entry = (MdiEntry)this.mapIdToEntry.get(id)) == null) {
            return false;
        }
        return entry.isAdded();
    }

    @Override
    public void setEntryAutoOpen(String id, Object datasource) {
        LightHashMap map = (LightHashMap)mapAutoOpen.get(id);
        if (map == null) {
            map = new LightHashMap(1);
        }
        map.put("datasource", datasource);
        mapAutoOpen.put(id, map);
    }

    @Override
    public void removeEntryAutoOpen(String id) {
        mapAutoOpen.remove(id);
    }

    protected void setupPluginViews() {
        PluginsMenuHelper.getInstance().addPluginAddedViewListener(new PluginsMenuHelper.PluginAddedViewListener(){

            public void pluginViewAdded(PluginsMenuHelper.IViewInfo viewInfo) {
                Object o = mapAutoOpen.get(viewInfo.viewID);
                if (o instanceof Map) {
                    BaseMDI.this.processAutoOpenMap(viewInfo.viewID, (Map)o, viewInfo);
                }
            }
        });
    }

    @Override
    public void informAutoOpenSet(MdiEntry entry, Map<String, Object> autoOpenInfo) {
        mapAutoOpen.put(entry.getId(), autoOpenInfo);
    }

    public void loadCloseables() {
        try {
            Map loadedMap = FileUtil.readResilientConfigFile("sidebarauto.config", true);
            if (loadedMap.isEmpty()) {
                return;
            }
            BDecoder.decodeStrings(loadedMap);
            List orderedEntries = (List)loadedMap.get("_entries_");
            if (orderedEntries == null) {
                for (String id : loadedMap.keySet()) {
                    Object o = loadedMap.get(id);
                    if (!(o instanceof Map) || this.processAutoOpenMap(id, (Map)o, null)) continue;
                    mapAutoOpen.put(id, o);
                }
            } else {
                for (Map map : orderedEntries) {
                    String id = (String)map.get("id");
                    Object o = map.get("value");
                    if (!(o instanceof Map) || this.processAutoOpenMap(id, (Map)o, null)) continue;
                    mapAutoOpen.put(id, o);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void saveCloseables() {
        try {
            for (String id : new ArrayList<String>(mapAutoOpen.keySet())) {
                MdiEntry entry = this.getEntry(id);
                if (entry != null && entry.isAdded()) {
                    mapAutoOpen.put(id, entry.getAutoOpenInfo());
                    continue;
                }
                mapAutoOpen.remove(id);
            }
            HashMap map = new HashMap();
            ArrayList list = new ArrayList(mapAutoOpen.size());
            map.put("_entries_", list);
            for (Map.Entry<String, Object> entry : mapAutoOpen.entrySet()) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                list.add(m);
                String id = entry.getKey();
                m.put("id", id);
                m.put("value", entry.getValue());
            }
            FileUtil.writeResilientConfigFile("sidebarauto.config", map);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private boolean processAutoOpenMap(String id, Map<?, ?> autoOpenInfo, PluginsMenuHelper.IViewInfo viewInfo) {
        try {
            MdiEntry entry = this.getEntry(id);
            if (entry != null) {
                return true;
            }
            Object datasource = autoOpenInfo.get("datasource");
            String title = MapUtils.getMapString(autoOpenInfo, "title", id);
            MdiEntry mdiEntry = this.createEntryByCreationListener(id, datasource, autoOpenInfo);
            if (mdiEntry != null) {
                if (mdiEntry.getTitle().equals("")) {
                    mdiEntry.setTitle(title);
                }
                return true;
            }
            String parentID = MapUtils.getMapString(autoOpenInfo, "parentID", "header.plugins");
            if (viewInfo != null) {
                if (viewInfo.view != null) {
                    entry = this.createEntryFromView(parentID, viewInfo.view, id, datasource, true, false, true);
                } else if (viewInfo.event_listener != null) {
                    entry = this.createEntryFromEventListener(parentID, viewInfo.event_listener, id, true, datasource, null);
                    entry.setTitle(title);
                }
            }
            if (entry != null && datasource == null) {
                final MdiEntry fEntry = entry;
                final String dmHash = MapUtils.getMapString(autoOpenInfo, "dm", null);
                if (dmHash != null) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            HashWrapper hw;
                            GlobalManager gm = core.getGlobalManager();
                            DownloadManager dm = gm.getDownloadManager(hw = new HashWrapper(Base32.decode(dmHash)));
                            if (dm != null) {
                                fEntry.setDatasource(dm);
                            }
                        }
                    });
                } else {
                    final List listHashes = MapUtils.getMapList(autoOpenInfo, "dms", null);
                    if (listHashes != null) {
                        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                            public void azureusCoreRunning(AzureusCore core) {
                                ArrayList<DownloadManager> listDMS = new ArrayList<DownloadManager>(1);
                                GlobalManager gm = core.getGlobalManager();
                                for (Object oDM : listHashes) {
                                    String hash;
                                    DownloadManager dm;
                                    if (oDM instanceof String && (dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash = (String)oDM)))) != null) {
                                        listDMS.add(dm);
                                    }
                                    fEntry.setDatasource(listDMS.toArray(new DownloadManager[0]));
                                }
                            }
                        });
                    }
                }
            }
            return entry != null;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(MdiEntry entry) {
        String id = entry.getId();
        Map<String, MdiEntrySWT> map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.remove(id);
            this.removeChildrenOf(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(String id) {
        if (id == null) {
            return;
        }
        Map<String, MdiEntrySWT> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            for (MdiEntrySWT entry : entriesSWT = this.getEntriesSWT()) {
                if (!id.equals(entry.getParentID())) continue;
                String kid_id = entry.getId();
                this.mapIdToEntry.remove(kid_id);
                this.removeChildrenOf(kid_id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MdiEntry> getChildrenOf(String id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<MdiEntry> list = new ArrayList<MdiEntry>(1);
        Map<String, MdiEntrySWT> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            for (MdiEntrySWT entry : entriesSWT = this.getEntriesSWT()) {
                if (!id.equals(entry.getParentID())) continue;
                list.add(entry);
            }
        }
        return list;
    }

    @Override
    public Object updateLanguage(SWTSkinObject skinObject, Object params) {
        MdiEntry[] entries;
        for (MdiEntry entry : entries = this.getEntries()) {
            if (!(entry instanceof BaseMdiEntry)) continue;
            BaseMdiEntry baseEntry = (BaseMdiEntry)entry;
            baseEntry.updateLanguage();
        }
        return null;
    }

    @Override
    public void setPreferredOrder(String[] preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    @Override
    public String[] getPreferredOrder() {
        return this.preferredOrder == null ? new String[]{} : this.preferredOrder;
    }
}

