/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.BEncodingException;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerStatus {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final String SS = "Scrape.status.";
    private static final String SSErr = "Scrape.status.error.";
    private static final int FAULTY_SCRAPE_RETRY_INTERVAL = 600000;
    private static final int NOHASH_RETRY_INTERVAL = 10800000;
    private static final int GROUP_SCRAPES_MS = 900000;
    private static final int GROUP_SCRAPES_LIMIT = 20;
    private static boolean tcpScrapeEnabled;
    private static boolean udpScrapeEnabled;
    private static boolean udpProbeEnabled;
    private byte autoUDPscrapeEvery = 1;
    private int scrapeCount;
    private static List logged_invalid_urls;
    private static ThreadPool thread_pool;
    private final URL tracker_url;
    private boolean az_tracker;
    private String scrapeURL = null;
    private HashMap hashes;
    private TRTrackerScraperImpl scraper;
    private boolean bSingleHashScrapes = false;
    protected AEMonitor hashes_mon = new AEMonitor("TrackerStatus:hashes");
    private final TrackerChecker checker;
    private final AtomicInteger numActiveScrapes = new AtomicInteger(0);

    public TrackerStatus(TrackerChecker _checker, TRTrackerScraperImpl _scraper, URL _tracker_url) {
        this.checker = _checker;
        this.scraper = _scraper;
        this.tracker_url = _tracker_url;
        this.az_tracker = TRTrackerUtils.isAZTracker(this.tracker_url);
        this.bSingleHashScrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Single Only");
        String trackerUrl = this.tracker_url.toString();
        this.hashes = new HashMap();
        try {
            trackerUrl = trackerUrl.replaceAll(" ", "");
            int position = trackerUrl.lastIndexOf(47);
            if (position >= 0 && trackerUrl.length() >= position + 9 && trackerUrl.substring(position + 1, position + 9).equals("announce")) {
                this.scrapeURL = trackerUrl.substring(0, position + 1) + "scrape" + trackerUrl.substring(position + 9);
            } else if (trackerUrl.toLowerCase().startsWith("udp:")) {
                this.scrapeURL = trackerUrl;
            } else if (position >= 0 && trackerUrl.lastIndexOf(46) < position) {
                this.scrapeURL = trackerUrl + (trackerUrl.endsWith("/") ? "" : "/") + "scrape";
            } else if (!logged_invalid_urls.contains(trackerUrl)) {
                logged_invalid_urls.add(trackerUrl);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected boolean isTrackerScrapeUrlValid() {
        return this.scrapeURL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl getHashData(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
            Object var4_3 = null;
            this.hashes_mon.exit();
            return tRTrackerScraperResponseImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.hashes_mon.exit();
            throw throwable;
        }
    }

    protected void updateSingleHash(HashWrapper hash, boolean force) {
        this.updateSingleHash(hash, force, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSingleHash(HashWrapper hash, boolean force, boolean async) {
        if (this.scrapeURL == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: scrape cancelled.. url null"));
            }
            return;
        }
        try {
            TRTrackerScraperResponseImpl response;
            ArrayList<TRTrackerScraperResponseImpl> responsesToUpdate = new ArrayList<TRTrackerScraperResponseImpl>();
            try {
                this.hashes_mon.enter();
                response = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
                Object var7_7 = null;
                this.hashes_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.hashes_mon.exit();
                throw throwable;
            }
            if (response == null) {
                response = this.addHash(hash);
            }
            long lMainNextScrapeStartTime = response.getNextScrapeStartTime();
            if (!force && lMainNextScrapeStartTime > SystemTime.getCurrentTime()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: scrape cancelled.. not forced and still " + (lMainNextScrapeStartTime - SystemTime.getCurrentTime()) + "ms"));
                }
                return;
            }
            response.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: setting to scraping"));
            }
            responsesToUpdate.add(response);
            if (!this.bSingleHashScrapes) {
                try {
                    this.hashes_mon.enter();
                    Iterator iterHashes = this.hashes.values().iterator();
                    while (iterHashes.hasNext() && responsesToUpdate.size() < 20) {
                        long lTimeDiff;
                        TRTrackerScraperResponseImpl r = (TRTrackerScraperResponseImpl)iterHashes.next();
                        if (r.getHash().equals(hash) || (lTimeDiff = Math.abs(lMainNextScrapeStartTime - r.getNextScrapeStartTime())) > 900000L || r.getStatus() == 3) continue;
                        r.setStatus(3, MessageText.getString("Scrape.status.scraping.queued"));
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TorrentUtils.getDownloadManager(r.getHash()), LOGID, "TrackerStatus: setting to scraping via group scrape"));
                        }
                        responsesToUpdate.add(r);
                    }
                    Object var13_14 = null;
                    this.hashes_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    this.hashes_mon.exit();
                    throw throwable;
                }
            }
            this.runScrapes(responsesToUpdate, force, async);
        }
        catch (Throwable t) {
            Debug.out("updateSingleHash() exception", t);
        }
    }

    protected void runScrapes(final ArrayList responses, final boolean force, boolean async) {
        this.numActiveScrapes.incrementAndGet();
        if (async) {
            thread_pool.run(new AERunnable(){

                public void runSupport() {
                    TrackerStatus.this.runScrapesSupport(responses, force);
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerStatus: queuing '" + this.scrapeURL + "', for " + responses.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes ? "Y" : "N") + ", queue size=" + thread_pool.getQueueSize()));
            }
        } else {
            this.runScrapesSupport(responses, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runScrapesSupport(ArrayList responses, boolean force) {
        try {
            try {
                int iMinRequestInterval;
                Map mapFiles;
                URL redirect_url;
                long scrapeStartTime;
                URL reqUrl;
                byte[] scrape_reply;
                boolean disable_stopped_scrapes;
                boolean original_bSingleHashScrapes;
                block71: {
                    block72: {
                        byte[] failure_reason_bytes;
                        Map mapFlags;
                        boolean this_is_az_tracker;
                        String tracker_network;
                        ArrayList<HashWrapper> hashesForUDP;
                        ArrayList<HashWrapper> hashesInQuery;
                        String flags;
                        String info_hash;
                        HashWrapper one_of_the_hashes;
                        block70: {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "TrackerStatus: scraping '" + this.scrapeURL + "', for " + responses.size() + " of " + this.hashes.size() + " hashes" + ", single_hash_scrapes: " + (this.bSingleHashScrapes ? "Y" : "N")));
                            }
                            original_bSingleHashScrapes = this.bSingleHashScrapes;
                            boolean disable_all_scrapes = !COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
                            disable_stopped_scrapes = !COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
                            scrape_reply = null;
                            one_of_the_hashes = null;
                            TRTrackerScraperResponseImpl one_of_the_responses = null;
                            char first_separator = this.scrapeURL.indexOf(63) == -1 ? (char)'?' : '&';
                            info_hash = "";
                            flags = "";
                            hashesInQuery = new ArrayList<HashWrapper>(responses.size());
                            hashesForUDP = new ArrayList<HashWrapper>();
                            for (int i = 0; i < responses.size(); ++i) {
                                TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                                HashWrapper hash = response.getHash();
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "TrackerStatus: scraping, single_hash_scrapes = " + this.bSingleHashScrapes));
                                }
                                if (!this.scraper.isNetworkEnabled(hash, this.tracker_url)) {
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    response.setStatus(1, MessageText.getString("Scrape.status.networkdisabled"));
                                    this.scraper.scrapeReceived(response);
                                    continue;
                                }
                                if (!force && (disable_all_scrapes || disable_stopped_scrapes && !this.scraper.isTorrentRunning(hash))) {
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                    response.setStatus(1, MessageText.getString("Scrape.status.disabled"));
                                    this.scraper.scrapeReceived(response);
                                    continue;
                                }
                                response.setStatus(3, MessageText.getString("Scrape.status.scraping"));
                                this.scraper.scrapeReceived(response);
                                info_hash = info_hash + (one_of_the_hashes != null ? (char)'&' : first_separator) + "info_hash=";
                                info_hash = info_hash + URLEncoder.encode(new String(hash.getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                                Object[] extensions = this.scraper.getExtensions(hash);
                                if (extensions != null) {
                                    if (extensions[0] != null) {
                                        info_hash = info_hash + (String)extensions[0];
                                    }
                                    flags = flags + (Character)extensions[1];
                                } else {
                                    flags = flags + TRTrackerScraperClientResolver.FL_NONE;
                                }
                                hashesInQuery.add(hash);
                                one_of_the_responses = response;
                                one_of_the_hashes = hash;
                                if (hashesForUDP.size() >= 70) continue;
                                hashesForUDP.add(hash);
                            }
                            if (one_of_the_hashes != null) break block70;
                            Object var41_35 = null;
                            this.numActiveScrapes.decrementAndGet();
                            return;
                        }
                        String request2 = this.scrapeURL + info_hash;
                        if (this.az_tracker) {
                            String port_details = TRTrackerUtils.getPortsForURL();
                            request2 = request2 + port_details;
                            request2 = request2 + "&azsf=" + flags + "&azver=" + 3;
                        }
                        reqUrl = new URL(request2);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Accessing scrape interface using url : " + reqUrl));
                        }
                        ByteArrayOutputStream message = new ByteArrayOutputStream();
                        scrapeStartTime = SystemTime.getCurrentTime();
                        redirect_url = null;
                        String protocol = reqUrl.getProtocol();
                        URL udpScrapeURL = null;
                        boolean auto_probe = false;
                        if (protocol.equalsIgnoreCase("udp")) {
                            if (!udpScrapeEnabled) throw new IOException("UDP Tracker protocol disabled");
                            udpScrapeURL = reqUrl;
                        } else if (protocol.equalsIgnoreCase("http") && !this.az_tracker && this.scrapeCount % this.autoUDPscrapeEvery == 0 && udpProbeEnabled && udpScrapeEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                            udpScrapeURL = new URL(reqUrl.toString().replaceFirst("^http", "udp"));
                            auto_probe = true;
                        }
                        if (udpScrapeURL == null && !this.az_tracker && !tcpScrapeEnabled && (tracker_network = AENetworkClassifier.categoriseAddress(reqUrl.getHost())) == "Public") {
                            throw new IOException("HTTP Tracker protocol disabled");
                        }
                        try {
                            TorrentUtils.setTLSTorrentHash(one_of_the_hashes);
                            if (udpScrapeURL != null) {
                                boolean success = this.scrapeUDP(reqUrl, message, hashesForUDP, !auto_probe);
                                if (!(success && message.size() != 0 || protocol.equalsIgnoreCase("udp"))) {
                                    udpScrapeURL = null;
                                    message.reset();
                                    if (this.autoUDPscrapeEvery < 16) {
                                        this.autoUDPscrapeEvery = (byte)(this.autoUDPscrapeEvery << 1);
                                    }
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp failed, will retry in " + this.autoUDPscrapeEvery + " scrapes"));
                                    }
                                } else if (success && !protocol.equalsIgnoreCase("udp")) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 0, "redirection of http scrape [" + this.scrapeURL + "] to udp successful"));
                                    }
                                    this.autoUDPscrapeEvery = 1;
                                    TRTrackerUtils.setUDPProbeResult(reqUrl, true);
                                }
                            }
                            ++this.scrapeCount;
                            if (udpScrapeURL == null) {
                                redirect_url = this.scrapeHTTP(hashesInQuery, reqUrl, message);
                            }
                            Object var25_49 = null;
                            TorrentUtils.setTLSTorrentHash(null);
                        }
                        catch (Throwable throwable) {
                            Object var25_50 = null;
                            TorrentUtils.setTLSTorrentHash(null);
                            throw throwable;
                        }
                        scrape_reply = message.toByteArray();
                        Map<String, Object> map = BDecoder.decode(scrape_reply);
                        boolean bl = this_is_az_tracker = map.get("aztracker") != null;
                        if (this.az_tracker != this_is_az_tracker) {
                            this.az_tracker = this_is_az_tracker;
                            TRTrackerUtils.setAZTracker(this.tracker_url, this.az_tracker);
                        }
                        mapFiles = (Map)map.get("files");
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Response from scrape interface " + this.scrapeURL + ": " + (mapFiles == null ? "null" : "" + mapFiles.size()) + " returned"));
                        }
                        iMinRequestInterval = 0;
                        if (map != null && (mapFlags = (Map)map.get("flags")) != null) {
                            Long longScrapeValue = (Long)mapFlags.get("min_request_interval");
                            if (longScrapeValue != null) {
                                iMinRequestInterval = longScrapeValue.intValue();
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Received min_request_interval of " + iMinRequestInterval));
                            }
                        }
                        if (mapFiles != null && mapFiles.size() != 0) break block71;
                        byte[] byArray = failure_reason_bytes = map == null ? null : (byte[])map.get("failure reason");
                        if (failure_reason_bytes != null) {
                            long nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 600000 : iMinRequestInterval * 1000);
                            for (int i = 0; i < responses.size(); ++i) {
                                TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                                response.setNextScrapeStartTime(nextScrapeTime);
                                response.setStatus(1, MessageText.getString("Scrape.status.error") + new String(failure_reason_bytes, "UTF8"));
                                this.scraper.scrapeReceived(response);
                            }
                            break block72;
                        }
                        if (responses.size() > 1) {
                            this.bSingleHashScrapes = true;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 1, this.scrapeURL + " doesn't properly support " + "multi-hash scrapes"));
                            }
                            for (int i = 0; i < responses.size(); ++i) {
                                TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                                response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                                this.scraper.scrapeReceived(response);
                            }
                            break block72;
                        }
                        long nextScrapeTime = SystemTime.getCurrentTime() + (long)(iMinRequestInterval == 0 ? 10800000 : iMinRequestInterval * 1000);
                        TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(0);
                        response.setNextScrapeStartTime(nextScrapeTime);
                        response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.nohash"));
                        this.scraper.scrapeReceived(response);
                    }
                    Object var41_36 = null;
                    this.numActiveScrapes.decrementAndGet();
                    return;
                }
                try {
                    if (!this.bSingleHashScrapes && responses.size() > 1 && mapFiles.size() == 1) {
                        this.bSingleHashScrapes = true;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, this.scrapeURL + " only returned " + mapFiles.size() + " hash scrape(s), but we asked for " + responses.size()));
                        }
                    }
                    for (int i = 0; i < responses.size(); ++i) {
                        int completed;
                        TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                        Map scrapeMap = (Map)mapFiles.get(new String(response.getHash().getBytes(), "ISO-8859-1"));
                        if (scrapeMap == null) {
                            if (responses.size() == 1 || mapFiles.size() != 1) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 10800000L);
                                response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.nohash"));
                                this.scraper.scrapeReceived(response);
                                continue;
                            }
                            if (disable_stopped_scrapes && !this.scraper.isTorrentRunning(response.getHash())) continue;
                            response.revertStatus();
                            if (response.getStatus() == 3) {
                                response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                            } else {
                                this.bSingleHashScrapes = true;
                                if (original_bSingleHashScrapes) {
                                    response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                                }
                            }
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        int seeds = ((Long)scrapeMap.get("complete")).intValue();
                        int peers = ((Long)scrapeMap.get("incomplete")).intValue();
                        Long comp2 = (Long)scrapeMap.get("downloaded");
                        int n = completed = comp2 == null ? -1 : comp2.intValue();
                        if (seeds < 0 || peers < 0 || completed < -1) {
                            if (Logger.isEnabled()) {
                                HashWrapper hash = response.getHash();
                                Logger.log(new LogEvent(TorrentUtils.getDownloadManager(hash), LOGID, "Invalid scrape response from '" + reqUrl + "': map = " + scrapeMap));
                            }
                            if (responses.size() > 1 && this.bSingleHashScrapes) {
                                response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid"));
                                this.scraper.scrapeReceived(response);
                                continue;
                            }
                            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                            response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.invalid") + " " + (seeds < 0 ? MessageText.getString("MyTorrentsView.seeds") + " == " + seeds + ". " : "") + (peers < 0 ? MessageText.getString("MyTorrentsView.peers") + " == " + peers + ". " : "") + (completed < 0 ? MessageText.getString("MyTorrentsView.completed") + " == " + completed + ". " : ""));
                            this.scraper.scrapeReceived(response);
                            continue;
                        }
                        int scrapeInterval = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(iMinRequestInterval, seeds);
                        long nextScrapeTime = SystemTime.getCurrentTime() + (long)(scrapeInterval * 1000);
                        response.setNextScrapeStartTime(nextScrapeTime);
                        response.setScrapeStartTime(scrapeStartTime);
                        response.setSeeds(seeds);
                        response.setPeers(peers);
                        response.setCompleted(completed);
                        response.setStatus(2, MessageText.getString("Scrape.status.ok"));
                        this.scraper.scrapeReceived(response);
                        try {
                            String redirect_str;
                            int s_pos;
                            if (responses.size() != 1 || redirect_url == null || (s_pos = (redirect_str = redirect_url.toString()).indexOf("/scrape")) == -1) continue;
                            URL new_url = new URL(redirect_str.substring(0, s_pos) + "/announce" + redirect_str.substring(s_pos + 7));
                            if (!this.scraper.redirectTrackerUrl(response.getHash(), this.tracker_url, new_url)) continue;
                            this.removeHash(response.getHash());
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                catch (NoClassDefFoundError ignoreSSL) {
                    for (int i = 0; i < responses.size(); ++i) {
                        TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, MessageText.getString("Scrape.status.error") + ignoreSSL.getMessage());
                        this.scraper.scrapeReceived(response);
                    }
                }
                catch (FileNotFoundException e) {
                    for (int i = 0; i < responses.size(); ++i) {
                        TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("DownloadManager.error.filenotfound"));
                        this.scraper.scrapeReceived(response);
                    }
                }
                catch (SocketException e) {
                    this.setAllError(e);
                }
                catch (SocketTimeoutException e) {
                    this.setAllError(e);
                }
                catch (UnknownHostException e) {
                    this.setAllError(e);
                }
                catch (PRUDPPacketHandlerException e) {
                    this.setAllError(e);
                }
                catch (BEncodingException e) {
                    this.setAllError(e);
                }
                catch (Exception e) {
                    String error_message = e.getMessage();
                    if (error_message != null) {
                        if (error_message.indexOf(" 500 ") >= 0 || error_message.indexOf(" 400 ") >= 0 || error_message.indexOf(" 403 ") >= 0 || error_message.indexOf(" 404 ") >= 0 || error_message.indexOf(" 501 ") >= 0) {
                            this.setAllError(e);
                            Object var41_37 = null;
                            this.numActiveScrapes.decrementAndGet();
                            return;
                        }
                        if (error_message.indexOf("414") != -1 && !this.bSingleHashScrapes) {
                            this.bSingleHashScrapes = true;
                            Object var41_38 = null;
                            this.numActiveScrapes.decrementAndGet();
                            return;
                        }
                    }
                    String msg = Debug.getNestedExceptionMessage(e);
                    if (scrape_reply != null) {
                        String trace_data = scrape_reply.length <= 150 ? new String(scrape_reply) : new String(scrape_reply, 0, 150) + "...";
                        msg = msg + " [" + trace_data + "]";
                    }
                    for (int i = 0; i < responses.size(); ++i) {
                        TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)responses.get(i);
                        if (Logger.isEnabled()) {
                            HashWrapper hash = response.getHash();
                            Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + msg + " (" + e.getClass() + ")"));
                        }
                        response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
                        response.setStatus(1, MessageText.getString("Scrape.status.error") + msg);
                        this.scraper.scrapeReceived(response);
                    }
                }
                Object var41_39 = null;
                this.numActiveScrapes.decrementAndGet();
            }
            catch (Throwable t) {
                Debug.out("runScrapesSupport failed", t);
                Object var41_40 = null;
                this.numActiveScrapes.decrementAndGet();
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var41_41 = null;
            this.numActiveScrapes.decrementAndGet();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllError(Exception e) {
        Object[] values;
        try {
            this.hashes_mon.enter();
            values = this.hashes.values().toArray();
            Object var4_3 = null;
            this.hashes_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.hashes_mon.exit();
            throw throwable;
        }
        String msg = e.getLocalizedMessage();
        if (e instanceof BEncodingException) {
            msg = msg.indexOf("html") != -1 ? "could not decode response, appears to be a website instead of tracker scrape: " + msg.replace('\n', ' ') : "bencoded response malformed:" + msg;
        }
        for (int i = 0; i < values.length; ++i) {
            TRTrackerScraperResponseImpl response = (TRTrackerScraperResponseImpl)values[i];
            if (Logger.isEnabled()) {
                HashWrapper hash = response.getHash();
                Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 1, "Error from scrape interface " + this.scrapeURL + " : " + msg));
            }
            response.setNextScrapeStartTime(SystemTime.getCurrentTime() + 600000L);
            response.setStatus(1, StringInterner.intern(MessageText.getString("Scrape.status.error") + msg + " (IO)"));
            this.scraper.scrapeReceived(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL scrapeHTTP(List<HashWrapper> hashesInQuery, URL reqUrl, ByteArrayOutputStream message) throws Exception {
        try {
            return this.scrapeHTTPSupport(reqUrl, null, message);
        }
        catch (Exception e) {
            if (AENetworkClassifier.categoriseAddress(reqUrl.getHost()) != "Public") {
                HashMap<String, Object> opts = new HashMap<String, Object>();
                if (hashesInQuery.size() == 1) {
                    opts.put("peer_networks", this.scraper.getEnabledNetworks(hashesInQuery.get(0)));
                } else {
                    String[] current_nets = null;
                    for (HashWrapper hash : hashesInQuery) {
                        String[] nets = this.scraper.getEnabledNetworks(hash);
                        if (nets == null) {
                            nets = new String[]{};
                        }
                        if (current_nets == null) {
                            current_nets = nets;
                            continue;
                        }
                        boolean ok = false;
                        if (nets.length == current_nets.length) {
                            ok = true;
                            for (String net1 : nets) {
                                boolean match = false;
                                for (String net2 : current_nets) {
                                    if (net1 != net2) continue;
                                    match = true;
                                    break;
                                }
                                if (match) continue;
                                ok = false;
                                break;
                            }
                        } else {
                            ok = false;
                        }
                        if (ok) continue;
                        this.bSingleHashScrapes = true;
                        throw new Exception("Mixed networks, forcing single-hash scrapes");
                    }
                    if (current_nets != null) {
                        opts.put("peer_networks", current_nets);
                    }
                }
                AEProxyFactory.PluginProxy proxy = AEProxyFactory.getPluginProxy("Tracker scrape", reqUrl, opts, true);
                if (proxy != null) {
                    boolean ok = false;
                    try {
                        URL result = this.scrapeHTTPSupport(proxy.getURL(), proxy.getProxy(), message);
                        ok = true;
                        URL uRL = result;
                        Object var21_22 = null;
                        proxy.setOK(ok);
                        return uRL;
                    }
                    catch (Throwable f) {
                        try {
                            Object var21_23 = null;
                            proxy.setOK(ok);
                        }
                        catch (Throwable throwable) {
                            Object var21_24 = null;
                            proxy.setOK(ok);
                            throw throwable;
                        }
                    }
                }
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL scrapeHTTPSupport(URL reqUrl, Proxy proxy, ByteArrayOutputStream message) throws IOException {
        block27: {
            i = 0;
            while (i < 2) {
                redirect_url = null;
                TRTrackerUtils.checkForBlacklistedURLs(reqUrl);
                reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
                reqUrl = AddressUtils.adjustURL(reqUrl);
                http_properties = new Properties();
                http_properties.put("URL", reqUrl);
                try {
                    ClientIDManagerImpl.getSingleton().generateHTTPProperties(http_properties);
                }
                catch (ClientIDException e) {
                    throw new IOException(e.getMessage());
                }
                reqUrl = (URL)http_properties.get("URL");
                is = null;
                try {
                    try {
                        con = null;
                        if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
                            ssl_con = proxy == null ? (HttpsURLConnection)reqUrl.openConnection() : (HttpsURLConnection)reqUrl.openConnection(proxy);
                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                public boolean verify(String host, SSLSession session) {
                                    return true;
                                }
                            });
                            con = ssl_con;
                        } else {
                            con = proxy == null ? (HttpURLConnection)reqUrl.openConnection() : (HttpURLConnection)reqUrl.openConnection(proxy);
                        }
                        con.setInstanceFollowRedirects(true);
                        user_agent = (String)http_properties.get("User-Agent");
                        if (user_agent != null) {
                            con.setRequestProperty("User-Agent", user_agent);
                        }
                        con.addRequestProperty("Accept-Encoding", "gzip");
                        con.setRequestProperty("Connection", "close");
                        try {
                            con.connect();
                        }
                        catch (AEProxyFactory.UnknownHostException e) {
                            throw new UnknownHostException(e.getMessage());
                        }
                        is = con.getInputStream();
                        resulting_url_str = con.getURL().toString();
                        if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                            --pos;
                            try {
                                redirect_url = new URL(resulting_url_str.substring(0, pos));
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        v0 = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip") != false;
                        if (gzip) {
                            is = new GZIPInputStream(is);
                        }
                        data = new byte[1024];
                        num_read = 0;
                        try {}
                        catch (Exception e) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Error from scrape interface " + this.scrapeURL + " : " + Debug.getNestedExceptionMessage(e)));
                            }
                            var16_23 = null;
                            var18_5 = null;
                            if (is == null) return var16_23;
                            try {
                                is.close();
                                return var16_23;
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                            return var16_23;
                        }
                        break block27;
                    }
                    catch (SSLException e) {
                        if (i != 0) throw e;
                        if (SESecurityManager.installServerCertificates(reqUrl) == null) throw e;
                        var18_5 = null;
                        if (is != null) {
                            try {}
                            catch (IOException e1) {}
                            is.close();
                        }
                    }
                }
                catch (Throwable var17_24) {
                    var18_5 = null;
                    if (is == null) throw var17_24;
                    ** try [egrp 6[TRYBLOCK] [9 : 577->585)] { 
lbl82:
                    // 1 sources

                    is.close();
                    throw var17_24;
lbl84:
                    // 1 sources

                    catch (IOException e1) {
                        // empty catch block
                    }
                    throw var17_24;
                }
                ++i;
            }
            throw new IOException("Shouldn't get here");
        }
        while (true) {
            if ((len = is.read(data)) > 0) {
                message.write(data, 0, len);
                if ((num_read += len) <= 131072) continue;
                message.reset();
                throw new Exception("Tracker response invalid (too large)");
            }
            if (len != 0) break;
            Thread.sleep(20L);
        }
        var18_5 = null;
        if (is == null) return redirect_url;
        try {}
        catch (IOException e1) {
            return redirect_url;
        }
        is.close();
        return redirect_url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean scrapeUDP(URL reqUrl, ByteArrayOutputStream message, List hashes, boolean do_auth_test) throws Exception {
        block24: {
            block23: {
                block22: {
                    rootMap = new HashMap<String, Object>();
                    files = new ByteEncodedKeyHashMap<T, S>();
                    rootMap.put("files", files);
                    reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
                    auth = null;
                    auth_ok = false;
                    try {
                        block21: {
                            block20: {
                                if (do_auth_test && UrlUtils.queryHasParameter(reqUrl.getQuery(), "auth", false)) {
                                    auth = SESecurityManager.getPasswordAuthentication("UDP Tracker", reqUrl);
                                }
                                port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                                handler = PRUDPPacketHandlerFactory.getHandler(port);
                                destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
                                handler = handler.openSession(destination);
                                try {
                                    failure_reason = null;
                                    for (retry_loop = 0; retry_loop < 1; ++retry_loop) {
                                        try {
                                            connect_request = new PRUDPPacketRequestConnect();
                                            reply = handler.sendAndReceive(auth, connect_request, destination);
                                            if (reply.getAction() != 0) ** GOTO lbl99
                                            connect_reply = (PRUDPPacketReplyConnect)reply;
                                            my_connection = connect_reply.getConnectionId();
                                            scrape_request = new PRUDPPacketRequestScrape(my_connection, hashes);
                                            if ((reply = handler.sendAndReceive(auth, scrape_request, destination)).getAction() != 2) ** GOTO lbl-1000
                                            auth_ok = true;
                                            if (PRUDPPacketTracker.VERSION == 1) {
                                                scrape_reply = (PRUDPPacketReplyScrape)reply;
                                                reply_hashes = scrape_reply.getHashes();
                                                complete = scrape_reply.getComplete();
                                                downloaded = scrape_reply.getDownloaded();
                                                incomplete = scrape_reply.getIncomplete();
                                                for (i = 0; i < reply_hashes.length; ++i) {
                                                    file = new HashMap<String, Long>();
                                                    resp_hash = reply_hashes[i];
                                                    files.put(new String(resp_hash, "ISO-8859-1"), file);
                                                    file.put("complete", new Long(complete[i]));
                                                    file.put("downloaded", new Long(downloaded[i]));
                                                    file.put("incomplete", new Long(incomplete[i]));
                                                }
                                                data = BEncoder.encode(rootMap);
                                                message.write(data);
                                                file = true;
                                            }
                                            ** GOTO lbl-1000
                                        }
                                        catch (PRUDPPacketHandlerException e) {
                                            if (e.getMessage() == null) throw e;
                                            if (e.getMessage().indexOf("timed out") == -1) {
                                                throw e;
                                            }
                                            failure_reason = "Timeout";
                                            continue;
                                        }
                                        var29_41 = null;
                                        break block20;
                                    }
                                    break block21;
                                }
                                catch (Throwable var28_49) {
                                    var29_44 = null;
                                    handler.closeSession();
                                    throw var28_49;
                                }
                            }
                            handler.closeSession();
                            var31_45 = null;
                            if (auth == null) return file;
                            break block22;
lbl-1000:
                            // 1 sources

                            {
                                scrape_reply = (PRUDPPacketReplyScrape2)reply;
                                complete = scrape_reply.getComplete();
                                downloaded = scrape_reply.getDownloaded();
                                incomplete = scrape_reply.getIncomplete();
                                it = hashes.iterator();
                                for (i = 0; it.hasNext() && i < complete.length; ++i) {
                                    hash = (HashWrapper)it.next();
                                    file = new HashMap<String, Long>();
                                    file.put("complete", new Long(complete[i]));
                                    file.put("downloaded", new Long(downloaded[i]));
                                    file.put("incomplete", new Long(incomplete[i]));
                                    files.put(new String(hash.getBytes(), "ISO-8859-1"), file);
                                }
                                data = BEncoder.encode(rootMap);
                                message.write(data);
                                var26_38 = true;
                            }
                            var29_42 = null;
                            handler.closeSession();
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Response from scrape interface " + reqUrl + " : " + failure_reason));
                                }
                                break block21;
lbl99:
                                // 1 sources

                                failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                                if (!Logger.isEnabled()) break block21;
                                Logger.log(new LogEvent(TrackerStatus.LOGID, 3, "Response from scrape interface " + reqUrl + " : " + ((PRUDPPacketReplyError)reply).getMessage()));
                            }
                        }
                        if (failure_reason != null) {
                            rootMap.put("failure reason", failure_reason.getBytes());
                            rootMap.remove("files");
                            data = BEncoder.encode(rootMap);
                            message.write(data);
                        }
                        var29_43 = null;
                        handler.closeSession();
                        var12_13 = false;
                        break block24;
                    }
                    catch (Throwable var30_50) {
                        var31_48 = null;
                        if (auth == null) throw var30_50;
                        SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
                        throw var30_50;
                    }
                }
                SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
                return file;
            }
            var31_46 = null;
            if (auth == null) return var26_38;
            SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
            return var26_38;
        }
        var31_47 = null;
        if (auth == null) return var12_13;
        SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, reqUrl, auth_ok);
        return var12_13;
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(param + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl addHash(HashWrapper hash) {
        TRTrackerScraperResponseImpl response;
        try {
            this.hashes_mon.enter();
            response = (TRTrackerScraperResponseImpl)this.hashes.get(hash);
            if (response == null) {
                response = new TRTrackerBTScraperResponseImpl(this, hash);
                if (this.scrapeURL == null) {
                    response.setStatus(1, MessageText.getString("Scrape.status.error") + MessageText.getString("Scrape.status.error.badURL"));
                } else {
                    response.setStatus(0, MessageText.getString("Scrape.status.initializing"));
                }
                response.setNextScrapeStartTime(this.checker.getNextScrapeCheckOn());
                this.hashes.put(hash, response);
            }
            Object var4_3 = null;
            this.hashes_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.hashes_mon.exit();
            throw throwable;
        }
        this.scraper.scrapeReceived(response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHash(HashWrapper hash) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(hash);
            Object var3_2 = null;
            this.hashes_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.hashes_mon.exit();
            throw throwable;
        }
    }

    protected URL getTrackerURL() {
        return this.tracker_url;
    }

    protected Map getHashes() {
        return this.hashes;
    }

    protected AEMonitor getHashesMonitor() {
        return this.hashes_mon;
    }

    protected void scrapeReceived(TRTrackerScraperResponse response) {
        this.scraper.scrapeReceived(response);
    }

    public boolean getSupportsMultipeHashScrapes() {
        return !this.bSingleHashScrapes;
    }

    protected String getString() {
        return this.tracker_url + ", " + this.scrapeURL + ", multi-scrape=" + !this.bSingleHashScrapes;
    }

    public int getNumActiveScrapes() {
        return this.numActiveScrapes.get();
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Enable TCP", "Server Enable UDP", "Tracker UDP Probe Enable"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                tcpScrapeEnabled = COConfigurationManager.getBooleanParameter("Tracker Client Enable TCP");
                udpScrapeEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
                udpProbeEnabled = COConfigurationManager.getBooleanParameter("Tracker UDP Probe Enable");
            }
        });
        logged_invalid_urls = new ArrayList();
        thread_pool = new ThreadPool("TrackerStatus", 10, true);
    }
}

