/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItemSO;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.PlayUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarActivationListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarEnablerBase;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarItem;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerCore;

public class ToolBarView
extends SkinView
implements UIToolBarManagerCore,
SelectedContentListener {
    private static boolean DEBUG = false;
    private static toolbarButtonListener buttonListener;
    private Map<String, List<String>> mapGroupToItemIDs = new HashMap<String, List<String>>();
    private Map<String, ToolBarItem> items = new LinkedHashMap<String, ToolBarItem>();
    Control lastControl = null;
    private boolean showText = true;
    private SWTSkinObject so2nd;
    private boolean initComplete = false;
    private boolean showCalled = false;
    private ArrayList<ToolBarViewListener> listeners = new ArrayList(1);
    String lastViewID = null;
    private FrequencyLimitedDispatcher refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){
        private AERunnable lock = this;
        private boolean refresh_pending;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSupport() {
            AERunnable aERunnable = this.lock;
            synchronized (aERunnable) {
                if (this.refresh_pending) {
                    return;
                }
                this.refresh_pending = true;
            }
            if (DEBUG) {
                System.out.println("refreshCoreItems via " + Debug.getCompressedStackTrace());
            }
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    AERunnable aERunnable = lock;
                    synchronized (aERunnable) {
                        refresh_pending = false;
                    }
                    ToolBarView.this._refreshCoreToolBarItems();
                }
            });
        }
    }, 250);
    private IdentityHashMap<DownloadManager, DownloadManagerListener> dm_listener_map = new IdentityHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        ToolBarItemSO item;
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (uiClassic && !"global-toolbar".equals(skinObject.getViewID())) {
            skinObject.setVisible(false);
            return null;
        }
        buttonListener = new toolbarButtonListener();
        this.so2nd = this.skin.getSkinObject("toolbar-2nd", skinObject);
        if (this.so2nd == null) {
            skinObject.setVisible(false);
            return null;
        }
        if (uiClassic) {
            this.lastControl = null;
            item = new ToolBarItemSO(this, "open", "image.toolbar.open", "Button.add");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                    return true;
                }
            });
            item.setAlwaysAvailable(true);
            item.setGroupID("classic");
            this.addToolBarItemNoCreate(item);
            item = new ToolBarItemSO(this, "search", "search", "Button.search");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    UIFunctionsManagerSWT.getUIFunctionsSWT().promptForSearch();
                    return true;
                }
            });
            item.setAlwaysAvailable(true);
            item.setGroupID("classic");
            this.addToolBarItemNoCreate(item);
        }
        if (!uiClassic) {
            item = new ToolBarItemSO(this, "play", "image.button.play", "iconBar.play");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                    if (sc != null && sc.length > 0) {
                        if (PlayUtils.canStreamDS(sc[0], sc[0].getFileIndex())) {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", true, false);
                        } else {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", false, true);
                        }
                    }
                    return false;
                }
            });
            this.addToolBarItemNoCreate(item);
        }
        item = new ToolBarItemSO(this, "run", "image.toolbar.run", "iconBar.run");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    return false;
                }
                Object[] dms = SelectedContentManager.getDMSFromSelectedContent();
                if (dms != null) {
                    TorrentUtil.runDataSources(dms);
                    return true;
                }
                return false;
            }
        });
        this.addToolBarItemNoCreate(item);
        if (uiClassic) {
            item = new ToolBarItemSO(this, "top", "image.toolbar.top", "iconBar.top");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType == 0L) {
                        return ToolBarView.this.moveTop();
                    }
                    return false;
                }
            });
            this.addToolBarItemNoCreate(item);
        }
        item = new ToolBarItemSO(this, "up", "image.toolbar.up", "v3.iconBar.up");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType == 0L) {
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        return false;
                    }
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return a.getPosition() - b.getPosition();
                            }
                        });
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableUp(dm)) continue;
                            gm.moveUp(dm);
                        }
                    }
                } else if (activationType == 1L) {
                    return ToolBarView.this.moveTop();
                }
                return false;
            }
        });
        this.addToolBarItemNoCreate(item);
        item = new ToolBarItemSO(this, "down", "image.toolbar.down", "v3.iconBar.down");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType == 0L) {
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        return false;
                    }
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return b.getPosition() - a.getPosition();
                            }
                        });
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableDown(dm)) continue;
                            gm.moveDown(dm);
                        }
                        return true;
                    }
                } else if (activationType == 1L) {
                    return ToolBarView.this.moveBottom();
                }
                return false;
            }
        });
        this.addToolBarItemNoCreate(item);
        if (uiClassic) {
            item = new ToolBarItemSO(this, "bottom", "image.toolbar.bottom", "iconBar.bottom");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    return ToolBarView.this.moveBottom();
                }
            });
            this.addToolBarItemNoCreate(item);
        }
        item = new ToolBarItemSO(this, "startstop", "image.toolbar.startstop.start", "iconBar.startstop");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    return false;
                }
                Object[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.stopOrStartDataSources(currentContent);
                return true;
            }
        });
        this.addToolBarItemNoCreate(item);
        item = new ToolBarItemSO(this, "remove", "image.toolbar.remove", "iconBar.remove");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    return false;
                }
                DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                if (dms != null) {
                    TorrentUtil.removeDownloads(dms, null);
                    return true;
                }
                return false;
            }
        });
        this.addToolBarItemNoCreate(item);
        item = new ToolBarItemSO(this, "modeBig", "image.toolbar.table_large", "v3.iconBar.view.big"){

            public void setSkinButton(SWTSkinButtonUtility btn) {
                super.setSkinButton(btn);
                SWTSkinObject soTitle = ToolBarView.this.skin.getSkinObject("toolbar-item-title", btn.getSkinObject());
                if (soTitle instanceof SWTSkinObjectText) {
                    ((SWTSkinObjectText)soTitle).setStyle(131072);
                }
            }
        };
        item.setGroupID("views");
        this.addToolBarItemNoCreate(item);
        item = new ToolBarItemSO(this, "modeSmall", "image.toolbar.table_normal", "v3.iconBar.view.small"){

            public void setSkinButton(SWTSkinButtonUtility btn) {
                super.setSkinButton(btn);
                SWTSkinObject soTitle = ToolBarView.this.skin.getSkinObject("toolbar-item-title", btn.getSkinObject());
                if (soTitle instanceof SWTSkinObjectText) {
                    ((SWTSkinObjectText)soTitle).setStyle(16384);
                }
            }
        };
        item.setGroupID("views");
        this.addToolBarItemNoCreate(item);
        if (uiClassic) {
            this.bulkSetupItems("classic", "toolbar.area.sitem", this.so2nd);
            this.addNonToolBar("toolbar.area.sitem.left2", this.so2nd);
        }
        this.bulkSetupItems("main", "toolbar.area.sitem", this.so2nd);
        this.addNonToolBar("toolbar.area.sitem.left2", this.so2nd);
        this.bulkSetupItems("views", "toolbar.area.vitem", this.so2nd);
        this.addNonToolBar("toolbar.area.sitem.left2", this.so2nd);
        Utils.execSWTThreadLater(0, new Runnable(){

            public void run() {
                Utils.relayout(ToolBarView.this.so2nd.getControl());
            }
        });
        this.initComplete = true;
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (ToolBarViewListener l : this.listeners) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        return null;
    }

    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
        if (!StringCompareUtils.equals(this.lastViewID, viewID)) {
            this.lastViewID = viewID;
            ToolBarItem[] allToolBarItems = this.getAllSWTToolBarItems();
            for (int i = 0; i < allToolBarItems.length; ++i) {
                ToolBarItem toolBarItem = allToolBarItems[i];
                if (toolBarItem instanceof ToolBarItemSO) {
                    toolBarItem.setState(((ToolBarItemSO)toolBarItem).getDefaultState());
                    continue;
                }
                toolBarItem.setState(0L);
            }
        }
        this.refreshCoreToolBarItems();
        UIFunctionsManagerSWT.getUIFunctionsSWT().refreshTorrentMenu();
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        if (this.showCalled) {
            return null;
        }
        this.showCalled = true;
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        return super.skinObjectShown(skinObject, params);
    }

    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.showCalled = false;
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        return super.skinObjectHidden(skinObject, params);
    }

    public boolean triggerToolBarItem(ToolBarItem item, long activationType, Object datasource) {
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to triggerToolBarItem when toolbar is not visible");
            return false;
        }
        if (this.triggerViewToolBar(item, activationType, datasource)) {
            return true;
        }
        UIToolBarActivationListener defaultActivation = item.getDefaultActivationListener();
        if (defaultActivation != null) {
            return defaultActivation.toolBarItemActivated(item, activationType, datasource);
        }
        if (DEBUG) {
            String viewID = SelectedContentManager.getCurrentySelectedViewID();
            System.out.println("Warning: Fallback of toolbar button " + item.getID() + " via " + viewID + " view");
        }
        return false;
    }

    protected boolean moveBottom() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveEnd(dms);
        }
        return true;
    }

    protected boolean moveTop() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveTop(dms);
        }
        return true;
    }

    public UIToolBarItem getToolBarItem(String itemID) {
        return this.items.get(itemID);
    }

    public ToolBarItemSO getToolBarItemSO(String itemID) {
        return (ToolBarItemSO)this.items.get(itemID);
    }

    public UIToolBarItem[] getAllToolBarItems() {
        return this.items.values().toArray(new ToolBarItem[0]);
    }

    public ToolBarItem[] getAllSWTToolBarItems() {
        return this.items.values().toArray(new ToolBarItem[0]);
    }

    public void refreshCoreToolBarItems() {
        this.refresh_limiter.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _refreshCoreToolBarItems() {
        MultipleDocumentInterfaceSWT mdi;
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to refresh core toolbar items when toolbar is not visible " + this + this.getMainSkinObject());
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null) {
            UIToolBarItem uIToolBarItem;
            boolean bl;
            UIToolBarItem[] allToolBarItems = this.getAllToolBarItems();
            MdiEntrySWT entry = mdi.getCurrentEntrySWT();
            HashMap<String, Long> mapStates = new HashMap<String, Long>();
            if (entry != null) {
                UIToolBarEnablerBase[] enablers;
                for (UIToolBarEnablerBase uIToolBarEnablerBase : enablers = entry.getToolbarEnablers()) {
                    if (uIToolBarEnablerBase instanceof UIPluginViewToolBarListener) {
                        try {
                            ((UIPluginViewToolBarListener)uIToolBarEnablerBase).refreshToolBarItems(mapStates);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        continue;
                    }
                    if (!(uIToolBarEnablerBase instanceof ToolBarEnabler)) continue;
                    HashMap<String, Boolean> oldMapStates = new HashMap<String, Boolean>();
                    ((ToolBarEnabler)uIToolBarEnablerBase).refreshToolBar(oldMapStates);
                    for (Map.Entry e : oldMapStates.entrySet()) {
                        String key = (String)e.getKey();
                        Boolean enable = (Boolean)e.getValue();
                        Long curState = (Long)mapStates.get(key);
                        if (curState == null) {
                            curState = 0L;
                        }
                        if (enable.booleanValue()) {
                            mapStates.put(key, curState | 1L);
                            continue;
                        }
                        mapStates.put(key, curState & 0xFFFFFFFFFFFFFFFEL);
                    }
                }
            }
            Object[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
            IdentityHashMap<DownloadManager, DownloadManagerListener> identityHashMap = this.dm_listener_map;
            synchronized (identityHashMap) {
                IdentityHashMap<DownloadManager, DownloadManagerListener> copy = new IdentityHashMap<DownloadManager, DownloadManagerListener>(this.dm_listener_map);
                for (ISelectedContent iSelectedContent : currentContent) {
                    DownloadManager dm = iSelectedContent.getDownloadManager();
                    if (dm == null) continue;
                    copy.remove(dm);
                    if (this.dm_listener_map.containsKey(dm)) continue;
                    DownloadManagerListener l = new DownloadManagerListener(){

                        public void stateChanged(DownloadManager manager, int state) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void downloadComplete(DownloadManager manager) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void completionChanged(DownloadManager manager, boolean bCompleted) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }
                    };
                    dm.addListener(l, false);
                    this.dm_listener_map.put(dm, l);
                }
                for (Map.Entry entry2 : copy.entrySet()) {
                    DownloadManager dm = (DownloadManager)entry2.getKey();
                    dm.removeListener((DownloadManagerListener)entry2.getValue());
                    this.dm_listener_map.remove(dm);
                }
            }
            if (!mapStates.containsKey("download")) {
                for (ISelectedContent iSelectedContent : currentContent) {
                    if (iSelectedContent.getDownloadManager() != null || iSelectedContent.getDownloadInfo() == null) continue;
                    mapStates.put("download", 1L);
                    break;
                }
            }
            boolean bl2 = currentContent.length == 1;
            boolean can_play = false;
            boolean can_stream = false;
            boolean bl3 = false;
            if (bl2 && !(currentContent[0] instanceof ISelectedVuzeFileContent)) {
                can_play = PlayUtils.canPlayDS(currentContent[0], currentContent[0].getFileIndex());
                can_stream = PlayUtils.canStreamDS(currentContent[0], currentContent[0].getFileIndex());
                if (can_stream) {
                    bl = PlayUtils.isStreamPermitted();
                }
            }
            if (mapStates.containsKey("play")) {
                can_play |= ((Long)mapStates.get("play") & 1L) > 0L;
            }
            if (mapStates.containsKey("stream")) {
                can_stream |= ((Long)mapStates.get("stream") & 1L) > 0L;
            }
            mapStates.put("play", can_play | can_stream ? 1L : 0L);
            UIToolBarItem pitem = this.getToolBarItem("play");
            if (pitem != null) {
                if (can_stream) {
                    pitem.setImageID(bl ? "image.button.stream" : "image.button.pstream");
                    pitem.setTextID(bl ? "iconBar.stream" : "iconBar.pstream");
                } else {
                    pitem.setImageID("image.button.play");
                    pitem.setTextID("iconBar.play");
                }
            }
            if ((uIToolBarItem = this.getToolBarItem("startstop")) != null) {
                boolean shouldStopGroup = TorrentUtil.shouldStopGroup(currentContent);
                uIToolBarItem.setTextID(shouldStopGroup ? "iconBar.stop" : "iconBar.start");
                uIToolBarItem.setImageID("image.toolbar.startstop." + (shouldStopGroup ? "stop" : "start"));
            }
            for (int i = 0; i < allToolBarItems.length; ++i) {
                UIToolBarItem toolBarItem = allToolBarItems[i];
                Long state = (Long)mapStates.get(toolBarItem.getID());
                if (state == null) continue;
                toolBarItem.setState(state);
            }
            if (uIToolBarItem != null && currentContent.length == 0 && !mapStates.containsKey("startstop")) {
                boolean can_start;
                boolean can_stop = mapStates.containsKey("stop") && ((Long)mapStates.get("stop") & 1L) > 0L;
                boolean bl4 = can_start = mapStates.containsKey("start") && ((Long)mapStates.get("start") & 1L) > 0L;
                if (can_start && can_stop) {
                    can_stop = false;
                }
                if (can_start | can_stop) {
                    uIToolBarItem.setTextID(can_stop ? "iconBar.stop" : "iconBar.start");
                    uIToolBarItem.setImageID("image.toolbar.startstop." + (can_stop ? "stop" : "start"));
                    uIToolBarItem.setState(1L);
                } else {
                    uIToolBarItem.setState(0L);
                }
            }
            return;
        }
    }

    private boolean triggerViewToolBar(ToolBarItem item, long activationType, Object datasource) {
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to triggerViewToolBar when toolbar is not visible");
            return false;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            UIToolBarEnablerBase[] enablers;
            MdiEntrySWT entry = mdi.getCurrentEntrySWT();
            for (UIToolBarEnablerBase enabler : enablers = entry.getToolbarEnablers()) {
                if (!(enabler instanceof UIPluginViewToolBarListener ? ((UIPluginViewToolBarListener)enabler).toolBarItemActivated(item, activationType, datasource) : enabler instanceof ToolBarEnabler && activationType == 0L && ((ToolBarEnabler)enabler).toolBarItemActivated(item.getID()))) continue;
                return true;
            }
        }
        return false;
    }

    public UIToolBarItem createToolBarItem(String id) {
        return new ToolBarItemSO(this, id, true);
    }

    public void addToolBarItem(UIToolBarItem item) {
        if (item instanceof ToolBarItemSO) {
            ToolBarItemSO itemSO = (ToolBarItemSO)item;
            itemSO.setGroupID("plugin");
            this.addToolBarItem(itemSO, "toolbar.area.sitem", this.so2nd);
        }
    }

    public void addToolBarItemNoCreate(ToolBarItemSO item) {
        this.addToolBarItem(item, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolBarItem(ToolBarItemSO item, String templatePrefix, SWTSkinObject soMain) {
        item.setDefaultState(item.getState());
        String groupID = item.getGroupID();
        int position = 131072;
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                list = new ArrayList<String>();
                this.mapGroupToItemIDs.put(groupID, list);
                position = 16384;
            } else if (soMain != null && !groupID.equals("big")) {
                SWTSkinObject so;
                int size = list.size();
                String lastID = list.get(size - 1);
                ToolBarItemSO lastItem = this.getToolBarItemSO(lastID);
                if (lastItem != null && (so = this.skin.getSkinObjectByID("toolbar:" + lastItem.getID())) != null) {
                    String configID = so.getConfigID();
                    if (size == 1 && !configID.endsWith(".left") || !configID.equals(templatePrefix)) {
                        this.setupToolBarItem(lastItem, templatePrefix, soMain, size == 1 ? 16384 : 0x1000000);
                    }
                }
                this.addSeperator(soMain);
            }
            list.add(item.getID());
        }
        if (soMain != null) {
            this.setupToolBarItem(item, templatePrefix, soMain, groupID.equals("big") ? 0 : position);
        } else {
            this.items.put(item.getID(), item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkSetupItems(String groupID, String templatePrefix, SWTSkinObject soMain) {
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                ToolBarItemSO item;
                String itemID = list.get(i);
                SWTSkinObject so = this.skin.getSkinObjectByID("toolbar:" + itemID, soMain);
                if (so != null) {
                    so.dispose();
                }
                if ((item = this.getToolBarItemSO(itemID)) == null) continue;
                int position = 0;
                int size = list.size();
                if (size == 1) {
                    position = 4;
                } else if (i == 0) {
                    position = 16384;
                } else if (i == size - 1) {
                    this.addSeperator(soMain);
                    position = 131072;
                } else {
                    this.addSeperator(soMain);
                }
                this.setupToolBarItem(item, templatePrefix, soMain, position);
            }
        }
    }

    private void setupToolBarItem(ToolBarItemSO item, String templatePrefix, SWTSkinObject soMain, int position) {
        SWTSkinObject so;
        FormData fd;
        String templateID = templatePrefix;
        if (position == 131072) {
            templateID = templateID + ".right";
        } else if (position == 16384) {
            templateID = templateID + ".left";
        } else if (position == 4) {
            templateID = templateID + ".lr";
        }
        Control attachToControl = this.lastControl;
        String id = "toolbar:" + item.getID();
        SWTSkinObject oldSO = this.skin.getSkinObjectByID(id, soMain);
        if (oldSO != null) {
            Object layoutData = oldSO.getControl().getLayoutData();
            if (layoutData instanceof FormData) {
                fd = (FormData)layoutData;
                if (fd.left != null) {
                    attachToControl = fd.left.control;
                }
            }
            oldSO.dispose();
        }
        if ((so = this.skin.createSkinObject(id, templateID, soMain)) != null) {
            so.setTooltipID(item.getTooltipID());
            if (this.lastControl != null) {
                fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(attachToControl);
            }
            so.setData("toolbaritem", item);
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(so, "toolbar-item-image");
            btn.setImage(item.getImageID());
            btn.addSelectionListener(buttonListener);
            item.setSkinButton(btn);
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            if (soTitle instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)soTitle).setTextID(item.getTextID());
                item.setSkinTitle((SWTSkinObjectText)soTitle);
            }
            if (this.initComplete) {
                Utils.relayout((Control)so.getControl().getParent());
            }
            this.lastControl = item.getSkinButton().getSkinObject().getControl();
        }
        this.items.put(item.getID(), item);
    }

    private void addSeperator(SWTSkinObject soMain) {
        this.addSeperator("toolbar.area.sitem.sep", soMain);
    }

    private void addSeperator(String id, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar_sep" + Math.random(), id, soMain);
        if (so != null) {
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl, fd.left == null ? 0 : fd.left.offset);
            }
            this.lastControl = so.getControl();
        }
    }

    private void addNonToolBar(String skinid, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar_d" + Math.random(), skinid, soMain);
        if (so != null) {
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl, fd.left == null ? 0 : fd.left.offset);
            }
            this.lastControl = so.getControl();
        }
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        UIToolBarItem[] allToolBarItems = this.getAllToolBarItems();
        for (int i = 0; i < allToolBarItems.length; ++i) {
            UIToolBarItem tbi = allToolBarItems[i];
            SWTSkinObject so = ((ToolBarItemSO)tbi).getSkinButton().getSkinObject();
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            if (soTitle == null) continue;
            soTitle.setVisible(showText);
        }
    }

    public boolean getShowText() {
        return this.showText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            if (this.initComplete) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    public void removeToolBarItem(String id) {
        UIToolBarItem toolBarItem = this.items.remove(id);
        if (toolBarItem instanceof ToolBarItemSO) {
            ToolBarItemSO item = (ToolBarItemSO)toolBarItem;
            item.dispose();
            SWTSkinObject so = this.skin.getSkinObjectByID("toolbar:" + item.getID(), this.soMain);
            if (so != null) {
                so.dispose();
            }
        }
    }

    public static interface ToolBarViewListener {
        public void toolbarViewInitialized(ToolBarView var1);
    }

    private static class toolbarButtonListener
    extends SWTSkinButtonUtility.ButtonListenerAdapter {
        private toolbarButtonListener() {
        }

        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            boolean rightClick = (stateMask & (0x200000 | SWT.MOD4)) > 0;
            item.triggerToolBarItem(rightClick ? 2L : 0L, SelectedContentManager.convertSelectedContentToObject(null));
        }

        public boolean held(SWTSkinButtonUtility buttonUtility) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            buttonUtility.getSkinObject().switchSuffix("", 0, false, true);
            boolean triggerToolBarItemHold = item.triggerToolBarItem(1L, SelectedContentManager.convertSelectedContentToObject(null));
            return triggerToolBarItemHold;
        }
    }
}

