/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.skin.SkinProperties;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.utils.LocationProvider;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageRepository {
    private static final String[] noCacheExtList = new String[]{".exe"};
    private static final boolean forceNoAWT = Constants.isOSX || Constants.isWindows;
    private static LocationProvider flag_provider;
    private static long flag_provider_last_check;
    private static org.eclipse.swt.graphics.Image flag_none;
    private static Object flag_small_key;
    private static Object flag_big_key;
    private static Map<String, org.eclipse.swt.graphics.Image> flag_cache;
    private static Map<String, org.eclipse.swt.graphics.Image> net_images;

    static void addPath(String path, String id) {
        SkinProperties[] skinProperties = ImageLoader.getInstance().getSkinProperties();
        if (skinProperties != null && skinProperties.length > 0) {
            skinProperties[0].addProperty(id, path);
        }
    }

    public static org.eclipse.swt.graphics.Image getImage(String name) {
        return ImageLoader.getInstance().getImage(name);
    }

    public static org.eclipse.swt.graphics.Image getIconFromExtension(File file, String ext, boolean bBig, boolean minifolder) {
        org.eclipse.swt.graphics.Image image = null;
        try {
            Program program;
            Class<?> enhancerClass;
            String key = "osicon" + ext;
            if (bBig) {
                key = key + "-big";
            }
            if (minifolder) {
                key = key + "-fold";
            }
            if (ImageLoader.isRealImage(image = ImageLoader.getInstance().getImage(key))) {
                return image;
            }
            ImageLoader.getInstance().releaseImage(key);
            image = null;
            ImageData imageData = null;
            if (Constants.isWindows) {
                try {
                    enhancerClass = Class.forName("org.gudy.azureus2.ui.swt.win32.Win32UIEnhancer");
                    Method method = enhancerClass.getMethod("getFileIcon", File.class, Boolean.TYPE);
                    image = (org.eclipse.swt.graphics.Image)method.invoke(null, file, bBig);
                    if (image != null) {
                        if (!bBig) {
                            image = ImageRepository.force16height(image);
                        }
                        if (minifolder) {
                            image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                        }
                        ImageLoader.getInstance().addImageNoDipose(key, image);
                        return image;
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            } else if (Utils.isCocoa) {
                try {
                    enhancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CocoaUIEnhancer");
                    Method method = enhancerClass.getMethod("getFileIcon", String.class, Integer.TYPE);
                    image = (org.eclipse.swt.graphics.Image)method.invoke(null, file.getAbsolutePath(), bBig ? 128 : 16);
                    if (image != null) {
                        if (!bBig) {
                            image = ImageRepository.force16height(image);
                        }
                        if (minifolder) {
                            image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                        }
                        ImageLoader.getInstance().addImageNoDipose(key, image);
                        return image;
                    }
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
            if (imageData == null && (program = Program.findProgram((String)ext)) != null) {
                imageData = program.getImageData();
            }
            if (imageData != null) {
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
                if (!bBig) {
                    image = ImageRepository.force16height(image);
                }
                if (minifolder) {
                    image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                }
                ImageLoader.getInstance().addImageNoDipose(key, image);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (image == null) {
            return ImageRepository.getImage(minifolder ? "folder" : "transparent");
        }
        return image;
    }

    private static org.eclipse.swt.graphics.Image minifolderize(String path, org.eclipse.swt.graphics.Image img, boolean big) {
        org.eclipse.swt.graphics.Image imgFolder = ImageRepository.getImage(big ? "folder" : "foldersmall");
        Rectangle folderBounds = imgFolder.getBounds();
        Rectangle dstBounds = img.getBounds();
        org.eclipse.swt.graphics.Image tempImg = Utils.renderTransparency(Display.getCurrent(), img, imgFolder, new Point(dstBounds.width - folderBounds.width, dstBounds.height - folderBounds.height), 204);
        if (tempImg != null) {
            img.dispose();
            img = tempImg;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.eclipse.swt.graphics.Image force16height(org.eclipse.swt.graphics.Image image) {
        if (image == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        if (bounds.height != 16) {
            org.eclipse.swt.graphics.Image newImage = new org.eclipse.swt.graphics.Image(image.getDevice(), 16, 16);
            GC gc = new GC((Drawable)newImage);
            try {
                if (!Constants.isUnix) {
                    gc.setAdvanced(true);
                }
                gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, 16, 16);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
            image.dispose();
            image = newImage;
        }
        return image;
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path, boolean bBig, boolean minifolder) {
        String ext;
        if (path == null) {
            return null;
        }
        File file = null;
        boolean bDeleteFile = false;
        boolean noAWT = forceNoAWT || !bBig;
        try {
            String key;
            file = new File(path);
            if (file.isDirectory()) {
                if (noAWT) {
                    if (Constants.isWindows || Utils.isCocoa) {
                        return ImageRepository.getIconFromExtension(file, "-folder", bBig, false);
                    }
                    return ImageRepository.getImage("folder");
                }
                key = file.getPath();
            } else {
                int idxDot = file.getName().lastIndexOf(".");
                if (idxDot == -1) {
                    if (noAWT) {
                        return ImageRepository.getIconFromExtension(file, "", bBig, false);
                    }
                    key = "?!blank";
                } else {
                    String ext2;
                    key = ext2 = file.getName().substring(idxDot);
                    if (noAWT) {
                        return ImageRepository.getIconFromExtension(file, ext2, bBig, minifolder);
                    }
                    for (int i = 0; i < noCacheExtList.length; ++i) {
                        if (!noCacheExtList[i].equalsIgnoreCase(ext2)) continue;
                        key = file.getPath();
                        break;
                    }
                }
            }
            if (bBig) {
                key = key + "-big";
            }
            if (minifolder) {
                key = key + "-fold";
            }
            key = "osicon" + key;
            org.eclipse.swt.graphics.Image image = ImageLoader.getInstance().getImage(key);
            if (ImageLoader.isRealImage(image)) {
                return image;
            }
            ImageLoader.getInstance().releaseImage(key);
            image = null;
            boolean bl = bDeleteFile = !file.exists();
            if (bDeleteFile) {
                file = File.createTempFile("AZ_", FileUtil.getExtension(path));
            }
            Image awtImage = null;
            try {
                Object sfInstance;
                Method method;
                Class<?> sfClass = Class.forName("sun.awt.shell.ShellFolder");
                if (sfClass != null && file != null && (method = sfClass.getMethod("getShellFolder", File.class)) != null && (sfInstance = method.invoke(null, file)) != null && (method = sfClass.getMethod("getIcon", Boolean.TYPE)) != null) {
                    awtImage = (Image)method.invoke(sfInstance, new Boolean(bBig));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (awtImage != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)awtImage), "png", outStream);
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)inStream);
                if (!bBig) {
                    image = ImageRepository.force16height(image);
                }
                if (minifolder) {
                    image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                }
                ImageLoader.getInstance().addImageNoDipose(key, image);
                if (bDeleteFile && file != null && file.exists()) {
                    file.delete();
                }
                return image;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bDeleteFile && file != null && file.exists()) {
            file.delete();
        }
        if ((ext = FileUtil.getExtension(path)).length() == 0) {
            return ImageRepository.getImage("folder");
        }
        return ImageRepository.getIconFromExtension(file, ext, bBig, minifolder);
    }

    private static LocationProvider getFlagProvider() {
        if (flag_provider != null && flag_provider.isDestroyed()) {
            flag_provider = null;
            flag_provider_last_check = 0L;
        }
        if (flag_provider == null) {
            long now = SystemTime.getMonotonousTime();
            if (flag_provider_last_check == 0L || now - flag_provider_last_check > 20000L) {
                flag_provider_last_check = now;
                List<LocationProvider> providers = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getLocationProviders();
                for (LocationProvider provider2 : providers) {
                    if (!provider2.hasCapabilities(6L)) continue;
                    flag_provider = provider2;
                }
            }
        }
        return flag_provider;
    }

    public static boolean hasCountryFlags(boolean small) {
        if (!Utils.isSWTThread()) {
            Debug.out("Needs to be swt thread...");
            return false;
        }
        LocationProvider fp = ImageRepository.getFlagProvider();
        return fp != null;
    }

    public static org.eclipse.swt.graphics.Image getCountryFlag(Peer peer, boolean small) {
        return ImageRepository.getCountryFlag(PluginCoreUtils.unwrap(peer), small);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.eclipse.swt.graphics.Image getCountryFlag(PEPeer peer, boolean small) {
        org.eclipse.swt.graphics.Image flag;
        block13: {
            LocationProvider fp;
            if (peer == null) {
                return null;
            }
            Object peer_key = small ? flag_small_key : flag_big_key;
            flag = (org.eclipse.swt.graphics.Image)peer.getUserData(peer_key);
            if (flag == null && (fp = ImageRepository.getFlagProvider()) != null) {
                try {
                    String ip = peer.getIp();
                    if (HostNameToIPResolver.isDNSName(ip)) {
                        String cc_key;
                        block14: {
                            InetAddress peer_address = InetAddress.getByName(ip);
                            cc_key = fp.getISO3166CodeForIP(peer_address) + (small ? ".s" : ".l");
                            flag = flag_cache.get(cc_key);
                            if (flag != null) {
                                peer.setUserData(peer_key, flag);
                                break block13;
                            }
                            InputStream is = fp.getCountryFlagForIP(peer_address, small ? 0 : 1);
                            if (is != null) {
                                try {
                                    flag = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), is);
                                    Object var10_13 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var10_14 = null;
                                    is.close();
                                    throw throwable;
                                }
                                is.close();
                                {
                                    break block14;
                                }
                            }
                            flag = flag_none;
                        }
                        flag_cache.put(cc_key, flag);
                        peer.setUserData(peer_key, flag);
                        break block13;
                    }
                    String cat = AENetworkClassifier.categoriseAddress(ip);
                    if (cat != "Public") {
                        final String key = "net_" + cat + (small ? "_s" : "_b");
                        org.eclipse.swt.graphics.Image i = net_images.get(key);
                        if (i == null) {
                            Utils.execSWTThread(new Runnable(){

                                public void run() {
                                    org.eclipse.swt.graphics.Image i = ImageLoader.getInstance().getImage(key);
                                    net_images.put(key, i);
                                }
                            }, false);
                            i = net_images.get(key);
                        }
                        if (ImageLoader.isRealImage(i)) {
                            return i;
                        }
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (flag == flag_none) {
            return null;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.eclipse.swt.graphics.Image getCountryFlag(InetAddress address, boolean small) {
        org.eclipse.swt.graphics.Image flag;
        block8: {
            if (address == null) {
                return null;
            }
            flag = null;
            LocationProvider fp = ImageRepository.getFlagProvider();
            if (fp != null) {
                try {
                    String cc_key;
                    block9: {
                        cc_key = fp.getISO3166CodeForIP(address) + (small ? ".s" : ".l");
                        flag = flag_cache.get(cc_key);
                        if (flag != null) break block8;
                        InputStream is = fp.getCountryFlagForIP(address, small ? 0 : 1);
                        if (is != null) {
                            try {
                                flag = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), is);
                                Object var7_7 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_8 = null;
                                is.close();
                                throw throwable;
                            }
                            is.close();
                            {
                                break block9;
                            }
                        }
                        flag = flag_none;
                    }
                    flag_cache.put(cc_key, flag);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (flag == flag_none) {
            return null;
        }
        return flag;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout(512));
        final Label label = new Label((Composite)shell, 2048);
        final Text text = new Text((Composite)shell, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                org.eclipse.swt.graphics.Image pathIcon = ImageRepository.getPathIcon(text.getText(), false, false);
                label.setImage(pathIcon);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static {
        flag_none = ImageLoader.getNoImage();
        flag_small_key = new Object();
        flag_big_key = new Object();
        flag_cache = new HashMap<String, org.eclipse.swt.graphics.Image>();
        net_images = new HashMap<String, org.eclipse.swt.graphics.Image>();
    }
}

