/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuItemImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBuildUtils {
    public static final PluginMenuController BASIC_MENU_ITEM_CONTROLLER = new MenuItemPluginMenuControllerImpl(null);
    private static AtomicBoolean pub_chat_pending = new AtomicBoolean();
    private static AtomicBoolean anon_chat_pending = new AtomicBoolean();

    public static void addMaintenanceListenerForMenu(final Menu menu, final MenuBuilder builder) {
        if (Constants.isLinux) {
            new org.eclipse.swt.widgets.MenuItem(menu, 2);
        }
        menu.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        org.eclipse.swt.widgets.MenuItem[] items = menu.getItems();
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                        if (Constants.isLinux) {
                            new org.eclipse.swt.widgets.MenuItem(menu, 2);
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                try {
                    org.eclipse.swt.widgets.MenuItem[] items = menu.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].dispose();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.bShown = true;
                builder.buildMenu(menu, e);
                if (Constants.isLinux && menu.getItemCount() == 0) {
                    new org.eclipse.swt.widgets.MenuItem(menu, 2);
                }
            }
        });
    }

    public static void addPluginMenuItems(Composite composite, MenuItem[] items, Menu parent, boolean prev_was_separator, boolean enable_items, PluginMenuController controller) {
        for (int i = 0; i < items.length; ++i) {
            int swt_style;
            final MenuItemImpl az_menuitem = (MenuItemImpl)items[i];
            controller.notifyFillListeners(az_menuitem);
            if (!az_menuitem.isVisible()) continue;
            int style = az_menuitem.getStyle();
            boolean this_is_separator = false;
            boolean is_container = false;
            if (style == 5) {
                swt_style = 64;
                is_container = true;
            } else if (style == 1) {
                swt_style = 8;
            } else if (style == 2) {
                swt_style = 32;
            } else if (style == 3) {
                swt_style = 16;
            } else if (style == 4) {
                this_is_separator = true;
                swt_style = 2;
            } else {
                swt_style = 8;
            }
            if (prev_was_separator && this_is_separator || this_is_separator && i == items.length - 1) continue;
            prev_was_separator = this_is_separator;
            final org.eclipse.swt.widgets.MenuItem menuItem = new org.eclipse.swt.widgets.MenuItem(parent, swt_style);
            if (swt_style == 2) continue;
            if (enable_items && (style == 2 || style == 3)) {
                Boolean selection_value = (Boolean)az_menuitem.getData();
                if (selection_value == null) {
                    throw new RuntimeException("MenuItem with resource name \"" + az_menuitem.getResourceKey() + "\" needs to have a boolean value entered via setData before being used!");
                }
                menuItem.setSelection(selection_value.booleanValue());
            }
            final Listener main_listener = controller.makeSelectionListener(az_menuitem);
            menuItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (!(az_menuitem.getStyle() != 2 && az_menuitem.getStyle() != 3 || menuItem.isDisposed())) {
                        az_menuitem.setData(new Boolean(menuItem.getSelection()));
                    }
                    main_listener.handleEvent(e);
                }
            });
            if (is_container) {
                Menu this_menu = new Menu((Decorations)composite.getShell(), 4);
                menuItem.setMenu(this_menu);
                MenuBuildUtils.addPluginMenuItems(composite, az_menuitem.getItems(), this_menu, false, enable_items, controller);
            }
            String custom_title = az_menuitem.getText();
            menuItem.setText(custom_title);
            Graphic g = az_menuitem.getGraphic();
            if (g instanceof UISWTGraphic) {
                Utils.setMenuItemImage(menuItem, ((UISWTGraphic)g).getImage());
            }
            menuItem.setEnabled(enable_items && az_menuitem.isEnabled());
        }
    }

    public static List<Object> splitLongMenuListIntoHierarchy(List<String> flat_entries, int split_after) {
        ArrayList<Object> result = new ArrayList<Object>();
        int flat_entry_count = flat_entries.size();
        if (flat_entry_count == 0) {
            return result;
        }
        Collections.sort(flat_entries, new Comparator<String>(){
            final Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(String o1, String o2) {
                return this.comp.compare(o1, o2);
            }
        });
        int[] buckets = new int[split_after];
        for (int i = 0; i < flat_entry_count; ++i) {
            int n = i % buckets.length;
            buckets[n] = buckets[n] + 1;
        }
        ArrayList<char[]> edges = new ArrayList<char[]>();
        int pos = 0;
        for (int i = 0; i < buckets.length; ++i) {
            int entries = buckets[i];
            edges.add(flat_entries.get(pos).toCharArray());
            if (entries <= 1) break;
            edges.add(flat_entries.get(pos + entries - 1).toCharArray());
            pos += entries;
        }
        int[] edge_lens = new int[edges.size()];
        for (int i = 0; i < edges.size() - 1; ++i) {
            int j;
            char[] c1 = (char[])edges.get(i);
            char[] c2 = (char[])edges.get(i + 1);
            for (j = 0; j < Math.min(Math.min(c1.length, c2.length), 5) && c1[j] == c2[j]; ++j) {
            }
            edge_lens[i] = Math.min(c1.length, Math.max(edge_lens[i], ++j));
            edge_lens[i + 1] = j;
        }
        int bucket_pos = 0;
        int edge_pos = 0;
        Iterator<String> tag_it = flat_entries.iterator();
        while (tag_it.hasNext()) {
            int bucket_entries = buckets[bucket_pos++];
            ArrayList<String> bucket_tags = new ArrayList<String>();
            for (int i = 0; i < bucket_entries; ++i) {
                bucket_tags.add(tag_it.next());
            }
            if (bucket_entries == 1) {
                result.add(bucket_tags.get(0));
                continue;
            }
            String level_name = new String((char[])edges.get(edge_pos), 0, edge_lens[edge_pos++]) + " - " + new String((char[])edges.get(edge_pos), 0, edge_lens[edge_pos++]);
            result.add(new Object[]{level_name, bucket_tags});
        }
        return result;
    }

    public static void addChatMenu(Menu menu, String menu_resource_key, final String chat_key) {
        if (BuddyPluginUtils.isBetaChatAvailable()) {
            Menu chat_menu = new Menu((Decorations)menu.getShell(), 4);
            org.eclipse.swt.widgets.MenuItem chat_item = new org.eclipse.swt.widgets.MenuItem(menu, 64);
            Messages.setLanguageText((Widget)chat_item, menu_resource_key);
            chat_item.setMenu(chat_menu);
            org.eclipse.swt.widgets.MenuItem chat_pub = new org.eclipse.swt.widgets.MenuItem(chat_menu, 8);
            Messages.setLanguageText((Widget)chat_pub, "label.public");
            chat_pub.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    pub_chat_pending.set(true);
                    BuddyPluginUtils.createBetaChat("Public", chat_key, new Runnable(){

                        public void run() {
                            pub_chat_pending.set(false);
                        }
                    });
                }
            });
            if (pub_chat_pending.get()) {
                chat_pub.setEnabled(false);
                chat_pub.setText(chat_pub.getText() + " (" + MessageText.getString("PeersView.state.pending") + ")");
            }
            if (BuddyPluginUtils.isBetaChatAnonAvailable()) {
                org.eclipse.swt.widgets.MenuItem chat_priv = new org.eclipse.swt.widgets.MenuItem(chat_menu, 8);
                Messages.setLanguageText((Widget)chat_priv, "label.anon");
                chat_priv.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        anon_chat_pending.set(true);
                        BuddyPluginUtils.createBetaChat("I2P", chat_key, new Runnable(){

                            public void run() {
                                anon_chat_pending.set(false);
                            }
                        });
                    }
                });
                if (anon_chat_pending.get()) {
                    chat_priv.setEnabled(false);
                    chat_priv.setText(chat_priv.getText() + " (" + MessageText.getString("PeersView.state.pending") + ")");
                }
            } else {
                org.eclipse.swt.widgets.MenuItem chat_priv = new org.eclipse.swt.widgets.MenuItem(chat_menu, 8);
                chat_priv.setText(MessageText.getString("label.anon") + "...");
                chat_priv.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        Utils.installI2PHelper(null, null, null);
                    }
                });
                if (Utils.isInstallingI2PHelper()) {
                    chat_priv.setEnabled(false);
                    chat_priv.setText(chat_priv.getText() + " (" + MessageText.getString("PeersView.state.pending") + ")");
                }
            }
        }
    }

    public static interface MenuBuilder {
        public void buildMenu(Menu var1, MenuEvent var2);
    }

    public static class MenuItemPluginMenuControllerImpl
    implements PluginMenuController {
        private Object[] objects;

        public MenuItemPluginMenuControllerImpl(Object[] o) {
            this.objects = o;
        }

        public Listener makeSelectionListener(MenuItem menu_item) {
            final MenuItemImpl mii = (MenuItemImpl)menu_item;
            return new Listener(){

                public void handleEvent(Event e) {
                    mii.invokeListenersMulti(MenuItemPluginMenuControllerImpl.this.objects);
                }
            };
        }

        public void notifyFillListeners(MenuItem menu_item) {
            ((MenuItemImpl)menu_item).invokeMenuWillBeShownListeners(this.objects);
        }
    }

    public static interface PluginMenuController {
        public Listener makeSelectionListener(MenuItem var1);

        public void notifyFillListeners(MenuItem var1);
    }
}

