/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RARTOCDecoder;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.ImageViewerWindow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String GOOD_STRING = "(/|,jI~`gy";
    public static final boolean isGTK = SWT.getPlatform().equals("gtk");
    public static final boolean isCarbon = SWT.getPlatform().equals("carbon");
    public static final boolean isCocoa = SWT.getPlatform().equals("cocoa");
    public static final boolean LAST_TABLECOLUMN_EXPANDS = isGTK;
    public static final boolean TABLE_GRIDLINE_IS_ALTERNATING_COLOR = isGTK || isCocoa;
    public static int BUTTON_MARGIN;
    public static int BUTTON_MINWIDTH;
    private static final boolean DEBUG_SWTEXEC;
    private static ArrayList<Runnable> queue;
    private static AEDiagnosticsLogger diag_logger;
    private static Image[] shellIcons;
    private static Image icon128;
    private static final String[] shellIconNames;
    public static final Rectangle EMPTY_RECT;
    private static int userMode;
    private static boolean isAZ2;
    private static Set<String> pending_ext_urls;
    private static AsyncDispatcher ext_url_dispatcher;
    private static boolean i2p_install_active_for_url;
    private static boolean browser_install_active_for_url;
    private static boolean i2p_installing;
    private static boolean tb_installing;
    private static boolean gotBrowserStyle;
    private static int browserStyle;
    private static Map truncatedTextCache;
    private static ThreadPool tp;
    private static Set<String> qv_exts;
    private static int qv_max_bytes;
    private static Set<DiskManagerFileInfo> quick_view_active;
    private static TimerEventPeriodic quick_view_event;

    public static boolean isAZ2UI() {
        return isAZ2;
    }

    public static void disposeComposite(Composite composite, boolean disposeSelf) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controls = composite.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            Control control = controls[i];
            if (control == null || control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.disposeComposite((Composite)control, true);
            }
            try {
                control.dispose();
                continue;
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
        if (!composite.isDisposed() && disposeSelf) {
            try {
                composite.dispose();
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void disposeComposite(Composite composite) {
        Utils.disposeComposite(composite, true);
    }

    public static void disposeSWTObjects(List disposeList) {
        Utils.disposeSWTObjects(disposeList.toArray());
        disposeList.clear();
    }

    public static void disposeSWTObjects(Object[] disposeList) {
        if (disposeList == null) {
            return;
        }
        for (int i = 0; i < disposeList.length; ++i) {
            try {
                Object o = disposeList[i];
                if (o instanceof Widget && !((Widget)o).isDisposed()) {
                    ((Widget)o).dispose();
                    continue;
                }
                if (!(o instanceof Resource) || ((Resource)o).isDisposed()) continue;
                ((Resource)o).dispose();
                continue;
            }
            catch (Exception e) {
                Debug.out("Warning: Disposal failed " + Debug.getCompressedStackTrace(e, 0, -1, true));
            }
        }
    }

    public static void setTextLinkFromClipboard(Shell shell, Text url, boolean accept_magnets, boolean default_magnet) {
        String link = Utils.getLinkFromClipboard(shell.getDisplay(), accept_magnets, default_magnet);
        if (link != null) {
            url.setText(link);
        }
    }

    public static String getLinkFromClipboard(Display display, boolean accept_magnets, boolean default_magnet) {
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents((Transfer)transfer);
        String text = UrlUtils.parseTextForURL(data, accept_magnets);
        if (text == null) {
            return default_magnet ? "magnet:" : "http://";
        }
        return text;
    }

    public static void centreWindow(Shell shell) {
        Utils.centreWindow(shell, true);
    }

    public static void centreWindow(Shell shell, boolean shrink_if_needed) {
        Rectangle displayArea;
        try {
            displayArea = shell.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayArea = shell.getDisplay().getClientArea();
        }
        Rectangle centerInArea = shell.getParent() != null ? shell.getParent().getBounds() : displayArea;
        Rectangle shellRect = shell.getBounds();
        if (shrink_if_needed) {
            if (shellRect.height > displayArea.height) {
                shellRect.height = displayArea.height;
            }
            if (shellRect.width > displayArea.width - 50) {
                shellRect.width = displayArea.width;
            }
        }
        shellRect.x = centerInArea.x + (centerInArea.width - shellRect.width) / 2;
        shellRect.y = centerInArea.y + (centerInArea.height - shellRect.height) / 2;
        shell.setBounds(shellRect);
    }

    public static void centerWindowRelativeTo(Shell window, Control control) {
        if (control == null || control.isDisposed() || window == null || window.isDisposed()) {
            return;
        }
        Rectangle bounds = control.getBounds();
        Point shellSize = window.getSize();
        window.setLocation(bounds.x + bounds.width / 2 - shellSize.x / 2, bounds.y + bounds.height / 2 - shellSize.y / 2);
    }

    public static RGB showColorDialog(Composite parent, RGB existing) {
        Shell parent_shell = parent.getShell();
        return Utils.showColorDialog(parent_shell, existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RGB showColorDialog(Shell parent_shell, RGB existing) {
        RGB rGB;
        Shell centerShell = new Shell(parent_shell, 8);
        try {
            RGB rgb;
            Rectangle displayArea;
            try {
                displayArea = parent_shell.getMonitor().getClientArea();
            }
            catch (NoSuchMethodError e) {
                displayArea = parent_shell.getDisplay().getClientArea();
            }
            int x = displayArea.x + displayArea.width / 2 - 120;
            int y = displayArea.y + displayArea.height / 2 - 170;
            centerShell.setLocation(x, y);
            ColorDialog cd = new ColorDialog(centerShell);
            cd.setRGB(existing);
            rGB = rgb = cd.open();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            centerShell.dispose();
            throw throwable;
        }
        centerShell.dispose();
        return rGB;
    }

    public static void createTorrentDropTarget(Composite composite, boolean bAllowShareAdd) {
        try {
            Utils.createDropTarget(composite, bAllowShareAdd, null);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void createURLDropTarget(Composite composite, Text url) {
        try {
            Utils.createDropTarget(composite, false, url);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url, DropTargetListener dropTargetListener) {
        Transfer[] transferList = new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)composite, 31);
        dropTarget.setTransfer(transferList);
        dropTarget.addDropListener(dropTargetListener);
        if (Constants.isWindows) {
            return;
        }
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.createDropTarget((Composite)control, bAllowShareAdd, url, dropTargetListener);
                continue;
            }
            DropTarget dropTarget2 = new DropTarget(control, 31);
            dropTarget2.setTransfer(transferList);
            dropTarget2.addDropListener(dropTargetListener);
        }
    }

    private static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url) {
        URLDropTarget target = new URLDropTarget(url, bAllowShareAdd);
        Utils.createDropTarget(composite, bAllowShareAdd, url, (DropTargetListener)target);
    }

    public static void alternateRowBackground(TableItem item) {
        Utils.alternateRowBackground(TableOrTreeUtils.getEventItem((Widget)item));
    }

    public static void alternateRowBackground(TableItemOrTreeItem item) {
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!item.getParent().getLinesVisible()) {
                item.getParent().setLinesVisible(true);
            }
            return;
        }
        if (item == null || item.isDisposed()) {
            return;
        }
        Color[] colors = new Color[]{item.getDisplay().getSystemColor(25), Colors.colorAltRow};
        Color newColor = colors[item.getParent().indexOf(item) % colors.length];
        if (!item.getBackground().equals((Object)newColor)) {
            item.setBackground(newColor);
        }
    }

    public static void alternateTableBackground(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!table.getLinesVisible()) {
                table.setLinesVisible(true);
            }
            return;
        }
        int iTopIndex = table.getTopIndex();
        if (iTopIndex < 0 || iTopIndex == 0 && table.getItemCount() == 0) {
            return;
        }
        TableOrTreeSWT tt = TableOrTreeUtils.getTableOrTreeSWT((Widget)table);
        int iBottomIndex = Utils.getTableBottomIndex(tt, iTopIndex);
        Color[] colors = new Color[]{table.getDisplay().getSystemColor(25), Colors.colorAltRow};
        int iFixedIndex = iTopIndex;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableItemOrTreeItem row = tt.getItem(i);
            if (row.isDisposed()) continue;
            Color newColor = colors[iFixedIndex % colors.length];
            ++iFixedIndex;
            if (row.getBackground().equals((Object)newColor)) continue;
            row.setBackground(newColor);
        }
    }

    public static void setMenuItemImage(MenuItem item, final String repoKey) {
        if (Constants.isOSX || repoKey == null) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        item.setImage(imageLoader.getImage(repoKey));
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                imageLoader.releaseImage(repoKey);
            }
        });
    }

    public static void setMenuItemImage(MenuItem item, Image image) {
        if (!Constants.isOSX) {
            item.setImage(image);
        }
    }

    public static void setShellIcon(Shell shell) {
        if (Constants.isOSX) {
            return;
        }
        try {
            if (shellIcons == null) {
                ArrayList<Image> listShellIcons = new ArrayList<Image>(shellIconNames.length);
                ImageLoader imageLoader = ImageLoader.getInstance();
                for (int i = 0; i < shellIconNames.length; ++i) {
                    Image image = imageLoader.getImage(shellIconNames[i]);
                    if (!ImageLoader.isRealImage(image)) continue;
                    listShellIcons.add(image);
                }
                shellIcons = listShellIcons.toArray(new Image[listShellIcons.size()]);
            }
            shell.setImages(shellIcons);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static Display getDisplay() {
        Display display;
        block6: {
            SWTThread swt = SWTThread.getInstance();
            if (swt == null) {
                try {
                    display = Display.getDefault();
                    if (display == null) {
                        System.err.println("SWT Thread not started yet!");
                        return null;
                    }
                    break block6;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            if (swt.isTerminated()) {
                return null;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    public static boolean execSWTThread(Runnable code, boolean async) {
        return Utils.execSWTThread(code, async ? -1 : -2);
    }

    public static boolean execSWTThreadLater(int msLater, Runnable code) {
        return Utils.execSWTThread(code, msLater);
    }

    public static boolean isSWTThread() {
        Display display = Utils.getDisplay();
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    private static boolean execSWTThread(final Runnable code, final int msLater) {
        boolean isSWTThread;
        final Display display = Utils.getDisplay();
        if (display == null || code == null) {
            return false;
        }
        boolean bl = isSWTThread = display.getThread() == Thread.currentThread();
        if (msLater < 0 && isSWTThread) {
            if (queue == null) {
                code.run();
            } else {
                long lStartTimeRun = SystemTime.getCurrentTime();
                code.run();
                long wait = SystemTime.getCurrentTime() - lStartTimeRun;
                if (wait > 700L) {
                    diag_logger.log(SystemTime.getCurrentTime() + "] took " + wait + "ms to run " + Debug.getCompressedStackTrace(-5));
                }
            }
        } else if (msLater >= -1) {
            try {
                if (queue == null) {
                    if (msLater <= 0) {
                        display.asyncExec(code);
                    }
                    if (isSWTThread) {
                        display.timerExec(msLater, code);
                    }
                    SimpleTimer.addEvent("execSWTThreadLater", SystemTime.getOffsetTime(msLater), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            if (!display.isDisposed()) {
                                display.asyncExec(code);
                            }
                        }
                    });
                }
                queue.add(code);
                diag_logger.log(SystemTime.getCurrentTime() + "] + Q. size= " + queue.size() + "; add " + code + " via " + Debug.getCompressedStackTrace(-5));
                final long lStart = SystemTime.getCurrentTime();
                final Display fDisplay = display;
                final AERunnable runnableWrapper = new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void runSupport() {
                        long wait = SystemTime.getCurrentTime() - lStart - (long)msLater;
                        if (wait > 700L) {
                            diag_logger.log(SystemTime.getCurrentTime() + "] took " + wait + "ms before SWT ran async code " + code);
                        }
                        long lStartTimeRun = SystemTime.getCurrentTime();
                        try {
                            if (fDisplay.isDisposed()) {
                                Debug.out("Display disposed while trying to execSWTThread " + code);
                                try {
                                    code.run();
                                }
                                catch (SWTException e) {
                                    Debug.out("Error while execSWTThread w/disposed Display", e);
                                }
                            } else {
                                code.run();
                            }
                            Object var7_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_5 = null;
                            long runTIme = SystemTime.getCurrentTime() - lStartTimeRun;
                            if (runTIme > 500L) {
                                diag_logger.log(SystemTime.getCurrentTime() + "] took " + runTIme + "ms to run " + code);
                            }
                            queue.remove(code);
                            if (runTIme > 10L) {
                                diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms " + code);
                                throw throwable;
                            } else {
                                diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms");
                            }
                            throw throwable;
                        }
                        long runTIme = SystemTime.getCurrentTime() - lStartTimeRun;
                        if (runTIme > 500L) {
                            diag_logger.log(SystemTime.getCurrentTime() + "] took " + runTIme + "ms to run " + code);
                        }
                        queue.remove(code);
                        if (runTIme > 10L) {
                            diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms " + code);
                            return;
                        }
                        diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms");
                    }
                };
                if (msLater <= 0) {
                    display.asyncExec((Runnable)runnableWrapper);
                }
                if (isSWTThread) {
                    display.timerExec(msLater, (Runnable)runnableWrapper);
                }
                SimpleTimer.addEvent("execSWTThreadLater", SystemTime.getOffsetTime(msLater), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        if (!display.isDisposed()) {
                            display.asyncExec((Runnable)runnableWrapper);
                        }
                    }
                });
            }
            catch (NullPointerException e) {
                return false;
            }
        } else {
            display.syncExec(code);
        }
        return true;
    }

    public static boolean execSWTThread(Runnable code) {
        return Utils.execSWTThread(code, -1);
    }

    public static boolean isThisThreadSWT() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            // empty if block
        }
        Display display2 = display = swt == null ? Display.getCurrent() : swt.getDisplay();
        if (display == null) {
            return false;
        }
        try {
            display.getWarnings();
        }
        catch (SWTException e) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static int getTableBottomIndex(TableOrTreeSWT table, int iTopIndex) {
        Object lastBottomIndex = table.getData("lastBottomIndex");
        if (lastBottomIndex instanceof Number) {
            return ((Number)lastBottomIndex).intValue();
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return -1;
        }
        int xPos = table.getColumn(0).getWidth() - 1;
        if (columnCount > 1) {
            xPos += table.getColumn(1).getWidth();
        }
        Rectangle clientArea = table.getClientArea();
        TableItemOrTreeItem bottomItem = table.getItem(new Point(xPos, clientArea.y + clientArea.height - 2));
        if (bottomItem != null) {
            while (bottomItem.getParentItem() != null) {
                bottomItem = bottomItem.getParentItem();
            }
            return table.indexOf(bottomItem);
        }
        return table.getItemCount() - 1;
    }

    public static List<TableItemOrTreeItem> getVisibleTableItems(TableOrTreeSWT table) {
        if (table.getColumnCount() < 2) {
            return Collections.emptyList();
        }
        int xPos = table.getColumn(0).getWidth() + table.getColumn(1).getWidth() - 1;
        Rectangle clientArea = table.getClientArea();
        TableItemOrTreeItem bottomItem = table.getItem(new Point(xPos, clientArea.y + clientArea.height - 1));
        if (bottomItem == null && clientArea.height + clientArea.y <= 0) {
            return Collections.emptyList();
        }
        TableItemOrTreeItem curItem = table.getTopItem();
        if (curItem == null) {
            if (table.getItemCount() > 0) {
                curItem = table.getItem(0);
            } else {
                return Collections.emptyList();
            }
        }
        ArrayList<TableItemOrTreeItem> items = new ArrayList<TableItemOrTreeItem>();
        int i = table.indexOf(curItem);
        int count = table.getItemCount();
        while (true) {
            if (curItem == bottomItem) {
                items.add(curItem);
                break;
            }
            if (curItem == null) break;
            items.add(curItem);
            if (curItem.getExpanded() && curItem.getItemCount() > 0 && !Utils.addItemsToList(items, curItem.getItems(), bottomItem) || ++i >= count) break;
            curItem = table.getItem(i);
        }
        return items;
    }

    private static boolean addItemsToList(List<TableItemOrTreeItem> list, TableItemOrTreeItem[] items, TableItemOrTreeItem stopOnItem) {
        for (TableItemOrTreeItem item : items) {
            list.add(item);
            if (item != stopOnItem) continue;
            return false;
        }
        return true;
    }

    public static void launch(final DiskManagerFileInfo fileInfo2) {
        LaunchManager launch_manager = LaunchManager.getManager();
        LaunchManager.LaunchTarget target = launch_manager.createTarget(fileInfo2);
        launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

            public void actionAllowed() {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        Utils.launch(fileInfo2.getFile(true).toString());
                    }
                });
            }

            public void actionDenied(Throwable reason) {
                Debug.out("Launch request denied", reason);
            }
        });
    }

    public static void launch(URL url) {
        Utils.launch(url.toExternalForm());
    }

    public static void launch(String sFile) {
        Utils.launch(sFile, false);
    }

    public static void launch(String sFileOriginal, boolean sync) {
        boolean launched;
        String lc_sFile;
        String exe;
        PlatformManager mgr;
        String sFileModified = sFileOriginal;
        if (sFileModified == null || sFileModified.trim().length() == 0) {
            return;
        }
        if (!Constants.isWindows && new File(sFileModified).isDirectory() && (mgr = PlatformManagerFactory.getPlatformManager()).hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(sFileModified);
                return;
            }
            catch (PlatformManagerException e) {
                // empty catch block
            }
        }
        if ((exe = Utils.getExplicitLauncher(sFileModified = sFileModified.replaceAll("&vzemb=1", ""))) != null) {
            File file = new File(sFileModified);
            try {
                System.out.println("Launching " + sFileModified + " with " + exe);
                if (Constants.isWindows) {
                    try {
                        PlatformManagerFactory.getPlatformManager().createProcess(exe + " \"" + sFileModified + "\"", false);
                        return;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                ProcessBuilder pb = GeneralUtils.createProcessBuilder(file.getParentFile(), new String[]{exe, file.getName()}, null);
                pb.start();
                return;
            }
            catch (Throwable e) {
                Debug.out("Launch failed", e);
            }
        }
        if ((lc_sFile = sFileModified.toLowerCase(Locale.US)).startsWith("http:") || lc_sFile.startsWith("https:")) {
            String net_type = "Public";
            boolean use_plugins = COConfigurationManager.getBooleanParameter("browser.external.non.pub", true);
            try {
                net_type = AENetworkClassifier.categoriseAddress(new URL(sFileModified).getHost());
            }
            catch (Throwable e) {
                // empty catch block
            }
            String eb_choice = COConfigurationManager.getStringParameter("browser.external.id", "system");
            if (net_type != "Public" && use_plugins) {
                eb_choice = "plugin";
            }
            if (!eb_choice.equals("system")) {
                if (eb_choice.equals("manual")) {
                    String browser_exe = COConfigurationManager.getStringParameter("browser.external.prog", "");
                    File bf = new File(browser_exe);
                    if (bf.exists()) {
                        try {
                            Process proc = Runtime.getRuntime().exec(new String[]{bf.getAbsolutePath(), sFileModified});
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    } else {
                        Debug.out("Can't launch '" + sFileModified + "' as manual browser '" + bf + " ' doesn't exist");
                    }
                    return;
                }
                Utils.handlePluginLaunch(eb_choice, net_type, use_plugins, sFileOriginal, sFileModified, sync);
                return;
            }
        }
        if (!(launched = Program.launch((String)sFileModified)) && Constants.isUnix) {
            sFileModified = sFileModified.replaceAll(" ", "\\ ");
            if (!Program.launch((String)("xdg-open " + sFileModified)) && !Program.launch((String)("htmlview " + sFileModified))) {
                Debug.out("Failed to launch '" + sFileModified + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlePluginLaunch(String eb_choice, String net_type, boolean use_plugins, final String sFileOriginal, final String sFileModified, final boolean sync) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        if (net_type == "I2P" && pm.getPluginInterfaceByID("azneti2phelper") == null) {
            boolean try_it;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                try_it = !i2p_install_active_for_url;
                i2p_install_active_for_url = true;
            }
            if (try_it) {
                ext_url_dispatcher.dispatch(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void runSupport() {
                        boolean installing = false;
                        try {
                            final boolean[] install_outcome = new boolean[]{false};
                            installing = Utils.installI2PHelper("azneti2phelper.install", install_outcome, new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        if (install_outcome[0]) {
                                            Utils.launch(sFileOriginal, sync);
                                        }
                                        Object var2_1 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var2_2 = null;
                                        Set set = pending_ext_urls;
                                        synchronized (set) {
                                            i2p_install_active_for_url = false;
                                        }
                                        throw throwable;
                                    }
                                    Set set = pending_ext_urls;
                                    synchronized (set) {
                                        i2p_install_active_for_url = false;
                                    }
                                }
                            });
                            Object var4_3 = null;
                            if (installing) return;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            if (installing) throw throwable;
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                i2p_install_active_for_url = false;
                                throw throwable;
                            }
                        }
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            i2p_install_active_for_url = false;
                            return;
                        }
                    }
                });
            } else {
                Debug.out("I2P installation already active");
            }
            return;
        }
        List<PluginInterface> pis = pm.getPluginsWithMethod("launchURL", new Class[]{URL.class, Boolean.TYPE, Runnable.class});
        boolean found = false;
        for (final PluginInterface pi : pis) {
            String id = "plugin:" + pi.getPluginID();
            if (!eb_choice.equals("plugin") && !id.equals(eb_choice)) continue;
            found = true;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                if (pending_ext_urls.contains(sFileModified)) {
                    Debug.outNoStack("Already queued browser request for '" + sFileModified + "' - ignoring");
                    return;
                }
                pending_ext_urls.add(sFileModified);
            }
            AERunnable launch = new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void runSupport() {
                    try {
                        block8: {
                            try {
                                final AESemaphore sem = new AESemaphore("wait");
                                pi.getIPC().invoke("launchURL", new Object[]{new URL(sFileModified), false, new Runnable(){

                                    public void run() {
                                        sem.release();
                                    }
                                }});
                                if (sem.reserve(30000L)) break block8;
                                Debug.out("Timeout waiting for external url launch");
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Object var3_4 = null;
                                Set set2 = pending_ext_urls;
                                synchronized (set2) {
                                    pending_ext_urls.remove(sFileModified);
                                    return;
                                }
                            }
                        }
                        Object var3_3 = null;
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            pending_ext_urls.remove(sFileModified);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            pending_ext_urls.remove(sFileModified);
                            throw throwable;
                        }
                    }
                }
            };
            if (sync) {
                launch.runSupport();
                continue;
            }
            ext_url_dispatcher.dispatch(launch);
        }
        if (!found && net_type != "Public" && use_plugins && (Constants.isWindows || Constants.isOSX)) {
            boolean try_it;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                try_it = !browser_install_active_for_url;
                browser_install_active_for_url = true;
            }
            if (try_it) {
                ext_url_dispatcher.dispatch(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void runSupport() {
                        boolean installing = false;
                        try {
                            try {
                                final boolean[] install_outcome = new boolean[]{false};
                                installing = Utils.installTorBrowser("aznettorbrowser.install", install_outcome, new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            if (install_outcome[0]) {
                                                Utils.launch(sFileOriginal, sync);
                                            }
                                            Object var2_1 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var2_2 = null;
                                            Set set = pending_ext_urls;
                                            synchronized (set) {
                                                browser_install_active_for_url = false;
                                            }
                                            throw throwable;
                                        }
                                        Set set = pending_ext_urls;
                                        synchronized (set) {
                                            browser_install_active_for_url = false;
                                        }
                                    }
                                });
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Object var4_5 = null;
                                if (installing) return;
                                Set set2 = pending_ext_urls;
                                synchronized (set2) {
                                    browser_install_active_for_url = false;
                                    return;
                                }
                            }
                            Object var4_4 = null;
                            if (installing) return;
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            if (installing) throw throwable;
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                browser_install_active_for_url = false;
                                throw throwable;
                            }
                        }
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            browser_install_active_for_url = false;
                            return;
                        }
                    }
                });
            } else {
                Debug.out("Browser installation already active");
            }
            return;
        }
        if (!eb_choice.equals("plugin")) {
            Debug.out("Failed to find external URL launcher plugin with id '" + eb_choice + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingI2PHelper() {
        Set<String> set = pending_ext_urls;
        synchronized (set) {
            return i2p_installing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installI2PHelper(String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean bl;
        block20: {
            boolean install;
            UIFunctions uif;
            boolean installing;
            block18: {
                boolean bl2;
                block19: {
                    Set<String> set;
                    Set<String> set2 = pending_ext_urls;
                    synchronized (set2) {
                        if (i2p_installing) {
                            Debug.out("I2P Helper already installing");
                            return false;
                        }
                        i2p_installing = true;
                    }
                    installing = false;
                    try {
                        uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) break block18;
                        Debug.out("UIFunctions unavailable - can't install plugin");
                        bl2 = false;
                        Object var11_9 = null;
                        if (installing) break block19;
                        set = pending_ext_urls;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        if (!installing) {
                            Set<String> set3 = pending_ext_urls;
                            synchronized (set3) {
                                i2p_installing = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (set) {
                        i2p_installing = false;
                    }
                }
                return bl2;
            }
            String title = MessageText.getString("azneti2phelper.install");
            String text = MessageText.getString("azneti2phelper.install.text");
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            if (remember_id != null) {
                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            }
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean bl3 = install = prompter.waitUntilClosed() == 0;
            if (install) {
                installing = true;
                uif.installPlugin("azneti2phelper", "azneti2phelper.install", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionComplete(Object result) {
                        try {
                            if (callback != null) {
                                if (result instanceof Boolean) {
                                    install_outcome[0] = (Boolean)result;
                                }
                                callback.run();
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                i2p_installing = false;
                            }
                            throw throwable;
                        }
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            i2p_installing = false;
                        }
                    }
                });
            } else {
                Debug.out("I2P Helper install declined (either user reply or auto-remembered)");
            }
            bl = install;
            Object var11_10 = null;
            if (installing) break block20;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                i2p_installing = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingTorBrowser() {
        Set<String> set = pending_ext_urls;
        synchronized (set) {
            return tb_installing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installTorBrowser(String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean bl;
        block20: {
            boolean install;
            UIFunctions uif;
            boolean installing;
            block18: {
                boolean bl2;
                block19: {
                    Set<String> set;
                    Set<String> set2 = pending_ext_urls;
                    synchronized (set2) {
                        if (tb_installing) {
                            Debug.out("Tor Browser already installing");
                            return false;
                        }
                        tb_installing = true;
                    }
                    installing = false;
                    try {
                        uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) break block18;
                        Debug.out("UIFunctions unavailable - can't install plugin");
                        bl2 = false;
                        Object var11_9 = null;
                        if (installing) break block19;
                        set = pending_ext_urls;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        if (!installing) {
                            Set<String> set3 = pending_ext_urls;
                            synchronized (set3) {
                                tb_installing = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (set) {
                        tb_installing = false;
                    }
                }
                return bl2;
            }
            String title = MessageText.getString("aznettorbrowser.install");
            String text = MessageText.getString("aznettorbrowser.install.text");
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            if (remember_id != null) {
                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            }
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean bl3 = install = prompter.waitUntilClosed() == 0;
            if (install) {
                uif.installPlugin("aznettorbrowser", "aznettorbrowser.install", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionComplete(Object result) {
                        try {
                            if (callback != null) {
                                if (result instanceof Boolean) {
                                    install_outcome[0] = (Boolean)result;
                                }
                                callback.run();
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                tb_installing = false;
                            }
                            throw throwable;
                        }
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            tb_installing = false;
                        }
                    }
                });
                installing = true;
            } else {
                Debug.out("Tor Browser install declined (either user reply or auto-remembered)");
            }
            bl = install;
            Object var11_10 = null;
            if (installing) break block20;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                tb_installing = false;
            }
        }
        return bl;
    }

    private static String getExplicitLauncher(String file) {
        int pos = file.lastIndexOf(".");
        if (pos >= 0) {
            String ext = file.substring(pos + 1).toLowerCase().trim();
            int q_pos = ext.indexOf("?");
            if (q_pos > 0) {
                ext = ext.substring(0, q_pos);
            }
            for (int i = 0; i < 10; ++i) {
                String exts = COConfigurationManager.getStringParameter("Table.lh" + i + ".exts", "").trim();
                String exe = COConfigurationManager.getStringParameter("Table.lh" + i + ".prog", "").trim();
                if (exts.length() <= 0 || exe.length() <= 0 || !new File(exe).exists()) continue;
                exts = "," + exts.toLowerCase();
                exts = exts.replaceAll("\\.", ",");
                exts = exts.replaceAll(";", ",");
                exts = exts.replaceAll(" ", ",");
                if (!(exts = exts.replaceAll("[,]+", ",")).contains("," + ext)) continue;
                return exe;
            }
        }
        return null;
    }

    public static void setCheckedInSetData(TableItem item, boolean checked) {
        item.setChecked(checked);
        if (Constants.isWindowsXP || isGTK) {
            Rectangle r = item.getBounds(0);
            Table table = item.getParent();
            Rectangle rTable = table.getClientArea();
            table.redraw(0, r.y, rTable.width, r.height, true);
        }
    }

    public static boolean linkShellMetricsToConfig(Shell shell, String sConfigPrefix) {
        boolean isMaximized = COConfigurationManager.getBooleanParameter(sConfigPrefix + ".maximized");
        if (!isMaximized) {
            shell.setMaximized(false);
        }
        String windowRectangle = COConfigurationManager.getStringParameter(sConfigPrefix + ".rectangle", null);
        boolean bDidResize = false;
        if (null != windowRectangle) {
            int i = 0;
            int[] values = new int[4];
            StringTokenizer st = new StringTokenizer(windowRectangle, ",");
            try {
                while (st.hasMoreTokens() && i < 4) {
                    values[i++] = Integer.valueOf(st.nextToken());
                }
                if (i == 4) {
                    Rectangle shellBounds = new Rectangle(values[0], values[1], values[2], values[3]);
                    if (shellBounds.width > 100 && shellBounds.height > 50) {
                        shell.setBounds(shellBounds);
                        Utils.verifyShellRect(shell, true);
                        bDidResize = true;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (isMaximized) {
            shell.setMaximized(isMaximized);
        }
        new ShellMetricsResizeListener(shell, sConfigPrefix);
        return bDidResize;
    }

    public static GridData setGridData(Composite composite, int gridStyle, Control ctrlBestSize, int maxHeight) {
        GridData gridData = new GridData(gridStyle);
        gridData.heightHint = ctrlBestSize.computeSize((int)-1, (int)-1).y;
        if (gridData.heightHint > maxHeight && maxHeight > 0) {
            gridData.heightHint = maxHeight;
        }
        composite.setLayoutData((Object)gridData);
        return gridData;
    }

    public static FormData getFilledFormData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        return formData;
    }

    public static int pixelsToPoint(int pixels, int dpi) {
        int ret = (int)Math.round((double)pixels * 72.0 / (double)dpi);
        return ret;
    }

    private static int pixelsToPoint(double pixels, int dpi) {
        int ret = (int)Math.round(pixels * 72.0 / (double)dpi);
        return ret;
    }

    private static boolean drawImage(GC gc, Image image, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        return Utils.drawImage(gc, image, new Point(0, 0), dstRect, clipping, hOffset, vOffset, clearArea);
    }

    private static boolean drawImage(GC gc, Image image, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset) {
        return Utils.drawImage(gc, image, new Point(0, 0), dstRect, clipping, hOffset, vOffset, false);
    }

    public static boolean drawImage(GC gc, Image image, Point srcStart, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        Rectangle srcRect;
        Point dstAdj;
        if (clipping == null) {
            dstAdj = new Point(0, 0);
            srcRect = new Rectangle(srcStart.x, srcStart.y, dstRect.width, dstRect.height);
        } else {
            if (!dstRect.intersects(clipping)) {
                return false;
            }
            dstAdj = new Point(Math.max(0, clipping.x - dstRect.x), Math.max(0, clipping.y - dstRect.y));
            srcRect = new Rectangle(0, 0, 0, 0);
            srcRect.x = srcStart.x + dstAdj.x;
            srcRect.y = srcStart.y + dstAdj.y;
            srcRect.width = Math.min(dstRect.width - dstAdj.x, clipping.x + clipping.width - dstRect.x);
            srcRect.height = Math.min(dstRect.height - dstAdj.y, clipping.y + clipping.height - dstRect.y);
        }
        if (!srcRect.isEmpty()) {
            try {
                if (clearArea) {
                    gc.fillRectangle(dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
                }
                gc.drawImage(image, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
            }
            catch (Exception e) {
                System.out.println("drawImage: " + e.getMessage() + ": " + image + ", " + srcRect + ", " + (dstRect.x + dstAdj.y + hOffset) + "," + (dstRect.y + dstAdj.y + vOffset) + "," + srcRect.width + "," + srcRect.height + "; imageBounds = " + image.getBounds());
            }
        }
        return true;
    }

    public static Control findChild(Composite comp2, int x, int y) {
        Rectangle comp_bounds = comp2.getBounds();
        if (comp2.isVisible() && comp_bounds.contains(x, y)) {
            x -= comp_bounds.x;
            y -= comp_bounds.y;
            Control[] children = comp2.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control child = children[i];
                if (!child.isVisible()) continue;
                if (child instanceof Composite) {
                    Control res = Utils.findChild((Composite)child, x, y);
                    if (res == null) continue;
                    return res;
                }
                return child;
            }
            return comp2;
        }
        return null;
    }

    public static void addListenerAndChildren(Composite area, int event2, Listener listener) {
        area.addListener(event2, listener);
        Control[] children = area.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child instanceof Composite) {
                Utils.addListenerAndChildren((Composite)child, event2, listener);
                continue;
            }
            child.addListener(event2, listener);
        }
    }

    public static Shell findAnyShell() {
        Shell shell;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (shell = uiFunctions.getMainShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        Display current = Display.getCurrent();
        if (current == null) {
            return null;
        }
        Shell shell2 = current.getActiveShell();
        if (shell2 != null && !shell2.isDisposed()) {
            return shell2;
        }
        Shell[] shells = current.getShells();
        if (shells.length == 0) {
            return null;
        }
        if (shells[0] != null && !shells[0].isDisposed()) {
            return shells[0];
        }
        return null;
    }

    public static boolean verifyShellRect(Shell shell, boolean bAdjustIfInvalid) {
        boolean bMetricsOk;
        try {
            bMetricsOk = false;
            Point ptTopLeft = shell.getLocation();
            Monitor[] monitors = shell.getDisplay().getMonitors();
            for (int j = 0; j < monitors.length && !bMetricsOk; ++j) {
                Rectangle bounds = monitors[j].getBounds();
                bMetricsOk = bounds.contains(ptTopLeft);
            }
        }
        catch (NoSuchMethodError e) {
            Rectangle bounds = shell.getDisplay().getBounds();
            bMetricsOk = shell.getBounds().intersects(bounds);
        }
        if (!bMetricsOk && bAdjustIfInvalid) {
            Utils.centreWindow(shell);
        }
        return bMetricsOk;
    }

    public static void relayout(Control control) {
        Utils.relayout(control, false);
    }

    public static void relayout(Control control, boolean expandOnly) {
        if (control == null || control.isDisposed() || !control.isVisible()) {
            return;
        }
        Composite parent = control.getParent();
        Point targetSize = control.computeSize(-1, -1, true);
        Point size = control.getSize();
        if (size.y == targetSize.y && size.x == targetSize.x) {
            return;
        }
        int fixedWidth = -1;
        int fixedHeight = -1;
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof FormData) {
            FormData fd = (FormData)layoutData;
            fixedHeight = fd.height;
            fixedWidth = fd.width;
            if (fd.width != -1 && fd.height != -1) {
                parent.layout();
                return;
            }
        }
        if (expandOnly && size.y >= targetSize.y && size.x >= targetSize.x) {
            parent.layout();
            return;
        }
        while (parent != null) {
            parent.layout(true, true);
            parent = parent.getParent();
            Point newSize = control.getSize();
            if (fixedHeight <= -1 && newSize.y < targetSize.y || fixedWidth <= -1 && newSize.x < targetSize.x) continue;
            break;
        }
        if (parent != null) {
            parent.layout();
        }
    }

    public static void beep() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Display display = Display.getDefault();
                if (display != null) {
                    display.beep();
                }
            }
        });
    }

    public static Boolean execSWTThreadWithBool(String ID, AERunnableBoolean code) {
        return Utils.execSWTThreadWithBool(ID, code, 0L);
    }

    public static Boolean execSWTThreadWithBool(String ID, AERunnableBoolean code, long millis) {
        if (code == null) {
            Logger.log(new LogEvent(LogIDs.CORE, "code null"));
            return null;
        }
        Boolean[] returnValueObject = new Boolean[]{null};
        Display display = Utils.getDisplay();
        AESemaphore sem = null;
        if (display == null || display.getThread() != Thread.currentThread()) {
            sem = new AESemaphore(ID);
        }
        try {
            code.setupReturn(ID, returnValueObject, sem);
            if (!Utils.execSWTThread(code)) {
                return null;
            }
        }
        catch (Throwable e) {
            if (sem != null) {
                sem.release();
            }
            Debug.out(ID, e);
        }
        if (sem != null) {
            sem.reserve(millis);
        }
        return returnValueObject[0];
    }

    public static Object execSWTThreadWithObject(String ID, AERunnableObject code) {
        return Utils.execSWTThreadWithObject(ID, code, 0L);
    }

    public static Object execSWTThreadWithObject(String ID, AERunnableObject code, long millis) {
        if (code == null) {
            return null;
        }
        Object[] returnValueObject = new Object[]{null};
        Display display = Utils.getDisplay();
        AESemaphore sem = null;
        if (display == null || display.getThread() != Thread.currentThread()) {
            sem = new AESemaphore(ID);
        }
        try {
            code.setupReturn(ID, returnValueObject, sem);
            if (!Utils.execSWTThread(code)) {
                return null;
            }
        }
        catch (Throwable e) {
            if (sem != null) {
                sem.releaseForever();
            }
            Debug.out(ID, e);
        }
        if (sem != null && !sem.reserve(millis) && DEBUG_SWTEXEC) {
            System.out.println("Timeout in execSWTThreadWithObject(" + ID + ", " + code + ", " + millis + ") via " + Debug.getCompressedStackTrace());
        }
        return returnValueObject[0];
    }

    public static void waitForModals() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            display = Display.getDefault();
            if (display == null) {
                System.err.println("SWT Thread not started yet!");
                return;
            }
        } else {
            if (swt.isTerminated()) {
                return;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed()) {
            return;
        }
        Shell[] shells = display.getShells();
        Shell modalShell = null;
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if ((shell.getStyle() & 0x10000) == 0) continue;
            modalShell = shell;
            break;
        }
        if (modalShell != null) {
            while (!modalShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    public static GridData getWrappableLabelGridData(int hspan, int styles) {
        GridData gridData = new GridData(0x100 | styles);
        gridData.horizontalSpan = hspan;
        gridData.widthHint = 0;
        return gridData;
    }

    private static Image createAlphaImage(Device device, int width, int height) {
        return Utils.createAlphaImage(device, width, height, (byte)0);
    }

    public static Image createAlphaImage(Device device, int width, int height, byte defaultAlpha) {
        byte[] alphaData = new byte[width * height];
        Arrays.fill(alphaData, 0, alphaData.length, defaultAlpha);
        ImageData imageData = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
        Arrays.fill(imageData.data, 0, imageData.data.length, (byte)0);
        imageData.alphaData = alphaData;
        if (device == null) {
            device = Display.getDefault();
        }
        Image image = new Image(device, imageData);
        return image;
    }

    public static Image blitImage(Device device, Image srcImage, Rectangle srcArea, Image dstImage, Point dstPos) {
        if (srcArea == null) {
            srcArea = srcImage.getBounds();
        }
        Rectangle dstBounds = dstImage.getBounds();
        if (dstPos == null) {
            dstPos = new Point(dstBounds.x, dstBounds.y);
        } else {
            dstBounds.x = dstPos.x;
            dstBounds.y = dstPos.y;
        }
        ImageData dstImageData = dstImage.getImageData();
        ImageData srcImageData = srcImage.getImageData();
        int yPos = dstPos.y;
        int[] pixels = new int[srcArea.width];
        byte[] alphas = new byte[srcArea.width];
        for (int y = 0; y < srcArea.height; ++y) {
            srcImageData.getPixels(srcArea.x, y + srcArea.y, srcArea.width, pixels, 0);
            dstImageData.setPixels(dstPos.x, yPos, srcArea.width, pixels, 0);
            srcImageData.getAlphas(srcArea.x, y + srcArea.y, srcArea.width, alphas, 0);
            dstImageData.setAlphas(dstPos.x, yPos, srcArea.width, alphas, 0);
            ++yPos;
        }
        return new Image(device, dstImageData);
    }

    public static void drawStriped(GC gcImg, int x, int y, int width, int height, int lineDist, int leftshift, boolean fallingLines) {
        lineDist += 2;
        int xm = x + width;
        int ym = y + height;
        for (int i = x; i < xm; ++i) {
            for (int j = y; j < ym; ++j) {
                if ((i + leftshift + (fallingLines ? -j : j)) % lineDist != 0) continue;
                gcImg.drawPoint(i, j);
            }
        }
    }

    public static Image renderTransparency(Display display, Image background, Image foreground, Point foregroundOffsetOnBg, int modifyForegroundAlpha) {
        if (display == null || display.isDisposed() || background == null || background.isDisposed() || foreground == null || foreground.isDisposed()) {
            return null;
        }
        Rectangle backgroundArea = background.getBounds();
        Rectangle foregroundDrawArea = foreground.getBounds();
        foregroundDrawArea.x += foregroundOffsetOnBg.x;
        foregroundDrawArea.y += foregroundOffsetOnBg.y;
        foregroundDrawArea.intersect(backgroundArea);
        if (foregroundDrawArea.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)display, backgroundArea);
        ImageData backData = background.getImageData();
        ImageData foreData = foreground.getImageData();
        ImageData imgData = image.getImageData();
        PaletteData backPalette = backData.palette;
        ImageData backMask = backData.getTransparencyType() != 1 ? backData.getTransparencyMask() : null;
        PaletteData forePalette = foreData.palette;
        ImageData foreMask = foreData.getTransparencyType() != 1 ? foreData.getTransparencyMask() : null;
        PaletteData imgPalette = imgData.palette;
        image.dispose();
        for (int x = 0; x < backgroundArea.width; ++x) {
            for (int y = 0; y < backgroundArea.height; ++y) {
                RGB cBack = backPalette.getRGB(backData.getPixel(x, y));
                int aBack = backData.getAlpha(x, y);
                if (backMask != null && backMask.getPixel(x, y) == 0) {
                    aBack = 0;
                }
                int aFore = 0;
                if (foregroundDrawArea.contains(x, y)) {
                    int fx = x - foregroundDrawArea.x;
                    int fy = y - foregroundDrawArea.y;
                    RGB cFore = forePalette.getRGB(foreData.getPixel(fx, fy));
                    aFore = foreData.getAlpha(fx, fy);
                    if (foreMask != null && foreMask.getPixel(fx, fy) == 0) {
                        aFore = 0;
                    }
                    aFore = aFore * modifyForegroundAlpha / 255;
                    cBack.red *= aBack * (255 - aFore);
                    cBack.red /= 255;
                    cBack.red += aFore * cFore.red;
                    cBack.red /= 255;
                    cBack.green *= aBack * (255 - aFore);
                    cBack.green /= 255;
                    cBack.green += aFore * cFore.green;
                    cBack.green /= 255;
                    cBack.blue *= aBack * (255 - aFore);
                    cBack.blue /= 255;
                    cBack.blue += aFore * cFore.blue;
                    cBack.blue /= 255;
                }
                imgData.setAlpha(x, y, aFore + aBack * (255 - aFore) / 255);
                imgData.setPixel(x, y, imgPalette.getPixel(cBack));
            }
        }
        return new Image((Device)display, imgData);
    }

    public static Control findBackgroundImageControl(Control control) {
        Composite parent;
        Image image = control.getBackgroundImage();
        if (image == null) {
            return control;
        }
        Composite lastParent = parent = control.getParent();
        while (parent != null) {
            Image parentImage = parent.getBackgroundImage();
            if (!image.equals((Object)parentImage)) {
                return lastParent;
            }
            lastParent = parent;
            parent = parent.getParent();
        }
        return control;
    }

    public static boolean anyShellHaveStyle(int styles) {
        Display display = Display.getCurrent();
        if (display != null) {
            Shell[] shells = display.getShells();
            for (int i = 0; i < shells.length; ++i) {
                Shell shell = shells[i];
                int style = shell.getStyle();
                if ((style & styles) != styles) continue;
                return true;
            }
        }
        return false;
    }

    public static Shell findFirstShellWithStyle(int styles) {
        Display display = Display.getCurrent();
        if (display != null) {
            Shell[] shells = display.getShells();
            for (int i = 0; i < shells.length; ++i) {
                Shell shell = shells[i];
                int style = shell.getStyle();
                if ((style & styles) != styles || shell.isDisposed()) continue;
                return shell;
            }
        }
        return null;
    }

    public static int[] colorToIntArray(Color color) {
        if (color == null || color.isDisposed()) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static void centerRelativeTo(Rectangle target, Rectangle reference) {
        target.x = reference.x + reference.width / 2 - target.width / 2;
        target.y = reference.y + reference.height / 2 - target.height / 2;
    }

    public static void makeVisibleOnCursor(Rectangle rect) {
        if (null == rect) {
            return;
        }
        Display display = Display.getCurrent();
        if (null == display) {
            Debug.out("No current display detected.  This method [Utils.makeVisibleOnCursor()] must be called from a display thread.");
            return;
        }
        try {
            Point cursorLocation = display.getCursorLocation();
            Utils.makeVisibleOnMonitor(rect, Utils.getMonitor(cursorLocation));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void makeVisibleOnMonitor(Rectangle rect, Monitor monitor) {
        if (null == rect || null == monitor) {
            return;
        }
        try {
            int rightDiff;
            Rectangle monitorBounds = monitor.getClientArea();
            int bottomDiff = monitorBounds.y + monitorBounds.height - (rect.y + rect.height);
            if (bottomDiff < 0) {
                rect.y += bottomDiff;
            }
            if ((rightDiff = monitorBounds.x + monitorBounds.width - (rect.x + rect.width)) < 0) {
                rect.x += rightDiff;
            }
            if (rect.x < monitorBounds.x) {
                rect.x = monitorBounds.x;
            }
            if (rect.y < monitorBounds.y) {
                rect.y = monitorBounds.y;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Monitor getMonitor(int x, int y) {
        return Utils.getMonitor(new Point(x, y));
    }

    public static Monitor getMonitor(Point location) {
        Display display = Display.getCurrent();
        if (null == display) {
            Debug.out("No current display detected.  This method [Utils.makeVisibleOnCursor()] must be called from a display thread.");
            return null;
        }
        try {
            Monitor[] monitors = display.getMonitors();
            Rectangle monitorBounds = null;
            for (int i = 0; i < monitors.length; ++i) {
                monitorBounds = monitors[i].getClientArea();
                if (!monitorBounds.contains(location)) continue;
                return monitors[i];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void makeButtonsEqualWidth(List<Button> buttons) {
        int width = 75;
        for (Button button : buttons) {
            width = Math.max(width, button.computeSize((int)-1, (int)-1).x);
        }
        for (Button button : buttons) {
            Object data = button.getLayoutData();
            if (data != null) {
                if (data instanceof GridData) {
                    ((GridData)data).widthHint = width;
                    continue;
                }
                if (data instanceof FormData) {
                    ((FormData)data).width = width;
                    continue;
                }
                Debug.out("Expected GridData/FormData");
                continue;
            }
            data = new GridData();
            ((GridData)data).widthHint = width;
            button.setLayoutData(data);
        }
    }

    public static int getInitialBrowserStyle(int style) {
        if (!gotBrowserStyle) {
            browserStyle = COConfigurationManager.getBooleanParameter("swt.forceMozilla") ? 32768 : 0;
            gotBrowserStyle = true;
        }
        return style | browserStyle;
    }

    public static synchronized String truncateText(GC gc, String text, int maxWidth, boolean cache) {
        TruncatedTextResult result;
        if (cache && (result = (TruncatedTextResult)truncatedTextCache.get(text)) != null && result.maxWidth == maxWidth) {
            return result.text;
        }
        StringBuffer sb = new StringBuffer(text);
        String append = "...";
        int appendWidth = gc.textExtent((String)append).x;
        boolean needsAppend = false;
        while (gc.textExtent((String)sb.toString()).x > maxWidth) {
            sb.deleteCharAt(sb.length() - 1);
            needsAppend = true;
            if (sb.length() != 1) continue;
        }
        if (needsAppend) {
            while (gc.textExtent((String)sb.toString()).x + appendWidth > maxWidth) {
                sb.deleteCharAt(sb.length() - 1);
                needsAppend = true;
                if (sb.length() != 1) continue;
            }
            sb.append(append);
        }
        if (cache) {
            TruncatedTextResult ttR = new TruncatedTextResult();
            ttR.text = sb.toString();
            ttR.maxWidth = maxWidth;
            truncatedTextCache.put(text, ttR);
        }
        return sb.toString();
    }

    public static String toColorHexString(Color bg) {
        StringBuffer sb = new StringBuffer();
        Utils.twoHex(sb, bg.getRed());
        Utils.twoHex(sb, bg.getGreen());
        Utils.twoHex(sb, bg.getBlue());
        return sb.toString();
    }

    private static void twoHex(StringBuffer sb, int h) {
        if (h <= 15) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(h));
    }

    public static String getWidgetBGColorURLParam() {
        Color bg = Utils.findAnyShell().getDisplay().getSystemColor(22);
        byte[] color = new byte[]{(byte)bg.getRed(), (byte)bg.getGreen(), (byte)bg.getBlue()};
        return "bg_color=" + ByteFormatter.nicePrint(color);
    }

    public static void reportError(Throwable e) {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("ConfigView.section.security.op.error", new String[]{Debug.getNestedExceptionMessage(e)}), new String[]{MessageText.getString("Button.ok")}, 0);
        mb.open(null);
    }

    public static void getOffOfSWTThread(AERunnable runnable) {
        tp.run(runnable);
    }

    public static Browser createSafeBrowser(Composite parent, int style) {
        try {
            Browser browser = new Browser(parent, Utils.getInitialBrowserStyle(style));
            browser.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void widgetDisposed(DisposeEvent e) {
                    ((Browser)e.widget).setUrl("about:blank");
                    ((Browser)e.widget).setVisible(false);
                    final boolean[] done = new boolean[]{false};
                    long start = SystemTime.getMonotonousTime();
                    Utils.execSWTThreadLater(250, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            boolean[] blArray = done;
                            synchronized (done) {
                                done[0] = true;
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                    while (!e.display.isDisposed()) {
                        if (!e.display.readAndDispatch()) return;
                        boolean[] blArray = done;
                        // MONITORENTER : done
                        if (done[0] || SystemTime.getMonotonousTime() - start > 500L) {
                            // MONITOREXIT : blArray
                            return;
                        }
                        // MONITOREXIT : blArray
                    }
                }
            });
            return browser;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int getUserMode() {
        return userMode;
    }

    public static Point getLocationRelativeToShell(Control control) {
        Point controlLocation = control.toDisplay(0, 0);
        Point shellLocation = control.getShell().getLocation();
        return new Point(controlLocation.x - shellLocation.x, controlLocation.y - shellLocation.y);
    }

    public static boolean isQuickViewSupported(DiskManagerFileInfo file) {
        String ext = file.getExtension().toLowerCase();
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        if (ext.equals("rar")) {
            return true;
        }
        return qv_exts.contains(ext) && file.getLength() <= (long)qv_max_bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isQuickViewActive(DiskManagerFileInfo file) {
        Set<DiskManagerFileInfo> set = quick_view_active;
        synchronized (set) {
            return quick_view_active.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQuickViewActive(DiskManagerFileInfo file, boolean active) {
        Set<DiskManagerFileInfo> set = quick_view_active;
        synchronized (set) {
            boolean file_complete;
            if (!active) {
                quick_view_active.remove(file);
                return;
            }
            if (quick_view_active.contains(file)) {
                return;
            }
            String ext = file.getExtension().toLowerCase();
            boolean bl = file_complete = file.getDownloaded() == file.getLength();
            if (ext.equals(".rar")) {
                quick_view_active.add(file);
                Utils.quickViewRAR(file);
            } else if (file_complete) {
                Utils.quickView(file);
            } else {
                DiskManagerFileInfo[] all_files;
                quick_view_active.add(file);
                if (file.isSkipped()) {
                    file.setSkipped(false);
                }
                file.setPriority(1);
                for (DiskManagerFileInfo f : all_files = file.getDownloadManager().getDiskManagerFileInfoSet().getFiles()) {
                    if (quick_view_active.contains(f)) continue;
                    f.setPriority(0);
                }
                if (quick_view_event == null) {
                    quick_view_event = SimpleTimer.addPeriodicEvent("qv_checker", 5000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            Set set = quick_view_active;
                            synchronized (set) {
                                Iterator it = quick_view_active.iterator();
                                while (it.hasNext()) {
                                    DiskManagerFileInfo file = (DiskManagerFileInfo)it.next();
                                    if (file.getDownloadManager().isDestroyed()) {
                                        it.remove();
                                        continue;
                                    }
                                    if (file.getDownloaded() != file.getLength()) continue;
                                    Utils.quickView(file);
                                    it.remove();
                                }
                                if (quick_view_active.isEmpty()) {
                                    quick_view_event.cancel();
                                    quick_view_event = null;
                                }
                            }
                        }
                    });
                }
            }
            if (!file_complete) {
                Utils.execSWTThreadLater(10, new Runnable(){

                    public void run() {
                        MessageBoxShell mb = new MessageBoxShell(32, MessageText.getString("quick.view.scheduled.title"), MessageText.getString("quick.view.scheduled.text"));
                        mb.setDefaultButtonUsingStyle(32);
                        mb.setRemember("quick.view.inform.activated.id", false, MessageText.getString("label.dont.show.again"));
                        mb.setLeftImage(2);
                        mb.open(null);
                    }
                });
            }
        }
    }

    private static void quickView(final DiskManagerFileInfo file) {
        try {
            final File target_file = file.getFile(true);
            final String contents = FileUtil.readFileAsString(target_file, qv_max_bytes);
            Utils.execSWTThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Image image;
                    DownloadManager dm;
                    block6: {
                        if (Utils.getExplicitLauncher(target_file.getName()) != null) {
                            Utils.launch(target_file.getAbsolutePath());
                            return;
                        }
                        dm = file.getDownloadManager();
                        try {
                            FileInputStream is = null;
                            try {
                                is = new FileInputStream(target_file);
                                image = new Image((Device)Utils.getDisplay(), (InputStream)is);
                                Object var5_5 = null;
                                if (is == null) break block6;
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                if (is == null) throw throwable;
                                ((InputStream)is).close();
                                throw throwable;
                            }
                            ((InputStream)is).close();
                        }
                        catch (Throwable e) {
                            image = null;
                        }
                    }
                    if (image != null) {
                        new ImageViewerWindow(MessageText.getString("MainWindow.menu.quick_view") + ": " + target_file.getName(), MessageText.getString("MainWindow.menu.quick_view.msg", new String[]{target_file.getName(), dm.getDisplayName()}), image);
                        return;
                    }
                    new TextViewerWindow(MessageText.getString("MainWindow.menu.quick_view") + ": " + target_file.getName(), MessageText.getString("MainWindow.menu.quick_view.msg", new String[]{target_file.getName(), dm.getDisplayName()}), contents, false);
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void quickViewRAR(final DiskManagerFileInfo file) {
        boolean went_async = false;
        try {
            try {
                final org.gudy.azureus2.plugins.disk.DiskManagerFileInfo plugin_file = PluginCoreUtils.wrap(file);
                final RARTOCDecoder decoder = new RARTOCDecoder(new RARTOCDecoder.DataProvider(){
                    private long file_position;
                    private long file_size;
                    {
                        this.file_size = file.getLength();
                    }

                    public int read(final byte[] buffer) throws IOException {
                        long read_from = this.file_position;
                        int read_length = buffer.length;
                        long read_to = Math.min(this.file_size, read_from + (long)read_length);
                        if ((read_length = (int)(read_to - read_from)) <= 0) {
                            return -1;
                        }
                        final int f_read_length = read_length;
                        try {
                            final AESemaphore sem = new AESemaphore("rarwait");
                            final Object[] result = new Object[]{null};
                            plugin_file.createRandomReadRequest(read_from, read_length, false, new DiskManagerListener(){
                                private int buffer_pos;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void eventOccurred(DiskManagerEvent event2) {
                                    int event_type = event2.getType();
                                    if (event_type == 1) {
                                        PooledByteBuffer pooled_buffer = event2.getBuffer();
                                        try {
                                            byte[] data = pooled_buffer.toByteArray();
                                            System.arraycopy(data, 0, buffer, this.buffer_pos, data.length);
                                            this.buffer_pos += data.length;
                                            if (this.buffer_pos == f_read_length) {
                                                sem.release();
                                            }
                                            Object var6_5 = null;
                                            pooled_buffer.returnToPool();
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_6 = null;
                                            pooled_buffer.returnToPool();
                                            throw throwable;
                                        }
                                    } else if (event_type == 2) {
                                        result[0] = event2.getFailure();
                                        sem.release();
                                    }
                                }
                            });
                            sem.reserve();
                            if (result[0] instanceof Throwable) {
                                throw (Throwable)result[0];
                            }
                            this.file_position += (long)read_length;
                            return read_length;
                        }
                        catch (Throwable e) {
                            throw new IOException("read failed: " + Debug.getNestedExceptionMessage(e));
                        }
                    }

                    public void skip(long bytes) throws IOException {
                        this.file_position += bytes;
                    }
                });
                new AEThread2("rardecoder"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            try {
                                decoder.analyse(new RARTOCDecoder.TOCResultHandler(){
                                    private TextViewerWindow viewer;
                                    private List<String> lines = new ArrayList<String>();
                                    private int pw_entries = 0;
                                    private int pw_text = 0;
                                    private volatile boolean abandon = false;

                                    public void entryRead(String name, long size, boolean password) throws IOException {
                                        if (this.abandon) {
                                            throw new IOException("Operation abandoned");
                                        }
                                        String line = name + ":    " + DisplayFormatters.formatByteCountToKiBEtc(size);
                                        if (password) {
                                            line = line + "    **** password protected ****";
                                            ++this.pw_entries;
                                        }
                                        if (password || name.toLowerCase().contains("password")) {
                                            line = "*\t" + line;
                                            ++this.pw_text;
                                        } else {
                                            line = " \t" + line;
                                        }
                                        this.appendLine(line, false);
                                    }

                                    public void complete() {
                                        this.appendLine("Done", true);
                                    }

                                    public void failed(IOException error) {
                                        this.appendLine("Failed: " + Debug.getNestedExceptionMessage(error), true);
                                    }

                                    private String getInfo() {
                                        if (this.pw_entries > 0) {
                                            return this.pw_entries + " password protected file(s) found";
                                        }
                                        if (this.pw_text > 0) {
                                            return this.pw_text + " file(s) mentioning 'password' found";
                                        }
                                        return "";
                                    }

                                    private void appendLine(final String line, final boolean complete) {
                                        Utils.execSWTThread(new Runnable(){

                                            public void run() {
                                                lines.add(line);
                                                StringBuffer content = new StringBuffer();
                                                for (String l : lines) {
                                                    content.append(l + "\r\n");
                                                }
                                                if (!complete) {
                                                    content.append("processing...");
                                                } else {
                                                    String info = this.getInfo();
                                                    if (info.length() > 0) {
                                                        content.append(info + "\r\n");
                                                    }
                                                }
                                                if (viewer == null) {
                                                    File target_file = file.getFile(true);
                                                    DownloadManager dm = file.getDownloadManager();
                                                    viewer = new TextViewerWindow(MessageText.getString("MainWindow.menu.quick_view") + ": " + target_file.getName(), MessageText.getString("MainWindow.menu.quick_view.msg", new String[]{target_file.getName(), dm.getDisplayName()}), content.toString(), false);
                                                } else if (viewer.isDisposed()) {
                                                    abandon = true;
                                                } else {
                                                    viewer.setText(content.toString());
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Object var3_2 = null;
                                Set set2 = quick_view_active;
                                synchronized (set2) {
                                    quick_view_active.remove(file);
                                    return;
                                }
                            }
                            Object var3_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            Set set = quick_view_active;
                            synchronized (set) {
                                quick_view_active.remove(file);
                                throw throwable;
                            }
                        }
                        Set set = quick_view_active;
                        synchronized (set) {
                            quick_view_active.remove(file);
                            return;
                        }
                    }
                }.start();
                return;
            }
            catch (Throwable e) {
                Debug.out(e);
                Object var5_6 = null;
                if (went_async) return;
                Set<DiskManagerFileInfo> set3 = quick_view_active;
                synchronized (set3) {
                    quick_view_active.remove(file);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (went_async) throw throwable;
            Set<DiskManagerFileInfo> set2 = quick_view_active;
            synchronized (set2) {
                quick_view_active.remove(file);
                throw throwable;
            }
        }
    }

    public static Sash createSash(Composite form, int SASH_WIDTH) {
        final Sash sash = new Sash(form, 256);
        Image image = new Image((Device)sash.getDisplay(), 9, SASH_WIDTH);
        ImageData imageData = image.getImageData();
        int[] row = new int[imageData.width];
        for (int i = 0; i < row.length; ++i) {
            int n = row[i] = i % 3 != 0 ? 0xE0E0E0 : 0x808080;
            if (imageData.depth != 32) continue;
            row[i] = (row[i] & 0xFF) + (row[i] << 8);
        }
        for (int y = 1; y < imageData.height - 1; ++y) {
            imageData.setPixels(0, y, row.length, row, 0);
        }
        Arrays.fill(row, -522133280);
        imageData.setPixels(0, 0, row.length, row, 0);
        imageData.setPixels(0, imageData.height - 1, row.length, row, 0);
        image.dispose();
        image = new Image((Device)sash.getDisplay(), imageData);
        sash.setBackgroundImage(image);
        sash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                sash.getBackgroundImage().dispose();
            }
        });
        return sash;
    }

    static {
        BUTTON_MINWIDTH = Constants.isOSX ? 90 : 70;
        DEBUG_SWTEXEC = System.getProperty("debug.swtexec", "0").equals("1");
        shellIcons = null;
        shellIconNames = new String[]{"azureus", "azureus32", "azureus64", "azureus128"};
        EMPTY_RECT = new Rectangle(0, 0, 0, 0);
        if (DEBUG_SWTEXEC) {
            System.out.println("==== debug.swtexec=1, performance may be affected ====");
            queue = new ArrayList();
            diag_logger = AEDiagnostics.getLogger("swt");
            diag_logger.log("\n\nSWT Logging Starts");
            AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

                public void generate(IndentWriter writer) {
                    writer.println("SWT Queue:");
                    writer.indent();
                    for (Runnable r : queue) {
                        writer.println(r.toString());
                    }
                    writer.exdent();
                }
            });
        } else {
            queue = null;
            diag_logger = null;
        }
        COConfigurationManager.addAndFireParameterListener("User Mode", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                userMode = COConfigurationManager.getIntParameter("User Mode");
            }
        });
        COConfigurationManager.addAndFireParameterListener("ui", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                isAZ2 = "az2".equals(COConfigurationManager.getStringParameter("ui"));
            }
        });
        boolean smallOSXControl = COConfigurationManager.getBooleanParameter("enable_small_osx_fonts");
        BUTTON_MARGIN = Constants.isOSX ? (smallOSXControl ? 10 : 12) : 6;
        pending_ext_urls = new HashSet<String>();
        ext_url_dispatcher = new AsyncDispatcher("Ext Urls");
        i2p_install_active_for_url = false;
        browser_install_active_for_url = false;
        i2p_installing = false;
        tb_installing = false;
        gotBrowserStyle = false;
        browserStyle = 0;
        truncatedTextCache = new HashMap();
        tp = new ThreadPool("GetOffSWT", 3, true);
        qv_exts = new HashSet<String>();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"quick.view.exts", "quick.view.maxkb"}, new ParameterListener(){

            public void parameterChanged(String name) {
                String exts_str = COConfigurationManager.getStringParameter("quick.view.exts");
                int max_bytes = COConfigurationManager.getIntParameter("quick.view.maxkb") * 1024;
                String[] bits = exts_str.split("[;, ]");
                HashSet<String> exts = new HashSet<String>();
                for (String bit : bits) {
                    if ((bit = bit.trim()).startsWith(".")) {
                        bit = bit.substring(1);
                    }
                    if (bit.length() <= 0) continue;
                    exts.add(bit.toLowerCase());
                }
                qv_exts = exts;
                qv_max_bytes = max_bytes;
            }
        });
        quick_view_active = new HashSet<DiskManagerFileInfo>();
    }

    private static class ShellMetricsResizeListener
    implements Listener {
        private int state = -1;
        private String sConfigPrefix;
        private Rectangle bounds = null;

        ShellMetricsResizeListener(Shell shell, String sConfigPrefix) {
            this.sConfigPrefix = sConfigPrefix;
            this.state = this.calcState(shell);
            if (this.state == 0) {
                this.bounds = shell.getBounds();
            }
            shell.addListener(11, (Listener)this);
            shell.addListener(10, (Listener)this);
            shell.addListener(12, (Listener)this);
        }

        private int calcState(Shell shell) {
            return shell.getMinimized() ? 128 : (shell.getMaximized() && !isCarbon ? 1024 : 0);
        }

        private void saveMetrics() {
            COConfigurationManager.setParameter(this.sConfigPrefix + ".maximized", this.state == 1024);
            if (this.bounds == null) {
                return;
            }
            COConfigurationManager.setParameter(this.sConfigPrefix + ".rectangle", this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height);
            COConfigurationManager.save();
        }

        public void handleEvent(Event event2) {
            Shell shell = (Shell)event2.widget;
            this.state = this.calcState(shell);
            if (event2.type != 12 && this.state == 0) {
                this.bounds = shell.getBounds();
            }
            if (event2.type == 12) {
                this.saveMetrics();
            }
        }
    }

    private static class TruncatedTextResult {
        String text;
        int maxWidth;
    }

    private static class URLDropTarget
    extends DropTargetAdapter {
        private final Text url;
        private final boolean bAllowShareAdd;

        public URLDropTarget(Text url, boolean bAllowShareAdd) {
            this.url = url;
            this.bAllowShareAdd = bAllowShareAdd;
        }

        public void dropAccept(DropTargetEvent event2) {
            event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
        }

        public void dragOver(DropTargetEvent event2) {
            if (event2.detail != 16 && (event2.operations & event2.detail) > 0) {
                return;
            }
            if ((event2.operations & 4) > 0) {
                event2.detail = 4;
            } else if ((event2.operations & 0x10) > 0) {
                event2.detail = 16;
            } else if ((event2.operations & 1) > 0) {
                event2.detail = 1;
            }
        }

        public void drop(DropTargetEvent event2) {
            String sURL;
            if (this.url == null || this.url.isDisposed()) {
                TorrentOpener.openDroppedTorrents(event2, this.bAllowShareAdd);
            } else if (event2.data instanceof URLTransfer.URLType) {
                if (((URLTransfer.URLType)event2.data).linkURL != null) {
                    this.url.setText(((URLTransfer.URLType)event2.data).linkURL);
                }
            } else if (event2.data instanceof String && (sURL = UrlUtils.parseTextForURL((String)event2.data, true)) != null) {
                this.url.setText(sURL);
            }
        }
    }
}

