/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImageListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionListWindow;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionView;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionWizard;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionsView;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class SubscriptionManagerUI {
    public static final Object SUB_ENTRYINFO_KEY = new Object();
    public static final Object SUB_EDIT_MODE_KEY = new Object();
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String INFO_IMAGE_ID = "image.sidebar.vitality.info";
    static final String EDIT_MODE_MARKER = "&editMode=1";
    private Graphic icon_rss_big;
    private Graphic icon_rss_small;
    private Graphic icon_rss_all_add_small;
    private Graphic icon_rss_all_add_big;
    private Graphic icon_rss_some_add_small;
    private Graphic icon_rss_some_add_big;
    private List<Graphic> icon_list = new ArrayList<Graphic>();
    private List<TableColumn> columns = new ArrayList<TableColumn>();
    protected UISWTInstance swt;
    private UIManager ui_manager;
    private PluginInterface default_pi = PluginInitializer.getDefaultInterface();
    private MdiEntry mdiEntryOverview;
    private boolean sidebar_setup_done;

    public SubscriptionManagerUI() {
        TableManager table_manager = this.default_pi.getUIManager().getTableManager();
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                SubscriptionManagerFactory.getSingleton();
            }
        });
        if (Constants.isCVSVersion()) {
            TableContextMenuItem menu_item_itorrents = table_manager.addContextMenuItem("MyTorrents", "azsubs.contextmenu.lookupassoc");
            TableContextMenuItem menu_item_ctorrents = table_manager.addContextMenuItem("MySeeders", "azsubs.contextmenu.lookupassoc");
            menu_item_itorrents.setStyle(1);
            menu_item_ctorrents.setStyle(1);
            MenuItemListener listener = new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    TableRow[] rows = (TableRow[])target;
                    if (rows.length > 0) {
                        Download download = (Download)rows[0].getDataSource();
                        new SubscriptionListWindow(PluginCoreUtils.unwrap(download), false);
                    }
                }
            };
            menu_item_itorrents.addMultiListener(listener);
            menu_item_ctorrents.addMultiListener(listener);
        }
        this.createSubsColumns(table_manager);
        this.ui_manager = this.default_pi.getUIManager();
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (!(instance instanceof UISWTInstance)) {
                    return;
                }
                SubscriptionManagerUI.this.swt = (UISWTInstance)instance;
                SubscriptionManagerUI.this.uiQuickInit();
                Utilities utilities = SubscriptionManagerUI.this.default_pi.getUtilities();
                DelayedTask dt = utilities.createDelayedTask(new Runnable(){

                    public void run() {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                SubscriptionManagerUI.this.delayedInit();
                            }
                        });
                    }
                });
                dt.queue();
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    void uiQuickInit() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        this.icon_rss_big = this.icon_rss_small = this.loadGraphic(this.swt, "subscription_icon.png");
        this.icon_rss_all_add_big = this.icon_rss_all_add_small = this.loadGraphic(this.swt, "subscription_icon_inactive.png");
        this.icon_rss_some_add_big = this.icon_rss_some_add_small = this.icon_rss_all_add_small;
        mdi.registerEntry("Subscriptions", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                SubscriptionManagerUI.this.setupSideBar(SubscriptionManagerUI.this.swt);
                return SubscriptionManagerUI.this.mdiEntryOverview;
            }
        });
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (uiClassic) {
            this.registerAllSubscriptions();
        }
    }

    void delayedInit() {
        if (this.swt == null) {
            return;
        }
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        subs_man.addListener(new SubscriptionManagerListener(){

            public void subscriptionAdded(Subscription subscription) {
            }

            public void subscriptionChanged(Subscription subscription) {
            }

            public void subscriptionSelected(Subscription subscription) {
            }

            public void subscriptionRemoved(Subscription subscription) {
            }

            public void associationsChanged(byte[] hash) {
                SubscriptionManagerUI.this.refreshColumns();
            }

            public void subscriptionRequested(final URL url) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        new SubscriptionWizard(url);
                    }
                });
            }
        });
        this.createConfigModel();
    }

    private void createConfigModel() {
        final SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        BasicPluginConfigModel configModel = this.ui_manager.createBasicPluginConfigModel("root", "Subscriptions");
        final IntParameter max_results = configModel.addIntParameter2("subscriptions.config.maxresults", "subscriptions.config.maxresults", subs_man.getMaxNonDeletedResults());
        final BooleanParameter search_enable = configModel.addBooleanParameter2("subscriptions.search.enable", "subscriptions.search.enable", subs_man.isSearchEnabled());
        search_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setSearchEnabled(search_enable.getValue());
            }
        });
        final BooleanParameter download_subs_enable = configModel.addBooleanParameter2("subscriptions.dl_subs.enable", "subscriptions.dl_subs.enable", subs_man.isSubsDownloadEnabled());
        download_subs_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setSubsDownloadEnabled(download_subs_enable.getValue());
            }
        });
        final StringParameter rate_limits = configModel.addStringParameter2("subscriptions.config.ratelimits", "subscriptions.config.ratelimits", subs_man.getRateLimits());
        rate_limits.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setRateLimits(rate_limits.getValue());
            }
        });
        final BooleanParameter auto_start = configModel.addBooleanParameter2("subscriptions.config.autostartdls", "subscriptions.config.autostartdls", subs_man.getAutoStartDownloads());
        auto_start.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setAutoStartDownloads(auto_start.getValue());
            }
        });
        final IntParameter min_auto_start_size = configModel.addIntParameter2("subscriptions.config.autostart.min", "subscriptions.config.autostart.min", subs_man.getAutoStartMinMB());
        final IntParameter max_auto_start_size = configModel.addIntParameter2("subscriptions.config.autostart.max", "subscriptions.config.autostart.max", subs_man.getAutoStartMaxMB());
        auto_start.addEnabledOnSelection(min_auto_start_size);
        auto_start.addEnabledOnSelection(max_auto_start_size);
        configModel.createGroup("subscriptions.config.auto", new Parameter[]{auto_start, min_auto_start_size, max_auto_start_size});
        this.default_pi.getPluginconfig().addListener(new PluginConfigListener(){

            public void configSaved() {
                subs_man.setMaxNonDeletedResults(max_results.getValue());
                subs_man.setAutoStartMinMB(min_auto_start_size.getValue());
                subs_man.setAutoStartMaxMB(max_auto_start_size.getValue());
            }
        });
        final BooleanParameter rss_enable = configModel.addBooleanParameter2("subscriptions.rss.enable", "subscriptions.rss.enable", subs_man.isRSSPublishEnabled());
        rss_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setRSSPublishEnabled(rss_enable.getValue());
            }
        });
        HyperlinkParameter rss_view = configModel.addHyperlinkParameter2("device.rss.view", subs_man.getRSSLink());
        rss_enable.addEnabledOnSelection(rss_view);
        configModel.createGroup("device.rss.group", new Parameter[]{rss_enable, rss_view});
    }

    private void createSubsColumns(TableManager table_manager) {
        final TableCellRefreshListener subs_refresh_listener = new TableCellRefreshListener(){

            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    String tooltip;
                    Graphic graphic;
                    Subscription[] subs = subs_man.getKnownSubscriptions(torrent.getHash());
                    int num_subscribed = 0;
                    int num_unsubscribed = 0;
                    for (int i = 0; i < subs.length; ++i) {
                        if (subs[i].isSubscribed()) {
                            ++num_subscribed;
                            continue;
                        }
                        ++num_unsubscribed;
                    }
                    int height = cell.getHeight();
                    int sort_order = 0;
                    if (subs.length == 0) {
                        graphic = null;
                        tooltip = null;
                    } else if (num_subscribed == subs.length) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_all_add_big : SubscriptionManagerUI.this.icon_rss_all_add_small;
                        tooltip = MessageText.getString("subscript.all.subscribed");
                    } else if (num_subscribed > 0) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_some_add_big : SubscriptionManagerUI.this.icon_rss_some_add_small;
                        tooltip = MessageText.getString("subscript.some.subscribed");
                        sort_order = 10000;
                    } else {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_big : SubscriptionManagerUI.this.icon_rss_small;
                        tooltip = MessageText.getString("subscript.none.subscribed");
                        sort_order = 1000000;
                    }
                    cell.setMarginHeight(0);
                    cell.setGraphic(graphic);
                    cell.setToolTip(tooltip);
                    cell.setSortValue(sort_order += 1000 * num_unsubscribed + num_subscribed);
                    cell.setCursorID(graphic == null ? 0 : 21);
                } else {
                    cell.setCursorID(0);
                    cell.setSortValue(0L);
                }
            }
        };
        final TableCellMouseListener subs_mouse_listener = new TableCellMouseListener(){

            public void cellMouseTrigger(TableCellMouseEvent event2) {
                SubscriptionManager subs_man;
                Subscription[] subs;
                TableCell cell;
                Download dl;
                Torrent torrent;
                if (event2.eventType == 0 && (torrent = (dl = (Download)(cell = event2.cell).getDataSource()).getTorrent()) != null && (subs = (subs_man = SubscriptionManagerFactory.getSingleton()).getKnownSubscriptions(torrent.getHash())).length > 0) {
                    event2.skipCoreFunctionality = true;
                    new SubscriptionWizard(PluginCoreUtils.unwrap(dl));
                    COConfigurationManager.setParameter("subscriptions.wizard.shown", true);
                    SubscriptionManagerUI.this.refreshTitles(SubscriptionManagerUI.this.mdiEntryOverview);
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs", new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(3);
                result.setPosition(-2);
                result.setWidth(32);
                result.setRefreshInterval(-3);
                result.setType(2);
                result.addCellRefreshListener(subs_refresh_listener);
                result.addCellMouseListener(subs_mouse_listener);
                result.setIconReference("image.subscription.column", true);
                List list = SubscriptionManagerUI.this.columns;
                synchronized (list) {
                    SubscriptionManagerUI.this.columns.add(result);
                }
            }
        });
        final TableCellRefreshListener link_refresh_listener = new TableCellRefreshListener(){

            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                String str = "";
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    byte[] hash = torrent.getHash();
                    Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                    for (int i = 0; i < subs.length; ++i) {
                        Subscription sub = subs[i];
                        if (!sub.hasAssociation(hash)) continue;
                        str = str + (str.length() == 0 ? "" : "; ") + sub.getName();
                    }
                }
                cell.setCursorID(str.length() > 0 ? 21 : 0);
                cell.setText(str);
            }
        };
        final TableCellMouseListener link_mouse_listener = new TableCellMouseListener(){

            public void cellMouseTrigger(TableCellMouseEvent event2) {
                if (event2.eventType == 0) {
                    TableCell cell = event2.cell;
                    Download dl = (Download)cell.getDataSource();
                    Torrent torrent = dl.getTorrent();
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    if (torrent != null) {
                        byte[] hash = torrent.getHash();
                        Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                        for (int i = 0; i < subs.length; ++i) {
                            Subscription sub = subs[i];
                            if (!sub.hasAssociation(hash)) continue;
                            String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                            if (mdi == null) break;
                            mdi.showEntryByID(key);
                            break;
                        }
                    }
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs_link", new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(1);
                result.setPosition(-1);
                result.setWidth(85);
                result.setRefreshInterval(-3);
                result.setType(3);
                result.addCellRefreshListener(link_refresh_listener);
                result.addCellMouseListener(link_mouse_listener);
                result.setMinimumRequiredUserMode(1);
                List list = SubscriptionManagerUI.this.columns;
                synchronized (list) {
                    SubscriptionManagerUI.this.columns.add(result);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSideBar(UISWTInstance swt_ui) {
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return;
        }
        this.mdiEntryOverview = mdi.createEntryFromEventListener("header.discovery", new UISWTViewEventListenerHolder("Subscriptions", SubscriptionsView.class, null, null), "Subscriptions", false, null, null);
        if (this.mdiEntryOverview == null) {
            return;
        }
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            if (this.sidebar_setup_done) {
                return;
            }
            this.sidebar_setup_done = true;
        }
        this.mdiEntryOverview.setImageLeftID("image.sidebar.subscriptions");
        this.setupHeader(mdi, this.mdiEntryOverview);
        String parentID = "sidebar.header.discovery";
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        MenuItem mi = menu_manager.addMenuItem(parentID, "MainWindow.menu.view.configuration");
        mi.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.openView(4, "Subscriptions");
                }
            }
        });
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        subs_man.addListener(new SubscriptionManagerListener(){

            public void subscriptionAdded(Subscription subscription) {
                SubscriptionManagerUI.this.registerSubscriptionViewMdiEntry(subscription, false);
            }

            public void subscriptionChanged(Subscription subscription) {
                SubscriptionManagerUI.this.changeSubscription(subscription);
            }

            public void subscriptionSelected(Subscription sub) {
                String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    mdi.showEntryByID(key);
                }
            }

            public void subscriptionRemoved(Subscription subscription) {
                SubscriptionManagerUI.this.removeSubscription(subscription);
            }

            public void associationsChanged(byte[] association_hash) {
            }

            public void subscriptionRequested(URL url) {
            }
        });
        if (!uiClassic) {
            this.registerAllSubscriptions();
        }
        mdi.addListener(new MdiListener(){
            private long last_select = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mdiEntrySelected(MdiEntry new_entry, MdiEntry old_entry) {
                UISWTViewEventListener eventListener;
                if (new_entry == old_entry && new_entry instanceof BaseMdiEntry && (eventListener = ((BaseMdiEntry)new_entry).getEventListener()) instanceof SubscriptionView) {
                    try {
                        if (SystemTime.getMonotonousTime() - this.last_select > 1000L) {
                            ((SubscriptionView)eventListener).updateBrowser(false);
                        }
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        this.last_select = SystemTime.getMonotonousTime();
                        throw throwable;
                    }
                    this.last_select = SystemTime.getMonotonousTime();
                    {
                    }
                }
            }
        });
    }

    private void setupHeader(MultipleDocumentInterface mdi, final MdiEntry headerEntry) {
        MdiEntryVitalityImage infoSub;
        MdiEntryVitalityImage warnSub;
        MdiEntryVitalityImage addSub = headerEntry.addVitalityImage("image.sidebar.subs.add");
        if (addSub != null) {
            addSub.setToolTip(MessageText.getString("subscriptions.add.tooltip"));
            addSub.addListener(new MdiEntryVitalityImageListener(){

                public void mdiEntryVitalityImage_clicked(int x, int y) {
                    new SubscriptionWizard();
                    COConfigurationManager.setParameter("subscriptions.wizard.shown", true);
                    SubscriptionManagerUI.this.refreshTitles(SubscriptionManagerUI.this.mdiEntryOverview);
                }
            });
        }
        if ((warnSub = headerEntry.addVitalityImage(ALERT_IMAGE_ID)) != null) {
            warnSub.setVisible(false);
        }
        if ((infoSub = headerEntry.addVitalityImage(INFO_IMAGE_ID)) != null) {
            infoSub.setVisible(false);
        }
        headerEntry.setViewTitleInfo(new ViewTitleInfo(){
            private long last_avail_calc = -1L;
            private int last_avail;

            public Object getTitleInfoProperty(int propertyID) {
                String result = null;
                if (propertyID == 0) {
                    boolean expanded = headerEntry.isExpanded();
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    Subscription[] subs = subs_man.getSubscriptions(true);
                    if (expanded) {
                        warnSub.setVisible(false);
                    } else {
                        int total = 0;
                        boolean warn = false;
                        String error_str = "";
                        for (Subscription s : subs) {
                            SubscriptionHistory history = s.getHistory();
                            total += history.getNumUnread();
                            String last_error = history.getLastError();
                            if (last_error == null || last_error.length() <= 0) continue;
                            boolean auth_fail = history.isAuthFail();
                            if (history.getConsecFails() < 3 && !auth_fail) continue;
                            warn = true;
                            if (error_str.length() > 128) {
                                if (error_str.endsWith(", ...")) continue;
                                error_str = error_str + ", ...";
                                continue;
                            }
                            error_str = error_str + (error_str.length() == 0 ? "" : ", ") + last_error;
                        }
                        warnSub.setVisible(warn);
                        warnSub.setToolTip(error_str);
                        if (total > 0) {
                            result = String.valueOf(total);
                        }
                    }
                    if (subs.length == 0 && !COConfigurationManager.getBooleanParameter("subscriptions.wizard.shown", false)) {
                        long now = SystemTime.getMonotonousTime();
                        if (this.last_avail_calc == -1L || now - this.last_avail_calc > 60000L) {
                            this.last_avail = subs_man.getKnownSubscriptionCount();
                            this.last_avail_calc = now;
                        }
                        if (this.last_avail > 0) {
                            infoSub.setVisible(true);
                            infoSub.setToolTip(MessageText.getString("subscriptions.info.avail", new String[]{String.valueOf(this.last_avail)}));
                        }
                    } else {
                        infoSub.setVisible(false);
                    }
                }
                return result;
            }
        });
    }

    private void registerAllSubscriptions() {
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        Subscription[] subs = subs_man.getSubscriptions(true);
        Arrays.sort(subs, new Comparator<Subscription>(){

            @Override
            public int compare(Subscription o1, Subscription o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (int i = 0; i < subs.length; ++i) {
            this.registerSubscriptionViewMdiEntry(subs[i], false);
        }
    }

    protected void changeSubscription(Subscription subs) {
        this.refreshTitles(this.mdiEntryOverview);
        if (subs.isSubscribed()) {
            String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null && mdi.getEntry(key) == null) {
                this.registerSubscriptionViewMdiEntry(subs, false);
            }
        } else {
            this.removeSubscription(subs);
        }
    }

    protected void registerSubscriptionViewMdiEntry(final Subscription subs, boolean show) {
        if (!subs.isSubscribed()) {
            return;
        }
        String name = subs.getName();
        if (name.startsWith("Search Template: ")) {
            return;
        }
        this.refreshColumns();
        String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        mdi.registerEntry(key, new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                return SubscriptionManagerUI.this.createSubscriptionMdiEntry(subs);
            }
        });
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (uiClassic && !show) {
            return;
        }
        mdi.loadEntryByID(key, show, true, subs);
    }

    private MdiEntry createSubscriptionMdiEntry(Subscription subs) {
        if (!subs.isSubscribed()) {
            return null;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        MdiEntry entry = mdi.createEntryFromEventListener("header.discovery", new UISWTViewEventListenerHolder(key, SubscriptionView.class, subs, null), key, true, subs, "Subscriptions");
        SubscriptionMDIEntry entryInfo = new SubscriptionMDIEntry(subs, entry);
        subs.setUserData(SUB_ENTRYINFO_KEY, entryInfo);
        return entry;
    }

    protected void refreshTitles(MdiEntry entry) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        while (entry != null) {
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
            String key = entry.getParentID();
            if (key == null) {
                return;
            }
            entry = mdi.getEntry(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(Subscription subs) {
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                mdi.closeEntry(key);
            }
        }
        this.refreshColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshColumns() {
        List<TableColumn> list = this.columns;
        synchronized (list) {
            for (TableColumn column : this.columns) {
                column.invalidateCells();
            }
        }
    }

    protected Graphic loadGraphic(UISWTInstance swt, String name) {
        Image image = swt.loadImage("com/aelitis/azureus/ui/images/" + name);
        UISWTGraphic graphic = swt.createGraphic(image);
        this.icon_list.add(graphic);
        return graphic;
    }
}

