/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;

public final class ImportExportUtils {
    public static final void exportString(Map map, String key, String value) throws IOException {
        if (value != null) {
            map.put(key, value.getBytes("UTF-8"));
        }
    }

    public static final void exportJSONString(Map map, String key, String value) throws IOException {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static final String importString(Map map, String key, String def) throws IOException {
        String res = ImportExportUtils.importString(map, key);
        if (res == null) {
            res = def;
        }
        return res;
    }

    public static final String importString(Map map, String key) throws IOException {
        if (map == null) {
            return null;
        }
        Object obj = map.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj, "UTF-8");
        }
        return null;
    }

    public static final long importLong(Map map, String key) throws IOException {
        return ImportExportUtils.importLong(map, key, 0L);
    }

    public static final long importLong(Map map, String key, long def) throws IOException {
        if (map == null) {
            return def;
        }
        Object obj = map.get(key);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        return def;
    }

    public static final void exportLong(Map map, String key, long value) {
        map.put(key, value);
    }

    public static final void exportInt(Map map, String key, int value) {
        map.put(key, new Long(value));
    }

    public static final int importInt(Map map, String key) throws IOException {
        return (int)ImportExportUtils.importLong(map, key, 0L);
    }

    public static final int importInt(Map map, String key, int def) throws IOException {
        return (int)ImportExportUtils.importLong(map, key, def);
    }

    public static final void exportFloat(Map map, String key, float value) throws IOException {
        ImportExportUtils.exportString(map, key, String.valueOf(value));
    }

    public static final float importFloat(Map map, String key, float def) throws IOException {
        String str = ImportExportUtils.importString(map, key);
        if (str == null) {
            return def;
        }
        return Float.parseFloat(str);
    }

    public static final void exportBoolean(Map map, String key, boolean value) throws IOException {
        map.put(key, new Long(value ? 1L : 0L));
    }

    public static final boolean importBoolean(Map map, String key) throws IOException {
        return ImportExportUtils.importBoolean(map, key, false);
    }

    public static final boolean importBoolean(Map map, String key, boolean def) throws IOException {
        if (map == null) {
            return def;
        }
        Object obj = map.get(key);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return def;
    }

    public static final void exportJSONBoolean(Map map, String key, boolean value) throws IOException {
        map.put(key, new Boolean(value));
    }

    public static final String importURL(Map map, String key) throws IOException {
        String url = ImportExportUtils.importString(map, key);
        if (url != null) {
            url = (url = url.trim()).length() == 0 ? null : URLDecoder.decode(url, "UTF-8");
        }
        return url;
    }

    public static final void exportURL(Map map, String key, String value) throws IOException {
        ImportExportUtils.exportString(map, key, value);
    }

    public static final void exportJSONURL(Map map, String key, String value) throws IOException {
        ImportExportUtils.exportJSONString(map, key, UrlUtils.encode(value));
    }

    public static final String[] importStringArray(Map map, String key) throws IOException {
        List list = (List)map.get(key);
        if (list == null) {
            return new String[0];
        }
        String[] res = new String[list.size()];
        for (int i = 0; i < res.length; ++i) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                res[i] = (String)obj;
                continue;
            }
            if (!(obj instanceof byte[])) continue;
            res[i] = new String((byte[])obj, "UTF-8");
        }
        return res;
    }

    public static final void exportStringArray(Map map, String key, String[] data) throws IOException {
        ArrayList<byte[]> l = new ArrayList<byte[]>(data.length);
        map.put(key, l);
        for (int i = 0; i < data.length; ++i) {
            l.add(data[i].getBytes("UTF-8"));
        }
    }

    public static final void exportJSONStringArray(Map map, String key, String[] data) throws IOException {
        JSONArray l = new JSONArray(data.length);
        map.put(key, l);
        for (int i = 0; i < data.length; ++i) {
            l.add(data[i]);
        }
    }

    public static final void exportIntArray(Map map, String key, int[] values) {
        if (values == null) {
            return;
        }
        int num = values.length;
        byte[] bytes = new byte[num * 4];
        int pos = 0;
        for (int i = 0; i < num; ++i) {
            int v = values[i];
            bytes[pos++] = (byte)(v >>> 24);
            bytes[pos++] = (byte)(v >>> 16);
            bytes[pos++] = (byte)(v >>> 8);
            bytes[pos++] = (byte)v;
        }
        map.put(key, bytes);
    }

    public static final int[] importIntArray(Map map, String key) {
        byte[] bytes = (byte[])map.get(key);
        if (bytes == null) {
            return null;
        }
        int[] values = new int[bytes.length / 4];
        int pos = 0;
        for (int i = 0; i < values.length; ++i) {
            values[i] = ((bytes[pos++] & 0xFF) << 24) + ((bytes[pos++] & 0xFF) << 16) + ((bytes[pos++] & 0xFF) << 8) + (bytes[pos++] & 0xFF);
        }
        return values;
    }
}

