/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableGroupRowVisibilityRunner;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.tables.TableCellInplaceEditorListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableColumnOrTreeColumn;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewFilterCheck;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTFilter;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableTooltips;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_Common;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_EraseItem;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_PaintItem;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnSWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWTImpl<DATASOURCETYPE>
extends TableViewImpl<DATASOURCETYPE>
implements ParameterListener,
TableViewSWT<DATASOURCETYPE>,
ObfusticateImage,
MessageText.MessageTextListener {
    protected static final boolean DRAW_VERTICAL_LINES = Constants.isWindows;
    protected static final boolean DRAW_FULL_ROW = Constants.isWindows;
    private static final LogIDs LOGID = LogIDs.GUI;
    protected static final boolean DEBUG_CELL_CHANGES = false;
    private static final boolean DEBUG_ROWCHANGE = false;
    private static final boolean OBEY_COLUMN_MINWIDTH = false;
    protected String sDefaultSortOn;
    protected boolean bSkipFirstColumn = true;
    private Point ptIconSize = null;
    private Composite mainComposite;
    private Composite tableComposite;
    private TableOrTreeSWT table;
    private ControlEditor editor;
    protected int iTableStyle;
    private Menu menu;
    protected int loopFactor;
    protected int graphicsUpdate = configMan.getIntParameter("Graphics Update");
    protected int reOrderDelay = configMan.getIntParameter("ReOrder Delay");
    private ColumnMoveListener columnMoveListener = new ColumnMoveListener();
    private boolean bEnableTabViews = false;
    private boolean tabViewsExpandedByDefault = true;
    private TableRowSWT[] visibleRows;
    private boolean[] columnsVisible;
    private TableViewSWTPanelCreator mainPanelCreator;
    private boolean columnPaddingAdjusted = false;
    private boolean columnVisibilitiesChanged = true;
    protected Rectangle clientArea;
    private boolean isVisible;
    private int lastHorizontalPos;
    private boolean useTree;
    protected int headerHeight;
    private Shell shell;
    private TableViewSWT_Common tvSWTCommon;
    private TableViewSWT_TabsCommon tvTabsCommon;
    private SourceReplaceListener cellEditNotifier;
    private Control sliderArea;
    private boolean isDragging;
    private int maxItemShown = -1;

    public TableViewSWTImpl(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        super(pluginDataSourceType, _sTableID, _sPropertiesPrefix, _basicItems);
        this.setProvideIndexesOnRemove(true);
        boolean wantTree = (_iTableStyle & 0x40) != 0;
        _iTableStyle &= 0xFFFFFFBF;
        if (wantTree) {
            this.useTree = COConfigurationManager.getBooleanParameter("Table.useTree") && !Utils.isCarbon;
        }
        this.sDefaultSortOn = _sDefaultSortOn;
        this.iTableStyle = _iTableStyle | 0x200 | 0x20000000;
        this.tvSWTCommon = new TableViewSWT_Common(this){

            public void mouseDown(TableRowSWT row, TableCellCore cell, int button, int stateMask) {
                if (row != null && !row.isRowDisposed()) {
                    this.tv.setRowSelected(row, true, true);
                }
            }

            public void widgetSelected(SelectionEvent event2) {
                TableViewSWTImpl.this.updateSelectedRows(TableViewSWTImpl.this.table.getSelection(), true);
            }

            public void keyReleased(KeyEvent e) {
                TableViewSWTImpl.this.swt_calculateClientArea();
                TableViewSWTImpl.this.visibleRowsChanged();
                super.keyReleased(e);
            }
        };
    }

    public TableViewSWTImpl(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, String _sDefaultSortOn) {
        this(pluginDataSourceType, _sTableID, _sPropertiesPrefix, new TableColumnCore[0], _sDefaultSortOn, 0x10010004);
    }

    @Override
    public void initialize(Composite composite) {
        this.initialize(null, composite);
    }

    @Override
    public void initialize(UISWTView parentView, Composite composite) {
        composite.setRedraw(false);
        this.tvTabsCommon = new TableViewSWT_TabsCommon(parentView, this);
        this.shell = composite.getShell();
        this.mainComposite = this.tvTabsCommon.createSashForm(composite);
        this.tableComposite = this.tvTabsCommon.tableComposite;
        this.table = this.createTable(this.tableComposite);
        this.menu = this.createMenu(this.table);
        this.clientArea = this.table.getClientArea();
        this.editor = TableOrTreeUtils.createTableOrTreeEditor(this.table);
        this.editor.minimumWidth = 80;
        this.editor.grabHorizontal = true;
        this.initializeTable(this.table);
        this.triggerLifeCycleListener(0);
        configMan.addParameterListener("Graphics Update", this);
        configMan.addParameterListener("ReOrder Delay", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.tableID).addListener(this);
        composite.setRedraw(true);
    }

    @Override
    public Composite createMainPanel(Composite composite) {
        TableViewSWTPanelCreator mainPanelCreator = this.getMainPanelCreator();
        if (mainPanelCreator != null) {
            return mainPanelCreator.createTableViewPanel(composite);
        }
        Composite panel = new Composite(composite, 524288);
        composite.getLayout();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        Layout parentLayout = composite.getLayout();
        if (parentLayout == null || parentLayout instanceof GridLayout) {
            panel.setLayoutData((Object)new GridData(1808));
        }
        return panel;
    }

    public TableOrTreeSWT createTable(Composite panel) {
        this.table = TableOrTreeUtils.createGrid(panel, this.iTableStyle, this.useTree);
        this.table.setLayoutData(new GridData(1808));
        return this.table;
    }

    public void initializeTable(final TableOrTreeSWT table) {
        ScrollBar horizontalBar;
        this.iTableStyle = table.getStyle();
        if ((this.iTableStyle & 0x10000000) == 0) {
            throw new Error("Virtual Table Required");
        }
        table.setLinesVisible(Utils.TABLE_GRIDLINE_IS_ALTERNATING_COLOR);
        table.setMenu(this.menu);
        table.setData("Name", this.tableID);
        table.setData("ObfusticateImage", this);
        table.setFont(table.getFont());
        table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event2) {
                TableViewSWTImpl.this.swt_changeColumnIndicator();
                table.setRedraw(false);
                table.setRedraw(true);
                table.removePaintListener(this);
            }
        });
        table.addListener(42, new TableViewSWT_PaintItem(this, table));
        if (Constants.isWindows) {
            TableViewSWT_EraseItem eraseItemListener = new TableViewSWT_EraseItem(this, table);
            table.addListener(40, eraseItemListener);
            table.addListener(9, eraseItemListener);
        }
        if ((horizontalBar = table.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.swt_calculateClientArea();
                        }
                    });
                }

                public void widgetSelected(SelectionEvent e) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.swt_calculateClientArea();
                        }
                    });
                }
            });
        }
        table.addListener(41, new Listener(){

            public void handleEvent(Event event2) {
                int defaultHeight;
                int iColumnNo = event2.index;
                if (TableViewSWTImpl.this.bSkipFirstColumn) {
                    --iColumnNo;
                }
                TableColumnCore[] columnsOrdered = TableViewSWTImpl.this.getVisibleColumns();
                if (iColumnNo >= 0 && iColumnNo < columnsOrdered.length) {
                    int preferredWidth;
                    TableColumnCore tc = columnsOrdered[iColumnNo];
                    event2.width = preferredWidth = tc.getPreferredWidth();
                }
                if (event2.height < (defaultHeight = TableViewSWTImpl.this.getRowDefaultHeight())) {
                    event2.height = defaultHeight;
                }
            }
        });
        table.addMouseListener(this.tvSWTCommon);
        table.addMouseMoveListener(this.tvSWTCommon);
        table.addSelectionListener(this.tvSWTCommon);
        table.addListener(39, new Listener(){

            public void handleEvent(Event e) {
                TableViewSWTImpl.this.tableInvalidate();
            }
        });
        if (this.useTree) {
            Listener listenerExpandCollapse = new Listener(){

                public void handleEvent(Event event2) {
                    TableItemOrTreeItem item = TableOrTreeUtils.getEventItem(event2.item);
                    if (item == null) {
                        return;
                    }
                    TableRowCore row = TableViewSWTImpl.this.getRow(item);
                    if (row == null || row.isRowDisposed()) {
                        return;
                    }
                    row.setExpanded(event2.type == 17);
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.visibleRowsChanged();
                        }
                    });
                }
            };
            table.addListener(17, listenerExpandCollapse);
            table.addListener(18, listenerExpandCollapse);
        }
        new TableTooltips(this, table.getComposite());
        table.addKeyListener(this.tvSWTCommon);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableViewSWTFilter<?> filter2 = TableViewSWTImpl.this.getSWTFilter();
                if (filter2 != null && filter2.widget != null && !filter2.widget.isDisposed()) {
                    filter2.widget.removeKeyListener((KeyListener)TableViewSWTImpl.this.tvSWTCommon);
                    filter2.widget.removeModifyListener(filter2.widgetModifyListener);
                }
                Utils.disposeSWTObjects(new Object[]{TableViewSWTImpl.this.sliderArea});
            }
        });
        ScrollBar bar = table.getVerticalBar();
        if (bar != null) {
            bar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.swt_calculateClientArea();
                            TableViewSWTImpl.this.visibleRowsChanged();
                        }
                    });
                    if (!table.isFocusControl()) {
                        table.setFocus();
                    }
                }
            });
        }
        table.setHeaderVisible(this.getHeaderVisible());
        this.headerHeight = table.getHeaderHeight();
        this.clientArea = table.getClientArea();
        table.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                TableViewSWTImpl.this.swt_calculateClientArea();
            }
        });
        this.swt_initializeTableColumns(table);
        MessageText.addListener(this);
    }

    @Override
    public void localeChanged(Locale old_locale, Locale new_locale) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.tvTabsCommon != null) {
                    TableViewSWTImpl.this.tvTabsCommon.localeChanged();
                }
                TableViewSWTImpl.this.tableInvalidate();
                TableViewSWTImpl.this.refreshTable(true);
                TableColumnOrTreeColumn[] tableColumnsSWT = TableViewSWTImpl.this.table.getColumns();
                for (int i = 0; i < tableColumnsSWT.length; ++i) {
                    TableColumnCore column = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                    if (column == null) continue;
                    Messages.setLanguageText((Widget)tableColumnsSWT[i].getColumn(), column.getTitleLanguageKey());
                }
            }
        });
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        super.setHeaderVisible(visible);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.table != null && !TableViewSWTImpl.this.table.isDisposed()) {
                    TableViewSWTImpl.this.table.setHeaderVisible(TableViewSWTImpl.this.getHeaderVisible());
                    TableViewSWTImpl.this.headerHeight = TableViewSWTImpl.this.table.getHeaderHeight();
                }
            }
        });
    }

    protected void swt_calculateClientArea() {
        int pos;
        Rectangle oldClientArea = this.clientArea;
        this.clientArea = this.table.getClientArea();
        ScrollBar horizontalBar = this.table.getHorizontalBar();
        boolean clientAreaCausedVisibilityChanged = false;
        if (horizontalBar != null && (pos = horizontalBar.getSelection()) != this.lastHorizontalPos) {
            this.lastHorizontalPos = pos;
            clientAreaCausedVisibilityChanged = true;
        }
        if (oldClientArea != null && (oldClientArea.x != this.clientArea.x || oldClientArea.width != this.clientArea.width)) {
            clientAreaCausedVisibilityChanged = true;
        }
        if (oldClientArea != null && (oldClientArea.y != this.clientArea.y || oldClientArea.height != this.clientArea.height)) {
            this.visibleRowsChanged();
        }
        if (oldClientArea != null && oldClientArea.height < this.table.getHeaderHeight()) {
            clientAreaCausedVisibilityChanged = true;
        }
        if (clientAreaCausedVisibilityChanged) {
            this.columnVisibilitiesChanged = true;
            Utils.execSWTThreadLater(50, new AERunnable(){

                public void runSupport() {
                    if (TableViewSWTImpl.this.columnVisibilitiesChanged) {
                        TableViewSWTImpl.this.refreshTable(false);
                    }
                }
            });
        }
    }

    @Override
    public void triggerTabViewsDataSourceChanged(boolean sendParent) {
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.triggerTabViewsDataSourceChanged(sendParent);
        }
    }

    @Override
    public void editCell(final TableColumnCore column, final int row) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_editCell(column, row);
            }
        });
    }

    private void swt_editCell(final TableColumnCore column, final int row) {
        Text oldInput = (Text)this.editor.getEditor();
        if (row < 0 || row >= this.table.getItemCount()) {
            this.cellEditNotifier = null;
            if (oldInput != null && !oldInput.isDisposed()) {
                this.editor.getEditor().dispose();
            }
            return;
        }
        final TableItemOrTreeItem item = this.table.getItem(row);
        String cellName = column.getName();
        final TableRowSWT rowSWT = (TableRowSWT)this.getRow(row);
        final TableCellSWT cell = rowSWT.getTableCellSWT(cellName);
        final Text newInput = oldInput == null || oldInput.isDisposed() ? new Text(this.table.getComposite(), Constants.isOSX ? 0 : 2048) : oldInput;
        final Object datasource = cell.getDataSource();
        if (this.cellEditNotifier != null) {
            this.cellEditNotifier.cleanup(newInput);
        }
        this.table.showItem(item);
        this.showColumn(column);
        TableColumnOrTreeColumn swtColumn = this.getSWTColumn(column);
        final int swtColumnNo = this.table.indexOf(swtColumn);
        newInput.setText(cell.getText());
        newInput.setSelection(0);
        newInput.selectAll();
        newInput.setFocus();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class QuickEditListener
        implements ModifyListener,
        SelectionListener,
        KeyListener,
        TraverseListener,
        SourceReplaceListener,
        ControlListener {
            boolean resizing = true;

            public QuickEditListener(Text toAttach) {
                toAttach.addModifyListener((ModifyListener)this);
                toAttach.addSelectionListener((SelectionListener)this);
                toAttach.addKeyListener((KeyListener)this);
                toAttach.addTraverseListener((TraverseListener)this);
                toAttach.addControlListener((ControlListener)this);
                TableViewSWTImpl.this.cellEditNotifier = this;
            }

            public void modifyText(ModifyEvent e) {
                if (item.isDisposed()) {
                    this.sourcesChanged();
                    return;
                }
                TableColumnCore columnCore = (TableColumnCore)cell.getTableColumn();
                TableCellInplaceEditorListener inplaceEditorListener = columnCore.getInplaceEditorListener();
                if (inplaceEditorListener != null && inplaceEditorListener.inplaceValueSet(cell, newInput.getText(), false)) {
                    newInput.setBackground(null);
                } else {
                    newInput.setBackground(Colors.colorErrorBG);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (item.isDisposed()) {
                    this.sourcesChanged();
                    newInput.traverse(4);
                    return;
                }
                TableColumnCore columnCore = (TableColumnCore)cell.getTableColumn();
                TableCellInplaceEditorListener inplaceEditorListener = columnCore.getInplaceEditorListener();
                if (inplaceEditorListener != null) {
                    inplaceEditorListener.inplaceValueSet(cell, newInput.getText(), true);
                }
                rowSWT.invalidate();
                TableViewSWTImpl.this.editCell(column, row + 1);
            }

            public void widgetSelected(SelectionEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    e.doit = false;
                    TableViewSWTImpl.this.editCell(column, row + (e.keyCode == 0x1000002 ? 1 : -1));
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                    TableViewSWTImpl.this.editCell(column, -1);
                }
            }

            @Override
            public void sourcesChanged() {
                if (TableViewSWTImpl.this.getRow(datasource) == rowSWT || TableViewSWTImpl.this.getRow(datasource) == null || newInput.isDisposed()) {
                    return;
                }
                String newVal = newInput.getText();
                Point sel = newInput.getSelection();
                TableViewSWTImpl.this.editCell(column, TableViewSWTImpl.this.getRow(datasource).getIndex());
                if (newInput.isDisposed()) {
                    return;
                }
                newInput.setText(newVal);
                newInput.setSelection(sel);
            }

            @Override
            public void cleanup(Text oldText) {
                if (!oldText.isDisposed()) {
                    oldText.removeModifyListener((ModifyListener)this);
                    oldText.removeSelectionListener((SelectionListener)this);
                    oldText.removeKeyListener((KeyListener)this);
                    oldText.removeTraverseListener((TraverseListener)this);
                    oldText.removeControlListener((ControlListener)this);
                }
            }

            public void controlMoved(ControlEvent e) {
                TableViewSWTImpl.this.table.showItem(item);
                if (this.resizing) {
                    return;
                }
                this.resizing = true;
                Point sel = newInput.getSelection();
                TableOrTreeUtils.setEditorItem(TableViewSWTImpl.this.editor, (Control)newInput, swtColumnNo, item);
                ((TableViewSWTImpl)TableViewSWTImpl.this).editor.minimumWidth = newInput.computeSize((int)-1, (int)-1).x;
                Rectangle leftAlignedBounds = item.getBounds(swtColumnNo);
                leftAlignedBounds.width = ((TableViewSWTImpl)TableViewSWTImpl.this).editor.minimumWidth = newInput.computeSize((int)-1, (int)-1).x;
                ((TableViewSWTImpl)TableViewSWTImpl.this).editor.horizontalAlignment = leftAlignedBounds.intersection(TableViewSWTImpl.this.clientArea).equals((Object)leftAlignedBounds) ? 16384 : 131072;
                TableViewSWTImpl.this.editor.layout();
                newInput.setSelection(0);
                newInput.setSelection(sel);
                this.resizing = false;
            }

            public void controlResized(ControlEvent e) {
            }
        }
        QuickEditListener l = new QuickEditListener(newInput);
        l.modifyText(null);
        TableOrTreeUtils.setEditorItem(this.editor, (Control)newInput, swtColumnNo, item);
        this.table.deselectAll();
        this.table.select(this.table.getItem(row));
        this.setSelectedRows(new TableRowCore[]{this.getRow(row)}, true);
        l.resizing = false;
        l.controlMoved(null);
    }

    private TableColumnOrTreeColumn getSWTColumn(TableColumnCore tc) {
        int[] columnOrder = this.table.getColumnOrder();
        int i = tc.getPosition() - (this.bSkipFirstColumn ? 1 : 0);
        if (i < 0 || i >= columnOrder.length) {
            return null;
        }
        return this.table.getColumn(columnOrder[i]);
    }

    private void showColumn(TableColumnCore tc) {
        TableColumnOrTreeColumn swtColumn = this.getSWTColumn(tc);
        if (swtColumn != null) {
            this.table.showColumn(swtColumn);
        }
    }

    private void swt_updateColumnVisibilities(boolean doInvalidate) {
        TableColumnOrTreeColumn[] columns = this.table.getColumns();
        if (this.table.getItemCount() < 1 || columns.length == 0 || !this.table.isVisible()) {
            return;
        }
        this.columnVisibilitiesChanged = false;
        TableItemOrTreeItem topRow = this.table.getTopItem();
        if (topRow == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            boolean nowVisible;
            int position;
            final TableColumnCore tc = (TableColumnCore)columns[i].getData("TableColumnCore");
            if (tc == null || (position = tc.getPosition()) < 0 || position >= this.columnsVisible.length) continue;
            Rectangle size = topRow.getBounds(i);
            size.intersect(this.clientArea);
            boolean bl = nowVisible = !size.isEmpty();
            if (this.columnsVisible[position] == nowVisible) continue;
            this.columnsVisible[position] = nowVisible;
            if (!nowVisible || !doInvalidate) continue;
            this.swt_runForVisibleRows(new TableGroupRowRunner(){

                public void run(TableRowCore row) {
                    TableCellCore cell = row.getTableCellCore(tc.getName());
                    if (cell != null) {
                        cell.invalidate();
                        cell.redraw();
                    }
                }
            });
        }
    }

    @Override
    public boolean isColumnVisible(TableColumn column) {
        int position = column.getPosition();
        if (position < 0 || position >= this.columnsVisible.length) {
            return false;
        }
        return this.columnsVisible[position];
    }

    protected void swt_initializeTableColumns(final TableOrTreeSWT table) {
        TableColumnCore tc;
        int i;
        TableColumnOrTreeColumn[] oldColumns = table.getColumns();
        for (i = 0; i < oldColumns.length; ++i) {
            oldColumns[i].removeListener(10, this.columnMoveListener);
        }
        for (i = oldColumns.length - 1; i >= 0; --i) {
            oldColumns[i].dispose();
        }
        this.columnPaddingAdjusted = false;
        ControlAdapter resizeListener = new ControlAdapter(){
            private boolean bInFunction = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void controlResized(ControlEvent e) {
                TableColumnOrTreeColumn column = TableOrTreeUtils.getTableColumnEventItem(e.widget);
                if (column == null || column.isDisposed() || this.bInFunction) {
                    return;
                }
                try {
                    this.bInFunction = true;
                    TableColumnCore tc = (TableColumnCore)column.getData("TableColumnCore");
                    if (tc != null) {
                        Long lPadding = (Long)column.getData("widthOffset");
                        int padding = lPadding == null ? 0 : lPadding.intValue();
                        int newWidth = column.getWidth();
                        tc.setWidth(newWidth - padding);
                    }
                    int columnNumber = table.indexOf(column);
                    TableViewSWTImpl.this.locationChanged(columnNumber);
                    Object var8_8 = null;
                    this.bInFunction = false;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.bInFunction = false;
                    throw throwable;
                }
            }
        };
        if (this.bSkipFirstColumn) {
            TableColumnOrTreeColumn tc2 = table.createNewColumn(0);
            tc2.setWidth(0);
            tc2.setResizable(false);
            tc2.setMoveable(false);
        }
        TableColumnCore[] tableColumns = this.getAllColumns();
        TableColumnCore[] tmpColumnsOrdered = new TableColumnCore[tableColumns.length];
        int columnOrderPos = 0;
        Arrays.sort(tableColumns, TableColumnManager.getTableColumnOrderComparator());
        for (int i2 = 0; i2 < tableColumns.length; ++i2) {
            int position = tableColumns[i2].getPosition();
            if (position == -1 || !tableColumns[i2].isVisible()) continue;
            table.createNewColumn(0);
            tmpColumnsOrdered[columnOrderPos++] = tableColumns[i2];
        }
        int numSWTColumns = table.getColumnCount();
        int iNewLength = numSWTColumns - (this.bSkipFirstColumn ? 1 : 0);
        TableColumnCore[] columnsOrdered = new TableColumnCore[iNewLength];
        System.arraycopy(tmpColumnsOrdered, 0, columnsOrdered, 0, iNewLength);
        this.setColumnsOrdered(columnsOrdered);
        this.columnsVisible = new boolean[tableColumns.length];
        ColumnSelectionListener columnSelectionListener = new ColumnSelectionListener();
        int swtColumnPos = this.bSkipFirstColumn ? 1 : 0;
        for (int i3 = 0; i3 < tableColumns.length; ++i3) {
            TableColumnCore columnCore = tableColumns[i3];
            int position = columnCore.getPosition();
            if (position == -1 || !columnCore.isVisible()) continue;
            this.columnsVisible[i3] = false;
            String sName = columnCore.getName();
            if (swtColumnPos >= numSWTColumns) {
                Debug.out("Incorrect table column setup, skipping column '" + sName + "', position=" + swtColumnPos + ";numCols=" + numSWTColumns);
                continue;
            }
            TableColumnOrTreeColumn column = table.getColumn(swtColumnPos);
            try {
                column.setMoveable(true);
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            column.setAlignment(TableColumnSWTUtils.convertColumnAlignmentToSWT(columnCore.getAlignment()));
            String iconReference = columnCore.getIconReference();
            if (iconReference != null) {
                Image image = ImageLoader.getInstance().getImage(iconReference);
                column.setImage(image);
            } else {
                Messages.setLanguageText((Widget)column.getColumn(), columnCore.getTitleLanguageKey());
            }
            if (!Constants.isUnix && !Utils.isCarbon) {
                column.setWidth(columnCore.getWidth());
            } else {
                column.setData("widthOffset", new Long(1L));
                column.setWidth(columnCore.getWidth() + 1);
            }
            if (columnCore.getMinWidth() == columnCore.getMaxWidth() && columnCore.getMinWidth() > 0) {
                column.setResizable(false);
            }
            column.setData("TableColumnCore", columnCore);
            column.setData("configName", "Table." + this.tableID + "." + sName);
            column.setData("Name", sName);
            column.addControlListener((ControlListener)resizeListener);
            column.addListener(13, columnSelectionListener);
            ++swtColumnPos;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String sSortColumn = tcManager.getDefaultSortColumnName(this.tableID);
        if (sSortColumn == null || sSortColumn.length() == 0) {
            sSortColumn = this.sDefaultSortOn;
        }
        if ((tc = tcManager.getTableColumnCore(this.tableID, sSortColumn)) == null && tableColumns.length > 0) {
            tc = tableColumns[0];
        }
        this.setSortColumn(tc, false);
        this.fixAlignment(tc, true);
        this.swt_changeColumnIndicator();
        TableColumnOrTreeColumn[] columns = table.getColumns();
        for (int i4 = 0; i4 < columns.length; ++i4) {
            TableColumnOrTreeColumn column = columns[i4];
            column.addListener(10, this.columnMoveListener);
        }
        this.columnVisibilitiesChanged = true;
    }

    public void fixAlignment(TableColumnCore tc, boolean sorted) {
        if (Constants.isOSX) {
            if (this.table.isDisposed() || tc == null) {
                return;
            }
            int[] columnOrder = this.table.getColumnOrder();
            int i = tc.getPosition() - (this.bSkipFirstColumn ? 1 : 0);
            if (i < 0 || i >= columnOrder.length) {
                return;
            }
            TableColumnOrTreeColumn swtColumn = this.table.getColumn(columnOrder[i]);
            if (swtColumn != null) {
                if (swtColumn.getAlignment() == 131072 && sorted) {
                    swtColumn.setText("   " + swtColumn.getText() + "   ");
                } else {
                    swtColumn.setText(swtColumn.getText().trim());
                }
            }
        }
    }

    private Menu createMenu(final TableOrTreeSWT table) {
        if (!this.isMenuEnabled()) {
            return null;
        }
        final Menu menu = new Menu((Decorations)this.shell, 8);
        table.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                boolean inHeader;
                Point pt = event2.display.map(null, (Control)table.getComposite(), new Point(event2.x, event2.y));
                boolean noRow = table.getItem(pt) == null;
                Rectangle clientArea = table.getClientArea();
                boolean bl = inHeader = clientArea.y <= pt.y && pt.y < clientArea.y + TableViewSWTImpl.this.headerHeight;
                if (!noRow) {
                    noRow = inHeader;
                }
                menu.setData("inBlankArea", (Object)(!inHeader && noRow ? 1 : 0));
                menu.setData("isHeader", (Object)new Boolean(noRow));
                menu.setData("column", (Object)TableViewSWTImpl.this.getTableColumnByOffset(event2.x));
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                Object oIsHeader = menu.getData("isHeader");
                boolean isHeader = oIsHeader instanceof Boolean ? (Boolean)oIsHeader : false;
                Object oInBlankArea = menu.getData("inBlankArea");
                boolean inBlankArea = oInBlankArea instanceof Boolean ? (Boolean)oInBlankArea : false;
                TableColumnCore column = (TableColumnCore)menu.getData("column");
                if (isHeader) {
                    TableViewSWTImpl.this.tvSWTCommon.fillColumnMenu(menu, column, inBlankArea);
                } else {
                    TableViewSWTImpl.this.tvSWTCommon.fillMenu(menu, column);
                }
            }
        });
        return menu;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public Composite getTableComposite() {
        return this.tableComposite;
    }

    @Override
    public TableOrTreeSWT getTableOrTreeSWT() {
        return this.table;
    }

    @Override
    public void refreshTable(final boolean bForceSort) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_refreshTable(bForceSort);
                if (TableViewSWTImpl.this.tvTabsCommon != null) {
                    TableViewSWTImpl.this.tvTabsCommon.swt_refresh();
                }
            }
        });
        super.refreshTable(bForceSort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_refreshTable(boolean bForceSort) {
        if (this.table == null) {
            return;
        }
        this.isVisible();
        try {
            long lTimeDiff;
            boolean bWillSort;
            block11: {
                block10: {
                    if (this.getComposite() == null) break block10;
                    if (!this.getComposite().isDisposed()) break block11;
                }
                Object var9_2 = null;
                return;
            }
            if (this.columnVisibilitiesChanged) {
                this.swt_updateColumnVisibilities(true);
            }
            final boolean bDoGraphics = this.loopFactor % this.graphicsUpdate == 0;
            boolean bl = bWillSort = bForceSort || this.reOrderDelay != 0 && this.loopFactor % this.reOrderDelay == 0;
            if (bWillSort) {
                TableColumnCore sortColumn = this.getSortColumn();
                if (bForceSort && sortColumn != null) {
                    this.resetLastSortedOn();
                    sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
                }
                this._sortColumn(true, false, false);
            }
            long lTimeStart = SystemTime.getMonotonousTime();
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    TableViewSWTImpl.this.runForAllRows(new TableGroupRowVisibilityRunner(){

                        public void run(TableRowCore row, boolean bVisible) {
                            row.refresh(bDoGraphics, bVisible);
                        }
                    });
                }
            });
            if (TableViewImpl.DEBUGADDREMOVE && (lTimeDiff = SystemTime.getMonotonousTime() - lTimeStart) > 500L) {
                this.debug(lTimeDiff + "ms to refresh rows");
            }
            ++this.loopFactor;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            throw throwable;
        }
        Object var9_3 = null;
    }

    private void swt_refreshVisibleRows() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.swt_runForVisibleRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                row.refresh(false, true);
            }
        });
    }

    private void locationChanged(final int iStartColumn) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.columnVisibilitiesChanged = true;
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                row.locationChanged(iStartColumn);
            }
        });
    }

    @Override
    public void delete() {
        this.triggerLifeCycleListener(1);
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.delete();
            this.tvTabsCommon = null;
        }
        TableStructureEventDispatcher.getInstance(this.tableID).removeListener(this);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager != null) {
            tcManager.saveTableColumns(this.getDataSourceType(), this.tableID);
        }
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.removeAllTableRows();
        configMan.removeParameterListener("ReOrder Delay", this);
        configMan.removeParameterListener("Graphics Update", this);
        Colors.getInstance().removeColorsChangedListener(this);
        super.delete();
        Composite comp2 = this.getComposite();
        if (comp2 != null && !comp2.isDisposed()) {
            comp2.dispose();
        }
        MessageText.removeListener(this);
    }

    private void addDataSourcesToSWT(final Object[] dataSources, boolean async) {
        try {
            if (this.isDisposed()) {
                return;
            }
            if (DEBUGADDREMOVE) {
                this.debug("-- Add " + dataSources.length + " rows to SWT " + (async ? " async " : " NOW"));
            }
            if (async) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this._addDataSourcesToSWT(dataSources);
                    }
                });
            } else {
                Utils.execSWTThread((Runnable)new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this._addDataSourcesToSWT(dataSources);
                    }
                }, false);
            }
            for (int i = 0; i < dataSources.length; ++i) {
                TableCellCore cell;
                Object dataSource = dataSources[i];
                if (dataSource == null) continue;
                TableRowCore row = this.getRow(dataSource);
                TableColumnCore sortColumn = this.getSortColumn();
                if (row == null || sortColumn == null || (cell = row.getSortColumnCell(sortColumn.getName())) == null) continue;
                try {
                    cell.invalidate();
                    cell.refresh(true);
                    continue;
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + this.tableID, e));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _addDataSourcesToSWT(Object[] dataSources) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        this.mainComposite.getParent().setCursor(this.table.getDisplay().getSystemCursor(1));
        TableRowCore[] selectedRows = this.getSelectedRows();
        boolean bWas0Rows = this.table.getItemCount() == 0;
        try {
            if (DEBUGADDREMOVE) {
                this.debug("-- Add " + dataSources.length + " rows to SWT. size(false) == " + this.size(false));
            }
            int size = this.size(false);
            this.table.setItemCount(size);
            if (size == 1) {
                this.columnVisibilitiesChanged = true;
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error while adding row to Table " + this.tableID, e));
        }
        if (!this.columnPaddingAdjusted && this.table.getItemCount() > 0 && bWas0Rows) {
            TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
            TableItemOrTreeItem item = this.table.getItem(0);
            int len = Constants.isUnix ? tableColumnsSWT.length - 1 : tableColumnsSWT.length;
            for (int i = 0; i < len; ++i) {
                TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                if (tc == null) continue;
                boolean foundOne = false;
                Rectangle bounds = item.getBounds(i);
                int tcWidth = tc.getWidth();
                if (tcWidth != 0 && bounds.width != 0) {
                    Object oOldOfs = tableColumnsSWT[i].getData("widthOffset");
                    int oldOfs = oOldOfs instanceof Number ? ((Number)oOldOfs).intValue() : 0;
                    int ofs = tc.getWidth() - bounds.width + oldOfs;
                    if (ofs > 0 && ofs != oldOfs) {
                        foundOne = true;
                        tableColumnsSWT[i].setResizable(true);
                        tableColumnsSWT[i].setData("widthOffset", new Long(ofs + oldOfs));
                    }
                }
                if (!foundOne) continue;
                tc.triggerColumnSizeChange(0);
            }
            this.columnPaddingAdjusted = true;
        }
        if (bWas0Rows) {
            this.swt_updateColumnVisibilities(false);
        }
        this.setSelectedRows(selectedRows);
        if (DEBUGADDREMOVE) {
            this.debug("<< " + this.size(false));
        }
        boolean bReplacedVisible = false;
        for (Object ds : dataSources) {
            TableRowCore row = this.getRow(ds);
            if (row == null) continue;
            int i = this.indexOf(row);
            int iTopIndex = this.uiGetTopIndex();
            int iBottomIndex = this.uiGetBottomIndex(iTopIndex);
            if (i < iTopIndex || i > iBottomIndex) continue;
            bReplacedVisible = true;
            break;
        }
        if (bReplacedVisible) {
            this.visibleRowsChanged();
        }
        this.mainComposite.getParent().setCursor(null);
    }

    @Override
    public void reallyAddDataSources(Object[] dataSources) {
        super.reallyAddDataSources(dataSources);
        this.addDataSourcesToSWT(dataSources, true);
    }

    @Override
    public void uiRemoveRows(TableRowCore[] rows, final Integer[] rowIndexes) {
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (TableViewSWTImpl.this.table == null || TableViewSWTImpl.this.table.isDisposed()) {
                    return;
                }
                TableViewSWTImpl.this.mainComposite.getParent().setCursor(TableViewSWTImpl.this.table.getDisplay().getSystemCursor(1));
                try {
                    int iTopIndex = TableViewSWTImpl.this.uiGetTopIndex();
                    int iBottomIndex = TableViewSWTImpl.this.uiGetBottomIndex(iTopIndex);
                    if (TableViewImpl.DEBUGADDREMOVE) {
                        TableViewSWTImpl.this.debug("--- Remove: vis rows " + iTopIndex + " to " + iBottomIndex);
                    }
                    boolean needRefresh = false;
                    for (Integer i : rowIndexes) {
                        if (i < iTopIndex || i > iBottomIndex) continue;
                        needRefresh = true;
                        break;
                    }
                    TableViewSWTImpl.this.table.setItemCount(TableViewSWTImpl.this.getRowCount());
                    TableViewSWTImpl.this.fillRowGaps(false);
                    if (needRefresh || iBottomIndex == TableViewSWTImpl.this.table.getItemCount() - 1) {
                        TableViewSWTImpl.this.table.redraw();
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    TableViewSWTImpl.this.mainComposite.getParent().setCursor(null);
                    throw throwable;
                }
                TableViewSWTImpl.this.mainComposite.getParent().setCursor(null);
            }
        });
    }

    @Override
    public void removeAllTableRows() {
        long lTimeDiff;
        long lTimeStart = System.currentTimeMillis();
        final TableRowCore[] rows = this.getRows();
        super.removeAllTableRows();
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewImpl.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug("removeAll (SWT)");
                }
                if (TableViewSWTImpl.this.table != null && !TableViewSWTImpl.this.table.isDisposed()) {
                    TableViewSWTImpl.this.table.removeAll();
                }
                for (int i = 0; i < rows.length; ++i) {
                    rows[i].delete();
                }
            }
        });
        if (DEBUGADDREMOVE && (lTimeDiff = System.currentTimeMillis() - lTimeStart) > 10L) {
            this.debug("RemovaAll took " + lTimeDiff + "ms");
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = configMan.getIntParameter("Graphics Update");
        }
        if (parameterName == null || parameterName.equals("ReOrder Delay")) {
            this.reOrderDelay = configMan.getIntParameter("ReOrder Delay");
        }
        if (parameterName == null || parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    @Override
    public void tableStructureChanged(final boolean columnAddedOrRemoved, Class forPluginDataSourceType) {
        if (forPluginDataSourceType == null || forPluginDataSourceType.equals(this.getDataSourceType())) {
            super.tableStructureChanged(columnAddedOrRemoved, forPluginDataSourceType);
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (TableViewSWTImpl.this.table.isDisposed()) {
                        return;
                    }
                    TableViewSWTImpl.this._tableStructureChanged(columnAddedOrRemoved);
                }
            });
        }
    }

    private void _tableStructureChanged(boolean columnAddedOrRemoved) {
        this.swt_initializeTableColumns(this.table);
        this.refreshTable(false);
        this.triggerLifeCycleListener(0);
    }

    @Override
    public void columnOrderChanged(final int[] positions) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    if (TableViewSWTImpl.this.table.isDisposed()) {
                        return;
                    }
                    TableViewSWTImpl.this.table.setColumnOrder(positions);
                    TableViewSWTImpl.this.swt_updateColumnVisibilities(true);
                }
                catch (NoSuchMethodError e) {
                    TableViewSWTImpl.this.tableStructureChanged(false, null);
                }
            }
        });
    }

    @Override
    public void columnSizeChanged(final TableColumnCore tableColumn, int diff) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_columnSizeChanged(tableColumn);
            }
        });
    }

    public void swt_columnSizeChanged(TableColumnCore tableColumn) {
        int newWidth = tableColumn.getWidth();
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableColumnOrTreeColumn column = null;
        TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            if (tableColumnsSWT[i].getData("TableColumnCore") != tableColumn) continue;
            column = tableColumnsSWT[i];
            break;
        }
        if (column == null) {
            return;
        }
        Long lOfs = (Long)column.getData("widthOffset");
        if (lOfs != null) {
            newWidth += lOfs.intValue();
        }
        this.swt_refreshVisibleRows();
        if (column.isDisposed() || column.getWidth() == newWidth) {
            return;
        }
        if (Constants.isUnix) {
            final int fNewWidth = newWidth;
            final TableColumnOrTreeColumn fTableColumn = column;
            column.getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!fTableColumn.isDisposed()) {
                        fTableColumn.setWidth(fNewWidth);
                    }
                }
            });
        } else {
            column.setWidth(newWidth);
        }
    }

    public void columnRefresh(TableColumnCore tableColumn) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.refresh(true, bVisible);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableRowCore getRow(TableItemOrTreeItem item) {
        if (item == null) {
            return null;
        }
        try {
            Object sortedRows_sync;
            Object o = item.getData("TableRow");
            if (o instanceof TableRowCore && !((TableRowCore)o).isRowDisposed()) {
                return (TableRowCore)o;
            }
            if (item.getParentItem() != null) {
                TableRowCore row = this.getRow(item.getParentItem());
                return row.linkSubItem(item.getParentItem().indexOf(item));
            }
            int iPos = this.table.indexOf(item);
            Object object = sortedRows_sync = this.getRowsSync();
            synchronized (object) {
                if (iPos >= 0 && iPos < this.getRowCount()) {
                    TableRowSWT row = (TableRowSWT)this.getRow(iPos);
                    if (row != null && !row.isRowDisposed()) {
                        row.setTableItem(iPos);
                        return row;
                    }
                    return null;
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRowSWT[] swt_getVisibleRows() {
        if (!this.isVisible()) {
            return new TableRowSWT[0];
        }
        TableViewSWTImpl tableViewSWTImpl = this;
        synchronized (tableViewSWTImpl) {
            if (this.visibleRows == null) {
                this.visibleRowsChanged();
            }
            return this.visibleRows;
        }
    }

    public void swt_runForVisibleRows(TableGroupRowRunner runner) {
        TableRowCore[] rows = this.swt_getVisibleRows();
        if (runner.run(rows)) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    public void runForTableItems(List<TableItemOrTreeItem> items, TableGroupRowRunner runner) {
        TableRowCore[] rows;
        boolean ran;
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        Iterator<TableItemOrTreeItem> iter = items.iterator();
        ArrayList<TableRowSWT> rows_to_use = new ArrayList<TableRowSWT>(items.size());
        while (iter.hasNext()) {
            TableRowSWT row;
            TableItemOrTreeItem tableItem = iter.next();
            if (tableItem.isDisposed() || (row = (TableRowSWT)this.getRow(tableItem)) == null || row.isRowDisposed()) continue;
            rows_to_use.add(row);
        }
        if (rows_to_use.size() > 0 && !(ran = runner.run(rows = rows_to_use.toArray(new TableRowCore[rows_to_use.size()])))) {
            for (int i = 0; i < rows.length; ++i) {
                TableRowCore row = rows[i];
                runner.run(row);
            }
        }
    }

    @Override
    public void clipboardSelected() {
        TableRowCore[] rows;
        String sToClipboard = "";
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            if (j != 0) {
                sToClipboard = sToClipboard + "\t";
            }
            sToClipboard = sToClipboard + this.table.getColumn(j).getText();
        }
        for (TableRowCore row : rows = this.getSelectedRows()) {
            sToClipboard = sToClipboard + "\n";
            TableColumnCore[] visibleColumns = this.getVisibleColumns();
            for (int j = 0; j < visibleColumns.length; ++j) {
                TableCellCore cell;
                TableColumnCore column = visibleColumns[j];
                if (!column.isVisible()) continue;
                if (j != 0) {
                    sToClipboard = sToClipboard + "\t";
                }
                if ((cell = row.getTableCellCore(column.getName())) == null) continue;
                sToClipboard = sToClipboard + cell.getClipboardText();
            }
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    @Override
    public TableRowCore getRow(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItemOrTreeItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            return null;
        }
        return this.getRow(item);
    }

    @Override
    public TableCellCore getTableCell(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItemOrTreeItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            item = this.table.getItem(new Point(x, y));
        }
        if (item == null) {
            return null;
        }
        TableRowSWT row = (TableRowSWT)this.getRow(item);
        if (row == null || row.isRowDisposed()) {
            return null;
        }
        TableColumnOrTreeColumn tcColumn = this.table.getColumn(iColumn);
        String sCellName = (String)tcColumn.getData("Name");
        if (sCellName == null) {
            return null;
        }
        return row.getTableCellCore(sCellName);
    }

    @Override
    public TableRowSWT getTableRow(int x, int y, boolean anyX) {
        TableItemOrTreeItem item = this.table.getItem(new Point(anyX ? 2 : x, y));
        if (item == null) {
            return null;
        }
        return (TableRowSWT)this.getRow(item);
    }

    private int getColumnNo(int iMouseX) {
        int iColumn = -1;
        int itemCount = this.table.getItemCount();
        if (this.table.getItemCount() > 0) {
            int i;
            TableItemOrTreeItem ti;
            int topIndex = this.table.getTopIndex();
            if (topIndex >= itemCount || topIndex < 0) {
                topIndex = itemCount - 1;
            }
            if ((ti = this.table.getItem(topIndex)).isDisposed()) {
                return -1;
            }
            int n = i = this.bSkipFirstColumn ? 1 : 0;
            while (i < this.table.getColumnCount()) {
                Rectangle cellBounds = ti.getBounds(i);
                if (iMouseX >= cellBounds.x && iMouseX < cellBounds.x + cellBounds.width && cellBounds.width > 0) {
                    iColumn = i;
                    break;
                }
                ++i;
            }
        }
        return iColumn;
    }

    @Override
    public TableColumnCore getTableColumnByOffset(int x) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableColumnOrTreeColumn column = this.table.getColumn(iColumn);
        return (TableColumnCore)column.getData("TableColumnCore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.generate(writer);
        }
        writer.println("Columns:");
        writer.indent();
        try {
            try {
                TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
                for (int i = 0; i < tableColumnsSWT.length; ++i) {
                    TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                    if (tc == null) continue;
                    writer.println(tc.getName() + ";w=" + tc.getWidth() + ";w-offset=" + tableColumnsSWT[i].getData("widthOffset"));
                }
                Object var6_6 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                writer.exdent();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public boolean getSkipFirstColumn() {
        return this.bSkipFirstColumn;
    }

    @Override
    public void setRowDefaultHeight(int iHeight) {
        if (this.ptIconSize == null) {
            this.ptIconSize = new Point(1, iHeight);
        } else {
            this.ptIconSize.y = iHeight;
        }
        if (!Constants.isOSX) {
            this.bSkipFirstColumn = true;
        }
    }

    @Override
    public int getRowDefaultHeight() {
        if (this.ptIconSize == null) {
            return 0;
        }
        return this.ptIconSize.y;
    }

    @Override
    public void setRowDefaultIconSize(Point size) {
        this.ptIconSize = size;
        if (!Constants.isOSX) {
            this.bSkipFirstColumn = true;
        }
    }

    @Override
    public void setRowSelected(TableRowCore row, boolean selected, boolean trigger) {
        super.setRowSelected(row, selected, trigger);
        if (row instanceof TableRowSWT) {
            ((TableRowSWT)row).setWidgetSelected(selected);
        }
    }

    protected void updateSelectedRows(TableItemOrTreeItem[] newSelectionArray, boolean trigger) {
        ArrayList<TableRowCore> newSelectionList = new ArrayList<TableRowCore>(1);
        for (TableItemOrTreeItem item : newSelectionArray) {
            TableRowCore row = this.getRow(item);
            if (row == null || row.isRowDisposed()) continue;
            newSelectionList.add(row);
        }
        this.setSelectedRows(newSelectionList.toArray(new TableRowCore[0]), trigger);
    }

    @Override
    public void uiSelectionChanged(final TableRowCore[] newlySelectedRows, final TableRowCore[] deselectedRows) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableRowImpl rowImpl;
                TableItemOrTreeItem item;
                if (TableViewSWTImpl.this.table.isDisposed()) {
                    return;
                }
                for (TableRowCore row : deselectedRows) {
                    if (!(row instanceof TableRowImpl) || (item = (rowImpl = (TableRowImpl)row).getItem()) == null || item.isDisposed()) continue;
                    TableViewSWTImpl.this.table.deselect(item);
                }
                for (TableRowCore row : newlySelectedRows) {
                    if (!(row instanceof TableRowImpl) || (item = (rowImpl = (TableRowImpl)row).getItem()) == null || item.isDisposed()) continue;
                    TableViewSWTImpl.this.table.select(item);
                }
            }
        });
    }

    @Override
    protected boolean setSortColumn(TableColumnCore newSortColumn, boolean allowOrderChange) {
        final TableColumnCore oldSortColumn = this.getSortColumn();
        boolean columnChanged = super.setSortColumn(newSortColumn, allowOrderChange);
        if (columnChanged) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    TableColumnCore sortColumn = TableViewSWTImpl.this.getSortColumn();
                    TableViewSWTImpl.this.fixAlignment(oldSortColumn, false);
                    TableViewSWTImpl.this.fixAlignment(sortColumn, true);
                }
            });
        }
        return columnChanged;
    }

    @Override
    protected void uiChangeColumnIndicator() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_changeColumnIndicator();
            }
        });
    }

    private void swt_changeColumnIndicator() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        try {
            TableColumnCore sortColumn = this.getSortColumn();
            TableColumnOrTreeColumn[] tcs = this.table.getColumns();
            for (int i = 0; i < tcs.length; ++i) {
                String sName = (String)tcs[i].getData("Name");
                if (sName == null || sortColumn == null || !sName.equals(sortColumn.getName())) continue;
                this.table.setSortDirection(sortColumn.isSortAscending() ? 128 : 1024);
                this.table.setSortColumn(tcs[i]);
                return;
            }
            this.table.setSortColumn(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public boolean isRowVisible(TableRowCore row) {
        if (row.isInPaintItem()) {
            return true;
        }
        if (this.visibleRows == null) {
            return false;
        }
        for (TableRowSWT visibleRow : this.visibleRows) {
            if (row != visibleRow) continue;
            return !Utils.isThisThreadSWT() || this.isVisible();
        }
        return false;
    }

    @Override
    public void visibleRowsChanged() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_visibleRowsChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_visibleRowsChanged() {
        ArrayList<TableRowSWT> nowInVisibleRows;
        final ArrayList<TableRowSWT> newlyVisibleRows = new ArrayList<TableRowSWT>();
        TableViewSWTImpl tableViewSWTImpl = this;
        synchronized (tableViewSWTImpl) {
            List<Object> visibleTableItems = this.isVisible() ? Utils.getVisibleTableItems(this.table) : Collections.emptyList();
            nowInVisibleRows = new ArrayList<TableRowSWT>(0);
            if (this.visibleRows != null) {
                nowInVisibleRows.addAll(Arrays.asList(this.visibleRows));
            }
            TableRowSWT[] rows = new TableRowSWT[visibleTableItems.size()];
            int pos = 0;
            for (TableItemOrTreeItem tableItemOrTreeItem : visibleTableItems) {
                TableRowCore row = this.getRow(tableItemOrTreeItem);
                if (!(row instanceof TableRowSWT)) continue;
                rows[pos++] = (TableRowSWT)row;
                boolean removed = nowInVisibleRows.remove(row);
                if (removed) continue;
                newlyVisibleRows.add((TableRowSWT)row);
            }
            if (pos < rows.length) {
                TableRowSWT[] temp = new TableRowSWT[pos];
                System.arraycopy(rows, 0, temp, 0, pos);
                this.visibleRows = temp;
            } else {
                this.visibleRows = rows;
            }
        }
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                boolean bTableUpdate = false;
                for (TableRowSWT row : newlyVisibleRows) {
                    row.refresh(true, true);
                    row.setShown(true, false);
                    if (!Constants.isOSX) continue;
                    bTableUpdate = true;
                }
                for (TableRowSWT row : nowInVisibleRows) {
                    row.setShown(false, false);
                }
                if (bTableUpdate) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.table.update();
                        }
                    });
                }
            }
        });
    }

    @Override
    public Image obfusticatedImage(Image image) {
        UISWTViewCore view;
        if (this.table.getItemCount() == 0 || !this.isVisible()) {
            return image;
        }
        TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            int iTopIndex;
            int iBottomIndex;
            int size;
            TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
            if (tc == null || !tc.isObfusticated() || (size = (iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex = this.table.getTopIndex())) - iTopIndex + 1) <= 0 || iTopIndex < 0) continue;
            for (int j = iTopIndex; j <= iBottomIndex; ++j) {
                TableCellSWT cell;
                String text;
                TableItemOrTreeItem rowSWT = this.table.getItem(j);
                TableRowSWT row = (TableRowSWT)this.table.getItem(j).getData("TableRow");
                if (row == null || row.isRowDisposed() || (text = (cell = row.getTableCellSWT(tc.getName())).getObfusticatedText()) == null) continue;
                Rectangle columnBounds = rowSWT.getBounds(i);
                if (columnBounds.y + columnBounds.height > this.clientArea.y + this.clientArea.height) {
                    columnBounds.height -= columnBounds.y + columnBounds.height - (this.clientArea.y + this.clientArea.height);
                }
                if (columnBounds.x + columnBounds.width > this.clientArea.x + this.clientArea.width) {
                    columnBounds.width -= columnBounds.x + columnBounds.width - (this.clientArea.x + this.clientArea.width);
                }
                Point location = Utils.getLocationRelativeToShell((Control)this.table.getComposite());
                columnBounds.x += location.x;
                columnBounds.y += location.y;
                UIDebugGenerator.obfusticateArea(image, columnBounds, text);
            }
        }
        UISWTViewCore uISWTViewCore = view = this.tvTabsCommon == null ? null : this.tvTabsCommon.getActiveSubView();
        if (view instanceof ObfusticateImage) {
            try {
                ((ObfusticateImage)((Object)view)).obfusticatedImage(image);
            }
            catch (Exception e) {
                Debug.out("Obfuscating " + view, e);
            }
        }
        return image;
    }

    @Override
    public void setEnableTabViews(boolean enableTabViews, boolean expandByDefault, String[] restrictedToIDs) {
        this.bEnableTabViews = enableTabViews;
        this.tabViewsExpandedByDefault = expandByDefault;
    }

    @Override
    public boolean isTabViewsEnabled() {
        return this.bEnableTabViews;
    }

    @Override
    public String[] getTabViewsRestrictedTo() {
        return null;
    }

    @Override
    public boolean getTabViewsExpandedByDefault() {
        return this.tabViewsExpandedByDefault;
    }

    @Override
    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        this.tvSWTCommon.addMenuFillListener(l);
    }

    @Override
    public boolean isDisposed() {
        return this.mainComposite == null || this.mainComposite.isDisposed() || this.table == null || this.table.isDisposed();
    }

    @Override
    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.tvSWTCommon == null || this.isDisposed()) {
            return;
        }
        this.tvSWTCommon.addKeyListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        if (this.tvSWTCommon == null || this.isDisposed()) {
            return;
        }
        this.tvSWTCommon.removeKeyListener(listener);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        if (this.tvSWTCommon == null || this.isDisposed()) {
            return new KeyListener[0];
        }
        return this.tvSWTCommon.getKeyListeners();
    }

    @Override
    public void selectAll() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.selectAll();
            super.selectAll();
        }
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public DragSource createDragSource(int style) {
        final DragSource dragSource = new DragSource((Control)this.table.getComposite(), style);
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event2) {
                TableViewSWTImpl.this.table.setCursor(null);
                TableViewSWTImpl.this.isDragging = true;
            }

            public void dragFinished(DragSourceEvent event2) {
                TableViewSWTImpl.this.isDragging = false;
            }
        });
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!dragSource.isDisposed()) {
                    dragSource.dispose();
                }
            }
        });
        return dragSource;
    }

    @Override
    public DropTarget createDropTarget(int style) {
        final DropTarget dropTarget = new DropTarget((Control)this.table.getComposite(), style);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!dropTarget.isDisposed()) {
                    dropTarget.dispose();
                }
            }
        });
        return dropTarget;
    }

    @Override
    public TableRowCore getRow(DropTargetEvent event2) {
        TableItemOrTreeItem ti = TableOrTreeUtils.getEventItem(event2.item);
        if (ti != null) {
            return (TableRowCore)ti.getData("TableRow");
        }
        return null;
    }

    protected TableViewSWTPanelCreator getMainPanelCreator() {
        return this.mainPanelCreator;
    }

    @Override
    public void setMainPanelCreator(TableViewSWTPanelCreator mainPanelCreator) {
        this.mainPanelCreator = mainPanelCreator;
    }

    @Override
    public TableCellCore getTableCellWithCursor() {
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        return this.getTableCell(pt.x, pt.y);
    }

    @Override
    public TableRowCore getTableRowWithCursor() {
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        return this.getTableRow(pt.x, pt.y, true);
    }

    @Override
    public Point getTableCellMouseOffset(TableCellSWT tableCell) {
        if (tableCell == null) {
            return null;
        }
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        Rectangle bounds = tableCell.getBounds();
        int x = pt.x - bounds.x;
        if (x < 0 || x > bounds.width) {
            return null;
        }
        int y = pt.y - bounds.y;
        if (y < 0 || y > bounds.height) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    public boolean isVisible() {
        if (!Utils.isThisThreadSWT()) {
            return this.isVisible;
        }
        boolean wasVisible = this.isVisible;
        boolean bl = this.isVisible = this.table != null && !this.table.isDisposed() && this.table.isVisible() && !this.shell.getMinimized();
        if (this.isVisible != wasVisible) {
            UISWTViewCore view;
            this.visibleRowsChanged();
            UISWTViewCore uISWTViewCore = view = this.tvTabsCommon == null ? null : this.tvTabsCommon.getActiveSubView();
            if (this.isVisible) {
                this.loopFactor = 0;
                if (view != null) {
                    view.triggerEvent(3, null);
                }
            } else if (view != null) {
                view.triggerEvent(4, null);
            }
        }
        return this.isVisible;
    }

    @Override
    public void showRow(final TableRowCore row) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.isDisposed()) {
                    return;
                }
                int index = row.getIndex();
                if (index >= 0 && index < TableViewSWTImpl.this.table.getItemCount()) {
                    TableViewSWTImpl.this.table.showItem(TableViewSWTImpl.this.table.getItem(index));
                }
            }
        });
    }

    @Override
    public void openFilterDialog() {
        if (this.filter == null) {
            return;
        }
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setFilter.title", null, "MyTorrentsView.dialog.setFilter.text", new String[]{MessageText.getString(this.getTableID() + "View" + ".header")});
        entryWindow.setPreenteredText(this.filter.text, false);
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return;
        }
        String message = entryWindow.getSubmittedInput();
        if (message == null) {
            message = "";
        }
        this.setFilterText(message);
    }

    @Override
    public void setFilterText(String s) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.setFilterText(s);
        }
    }

    @Override
    public TableViewSWTFilter<?> getSWTFilter() {
        return (TableViewSWTFilter)this.filter;
    }

    @Override
    public boolean isFiltered(DATASOURCETYPE ds) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.checker.filterCheck(ds, this.filter.text, this.filter.regex);
    }

    @Override
    public void enableFilterCheck(Text txtFilter, com.aelitis.azureus.ui.common.table.TableViewFilterCheck<DATASOURCETYPE> filterCheck) {
        TableViewSWTFilter<Object> filter2 = this.getSWTFilter();
        if (filter2 != null) {
            if (filter2.widget != null && !filter2.widget.isDisposed()) {
                filter2.widget.removeKeyListener((KeyListener)this.tvSWTCommon);
                filter2.widget.removeModifyListener(filter2.widgetModifyListener);
            }
        } else {
            filter2 = new TableViewSWTFilter();
            this.filter = filter2;
        }
        filter2.widget = txtFilter;
        if (txtFilter != null) {
            txtFilter.setMessage("Filter");
            txtFilter.addKeyListener((KeyListener)this.tvSWTCommon);
            filter2.widgetModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TableViewSWTImpl.this.setFilterText(((Text)e.widget).getText());
                }
            };
            txtFilter.addModifyListener(filter2.widgetModifyListener);
            if (txtFilter.getText().length() == 0) {
                txtFilter.setText(filter2.text);
            } else {
                filter2.text = filter2.nextText = txtFilter.getText();
            }
        } else {
            filter2.nextText = "";
            filter2.text = "";
        }
        filter2.checker = filterCheck;
        filter2.checker.filterSet(filter2.text);
        this.refilter();
    }

    @Override
    public Text getFilterControl() {
        TableViewSWTFilter<?> filter2 = this.getSWTFilter();
        return filter2 == null ? null : filter2.widget;
    }

    @Override
    public void disableFilterCheck() {
        TableViewSWTFilter<?> filter2 = this.getSWTFilter();
        if (filter2 == null) {
            return;
        }
        if (filter2.widget != null && !filter2.widget.isDisposed()) {
            filter2.widget.removeKeyListener((KeyListener)this.tvSWTCommon);
            filter2.widget.removeModifyListener(filter2.widgetModifyListener);
        }
        filter2 = null;
    }

    @Override
    public boolean enableSizeSlider(Composite composite, final int min, final int max) {
        try {
            if (this.sliderArea != null && !this.sliderArea.isDisposed()) {
                this.sliderArea.dispose();
            }
            Class<?> claTable = Class.forName("org.eclipse.swt.widgets." + (this.useTree ? "Tree" : "Table"));
            final Method method = claTable.getDeclaredMethod("setItemHeight", Integer.TYPE);
            method.setAccessible(true);
            composite.setLayout((Layout)new FormLayout());
            this.sliderArea = new Label(composite, 0);
            ((Label)this.sliderArea).setImage(ImageLoader.getInstance().getImage("zoom"));
            this.sliderArea.addListener(4, new Listener(){

                public void handleEvent(Event event2) {
                    final Shell shell = new Shell(TableViewSWTImpl.this.sliderArea.getShell(), 2048);
                    Listener l = new Listener(){

                        public void handleEvent(Event event2) {
                            if (event2.type == 7) {
                                Control curControl = event2.display.getCursorControl();
                                Point curPos = event2.display.getCursorLocation();
                                Point curPosRelShell = shell.toControl(curPos);
                                Rectangle bounds = shell.getBounds();
                                bounds.y = 0;
                                bounds.x = 0;
                                if (!bounds.contains(curPosRelShell)) {
                                    shell.dispose();
                                    return;
                                }
                                if (curControl != null && (curControl == shell || curControl.getParent() == shell)) {
                                    return;
                                }
                            }
                            shell.dispose();
                        }
                    };
                    shell.setBackgroundMode(2);
                    shell.setBackground(shell.getDisplay().getSystemColor(29));
                    shell.addListener(7, l);
                    shell.addListener(27, l);
                    FillLayout fillLayout = new FillLayout();
                    fillLayout.marginHeight = 4;
                    shell.setLayout((Layout)fillLayout);
                    final Scale slider = new Scale((Composite)shell, 512);
                    slider.addListener(7, l);
                    slider.addListener(27, l);
                    slider.setMinimum(min);
                    slider.setMaximum(max);
                    slider.setSelection(TableViewSWTImpl.this.getRowDefaultHeight());
                    try {
                        method.invoke((Object)TableViewSWTImpl.this.table.getComposite(), slider.getSelection());
                    }
                    catch (Throwable e1) {
                        // empty catch block
                    }
                    slider.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            TableViewSWTImpl.this.setRowDefaultHeight(slider.getSelection());
                            try {
                                method.invoke((Object)TableViewSWTImpl.this.table.getComposite(), slider.getSelection());
                            }
                            catch (Throwable e1) {
                                e1.printStackTrace();
                            }
                            TableViewSWTImpl.this.tableInvalidate();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    Point pt = TableViewSWTImpl.this.sliderArea.toDisplay(event2.x - 2, event2.y - 5);
                    int width = Constants.isOSX ? 20 : 50;
                    shell.setBounds(pt.x - width / 2, pt.y, width, 120);
                    shell.open();
                }
            });
            this.sliderArea.setLayoutData((Object)Utils.getFilledFormData());
            composite.layout();
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @Override
    public void disableSizeSlider() {
        Utils.disposeSWTObjects(new Object[]{this.sliderArea});
    }

    @Override
    public void setEnabled(final boolean enable) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!TableViewSWTImpl.this.isDisposed()) {
                    TableViewSWTImpl.this.table.setEnabled(enable);
                }
            }
        });
    }

    @Override
    public void addRowMouseListener(TableRowMouseListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.addRowMouseListener(listener);
        }
    }

    @Override
    public void removeRowMouseListener(TableRowMouseListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.removeRowMouseListener(listener);
        }
    }

    @Override
    public void invokeRowMouseListener(TableRowMouseEvent event2) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.invokeRowMouseListener(event2);
        }
    }

    @Override
    public void addRowPaintListener(TableRowSWTPaintListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.addRowPaintListener(listener);
        }
    }

    @Override
    public void removeRowPaintListener(TableRowSWTPaintListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.removeRowPaintListener(listener);
        }
    }

    @Override
    public void invokePaintListeners(GC gc, TableRowCore row, TableColumnCore column, Rectangle cellArea) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.invokePaintListeners(gc, row, column, cellArea);
        }
    }

    @Override
    public boolean canHaveSubItems() {
        return this.useTree;
    }

    @Override
    public void setParentDataSource(Object newDataSource) {
        super.setParentDataSource(newDataSource);
        this.triggerTabViewsDataSourceChanged(true);
    }

    @Override
    public void packColumns() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.table != null && !TableViewSWTImpl.this.table.isDisposed()) {
                    TableViewSWTImpl.this.table.pack(true);
                }
            }
        });
    }

    @Override
    public int getMaxItemShown() {
        return this.maxItemShown;
    }

    @Override
    public void setMaxItemShown(int i) {
        this.maxItemShown = i;
    }

    @Override
    public int indexOf(TableRowCore row) {
        if (!Utils.isThisThreadSWT()) {
            return super.indexOf(row);
        }
        int i = ((TableRowImpl)row).getRealIndex();
        if (i == -1 && (i = super.indexOf(row)) >= 0) {
            row.setTableItem(i);
        }
        return i;
    }

    @Override
    public TableRowCore createNewRow(Object ds) {
        TableRowImpl row = new TableRowImpl(this, this.table, this.getVisibleColumns(), ds, this.bSkipFirstColumn);
        return row;
    }

    private int uiGetTopIndex() {
        return ((Number)Utils.execSWTThreadWithObject("uiGetTopIndex", new AERunnableObject(){

            public Object runSupport() {
                return TableViewSWTImpl.this.table.getTopIndex();
            }
        }, 500L)).intValue();
    }

    @Override
    public int uiGuessMaxVisibleRows() {
        return 0;
    }

    private int uiGetBottomIndex(final int iTopIndex) {
        return ((Number)Utils.execSWTThreadWithObject("uiGetBottomIndex", new AERunnableObject(){

            public Object runSupport() {
                return Utils.getTableBottomIndex(TableViewSWTImpl.this.table, iTopIndex);
            }
        }, 500L)).intValue();
    }

    @Override
    public TableRowSWT getRowSWT(DATASOURCETYPE dataSource) {
        return (TableRowSWT)this.getRow(dataSource);
    }

    @Override
    public void enableFilterCheck(Text txtFilter, TableViewFilterCheck<DATASOURCETYPE> filterCheck) {
    }

    @Override
    public void getOffUIThread(AERunnable runnable) {
        Utils.getOffOfSWTThread(runnable);
    }

    @Override
    protected void _sortColumn(final boolean bForceDataRefresh, final boolean bFillGapsOnly, final boolean bFollowSelected) {
        if (Utils.isThisThreadSWT()) {
            super._sortColumn(bForceDataRefresh, bFillGapsOnly, bFollowSelected);
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this._sortColumn(bForceDataRefresh, bFillGapsOnly, bFollowSelected);
            }
        });
    }

    @Override
    public boolean isSingleSelection() {
        return (this.iTableStyle & 2) > 0;
    }

    @Override
    public void expandColumns() {
        TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
            if (tc == null) continue;
            int w = tc.getPreferredWidth();
            if (w <= 0 && (w = tc.getMinWidth()) <= 0) {
                w = 100;
            }
            tc.setWidth(w);
        }
    }

    @Override
    public void showColumnEditor() {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.showColumnEditor();
        }
    }

    @Override
    public TableViewSWT_TabsCommon getTabsCommon() {
        return this.tvTabsCommon;
    }

    private class ColumnMoveListener
    implements Listener {
        private ColumnMoveListener() {
        }

        public void handleEvent(Event event2) {
            int[] iColumnOrder;
            int iAddedPosition;
            TableColumnOrTreeColumn column = TableOrTreeUtils.getTableColumnEventItem(event2.widget);
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore == null) {
                return;
            }
            TableOrTreeSWT table = column.getParent();
            TableColumnOrTreeColumn[] tableColumns = table.getColumns();
            for (iAddedPosition = 0; iAddedPosition < tableColumns.length && column.getColumn() != tableColumns[iAddedPosition].getColumn(); ++iAddedPosition) {
            }
            if (iAddedPosition >= tableColumns.length) {
                return;
            }
            try {
                iColumnOrder = table.getColumnOrder();
            }
            catch (NoSuchMethodError e) {
                return;
            }
            for (int i = 0; i < iColumnOrder.length; ++i) {
                if (iColumnOrder[i] != iAddedPosition) continue;
                int iNewPosition = i - (TableViewSWTImpl.this.bSkipFirstColumn ? 1 : 0);
                if (tableColumnCore.getPosition() == iNewPosition) break;
                if (iNewPosition == -1) {
                    iColumnOrder[0] = 0;
                    iColumnOrder[1] = iAddedPosition;
                    table.setColumnOrder(iColumnOrder);
                    iNewPosition = 0;
                }
                tableColumnCore.setPositionNoShift(iNewPosition);
                tableColumnCore.saveSettings(null);
                TableStructureEventDispatcher.getInstance(TableViewSWTImpl.this.tableID).columnOrderChanged(iColumnOrder);
                break;
            }
        }
    }

    private class ColumnSelectionListener
    implements Listener {
        private ColumnSelectionListener() {
        }

        public void handleEvent(Event event2) {
            int maskNoButton = event2.stateMask & ~SWT.BUTTON_MASK;
            if (maskNoButton != 0) {
                return;
            }
            TableColumnOrTreeColumn column = TableOrTreeUtils.getTableColumnEventItem(event2.widget);
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore != null) {
                TableViewSWTImpl.this.setSortColumn(tableColumnCore, true);
                TableViewSWTImpl.this.columnVisibilitiesChanged = true;
                TableViewSWTImpl.this.refreshTable(true);
            }
        }
    }

    private static interface SourceReplaceListener {
        public void sourcesChanged();

        public void cleanup(Text var1);
    }
}

