/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.control.impl;

import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.control.impl.DHTControlImpl;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DHTControlStatsImpl
implements DHTTransportFullStats,
DHTControlStats {
    private static final int UPDATE_INTERVAL = 10000;
    private static final int UPDATE_PERIOD = 120;
    private DHTControlImpl control;
    private Average packets_in_average = Average.getInstance(10000, 120);
    private Average packets_out_average = Average.getInstance(10000, 120);
    private Average bytes_in_average = Average.getInstance(10000, 120);
    private Average bytes_out_average = Average.getInstance(10000, 120);
    private DHTTransportStats transport_snapshot;
    private long[] router_snapshot;
    private int[] value_details_snapshot;

    protected DHTControlStatsImpl(DHTControlImpl _control) {
        this.control = _control;
        this.transport_snapshot = this.control.getTransport().getStats().snapshot();
        this.router_snapshot = this.control.getRouter().getStats().getStats();
        SimpleTimer.addPeriodicEvent("DHTCS:update", 10000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                DHTControlStatsImpl.this.update();
                DHTControlStatsImpl.this.control.poke();
            }
        });
    }

    protected void update() {
        DHTTransport transport = this.control.getTransport();
        DHTTransportStats t_stats = transport.getStats().snapshot();
        this.packets_in_average.addValue(t_stats.getPacketsReceived() - this.transport_snapshot.getPacketsReceived());
        this.packets_out_average.addValue(t_stats.getPacketsSent() - this.transport_snapshot.getPacketsSent());
        this.bytes_in_average.addValue(t_stats.getBytesReceived() - this.transport_snapshot.getBytesReceived());
        this.bytes_out_average.addValue(t_stats.getBytesSent() - this.transport_snapshot.getBytesSent());
        this.transport_snapshot = t_stats;
        this.router_snapshot = this.control.getRouter().getStats().getStats();
        this.value_details_snapshot = null;
    }

    public long getTotalBytesReceived() {
        return this.transport_snapshot.getBytesReceived();
    }

    public long getTotalBytesSent() {
        return this.transport_snapshot.getBytesSent();
    }

    public long getTotalPacketsReceived() {
        return this.transport_snapshot.getPacketsReceived();
    }

    public long getTotalPacketsSent() {
        return this.transport_snapshot.getPacketsSent();
    }

    public long getTotalPingsReceived() {
        return this.transport_snapshot.getPings()[3];
    }

    public long getTotalFindNodesReceived() {
        return this.transport_snapshot.getFindNodes()[3];
    }

    public long getTotalFindValuesReceived() {
        return this.transport_snapshot.getFindValues()[3];
    }

    public long getTotalStoresReceived() {
        return this.transport_snapshot.getStores()[3];
    }

    public long getTotalKeyBlocksReceived() {
        return this.transport_snapshot.getKeyBlocks()[3];
    }

    public long getAverageBytesReceived() {
        return this.bytes_in_average.getAverage();
    }

    public long getAverageBytesSent() {
        return this.bytes_out_average.getAverage();
    }

    public long getAveragePacketsReceived() {
        return this.packets_in_average.getAverage();
    }

    public long getAveragePacketsSent() {
        return this.packets_out_average.getAverage();
    }

    public long getIncomingRequests() {
        return this.transport_snapshot.getIncomingRequests();
    }

    protected int[] getValueDetails() {
        int[] vd = this.value_details_snapshot;
        if (vd == null) {
            this.value_details_snapshot = vd = this.control.getDataBase().getStats().getValueDetails();
        }
        return vd;
    }

    public long getDBValuesStored() {
        int[] vd = this.getValueDetails();
        return vd[0];
    }

    public long getDBKeyCount() {
        return this.control.getDataBase().getStats().getKeyCount();
    }

    public long getDBValueCount() {
        return this.control.getDataBase().getStats().getValueCount();
    }

    public long getDBKeysBlocked() {
        return this.control.getDataBase().getStats().getKeyBlockCount();
    }

    public long getDBKeyDivSizeCount() {
        int[] vd = this.getValueDetails();
        return vd[5];
    }

    public long getDBKeyDivFreqCount() {
        int[] vd = this.getValueDetails();
        return vd[4];
    }

    public long getDBStoreSize() {
        return this.control.getDataBase().getStats().getSize();
    }

    public long getRouterNodes() {
        return this.router_snapshot[0];
    }

    public long getRouterLeaves() {
        return this.router_snapshot[1];
    }

    public long getRouterContacts() {
        return this.router_snapshot[2];
    }

    public long getRouterUptime() {
        return this.control.getRouterUptime();
    }

    public int getRouterCount() {
        return this.control.getRouterCount();
    }

    public String getVersion() {
        return "5.5.0.1_B25";
    }

    public long getEstimatedDHTSize() {
        return this.control.getEstimatedDHTSize();
    }

    public String getString() {
        return "transport:" + this.getTotalBytesReceived() + "," + this.getTotalBytesSent() + "," + this.getTotalPacketsReceived() + "," + this.getTotalPacketsSent() + "," + this.getTotalPingsReceived() + "," + this.getTotalFindNodesReceived() + "," + this.getTotalFindValuesReceived() + "," + this.getTotalStoresReceived() + "," + this.getTotalKeyBlocksReceived() + "," + this.getAverageBytesReceived() + "," + this.getAverageBytesSent() + "," + this.getAveragePacketsReceived() + "," + this.getAveragePacketsSent() + "," + this.getIncomingRequests() + ",router:" + this.getRouterNodes() + "," + this.getRouterLeaves() + "," + this.getRouterContacts() + ",database:" + this.getDBKeyCount() + "," + this.getDBValueCount() + "," + this.getDBValuesStored() + "," + this.getDBStoreSize() + "," + this.getDBKeyDivFreqCount() + "," + this.getDBKeyDivSizeCount() + "," + this.getDBKeysBlocked() + ",version:" + this.getVersion() + "," + this.getRouterUptime() + "," + this.getRouterCount();
    }
}

