/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginUtils {
    private static final Object i2p_install_lock = new Object();
    private static boolean i2p_installing = false;

    private static BuddyPlugin getPlugin() {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azbuddy", true);
        if (pi != null) {
            return (BuddyPlugin)pi.getPlugin();
        }
        return null;
    }

    public static BuddyPluginBeta getBetaPlugin() {
        BuddyPluginBeta beta;
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && (beta = bp.getBeta()).isAvailable()) {
            return beta;
        }
        return null;
    }

    public static boolean isBetaChatAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable();
        }
        return false;
    }

    public static boolean isBetaChatAnonAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable() && bp.getBeta().isI2PAvailable();
        }
        return false;
    }

    public static void createBetaChat(final String network, final String key, final Runnable callback) {
        new AEThread2("Chat create async"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
                        bp.getBeta().getAndShowChat(network, key);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        Object var3_4 = null;
                        callback.run();
                    }
                    Object var3_3 = null;
                    callback.run();
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    callback.run();
                    throw throwable;
                }
            }
        }.start();
    }

    public static Map<String, Object> peekChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(net, key);
        }
        return null;
    }

    public static Map<String, Object> peekChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(download);
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            try {
                return bp.getBeta().getChat(net, key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().getChat(download);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingI2PHelper() {
        Object object = i2p_install_lock;
        synchronized (object) {
            return i2p_installing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installI2PHelper(String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean bl;
        block20: {
            boolean install;
            UIFunctions uif;
            boolean installing;
            block18: {
                boolean bl2;
                block19: {
                    Object object;
                    Object object2 = i2p_install_lock;
                    synchronized (object2) {
                        if (i2p_installing) {
                            Debug.out("I2P Helper already installing");
                            return false;
                        }
                        i2p_installing = true;
                    }
                    installing = false;
                    try {
                        uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) break block18;
                        Debug.out("UIFunctions unavailable - can't install plugin");
                        bl2 = false;
                        Object var11_9 = null;
                        if (installing) break block19;
                        object = i2p_install_lock;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        if (!installing) {
                            Object object3 = i2p_install_lock;
                            synchronized (object3) {
                                i2p_installing = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        i2p_installing = false;
                    }
                }
                return bl2;
            }
            String title = MessageText.getString("azneti2phelper.install");
            String text = MessageText.getString("azneti2phelper.install.text");
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            if (remember_id != null) {
                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            }
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean bl3 = install = prompter.waitUntilClosed() == 0;
            if (install) {
                installing = true;
                uif.installPlugin("azneti2phelper", "azneti2phelper.install", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionComplete(Object result) {
                        try {
                            if (callback != null) {
                                if (result instanceof Boolean) {
                                    install_outcome[0] = (Boolean)result;
                                }
                                callback.run();
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            Object object = i2p_install_lock;
                            synchronized (object) {
                                i2p_installing = false;
                            }
                            throw throwable;
                        }
                        Object object = i2p_install_lock;
                        synchronized (object) {
                            i2p_installing = false;
                        }
                    }
                });
            } else {
                Debug.out("I2P Helper install declined (either user reply or auto-remembered)");
            }
            bl = install;
            Object var11_10 = null;
            if (installing) break block20;
            Object object = i2p_install_lock;
            synchronized (object) {
                i2p_installing = false;
            }
        }
        return bl;
    }
}

