/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleAdapter;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2Listener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAdapter;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginViewBetaChat;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginViewChat;
import com.aelitis.azureus.plugins.net.buddy.swt.BuddyPluginViewInstance;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTracker;
import com.aelitis.azureus.plugins.net.buddy.tracker.BuddyPluginTrackerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.menus.MenuContext;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntryListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginView
implements UISWTViewEventListener,
BuddyPluginViewInterface {
    private BuddyPlugin plugin;
    private UISWTInstance ui_instance;
    private String VIEW_ID;
    private BuddyPluginViewInstance current_instance;
    private Image iconNLI;
    private Image iconIDLE;
    private Image iconIN;
    private Image iconOUT;
    private final String default_sound = "org/gudy/azureus2/ui/icons/downloadFinished.wav";
    private static Object CHAT_LM_KEY = new Object();
    private HashMap<UISWTView, BetaSubViewHolder> beta_subviews = new HashMap();
    private Map<BuddyPluginBeta.ChatInstance, Integer> chat_uis = new HashMap<BuddyPluginBeta.ChatInstance, Integer>();
    private UISWTStatusEntry beta_status;
    private Image bs_chat_gray;
    private Image bs_chat_gray_text;
    private Image bs_chat_green;
    private static Map<String, Object[]> pending_msg_map = new HashMap<String, Object[]>();
    private static TimerEventPeriodic pending_msg_event;
    private List<MenuItem> menu_items = new ArrayList<MenuItem>();
    private Set<BuddyPluginBeta.ChatInstance> menu_latest_instances = new HashSet<BuddyPluginBeta.ChatInstance>();
    private static AsyncDispatcher public_dispatcher;
    private static AsyncDispatcher anon_dispatcher;
    private static AtomicInteger public_done;
    private static AtomicInteger anon_done;

    public BuddyPluginView(BuddyPlugin _plugin, UIInstance _ui_instance, String _VIEW_ID) {
        this.plugin = _plugin;
        this.ui_instance = (UISWTInstance)_ui_instance;
        this.VIEW_ID = _VIEW_ID;
        this.plugin.getAZ2Handler().addListener(new BuddyPluginAZ2Listener(){

            public void chatCreated(final BuddyPluginAZ2.chatInstance chat) {
                final Display display = BuddyPluginView.this.ui_instance.getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!display.isDisposed()) {
                                new BuddyPluginViewChat(BuddyPluginView.this.plugin, display, chat);
                            }
                        }
                    });
                }
            }

            public void chatDestroyed(BuddyPluginAZ2.chatInstance chat) {
            }
        });
        SimpleTimer.addEvent("BuddyStatusInit", SystemTime.getOffsetTime(1000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                UISWTStatusEntry label = BuddyPluginView.this.ui_instance.createStatusEntry();
                label.setText(MessageText.getString("azbuddy.tracker.bbb.status.title"));
                new statusUpdater(BuddyPluginView.this.ui_instance);
            }
        });
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                ImageLoader imageLoader = ImageLoader.getInstance();
                BuddyPluginView.this.iconNLI = imageLoader.getImage("bbb_nli");
                BuddyPluginView.this.iconIDLE = imageLoader.getImage("bbb_idle");
                BuddyPluginView.this.iconIN = imageLoader.getImage("bbb_in");
                BuddyPluginView.this.iconOUT = imageLoader.getImage("bbb_out");
            }
        });
        this.ui_instance.addView("Main", this.VIEW_ID, this);
        this.initBeta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (this.current_instance == null) break;
                return false;
            }
            case 2: {
                this.current_instance = new BuddyPluginViewInstance(this, this.plugin, this.ui_instance, (Composite)event2.getData());
                break;
            }
            case 7: 
            case 8: {
                try {
                    if (this.current_instance != null) {
                        this.current_instance.destroy();
                    }
                    Object var3_2 = null;
                    this.current_instance = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.current_instance = null;
                    throw throwable;
                }
            }
        }
        return true;
    }

    @Override
    public void openChat(final BuddyPluginBeta.ChatInstance chat) {
        final Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                new BuddyPluginViewBetaChat(BuddyPluginView.this, BuddyPluginView.this.plugin, chat);
            }
        });
    }

    private void initBeta() {
        if (this.plugin.isBetaEnabled() && this.plugin.getBeta().isAvailable()) {
            this.addBetaSubviews(true);
            this.beta_status = this.ui_instance.createStatusEntry();
            this.beta_status.setImageEnabled(true);
            this.beta_status.setVisible(true);
            this.updateIdleTT();
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    BuddyPluginView.this.bs_chat_gray = imageLoader.getImage("dchat_gray");
                    BuddyPluginView.this.bs_chat_gray_text = imageLoader.getImage("dchat_gray_text");
                    BuddyPluginView.this.bs_chat_green = imageLoader.getImage("dchat_green");
                    BuddyPluginView.this.beta_status.setImage(BuddyPluginView.this.bs_chat_gray);
                }
            });
            this.beta_status.setListener(new UISWTStatusEntryListener(){

                public void entryClicked(UISWTStatusEntry entry) {
                    Set current_instances = BuddyPluginView.this.menu_latest_instances;
                    for (BuddyPluginBeta.ChatInstance chat : current_instances) {
                        if (!chat.getMessageOutstanding()) continue;
                        try {
                            BuddyPluginView.this.openChat(chat.getClone());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
            SimpleTimer.addPeriodicEvent("msgcheck", 30000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(TimerEvent event2) {
                    List<BuddyPluginBeta.ChatInstance> chats = BuddyPluginView.this.plugin.getBeta().getChats();
                    Map map = pending_msg_map;
                    synchronized (map) {
                        for (BuddyPluginBeta.ChatInstance chat : chats) {
                            BuddyPluginBeta.ChatMessage last_msg;
                            if (BuddyPluginView.this.chat_uis.containsKey(chat) || !chat.isFavourite() && !chat.isAutoNotify() && !chat.isInteresting() || (last_msg = chat.getLastMessageNotMine()) == null) continue;
                            BuddyPluginBeta.ChatMessage last_handled = (BuddyPluginBeta.ChatMessage)chat.getUserData(CHAT_LM_KEY);
                            long last_msg_time = last_msg.getTimeStamp();
                            if (last_handled != null && last_msg_time <= last_handled.getTimeStamp()) continue;
                            chat.setUserData(CHAT_LM_KEY, last_msg);
                            BuddyPluginView.this.betaMessagePending(chat, null, last_msg);
                        }
                        BuddyPluginView.this.updateIdleTT();
                    }
                }
            });
        }
    }

    private void addBetaSubviews(boolean enable) {
        String[] views = new String[]{"MyLibrary.big", "MyTorrents", "MyTorrents.big", "MySeeders"};
        if (enable) {
            TagManagerFactory.getTagManager().addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

                public void taggableTagged(TagType tag_type, Tag tag, Taggable taggable) {
                    if (tag_type.getTagType() == 3) {
                        DownloadManager dm = (DownloadManager)taggable;
                        for (BetaSubViewHolder h : BuddyPluginView.this.beta_subviews.values()) {
                            h.tagsUpdated(dm);
                        }
                    }
                }

                public void taggableUntagged(TagType tag_type, Tag tag, Taggable taggable) {
                    if (tag_type.getTagType() == 3) {
                        DownloadManager dm = (DownloadManager)taggable;
                        for (BetaSubViewHolder h : BuddyPluginView.this.beta_subviews.values()) {
                            h.tagsUpdated(dm);
                        }
                    }
                }
            });
            UISWTViewEventListener listener = new UISWTViewEventListener(){

                public boolean eventOccurred(UISWTViewEvent event2) {
                    UISWTView currentView = event2.getView();
                    switch (event2.getType()) {
                        case 0: {
                            BuddyPluginView.this.beta_subviews.put(currentView, new BetaSubViewHolder());
                            break;
                        }
                        case 2: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.initialise(event2.getView(), (Composite)event2.getData());
                            break;
                        }
                        case 1: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.setDataSource(event2.getData());
                            break;
                        }
                        case 3: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.gotFocus();
                            break;
                        }
                        case 4: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.get(currentView);
                            if (subview == null) break;
                            subview.lostFocus();
                            break;
                        }
                        case 7: {
                            BetaSubViewHolder subview = (BetaSubViewHolder)BuddyPluginView.this.beta_subviews.remove(currentView);
                            if (subview == null) break;
                            subview.destroy();
                            break;
                        }
                    }
                    return true;
                }
            };
            for (String table_id : views) {
                this.ui_instance.addView(table_id, "azbuddy.ui.menu.chat", listener);
            }
        } else {
            for (String table_id : views) {
                this.ui_instance.removeViews(table_id, "azbuddy.ui.menu.chat");
            }
            for (UISWTView entry : new ArrayList<UISWTView>(this.beta_subviews.keySet())) {
                entry.closeView();
            }
            this.beta_subviews.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerUI(BuddyPluginBeta.ChatInstance chat) {
        Map<String, Object[]> map = pending_msg_map;
        synchronized (map) {
            Integer num = this.chat_uis.get(chat);
            if (num == null) {
                num = 1;
            } else {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
            }
            this.chat_uis.put(chat, num);
            if (num == 1) {
                this.updateIdleTT();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterUI(BuddyPluginBeta.ChatInstance chat) {
        Map<String, Object[]> map = pending_msg_map;
        synchronized (map) {
            Integer num = this.chat_uis.get(chat);
            if (num != null) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num - 1);
            }
            if (num == 0) {
                this.chat_uis.remove(chat);
                this.updateIdleTT();
            } else {
                this.chat_uis.put(chat, num);
            }
        }
    }

    private List<BuddyPluginBeta.ChatInstance> sortChats(Collection<BuddyPluginBeta.ChatInstance> chats) {
        ArrayList<BuddyPluginBeta.ChatInstance> result = new ArrayList<BuddyPluginBeta.ChatInstance>(chats);
        Collections.sort(result, new Comparator<BuddyPluginBeta.ChatInstance>(){

            @Override
            public int compare(BuddyPluginBeta.ChatInstance o1, BuddyPluginBeta.ChatInstance o2) {
                int res = o1.getNetAndKey().compareTo(o2.getNetAndKey());
                return res;
            }
        });
        return result;
    }

    private void updateIdleTT() {
        if (pending_msg_map.size() == 0) {
            HashSet<BuddyPluginBeta.ChatInstance> instances = new HashSet<BuddyPluginBeta.ChatInstance>();
            if (this.chat_uis.size() > 0) {
                for (BuddyPluginBeta.ChatInstance chat : this.chat_uis.keySet()) {
                    instances.add(chat);
                }
            }
            List<BuddyPluginBeta.ChatInstance> chats = this.plugin.getBeta().getChats();
            for (BuddyPluginBeta.ChatInstance chat : chats) {
                if (this.chat_uis.containsKey(chat) || !chat.isFavourite()) continue;
                instances.add(chat);
            }
            String text = MessageText.getString("label.no.messages");
            for (BuddyPluginBeta.ChatInstance chat : this.sortChats(instances)) {
                text = text + "\n  " + chat.getShortName();
            }
            this.beta_status.setTooltipText(text);
            this.buildMenu(instances);
        }
    }

    protected void playSound() {
        if (this.plugin.getBeta().getSoundEnabled()) {
            final String sound_file = this.plugin.getBeta().getSoundFile();
            new AEThread2("BuddyPluginSound"){

                public void run() {
                    try {
                        AudioClip audio_clip = null;
                        if (sound_file.length() == 0) {
                            audio_clip = Applet.newAudioClip(BuddyPluginView.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                        } else {
                            URL file_url = new File(sound_file).toURI().toURL();
                            audio_clip = Applet.newAudioClip(file_url);
                        }
                        audio_clip.play();
                        Thread.sleep(2500L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void betaMessagePending(BuddyPluginBeta.ChatInstance chat, Control comp_maybe_null, BuddyPluginBeta.ChatMessage pending_message) {
        Map<String, Object[]> map = pending_msg_map;
        synchronized (map) {
            String key = chat.getNetAndKey();
            Object[] entry = pending_msg_map.get(key);
            if (pending_message != null) {
                if (chat.isOldOutstandingMessage(pending_message)) {
                    return;
                }
                chat.setMessageOutstanding(true);
                if (entry == null) {
                    entry = new Object[]{1, new HashSet(), chat};
                    pending_msg_map.put(key, entry);
                } else {
                    entry[0] = (Integer)entry[0] + 1;
                }
                HashSet controls = (HashSet)entry[1];
                if (controls.contains(comp_maybe_null)) {
                    return;
                }
                controls.add(comp_maybe_null);
                if (pending_msg_event == null) {
                    pending_msg_event = SimpleTimer.addPeriodicEvent("BPPM", 2500L, new TimerEventPerformer(){
                        private int tick_count = 0;
                        private Set<BuddyPluginBeta.ChatInstance> prev_instances = new HashSet<BuddyPluginBeta.ChatInstance>();

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            ++this.tick_count;
                            Map map = pending_msg_map;
                            synchronized (map) {
                                HashSet<BuddyPluginBeta.ChatInstance> current_instances = new HashSet<BuddyPluginBeta.ChatInstance>();
                                HashMap<BuddyPluginBeta.ChatInstance, Object> instance_map = new HashMap<BuddyPluginBeta.ChatInstance, Object>();
                                Iterator it = pending_msg_map.entrySet().iterator();
                                boolean has_new = false;
                                while (it.hasNext()) {
                                    Map.Entry map_entry = it.next();
                                    Object[] entry = (Object[])map_entry.getValue();
                                    BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)entry[2];
                                    if (chat.isDestroyed()) {
                                        it.remove();
                                        continue;
                                    }
                                    HashSet comps = (HashSet)entry[1];
                                    for (Control c : comps) {
                                        if (c == null || !c.isDisposed()) continue;
                                        it.remove();
                                    }
                                    if (comps.size() == 0) {
                                        it.remove();
                                        continue;
                                    }
                                    current_instances.add(chat);
                                    if (!this.prev_instances.contains(chat)) {
                                        has_new = true;
                                    }
                                    instance_map.put(chat, entry[0]);
                                }
                                if (pending_msg_map.size() == 0) {
                                    pending_msg_event.cancel();
                                    pending_msg_event = null;
                                }
                                if (current_instances.size() == 0) {
                                    BuddyPluginView.this.updateIdleTT();
                                    BuddyPluginView.this.beta_status.setImage(BuddyPluginView.this.bs_chat_gray);
                                } else {
                                    String tt_text = "";
                                    for (BuddyPluginBeta.ChatInstance chat : BuddyPluginView.this.sortChats(current_instances)) {
                                        String short_name = chat.getShortName();
                                        tt_text = tt_text + (tt_text.length() == 0 ? "" : "\n") + instance_map.get(chat) + " - " + short_name;
                                    }
                                    BuddyPluginView.this.buildMenu(current_instances);
                                    if (has_new) {
                                        BuddyPluginView.this.playSound();
                                    }
                                    BuddyPluginView.this.beta_status.setTooltipText(tt_text);
                                    BuddyPluginView.this.beta_status.setImage(this.tick_count % 2 == 0 ? BuddyPluginView.this.bs_chat_gray_text : BuddyPluginView.this.bs_chat_green);
                                }
                                this.prev_instances = current_instances;
                            }
                        }
                    });
                }
            } else {
                chat.setUserData(CHAT_LM_KEY, chat.getLastMessageNotMine());
                chat.setMessageOutstanding(false);
                if (entry != null) {
                    pending_msg_map.remove(key);
                    if (pending_msg_event == null) {
                        Debug.out("eh?");
                    }
                }
            }
        }
    }

    private void buildMenu(final Set<BuddyPluginBeta.ChatInstance> current_instances) {
        if (this.menu_items.size() == 0 || !((Object)this.menu_latest_instances).equals(current_instances)) {
            MenuItem mi;
            for (MenuItem mi2 : this.menu_items) {
                mi2.remove();
            }
            this.menu_items.clear();
            MenuManager menu_manager = this.plugin.getPluginInterface().getUIManager().getMenuManager();
            MenuContext mc = this.beta_status.getMenuContext();
            for (final BuddyPluginBeta.ChatInstance chat : this.sortChats(current_instances)) {
                String short_name = chat.getShortName();
                MenuItem mi3 = menu_manager.addMenuItem(mc, "!" + short_name + "!");
                mi3.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        try {
                            BuddyPluginView.this.openChat(chat.getClone());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                this.menu_items.add(mi3);
            }
            boolean need_sep = true;
            if (current_instances.size() > 1) {
                mi = menu_manager.addMenuItem(mc, "sep1");
                need_sep = false;
                mi.setStyle(4);
                this.menu_items.add(mi);
                mi = menu_manager.addMenuItem(mc, "label.open.all");
                mi.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        for (BuddyPluginBeta.ChatInstance chat : current_instances) {
                            if (!chat.getMessageOutstanding()) continue;
                            try {
                                BuddyPluginView.this.openChat(chat.getClone());
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                });
                this.menu_items.add(mi);
            }
            if (need_sep) {
                mi = menu_manager.addMenuItem(mc, "sep2");
                mi.setStyle(4);
                this.menu_items.add(mi);
            }
            mi = menu_manager.addMenuItem(mc, "!" + MessageText.getString("chats.view.heading") + "...!");
            mi.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.openView(15, null);
                    }
                }
            });
            this.menu_items.add(mi);
            mi = menu_manager.addMenuItem(mc, "sep3");
            mi.setStyle(4);
            this.menu_items.add(mi);
            mi = menu_manager.addMenuItem(mc, "MainWindow.menu.view.configuration");
            mi.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    BuddyPluginView.this.ui_instance.openView("Main", BuddyPluginView.this.VIEW_ID, null);
                }
            });
            this.menu_items.add(mi);
            this.menu_latest_instances = current_instances;
        }
    }

    static {
        public_dispatcher = new AsyncDispatcher();
        anon_dispatcher = new AsyncDispatcher();
        public_done = new AtomicInteger();
        anon_done = new AtomicInteger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BetaSubViewHolder {
        private int CHAT_DOWNLOAD = 0;
        private int CHAT_TAG = 1;
        private int CHAT_GENERAL = 2;
        private int CHAT_FAVOURITES = 3;
        private Composite[] chat_composites;
        private List<Button> mode_buttons = new ArrayList<Button>();
        private Group middle;
        private CTabFolder tab_folder;
        private CTabItem public_item;
        private CTabItem anon_item;
        private int last_build_chat_mode = -1;
        private int chat_mode = this.CHAT_DOWNLOAD;
        private Download current_download;
        private Tag current_tag;
        private String current_general;
        private String current_favourite_net;
        private String current_favourite_key;
        private Tag current_ds_tag;
        private boolean have_focus;
        private boolean rebuild_outstanding = true;

        private BetaSubViewHolder() {
        }

        private void initialise(UISWTView view, Composite parent) {
            Object initial_ds;
            UISWTView parent_view = view.getParentView();
            if (parent_view != null && (initial_ds = parent_view.getInitialDataSource()) instanceof Tag) {
                this.current_ds_tag = (Tag)initial_ds;
            }
            Composite composite = parent;
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            layout.marginRight = 4;
            composite.setLayout((Layout)layout);
            GridData grid_data = new GridData(1808);
            composite.setLayoutData((Object)grid_data);
            Group lhs = new Group(composite, 0);
            lhs.setText(MessageText.getString("label.chat.type"));
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.horizontalSpacing = 1;
            layout.verticalSpacing = 1;
            lhs.setLayout((Layout)layout);
            grid_data = new GridData(1040);
            lhs.setLayoutData((Object)grid_data);
            Button downloads = new Button((Composite)lhs, 2);
            downloads.setText(MessageText.getString("v3.MainWindow.button.download"));
            downloads.setData((Object)this.CHAT_DOWNLOAD);
            Button tags = new Button((Composite)lhs, 2);
            tags.setText(MessageText.getString("label.tags"));
            tags.setData((Object)this.CHAT_TAG);
            Button general = new Button((Composite)lhs, 2);
            general.setText(MessageText.getString("ConfigView.section.global"));
            general.setData((Object)this.CHAT_GENERAL);
            Button favourites = new Button((Composite)lhs, 2);
            favourites.setText(MessageText.getString("label.favorites"));
            favourites.setData((Object)this.CHAT_FAVOURITES);
            this.middle = new Group(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            this.middle.setLayout((Layout)layout);
            grid_data = new GridData(1040);
            grid_data.widthHint = 0;
            this.middle.setLayoutData((Object)grid_data);
            this.middle.setText("");
            this.middle.setVisible(false);
            downloads.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_DOWNLOAD, true);
                }
            });
            tags.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_TAG, true);
                }
            });
            general.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_GENERAL, true);
                }
            });
            favourites.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BetaSubViewHolder.this.buildChatMode(BetaSubViewHolder.this.CHAT_FAVOURITES, true);
                }
            });
            downloads.setSelection(true);
            this.mode_buttons.add(downloads);
            this.mode_buttons.add(tags);
            this.mode_buttons.add(general);
            this.mode_buttons.add(favourites);
            this.setupButtonGroup(this.mode_buttons);
            this.tab_folder = new CTabFolder(composite, 16384);
            this.tab_folder.setTabHeight(20);
            grid_data = new GridData(1808);
            this.tab_folder.setLayoutData((Object)grid_data);
            this.public_item = new CTabItem(this.tab_folder, 0);
            this.public_item.setText(MessageText.getString("label.public.chat"));
            this.public_item.setData((Object)"Public");
            Composite public_composite = new Composite((Composite)this.tab_folder, 0);
            this.public_item.setControl((Control)public_composite);
            grid_data = new GridData(1808);
            public_composite.setLayoutData((Object)grid_data);
            public_composite.setData("tabitem", (Object)this.public_item);
            Composite anon_composite = null;
            this.anon_item = new CTabItem(this.tab_folder, 0);
            this.anon_item.setText(MessageText.getString("label.anon.chat"));
            this.anon_item.setData((Object)"I2P");
            anon_composite = new Composite((Composite)this.tab_folder, 0);
            this.anon_item.setControl((Control)anon_composite);
            grid_data = new GridData(1808);
            anon_composite.setLayoutData((Object)grid_data);
            anon_composite.setData("tabitem", (Object)this.anon_item);
            this.chat_composites = new Composite[]{public_composite, anon_composite};
            this.tab_folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabItem item = (CTabItem)e.item;
                    String network = (String)item.getData();
                    BetaSubViewHolder.this.activateNetwork(network);
                }
            });
        }

        private void tagsUpdated(DownloadManager dm) {
            Download download = this.current_download;
            if (download == null) {
                return;
            }
            if (this.chat_mode == this.CHAT_TAG && dm == PluginCoreUtils.unwrap(download)) {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        BetaSubViewHolder.this.rebuild_outstanding = true;
                        BetaSubViewHolder.this.activate();
                    }
                });
            }
        }

        private void setupButtonGroup(final List<Button> buttons) {
            for (final Button b : buttons) {
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!b.getSelection()) {
                            b.setSelection(true);
                        }
                        for (Button b2 : buttons) {
                            if (b2 == b) continue;
                            b2.setSelection(false);
                        }
                    }
                });
            }
            Utils.makeButtonsEqualWidth(buttons);
        }

        private void selectButtonGroup(List<Button> buttons, int data) {
            for (Button b : buttons) {
                b.setSelection((Integer)b.getData() == data);
            }
        }

        private void selectButtonGroup(List<Button> buttons, String data) {
            Iterator<Button> i$ = buttons.iterator();
            while (i$.hasNext()) {
                Button b;
                String str = (String)(b = i$.next()).getData();
                b.setSelection(str != null && str.endsWith(data));
            }
        }

        private void setChatMode(int mode) {
            if (this.chat_mode == mode) {
                return;
            }
            this.chat_mode = mode;
            this.selectButtonGroup(this.mode_buttons, mode);
        }

        private void buildChatMode(int mode, boolean activate) {
            Download download = this.current_download;
            this.chat_mode = mode;
            if (mode != this.CHAT_GENERAL || this.last_build_chat_mode != mode) {
                for (Control c : this.middle.getChildren()) {
                    c.dispose();
                }
                if (mode == this.CHAT_DOWNLOAD || mode == this.CHAT_TAG && download == null && this.current_ds_tag == null) {
                    this.middle.setVisible(false);
                    this.middle.setText("");
                    GridData grid_data = new GridData(1040);
                    grid_data.widthHint = 0;
                    this.middle.setLayoutData((Object)grid_data);
                } else if (mode == this.CHAT_TAG) {
                    List<Tag> tags;
                    this.middle.setVisible(true);
                    this.middle.setText(MessageText.getString("label.tag.selection"));
                    List<Tag> list = tags = this.current_download == null ? new ArrayList<Tag>() : TagManagerFactory.getTagManager().getTagsForTaggable(3, PluginCoreUtils.unwrap(this.current_download));
                    if (this.current_ds_tag != null && !tags.contains(this.current_ds_tag)) {
                        tags.add(this.current_ds_tag);
                    }
                    GridLayout layout = new GridLayout();
                    layout.horizontalSpacing = 1;
                    layout.verticalSpacing = 1;
                    layout.numColumns = 1;
                    this.middle.setLayout((Layout)layout);
                    GridData grid_data = new GridData(1040);
                    this.middle.setLayoutData((Object)grid_data);
                    if (tags.size() == 0) {
                        this.current_tag = null;
                        Label label = new Label((Composite)this.middle, 0);
                        label.setText(MessageText.getString("label.none.assigned"));
                        label.setEnabled(false);
                    } else {
                        tags = TagUIUtils.sortTags(tags);
                        this.current_tag = tags.get(0);
                        ArrayList<Button> buttons = new ArrayList<Button>();
                        for (final Tag tag : tags) {
                            Button button = new Button((Composite)this.middle, 2);
                            button.setText(tag.getTagName(true));
                            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    BetaSubViewHolder.this.current_tag = tag;
                                    BetaSubViewHolder.this.activate();
                                }
                            });
                            buttons.add(button);
                        }
                        ((Button)buttons.get(0)).setSelection(true);
                        this.setupButtonGroup(buttons);
                    }
                } else if (mode == this.CHAT_GENERAL) {
                    String[][] general_data;
                    this.middle.setVisible(true);
                    this.middle.setText(MessageText.getString("azbuddy.dchat.general.chats"));
                    GridLayout layout = new GridLayout();
                    layout.horizontalSpacing = 1;
                    layout.verticalSpacing = 1;
                    layout.numColumns = 1;
                    this.middle.setLayout((Layout)layout);
                    GridData grid_data = new GridData(1040);
                    this.middle.setLayoutData((Object)grid_data);
                    ArrayList<Button> buttons = new ArrayList<Button>();
                    for (String[] entry : general_data = new String[][]{{"label.help", "General: Help"}, {"label.announce", "General: Announce"}, {"label.beta", "test:beta:chat"}}) {
                        final String key = entry[1];
                        if (key == "test:beta:chat" && !Constants.isCVSVersion()) continue;
                        Button button = new Button((Composite)this.middle, 2);
                        button.setText(MessageText.getString(entry[0]));
                        button.setData((Object)key);
                        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                BetaSubViewHolder.this.current_general = key;
                                BetaSubViewHolder.this.activate();
                            }
                        });
                        buttons.add(button);
                    }
                    this.setupButtonGroup(buttons);
                    if (this.current_general != null) {
                        this.selectButtonGroup(buttons, this.current_general);
                    }
                } else {
                    this.middle.setVisible(true);
                    this.middle.setText(MessageText.getString("azbuddy.dchat.fave.chats"));
                    List<String[]> list = BuddyPluginView.this.plugin.getBeta().getFavourites();
                    int num_faves = list.size();
                    boolean use_scroll = num_faves > 4;
                    GridLayout layout = new GridLayout();
                    layout.horizontalSpacing = 1;
                    layout.verticalSpacing = 1;
                    layout.numColumns = 1;
                    this.middle.setLayout((Layout)layout);
                    GridData grid_data = new GridData(1040);
                    this.middle.setLayoutData((Object)grid_data);
                    if (num_faves == 0) {
                        Label label = new Label((Composite)this.middle, 0);
                        label.setText(MessageText.getString("label.none.assigned"));
                        label.setEnabled(false);
                    } else {
                        Group fave_area;
                        if (use_scroll) {
                            final ScrolledComposite scrollable = new ScrolledComposite((Composite)this.middle, 512){
                                private final Point bar_size;
                                private int x_adjust;
                                private boolean first_time;
                                private boolean hacking;
                                {
                                    this.first_time = true;
                                    Composite composite = new Composite((Composite)BetaSubViewHolder.this.middle, 768);
                                    composite.setSize(1, 1);
                                    this.bar_size = composite.computeSize(0, 0);
                                    composite.dispose();
                                }

                                public Point computeSize(int wHint, int hHint, boolean changed) {
                                    Point point = super.computeSize(wHint, hHint, changed);
                                    if (!this.hacking) {
                                        final boolean was_visible = this.getVerticalBar().isVisible();
                                        Utils.execSWTThreadLater(0, new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void run() {
                                                if (this.isDisposed()) {
                                                    return;
                                                }
                                                boolean is_visible = this.getVerticalBar().isVisible();
                                                if (first_time || was_visible != is_visible) {
                                                    x_adjust = is_visible ? 0 : -(this).bar_size.x;
                                                    try {
                                                        hacking = true;
                                                        BetaSubViewHolder.this.middle.getParent().layout(true, true);
                                                        Object var3_2 = null;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var3_3 = null;
                                                        hacking = false;
                                                        throw throwable;
                                                    }
                                                    hacking = false;
                                                    {
                                                    }
                                                }
                                            }
                                        });
                                    }
                                    point.x += this.x_adjust;
                                    return point;
                                }
                            };
                            scrollable.setLayoutData((Object)new GridData(1040));
                            final Composite scrollChild = new Composite((Composite)scrollable, 0);
                            GridLayout gLayoutChild = new GridLayout();
                            gLayoutChild.numColumns = 1;
                            gLayoutChild.horizontalSpacing = 1;
                            gLayoutChild.verticalSpacing = 1;
                            scrollChild.setLayout((Layout)gLayoutChild);
                            scrollChild.setLayoutData((Object)new GridData(1040));
                            scrollable.setContent((Control)scrollChild);
                            scrollable.setExpandVertical(true);
                            scrollable.setExpandHorizontal(true);
                            scrollable.setAlwaysShowScrollBars(false);
                            scrollable.setMinSize(scrollChild.computeSize(-1, -1));
                            scrollable.addControlListener((ControlListener)new ControlAdapter(){

                                public void controlResized(ControlEvent e) {
                                    Rectangle r = scrollable.getClientArea();
                                    scrollable.setMinSize(scrollChild.computeSize(-1, -1));
                                }
                            });
                            fave_area = scrollChild;
                        } else {
                            fave_area = this.middle;
                        }
                        ArrayList<Button> buttons = new ArrayList<Button>();
                        Collections.sort(list, new Comparator<String[]>(){
                            Comparator<String> c = new FormattersImpl().getAlphanumericComparator(true);

                            @Override
                            public int compare(String[] o1, String[] o2) {
                                int result = o1[0].compareTo(o2[0]);
                                if (result == 0) {
                                    result = this.c.compare(o1[1], o2[1]);
                                }
                                return result;
                            }
                        });
                        for (String[] entry : list) {
                            final String net = entry[0];
                            final String key = entry[1];
                            Button button = new Button((Composite)fave_area, 2);
                            String short_name = "(" + MessageText.getString(net == "Public" ? "label.public.short" : "label.anon.short") + ")";
                            if ((short_name = short_name + " " + key).length() > 30) {
                                short_name = short_name.substring(0, 30) + "...";
                            }
                            String long_name = "(" + MessageText.getString(net == "Public" ? "label.public" : "label.anon") + ")";
                            long_name = long_name + " " + key;
                            button.setText(short_name);
                            button.setAlignment(16384);
                            button.setToolTipText(long_name);
                            button.setData((Object)(net + ":" + key));
                            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    BetaSubViewHolder.this.current_favourite_net = net;
                                    BetaSubViewHolder.this.current_favourite_key = key;
                                    BetaSubViewHolder.this.activate();
                                }
                            });
                            buttons.add(button);
                        }
                        this.setupButtonGroup(buttons);
                        if (this.current_favourite_key != null) {
                            this.selectButtonGroup(buttons, this.current_favourite_net + ":" + this.current_favourite_key);
                        }
                    }
                }
                this.middle.getParent().layout(true, true);
                this.last_build_chat_mode = mode;
            }
            if (activate) {
                this.activate();
            }
        }

        private void activate() {
            if (this.rebuild_outstanding) {
                this.rebuild_outstanding = false;
                if (this.current_download == null && (this.chat_mode == this.CHAT_DOWNLOAD || this.chat_mode == this.CHAT_TAG)) {
                    this.setChatMode(this.current_ds_tag == null ? this.CHAT_GENERAL : this.CHAT_TAG);
                }
                this.buildChatMode(this.chat_mode, false);
            }
            this.activateNetwork(null);
        }

        private void activateNetwork(String network) {
            if (network != null) {
                this.activateNetwork(network, false);
            } else if (this.chat_mode == this.CHAT_FAVOURITES && this.current_favourite_net != null) {
                this.activateNetwork(this.current_favourite_net, true);
            } else {
                Download download = this.current_download;
                if (download == null) {
                    this.activateNetwork("Public", true);
                } else {
                    String[] nets = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
                    boolean pub = false;
                    boolean anon = false;
                    for (String net : nets) {
                        if (net == "Public") {
                            pub = true;
                            continue;
                        }
                        if (net != "I2P") continue;
                        anon = true;
                    }
                    if (pub && anon) {
                        this.activateNetwork("Public", true);
                        this.activateNetwork("I2P", false);
                    } else if (pub) {
                        this.activateNetwork("Public", true);
                    } else if (anon) {
                        this.activateNetwork("I2P", true);
                    }
                }
            }
        }

        private void activateNetwork(String network, boolean select_tab) {
            Tag tag;
            Download download;
            Object key = this.chat_mode == this.CHAT_DOWNLOAD ? ((download = this.current_download) == null ? null : BuddyPluginView.this.plugin.getBeta().getDownloadKey(download)) : (this.chat_mode == this.CHAT_TAG ? ((tag = this.current_tag) == null ? null : TagUIUtils.getChatKey(tag)) : (this.chat_mode == this.CHAT_GENERAL ? this.current_general : this.current_favourite_key));
            this.activateChat(network, (String)key, select_tab);
        }

        private void activateChat(final String network, final String key, boolean select_tab) {
            final Composite chat_composite = this.chat_composites[network == "Public" ? 0 : 1];
            if (chat_composite == null) {
                return;
            }
            final String comp_key = network + ":" + key;
            String existing_comp_key = (String)chat_composite.getData();
            if (existing_comp_key == null || !existing_comp_key.equals(comp_key)) {
                for (Control c : chat_composite.getChildren()) {
                    c.dispose();
                }
                if (key == null) {
                    chat_composite.setData((Object)comp_key);
                    return;
                }
                AsyncDispatcher disp = network == "Public" ? public_dispatcher : anon_dispatcher;
                final AtomicInteger counter = network == "Public" ? public_done : anon_done;
                disp.dispatch(new AERunnable(){

                    public void runSupport() {
                        if (chat_composite.isDisposed()) {
                            return;
                        }
                        try {
                            final BuddyPluginBeta.ChatInstance chat = network == "I2P" && !BuddyPluginView.this.plugin.getBeta().isI2PAvailable() ? null : BuddyPluginView.this.plugin.getBeta().getChat(network, key);
                            counter.incrementAndGet();
                            Utils.execSWTThread(new Runnable(){

                                public void run() {
                                    if (chat_composite.isDisposed()) {
                                        return;
                                    }
                                    for (Control c : chat_composite.getChildren()) {
                                        c.dispose();
                                    }
                                    if (chat == null) {
                                        GridLayout layout = new GridLayout();
                                        layout.numColumns = 3;
                                        chat_composite.setLayout((Layout)layout);
                                        Label label = new Label(chat_composite, 0);
                                        label.setText(MessageText.getString("azbuddy.dchat.not.installed"));
                                        final Button install_button = new Button(chat_composite, 0);
                                        install_button.setText(MessageText.getString("UpdateWindow.columns.install"));
                                        install_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                final boolean[] result = new boolean[]{false};
                                                BuddyPluginUtils.installI2PHelper(null, result, new Runnable(){
                                                    private long start = SystemTime.getMonotonousTime();
                                                    private TimerEventPeriodic timer;

                                                    public void run() {
                                                        if (result[0]) {
                                                            Utils.execSWTThread(new Runnable(){

                                                                public void run() {
                                                                    install_button.setEnabled(false);
                                                                }
                                                            });
                                                            this.timer = SimpleTimer.addPeriodicEvent("install-waiter", 1000L, new TimerEventPerformer(){

                                                                public void perform(TimerEvent event2) {
                                                                    if (BuddyPluginView.this.plugin.getBeta().isI2PAvailable()) {
                                                                        timer.cancel();
                                                                        Utils.execSWTThread(new Runnable(){

                                                                            public void run() {
                                                                                String existing_comp_key = (String)chat_composite.getData();
                                                                                if (existing_comp_key == null || existing_comp_key.equals(comp_key)) {
                                                                                    counter.set(0);
                                                                                    chat_composite.setData(null);
                                                                                    BetaSubViewHolder.this.activateChat(network, key, true);
                                                                                }
                                                                            }
                                                                        });
                                                                    } else if (SystemTime.getMonotonousTime() - start > 300000L) {
                                                                        timer.cancel();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                        ArrayList<Button> buttons = new ArrayList<Button>();
                                        buttons.add(install_button);
                                        Utils.makeButtonsEqualWidth(buttons);
                                        chat_composite.layout(true, true);
                                    } else {
                                        BuddyPluginViewBetaChat view = new BuddyPluginViewBetaChat(BuddyPluginView.this, BuddyPluginView.this.plugin, chat, chat_composite);
                                        ((CTabItem)chat_composite.getData("tabitem")).setToolTipText(key);
                                        chat_composite.layout(true, true);
                                        chat_composite.setData((Object)comp_key);
                                        chat_composite.setData("viewitem", (Object)view);
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
                if (counter.get() == 0) {
                    GridLayout layout = new GridLayout();
                    layout.numColumns = 1;
                    chat_composite.setLayout((Layout)layout);
                    Label label = new Label(chat_composite, 0);
                    label.setText(MessageText.getString("v3.MainWindow.view.wait"));
                    GridData grid_data = new GridData(1808);
                    label.setLayoutData((Object)grid_data);
                }
                chat_composite.layout(true, true);
            } else {
                BuddyPluginViewBetaChat existing_chat = (BuddyPluginViewBetaChat)chat_composite.getData("viewitem");
                if (existing_chat != null) {
                    existing_chat.activate();
                }
            }
            if (select_tab) {
                this.tab_folder.setSelection(network == "Public" ? this.public_item : this.anon_item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setDataSource(Object obj) {
            Download dl = null;
            DiskManagerFileInfo dl_file = null;
            Tag tag = null;
            if (obj instanceof Object[]) {
                Object[] ds = (Object[])obj;
                if (ds.length > 0) {
                    if (ds[0] instanceof Download) {
                        dl = (Download)ds[0];
                    } else if (ds[0] instanceof DiskManagerFileInfo) {
                        dl_file = (DiskManagerFileInfo)ds[0];
                    }
                }
            } else if (obj instanceof Download) {
                dl = (Download)obj;
            } else if (obj instanceof DiskManagerFileInfo) {
                dl_file = (DiskManagerFileInfo)obj;
            } else if (obj instanceof Tag) {
                tag = (Tag)obj;
            }
            if (dl_file != null) {
                try {
                    dl = dl_file.getDownload();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            BetaSubViewHolder betaSubViewHolder = this;
            synchronized (betaSubViewHolder) {
                if (dl == this.current_download && tag == this.current_ds_tag) {
                    return;
                }
                this.current_download = dl;
                this.current_ds_tag = tag;
                this.rebuild_outstanding = true;
                if (this.have_focus) {
                    this.activate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gotFocus() {
            BetaSubViewHolder betaSubViewHolder = this;
            synchronized (betaSubViewHolder) {
                this.have_focus = true;
                this.activate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lostFocus() {
            BetaSubViewHolder betaSubViewHolder = this;
            synchronized (betaSubViewHolder) {
                this.have_focus = false;
            }
        }

        private void destroy() {
        }
    }

    protected class statusUpdater
    implements BuddyPluginTrackerListener {
        private UISWTStatusEntry label;
        private UISWTStatusEntry status;
        private BuddyPluginTracker tracker;
        private TimerEventPeriodic update_event;
        private CryptoManager crypto;
        private boolean crypto_ok;
        private boolean has_buddies;

        protected statusUpdater(UISWTInstance instance) {
            this.status = BuddyPluginView.this.ui_instance.createStatusEntry();
            this.label = BuddyPluginView.this.ui_instance.createStatusEntry();
            this.label.setText(MessageText.getString("azbuddy.tracker.bbb.status.title"));
            this.label.setTooltipText(MessageText.getString("azbuddy.tracker.bbb.status.title.tooltip"));
            this.tracker = BuddyPluginView.this.plugin.getTracker();
            this.status.setText("");
            this.status.setImageEnabled(true);
            this.tracker.addListener(this);
            this.has_buddies = BuddyPluginView.this.plugin.getBuddies().size() > 0;
            this.status.setVisible(this.tracker.isEnabled() && this.has_buddies);
            this.label.setVisible(this.tracker.isEnabled() && this.has_buddies);
            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                public void entryClicked(UISWTStatusEntry entry) {
                    try {
                        BuddyPluginView.this.plugin.getPluginInterface().getUIManager().openURL(new URL("http://wiki.vuze.com"));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            };
            this.status.setListener(click_listener);
            this.label.setListener(click_listener);
            BuddyPluginView.this.plugin.addListener(new BuddyPluginAdapter(){

                public void initialised(boolean available) {
                }

                public void buddyAdded(BuddyPluginBuddy buddy) {
                    if (!statusUpdater.this.has_buddies) {
                        statusUpdater.this.has_buddies = true;
                        statusUpdater.this.updateStatus();
                    }
                }

                public void buddyRemoved(BuddyPluginBuddy buddy) {
                    statusUpdater.this.has_buddies = BuddyPluginView.this.plugin.getBuddies().size() > 0;
                    if (!statusUpdater.this.has_buddies) {
                        statusUpdater.this.updateStatus();
                    }
                }

                public void buddyChanged(BuddyPluginBuddy buddy) {
                }

                public void messageLogged(String str, boolean error) {
                }

                public void enabledStateChanged(boolean enabled) {
                }
            });
            this.crypto = CryptoManagerFactory.getSingleton();
            this.crypto.addKeyListener(new CryptoManagerKeyListener(){

                public void keyChanged(CryptoHandler handler) {
                }

                public void keyLockStatusChanged(CryptoHandler handler) {
                    boolean ok = statusUpdater.this.crypto.getECCHandler().isUnlocked();
                    if (ok != statusUpdater.this.crypto_ok) {
                        statusUpdater.this.crypto_ok = ok;
                        statusUpdater.this.updateStatus();
                    }
                }
            });
            this.crypto_ok = this.crypto.getECCHandler().isUnlocked();
            this.updateStatus();
        }

        public void networkStatusChanged(BuddyPluginTracker tracker, int new_status) {
            this.updateStatus();
        }

        protected synchronized void updateStatus() {
            if (this.tracker.isEnabled() && this.has_buddies) {
                this.status.setVisible(true);
                this.label.setVisible(true);
                if (this.has_buddies && !this.crypto_ok) {
                    this.status.setImage(BuddyPluginView.this.iconNLI);
                    this.status.setTooltipText(MessageText.getString("azbuddy.tracker.bbb.status.nli"));
                    this.disableUpdates();
                } else {
                    int network_status = this.tracker.getNetworkStatus();
                    if (network_status == 1) {
                        this.status.setImage(BuddyPluginView.this.iconIDLE);
                        this.status.setTooltipText(MessageText.getString("azbuddy.tracker.bbb.status.idle"));
                        this.disableUpdates();
                    } else if (network_status == 3) {
                        this.status.setImage(BuddyPluginView.this.iconIN);
                        this.enableUpdates();
                    } else {
                        this.status.setImage(BuddyPluginView.this.iconOUT);
                        this.enableUpdates();
                    }
                }
            } else {
                this.disableUpdates();
                this.status.setVisible(false);
                this.label.setVisible(false);
            }
        }

        protected void enableUpdates() {
            if (this.update_event == null) {
                this.update_event = SimpleTimer.addPeriodicEvent("Buddy:GuiUpdater", 2500L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        statusUpdater statusUpdater2 = statusUpdater.this;
                        synchronized (statusUpdater2) {
                            if (statusUpdater.this.tracker.isEnabled() && (statusUpdater.this.crypto_ok || !statusUpdater.this.has_buddies)) {
                                int ns = statusUpdater.this.tracker.getNetworkStatus();
                                String tt = ns == 1 ? MessageText.getString("azbuddy.tracker.bbb.status.idle") : (ns == 3 ? MessageText.getString("azbuddy.tracker.bbb.status.in") + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkReceiveBytesPerSecond()) : MessageText.getString("azbuddy.tracker.bbb.status.out") + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(statusUpdater.this.tracker.getNetworkSendBytesPerSecond()));
                                statusUpdater.this.status.setTooltipText(tt);
                            }
                        }
                    }
                });
            }
        }

        protected void disableUpdates() {
            if (this.update_event != null) {
                this.update_event.cancel();
                this.update_event = null;
            }
        }

        public void enabledStateChanged(BuddyPluginTracker tracker, boolean enabled) {
            this.updateStatus();
        }
    }
}

