/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.views.stats.DHTOpsPanel;

public class DHTOpsView
implements UISWTViewEventListener {
    public static final int DHT_TYPE_MAIN = 0;
    public static final String MSGID_PREFIX = "DHTOpsView";
    DHT dht;
    Composite panel;
    DHTOpsPanel drawPanel;
    private final boolean autoAlpha;
    private final boolean autoDHT;
    private int dht_type;
    private AzureusCore core;
    private UISWTView swtView;

    public DHTOpsView() {
        this(false);
    }

    public DHTOpsView(boolean autoAlpha) {
        this(autoAlpha, true);
    }

    public DHTOpsView(boolean autoAlpha, boolean autoDHT) {
        this.autoAlpha = autoAlpha;
        this.autoDHT = autoDHT;
    }

    private void init(AzureusCore core) {
        try {
            PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                if (this.drawPanel != null) {
                    this.drawPanel.setUnavailable();
                }
                return;
            }
            DHTPlugin dht_plugin = (DHTPlugin)dht_pi.getPlugin();
            DHT[] dhts = dht_plugin.getDHTs();
            for (int i = 0; i < dhts.length; ++i) {
                if (dhts[i].getTransport().getNetwork() != this.dht_type) continue;
                this.dht = dhts[i];
                break;
            }
            if (this.drawPanel != null && this.dht == null && !dht_plugin.isInitialising()) {
                this.drawPanel.setUnavailable();
            }
            if (this.dht == null) {
                return;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void setDHT(DHT _dht) {
        this.dht = _dht;
    }

    public void initialize(Composite composite) {
        if (this.autoDHT) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    DHTOpsView.this.core = core;
                    DHTOpsView.this.init(core);
                }
            });
        }
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new FillLayout());
        this.drawPanel = new DHTOpsPanel(this.panel);
        this.drawPanel.setAutoAlpha(this.autoAlpha);
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        if (this.dht == null) {
            if (this.core != null) {
                this.init(this.core);
            } else {
                return;
            }
        }
        if (this.dht != null) {
            this.drawPanel.refreshView(this.dht);
        }
    }

    private String getTitleID() {
        return "DHTOpsView.title.full";
    }

    private void delete() {
        if (this.drawPanel != null) {
            this.drawPanel.delete();
        }
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                if (!(event2.getData() instanceof Number)) break;
                this.dht_type = ((Number)event2.getData()).intValue();
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

