/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerUtils {
    private static RunDownloadManager run;
    private static AsyncDispatcher async;

    public static void setRunRunnable(RunDownloadManager run) {
        ManagerUtils.run = run;
    }

    public static void run(final DownloadManager dm) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    AZ3Functions.provider prov = AZ3Functions.getProvider();
                    if (prov != null) {
                        prov.setOpened(dm, true);
                    }
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            if (run != null) {
                                run.run(dm);
                            } else {
                                Utils.launch(dm.getSaveLocation().toString());
                            }
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(DownloadManager dm) {
        ManagerUtils.open(dm, false);
    }

    public static void open(final DownloadManager dm, final boolean open_containing_folder_mode) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            ManagerUtils.open(dm.getSaveLocation(), open_containing_folder_mode);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(final DiskManagerFileInfo file, final boolean open_containing_folder_mode) {
        if (file != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(file);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            File this_file = file.getFile(true);
                            File parent_file = open_containing_folder_mode ? this_file.getParentFile() : null;
                            ManagerUtils.open(parent_file == null ? this_file : parent_file);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(File f, boolean open_containing_folder_mode) {
        if (open_containing_folder_mode) {
            Utils.launch(f.getParent());
        } else {
            ManagerUtils.open(f);
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Utils.launch(f.toString());
        } else {
            Utils.launch(f.getParent().toString());
        }
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65;
    }

    public static boolean isPauseable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65 && state != 100;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().publishTorrent(torrent);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static void queue(DownloadManager dm, Composite panelNotUsed) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateQueued();
        }
    }

    public static void pause(DownloadManager dm, Shell shell) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65) {
            return;
        }
        ManagerUtils.asyncPause(dm);
    }

    public static void stop(DownloadManager dm, Shell shell) {
        ManagerUtils.stop(dm, shell, 70);
    }

    public static void stop(final DownloadManager dm, final Shell shell, final int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65 || state == stateAfterStopped) {
            return;
        }
        boolean stopme = true;
        if (state == 60 && dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", false)) {
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        ManagerUtils.stop(dm, shell, stateAfterStopped);
                    }
                });
                return;
            }
            Shell aShell = shell == null ? Utils.findAnyShell() : shell;
            MessageBox mb = new MessageBox(aShell, 200);
            mb.setText(MessageText.getString("seedmore.title"));
            mb.setMessage(MessageText.getString("seedmore.shareratio") + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
            int action = mb.open();
            boolean bl = stopme = action == 64;
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData) {
        ManagerUtils.remove(dm, unused_shell, bDeleteTorrent, bDeleteData, null);
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData, AERunnable deleteFailed) {
        TorrentUtil.removeDownloads(new DownloadManager[]{dm}, null);
        Debug.out("ManagerUtils.remove is Deprecated.  Use TorrentUtil.removeDownloads");
    }

    public static void asyncStopDelete(final DownloadManager dm, int stateAfterStopped, final boolean bDeleteTorrent, final boolean bDeleteData, final AERunnable deleteFailed) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                block13: {
                    try {
                        boolean reallyDeleteData = bDeleteData && !dm.getDownloadState().getFlag(64L);
                        dm.getGlobalManager().removeDownloadManager(dm, bDeleteTorrent, reallyDeleteData);
                    }
                    catch (GlobalManagerDownloadRemovalVetoException f) {
                        try {
                            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                            ShareManager sm = pi.getShareManager();
                            Tracker tracker = pi.getTracker();
                            ShareResource[] shares = sm.getShares();
                            TOTorrent torrent = dm.getTorrent();
                            byte[] target_hash = torrent.getHash();
                            for (ShareResource share : shares) {
                                int type = share.getType();
                                byte[] hash = type == 2 ? ((ShareResourceDir)share).getItem().getTorrent().getHash() : (type == 1 ? ((ShareResourceFile)share).getItem().getTorrent().getHash() : null);
                                if (hash == null || !Arrays.equals(target_hash, hash)) continue;
                                try {
                                    dm.stopIt(70, false, false);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                try {
                                    TrackerTorrent tracker_torrent = tracker.getTorrent(PluginCoreUtils.wrap(torrent));
                                    if (tracker_torrent != null) {
                                        tracker_torrent.stop();
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                share.delete();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!f.isSilent()) {
                            UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), f.getMessage(), null, null, -1);
                        }
                        if (deleteFailed != null) {
                            deleteFailed.runSupport();
                        }
                    }
                    catch (Exception ex) {
                        Debug.printStackTrace(ex);
                        if (deleteFailed == null) break block13;
                        deleteFailed.runSupport();
                    }
                }
            }
        });
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                dm.stopIt(stateAfterStopped, false, false);
            }
        });
    }

    public static void asyncPause(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                dm.pause();
            }
        });
    }

    public static void asyncStartAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static void asyncStopAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().stopAllDownloads();
            }
        });
    }

    public static void asyncPause() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloadsForPeriod(seconds);
            }
        });
    }

    public static void asyncResume() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().resumeDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final List<DownloadManager> dms, final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void azureusCoreRunning(AzureusCore core) {
                final ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
                final DownloadManagerAdapter listener = new DownloadManagerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void stateChanged(DownloadManager manager, int state) {
                        List list = paused;
                        synchronized (list) {
                            if (!paused.remove(manager)) {
                                return;
                            }
                        }
                        manager.removeListener(this);
                    }
                };
                for (DownloadManager dm : dms) {
                    if (!ManagerUtils.isPauseable(dm) || !dm.pause()) continue;
                    ArrayList<DownloadManager> arrayList = paused;
                    synchronized (arrayList) {
                        paused.add(dm);
                    }
                    dm.addListener(listener, false);
                }
                if (paused.size() > 0) {
                    SimpleTimer.addEvent("ManagerUtils.resumer", SystemTime.getOffsetTime(seconds * 1000), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            ArrayList to_resume = new ArrayList();
                            List list = paused;
                            synchronized (list) {
                                to_resume.addAll(paused);
                                paused.clear();
                            }
                            for (DownloadManager dm : to_resume) {
                                dm.removeListener(listener);
                                try {
                                    dm.resume();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    static {
        async = new AsyncDispatcher(2000);
    }

    public static interface RunDownloadManager {
        public void run(DownloadManager var1);
    }
}

