/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMediaRendererManual
extends DeviceMediaRendererImpl {
    private static final Object COPY_ERROR_KEY = new Object();
    private static final Object COPY_PENDING_KEY = new Object();
    private boolean can_copy_to_folder = true;
    private boolean copy_outstanding;
    private boolean copy_outstanding_set;
    private AEThread2 copy_thread;
    private AESemaphore copy_sem = new AESemaphore("Device:copy");
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);

    protected DeviceMediaRendererManual(DeviceManagerImpl _manager, String _uid, String _classification, boolean _manual, String _name) {
        super(_manager, _uid, _classification, _manual, _name);
    }

    protected DeviceMediaRendererManual(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    protected void initialise() {
        super.initialise();
        if (this.getPersistentBooleanProperty("copy_outstanding", false)) {
            this.setCopyOutstanding();
        }
        this.addListener(new TranscodeTargetListener(){

            public void fileAdded(TranscodeFile file) {
                this.updateStatus(file);
            }

            public void fileChanged(TranscodeFile file, int type, Object data) {
                this.updateStatus(file);
            }

            public void fileRemoved(TranscodeFile file) {
                DeviceMediaRendererManual.this.setCopyOutstanding();
            }

            private void updateStatus(TranscodeFile file) {
                if (file.isComplete() && !file.isCopiedToDevice()) {
                    DeviceMediaRendererManual.this.setCopyOutstanding();
                }
            }
        });
    }

    @Override
    public boolean canAssociate() {
        return false;
    }

    @Override
    public boolean canRestrictAccess() {
        return false;
    }

    @Override
    public boolean canFilterFilesView() {
        return false;
    }

    @Override
    public boolean isBrowsable() {
        return false;
    }

    @Override
    public boolean canCopyToFolder() {
        return this.can_copy_to_folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanCopyToFolder(boolean can) {
        this.can_copy_to_folder = can;
        if (!can) {
            this.setPersistentBooleanProperty("copy_outstanding", false);
            DeviceMediaRendererManual deviceMediaRendererManual = this;
            synchronized (deviceMediaRendererManual) {
                this.copy_outstanding = false;
                this.copy_outstanding_set = false;
            }
        }
    }

    @Override
    public File getCopyToFolder() {
        String str = this.getPersistentStringProperty("copy_to_folder", null);
        if (str == null) {
            return null;
        }
        return new File(str);
    }

    @Override
    public void setCopyToFolder(File file) {
        this.setPersistentStringProperty("copy_to_folder", file == null ? null : file.getAbsolutePath());
        if (this.getAutoCopyToFolder()) {
            this.setCopyOutstanding();
        }
    }

    @Override
    public boolean isLivenessDetectable() {
        return this.getPersistentBooleanProperty("live_det", false);
    }

    public void setLivenessDetectable(boolean b) {
        this.setPersistentBooleanProperty("live_det", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCopyToFolderPending() {
        if (!this.can_copy_to_folder) {
            return 0;
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            if (!this.copy_outstanding) {
                return 0;
            }
        }
        TranscodeFileImpl[] files = this.getFiles();
        int result = 0;
        for (TranscodeFileImpl file : files) {
            if (!file.isComplete() || file.isCopiedToDevice()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean getAutoCopyToFolder() {
        return this.getPersistentBooleanProperty("auto_copy", false);
    }

    @Override
    public void setAutoCopyToFolder(boolean auto) {
        this.setPersistentBooleanProperty("auto_copy", auto);
        this.setCopyOutstanding();
    }

    @Override
    public void manualCopy() throws DeviceManagerException {
        if (this.getAutoCopyToFolder()) {
            throw new DeviceManagerException("Operation prohibited - auto copy enabled");
        }
        this.doCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCopyOutstanding() {
        if (!this.can_copy_to_folder) {
            return;
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            this.copy_outstanding_set = true;
            if (this.copy_thread == null) {
                this.copy_thread = new AEThread2("Device:copier", true){

                    public void run() {
                        DeviceMediaRendererManual.this.performCopy();
                    }
                };
                this.copy_thread.start();
            }
            this.copy_sem.release();
        }
    }

    @Override
    public boolean isAudioCompatible(TranscodeFile transcode_file) {
        if (this.getDeviceClassification().equals("sony.PSP")) {
            try {
                String name;
                File file = transcode_file.getSourceFile().getFile();
                if (file.exists() && ((name = file.getName().toLowerCase()).endsWith(".mp3") || name.endsWith(".wma"))) {
                    ((TranscodeFileImpl)transcode_file).setCopyToFolderOverride(".." + File.separator + "MUSIC");
                    return true;
                }
            }
            catch (Throwable e) {
                this.log("audio compatible check failed", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performCopy() {
        if (!this.can_copy_to_folder) {
            return;
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            this.copy_outstanding = true;
            this.async_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    DeviceMediaRendererManual.this.setPersistentBooleanProperty("copy_outstanding", true);
                }
            });
        }
        do {
            if (this.copy_sem.reserve(10000L)) {
                while (this.copy_sem.reserveIfAvailable()) {
                }
            }
            boolean auto_copy = this.getAutoCopyToFolder();
            boolean nothing_to_do = false;
            DeviceMediaRendererManual deviceMediaRendererManual2 = this;
            synchronized (deviceMediaRendererManual2) {
                if (!auto_copy) {
                    this.copy_thread = null;
                    nothing_to_do = true;
                } else {
                    this.copy_outstanding_set = false;
                }
            }
            if (!nothing_to_do) continue;
            this.setError(COPY_ERROR_KEY, null);
            int pending = this.getCopyToFolderPending();
            if (pending == 0) {
                this.setInfo(COPY_PENDING_KEY, null);
            } else {
                String str = MessageText.getString("devices.info.copypending", new String[]{String.valueOf(pending)});
                this.setInfo(COPY_PENDING_KEY, str);
            }
            return;
        } while (!this.doCopy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCopy() {
        if (!this.can_copy_to_folder) {
            return true;
        }
        this.setInfo(COPY_PENDING_KEY, null);
        File copy_to = this.getCopyToFolder();
        ArrayList<TranscodeFileImpl> to_copy = new ArrayList<TranscodeFileImpl>();
        boolean borked = false;
        TranscodeFileImpl[] files = this.getFiles();
        int pending = 0;
        for (TranscodeFileImpl transcodeFileImpl : files) {
            if (!transcodeFileImpl.isComplete() || transcodeFileImpl.isCopiedToDevice()) continue;
            ++pending;
            if (transcodeFileImpl.getCopyToDeviceFails() < 3L) {
                to_copy.add(transcodeFileImpl);
                continue;
            }
            String info = (String)transcodeFileImpl.getTransientProperty(COPY_ERROR_KEY);
            this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copyfail") + (info == null ? "" : " - " + info));
            borked = true;
        }
        boolean try_copy = false;
        if (to_copy.size() > 0) {
            if (!(!this.isLivenessDetectable() || this.isAlive() || copy_to != null && copy_to.exists())) {
                String str = MessageText.getString("devices.info.copypending2", new String[]{String.valueOf(pending)});
                this.setInfo(COPY_PENDING_KEY, str);
                borked = true;
            } else {
                this.setInfo(COPY_PENDING_KEY, null);
                boolean sub_borked = false;
                if (copy_to == null) {
                    this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copytonotset"));
                    sub_borked = true;
                } else if (!copy_to.exists()) {
                    File parent = copy_to.getParentFile();
                    if (parent != null && parent.canWrite()) {
                        copy_to.mkdir();
                    }
                    if (!copy_to.exists()) {
                        this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.mountrequired", new String[]{copy_to.getAbsolutePath()}));
                        sub_borked = true;
                    }
                }
                if (!sub_borked) {
                    if (!copy_to.canWrite()) {
                        this.setError(COPY_ERROR_KEY, MessageText.getString("device.error.copytonowrite", new String[]{copy_to.getAbsolutePath()}));
                        sub_borked = true;
                    } else {
                        try_copy = true;
                        this.setError(COPY_ERROR_KEY, null);
                    }
                }
                borked |= sub_borked;
            }
        } else {
            this.setInfo(COPY_PENDING_KEY, null);
        }
        DeviceMediaRendererManual deviceMediaRendererManual = this;
        synchronized (deviceMediaRendererManual) {
            if (to_copy.size() == 0 && !this.copy_outstanding_set && !borked) {
                this.copy_outstanding = false;
                this.async_dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        DeviceMediaRendererManual.this.setError(COPY_ERROR_KEY, null);
                        DeviceMediaRendererManual.this.setPersistentBooleanProperty("copy_outstanding", false);
                    }
                });
                this.copy_thread = null;
                return true;
            }
        }
        if (try_copy) {
            try {
                this.setBusy(true);
                for (TranscodeFileImpl transcode_file : to_copy) {
                    try {
                        File override_dir;
                        transcode_file.setCopyingToDevice(true);
                        File file = transcode_file.getTargetFile().getFile();
                        File target = new File(copy_to, file.getName());
                        String override_str = transcode_file.getCopyToFolderOverride();
                        if (override_str != null && (override_dir = new File(copy_to, override_str)).exists()) {
                            target = new File(override_dir, file.getName());
                        }
                        try {
                            FileUtil.copyFileWithException(file, target);
                            this.log("Copied file '" + file + ": to " + copy_to);
                            transcode_file.setCopiedToDevice(true);
                        }
                        catch (Throwable e) {
                            copy_to.delete();
                            transcode_file.setCopyToDeviceFailed();
                            transcode_file.setTransientProperty(COPY_ERROR_KEY, Debug.getNestedExceptionMessage(e));
                            this.log("Failed to copy file " + file, e);
                        }
                    }
                    catch (TranscodeException transcodeException) {}
                }
                Object var14_24 = null;
            }
            catch (Throwable throwable) {
                Object var14_25 = null;
                this.setBusy(false);
                throw throwable;
            }
            this.setBusy(false);
            {
            }
        }
        return false;
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        this.addDP(dp, "devices.copy.pending", this.copy_outstanding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            writer.println("auto_copy=" + this.getAutoCopyToFolder() + ", copy_to=" + this.getCopyToFolder() + ", copy_os=" + this.copy_outstanding);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    @Override
    public String getStatus() {
        String s = super.getStatus();
        if (COConfigurationManager.getIntParameter("User Mode") > 0 && this.getCopyToFolder() != null) {
            s = s + " (" + this.getCopyToFolder().getPath() + ")";
        }
        return s;
    }
}

