/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePriorityProvider;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderLinear;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderRange;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ExternalSeedReaderGetRight
extends ExternalSeedReaderImpl
implements PiecePriorityProvider {
    private static final int TARGET_REQUEST_SIZE_DEFAULT = 262144;
    private URL url;
    private int port;
    private ExternalSeedHTTPDownloader[] http_downloaders;
    private long[] downloader_offsets;
    private long[] downloader_lengths;
    private int piece_size;
    private int piece_group_size;
    private long[] piece_priorities;
    private boolean linear_download;

    protected ExternalSeedReaderGetRight(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url, Map _params) throws Exception {
        super(_plugin, _torrent, _url.getHost(), _params);
        int target_request_size = this.getIntParam(_params, "req_size", 262144);
        this.linear_download = this.getBooleanParam(_params, "linear", false);
        this.url = _url;
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        this.piece_size = (int)this.getTorrent().getPieceSize();
        this.piece_group_size = target_request_size / this.piece_size;
        if (this.piece_group_size == 0) {
            this.piece_group_size = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDownloaders() {
        ExternalSeedReaderGetRight externalSeedReaderGetRight = this;
        synchronized (externalSeedReaderGetRight) {
            if (this.http_downloaders != null) {
                return;
            }
            TOTorrent to_torrent = ((TorrentImpl)this.getTorrent()).getTorrent();
            String ua = this.getUserAgent();
            if (to_torrent.isSimpleTorrent()) {
                this.http_downloaders = new ExternalSeedHTTPDownloader[]{this.linear_download ? new ExternalSeedHTTPDownloaderLinear(this.url, ua) : new ExternalSeedHTTPDownloaderRange(this.url, ua)};
                this.downloader_offsets = new long[]{0L};
                this.downloader_lengths = new long[]{to_torrent.getSize()};
            } else {
                TOTorrentFile[] files = to_torrent.getFiles();
                this.http_downloaders = new ExternalSeedHTTPDownloader[files.length];
                this.downloader_offsets = new long[files.length];
                this.downloader_lengths = new long[files.length];
                long offset = 0L;
                String base_url = this.url.toString();
                if (base_url.endsWith("/")) {
                    base_url = base_url.substring(0, base_url.length() - 1);
                }
                try {
                    base_url = base_url + "/" + URLEncoder.encode(new String(to_torrent.getName(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                    for (int i = 0; i < files.length; ++i) {
                        TOTorrentFile file = files[i];
                        long length = file.getLength();
                        String file_url_str = base_url;
                        byte[][] bits = file.getPathComponents();
                        for (int j = 0; j < bits.length; ++j) {
                            file_url_str = file_url_str + "/" + URLEncoder.encode(new String(bits[j], "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                        }
                        this.http_downloaders[i] = this.linear_download ? new ExternalSeedHTTPDownloaderLinear(new URL(file_url_str), ua) : new ExternalSeedHTTPDownloaderRange(new URL(file_url_str), ua);
                        this.downloader_offsets[i] = offset;
                        this.downloader_lengths[i] = length;
                        offset += length;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    public boolean sameAs(ExternalSeedReader other) {
        if (other instanceof ExternalSeedReaderGetRight) {
            return this.url.toString().equals(((ExternalSeedReaderGetRight)other).url.toString());
        }
        return false;
    }

    public String getName() {
        return "HTTP Seed: " + this.url;
    }

    public URL getURL() {
        return this.url;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return this.piece_group_size;
    }

    protected boolean getRequestCanSpanPieces() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setActiveSupport(PeerManager peer_manager, boolean active) {
        if (!this.linear_download) return;
        if (peer_manager != null) {
            PiecePicker picker = PluginCoreUtils.unwrap(peer_manager).getPiecePicker();
            if (active) {
                this.piece_priorities = new long[peer_manager.getPieces().length];
                for (int i = 0; i < this.piece_priorities.length; ++i) {
                    this.piece_priorities[i] = 10000 + i;
                }
                picker.addPriorityProvider((PiecePriorityProvider)this);
            } else {
                this.piece_priorities = null;
                picker.removePriorityProvider((PiecePriorityProvider)this);
            }
        }
        if (active) return;
        ExternalSeedHTTPDownloader[] externalSeedHTTPDownloaderArray = this;
        synchronized (this) {
            if (this.http_downloaders == null) return;
            boolean bl = true;
            boolean downloaders_set = bl;
            // ** MonitorExit[var4_6] (shouldn't be in output)
            if (!downloaders_set) return;
            externalSeedHTTPDownloaderArray = this.http_downloaders;
            int n = externalSeedHTTPDownloaderArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExternalSeedHTTPDownloader d = externalSeedHTTPDownloaderArray[n2];
                d.deactivate();
                ++n2;
            }
            return;
        }
    }

    public long[] updatePriorities(PiecePicker picker) {
        return this.piece_priorities;
    }

    public void calculatePriorityOffsets(PeerManager peer_manager, int[] base_priorities) {
        if (this.linear_download) {
            for (int i = 0; i < base_priorities.length; ++i) {
                base_priorities[i] = 100000 + base_priorities.length - (i + 1);
            }
        } else {
            super.calculatePriorityOffsets(peer_manager, base_priorities);
        }
    }

    protected void readData(ExternalSeedReaderRequest request2) throws ExternalSeedException {
        this.readData(request2.getStartPieceNumber(), request2.getStartPieceOffset(), request2.getLength(), request2);
    }

    protected void readData(int start_piece_number, int start_piece_offset, int length, final ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        this.setupDownloaders();
        this.setReconnectDelay(30000, false);
        long request_start = (long)start_piece_number * (long)this.piece_size + (long)start_piece_offset;
        int request_length = length;
        if (this.http_downloaders.length == 1) {
            ExternalSeedHTTPDownloader http_downloader = this.http_downloaders[0];
            try {
                http_downloader.downloadRange(request_start, request_length, listener, this.isTransient());
            }
            catch (ExternalSeedException ese) {
                if (http_downloader.getLastResponse() == 503 && http_downloader.getLast503RetrySecs() >= 0) {
                    int retry_secs = http_downloader.getLast503RetrySecs();
                    this.setReconnectDelay(retry_secs * 1000, true);
                    throw new ExternalSeedException("Server temporarily unavailable, retrying in " + retry_secs + " seconds");
                }
                throw ese;
            }
        } else {
            long request_end = request_start + (long)request_length;
            final byte[][] overlap_buffer = new byte[][]{null};
            final int[] overlap_buffer_position = new int[]{0};
            for (int i = 0; i < this.http_downloaders.length; ++i) {
                long this_start = this.downloader_offsets[i];
                long this_end = this_start + this.downloader_lengths[i];
                if (this_end <= request_start) continue;
                if (this_start >= request_end) break;
                long sub_request_start = Math.max(request_start, this_start);
                long sub_request_end = Math.min(request_end, this_end);
                final int sub_len = (int)(sub_request_end - sub_request_start);
                if (sub_len == 0) continue;
                ExternalSeedHTTPDownloader http_downloader = this.http_downloaders[i];
                ExternalSeedHTTPDownloaderListener sub_request = new ExternalSeedHTTPDownloaderListener(){
                    private int bytes_read;
                    private byte[] current_buffer;
                    private int current_buffer_position;
                    private int current_buffer_length;
                    {
                        this.current_buffer = overlap_buffer[0];
                        this.current_buffer_position = overlap_buffer_position[0];
                        this.current_buffer_length = this.current_buffer == null ? -1 : Math.min(this.current_buffer.length, this.current_buffer_position + sub_len);
                    }

                    public byte[] getBuffer() throws ExternalSeedException {
                        if (this.current_buffer == null) {
                            this.current_buffer = listener.getBuffer();
                            this.current_buffer_position = 0;
                            this.current_buffer_length = Math.min(this.current_buffer.length, sub_len - this.bytes_read);
                        }
                        return this.current_buffer;
                    }

                    public void setBufferPosition(int position) {
                        this.current_buffer_position = position;
                        listener.setBufferPosition(position);
                    }

                    public int getBufferPosition() {
                        return this.current_buffer_position;
                    }

                    public int getBufferLength() {
                        return this.current_buffer_length;
                    }

                    public int getPermittedBytes() throws ExternalSeedException {
                        return listener.getPermittedBytes();
                    }

                    public int getPermittedTime() {
                        return listener.getPermittedTime();
                    }

                    public void reportBytesRead(int num) {
                        this.bytes_read += num;
                        listener.reportBytesRead(num);
                    }

                    public boolean isCancelled() {
                        return listener.isCancelled();
                    }

                    public void done() {
                        int rem = this.current_buffer.length - this.current_buffer_length;
                        if (this.bytes_read == sub_len) {
                            if (rem == 0) {
                                overlap_buffer[0] = null;
                                overlap_buffer_position[0] = 0;
                            } else {
                                overlap_buffer[0] = this.current_buffer;
                                overlap_buffer_position[0] = this.current_buffer_length;
                            }
                        }
                        this.current_buffer = null;
                        if (rem == 0) {
                            listener.done();
                        }
                    }
                };
                try {
                    http_downloader.downloadRange(sub_request_start - this_start, sub_len, sub_request, this.isTransient());
                    continue;
                }
                catch (ExternalSeedException ese) {
                    if (http_downloader.getLastResponse() == 503 && http_downloader.getLast503RetrySecs() >= 0) {
                        int retry_secs = http_downloader.getLast503RetrySecs();
                        this.setReconnectDelay(retry_secs * 1000, true);
                        throw new ExternalSeedException("Server temporarily unavailable, retrying in " + retry_secs + " seconds");
                    }
                    throw ese;
                }
            }
        }
    }
}

