/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderLinear
implements ExternalSeedHTTPDownloader {
    private final URL very_original_url;
    private final String user_agent;
    private int last_response;
    private int last_response_retry_after_secs;
    private Downloader downloader;

    public ExternalSeedHTTPDownloaderLinear(URL _url, String _user_agent) {
        this.very_original_url = _url;
        this.user_agent = _user_agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRange(long offset, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        Request request2;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == null) {
                this.downloader = new Downloader(listener, con_fail_is_perm_fail);
            }
            request2 = this.downloader.addRequest(offset, length, listener);
        }
        do {
            if (!request2.waitFor(1000)) continue;
            return;
        } while (!listener.isCancelled());
        throw new ExternalSeedException("request cancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Downloader to_destroy = null;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader != null) {
                to_destroy = this.downloader;
                this.downloader = null;
            }
        }
        if (to_destroy != null) {
            to_destroy.destroy(new ExternalSeedException("deactivated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destoyed(Downloader dead) {
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == dead) {
                this.downloader = null;
            }
        }
    }

    public void download(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    public void downloadSocket(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    public int getLastResponse() {
        return this.last_response;
    }

    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    static /* synthetic */ URL access$000(ExternalSeedHTTPDownloaderLinear x0) {
        return x0.very_original_url;
    }

    static /* synthetic */ String access$100(ExternalSeedHTTPDownloaderLinear x0) {
        return x0.user_agent;
    }

    static /* synthetic */ int access$202(ExternalSeedHTTPDownloaderLinear x0, int x1) {
        x0.last_response = x1;
        return x0.last_response;
    }

    static /* synthetic */ int access$302(ExternalSeedHTTPDownloaderLinear x0, int x1) {
        x0.last_response_retry_after_secs = x1;
        return x0.last_response_retry_after_secs;
    }

    static /* synthetic */ int access$300(ExternalSeedHTTPDownloaderLinear x0) {
        return x0.last_response_retry_after_secs;
    }

    protected class Downloader
    implements SEPasswordListener {
        private ExternalSeedHTTPDownloaderListener listener;
        private boolean con_fail_is_perm_fail;
        private volatile boolean destroyed;
        private List<Request> requests = new ArrayList<Request>();
        private RandomAccessFile raf = null;
        private File scratch_file = null;

        protected Downloader(ExternalSeedHTTPDownloaderListener _listener, boolean _con_fail_is_perm_fail) {
            this.listener = _listener;
            this.con_fail_is_perm_fail = _con_fail_is_perm_fail;
            new AEThread2("ES:downloader", true){

                public void run() {
                    Downloader.this.download();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void download() {
            connected = false;
            outcome = "";
            plugin_proxy = null;
            proxy_ok = false;
            try {
                try {
                    current_url = original_url = ExternalSeedHTTPDownloaderLinear.access$000(ExternalSeedHTTPDownloaderLinear.this);
                    current_proxy = null;
                    if (AENetworkClassifier.categoriseAddress(original_url.getHost()) != "Public" && (plugin_proxy = AEProxyFactory.getPluginProxy("webseed", original_url)) != null) {
                        current_url = plugin_proxy.getURL();
                        current_proxy = plugin_proxy.getProxy();
                    }
                    is = null;
                    SESecurityManager.setThreadPasswordHandler(this);
                    if (NetworkAdmin.getSingleton().hasMissingForcedBind()) {
                        throw new ExternalSeedException("Forced bind address is missing");
                    }
                    var9_10 = this;
                    synchronized (var9_10) {
                        if (!this.destroyed) ** break block41
                    }
                    var21_14 = null;
                    SESecurityManager.unsetThreadPasswordHandler();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable e) {
                        }
                    }
                    var24_20 = null;
                    if (plugin_proxy == null) return;
                    plugin_proxy.setOK(proxy_ok);
                    return;
                    {
                        try {
                            try {
                                this.scratch_file = AETemporaryFileHandler.createTempFile();
                                this.raf = new RandomAccessFile(this.scratch_file, "rw");
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 5, 10] lbl38 : MonitorExitStatement: MONITOREXIT : var9_10
                                if (current_proxy == null) {
                                    connection = (HttpURLConnection)current_url.openConnection();
                                } else {
                                    connection = (HttpURLConnection)current_url.openConnection(current_proxy);
                                    connection.setRequestProperty("HOST", plugin_proxy.getURLHostRewrite() + (original_url.getPort() == -1 ? "" : ":" + original_url.getPort()));
                                }
                                connection.setRequestProperty("Connection", "Keep-Alive");
                                connection.setRequestProperty("User-Agent", ExternalSeedHTTPDownloaderLinear.access$100(ExternalSeedHTTPDownloaderLinear.this));
                                time_remaining = this.listener.getPermittedTime();
                                if (time_remaining > 0) {
                                    connection.setConnectTimeout(time_remaining);
                                }
                                connection.connect();
                                proxy_ok = true;
                                time_remaining = this.listener.getPermittedTime();
                                if (time_remaining < 0) {
                                    throw new IOException("Timeout during connect");
                                }
                                connection.setReadTimeout(time_remaining);
                                connected = true;
                                response = connection.getResponseCode();
                                ExternalSeedHTTPDownloaderLinear.access$202(ExternalSeedHTTPDownloaderLinear.this, response);
                                ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, -1);
                                if (response == 503) {
                                    retry_after_date = connection.getHeaderFieldDate("Retry-After", -1L);
                                    if (retry_after_date <= -1L) {
                                        ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, connection.getHeaderFieldInt("Retry-After", -1));
                                    } else {
                                        ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, (int)((retry_after_date - System.currentTimeMillis()) / 1000L));
                                        if (ExternalSeedHTTPDownloaderLinear.access$300(ExternalSeedHTTPDownloaderLinear.this) < 0) {
                                            ExternalSeedHTTPDownloaderLinear.access$302(ExternalSeedHTTPDownloaderLinear.this, -1);
                                        }
                                    }
                                }
                                is = connection.getInputStream();
                                if (response != 202 && response != 200 && response != 206) {
                                    outcome = "Connection failed: " + connection.getResponseMessage();
                                    error = new ExternalSeedException(outcome);
                                    error.setPermanentFailure(true);
                                    throw error;
                                }
                                buffer = new byte[65536];
                                requests_outstanding = 1;
                                while (!this.destroyed) {
                                    permitted = this.listener.getPermittedBytes();
                                    if (requests_outstanding == 0 || permitted < 1) {
                                        permitted = 1;
                                        Thread.sleep(100L);
                                    }
                                    if ((len = is.read(buffer, 0, Math.min(permitted, buffer.length))) <= 0) break;
                                    var16_34 = this;
                                    synchronized (var16_34) {
                                        try {
                                            this.raf.write(buffer, 0, len);
                                        }
                                        catch (Throwable e) {
                                            outcome = "Write failed: " + e.getMessage();
                                            error = new ExternalSeedException(outcome, e);
                                            error.setPermanentFailure(true);
                                            throw error;
                                        }
                                    }
                                    this.listener.reportBytesRead(len);
                                    requests_outstanding = this.checkRequests();
                                }
                                this.checkRequests();
                                var21_15 = null;
                            }
                            catch (IOException e) {
                                if (this.con_fail_is_perm_fail && !connected) {
                                    outcome = "Connection failed: " + e.getMessage();
                                    error = new ExternalSeedException(outcome);
                                    error.setPermanentFailure(true);
                                    throw error;
                                }
                                outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                                if (ExternalSeedHTTPDownloaderLinear.access$300(ExternalSeedHTTPDownloaderLinear.this) >= 0) {
                                    outcome = outcome + ", Retry-After: " + ExternalSeedHTTPDownloaderLinear.access$300(ExternalSeedHTTPDownloaderLinear.this) + " seconds";
                                }
                                excep = new ExternalSeedException(outcome, e);
                                if (e instanceof FileNotFoundException == false) throw excep;
                                excep.setPermanentFailure(true);
                                throw excep;
                            }
                            catch (ExternalSeedException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                if (e instanceof ExternalSeedException) {
                                    throw (ExternalSeedException)e;
                                }
                                outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                                throw new ExternalSeedException("Connection failed", e);
                            }
                            SESecurityManager.unsetThreadPasswordHandler();
                            if (is != null) {
                                try {}
                                catch (Throwable e) {}
                                is.close();
                            }
                        }
                        catch (Throwable var20_37) {
                            var21_16 = null;
                            SESecurityManager.unsetThreadPasswordHandler();
                            if (is == null) throw var20_37;
                            ** try [egrp 9[TRYBLOCK] [15 : 941->949)] { 
lbl136:
                            // 1 sources

                            is.close();
                            throw var20_37;
lbl138:
                            // 1 sources

                            catch (Throwable e) {
                                // empty catch block
                            }
                            throw var20_37;
                        }
                    }
                    var24_21 = null;
                    if (plugin_proxy == null) return;
                    plugin_proxy.setOK(proxy_ok);
                    return;
                }
                catch (ExternalSeedException e) {
                    if (!connected && this.con_fail_is_perm_fail) {
                        e.setPermanentFailure(true);
                    }
                    this.destroy(e);
                    var24_22 = null;
                    if (plugin_proxy == null) return;
                    plugin_proxy.setOK(proxy_ok);
                    return;
                }
            }
            catch (Throwable var23_38) {
                var24_23 = null;
                if (plugin_proxy == null) throw var23_38;
                plugin_proxy.setOK(proxy_ok);
                throw var23_38;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request addRequest(long offset, int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
            Request request2;
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    throw new ExternalSeedException("downloader destroyed");
                }
                request2 = new Request(offset, length, listener);
                this.requests.add(request2);
            }
            this.checkRequests();
            return request2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int checkRequests() {
            try {
                Downloader downloader = this;
                synchronized (downloader) {
                    if (this.raf == null) {
                        return this.requests.size();
                    }
                    long pos = this.raf.getFilePointer();
                    Iterator<Request> it = this.requests.iterator();
                    while (it.hasNext()) {
                        Object var13_11;
                        Request request2 = it.next();
                        long end = request2.getOffset() + (long)request2.getLength();
                        if (pos < end) continue;
                        ExternalSeedHTTPDownloaderListener listener = request2.getListener();
                        try {
                            int buffer_len;
                            this.raf.seek(request2.getOffset());
                            for (int total = 0; total < request2.getLength(); total += buffer_len) {
                                byte[] buffer = listener.getBuffer();
                                if (this.raf.read(buffer, 0, buffer_len = listener.getBufferLength()) != buffer_len) {
                                    throw new IOException("Error reading scratch file");
                                }
                                listener.done();
                            }
                            var13_11 = null;
                        }
                        catch (Throwable throwable) {
                            var13_11 = null;
                            this.raf.seek(pos);
                            throw throwable;
                        }
                        this.raf.seek(pos);
                        request2.complete();
                        it.remove();
                    }
                    return this.requests.size();
                }
            }
            catch (Throwable e) {
                Debug.out(e);
                this.destroy(new ExternalSeedException("read failed", e));
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy(ExternalSeedException error) {
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    return;
                }
                this.destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.scratch_file != null) {
                    this.scratch_file.delete();
                }
                for (Request r : this.requests) {
                    r.destroy(error);
                }
                this.requests.clear();
            }
            ExternalSeedHTTPDownloaderLinear.this.destoyed(this);
        }

        public PasswordAuthentication getAuthentication(String realm, URL tracker) {
            return null;
        }

        public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
        }

        public void clearPasswords() {
        }
    }

    private static class Request {
        private long offset;
        private int length;
        private ExternalSeedHTTPDownloaderListener listener;
        private AESemaphore sem = new AESemaphore("ES:wait");
        private volatile ExternalSeedException exception;

        protected Request(long _offset, int _length, ExternalSeedHTTPDownloaderListener _listener) {
            this.offset = _offset;
            this.length = _length;
            this.listener = _listener;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected int getLength() {
            return this.length;
        }

        protected ExternalSeedHTTPDownloaderListener getListener() {
            return this.listener;
        }

        protected void complete() {
            this.sem.release();
        }

        protected void destroy(ExternalSeedException e) {
            this.exception = e;
            this.sem.release();
        }

        public boolean waitFor(int timeout) throws ExternalSeedException {
            if (!this.sem.reserve(timeout)) {
                return false;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return true;
        }
    }
}

