/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.swt.NetStatusPluginTester;
import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class NetStatusPluginView
implements UISWTViewEventListener {
    private NetStatusPlugin plugin;
    private boolean created = false;
    private Composite composite;
    private Button start_button;
    private Button cancel_button;
    private StyledText log;
    private int selected_tests;
    private NetStatusPluginTester current_test;
    private static final int LOG_NORMAL = 1;
    private static final int LOG_SUCCESS = 2;
    private static final int LOG_ERROR = 3;
    private static final int LOG_INFO = 4;
    private int log_type = 1;

    public NetStatusPluginView(NetStatusPlugin _plugin, UIInstance _ui, String VIEW_ID) {
        this.plugin = _plugin;
        ((UISWTInstance)_ui).addView("Main", VIEW_ID, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (this.created) {
                    return false;
                }
                this.created = true;
                break;
            }
            case 2: {
                this.initialise((Composite)event2.getData());
                break;
            }
            case 7: 
            case 8: {
                try {
                    this.destroy();
                    Object var3_2 = null;
                    this.created = false;
                    break;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.created = false;
                    throw throwable;
                }
            }
        }
        return true;
    }

    protected void initialise(Composite _composite) {
        this.composite = _composite;
        Composite main = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        GridData grid_data = new GridData(1808);
        main.setLayoutData((Object)grid_data);
        Composite control = new Composite(main, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        control.setLayout((Layout)layout);
        Label info = new Label(control, 0);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 3;
        info.setLayoutData((Object)grid_data);
        Messages.setLanguageText((Widget)info, "label.test.internet");
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        control.setLayoutData((Object)grid_data);
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.start_button = new Button(control, 8);
        buttons.add(this.start_button);
        Messages.setLanguageText((Widget)this.start_button, "ConfigView.section.start");
        this.start_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetStatusPluginView.this.start_button.setEnabled(false);
                NetStatusPluginView.this.cancel_button.setEnabled(true);
                NetStatusPluginView.this.startTest();
            }
        });
        this.cancel_button = new Button(control, 8);
        buttons.add(this.cancel_button);
        Messages.setLanguageText((Widget)this.cancel_button, "UpdateWindow.cancel");
        this.cancel_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetStatusPluginView.this.cancel_button.setEnabled(false);
                NetStatusPluginView.this.cancelTest();
            }
        });
        this.cancel_button.setEnabled(false);
        Utils.makeButtonsEqualWidth(buttons);
        Group options = new Group(control, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        options.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)options, "label.test.types");
        grid_data = new GridData(768);
        options.setLayoutData((Object)grid_data);
        Button opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.outbound");
        this.addOption(opt, 4, true);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.inbound");
        this.addOption(opt, 8, true);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.nat.proxies");
        this.addOption(opt, 2, true);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.bt.connect");
        this.addOption(opt, 16, true);
        opt = new Button((Composite)options, 32);
        opt.setText("IPv6");
        boolean ipv6_enabled = COConfigurationManager.getBooleanParameter("IPV6 Enable Support");
        this.addOption(opt, 32, ipv6_enabled);
        opt = new Button((Composite)options, 32);
        Messages.setLanguageText((Widget)opt, "label.vuze.services");
        this.addOption(opt, 64, true);
        if (Constants.isWindows || Constants.isOSX) {
            opt = new Button((Composite)options, 32);
            Messages.setLanguageText((Widget)opt, "label.indirect.connect");
            boolean ic_enabled = AEProxyFactory.hasPluginProxy();
            this.addOption(opt, 128, ic_enabled);
        }
        this.log = new StyledText(main, 2824);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.horizontalIndent = 4;
        this.log.setLayoutData((Object)grid_data);
        this.log.setIndent(4);
        ClipboardCopy.addCopyToClipMenu((Control)this.log, new ClipboardCopy.copyToClipProvider(){

            public String getText() {
                return NetStatusPluginView.this.log.getText().trim();
            }
        });
    }

    protected void addOption(final Button button, final int type, boolean enable) {
        final String config = "test.option." + type;
        boolean selected = this.plugin.getBooleanParameter(config, enable);
        this.selected_tests = selected && enable ? (this.selected_tests |= type) : (this.selected_tests &= ~type);
        if (!enable) {
            button.setEnabled(false);
        }
        button.setSelection(selected);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = button.getSelection();
                if (selected) {
                    NetStatusPluginView.this.selected_tests = NetStatusPluginView.this.selected_tests | type;
                } else {
                    NetStatusPluginView.this.selected_tests = NetStatusPluginView.this.selected_tests & ~type;
                }
                NetStatusPluginView.this.plugin.setBooleanParameter(config, selected);
            }
        });
    }

    protected void startTest() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                NetStatusPluginView.this.startTestSupport(core);
            }
        });
    }

    protected void cancelTest() {
        new AEThread2("NetStatus:cancel", true){

            public void run() {
                NetStatusPluginView.this.cancelTestSupport();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startTestSupport(AzureusCore core) {
        block37: {
            block34: {
                block29: {
                    block36: {
                        block33: {
                            block28: {
                                try {
                                    try {
                                        var2_2 = this;
                                        synchronized (var2_2) {
                                            if (this.current_test != null) {
                                                Debug.out("Test already running!!!!");
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 27] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                                                var5_4 = null;
                                                break block28;
                                            }
                                            this.current_test = new NetStatusPluginTester(this.plugin, this.selected_tests, new NetStatusPluginTester.loggerProvider(){

                                                public void log(String str, boolean detailed) {
                                                    if (detailed && !NetStatusPluginView.this.plugin.isDetailedLogging()) {
                                                        return;
                                                    }
                                                    NetStatusPluginView.this.println(str);
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public void logSuccess(String str) {
                                                    try {
                                                        NetStatusPluginView.this.log_type = 2;
                                                        NetStatusPluginView.this.println(str);
                                                        Object var3_2 = null;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var3_3 = null;
                                                        NetStatusPluginView.this.log_type = 1;
                                                        throw throwable;
                                                    }
                                                    NetStatusPluginView.this.log_type = 1;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public void logInfo(String str) {
                                                    try {
                                                        NetStatusPluginView.this.log_type = 4;
                                                        NetStatusPluginView.this.println(str);
                                                        Object var3_2 = null;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var3_3 = null;
                                                        NetStatusPluginView.this.log_type = 1;
                                                        throw throwable;
                                                    }
                                                    NetStatusPluginView.this.log_type = 1;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public void logFailure(String str) {
                                                    try {
                                                        NetStatusPluginView.this.log_type = 3;
                                                        NetStatusPluginView.this.println(str);
                                                        Object var3_2 = null;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var3_3 = null;
                                                        NetStatusPluginView.this.log_type = 1;
                                                        throw throwable;
                                                    }
                                                    NetStatusPluginView.this.log_type = 1;
                                                }
                                            });
                                        }
                                        this.println("Test starting", true);
                                        this.current_test.run(core);
                                        this.println(this.current_test.isCancelled() != false ? "Test Cancelled" : "Test complete");
                                        break block29;
                                    }
                                    catch (Throwable var2_3) {
                                        var5_6 = null;
                                        try {
                                            c = this.composite;
                                            if (c != null && !c.isDisposed()) {
                                                try {
                                                    c.getDisplay().asyncExec(new Runnable(){

                                                        public void run() {
                                                            if (!NetStatusPluginView.this.start_button.isDisposed()) {
                                                                NetStatusPluginView.this.start_button.setEnabled(true);
                                                            }
                                                            if (!NetStatusPluginView.this.cancel_button.isDisposed()) {
                                                                NetStatusPluginView.this.cancel_button.setEnabled(false);
                                                            }
                                                        }
                                                    });
                                                }
                                                catch (Throwable e) {
                                                    // empty catch block
                                                }
                                            }
                                            v0 = null;
                                        }
                                        catch (Throwable var8_18) {
                                            v0 = null;
                                        }
                                        var9_22 = v0;
                                        var10_26 = this;
                                        synchronized (var10_26) {
                                            this.current_test.cancel();
                                            this.current_test = null;
                                            return;
                                        }
                                    }
                                }
                                catch (Throwable var4_28) {
                                    block35: {
                                        block32: {
                                            var5_7 = null;
                                            ** try [egrp 4[TRYBLOCK] [10 : 118->164)] { 
lbl43:
                                            // 1 sources

                                            c = this.composite;
                                            if (c != null && !c.isDisposed()) {
                                                ** try [egrp 5[TRYBLOCK] [9 : 137->156)] { 
lbl46:
                                                // 1 sources

                                                c.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                                break block32;
lbl48:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        v1 = null;
                                        break block35;
lbl53:
                                        // 1 sources

                                        catch (Throwable var8_19) {
                                            v1 = null;
                                        }
                                    }
                                    var9_23 = v1;
                                    var10_27 = this;
                                    synchronized (var10_27) {
                                        this.current_test.cancel();
                                        this.current_test = null;
                                        throw var4_28;
                                    }
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [10 : 118->164)] { 
lbl64:
                            // 1 sources

                            c = this.composite;
                            if (c != null && !c.isDisposed()) {
                                ** try [egrp 5[TRYBLOCK] [9 : 137->156)] { 
lbl67:
                                // 1 sources

                                c.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                break block33;
lbl69:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        v2 = null;
                        break block36;
lbl74:
                        // 1 sources

                        catch (Throwable var8_16) {
                            v2 = null;
                        }
                    }
                    var9_20 = v2;
                    var10_24 = this;
                    synchronized (var10_24) {
                        this.current_test.cancel();
                        this.current_test = null;
                        return;
                    }
                }
                var5_5 = null;
                ** try [egrp 4[TRYBLOCK] [10 : 118->164)] { 
lbl86:
                // 1 sources

                c = this.composite;
                if (c != null && !c.isDisposed()) {
                    ** try [egrp 5[TRYBLOCK] [9 : 137->156)] { 
lbl89:
                    // 1 sources

                    c.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    break block34;
lbl91:
                    // 1 sources

                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            v3 = null;
            break block37;
lbl96:
            // 1 sources

            catch (Throwable var8_17) {
                v3 = null;
            }
        }
        var9_21 = v3;
        var10_25 = this;
        synchronized (var10_25) {
            this.current_test.cancel();
            this.current_test = null;
            return;
        }
    }

    protected void println(String str) {
        this.print(str + "\n", false);
    }

    protected void println(String str, boolean clear_first) {
        this.print(str + "\n", clear_first);
    }

    protected void print(final String str, final boolean clear_first) {
        this.plugin.log(str);
        if (!this.log.isDisposed() && !this.log.getDisplay().isDisposed()) {
            final int f_log_type = this.log_type;
            this.log.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int start;
                    if (NetStatusPluginView.this.log.isDisposed()) {
                        return;
                    }
                    if (clear_first) {
                        start = 0;
                        NetStatusPluginView.this.log.setText(str);
                    } else {
                        start = NetStatusPluginView.this.log.getText().length();
                        NetStatusPluginView.this.log.append(str);
                    }
                    Color color = f_log_type == 1 ? Colors.black : (f_log_type == 2 ? Colors.green : (f_log_type == 4 ? Colors.blue : Colors.red));
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = start;
                    styleRange.length = str.length();
                    styleRange.foreground = color;
                    NetStatusPluginView.this.log.setStyleRange(styleRange);
                    NetStatusPluginView.this.log.setSelection(NetStatusPluginView.this.log.getText().length());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTestSupport() {
        NetStatusPluginView netStatusPluginView = this;
        synchronized (netStatusPluginView) {
            if (this.current_test != null) {
                this.println("Cancelling test...");
                this.current_test.cancel();
            }
        }
    }

    protected void destroy() {
        this.cancelTest();
        this.composite = null;
    }
}

