/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloader;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.util.ConstantsVuze;
import java.net.URLEncoder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class DevicesODFTUX {
    private static final String URL_LEARN_MORE = "/devices/offlinedownloader.start";
    private DeviceOfflineDownloader device;
    private Display display;
    private Shell shell;
    private Font boldFont;
    private Font titleFont;
    private Font subTitleFont;
    private Font textInputFont;
    private Button turnOnButton;
    private Label noSpaceWarning;
    private String dev_image_key;
    private ImageLoader imageLoader;

    protected DevicesODFTUX(DeviceOfflineDownloader _device) throws DeviceManagerException {
        this.device = _device;
        final long avail = this.device.getSpaceAvailable(false);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                DevicesODFTUX.this.open(avail == 0L);
            }
        });
    }

    private void open(boolean no_space_available) {
        this.imageLoader = ImageLoader.getInstance();
        this.shell = ShellFactory.createMainShell(112);
        this.shell.setSize(650, 400);
        Utils.centreWindow(this.shell);
        this.shell.setMinimumSize(550, 400);
        this.display = this.shell.getDisplay();
        Utils.setShellIcon(this.shell);
        this.createFonts();
        this.shell.setText(MessageText.getString("devices.activation"));
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                DevicesODFTUX.this.imageLoader.releaseImage("wizard_header_bg");
                if (DevicesODFTUX.this.dev_image_key != null) {
                    DevicesODFTUX.this.imageLoader.releaseImage(DevicesODFTUX.this.dev_image_key);
                }
                if (DevicesODFTUX.this.titleFont != null && !DevicesODFTUX.this.titleFont.isDisposed()) {
                    DevicesODFTUX.this.titleFont.dispose();
                }
                if (DevicesODFTUX.this.textInputFont != null && !DevicesODFTUX.this.textInputFont.isDisposed()) {
                    DevicesODFTUX.this.textInputFont.dispose();
                }
                if (DevicesODFTUX.this.boldFont != null && !DevicesODFTUX.this.boldFont.isDisposed()) {
                    DevicesODFTUX.this.boldFont.dispose();
                }
                if (DevicesODFTUX.this.subTitleFont != null && !DevicesODFTUX.this.subTitleFont.isDisposed()) {
                    DevicesODFTUX.this.subTitleFont.dispose();
                }
            }
        });
        Composite header = new Composite((Composite)this.shell, 0);
        header.setBackgroundMode(1);
        header.setBackgroundImage(this.imageLoader.getImage("wizard_header_bg"));
        Label topSeparator = new Label((Composite)this.shell, 258);
        Composite main = new Composite((Composite)this.shell, 0);
        main.setBackground(Colors.white);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        Composite footer = new Composite((Composite)this.shell, 0);
        FormLayout layout = new FormLayout();
        this.shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        header.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)topSeparator, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)bottomSeparator, 0);
        main.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)footer, 0);
        bottomSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        footer.setLayoutData((Object)data);
        this.populateHeader(header);
        this.populateMain(main, no_space_available);
        this.populateFooter(footer, no_space_available);
        this.shell.setDefaultButton(this.turnOnButton);
        this.shell.layout();
        Utils.centreWindow(this.shell);
        this.turnOnButton.setFocus();
        this.shell.open();
    }

    private void populateHeader(Composite header) {
        header.setBackground(this.display.getSystemColor(1));
        Label title = new Label(header, 64);
        title.setFont(this.titleFont);
        title.setText(MessageText.getString("devices.turnon.title"));
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        header.setLayout((Layout)layout);
    }

    private void populateMain(Composite main, boolean no_space_available) {
        String router_text;
        String manufacturer = this.device.getManufacturer();
        boolean is_belkin = manufacturer.toLowerCase().contains("belkin");
        Label image_area = new Label(main, 0);
        if (is_belkin) {
            this.dev_image_key = "image.device.logo.belkin";
            router_text = MessageText.getString("devices.router");
        } else {
            router_text = MessageText.getString("devices.od");
        }
        if (this.dev_image_key != null) {
            image_area.setImage(this.imageLoader.getImage(this.dev_image_key));
        }
        Label text1 = new Label(main, 64);
        text1.setBackground(Colors.white);
        text1.setFont(this.textInputFont);
        text1.setText(MessageText.getString("devices.od.turnon.text1", new String[]{(is_belkin ? "Belkin" : "Vuze") + " " + router_text}));
        Label text2 = new Label(main, 64);
        text2.setBackground(Colors.white);
        text2.setFont(this.textInputFont);
        text2.setText(MessageText.getString("devices.od.turnon.text2", new String[]{router_text}));
        this.noSpaceWarning = new Label(main, 64);
        this.noSpaceWarning.setBackground(Colors.white);
        this.noSpaceWarning.setFont(this.textInputFont);
        this.noSpaceWarning.setText(MessageText.getString("devices.od.turnon.text3", new String[]{router_text}));
        this.noSpaceWarning.setForeground(Colors.red);
        this.noSpaceWarning.setVisible(no_space_available);
        Label link = new Label(main, 64);
        link.setBackground(Colors.white);
        link.setFont(this.textInputFont);
        link.setText(MessageText.getString("devices.od.turnon.learn"));
        String url = URL_LEARN_MORE;
        try {
            url = url + "?man=" + URLEncoder.encode(manufacturer, "UTF-8");
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL(url, true);
        LinkLabel.makeLinkedLabel(link, url);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 50;
        layout.spacing = 5;
        main.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 20);
        data.left = new FormAttachment(0);
        image_area.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)image_area, 10);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        text1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)text1, 10);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        text2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)text2, 10);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.noSpaceWarning.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.noSpaceWarning, 10);
        data.left = new FormAttachment(0);
        link.setLayoutData((Object)data);
    }

    private void createFonts() {
        int i;
        FontData[] fDatas = this.shell.getFont().getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setStyle(1);
        }
        this.boldFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(12);
                continue;
            }
            fDatas[i].setHeight(10);
        }
        this.subTitleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(17);
                continue;
            }
            fDatas[i].setHeight(14);
        }
        this.titleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(14);
            } else {
                fDatas[i].setHeight(12);
            }
            fDatas[i].setStyle(0);
        }
        this.textInputFont = new Font((Device)this.display, fDatas);
    }

    private void populateFooter(Composite footer, final boolean no_space_available) {
        final Button dont_ask_again = new Button(footer, 32);
        dont_ask_again.setText(MessageText.getString("general.dont.ask.again"));
        dont_ask_again.setSelection(true);
        Button cancelButton = new Button(footer, 8);
        cancelButton.setText(MessageText.getString("button.nothanks"));
        this.turnOnButton = new Button(footer, 8);
        this.turnOnButton.setText(MessageText.getString("Button.turnon"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        footer.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 45);
        data.right = new FormAttachment((Control)this.turnOnButton);
        dont_ask_again.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        cancelButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)cancelButton);
        data.width = 100;
        this.turnOnButton.setLayoutData((Object)data);
        this.turnOnButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                DevicesODFTUX.this.device.setEnabled(true);
                DevicesODFTUX.this.device.setShownFTUX();
                DevicesODFTUX.this.shell.close();
            }
        });
        this.turnOnButton.setEnabled(!no_space_available);
        new AEThread2("scanner", true){
            private long last_avail;
            {
                super(_name, _daemon);
                this.last_avail = no_space_available ? 0L : Long.MAX_VALUE;
            }

            public void run() {
                while (!DevicesODFTUX.this.shell.isDisposed()) {
                    try {
                        Thread.sleep(10000L);
                        final long avail = DevicesODFTUX.this.device.getSpaceAvailable(true);
                        if (avail == this.last_avail) continue;
                        this.last_avail = avail;
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if (!DevicesODFTUX.this.turnOnButton.isDisposed()) {
                                    DevicesODFTUX.this.turnOnButton.setEnabled(avail > 0L);
                                }
                                if (!DevicesODFTUX.this.noSpaceWarning.isDisposed()) {
                                    DevicesODFTUX.this.noSpaceWarning.setVisible(avail <= 0L);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {}
                }
            }
        }.start();
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                DevicesODFTUX.this.device.setEnabled(false);
                if (dont_ask_again.getSelection()) {
                    DevicesODFTUX.this.device.setShownFTUX();
                }
                DevicesODFTUX.this.shell.close();
            }
        });
    }

    protected void close() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (DevicesODFTUX.this.shell != null && !DevicesODFTUX.this.shell.isDisposed()) {
                    DevicesODFTUX.this.shell.dispose();
                }
            }
        });
    }
}

