/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.imageloader;

import com.aelitis.azureus.ui.skin.SkinProperties;
import com.aelitis.azureus.ui.skin.SkinPropertiesImpl;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoaderRefInfo;
import com.aelitis.azureus.ui.utils.ImageBytesDownloader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageLoader
implements AEDiagnosticsEvidenceGenerator {
    private static ImageLoader instance;
    private static final boolean DEBUG_UNLOAD = false;
    private static final boolean DEBUG_REFCOUNT = false;
    private static final int GC_INTERVAL = 60000;
    private final String[] sSuffixChecks = new String[]{"-over", "-down", "-disabled", "-selected", "-gray"};
    private Display display;
    public static Image noImage;
    private final ConcurrentHashMap<String, ImageLoaderRefInfo> _mapImages;
    private final ArrayList<String> notFound;
    private CopyOnWriteArrayList<SkinProperties> skinProperties;
    private int disabledOpacity;
    private Set<String> cached_resources = new HashSet<String>();
    private File cache_dir = new File(SystemProperties.getUserPath(), "cache");

    public static synchronized ImageLoader getInstance() {
        if (instance == null) {
            instance = new ImageLoader(Display.getDefault(), null);
            SkinPropertiesImpl skinProperties = new SkinPropertiesImpl(ImageRepository.class.getClassLoader(), "org/gudy/azureus2/ui/icons/", "icons.properties");
            instance.addSkinProperties(skinProperties);
        }
        return instance;
    }

    public ImageLoader(Display display, SkinProperties skinProperties) {
        File[] files = this.cache_dir.listFiles();
        if (files != null) {
            for (File f : files) {
                String name = f.getName();
                if (!name.endsWith(".ico")) continue;
                this.cached_resources.add(name);
            }
        }
        this._mapImages = new ConcurrentHashMap();
        this.notFound = new ArrayList();
        this.display = display;
        this.skinProperties = new CopyOnWriteArrayList();
        this.addSkinProperties(skinProperties);
        AEDiagnostics.addEvidenceGenerator(this);
        SimpleTimer.addPeriodicEvent("GC_ImageLoader", 60000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                ImageLoader.this.collectGarbage();
            }
        });
    }

    private Image[] findResources(String sKey) {
        int i;
        if (Collections.binarySearch(this.notFound, sKey) >= 0) {
            return null;
        }
        for (i = 0; i < this.sSuffixChecks.length; ++i) {
            String sSuffix = this.sSuffixChecks[i];
            if (!sKey.endsWith(sSuffix)) continue;
            String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
            String[] sParentFiles = null;
            ClassLoader cl = null;
            for (SkinProperties sp : this.skinProperties) {
                sParentFiles = sp.getStringArray(sParentName);
                if (sParentFiles == null) continue;
                cl = sp.getClassLoader();
                break;
            }
            if (sParentFiles != null) {
                Image image;
                int j;
                boolean bFoundOne = false;
                Image[] images = this.parseValuesString(cl, sKey, sParentFiles, sSuffix);
                if (images == null) continue;
                for (j = 0; j < images.length; ++j) {
                    image = images[j];
                    if (!ImageLoader.isRealImage(image)) continue;
                    bFoundOne = true;
                }
                if (!bFoundOne) {
                    for (j = 0; j < images.length; ++j) {
                        image = images[j];
                        if (!ImageLoader.isRealImage(image)) continue;
                        image.dispose();
                    }
                    continue;
                }
                return images;
            }
            Image[] images = this.findResources(sParentName);
            if (images == null) continue;
            return images;
        }
        i = Collections.binarySearch(this.notFound, sKey) * -1 - 1;
        if (i >= 0) {
            this.notFound.add(i, sKey);
        }
        return null;
    }

    private Image[] parseValuesString(ClassLoader cl, String sKey, String[] values, String suffix) {
        Image[] images = null;
        int splitX = 0;
        int locationStart = 0;
        int useIndex = -1;
        if (values[0].equals("multi") && values.length > 2) {
            splitX = Integer.parseInt(values[1]);
            locationStart = 2;
        } else if (values[0].equals("multi-index") && values.length > 3) {
            splitX = Integer.parseInt(values[1]);
            useIndex = Integer.parseInt(values[2]);
            locationStart = 3;
        }
        if (locationStart == 0 || splitX <= 0) {
            images = new Image[values.length];
            for (int i = 0; i < values.length; ++i) {
                int index = values[i].lastIndexOf(46);
                if (index > 0) {
                    String sTryFile = values[i].substring(0, index) + suffix + values[i].substring(index);
                    images[i] = this.loadImage(this.display, cl, sTryFile, sKey);
                    if (images[i] == null) {
                        sTryFile = values[i].substring(0, index) + suffix.replace('-', '_') + values[i].substring(index);
                        images[i] = this.loadImage(this.display, cl, sTryFile, sKey);
                    }
                }
                if (images[i] != null) continue;
                images[i] = ImageLoader.getNoImage(sKey);
            }
        } else {
            Image image = null;
            String image_key = null;
            String origFile = values[locationStart];
            int index = origFile.lastIndexOf(46);
            if (index > 0) {
                String sTryFile;
                if (useIndex == -1) {
                    sTryFile = origFile.substring(0, index) + suffix + origFile.substring(index);
                    image = this.loadImage(this.display, cl, sTryFile, sKey);
                    if (image == null) {
                        sTryFile = origFile.substring(0, index) + suffix.replace('-', '_') + origFile.substring(index);
                        image = this.loadImage(this.display, cl, sTryFile, sKey);
                    }
                } else {
                    sTryFile = origFile.substring(0, index) + suffix + origFile.substring(index);
                    image = this.getImageFromMap(sTryFile);
                    if (image == null) {
                        image = this.loadImage(this.display, cl, sTryFile, sTryFile);
                        if (ImageLoader.isRealImage(image)) {
                            image_key = sTryFile;
                            this.addImage(image_key, image);
                        } else if (sTryFile.matches(".*[-_]disabled.*")) {
                            String sTryFileNonDisabled = sTryFile.replaceAll("[-_]disabled", "");
                            image = this.getImageFromMap(sTryFileNonDisabled);
                            if (!ImageLoader.isRealImage(image) && ImageLoader.isRealImage(image = this.loadImage(this.display, cl, sTryFileNonDisabled, sTryFileNonDisabled))) {
                                this.addImage(sTryFileNonDisabled, image);
                            }
                            if (ImageLoader.isRealImage(image)) {
                                image = this.fadeImage(image);
                                image_key = sTryFile;
                                this.addImage(image_key, image);
                                this.releaseImage(sTryFileNonDisabled);
                            }
                        }
                    } else {
                        image_key = sTryFile;
                    }
                }
            }
            if (!ImageLoader.isRealImage(image)) {
                String temp_key = sKey + "-[multi-load-temp]";
                image = this.getImageFromMap(temp_key);
                if (ImageLoader.isRealImage(image)) {
                    image_key = temp_key;
                } else {
                    image = this.loadImage(this.display, cl, values[locationStart], sKey);
                    if (ImageLoader.isRealImage(image)) {
                        image_key = temp_key;
                        this.addImage(image_key, image);
                    }
                }
            }
            if (ImageLoader.isRealImage(image)) {
                Rectangle bounds = image.getBounds();
                if (useIndex == -1) {
                    images = new Image[(bounds.width + splitX - 1) / splitX];
                    for (int i = 0; i < images.length; ++i) {
                        Image imgBG = Utils.createAlphaImage((Device)this.display, splitX, bounds.height, (byte)0);
                        int pos = i * splitX;
                        try {
                            images[i] = Utils.blitImage((Device)this.display, image, new Rectangle(pos, 0, Math.min(splitX, bounds.width - pos), bounds.height), imgBG, new Point(0, 0));
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                        imgBG.dispose();
                    }
                } else {
                    images = new Image[1];
                    Image imgBG = Utils.createAlphaImage((Device)this.display, splitX, bounds.height, (byte)0);
                    try {
                        int pos = useIndex * splitX;
                        images[0] = Utils.blitImage((Device)this.display, image, new Rectangle(pos, 0, Math.min(splitX, bounds.width - pos), bounds.height), imgBG, new Point(0, 0));
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    imgBG.dispose();
                }
                if (image_key != null) {
                    this.releaseImage(image_key);
                } else {
                    image.dispose();
                }
            }
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadImage(Display display, ClassLoader cl, String res, String sKey) {
        Image img = null;
        if (res == null) {
            for (int i = 0; i < this.sSuffixChecks.length; ++i) {
                String sTryFile;
                int index;
                String sSuffix = this.sSuffixChecks[i];
                if (!sKey.endsWith(sSuffix)) continue;
                String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
                String sParentFile = null;
                for (SkinProperties sp : this.skinProperties) {
                    sParentFile = sp.getStringValue(sParentName);
                    if (sParentFile == null) continue;
                    if (cl != null) break;
                    cl = sp.getClassLoader();
                    break;
                }
                if (sParentFile != null && (index = sParentFile.lastIndexOf(46)) > 0 && ((img = this.loadImage(display, cl, sTryFile = sParentFile.substring(0, index) + sSuffix + sParentFile.substring(index), sKey)) != null || (img = this.loadImage(display, cl, sTryFile = sParentFile.substring(0, index) + sSuffix.replace('-', '_') + sParentFile.substring(index), sKey)) != null)) break;
            }
        }
        if (img == null) {
            try {
                InputStream is;
                if (cl != null && res != null && (is = cl.getResourceAsStream(res)) != null) {
                    try {
                        img = new Image((Device)display, is);
                        Object var13_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_18 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    {
                    }
                }
                if (img == null) {
                    if (res != null && res.contains("_disabled.")) {
                        String id = sKey.substring(0, sKey.length() - 9);
                        Image imgToFade = this.getImage(id);
                        if (ImageLoader.isRealImage(imgToFade)) {
                            img = this.fadeImage(imgToFade);
                        }
                        this.releaseImage(id);
                    } else if (sKey.endsWith("-gray")) {
                        String id = sKey.substring(0, sKey.length() - 5);
                        Image imgToGray = this.getImage(id);
                        if (ImageLoader.isRealImage(imgToGray)) {
                            img = new Image((Device)display, imgToGray, 2);
                        }
                        this.releaseImage(id);
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("ImageRepository:loadImage:: Resource not found: " + res + "\n" + e);
            }
        }
        return img;
    }

    private Image fadeImage(Image imgToFade) {
        Image img;
        ImageData imageData = imgToFade.getImageData();
        if (imageData.alphaData != null) {
            if (this.disabledOpacity == -1) {
                for (int i = 0; i < imageData.alphaData.length; ++i) {
                    imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) >> 3);
                }
            } else {
                for (int i = 0; i < imageData.alphaData.length; ++i) {
                    imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) * this.disabledOpacity / 100);
                }
            }
            img = new Image((Device)this.display, imageData);
        } else {
            Rectangle bounds = imgToFade.getBounds();
            Image bg = Utils.createAlphaImage((Device)this.display, bounds.width, bounds.height, (byte)0);
            img = Utils.renderTransparency(this.display, bg, imgToFade, new Point(0, 0), this.disabledOpacity == -1 ? 64 : this.disabledOpacity * 255 / 100);
            bg.dispose();
        }
        return img;
    }

    public void unLoadImages() {
        for (ImageLoaderRefInfo imageInfo : this._mapImages.values()) {
            Image[] images = imageInfo.getImages();
            if (images == null) continue;
            for (int i = 0; i < images.length; ++i) {
                Image image = images[i];
                if (!ImageLoader.isRealImage(image)) continue;
                image.dispose();
            }
        }
    }

    private ImageLoaderRefInfo getRefInfoFromImageMap(String key) {
        return this._mapImages.get(key);
    }

    private void putRefInfoToImageMap(String key, ImageLoaderRefInfo info) {
        Image[] images;
        ImageLoaderRefInfo existing = this._mapImages.put(key, info);
        if (existing != null && (images = existing.getImages()) != null && images.length > 0) {
            Debug.out("P: existing found! " + key + " -> " + existing.getString());
        }
    }

    private ImageLoaderRefInfo putIfAbsentRefInfoToImageMap(String key, ImageLoaderRefInfo info) {
        Image[] images;
        ImageLoaderRefInfo x = this._mapImages.putIfAbsent(key, info);
        if (x != null && (images = x.getImages()) != null && images.length > 0) {
            Debug.out("PIA: existing found! " + key + " -> " + x.getString());
        }
        return x;
    }

    protected Image getImageFromMap(String sKey) {
        Image[] imagesFromMap = this.getImagesFromMap(sKey);
        if (imagesFromMap.length == 0) {
            return null;
        }
        return imagesFromMap[0];
    }

    protected Image[] getImagesFromMap(String sKey) {
        if (sKey == null) {
            return new Image[0];
        }
        ImageLoaderRefInfo imageInfo = this.getRefInfoFromImageMap(sKey);
        if (imageInfo != null && imageInfo.getImages() != null) {
            imageInfo.addref();
            return imageInfo.getImages();
        }
        return new Image[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image[] getImages(String sKey) {
        Image[] images;
        ImageLoaderRefInfo imageInfo;
        if (sKey == null) {
            return new Image[0];
        }
        if (!Utils.isThisThreadSWT()) {
            Debug.out("getImages called on non-SWT thread");
            return new Image[0];
        }
        if (sKey.startsWith("http://") && sKey.endsWith("-gray")) {
            sKey = sKey.substring(0, sKey.length() - 5);
        }
        if ((imageInfo = this.getRefInfoFromImageMap(sKey)) != null && imageInfo.getImages() != null) {
            imageInfo.addref();
            return imageInfo.getImages();
        }
        String[] locations = null;
        ClassLoader cl = null;
        for (SkinProperties sp : this.skinProperties) {
            locations = sp.getStringArray(sKey);
            if (locations == null || locations.length <= 0) continue;
            cl = sp.getClassLoader();
            break;
        }
        if (locations == null || locations.length == 0) {
            images = this.findResources(sKey);
            if (images == null) {
                String cache_key = sKey.hashCode() + ".ico";
                if (this.cached_resources.contains(cache_key)) {
                    File cache = new File(this.cache_dir, cache_key);
                    if (cache.exists()) {
                        try {
                            FileInputStream fis = new FileInputStream(cache);
                            try {
                                byte[] imageBytes = FileUtil.readInputStreamAsByteArray(fis);
                                ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                                org.eclipse.swt.graphics.ImageLoader swtImageLoader = new org.eclipse.swt.graphics.ImageLoader();
                                ImageData[] imageDatas = swtImageLoader.load((InputStream)is);
                                images = new Image[imageDatas.length];
                                for (int i = 0; i < imageDatas.length; ++i) {
                                    images[i] = new Image((Device)Display.getCurrent(), imageDatas[i]);
                                }
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException e) {
                                }
                                Object var15_18 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_19 = null;
                                fis.close();
                                throw throwable;
                            }
                            fis.close();
                            {
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                } else {
                    this.cached_resources.remove(cache_key);
                }
                if (images == null) {
                    images = new Image[]{};
                }
            }
            for (int i = 0; i < images.length; ++i) {
                if (images[i] != null) continue;
                images[i] = ImageLoader.getNoImage(sKey);
            }
        } else {
            images = this.parseValuesString(cl, sKey, locations, "");
        }
        ImageLoaderRefInfo info = new ImageLoaderRefInfo(images);
        this.putRefInfoToImageMap(sKey, info);
        return images;
    }

    public Image getImage(String sKey) {
        Image[] images = this.getImages(sKey);
        if (images == null || images.length == 0 || images[0].isDisposed()) {
            return ImageLoader.getNoImage(sKey);
        }
        return images[0];
    }

    public long releaseImage(String sKey) {
        if (sKey == null) {
            return 0L;
        }
        ImageLoaderRefInfo imageInfo = this.getRefInfoFromImageMap(sKey);
        if (imageInfo != null) {
            imageInfo.unref();
            return imageInfo.getRefCount();
        }
        return 0L;
    }

    public void addImage(String key, Image image) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImage called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.putIfAbsentRefInfoToImageMap(key, new ImageLoaderRefInfo(image));
        if (existing != null) {
            existing.setImages(new Image[]{image});
            existing.addref();
        }
    }

    public void addImage(String key, Image[] images) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImage called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.putIfAbsentRefInfoToImageMap(key, new ImageLoaderRefInfo(images));
        if (existing != null) {
            existing.setImages(images);
            existing.addref();
        }
    }

    private void logRefCount(String key, ImageLoaderRefInfo info, boolean inc) {
    }

    public void addImageNoDipose(String key, Image image) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImageNoDispose called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.putIfAbsentRefInfoToImageMap(key, new ImageLoaderRefInfo(image));
        if (existing != null) {
            existing.setNonDisposable();
            existing.setImages(new Image[]{image});
            existing.addref();
        }
    }

    public static Image getNoImage() {
        return ImageLoader.getNoImage("explicit");
    }

    private static Image getNoImage(String key) {
        if (noImage == null) {
            Display display = Display.getDefault();
            int SIZE = 10;
            noImage = new Image((Device)display, 10, 10);
            GC gc = new GC((Drawable)noImage);
            gc.setBackground(display.getSystemColor(7));
            gc.fillRectangle(0, 0, 10, 10);
            gc.setBackground(display.getSystemColor(3));
            gc.drawRectangle(0, 0, 9, 9);
            gc.dispose();
        }
        return noImage;
    }

    public boolean imageExists(String name) {
        boolean exists = ImageLoader.isRealImage(this.getImage(name));
        this.releaseImage(name);
        return exists;
    }

    public boolean imageAdded_NoSWT(String name) {
        return this._mapImages.containsKey(name);
    }

    public boolean imageAdded(String name) {
        Image[] images = this.getImages(name);
        boolean added = images != null && images.length > 0;
        this.releaseImage(name);
        return added;
    }

    public static boolean isRealImage(Image image) {
        if (image == null || image.isDisposed()) {
            return false;
        }
        if (noImage != null) {
            return image != noImage;
        }
        return image != ImageLoader.getNoImage(null);
    }

    public int getAnimationDelay(String sKey) {
        for (SkinProperties sp : this.skinProperties) {
            int delay = sp.getIntValue(sKey + ".delay", -1);
            if (delay < 0) continue;
            return delay;
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getUrlImage(final String url, final ImageDownloaderListener l) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("getUrlImage called on non-SWT thread");
            return null;
        }
        if (l == null || url == null) {
            return null;
        }
        if (this.imageExists(url)) {
            Image image = this.getImage(url);
            l.imageDownloaded(image, true);
            return image;
        }
        final String cache_key = url.hashCode() + ".ico";
        final File cache_file = new File(this.cache_dir, cache_key);
        if (this.cached_resources.contains(cache_key)) {
            if (cache_file.exists()) {
                try {
                    Image image;
                    FileInputStream fis = new FileInputStream(cache_file);
                    try {
                        byte[] imageBytes = FileUtil.readInputStreamAsByteArray(fis);
                        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                        Image image2 = new Image((Device)Display.getCurrent(), (InputStream)is);
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        this.putRefInfoToImageMap(url, new ImageLoaderRefInfo(image2));
                        l.imageDownloaded(image2, true);
                        image = image2;
                        Object var11_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                    return image;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else {
                this.cached_resources.remove(cache_key);
            }
        }
        ImageBytesDownloader.loadImage(url, new ImageBytesDownloader.ImageDownloaderListener(){

            public void imageDownloaded(final byte[] imageBytes) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (ImageLoader.this.imageExists(url)) {
                            Image image = ImageLoader.this.getImage(url);
                            l.imageDownloaded(image, false);
                            return;
                        }
                        FileUtil.writeBytesAsFile(cache_file.getAbsolutePath(), imageBytes);
                        ImageLoader.this.cached_resources.add(cache_key);
                        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                        Image image = new Image((Device)Display.getCurrent(), (InputStream)is);
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ImageLoader.this.putRefInfoToImageMap(url, new ImageLoaderRefInfo(image));
                        l.imageDownloaded(image, false);
                    }
                });
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("ImageLoader for " + this.skinProperties);
        writer.indent();
        long[] sizeCouldBeFree = new long[]{0L};
        long[] totalSizeEstimate = new long[]{0L};
        try {
            writer.indent();
            try {
                ImageLoaderRefInfo info;
                writer.println("Non-Disposable:");
                writer.indent();
                for (String key : this._mapImages.keySet()) {
                    info = this._mapImages.get(key);
                    if (!info.isNonDisposable()) continue;
                    this.writeEvidenceLine(writer, key, info, totalSizeEstimate, sizeCouldBeFree);
                }
                writer.exdent();
                writer.println("Disposable:");
                writer.indent();
                for (String key : this._mapImages.keySet()) {
                    info = this._mapImages.get(key);
                    if (info.isNonDisposable()) continue;
                    this.writeEvidenceLine(writer, key, info, totalSizeEstimate, sizeCouldBeFree);
                }
                writer.exdent();
                Object var8_7 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                writer.exdent();
                throw throwable;
            }
            if (totalSizeEstimate[0] > 0L) {
                writer.println(totalSizeEstimate[0] / 1024L + "k estimated used for images");
            }
            if (sizeCouldBeFree[0] > 0L) {
                writer.println(sizeCouldBeFree[0] / 1024L + "k could be freed");
            }
            Object var10_10 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            writer.exdent();
            throw throwable;
        }
    }

    private void writeEvidenceLine(IndentWriter writer, String key, ImageLoaderRefInfo info, long[] totalSizeEstimate, long[] sizeCouldBeFree) {
        String line = info.getRefCount() + "] " + key;
        if (Utils.isThisThreadSWT()) {
            long sizeEstimate = 0L;
            Image[] images = info.getImages();
            for (int i = 0; i < images.length; ++i) {
                Image img = images[i];
                if (img == null) continue;
                if (img.isDisposed()) {
                    line = line + "; *DISPOSED*";
                    continue;
                }
                Rectangle bounds = img.getBounds();
                long est = (long)(bounds.width * bounds.height) * 4L;
                sizeEstimate += est;
                totalSizeEstimate[0] = totalSizeEstimate[0] + est;
                if (!info.canDispose()) continue;
                sizeCouldBeFree[0] = sizeCouldBeFree[0] + est;
            }
            line = line + "; est " + sizeEstimate + " bytes";
        }
        writer.println(line);
    }

    public void addSkinProperties(SkinProperties skinProperties) {
        if (skinProperties == null) {
            return;
        }
        this.skinProperties.add(skinProperties);
        this.disabledOpacity = skinProperties.getIntValue("imageloader.disabled-opacity", -1);
        this.notFound.clear();
    }

    public void collectGarbage() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int numRemoved = 0;
                Iterator iter = ((ConcurrentHashMap.KeySetView)ImageLoader.this._mapImages.keySet()).iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    ImageLoaderRefInfo info = (ImageLoaderRefInfo)ImageLoader.this._mapImages.get(key);
                    if (info == null || !info.canDispose()) continue;
                    iter.remove();
                    ++numRemoved;
                    Image[] images = info.getImages();
                    for (int j = 0; j < images.length; ++j) {
                        Image image = images[j];
                        if (!ImageLoader.isRealImage(image)) continue;
                        image.dispose();
                    }
                }
            }
        });
    }

    public void setLabelImage(Label label, final String key) {
        Image bg = this.getImage(key);
        label.setImage(bg);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
    }

    public Image setButtonImage(Button btn, final String key) {
        Image bg = this.getImage(key);
        btn.setImage(bg);
        btn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
        return bg;
    }

    public void setBackgroundImage(Control control, final String key) {
        Image bg = this.getImage(key);
        control.setBackgroundImage(bg);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
    }

    public SkinProperties[] getSkinProperties() {
        return this.skinProperties.toArray(new SkinProperties[0]);
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(Image var1, boolean var2);
    }
}

