/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.uiupdater;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.updater.UIUpdatableAlways;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainStatusBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUpdaterSWT
extends AEThread2
implements ParameterListener,
UIUpdater {
    private static final LogIDs LOGID = LogIDs.UI3;
    private static final String CFG_REFRESH_INTERVAL = "GUI Refresh";
    private static final String CFG_REFRESH_INACTIVE_FACTOR = "Refresh When Inactive";
    private static final boolean DEBUG_TIMER = Constants.isCVSVersion();
    private static final boolean DEBUG_UPDATEABLES = Constants.IS_CVS_VERSION;
    private static UIUpdater updater = null;
    private int waitTimeMS;
    private boolean finished = false;
    private boolean refreshed = true;
    private CopyOnWriteList<UIUpdatable> updateables = new CopyOnWriteList();
    private Map<UIUpdatable, String> debug_Updateables;
    private CopyOnWriteList<UIUpdatable> alwaysUpdateables = new CopyOnWriteList();
    private AEMonitor updateables_mon = new AEMonitor("updateables");
    private int inactiveFactor;
    private int inactiveTicks;
    Map averageTimes = DEBUG_TIMER ? new HashMap() : null;
    private int update_count = 0;
    private CopyOnWriteList<UIUpdater.UIUpdaterListener> listeners = new CopyOnWriteList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIUpdater getInstance() {
        Class<UIUpdaterSWT> clazz = UIUpdaterSWT.class;
        synchronized (UIUpdaterSWT.class) {
            if (updater == null) {
                updater = new UIUpdaterSWT();
                updater.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return updater;
        }
    }

    public UIUpdaterSWT() {
        super("UI Updater", true);
        if (DEBUG_UPDATEABLES) {
            this.debug_Updateables = new HashMap<UIUpdatable, String>();
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{CFG_REFRESH_INTERVAL, CFG_REFRESH_INACTIVE_FACTOR}, this);
    }

    @Override
    public void run() {
        while (!this.finished) {
            if (this.refreshed) {
                this.refreshed = false;
                if (!Utils.execSWTThread(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void runSupport() {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        try {
                                            try {
                                                display = Utils.getDisplay();
                                                if (display == null) {
                                                    var6_3 = null;
                                                    break block24;
                                                }
                                                if (display.getActiveShell() == null) {
                                                    shells = display.getShells();
                                                    noneVisible = true;
                                                    for (i = 0; i < shells.length; ++i) {
                                                        if (!shells[i].isVisible() || shells[i].getMinimized()) continue;
                                                        noneVisible = false;
                                                        break;
                                                    }
                                                    if (noneVisible) {
                                                        if (UIUpdaterSWT.access$000(UIUpdaterSWT.this).size() > 0) {
                                                            UIUpdaterSWT.access$100(UIUpdaterSWT.this, UIUpdaterSWT.access$000(UIUpdaterSWT.this), false);
                                                        }
                                                        break block25;
                                                    }
                                                    if (UIUpdaterSWT.access$208(UIUpdaterSWT.this) % UIUpdaterSWT.access$300(UIUpdaterSWT.this) != 0) {
                                                        break block26;
                                                    }
                                                }
                                                UIUpdaterSWT.access$100(UIUpdaterSWT.this, UIUpdaterSWT.access$400(UIUpdaterSWT.this), true);
                                                break block27;
                                            }
                                            catch (Exception e) {
                                                Logger.log(new LogEvent(UIUpdaterSWT.access$500(), "Error while trying to update GUI", e));
                                                var6_7 = null;
                                                UIUpdaterSWT.access$602(UIUpdaterSWT.this, true);
                                                for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.access$700(UIUpdaterSWT.this)) {
                                                    try {
                                                        l.updateComplete(UIUpdaterSWT.access$804(UIUpdaterSWT.this));
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.out(e);
                                                    }
                                                }
                                                return;
                                            }
                                        }
                                        catch (Throwable var5_30) {
                                            var6_8 = null;
                                            UIUpdaterSWT.access$602(UIUpdaterSWT.this, true);
                                            var7_14 = UIUpdaterSWT.access$700(UIUpdaterSWT.this).iterator();
                                            while (true) {
                                                if (!var7_14.hasNext()) {
                                                    throw var5_30;
                                                }
                                                l = (UIUpdater.UIUpdaterListener)var7_14.next();
                                                ** try [egrp 2[TRYBLOCK] [10 : 222->239)] { 
lbl50:
                                                // 1 sources

                                                l.updateComplete(UIUpdaterSWT.access$804(UIUpdaterSWT.this));
lbl52:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                            }
                                        }
                                    }
                                    UIUpdaterSWT.access$602(UIUpdaterSWT.this, true);
                                    for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.access$700(UIUpdaterSWT.this)) {
                                        ** try [egrp 2[TRYBLOCK] [10 : 222->239)] { 
lbl60:
                                        // 1 sources

                                        l.updateComplete(UIUpdaterSWT.access$804(UIUpdaterSWT.this));
lbl62:
                                        // 1 sources

                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                    return;
                                }
                                var6_4 = null;
                                UIUpdaterSWT.access$602(UIUpdaterSWT.this, true);
                                for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.access$700(UIUpdaterSWT.this)) {
                                    ** try [egrp 2[TRYBLOCK] [10 : 222->239)] { 
lbl72:
                                    // 1 sources

                                    l.updateComplete(UIUpdaterSWT.access$804(UIUpdaterSWT.this));
lbl74:
                                    // 1 sources

                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                                return;
                            }
                            var6_5 = null;
                            UIUpdaterSWT.access$602(UIUpdaterSWT.this, true);
                            for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.access$700(UIUpdaterSWT.this)) {
                                ** try [egrp 2[TRYBLOCK] [10 : 222->239)] { 
lbl84:
                                // 1 sources

                                l.updateComplete(UIUpdaterSWT.access$804(UIUpdaterSWT.this));
lbl86:
                                // 1 sources

                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            return;
                        }
                        var6_6 = null;
                        UIUpdaterSWT.access$602(UIUpdaterSWT.this, true);
                        for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.access$700(UIUpdaterSWT.this)) {
                            ** try [egrp 2[TRYBLOCK] [10 : 222->239)] { 
lbl96:
                            // 1 sources

                            l.updateComplete(UIUpdaterSWT.access$804(UIUpdaterSWT.this));
lbl98:
                            // 1 sources

                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                })) {
                    this.refreshed = true;
                }
            }
            try {
                Thread.sleep(this.waitTimeMS);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.waitTimeMS = COConfigurationManager.getIntParameter(CFG_REFRESH_INTERVAL);
        this.inactiveFactor = COConfigurationManager.getIntParameter(CFG_REFRESH_INACTIVE_FACTOR);
        if (this.inactiveFactor == 0) {
            this.inactiveFactor = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            if (updateable instanceof UIUpdatableAlways && !this.alwaysUpdateables.contains(updateable)) {
                this.alwaysUpdateables.add(updateable);
            }
            if (!this.updateables.contains(updateable)) {
                this.updateables.add(updateable);
                if (DEBUG_UPDATEABLES) {
                    this.debug_Updateables.put(updateable, Debug.getCompressedStackTrace() + "\n");
                }
            } else if (DEBUG_UPDATEABLES) {
                System.out.println("WARNING: already added UIUpdatable " + updateable + "\n\t" + this.debug_Updateables.get(updateable) + "\t" + Debug.getCompressedStackTrace());
            } else {
                System.out.println("WARNING: already added UIUpdatable " + updateable);
            }
            Object var3_2 = null;
            this.updateables_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.updateables_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdded(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            boolean bl = this.updateables.contains(updateable);
            Object var4_3 = null;
            this.updateables_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.updateables_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            this.updateables.remove(updateable);
            if (updateable instanceof UIUpdatableAlways) {
                this.alwaysUpdateables.remove(updateable);
            }
            Object var3_2 = null;
            this.updateables_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.updateables_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener(CFG_REFRESH_INTERVAL, this);
    }

    private void update(CopyOnWriteList<UIUpdatable> updateables, boolean is_visible) {
        long start = 0L;
        HashMap<UIUpdatable, Long> mapTimeMap = DEBUG_TIMER ? new HashMap<UIUpdatable, Long>() : null;
        Display display = Utils.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        for (UIUpdatable updateable : updateables) {
            try {
                long diff;
                if (DEBUG_TIMER) {
                    start = SystemTime.getCurrentTime();
                }
                if (updateable instanceof UIUpdatableAlways) {
                    ((UIUpdatableAlways)updateable).updateUI(is_visible);
                } else {
                    updateable.updateUI();
                }
                if (!DEBUG_TIMER || (diff = SystemTime.getCurrentTime() - start) <= 0L) continue;
                mapTimeMap.put(updateable, new Long(diff));
            }
            catch (Throwable t) {
                Logger.log(new LogEvent(LOGID, "Error while trying to update UI Element " + updateable.getUpdateUIName(), t));
            }
        }
        if (DEBUG_TIMER) {
            this.makeDebugToolTip(mapTimeMap);
        }
    }

    private void makeDebugToolTip(Map timeMap) {
        IMainStatusBar mainStatusBar;
        boolean IDX_AVG = false;
        boolean IDX_SIZE = true;
        int IDX_MAX = 2;
        int IDX_LAST = 3;
        int IDX_TIME = 4;
        long ttl = 0L;
        for (Object key : timeMap.keySet()) {
            if (!this.averageTimes.containsKey(key)) {
                this.averageTimes.put(key, new Object[]{new Long(0L), new Long(0L), new Long(0L), new Long(0L), new Long(System.currentTimeMillis())});
            }
            Object[] average = (Object[])this.averageTimes.get(key);
            long diff = (Long)timeMap.get(key);
            if (diff > 0L) {
                long count = (Long)average[1];
                if (count >= 20L) {
                    count = 19L;
                }
                long lNewAverage = ((Long)average[0] * count + diff) / (count + 1L);
                average[0] = new Long(lNewAverage);
                average[1] = new Long(count + 1L);
                if (diff > (Long)average[2]) {
                    average[2] = new Long(diff);
                }
                average[3] = new Long(diff);
                average[4] = new Long(System.currentTimeMillis());
            } else {
                average[3] = new Long(diff);
            }
            ttl += diff;
            this.averageTimes.put(key, average);
        }
        UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        IMainStatusBar iMainStatusBar = mainStatusBar = uiFunctionsSWT == null ? null : uiFunctionsSWT.getMainStatusBar();
        if (mainStatusBar != null && mainStatusBar.isMouseOver()) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = this.averageTimes.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object[] average = (Object[])this.averageTimes.get(key);
                long lLastUpdated = (Long)average[4];
                if (System.currentTimeMillis() - lLastUpdated > 10000L) {
                    iter.remove();
                    continue;
                }
                long lTime = (Long)average[0];
                if (lTime <= 0L) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(lTime * 100L / (long)this.waitTimeMS);
                sb.append("% ");
                sb.append(lTime + "ms avg: ");
                sb.append("[" + ((UIUpdatable)key).getUpdateUIName() + "]");
                sb.append(average[1] + " samples");
                sb.append("; max:" + average[2]);
                sb.append("; last:" + average[3]);
            }
            mainStatusBar.setDebugInfo(sb.toString());
        }
    }

    @Override
    public void addListener(UIUpdater.UIUpdaterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(UIUpdater.UIUpdaterListener listener) {
        this.listeners.remove(listener);
    }

    static /* synthetic */ CopyOnWriteList access$000(UIUpdaterSWT x0) {
        return x0.alwaysUpdateables;
    }

    static /* synthetic */ void access$100(UIUpdaterSWT x0, CopyOnWriteList x1, boolean x2) {
        x0.update(x1, x2);
    }

    static /* synthetic */ int access$208(UIUpdaterSWT x0) {
        return x0.inactiveTicks++;
    }

    static /* synthetic */ int access$300(UIUpdaterSWT x0) {
        return x0.inactiveFactor;
    }

    static /* synthetic */ CopyOnWriteList access$400(UIUpdaterSWT x0) {
        return x0.updateables;
    }

    static /* synthetic */ LogIDs access$500() {
        return LOGID;
    }

    static /* synthetic */ boolean access$602(UIUpdaterSWT x0, boolean x1) {
        x0.refreshed = x1;
        return x0.refreshed;
    }

    static /* synthetic */ CopyOnWriteList access$700(UIUpdaterSWT x0) {
        return x0.listeners;
    }

    static /* synthetic */ int access$804(UIUpdaterSWT x0) {
        return ++x0.update_count;
    }
}

