/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinViewManager {
    private static Map<Class<?>, List<SkinView>> mapSkinViews = new HashMap();
    private static AEMonitor2 mon_skinViews = new AEMonitor2("skinViews");
    private static Map<String, SkinView> skinIDs = new HashMap<String, SkinView>();
    private static Map<String, SkinView> skinViewIDs = new HashMap<String, SkinView>();
    private static List listeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(SkinView skinView) {
        mon_skinViews.enter();
        try {
            List<SkinView> list = mapSkinViews.get(skinView.getClass());
            if (list == null) {
                list = new ArrayList<SkinView>(1);
                mapSkinViews.put(skinView.getClass(), list);
            }
            list.add(skinView);
            Object var3_2 = null;
            mon_skinViews.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_skinViews.exit();
            throw throwable;
        }
        SWTSkinObject mainSkinObject = skinView.getMainSkinObject();
        if (mainSkinObject != null) {
            skinIDs.put(mainSkinObject.getSkinObjectID(), skinView);
            String viewID = mainSkinObject.getViewID();
            if (viewID != null && viewID.length() > 0) {
                skinViewIDs.put(viewID, skinView);
            }
        }
        SkinViewManager.triggerViewAddedListeners(skinView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(SkinView skinView) {
        if (skinView == null) {
            return;
        }
        mon_skinViews.enter();
        try {
            List<SkinView> list = mapSkinViews.get(skinView.getClass());
            if (list != null) {
                list.remove(skinView);
                if (list.isEmpty()) {
                    mapSkinViews.remove(skinView.getClass());
                }
            }
            Object var3_2 = null;
            mon_skinViews.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_skinViews.exit();
            throw throwable;
        }
        SWTSkinObject mainSkinObject = skinView.getMainSkinObject();
        if (mainSkinObject != null) {
            skinIDs.remove(mainSkinObject.getSkinObjectID());
            skinViewIDs.remove(mainSkinObject.getViewID());
        }
    }

    public static SkinView getByClass(Class<?> cla) {
        List<SkinView> list = mapSkinViews.get(cla);
        if (list == null) {
            return null;
        }
        Object[] skinViews = list.toArray();
        for (int i = 0; i < skinViews.length; ++i) {
            SkinView sv = (SkinView)skinViews[i];
            SWTSkinObject so = sv.getMainSkinObject();
            if (so == null) continue;
            if (!so.isDisposed()) {
                return sv;
            }
            SkinViewManager.remove(sv);
        }
        return null;
    }

    public static SkinView[] getMultiByClass(Class<?> cla) {
        List<SkinView> list = mapSkinViews.get(cla);
        if (list == null) {
            return new SkinView[0];
        }
        return list.toArray(new SkinView[0]);
    }

    public static SkinView getBySkinObjectID(String id) {
        SWTSkinObject so;
        SkinView sv = skinIDs.get(id);
        if (sv != null && (so = sv.getMainSkinObject()) != null && so.isDisposed()) {
            SkinViewManager.remove(sv);
            return null;
        }
        return sv;
    }

    public static SkinView getByViewID(String viewID) {
        SWTSkinObject so;
        SkinView sv = skinViewIDs.get(viewID);
        if (sv != null && (so = sv.getMainSkinObject()) != null && so.isDisposed()) {
            SkinViewManager.remove(sv);
            return null;
        }
        return sv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(Class cla, SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            SkinView[] svs = SkinViewManager.getMultiByClass(cla);
            if (svs != null) {
                for (SkinView skinView : svs) {
                    l.skinViewAdded(skinView);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RemoveListener(SkinViewManagerListener l) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            listeners.remove(l);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerViewAddedListeners(SkinView skinView) {
        Class<SkinViewManager> clazz = SkinViewManager.class;
        synchronized (SkinViewManager.class) {
            Object[] array = listeners.toArray();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (int i = 0; i < array.length; ++i) {
                SkinViewManagerListener l = (SkinViewManagerListener)array[i];
                try {
                    l.skinViewAdded(skinView);
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            return;
        }
    }

    public static interface SkinViewManagerListener {
        public void skinViewAdded(SkinView var1);
    }
}

