/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.OIDTokenizer;

public class DERObjectIdentifier
extends ASN1Object {
    String identifier;

    public static DERObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERObjectIdentifier.getInstance(obj.getObject());
    }

    DERObjectIdentifier(byte[] bytes) {
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        for (int i = 0; i != bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (value < 0x80000000000000L) {
                value = value * 128L + (long)(b & 0x7F);
                if ((b & 0x80) != 0) continue;
                if (first) {
                    switch ((int)value / 40) {
                        case 0: {
                            objId.append('0');
                            break;
                        }
                        case 1: {
                            objId.append('1');
                            value -= 40L;
                            break;
                        }
                        default: {
                            objId.append('2');
                            value -= 80L;
                        }
                    }
                    first = false;
                }
                objId.append('.');
                objId.append(value);
                value = 0L;
                continue;
            }
            if (bigValue == null) {
                bigValue = BigInteger.valueOf(value);
            }
            bigValue = bigValue.shiftLeft(7);
            bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
            if ((b & 0x80) != 0) continue;
            objId.append('.');
            objId.append(bigValue);
            bigValue = null;
            value = 0L;
        }
        this.identifier = objId.toString();
    }

    public DERObjectIdentifier(String identifier) {
        if (!DERObjectIdentifier.isValidIdentifier(identifier)) {
            throw new IllegalArgumentException("string " + identifier + " not an OID");
        }
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream out, long fieldValue) throws IOException {
        if (fieldValue >= 128L) {
            if (fieldValue >= 16384L) {
                if (fieldValue >= 0x200000L) {
                    if (fieldValue >= 0x10000000L) {
                        if (fieldValue >= 0x800000000L) {
                            if (fieldValue >= 0x40000000000L) {
                                if (fieldValue >= 0x2000000000000L) {
                                    if (fieldValue >= 0x100000000000000L) {
                                        out.write((int)(fieldValue >> 56) | 0x80);
                                    }
                                    out.write((int)(fieldValue >> 49) | 0x80);
                                }
                                out.write((int)(fieldValue >> 42) | 0x80);
                            }
                            out.write((int)(fieldValue >> 35) | 0x80);
                        }
                        out.write((int)(fieldValue >> 28) | 0x80);
                    }
                    out.write((int)(fieldValue >> 21) | 0x80);
                }
                out.write((int)(fieldValue >> 14) | 0x80);
            }
            out.write((int)(fieldValue >> 7) | 0x80);
        }
        out.write((int)fieldValue & 0x7F);
    }

    private void writeField(OutputStream out, BigInteger fieldValue) throws IOException {
        int byteCount = (fieldValue.bitLength() + 6) / 7;
        if (byteCount == 0) {
            out.write(0);
        } else {
            BigInteger tmpValue = fieldValue;
            byte[] tmp = new byte[byteCount];
            for (int i = byteCount - 1; i >= 0; --i) {
                tmp[i] = (byte)(tmpValue.intValue() & 0x7F | 0x80);
                tmpValue = tmpValue.shiftRight(7);
            }
            int n = byteCount - 1;
            tmp[n] = (byte)(tmp[n] & 0x7F);
            out.write(tmp);
        }
    }

    void encode(DEROutputStream out) throws IOException {
        OIDTokenizer tok = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        this.writeField((OutputStream)bOut, Integer.parseInt(tok.nextToken()) * 40 + Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() < 18) {
                this.writeField((OutputStream)bOut, Long.parseLong(token));
                continue;
            }
            this.writeField((OutputStream)bOut, new BigInteger(token));
        }
        dOut.close();
        byte[] bytes = bOut.toByteArray();
        out.writeEncoded(6, bytes);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)o).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        if (first < '0' || first > '2') {
            return false;
        }
        boolean periodAllowed = false;
        for (int i = identifier.length() - 1; i >= 2; --i) {
            char ch = identifier.charAt(i);
            if ('0' <= ch && ch <= '9') {
                periodAllowed = true;
                continue;
            }
            if (ch == '.') {
                if (!periodAllowed) {
                    return false;
                }
                periodAllowed = false;
                continue;
            }
            return false;
        }
        return periodAllowed;
    }
}

