/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerRateController;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;

public class DownloadManagerController
extends LogRelation
implements PEPeerManagerAdapter,
PeerManagerRegistrationAdapter,
SimpleTimer.TimerTickReceiver {
    private static long STATE_FLAG_HASDND = 1L;
    private static long STATE_FLAG_COMPLETE_NO_DND = 2L;
    private static long skeleton_builds;
    private static boolean tracker_stats_exclude_lan;
    private static ExternalSeedPlugin ext_seed_plugin;
    private static boolean ext_seed_plugin_tried;
    private static final int LDT_DL_ADDED = 1;
    private static final int LDT_DL_REMOVED = 2;
    private static ListenerManager disk_listeners_agregator;
    private ListenerManager disk_listeners = ListenerManager.createManager("DMC:DiskListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            disk_listeners_agregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor disk_listeners_mon = new AEMonitor("DownloadManagerController:DL");
    private AEMonitor control_mon = new AEMonitor("DownloadManagerController");
    private AEMonitor state_mon = new AEMonitor("DownloadManagerController:State");
    private AEMonitor facade_mon = new AEMonitor("DownloadManagerController:Facade");
    private DownloadManagerImpl download_manager;
    private DownloadManagerStatsImpl stats;
    private volatile int state_set_by_method = -1;
    private volatile int substate;
    private volatile boolean force_start;
    private volatile DiskManager disk_manager_use_accessors;
    private DiskManagerListener disk_manager_listener_use_accessors;
    private FileInfoFacadeSet fileFacadeSet = new FileInfoFacadeSet();
    private boolean files_facade_destroyed;
    private boolean cached_complete_excluding_dnd;
    private boolean cached_has_dnd_files;
    private boolean cached_values_set;
    private Set<String> cached_networks;
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private List<Object[]> external_rate_limiters_cow;
    private String errorDetail;
    private GlobalManagerStats global_stats;
    private boolean bInitialized = false;
    private long data_send_rate_at_close;
    private static final int ACTIVATION_REBUILD_TIME = 600000;
    private static final int BLOOM_SIZE = 64;
    private volatile BloomFilter activation_bloom;
    private volatile long activation_bloom_create_time = SystemTime.getCurrentTime();
    private volatile int activation_count;
    private volatile long activation_count_time;
    private boolean piece_checking_enabled = true;
    private long priority_connection_count;
    private static final int HTTP_SEEDS_MAX = 64;
    private LinkedList<ExternalSeedPeer> http_seeds = new LinkedList();
    private int md_info_dict_size;
    private volatile WeakReference<byte[]> md_info_dict_ref = new WeakReference<Object>(null);
    private static final int MD_INFO_PEER_HISTORY_MAX = 128;
    private Map<String, int[]> md_info_peer_history = new LinkedHashMap<String, int[]>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, int[]> eldest) {
            return this.size() > 128;
        }
    };

    protected static ExternalSeedPlugin getExternalSeedPlugin() {
        if (!ext_seed_plugin_tried) {
            ext_seed_plugin_tried = true;
            try {
                PluginInterface ext_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                if (ext_pi != null) {
                    ext_seed_plugin = (ExternalSeedPlugin)ext_pi.getPlugin();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return ext_seed_plugin;
    }

    protected DownloadManagerController(DownloadManagerImpl _download_manager) {
        this.download_manager = _download_manager;
        GlobalManager gm = this.download_manager.getGlobalManager();
        this.global_stats = gm.getStats();
        this.stats = (DownloadManagerStatsImpl)this.download_manager.getStats();
        this.cached_values_set = false;
    }

    protected void setInitialState(int initial_state) {
        DownloadManagerState state;
        block7: {
            this.bInitialized = true;
            if (this.getState() == -1) {
                this.setState(initial_state, true);
            }
            state = this.download_manager.getDownloadState();
            TOTorrent torrent = this.download_manager.getTorrent();
            if (torrent != null) {
                try {
                    this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(torrent.getHashWrapper(), this);
                    this.md_info_dict_size = state.getIntAttribute("mdinfodictsize");
                    if (this.md_info_dict_size != 0) break block7;
                    try {
                        this.md_info_dict_size = BEncoder.encode((Map)torrent.serialiseToMap().get("info")).length;
                    }
                    catch (Throwable e) {
                        this.md_info_dict_size = -1;
                    }
                    state.setIntAttribute("mdinfodictsize", this.md_info_dict_size);
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (state.parameterExists("dndflags")) {
            long flags = state.getLongParameter("dndflags");
            this.cached_complete_excluding_dnd = (flags & STATE_FLAG_COMPLETE_NO_DND) != 0L;
            this.cached_has_dnd_files = (flags & STATE_FLAG_HASDND) != 0L;
            this.cached_values_set = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startDownload(TRTrackerAnnouncer tracker_client) {
        List<Object[]> limiters;
        DiskManager dm;
        block13: {
            block12: {
                block11: {
                    try {
                        this.control_mon.enter();
                        if (this.getState() != 40) {
                            Debug.out("DownloadManagerController::startDownload state must be ready, " + this.getState());
                            this.setFailed("Inconsistent download state: startDownload, state = " + this.getState());
                            Object var4_2 = null;
                            this.control_mon.exit();
                            return;
                        }
                        if (tracker_client == null) {
                            Debug.out("DownloadManagerController:startDownload: tracker_client is null");
                            this.stopIt(70, false, false, false);
                            break block11;
                        }
                        if (this.peer_manager != null) {
                            Debug.out("DownloadManagerController::startDownload: peer manager not null");
                            this.peer_manager.stopAll();
                            SimpleTimer.removeTickReceiver(this);
                            DownloadManagerRateController.removePeerManager(this.peer_manager);
                            this.peer_manager = null;
                        }
                        if ((dm = this.getDiskManager()) == null) {
                            Debug.out("DownloadManagerController::startDownload: disk manager is null");
                            break block12;
                        }
                        this.setState(50, false);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        this.control_mon.exit();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                this.control_mon.exit();
                return;
            }
            Object var4_4 = null;
            this.control_mon.exit();
            return;
        }
        Object var4_5 = null;
        this.control_mon.exit();
        this.cacheNetworks();
        final PEPeerManager temp = PEPeerManagerFactory.create(tracker_client.getPeerId(), this, dm);
        this.download_manager.informWillBeStarted(temp);
        temp.start();
        tracker_client.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){
            private final PEPeerManagerStats pm_stats;
            private long last_reported_total_received;
            private long last_reported_total_received_data;
            private long last_reported_total_received_discard;
            private long last_reported_total_received_failed;
            {
                this.pm_stats = temp.getStats();
            }

            public String getName() {
                return DownloadManagerController.this.getDisplayName();
            }

            public long getTotalSent() {
                return tracker_stats_exclude_lan ? this.pm_stats.getTotalDataBytesSentNoLan() : this.pm_stats.getTotalDataBytesSent();
            }

            public long getTotalReceived() {
                long received = tracker_stats_exclude_lan ? this.pm_stats.getTotalDataBytesReceivedNoLan() : this.pm_stats.getTotalDataBytesReceived();
                long discarded = this.pm_stats.getTotalDiscarded();
                long failed = this.pm_stats.getTotalHashFailBytes();
                long verified = received - (discarded + failed);
                if ((verified -= temp.getHiddenBytes()) < this.last_reported_total_received) {
                    verified = this.last_reported_total_received;
                    if (this.last_reported_total_received_data != -1L) {
                        this.last_reported_total_received_data = -1L;
                    }
                } else {
                    this.last_reported_total_received = verified;
                    this.last_reported_total_received_data = received;
                    this.last_reported_total_received_discard = discarded;
                    this.last_reported_total_received_failed = failed;
                }
                return verified < 0L ? 0L : verified;
            }

            public long getRemaining() {
                return Math.max(temp.getRemaining(), temp.getHiddenBytes());
            }

            public long getFailedHashCheck() {
                return this.pm_stats.getTotalHashFailBytes();
            }

            public String getExtensions() {
                return DownloadManagerController.this.getTrackerClientExtensions();
            }

            public int getMaxNewConnectionsAllowed() {
                return temp.getMaxNewConnectionsAllowed();
            }

            public int getPendingConnectionCount() {
                return temp.getPendingPeerCount();
            }

            public int getConnectedConnectionCount() {
                return temp.getNbPeers() + temp.getNbSeeds();
            }

            public int getUploadSpeedKBSec(boolean estimate) {
                long current_local = DownloadManagerController.this.stats.getDataSendRate();
                if (estimate && (current_local = DownloadManagerController.this.data_send_rate_at_close) == 0L) {
                    int old_global;
                    int current_global = DownloadManagerController.this.global_stats.getDataSendRate();
                    if (current_global < (old_global = DownloadManagerController.this.global_stats.getDataSendRateAtClose())) {
                        current_global = old_global;
                    }
                    List<DownloadManager> managers = DownloadManagerController.this.download_manager.getGlobalManager().getDownloadManagers();
                    int num_dls = 0;
                    for (int i = 0; i < managers.size(); ++i) {
                        int state;
                        DownloadManager dm = managers.get(i);
                        if (dm.getStats().getDownloadCompleted(false) == 1000 || (state = dm.getState()) == 100 || state == 65 || state == 70) continue;
                        ++num_dls;
                    }
                    current_local = num_dls == 0 ? (long)current_global : (long)(current_global / num_dls);
                }
                return (int)((current_local + 1023L) / 1024L);
            }

            public int getCryptoLevel() {
                return DownloadManagerController.this.download_manager.getCryptoLevel();
            }

            public void setPeerSources(String[] allowed_sources) {
                DownloadManagerState dms = DownloadManagerController.this.download_manager.getDownloadState();
                String[] sources = PEPeerSource.PS_SOURCES;
                for (int i = 0; i < sources.length; ++i) {
                    String s = sources[i];
                    boolean ok = false;
                    for (int j = 0; j < allowed_sources.length; ++j) {
                        if (!s.equals(allowed_sources[j])) continue;
                        ok = true;
                        break;
                    }
                    if (ok) continue;
                    dms.setPeerSourcePermitted(s, false);
                }
                PEPeerManager pm = DownloadManagerController.this.getPeerManager();
                if (pm != null) {
                    HashSet<String> allowed = new HashSet<String>();
                    allowed.addAll(Arrays.asList(allowed_sources));
                    for (PEPeer peer : pm.getPeers()) {
                        if (allowed.contains(peer.getPeerSource())) continue;
                        pm.removePeer(peer, "Peer source not permitted");
                    }
                }
            }

            public boolean isPeerSourceEnabled(String peer_source) {
                return DownloadManagerController.this.isPeerSourceEnabled(peer_source);
            }
        });
        try {
            this.control_mon.enter();
            this.peer_manager = temp;
            DownloadManagerRateController.addPeerManager(this.peer_manager);
            SimpleTimer.addTickReceiver(this);
            limiters = this.external_rate_limiters_cow;
            Object var6_10 = null;
            this.control_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.control_mon.exit();
            throw throwable;
        }
        if (limiters != null) {
            for (int i = 0; i < limiters.size(); ++i) {
                Object[] entry = limiters.get(i);
                temp.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
            }
        }
        if (this.getState() == 50) {
            this.download_manager.informStateChanged();
        }
        this.download_manager.informStarted(temp);
    }

    public void initializeDiskManager(final boolean open_for_seeding) {
        this.initializeDiskManagerSupport(10, new DiskManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(int oldDMState, int newDMState) {
                DiskManager dm;
                try {
                    DownloadManagerController.this.control_mon.enter();
                    dm = DownloadManagerController.this.getDiskManager();
                    if (dm == null) {
                        Object var5_4 = null;
                        DownloadManagerController.this.control_mon.exit();
                        return;
                    }
                    Object var5_5 = null;
                    DownloadManagerController.this.control_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    DownloadManagerController.this.control_mon.exit();
                    throw throwable;
                }
                try {
                    if (newDMState == 10) {
                        DownloadManagerController.this.setFailed(dm.getErrorMessage());
                    }
                    if (oldDMState == 3 && newDMState != 3) {
                        DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
                        DownloadManagerController.this.stats.setDownloadCompleted(DownloadManagerController.this.stats.getDownloadCompleted(true));
                        DownloadManagerController.this.download_manager.setAssumedComplete(DownloadManagerController.this.isDownloadComplete(false));
                    }
                    if (newDMState == 4) {
                        int completed = DownloadManagerController.this.stats.getDownloadCompleted(false);
                        if (DownloadManagerController.this.stats.getTotalDataBytesReceived() == 0L && DownloadManagerController.this.stats.getTotalDataBytesSent() == 0L && DownloadManagerController.this.stats.getSecondsDownloading() == 0L) {
                            if (completed < 1000) {
                                if (open_for_seeding) {
                                    DownloadManagerController.this.setFailed("File check failed");
                                    DownloadManagerController.this.download_manager.getDownloadState().clearResumeData();
                                } else {
                                    long amount_downloaded = (long)completed * dm.getTotalLength() / 1000L;
                                    DownloadManagerController.this.stats.setSavedDownloadedUploaded(amount_downloaded, amount_downloaded);
                                }
                            } else {
                                int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                                if (dl_copies > 0) {
                                    DownloadManagerController.this.stats.setSavedDownloadedUploaded(DownloadManagerController.this.download_manager.getSize() * (long)dl_copies, DownloadManagerController.this.stats.getTotalDataBytesSent());
                                }
                                DownloadManagerController.this.download_manager.getDownloadState().setFlag(1L, true);
                            }
                        }
                        if (completed == 1000) {
                            DownloadManagerController.this.download_manager.getDownloadState().discardFluff();
                        }
                    }
                    Object var8_11 = null;
                    DownloadManagerController.this.download_manager.informStateChanged();
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    DownloadManagerController.this.download_manager.informStateChanged();
                    throw throwable;
                }
            }

            public void filePriorityChanged(DiskManagerFileInfo file) {
                DownloadManagerController.this.download_manager.informPriorityChange(file);
            }

            public void pieceDoneChanged(DiskManagerPiece piece) {
            }

            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDiskManagerSupport(int initialising_state, DiskManagerListener listener) {
        try {
            this.control_mon.enter();
            int entry_state = this.getState();
            if (entry_state != 0 && entry_state != 70 && entry_state != 75 && entry_state != 100) {
                Debug.out("DownloadManagerController::initializeDiskManager: Illegal initialize state, " + entry_state);
                this.setFailed("Inconsistent download state: initSupport, state = " + entry_state);
                Object var7_4 = null;
                this.control_mon.exit();
                this.download_manager.informStateChanged();
                return;
            }
            DiskManager old_dm = this.getDiskManager();
            if (old_dm != null) {
                Debug.out("DownloadManagerController::initializeDiskManager: disk manager is not null");
                old_dm.stop(false);
                this.setDiskManager(null, null);
            }
            this.errorDetail = "";
            this.setState(initialising_state, false);
            DiskManager dm = DiskManagerFactory.create(this.download_manager.getTorrent(), this.download_manager);
            this.setDiskManager(dm, listener);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.control_mon.exit();
            this.download_manager.informStateChanged();
            throw throwable;
        }
        Object var7_5 = null;
        this.control_mon.exit();
        this.download_manager.informStateChanged();
    }

    public boolean canForceRecheck() {
        int state = this.getState();
        return state == 70 || state == 75 || state == 100 && this.getDiskManager() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRecheck(ForceRecheckListener l) {
        try {
            this.control_mon.enter();
            if (this.getDiskManager() != null || !this.canForceRecheck()) {
                Debug.out("DownloadManagerController::forceRecheck: illegal entry state");
                Object var5_2 = null;
                this.control_mon.exit();
                return;
            }
            int start_state = this.getState();
            this.download_manager.getDownloadState().clearResumeData();
            boolean wasForceStarted = this.force_start;
            this.force_start = true;
            this.download_manager.setDataAlreadyAllocated(false);
            this.initializeDiskManagerSupport(30, new forceRecheckDiskManagerListener(wasForceStarted, start_state, l));
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.control_mon.exit();
            throw throwable;
        }
        Object var5_3 = null;
        this.control_mon.exit();
    }

    public void setPieceCheckingEnabled(boolean enabled) {
        this.piece_checking_enabled = enabled;
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            dm.setPieceCheckingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopIt(int _stateAfterStopping, boolean remove_torrent, boolean remove_data, boolean for_removal) {
        block40: {
            block38: {
                boolean closing;
                long current_up = this.stats.getDataSendRate();
                if (current_up != 0L) {
                    this.data_send_rate_at_close = current_up;
                }
                boolean bl = closing = _stateAfterStopping == 71;
                if (closing) {
                    _stateAfterStopping = 70;
                }
                int stateAfterStopping = _stateAfterStopping;
                try {
                    try {
                        this.control_mon.enter();
                        int state = this.getState();
                        if (state == 70 || state == 100 && this.getDiskManager() == null) {
                            if (remove_data) {
                                this.download_manager.deleteDataFiles();
                            } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                                this.download_manager.deletePartialDataFiles();
                            }
                            if (remove_torrent) {
                                this.download_manager.deleteTorrentFile();
                            }
                            this.setState(_stateAfterStopping, false);
                            Object var22_10 = null;
                            this.control_mon.exit();
                            this.download_manager.informStateChanged();
                            return;
                        }
                        if (state == 65) {
                            break block38;
                        }
                        this.setSubState(_stateAfterStopping);
                        this.setState(65, false);
                        final AESemaphore nd_sem = new AESemaphore("DM:DownloadManager.NDTR");
                        NonDaemonTaskRunner.runAsync(new NonDaemonTask(){

                            public Object run() {
                                nd_sem.reserve();
                                return null;
                            }

                            public String getName() {
                                return "Stopping '" + DownloadManagerController.this.getDisplayName() + "'";
                            }
                        });
                        try {
                            block39: {
                                try {
                                    if (this.peer_manager != null) {
                                        this.peer_manager.stopAll();
                                        this.stats.saveSessionTotals();
                                        SimpleTimer.removeTickReceiver(this);
                                        DownloadManagerRateController.removePeerManager(this.peer_manager);
                                    }
                                    this.download_manager.informStopped(this.peer_manager, stateAfterStopping == 75);
                                    this.peer_manager = null;
                                    DiskManager dm = this.getDiskManager();
                                    if (dm != null) {
                                        boolean went_async = dm.stop(closing);
                                        if (went_async) {
                                            int wait_count = 0;
                                            Thread.sleep(10L);
                                            while (!dm.isStopped()) {
                                                if (++wait_count > 1200) {
                                                    Debug.out("Download stop took too long to complete");
                                                    break;
                                                }
                                                if (wait_count % 200 == 0) {
                                                    Debug.out("Waiting for download to stop - elapsed=" + wait_count + " sec");
                                                }
                                                Thread.sleep(100L);
                                            }
                                        }
                                        this.stats.setCompleted(this.stats.getCompleted());
                                        this.stats.setDownloadCompleted(this.stats.getDownloadCompleted(true));
                                        if (!this.download_manager.getAssumedComplete()) {
                                            this.download_manager.getDownloadState().save();
                                        }
                                        this.setDiskManager(null, null);
                                    }
                                    Object var15_19 = null;
                                    this.force_start = false;
                                    if (remove_data) {
                                        this.download_manager.deleteDataFiles();
                                        break block39;
                                    }
                                    if (!for_removal) break block39;
                                }
                                catch (Throwable throwable) {
                                    Object var15_20 = null;
                                    this.force_start = false;
                                    if (remove_data) {
                                        this.download_manager.deleteDataFiles();
                                    } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                                        this.download_manager.deletePartialDataFiles();
                                    }
                                    if (remove_torrent) {
                                        this.download_manager.deleteTorrentFile();
                                    }
                                    ArrayList<ExternalSeedPeer> to_remove = new ArrayList<ExternalSeedPeer>();
                                    Object object = this.http_seeds;
                                    synchronized (object) {
                                        to_remove.addAll(this.http_seeds);
                                        this.http_seeds.clear();
                                    }
                                    object = to_remove.iterator();
                                    while (true) {
                                        if (!object.hasNext()) {
                                            if (this.getState() != 65) throw throwable;
                                            this.setState(stateAfterStopping, true);
                                            throw throwable;
                                        }
                                        ExternalSeedPeer peer = (ExternalSeedPeer)object.next();
                                        peer.remove();
                                    }
                                }
                                if (COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                                    this.download_manager.deletePartialDataFiles();
                                }
                            }
                            if (remove_torrent) {
                                this.download_manager.deleteTorrentFile();
                            }
                            ArrayList<ExternalSeedPeer> to_remove = new ArrayList<ExternalSeedPeer>();
                            LinkedList<ExternalSeedPeer> linkedList = this.http_seeds;
                            synchronized (linkedList) {
                                to_remove.addAll(this.http_seeds);
                                this.http_seeds.clear();
                            }
                            for (ExternalSeedPeer peer : to_remove) {
                                peer.remove();
                            }
                            if (this.getState() == 65) {
                                this.setState(stateAfterStopping, true);
                            }
                            Object var20_28 = null;
                            nd_sem.release();
                            break block40;
                        }
                        catch (Throwable throwable) {
                            Object var20_29 = null;
                            nd_sem.release();
                            throw throwable;
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        Object var22_13 = null;
                        this.control_mon.exit();
                        this.download_manager.informStateChanged();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var22_14 = null;
                    this.control_mon.exit();
                    this.download_manager.informStateChanged();
                    throw throwable;
                }
            }
            Object var22_11 = null;
            this.control_mon.exit();
            this.download_manager.informStateChanged();
            return;
        }
        Object var22_12 = null;
        this.control_mon.exit();
        this.download_manager.informStateChanged();
    }

    protected void setStateWaiting() {
        this.setState(0, true);
    }

    public void setStateFinishing() {
        this.setState(55, true);
    }

    public void setStateDownloading() {
        if (this.getState() == 60) {
            this.setState(50, true);
        } else if (this.getState() != 50) {
            Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Trying to set state to downloading when state is not seeding"));
        }
    }

    public void setStateSeeding(boolean never_downloaded) {
        this.setStateFinishing();
        this.download_manager.downloadEnded(never_downloaded);
        this.setState(60, true);
    }

    public boolean isStateSeeding() {
        return this.getState() == 60;
    }

    protected void setStateQueued() {
        this.setState(75, true);
    }

    public int getState() {
        if (this.state_set_by_method != 10) {
            return this.state_set_by_method;
        }
        DiskManager dm = this.getDiskManager();
        if (dm == null) {
            return 10;
        }
        int diskManagerState = dm.getState();
        if (diskManagerState == 1) {
            return 10;
        }
        if (diskManagerState == 2) {
            return 20;
        }
        if (diskManagerState == 3) {
            return 30;
        }
        if (diskManagerState == 4) {
            return 40;
        }
        if (diskManagerState == 10) {
            return 100;
        }
        return 100;
    }

    protected int getSubState() {
        if (this.state_set_by_method == 65) {
            return this.substate;
        }
        return this.getState();
    }

    private void setSubState(int ss) {
        this.substate = ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int _state, boolean _inform_changed) {
        boolean call_filesExist = false;
        try {
            this.state_mon.enter();
            int old_state = this.state_set_by_method;
            if (old_state != _state) {
                File save_dir_file;
                TOTorrent torrent;
                this.state_set_by_method = _state;
                if (this.state_set_by_method != 75) {
                    this.activation_bloom = null;
                    if (this.state_set_by_method == 70) {
                        this.activation_count = 0;
                    }
                }
                if (this.state_set_by_method != 75 && this.state_set_by_method == 100 && (torrent = this.download_manager.getTorrent()) != null && !torrent.isSimpleTorrent() && (save_dir_file = this.download_manager.getAbsoluteSaveLocation()) != null && save_dir_file.exists() && save_dir_file.isDirectory()) {
                    TorrentUtils.recursiveEmptyDirDelete(save_dir_file, false);
                }
            }
            Object var8_7 = null;
            this.state_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.state_mon.exit();
            throw throwable;
        }
        if (call_filesExist) {
            this.filesExist(true);
        }
        if (_inform_changed) {
            this.download_manager.informStateChanged();
        }
    }

    public void restartDownload(boolean forceRecheck) {
        boolean was_force_start = this.isForceStart();
        this.stopIt(70, false, false, false);
        if (forceRecheck) {
            this.download_manager.getDownloadState().clearResumeData();
        }
        this.download_manager.initialize();
        if (was_force_start) {
            this.setForceStart(true);
        }
    }

    protected void destroy() {
        if (this.peer_manager_registration != null) {
            this.peer_manager_registration.unregister();
            this.peer_manager_registration = null;
        }
        this.fileFacadeSet.destroyFileInfo();
    }

    public boolean isPeerSourceEnabled(String peer_source) {
        return this.download_manager.getDownloadState().isPeerSourceEnabled(peer_source);
    }

    private void cacheNetworks() {
        this.cached_networks = new HashSet<String>(Arrays.asList(this.download_manager.getDownloadState().getNetworks()));
    }

    public boolean isNetworkEnabled(String network) {
        Set<String> cache = this.cached_networks;
        if (cache == null) {
            return this.download_manager.getDownloadState().isNetworkEnabled(network);
        }
        return cache.contains(network);
    }

    public String[] getEnabledNetworks() {
        Set<String> cache = this.cached_networks;
        if (cache == null) {
            return this.download_manager.getDownloadState().getNetworks();
        }
        return cache.toArray(new String[cache.size()]);
    }

    public byte[][] getSecrets() {
        TOTorrent torrent = this.download_manager.getTorrent();
        try {
            byte[] secret1 = torrent.getHash();
            try {
                byte[] secret2 = this.getSecret2(torrent);
                return new byte[][]{secret1, secret2};
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new byte[][]{secret1};
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new byte[0][];
        }
    }

    public byte[][] getSecrets(int crypto_level) {
        TOTorrent torrent = this.download_manager.getTorrent();
        try {
            byte[] secret = crypto_level == 1 ? torrent.getHash() : this.getSecret2(torrent);
            return new byte[][]{secret};
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new byte[0][];
        }
    }

    protected byte[] getSecret2(TOTorrent torrent) throws TOTorrentException {
        AbstractMap secrets_map = this.download_manager.getDownloadState().getMapAttribute("secrets");
        secrets_map = secrets_map == null ? new HashMap() : new LightHashMap(secrets_map);
        if (secrets_map.size() == 0) {
            secrets_map.put("p1", torrent.getPieces()[0]);
            this.download_manager.getDownloadState().setMapAttribute("secrets", secrets_map);
        }
        return (byte[])secrets_map.get("p1");
    }

    public boolean manualRoute(NetworkConnection connection) {
        return false;
    }

    public long getRandomSeed() {
        return this.download_manager.getDownloadState().getLongParameter("rand");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        PEPeerManager pm;
        try {
            this.control_mon.enter();
            ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                new_limiters.addAll(this.external_rate_limiters_cow);
            }
            new_limiters.add(new Object[]{group, new Boolean(upload)});
            this.external_rate_limiters_cow = new_limiters;
            pm = this.peer_manager;
            Object var6_5 = null;
            this.control_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.control_mon.exit();
            throw throwable;
        }
        if (pm != null) {
            pm.addRateLimiter(group, upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        block4: {
            this.control_mon.enter();
            if (this.external_rate_limiters_cow != null) break block4;
            LimitedRateGroup[] limitedRateGroupArray = new LimitedRateGroup[]{};
            Object var6_4 = null;
            this.control_mon.exit();
            return limitedRateGroupArray;
        }
        try {
            ArrayList<LimitedRateGroup> result = new ArrayList<LimitedRateGroup>();
            for (Object[] entry : this.external_rate_limiters_cow) {
                if ((Boolean)entry[1] != upload) continue;
                result.add((LimitedRateGroup)entry[0]);
            }
            LimitedRateGroup[] limitedRateGroupArray = result.toArray(new LimitedRateGroup[result.size()]);
            Object var6_5 = null;
            this.control_mon.exit();
            return limitedRateGroupArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.control_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        PEPeerManager pm;
        try {
            this.control_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                for (int i = 0; i < this.external_rate_limiters_cow.size(); ++i) {
                    Object[] entry = this.external_rate_limiters_cow.get(i);
                    if (entry[0] == group) continue;
                    new_limiters.add(entry);
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            pm = this.peer_manager;
            Object var8_7 = null;
            this.control_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.control_mon.exit();
            throw throwable;
        }
        if (pm != null) {
            pm.removeRateLimiter(group, upload);
        }
    }

    public void enqueueReadRequest(PEPeer peer, DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.getDiskManager().enqueueReadRequest(request2, listener);
    }

    public boolean activateRequest(InetSocketAddress address) {
        if (this.getState() == 75) {
            byte[] address_bytes;
            int hit_count;
            BloomFilter bloom = this.activation_bloom;
            if (bloom == null) {
                this.activation_bloom = bloom = BloomFilterFactory.createAddRemove4Bit(64);
            }
            if ((hit_count = bloom.add(address_bytes = AddressUtils.getAddressBytes(address))) > 5) {
                Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Activate request for " + this.getDisplayName() + " from " + address + " denied as too many recently received"));
                return false;
            }
            Logger.log(new LogEvent(this, LogIDs.CORE, "Activate request for " + this.getDisplayName() + " from " + address));
            long now = SystemTime.getCurrentTime();
            if (now < this.activation_bloom_create_time || now - this.activation_bloom_create_time > 600000L) {
                this.activation_bloom = BloomFilterFactory.createAddRemove4Bit(64);
                this.activation_bloom_create_time = now;
            }
            this.activation_count = bloom.getEntryCount();
            this.activation_count_time = now;
            return this.download_manager.activateRequest(this.activation_count);
        }
        return false;
    }

    public void deactivateRequest(InetSocketAddress address) {
        BloomFilter bloom = this.activation_bloom;
        if (bloom != null) {
            byte[] address_bytes = AddressUtils.getAddressBytes(address);
            int count = bloom.count(address_bytes);
            for (int i = 0; i < count; ++i) {
                bloom.remove(address_bytes);
            }
            this.activation_count = bloom.getEntryCount();
        }
    }

    public int getActivationCount() {
        long now = SystemTime.getCurrentTime();
        if (now < this.activation_count_time) {
            this.activation_count_time = now;
        } else if (now - this.activation_count_time > 600000L) {
            this.activation_count = 0;
        }
        return this.activation_count;
    }

    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    public boolean isForceStart() {
        return this.force_start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceStart(boolean _force_start) {
        try {
            this.state_mon.enter();
            if (this.force_start != _force_start) {
                this.force_start = _force_start;
                int state = this.getState();
                if (this.force_start && (state == 70 || state == 75)) {
                    this.setState(0, false);
                }
            }
            Object var4_3 = null;
            this.state_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.state_mon.exit();
            throw throwable;
        }
        this.download_manager.informStateChanged();
    }

    protected void setFailed(String reason) {
        if (reason != null) {
            this.errorDetail = reason;
        }
        this.stopIt(100, false, false, false);
    }

    public boolean filesExist(boolean expected_to_be_allocated) {
        if (!expected_to_be_allocated && !this.download_manager.isDataAlreadyAllocated()) {
            return false;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            return dm.filesExist();
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        DiskManagerFileInfo[] files = this.fileFacadeSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo fileInfo2 = files[i];
            if (fileInfo2.isSkipped()) continue;
            File file = fileInfo2.getFile(true);
            try {
                long start = SystemTime.getMonotonousTime();
                boolean exists = file.exists();
                long elapsed = SystemTime.getMonotonousTime() - start;
                if (elapsed >= 500L) {
                    Debug.out("Accessing '" + file.getAbsolutePath() + "' in '" + this.getDisplayName() + "' took " + elapsed + "ms - possibly offline");
                }
                if (!exists) {
                    File save_path;
                    if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(save_path = this.download_manager.getAbsoluteSaveLocation(), file) && !save_path.exists()) {
                        file = save_path;
                    }
                    this.setFailed(MessageText.getString("DownloadManager.error.datamissing") + " " + file);
                    return false;
                }
                if (fileInfo2.getLength() >= file.length() || COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) continue;
                this.setFailed(MessageText.getString("DownloadManager.error.badsize") + " " + file + "(" + fileInfo2.getLength() + "/" + file.length() + ")");
                return false;
            }
            catch (Exception e) {
                this.setFailed(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet.getFiles();
    }

    protected void fileInfoChanged() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(true);
    }

    protected void filePrioritiesChanged(List files) {
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files && files.size() == 1 && !((DiskManagerFileInfo)files.get(0)).isSkipped()) {
            return;
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        this.calculateCompleteness(this.fileFacadeSet.facadeFiles);
    }

    protected void calculateCompleteness(DiskManagerFileInfo[] active) {
        boolean complete_excluding_dnd = true;
        boolean has_dnd_files = false;
        for (int i = 0; i < active.length; ++i) {
            DiskManagerFileInfo file = active[i];
            if (file.isSkipped()) {
                has_dnd_files = true;
            } else if (file.getDownloaded() != file.getLength()) {
                complete_excluding_dnd = false;
            }
            if (has_dnd_files && !complete_excluding_dnd) break;
        }
        this.cached_complete_excluding_dnd = complete_excluding_dnd;
        this.cached_has_dnd_files = has_dnd_files;
        this.cached_values_set = true;
        DownloadManagerState state = this.download_manager.getDownloadState();
        long flags = (this.cached_complete_excluding_dnd ? STATE_FLAG_COMPLETE_NO_DND : 0L) | (this.cached_has_dnd_files ? STATE_FLAG_HASDND : 0L);
        state.setLongParameter("dndflags", flags);
    }

    protected boolean isDownloadComplete(boolean bIncludeDND) {
        int dm_state;
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files) {
            return this.stats.getDownloadCompleted(false) == 1000;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null && (dm_state = dm.getState()) == 4) {
            long remaining = bIncludeDND ? dm.getRemaining() : dm.getRemainingExcludingDND();
            return remaining == 0L;
        }
        if (bIncludeDND) {
            return false;
        }
        return this.cached_complete_excluding_dnd;
    }

    protected PEPeerManager getPeerManager() {
        return this.peer_manager;
    }

    protected DiskManager getDiskManager() {
        return this.disk_manager_use_accessors;
    }

    protected String getErrorDetail() {
        return this.errorDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDiskManager(DiskManager new_disk_manager, DiskManagerListener new_disk_manager_listener) {
        if (new_disk_manager != null) {
            new_disk_manager.setPieceCheckingEnabled(this.piece_checking_enabled);
        }
        try {
            this.disk_listeners_mon.enter();
            DiskManager old_disk_manager = this.disk_manager_use_accessors;
            if (old_disk_manager != null && this.disk_manager_listener_use_accessors != null) {
                old_disk_manager.removeListener(this.disk_manager_listener_use_accessors);
            }
            this.disk_manager_use_accessors = new_disk_manager;
            this.disk_manager_listener_use_accessors = new_disk_manager_listener;
            if (new_disk_manager != null) {
                new_disk_manager.addListener(new_disk_manager_listener);
            }
            this.fileInfoChanged();
            if (new_disk_manager == null && old_disk_manager != null) {
                this.disk_listeners.dispatch(2, old_disk_manager);
            } else if (new_disk_manager != null && old_disk_manager == null) {
                this.disk_listeners.dispatch(1, new_disk_manager);
            } else {
                Debug.out("inconsistent DiskManager state - " + new_disk_manager + "/" + old_disk_manager);
            }
            Object var5_4 = null;
            this.disk_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.disk_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.addListener(listener);
            DiskManager dm = this.getDiskManager();
            if (dm != null) {
                this.disk_listeners.dispatch(listener, 1, dm);
            }
            Object var4_3 = null;
            this.disk_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.disk_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.removeListener(listener);
            Object var3_2 = null;
            this.disk_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.disk_listeners_mon.exit();
            throw throwable;
        }
    }

    public long getDiskListenerCount() {
        return this.disk_listeners.size();
    }

    public String getDisplayName() {
        return this.download_manager.getDisplayName();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getEffectiveUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.stats.getDownloadRateLimitBytesPerSecond();
    }

    public int getPermittedBytesToReceive() {
        return NetworkManager.getSingleton().getRateHandler(false, false).getCurrentNumBytesAllowed();
    }

    public void permittedReceiveBytesUsed(int bytes) {
        NetworkManager.getSingleton().getRateHandler(false, false).bytesProcessed(bytes);
    }

    public int getPermittedBytesToSend() {
        return NetworkManager.getSingleton().getRateHandler(true, false).getCurrentNumBytesAllowed();
    }

    public void permittedSendBytesUsed(int bytes) {
        NetworkManager.getSingleton().getRateHandler(true, false).bytesProcessed(bytes);
    }

    public int getMaxUploads() {
        return this.download_manager.getEffectiveMaxUploads();
    }

    public int getMaxConnections() {
        int result = this.download_manager.isMaxConnectionsWhenSeedingEnabled() && this.isStateSeeding() ? this.download_manager.getMaxConnectionsWhenSeeding() : this.download_manager.getMaxConnections();
        return result;
    }

    public int getMaxSeedConnections() {
        return this.download_manager.getMaxSeedConnections();
    }

    public int getUploadPriority() {
        return this.download_manager.getEffectiveUploadPriority();
    }

    public boolean isExtendedMessagingEnabled() {
        return this.download_manager.isExtendedMessagingEnabled();
    }

    public boolean isPeerExchangeEnabled() {
        return this.download_manager.getDownloadState().isPeerSourceEnabled("PeerExchange");
    }

    public int getCryptoLevel() {
        return this.download_manager.getCryptoLevel();
    }

    public boolean isPeriodicRescanEnabled() {
        return this.download_manager.getDownloadState().getFlag(2L);
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return this.download_manager.getTrackerScrapeResponse();
    }

    public String getTrackerClientExtensions() {
        return this.download_manager.getDownloadState().getTrackerClientExtensions();
    }

    public void setTrackerRefreshDelayOverrides(int percent) {
        this.download_manager.setTrackerRefreshDelayOverrides(percent);
    }

    public boolean isNATHealthy() {
        return this.download_manager.getNATStatus() == 1;
    }

    public boolean isMetadataDownload() {
        return this.download_manager.getDownloadState().getFlag(512L);
    }

    public int getTorrentInfoDictSize() {
        return this.md_info_dict_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTorrentInfoDict(PEPeer peer) {
        try {
            String ip = peer.getIp();
            Map<String, int[]> map = this.md_info_peer_history;
            synchronized (map) {
                int now_secs = (int)(SystemTime.getMonotonousTime() / 1000L);
                int[] stats2 = this.md_info_peer_history.get(ip);
                if (stats2 == null) {
                    stats2 = new int[]{now_secs, 0};
                    this.md_info_peer_history.put(ip, stats2);
                }
                if (now_secs - stats2[0] > 300) {
                    stats2[1] = 16384;
                } else {
                    int bytes = stats2[1];
                    if (bytes >= this.md_info_dict_size * 3) {
                        return null;
                    }
                    stats2[1] = bytes + 16384;
                }
            }
            byte[] data = (byte[])this.md_info_dict_ref.get();
            if (data == null) {
                TOTorrent torrent = this.download_manager.getTorrent();
                data = BEncoder.encode((Map)torrent.serialiseToMap().get("info"));
                this.md_info_dict_ref = new WeakReference<byte[]>(data);
            }
            return data;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void addPeer(PEPeer peer) {
        this.download_manager.addPeer(peer);
    }

    public void removePeer(PEPeer peer) {
        this.download_manager.removePeer(peer);
    }

    public void addPiece(PEPiece piece) {
        this.download_manager.addPiece(piece);
    }

    public void removePiece(PEPiece piece) {
        this.download_manager.removePiece(piece);
    }

    public void discarded(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.discarded(bytes);
        }
    }

    public void protocolBytesReceived(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesReceived(bytes, peer.isLANLocal());
        }
    }

    public void dataBytesReceived(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesReceived(bytes, peer.isLANLocal());
        }
    }

    public void protocolBytesSent(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesSent(bytes, peer.isLANLocal());
        }
    }

    public void dataBytesSent(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesSent(bytes, peer.isLANLocal());
        }
    }

    public int getPosition() {
        return this.download_manager.getPosition();
    }

    public void tick(long mono_now, int tick_count) {
        this.stats.timerTick(tick_count);
    }

    public void statsRequest(PEPeer originator, Map request2, Map reply) {
        GlobalManager gm = this.download_manager.getGlobalManager();
        gm.statsRequest(request2, reply);
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        reply.put("dl", info);
        try {
            info.put("u_lim", new Long(this.getUploadRateLimitBytesPerSecond()));
            info.put("d_lim", new Long(this.getDownloadRateLimitBytesPerSecond()));
            info.put("u_rate", new Long(this.stats.getProtocolSendRate() + this.stats.getDataSendRate()));
            info.put("d_rate", new Long(this.stats.getProtocolReceiveRate() + this.stats.getDataReceiveRate()));
            info.put("u_slot", new Long(this.getMaxUploads()));
            info.put("c_max", new Long(this.getMaxConnections()));
            info.put("c_leech", new Long(this.download_manager.getNbPeers()));
            info.put("c_seed", new Long(this.download_manager.getNbSeeds()));
            PEPeerManager pm = this.peer_manager;
            if (pm != null) {
                info.put("c_rem", Integer.valueOf(pm.getNbRemoteTCPConnections()));
                info.put("c_rem_utp", Integer.valueOf(pm.getNbRemoteUTPConnections()));
                info.put("c_rem_udp", Integer.valueOf(pm.getNbRemoteUDPConnections()));
                List<PEPeer> peers = pm.getPeers();
                ArrayList<Long> slot_up = new ArrayList<Long>();
                info.put("slot_up", slot_up);
                for (PEPeer p : peers) {
                    if (p.isChokedByMe()) continue;
                    long up = p.getStats().getDataSendRate() + p.getStats().getProtocolSendRate();
                    slot_up.add(up);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHTTPSeed(String address, int port) {
        block7: {
            ExternalSeedPlugin plugin = DownloadManagerController.getExternalSeedPlugin();
            try {
                if (plugin == null) break block7;
                HashMap<String, Cloneable> config = new HashMap<String, Cloneable>();
                ArrayList<byte[]> urls = new ArrayList<byte[]>();
                String seed_url = "http://" + UrlUtils.convertIPV6Host(address) + ":" + port + "/webseed";
                urls.add(seed_url.getBytes());
                config.put("httpseeds", urls);
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("supports_503", new Long(0L));
                params.put("transient", new Long(1L));
                config.put("httpseeds-params", params);
                List<ExternalSeedPeer> new_seeds = plugin.addSeed(org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl.getDownloadStatic(this.download_manager), config);
                if (new_seeds.size() <= 0) break block7;
                ArrayList<ExternalSeedPeer> to_remove = new ArrayList<ExternalSeedPeer>();
                LinkedList<ExternalSeedPeer> linkedList = this.http_seeds;
                synchronized (linkedList) {
                    this.http_seeds.addAll(new_seeds);
                    while (this.http_seeds.size() > 64) {
                        ExternalSeedPeer x = this.http_seeds.removeFirst();
                        to_remove.add(x);
                    }
                }
                for (ExternalSeedPeer peer : to_remove) {
                    peer.remove();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void priorityConnectionChanged(boolean added) {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            this.priority_connection_count = added ? ++this.priority_connection_count : --this.priority_connection_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPriorityConnection() {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            return this.priority_connection_count > 0L;
        }
    }

    public String getDescription() {
        return this.download_manager.getDisplayName();
    }

    public LogRelation getLogRelation() {
        return this;
    }

    public String getRelationText() {
        return this.download_manager.getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        ArrayList<Object> interfaces = new ArrayList<Object>();
        Object[] intf = this.download_manager.getQueryableInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            interfaces.add(intf[i]);
        }
        interfaces.add(this.download_manager);
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            interfaces.add(dm);
        }
        return interfaces.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManager Controller:");
        writer.indent();
        try {
            writer.println("cached info: complete w/o DND=" + this.cached_complete_excluding_dnd + "; hasDND? " + this.cached_has_dnd_files);
            writer.println("Complete w/DND? " + this.isDownloadComplete(true) + "; w/o DND? " + this.isDownloadComplete(false));
            writer.println("filesFacade length: " + this.fileFacadeSet.nbFiles());
            if (this.force_start) {
                writer.println("Force Start");
            }
            writer.println("FilesExist? " + this.filesExist(this.download_manager.isDataAlreadyAllocated()));
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Tracker Client Exclude LAN", new ParameterListener(){

            public void parameterChanged(String name) {
                tracker_stats_exclude_lan = COConfigurationManager.getBooleanParameter(name);
            }
        });
        disk_listeners_agregator = ListenerManager.createAsyncManager("DMC:DiskListenAgregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DownloadManagerDiskListener listener = (DownloadManagerDiskListener)_listener;
                if (type == 1) {
                    listener.diskManagerAdded((DiskManager)value);
                } else if (type == 2) {
                    listener.diskManagerRemoved((DiskManager)value);
                }
            }
        });
    }

    protected class FileInfoFacadeSet
    implements DiskManagerFileInfoSet {
        DiskManagerFileInfoSet delegate;
        fileInfoFacade[] facadeFiles = new fileInfoFacade[0];

        protected FileInfoFacadeSet() {
        }

        public DiskManagerFileInfo[] getFiles() {
            return this.facadeFiles;
        }

        public int nbFiles() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.nbFiles();
        }

        public void setPriority(int[] toChange) {
            this.delegate.setPriority(toChange);
        }

        public void setSkipped(boolean[] toChange, boolean setSkipped) {
            this.delegate.setSkipped(toChange, setSkipped);
        }

        public boolean[] setStorageTypes(boolean[] toChange, int newStroageType) {
            return this.delegate.setStorageTypes(toChange, newStroageType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fixupFileInfo(fileInfoFacade[] info) {
            if (info.length == 0) {
                return;
            }
            final ArrayList delayed_prio_changes = new ArrayList(0);
            try {
                int dm_state;
                DownloadManagerController.this.facade_mon.enter();
                if (DownloadManagerController.this.files_facade_destroyed) {
                    Object var9_3 = null;
                    DownloadManagerController.this.facade_mon.exit();
                    return;
                }
                DiskManager dm = DownloadManagerController.this.getDiskManager();
                DiskManagerFileInfoSet active = null;
                if (dm != null && ((dm_state = dm.getState()) == 3 || dm_state == 4)) {
                    active = dm.getFileSet();
                }
                if (active == null) {
                    final boolean[] initialising = new boolean[]{true};
                    try {
                        skeleton_builds++;
                        if (skeleton_builds % 1000L == 0L) {
                            Debug.outNoStack("Skeleton builds: " + skeleton_builds);
                        }
                        active = DiskManagerFactory.getFileInfoSkeleton(DownloadManagerController.this.download_manager, new DiskManagerListener(){

                            public void stateChanged(int oldState, int newState) {
                            }

                            public void filePriorityChanged(DiskManagerFileInfo file) {
                                if (initialising[0]) {
                                    delayed_prio_changes.add(file);
                                } else {
                                    DownloadManagerController.this.download_manager.informPriorityChange(file);
                                }
                            }

                            public void pieceDoneChanged(DiskManagerPiece piece) {
                            }

                            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                            }
                        });
                        Object var7_11 = null;
                        initialising[0] = false;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        initialising[0] = false;
                        throw throwable;
                    }
                    DownloadManagerController.this.calculateCompleteness(active.getFiles());
                }
                DiskManagerFileInfo[] activeFiles = active.getFiles();
                for (int i = 0; i < info.length; ++i) {
                    info[i].setDelegate(activeFiles[i]);
                }
                this.delegate = active;
            }
            catch (Throwable throwable) {
                Object var9_5 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
            Object var9_4 = null;
            DownloadManagerController.this.facade_mon.exit();
            ((DownloadManagerController)DownloadManagerController.this).fileFacadeSet.facadeFiles = info;
            DownloadManagerController.this.download_manager.informPrioritiesChange(delayed_prio_changes);
            delayed_prio_changes.clear();
        }

        private void makeSureFilesFacadeFilled(boolean refresh) {
            if (!DownloadManagerController.this.bInitialized) {
                return;
            }
            if (this.facadeFiles.length == 0) {
                fileInfoFacade[] newFacadeFiles = new fileInfoFacade[DownloadManagerController.this.download_manager.getTorrent() == null ? 0 : DownloadManagerController.this.download_manager.getTorrent().getFiles().length];
                for (int i = 0; i < newFacadeFiles.length; ++i) {
                    newFacadeFiles[i] = new fileInfoFacade();
                }
                DownloadManagerController.this.fileFacadeSet.fixupFileInfo(newFacadeFiles);
            } else if (refresh) {
                this.fixupFileInfo(this.facadeFiles);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroyFileInfo() {
            try {
                block6: {
                    block5: {
                        DownloadManagerController.this.facade_mon.enter();
                        if (DownloadManagerController.this.fileFacadeSet == null) break block5;
                        if (!DownloadManagerController.this.files_facade_destroyed) break block6;
                    }
                    Object var3_1 = null;
                    DownloadManagerController.this.facade_mon.exit();
                    return;
                }
                DownloadManagerController.this.files_facade_destroyed = true;
                for (int i = 0; i < this.facadeFiles.length; ++i) {
                    this.facadeFiles[i].close();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
            Object var3_2 = null;
            DownloadManagerController.this.facade_mon.exit();
        }
    }

    protected class fileInfoFacade
    implements DiskManagerFileInfo {
        private DiskManagerFileInfo delegate;
        private List listeners;

        protected fileInfoFacade() {
        }

        protected void setDelegate(DiskManagerFileInfo _delegate) {
            if (_delegate == this.delegate) {
                return;
            }
            if (this.delegate != null) {
                this.delegate.close();
            }
            this.delegate = _delegate;
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.delegate.addListener((DiskManagerFileInfoListener)this.listeners.get(i));
                }
            }
        }

        public void setPriority(int b) {
            this.delegate.setPriority(b);
        }

        public void setSkipped(boolean b) {
            this.delegate.setSkipped(b);
        }

        public boolean setLink(File link_destination) {
            return this.delegate.setLink(link_destination);
        }

        public boolean setLinkAtomic(File link_destination) {
            return this.delegate.setLinkAtomic(link_destination);
        }

        public File getLink() {
            return this.delegate.getLink();
        }

        public boolean setStorageType(int type) {
            return this.delegate.setStorageType(type);
        }

        public int getStorageType() {
            return this.delegate.getStorageType();
        }

        public int getAccessMode() {
            return this.delegate.getAccessMode();
        }

        public long getDownloaded() {
            return this.delegate.getDownloaded();
        }

        public String getExtension() {
            return this.delegate.getExtension();
        }

        public int getFirstPieceNumber() {
            return this.delegate.getFirstPieceNumber();
        }

        public int getLastPieceNumber() {
            return this.delegate.getLastPieceNumber();
        }

        public long getLength() {
            return this.delegate.getLength();
        }

        public int getNbPieces() {
            return this.delegate.getNbPieces();
        }

        public int getPriority() {
            return this.delegate.getPriority();
        }

        public boolean isSkipped() {
            return this.delegate.isSkipped();
        }

        public int getIndex() {
            return this.delegate.getIndex();
        }

        public DiskManager getDiskManager() {
            return this.delegate.getDiskManager();
        }

        public DownloadManager getDownloadManager() {
            return DownloadManagerController.this.download_manager;
        }

        public File getFile(boolean follow_link) {
            return this.delegate.getFile(follow_link);
        }

        public TOTorrentFile getTorrentFile() {
            return this.delegate.getTorrentFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() throws Exception {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.flushCache();
                Object var2_1 = null;
                DownloadManagerController.this.facade_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DirectByteBuffer read(long offset, int length) throws IOException {
            try {
                DownloadManagerController.this.facade_mon.enter();
                DirectByteBuffer directByteBuffer = this.delegate.read(offset, length);
                Object var6_4 = null;
                DownloadManagerController.this.facade_mon.exit();
                return directByteBuffer;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
        }

        public int getReadBytesPerSecond() {
            return this.delegate.getReadBytesPerSecond();
        }

        public int getWriteBytesPerSecond() {
            return this.delegate.getWriteBytesPerSecond();
        }

        public long getETA() {
            return this.delegate.getETA();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.close();
                Object var2_1 = null;
                DownloadManagerController.this.facade_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
        }

        public void addListener(DiskManagerFileInfoListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
            this.delegate.addListener(listener);
        }

        public void removeListener(DiskManagerFileInfoListener listener) {
            this.listeners.remove(listener);
            this.delegate.removeListener(listener);
        }
    }

    public class forceRecheckDiskManagerListener
    implements DiskManagerListener {
        private final boolean wasForceStarted;
        private final int start_state;
        private final ForceRecheckListener l;

        public forceRecheckDiskManagerListener(boolean wasForceStarted, int start_state, ForceRecheckListener l) {
            this.wasForceStarted = wasForceStarted;
            this.start_state = start_state;
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(int oldDMState, int newDMState) {
            try {
                DownloadManagerController.this.control_mon.enter();
                if (DownloadManagerController.this.getDiskManager() == null) {
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                    if (this.l != null) {
                        this.l.forceRecheckComplete(DownloadManagerController.this.download_manager);
                    }
                    Object var4_3 = null;
                    DownloadManagerController.this.control_mon.exit();
                    return;
                }
                Object var4_4 = null;
                DownloadManagerController.this.control_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DownloadManagerController.this.control_mon.exit();
                throw throwable;
            }
            if (newDMState == 3) {
                DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
            }
            if (newDMState == 4 || newDMState == 10) {
                DownloadManagerController.this.force_start = this.wasForceStarted;
                DownloadManagerController.this.stats.setDownloadCompleted(DownloadManagerController.this.stats.getDownloadCompleted(true));
                if (newDMState == 4) {
                    try {
                        boolean only_seeding = false;
                        boolean update_only_seeding = false;
                        try {
                            DownloadManagerController.this.control_mon.enter();
                            DiskManager dm = DownloadManagerController.this.getDiskManager();
                            if (dm != null) {
                                dm.stop(false);
                                only_seeding = dm.getRemainingExcludingDND() == 0L;
                                update_only_seeding = true;
                                DownloadManagerController.this.setDiskManager(null, null);
                                if (this.start_state == 100) {
                                    DownloadManagerController.this.setState(70, false);
                                } else {
                                    DownloadManagerController.this.setState(this.start_state, false);
                                }
                            }
                            Object var7_12 = null;
                            DownloadManagerController.this.control_mon.exit();
                            DownloadManagerController.this.download_manager.informStateChanged();
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            DownloadManagerController.this.control_mon.exit();
                            DownloadManagerController.this.download_manager.informStateChanged();
                            throw throwable;
                        }
                        if (update_only_seeding) {
                            DownloadManagerController.this.download_manager.setAssumedComplete(only_seeding);
                        }
                    }
                    catch (Exception e) {
                        DownloadManagerController.this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                    }
                } else {
                    try {
                        DownloadManagerController.this.control_mon.enter();
                        DiskManager dm = DownloadManagerController.this.getDiskManager();
                        if (dm != null) {
                            dm.stop(false);
                            DownloadManagerController.this.setDiskManager(null, null);
                            DownloadManagerController.this.setFailed(dm.getErrorMessage());
                        }
                        Object var9_15 = null;
                        DownloadManagerController.this.control_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        DownloadManagerController.this.control_mon.exit();
                        throw throwable;
                    }
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                }
                if (this.l != null) {
                    this.l.forceRecheckComplete(DownloadManagerController.this.download_manager);
                }
            }
        }

        public void filePriorityChanged(DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informPriorityChange(file);
        }

        public void pieceDoneChanged(DiskManagerPiece piece) {
        }

        public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }
    }
}

