/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection2;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class TorrentDownloaderImpl
extends AEThread
implements TorrentDownloader {
    private String original_url;
    private String url_str;
    private Proxy proxy;
    private String referrer;
    private Map request_properties;
    private String file_str;
    private URL url;
    private URLConnection con;
    private String error = "Ok";
    private String status = "";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private byte[] buf = new byte[1020];
    private int bufBytes = 0;
    private boolean deleteFileOnCancel = true;
    private boolean ignoreReponseCode = false;
    private AEMonitor this_mon = new AEMonitor("TorrentDownloader");
    private int errCode;

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
        this.setDaemon(true);
    }

    public void init(TorrentDownloaderCallBackInterface _iface, String _url, Proxy _proxy, String _referrer, Map _request_properties, String _file) {
        this.iface = _iface;
        this.original_url = _url;
        _url = _url.replace('\\', '/');
        _url = _url.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + _url);
        this.url_str = _url;
        this.proxy = _proxy;
        this.referrer = _referrer;
        this.request_properties = _request_properties;
        this.file_str = _file;
        if (this.referrer == null || this.referrer.length() == 0) {
            try {
                this.referrer = this.url_str;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(int errCode, String err) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(errCode, err);
            this.cleanUpFile();
            this.notifyListener();
            Object var4_3 = null;
            this.this_mon.exit();
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            this.closeConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runSupport() {
        block115: {
            block107: {
                try {
                    new URL(this.url_str);
                }
                catch (Throwable t) {
                    magnet_uri = UrlUtils.normaliseMagnetURI(this.url_str);
                    if (magnet_uri == null) break block107;
                    this.url_str = magnet_uri;
                }
            }
            try {
                this.url = AddressUtils.adjustURL(new URL(this.url_str));
                protocol = this.url.getProtocol().toLowerCase(Locale.US);
                if (protocol.equals("magnet") || protocol.equals("maggot") || protocol.equals("dht")) {
                    this.url = AddressUtils.adjustURL(new URL(this.url_str + (this.url_str.contains("?") != false ? "&" : "?") + "pause_on_error=true"));
                }
                redirect_urls = new HashSet<String>();
                follow_redirect = true;
                current_url = this.url;
                current_proxy = this.proxy;
                current_plugin_proxy = AEProxyFactory.getPluginProxy(current_proxy);
                block42: while (follow_redirect) {
                    follow_redirect = false;
                    for (connect_loop = 0; connect_loop < 2; ++connect_loop) {
                        try {
                            if (protocol.equals("https")) {
                                ssl_con = current_proxy == null ? (HttpsURLConnection)current_url.openConnection() : (HttpsURLConnection)current_url.openConnection(current_proxy);
                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String host, SSLSession session) {
                                        return true;
                                    }
                                });
                                this.con = ssl_con;
                            } else {
                                this.con = current_proxy == null ? current_url.openConnection() : current_url.openConnection(current_proxy);
                            }
                            if (this.con instanceof HttpURLConnection) {
                                ((HttpURLConnection)this.con).setInstanceFollowRedirects(this.proxy == null);
                            }
                            this.con.setRequestProperty("User-Agent", "Azureus 5.5.0.1_B29");
                            if (this.referrer != null && this.referrer.length() > 0) {
                                this.con.setRequestProperty("Referer", this.referrer);
                            }
                            if (this.request_properties != null) {
                                for (Map.Entry<K, V> entry : this.request_properties.entrySet()) {
                                    key = (String)entry.getKey();
                                    value = (String)entry.getValue();
                                    if (key.equalsIgnoreCase("Accept-Encoding")) continue;
                                    this.con.setRequestProperty(key, value);
                                }
                            }
                            this.con.connect();
                            magnetURI = this.con.getHeaderField("Magnet-Uri");
                            if (magnetURI != null) {
                                this.closeConnection();
                                this.url_str = magnetURI;
                                this.runSupport();
                                return;
                            }
                            v0 = response = this.con instanceof HttpURLConnection != false ? ((HttpURLConnection)this.con).getResponseCode() : 200;
                            if (response != 302 && response != 301 || (move_to = this.con.getHeaderField("location")) == null || redirect_urls.contains(move_to) || redirect_urls.size() > 32) continue block42;
                            redirect_urls.add(move_to);
                            try {
                                move_to_url = new URL(move_to);
                                follow = false;
                                if (current_plugin_proxy != null && (child = current_plugin_proxy.getChildProxy("redirect", move_to_url)) != null) {
                                    this.request_properties.put("HOST", child.getURLHostRewrite() + (move_to_url.getPort() == -1 ? "" : ":" + move_to_url.getPort()));
                                    current_proxy = child.getProxy();
                                    move_to_url = child.getURL();
                                    follow = true;
                                }
                                original_protocol = current_url.getProtocol().toLowerCase();
                                new_protocol = move_to_url.getProtocol().toLowerCase();
                                if (!follow && original_protocol.equals(new_protocol)) continue block42;
                                current_url = move_to_url;
                                try {
                                    cookies_list = this.con.getHeaderFields().get("Set-cookie");
                                    cookies_set = new ArrayList<String>();
                                    if (cookies_list != null) {
                                        for (i = 0; i < cookies_list.size(); ++i) {
                                            cookie_bits = cookies_list.get(i).split(";");
                                            if (cookie_bits.length <= 0) continue;
                                            cookies_set.add(cookie_bits[0]);
                                        }
                                    }
                                    if (cookies_set.size() > 0) {
                                        new_cookies = "";
                                        obj = this.request_properties.get("Cookie");
                                        if (obj instanceof String) {
                                            new_cookies = (String)obj;
                                        }
                                        for (String s : cookies_set) {
                                            new_cookies = new_cookies + (new_cookies.length() == 0 ? "" : "; ") + s;
                                        }
                                        this.request_properties.put("Cookie", new_cookies);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                follow_redirect = true;
                            }
                            catch (Throwable e) {}
                            continue block42;
                        }
                        catch (SSLException e) {
                            if (connect_loop == 0 && SESecurityManager.installServerCertificates(this.url) != null) continue;
                            throw e;
                        }
                        catch (IOException e) {
                            if (connect_loop == 0) {
                                retry_url = UrlUtils.getIPV4Fallback(this.url);
                                if (retry_url != null) {
                                    this.url = retry_url;
                                } else {
                                    throw e;
                                }
                            }
                            if (!(e instanceof UnknownHostException)) continue;
                            throw e;
                        }
                    }
                }
                v1 = response = this.con instanceof HttpURLConnection != false ? ((HttpURLConnection)this.con).getResponseCode() : 200;
                if (!this.ignoreReponseCode && response != 202 && response != 200) {
                    this.error(response, Integer.toString(response) + ": " + ((HttpURLConnection)this.con).getResponseMessage());
                    return;
                }
                this.filename = this.con.getHeaderField("Content-Disposition");
                if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                    while (this.filename.toLowerCase().charAt(0) != 'a') {
                        this.filename = this.filename.substring(1);
                    }
                }
                p = Pattern.compile(".*filename=\\\"(.*)\\\"");
                m = null;
                if (this.filename != null && (m = p.matcher(this.filename)) != null && m.matches()) {
                    this.filename = m.group(1).trim();
                } else if (this.filename == null || !this.filename.toLowerCase().startsWith("attachment") || this.filename.indexOf(61) == -1) {
                    tmp = this.url.getFile();
                    if (tmp.length() == 0 || tmp.equals("/")) {
                        this.filename = this.url.getHost();
                    } else if (tmp.startsWith("?")) {
                        query = tmp.toUpperCase();
                        pos = query.indexOf("XT=URN:SHA1:");
                        if (pos == -1) {
                            pos = query.indexOf("XT=URN:BTIH:");
                        }
                        this.filename = pos != -1 ? ((p2 = query.indexOf("&", pos += 12)) == -1 ? query.substring(pos) : query.substring(pos, p2)) : "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        this.filename = this.filename + ".tmp";
                    } else {
                        while (tmp.endsWith("/")) {
                            tmp = tmp.substring(0, tmp.length() - 1);
                        }
                        if (tmp.lastIndexOf(47) != -1) {
                            tmp = tmp.substring(tmp.lastIndexOf(47) + 1);
                        }
                        if ((param_pos = tmp.indexOf(63)) != -1) {
                            tmp = tmp.substring(0, param_pos);
                        }
                        this.filename = URLDecoder.decode(tmp, "UTF8");
                        if (this.filename.length() == 0) {
                            this.filename = "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        }
                    }
                } else {
                    this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                    if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                        this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                    }
                    this.filename = URLDecoder.decode(this.filename, "UTF8");
                    temp = new File(this.filename);
                    this.filename = temp.getName();
                }
                this.filename = FileUtil.convertOSSpecificChars(this.filename, false);
                this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                useTorrentSave = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                if (this.file_str != null) {
                    temp = new File(this.file_str);
                    if (!useTorrentSave || this.directoryname.length() == 0) {
                        this.directoryname = temp.isDirectory() != false ? temp.getCanonicalPath() : temp.getCanonicalFile().getParent();
                    }
                    if (!temp.isDirectory()) {
                        this.filename = temp.getName();
                    }
                }
                this.state = 0;
                this.notifyListener();
            }
            catch (MalformedURLException e) {
                this.error(0, "Exception while parsing URL '" + this.url_str + "':" + e.getMessage());
            }
            catch (UnknownHostException e) {
                this.error(0, "Exception while initializing download of '" + this.url + "': Unknown Host '" + e.getMessage() + "'");
            }
            catch (IOException ioe) {
                this.error(0, "I/O Exception while initializing download of '" + this.url + "':" + ioe.toString());
            }
            catch (Throwable e) {
                this.error(0, "Exception while initializing download of '" + this.url + "':" + e.toString());
            }
            if (this.state == 4) {
                return;
            }
            try {
                block111: {
                    block116: {
                        block109: {
                            status_reader_run = new boolean[]{true};
                            this.state = 1;
                            this.notifyListener();
                            this.state = 2;
                            this.notifyListener();
                            if (this.con instanceof HttpURLConnection) {
                                status_reader = new AEThread("TorrentDownloader:statusreader"){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void runSupport() {
                                        HttpURLConnection http_con = (HttpURLConnection)TorrentDownloaderImpl.this.con;
                                        boolean changed_status = false;
                                        String last_status = "";
                                        boolean sleep = false;
                                        long last_progress_update = SystemTime.getMonotonousTime();
                                        try {
                                            while (true) {
                                                Object var8_9;
                                                if (sleep) {
                                                    Thread.sleep(50L);
                                                    sleep = false;
                                                }
                                                try {
                                                    TorrentDownloaderImpl.this.this_mon.enter();
                                                    if (!status_reader_run[0]) {
                                                        var8_9 = null;
                                                        TorrentDownloaderImpl.this.this_mon.exit();
                                                        break;
                                                    }
                                                    var8_9 = null;
                                                    TorrentDownloaderImpl.this.this_mon.exit();
                                                }
                                                catch (Throwable throwable) {
                                                    var8_9 = null;
                                                    TorrentDownloaderImpl.this.this_mon.exit();
                                                    throw throwable;
                                                }
                                                String s = http_con.getResponseMessage();
                                                if (s.equals(last_status)) {
                                                    sleep = true;
                                                    continue;
                                                }
                                                last_status = s;
                                                String lc_s = s.toLowerCase();
                                                if (!lc_s.startsWith("error:")) {
                                                    if (s.toLowerCase().indexOf("alive") != -1 && TorrentDownloaderImpl.this.percentDone < 10) {
                                                        TorrentDownloaderImpl.this.percentDone++;
                                                    }
                                                    boolean progress_update = false;
                                                    int pos = s.indexOf(37);
                                                    if (pos != -1) {
                                                        int i;
                                                        for (i = pos - 1; i >= 0; --i) {
                                                            char c = s.charAt(i);
                                                            if (Character.isDigit(c) || c == ' ') continue;
                                                            ++i;
                                                            break;
                                                        }
                                                        try {
                                                            TorrentDownloaderImpl.this.percentDone = Integer.parseInt(s.substring(i, pos).trim());
                                                            progress_update = true;
                                                        }
                                                        catch (Throwable e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (lc_s.startsWith("received")) {
                                                        progress_update = true;
                                                    }
                                                    if (progress_update) {
                                                        long now = SystemTime.getMonotonousTime();
                                                        if (now - last_progress_update < 250L) continue;
                                                        last_progress_update = now;
                                                    }
                                                    TorrentDownloaderImpl.this.setStatus(s);
                                                } else {
                                                    TorrentDownloaderImpl.this.error(http_con.getResponseCode(), s.substring(6));
                                                }
                                                changed_status = true;
                                            }
                                        }
                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                        if (changed_status) {
                                            TorrentDownloaderImpl.this.setStatus("");
                                        }
                                    }
                                };
                                status_reader.setDaemon(true);
                                status_reader.start();
                            }
                            in = null;
                            fileout = null;
                            in = this.con.getInputStream();
                            var22_54 = null;
                            try {
                                this.this_mon.enter();
                                status_reader_run[0] = false;
                                v2 = null;
                            }
                            catch (Throwable var23_56) {
                                v2 = null;
                            }
                            var24_58 = v2;
                            this.this_mon.exit();
                            {
                                break block109;
                                catch (FileNotFoundException e) {
                                    if (this.ignoreReponseCode) {
                                        in = this.con instanceof HttpURLConnection ? ((HttpURLConnection)this.con).getErrorStream() : null;
                                    } else {
                                        throw e;
                                    }
                                    var22_54 = null;
                                    try {
                                        this.this_mon.enter();
                                        status_reader_run[0] = false;
                                        v3 = null;
                                    }
                                    catch (Throwable var23_56) {
                                        v3 = null;
                                    }
                                    var24_58 = v3;
                                    this.this_mon.exit();
                                }
                            }
                            catch (Throwable var21_60) {
                                var22_55 = null;
                                try {
                                    this.this_mon.enter();
                                    status_reader_run[0] = false;
                                    v4 = null;
                                }
                                catch (Throwable var23_57) {
                                    v4 = null;
                                }
                                var24_59 = v4;
                                this.this_mon.exit();
                                throw var21_60;
                            }
                        }
                        encoding = this.con.getHeaderField("content-encoding");
                        if (encoding != null) {
                            if (encoding.equalsIgnoreCase("gzip")) {
                                in = new GZIPInputStream(in);
                            } else if (encoding.equalsIgnoreCase("deflate")) {
                                in = new InflaterInputStream(in);
                            }
                        }
                        if (this.state == 4) break block111;
                        this.file = new File(this.directoryname, this.filename);
                        useTempFile = this.file.exists();
                        if (!useTempFile) {
                            try {
                                this.file.createNewFile();
                                useTempFile = this.file.exists() == false;
                            }
                            catch (Throwable t) {
                                useTempFile = true;
                            }
                        }
                        if (useTempFile) {
                            this.file = File.createTempFile("AZU", ".torrent", new File(this.directoryname));
                            this.file.createNewFile();
                        }
                        fileout = new FileOutputStream(this.file, false);
                        this.bufBytes = 0;
                        size = (int)UrlUtils.getContentLength(this.con);
                        this.percentDone = -1;
                        while (!this.cancel) {
                            try {
                                this.bufBytes = in.read(this.buf);
                                this.readTotal += this.bufBytes;
                                if (size > 0) {
                                    this.percentDone = 100 * this.readTotal / size;
                                }
                                this.notifyListener();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            if (this.bufBytes > 0) {
                                fileout.write(this.buf, 0, this.bufBytes);
                            }
                            if (this.bufBytes > 0) continue;
                        }
                        in.close();
                        fileout.flush();
                        fileout.close();
                        if (!this.cancel) break block116;
                        this.state = 6;
                        if (this.deleteFileOnCancel) {
                            this.cleanUpFile();
                        }
                        break block117;
                    }
                    if (this.readTotal > 0) break block118;
                    this.error(0, "No data contained in '" + this.url.toString() + "'");
                    var26_61 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (fileout == null) ** GOTO lbl-1000
                    try {
                        fileout.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
lbl-1000:
                    // 3 sources

                    {
                        block117: {
                            block113: {
                                block118: {
                                    return;
                                }
                                try {
                                    if (!this.filename.toLowerCase().endsWith(".torrent") && this.file.renameTo(new_file = new File(this.directoryname, name = TorrentUtils.getLocalisedName(torrent = TorrentUtils.readFromFile(this.file, false)) + ".torrent"))) {
                                        this.filename = name;
                                        this.file = new_file;
                                    }
                                }
                                catch (Throwable e) {
                                    is_vuze_file = false;
                                    try {
                                        if (this.filename.toLowerCase().endsWith(".vuze")) {
                                            is_vuze_file = true;
                                        } else if (VuzeFileHandler.getSingleton().loadVuzeFile(this.file) != null) {
                                            is_vuze_file = true;
                                            name = this.filename + ".vuze";
                                            new_file = new File(this.directoryname, name);
                                            if (this.file.renameTo(new_file)) {
                                                this.filename = name;
                                                this.file = new_file;
                                            }
                                        }
                                    }
                                    catch (Throwable f) {
                                        // empty catch block
                                    }
                                    if (is_vuze_file || RSSUtils.isRSSFeed(this.file)) break block113;
                                    Debug.printStackTrace(e);
                                }
                            }
                            if (this.proxy == null) {
                                TorrentUtils.setObtainedFrom(this.file, this.original_url);
                            }
                            this.state = 3;
                        }
                        this.notifyListener();
                    }
                }
                var26_62 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (fileout != null) {
                    try {
                        fileout.close();
                    }
                    catch (Throwable e) {}
                }
                break block115;
                catch (Throwable var25_67) {
                    var26_63 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (fileout != null) {
                        try {
                            fileout.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    throw var25_67;
                }
            }
            catch (Throwable e) {
                url_log_string = this.url_str.toString().replaceAll("\\Q&pause_on_error=true\\E", "");
                log_msg = MessageText.getString("torrentdownload.error.dl_fail", new String[]{url_log_string, this.file == null ? this.filename : this.file.getAbsolutePath(), e.getMessage()});
                if (!this.cancel) {
                    Debug.out(log_msg);
                }
                this.error(0, log_msg);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TorrentDownloaderImpl) {
            TorrentDownloaderImpl other = (TorrentDownloaderImpl)obj;
            if (other.original_url.equals(this.original_url)) {
                File this_file;
                File other_file = other.getFile();
                if (other_file == (this_file = this.file)) {
                    return true;
                }
                if (other_file == null || this_file == null) {
                    return false;
                }
                return other_file.getAbsolutePath().equals(this_file.getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.original_url.hashCode();
    }

    public String getError() {
        return this.error;
    }

    public void setError(int errCode, String err) {
        this.error = err;
        this.errCode = errCode;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    protected void setStatus(String str) {
        this.status = str;
        this.notifyListener();
    }

    public String getStatus() {
        return this.status;
    }

    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = new File(this.directoryname, this.filename);
        }
        return this.file;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int state) {
        this.state = state;
    }

    public String getURL() {
        return this.url.toString();
    }

    public void cancel() {
        this.cancel = true;
        this.closeConnection();
    }

    protected void closeConnection() {
        if (this.con instanceof MagnetConnection) {
            ((MagnetConnection)this.con).disconnect();
        } else if (this.con instanceof MagnetConnection2) {
            ((MagnetConnection2)this.con).disconnect();
        } else if (this.con instanceof HttpURLConnection) {
            ((HttpURLConnection)this.con).disconnect();
        }
    }

    public void setDownloadPath(String path, String file) {
        if (!this.isAlive()) {
            if (path != null) {
                this.directoryname = path;
            }
            if (file != null) {
                this.filename = file;
            }
        }
    }

    public int getTotalRead() {
        return this.readTotal;
    }

    public byte[] getLastReadBytes() {
        if (this.bufBytes <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.bufBytes];
        System.arraycopy(this.buf, 0, bytes, 0, this.bufBytes);
        return bytes;
    }

    public int getLastReadCount() {
        return this.bufBytes;
    }

    public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
        this.deleteFileOnCancel = deleteFileOnCancel;
    }

    public boolean getDeleteFileOnCancel() {
        return this.deleteFileOnCancel;
    }

    public boolean isIgnoreReponseCode() {
        return this.ignoreReponseCode;
    }

    public void setIgnoreReponseCode(boolean ignoreReponseCode) {
        this.ignoreReponseCode = ignoreReponseCode;
    }
}

