/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class Constants {
    public static final String EMPTY_STRING = "";
    public static final String SF_WEB_SITE = "http://plugins.vuze.com/";
    public static final String AELITIS_TORRENTS = "http://cf1.vuze.com/torrent/torrents/";
    public static final String AELITIS_FILES = "http://cf1.vuze.com/torrent/files/";
    public static final String AZUREUS_WIKI = "http://wiki.vuze.com/w/";
    public static final String VERSION_SERVER_V4 = "version.vuze.com";
    public static final String VERSION_SERVER_V6 = "version6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6_TUNNEL = "dht6tunnel.vuze.com";
    public static final String NAT_TEST_SERVER = "nettest.vuze.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.vuze.com/";
    public static final String SPEED_TEST_SERVER = "speedtest.vuze.com";
    public static final String PAIRING_URL = "https://pair.vuze.com/pairing";
    public static final String[] AZUREUS_DOMAINS;
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static final Charset BYTE_CHARSET;
    public static final Charset DEFAULT_CHARSET;
    public static final int DEFAULT_INSTANCE_PORT = 6880;
    public static final int INSTANCE_PORT;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static boolean DOWNLOAD_SOURCES_PRETEND_COMPLETE;
    public static String APP_NAME;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_PROTOCOL_NAME_PRE_4813 = "Azureus";
    public static final String AZUREUS_PROTOCOL_NAME = "Vuze";
    public static final String AZUREUS_VERSION = "5.5.0.1_B29";
    public static final String BUILD_VERSION = "5501-29";
    public static final String AZUREUS_SUBVER = "";
    public static final byte[] VERSION_ID;
    private static final boolean FORCE_NON_CVS;
    public static final boolean IS_CVS_VERSION;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVista;
    public static final boolean isWindowsVistaSP2OrHigher;
    public static final boolean isWindowsVistaOrHigher;
    public static final boolean isWindows7OrHigher;
    public static final boolean isWindows8OrHigher;
    public static final Pattern PAT_SPLIT_COMMAWORDS;
    public static final Pattern PAT_SPLIT_COMMA;
    public static final Pattern PAT_SPLIT_DOT;
    public static final Pattern PAT_SPLIT_SPACE;
    public static final Pattern PAT_SPLIT_SLASH_N;
    public static final boolean is64Bit;
    public static final boolean isOSX_10_5_OrHigher;
    public static final boolean isOSX_10_6_OrHigher;
    public static final boolean isOSX_10_7_OrHigher;
    public static final boolean isOSX_10_8_OrHigher;
    public static final boolean isAndroid;
    public static final String JAVA_VERSION;
    public static final int API_LEVEL;
    public static final boolean isJava7OrHigher;
    public static final String FILE_WILDCARD;

    public static String getCurrentVersion() {
        return AZUREUS_VERSION;
    }

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return IS_CVS_VERSION;
    }

    public static boolean isCVSVersion(String version) {
        return version.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static boolean isCurrentVersionLT(String version) {
        return Constants.compareVersions(AZUREUS_VERSION, version) < 0;
    }

    public static boolean isCurrentVersionGE(String version) {
        return Constants.compareVersions(AZUREUS_VERSION, version) >= 0;
    }

    public static int compareVersions(String version_1, String version_2) {
        try {
            block7: {
                version_1 = version_1.replaceAll("_B29", "_B100");
                version_2 = version_2.replaceAll("_B29", "_B100");
                if (version_1.startsWith(".")) {
                    version_1 = "0" + version_1;
                }
                if (version_2.startsWith(".")) {
                    version_2 = "0" + version_2;
                }
                version_1 = version_1.replaceAll("[^0-9.]", ".");
                version_2 = version_2.replaceAll("[^0-9.]", ".");
                StringTokenizer tok1 = new StringTokenizer(version_1, ".");
                StringTokenizer tok2 = new StringTokenizer(version_2, ".");
                while (true) {
                    int i1;
                    if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                        int i2;
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                        return i1 - i2;
                    }
                    if (tok1.hasMoreTokens()) {
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == 0) continue;
                        return 1;
                    }
                    if (!tok2.hasMoreTokens()) break block7;
                    int i2 = Integer.parseInt(tok2.nextToken());
                    if (i2 != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return !version.startsWith(".") && !version.endsWith(".") && version.indexOf("..") == -1;
    }

    public static boolean isAzureusDomain(String host) {
        host = host.toLowerCase();
        for (int i = 0; i < AZUREUS_DOMAINS.length; ++i) {
            String domain = AZUREUS_DOMAINS[i];
            if (domain.equals(host)) {
                return true;
            }
            if (!host.endsWith("." + domain)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block37: {
            Constants.AZUREUS_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com"};
            ip_str = System.getProperty("azureus.instance.port", String.valueOf(6880));
            try {
                ip = Integer.parseInt(ip_str);
            }
            catch (Throwable e) {
                ip = 6880;
            }
            Constants.INSTANCE_PORT = ip;
            bc = null;
            dc = null;
            try {
                bc = Charset.forName("ISO-8859-1");
                dc = Charset.forName("UTF8");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Constants.BYTE_CHARSET = bc;
            Constants.DEFAULT_CHARSET = dc;
            Constants.LOCALE_ENGLISH = new Locale("en", "");
            try {
                timezone = System.getProperty("azureus.timezone", null);
                if (timezone != null) {
                    TimeZone.setDefault(TimeZone.getTimeZone(timezone));
                }
            }
            catch (Throwable e) {
                if (e instanceof AccessControlException) break block37;
                e.printStackTrace();
            }
        }
        Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE = false;
        Constants.APP_NAME = "Vuze";
        Constants.VERSION_ID = "-AZ5501-".getBytes();
        Constants.FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        Constants.IS_CVS_VERSION = Constants.isCVSVersion("5.5.0.1_B29") != false && Constants.FORCE_NON_CVS == false;
        Constants.OSName = System.getProperty("os.name");
        Constants.isOSX = Constants.OSName.toLowerCase().startsWith("mac os");
        Constants.isLinux = Constants.OSName.equalsIgnoreCase("Linux");
        Constants.isSolaris = Constants.OSName.equalsIgnoreCase("SunOS");
        Constants.isFreeBSD = Constants.OSName.equalsIgnoreCase("FreeBSD");
        Constants.isWindowsXP = Constants.OSName.equalsIgnoreCase("Windows XP");
        Constants.isWindows95 = Constants.OSName.equalsIgnoreCase("Windows 95");
        Constants.isWindows98 = Constants.OSName.equalsIgnoreCase("Windows 98");
        Constants.isWindows2000 = Constants.OSName.equalsIgnoreCase("Windows 2000");
        Constants.isWindowsME = Constants.OSName.equalsIgnoreCase("Windows ME");
        Constants.isWindows9598ME = Constants.isWindows95 != false || Constants.isWindows98 != false || Constants.isWindowsME != false;
        Constants.isSafeMode = false;
        Constants.isWindows = Constants.OSName.toLowerCase().startsWith("windows");
        Constants.isUnix = Constants.isWindows == false && Constants.isOSX == false;
        Constants.PAT_SPLIT_COMMAWORDS = Pattern.compile("\\s*,\\s*");
        Constants.PAT_SPLIT_COMMA = Pattern.compile(",");
        Constants.PAT_SPLIT_DOT = Pattern.compile("\\.");
        Constants.PAT_SPLIT_SPACE = Pattern.compile(" ");
        Constants.PAT_SPLIT_SLASH_N = Pattern.compile("\n");
        try {
            _is64Bit = System.getProperty("os.arch").contains("64");
        }
        catch (Throwable e) {
            _is64Bit = false;
        }
        Constants.is64Bit = _is64Bit;
        if (Constants.isWindows) {
            block38: {
                ver = null;
                try {
                    ver = new Float(System.getProperty("os.version"));
                }
                catch (Throwable e) {
                    // empty catch block
                }
                vista_sp2_or_higher = false;
                if (ver == null) {
                    Constants.isWindowsVista = false;
                    Constants.isWindowsVistaOrHigher = false;
                    Constants.isWindows7OrHigher = false;
                    Constants.isWindows8OrHigher = false;
                } else {
                    f_ver = ver.floatValue();
                    Constants.isWindowsVista = f_ver == 6.0f;
                    Constants.isWindowsVistaOrHigher = f_ver >= 6.0f;
                    Constants.isWindows7OrHigher = f_ver >= 6.1f;
                    v0 = Constants.isWindows8OrHigher = f_ver >= 6.2f;
                    if (Constants.isWindowsVista) {
                        lnr = null;
                        try {
                            try {
                                p = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                                lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                                while ((line = lnr.readLine()) != null) {
                                    if (!line.matches(".*CSDVersion.*")) continue;
                                    vista_sp2_or_higher = line.matches(".*Service Pack [2-9]");
                                    break;
                                }
                                var8_30 = null;
                                if (lnr == null) break block38;
                            }
                            catch (Throwable e) {
                                var8_31 = null;
                                if (lnr != null) {
                                    try {
                                        lnr.close();
                                    }
                                    catch (Throwable e) {}
                                }
                                break block38;
                            }
                        }
                        catch (Throwable var7_36) {
                            var8_32 = null;
                            if (lnr == null) throw var7_36;
                            ** try [egrp 7[TRYBLOCK] [9 : 679->687)] { 
lbl105:
                            // 1 sources

                            lnr.close();
                            throw var7_36;
lbl107:
                            // 1 sources

                            catch (Throwable e) {
                                // empty catch block
                            }
                            throw var7_36;
                        }
                        try {}
                        catch (Throwable e) {}
                        lnr.close();
                    }
                }
            }
            Constants.isWindowsVistaSP2OrHigher = vista_sp2_or_higher;
        } else {
            Constants.isWindowsVista = false;
            Constants.isWindowsVistaSP2OrHigher = false;
            Constants.isWindowsVistaOrHigher = false;
            Constants.isWindows7OrHigher = false;
            Constants.isWindows8OrHigher = false;
        }
        if (Constants.isOSX) {
            first_digit = 0;
            second_digit = 0;
            try {
                os_version = System.getProperty("os.version");
                bits = os_version.split("\\.");
                first_digit = Integer.parseInt(bits[0]);
                if (bits.length > 1) {
                    second_digit = Integer.parseInt(bits[1]);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            Constants.isOSX_10_5_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 5;
            Constants.isOSX_10_6_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 6;
            Constants.isOSX_10_7_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 7;
            Constants.isOSX_10_8_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 8;
        } else {
            Constants.isOSX_10_5_OrHigher = false;
            Constants.isOSX_10_6_OrHigher = false;
            Constants.isOSX_10_7_OrHigher = false;
            Constants.isOSX_10_8_OrHigher = false;
        }
        vm_name = System.getProperty("java.vm.name", "");
        Constants.isAndroid = vm_name.equalsIgnoreCase("Dalvik");
        java_version = Constants.isAndroid != false ? "1.6" : System.getProperty("java.version");
        api_level = 0;
        if (Constants.isAndroid) {
            sdk_int = System.getProperty("android.os.build.version.sdk_int", "0");
            try {
                api_level = Integer.parseInt(sdk_int);
                if (api_level > 0 && api_level <= 8) {
                    java_version = "1.5";
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Constants.JAVA_VERSION = java_version;
        Constants.API_LEVEL = api_level;
        try {
            bits = Constants.JAVA_VERSION.split("\\.");
            first = Integer.parseInt(bits[0]);
            second = Integer.parseInt(bits[1]);
            _7plus = first > 1 || second >= 7;
        }
        catch (Throwable e) {
            System.err.println("Unparsable Java version: " + Constants.JAVA_VERSION);
            e.printStackTrace();
            _7plus = false;
        }
        Constants.isJava7OrHigher = _7plus;
        Constants.FILE_WILDCARD = Constants.isWindows != false ? "*.*" : "*";
    }
}

