/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.painted;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowVisibilityRunner;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.table.impl.TableRowCoreSorter;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTFilter;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableTooltips;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_Common;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.table.painted.TableCellPainted;
import org.gudy.azureus2.ui.swt.views.table.painted.TableRowPainted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewPainted
extends TableViewImpl<Object>
implements ParameterListener,
TableViewSWT<Object>,
ObfusticateImage,
MessageText.MessageTextListener {
    private static final boolean hasGetScrollBarMode = SWT.getVersion() >= 3821;
    private static final boolean DEBUG_ROWCHANGE = false;
    private static final boolean DEBUG_WITH_SHELL = false;
    private static final int DEFAULT_HEADER_HEIGHT = 27;
    private Composite cTable;
    private int loopFactor;
    protected int graphicsUpdate = configMan.getIntParameter("Graphics Update");
    protected int reOrderDelay = configMan.getIntParameter("ReOrder Delay");
    protected boolean extendedErase = configMan.getBooleanParameter("Table.extendedErase");
    private int defaultRowHeight = 17;
    LinkedHashSet<TableRowPainted> visibleRows = new LinkedHashSet();
    Object visibleRows_sync = new Object();
    Object lock = new Object();
    protected Rectangle clientArea;
    private boolean isVisible;
    private Shell shell;
    private Color colorLine;
    private int headerHeight;
    private Canvas cHeaderArea;
    private Image canvasImage;
    private final String sDefaultSortOn;
    private TableViewSWT_Common tvSWTCommon;
    private TableViewSWT_TabsCommon tvTabsCommon;
    private TableViewSWTPanelCreator mainPanelCreator;
    private boolean isMultiSelect;
    private int columnsWidth;
    private Menu menu;
    protected boolean isHeaderDragging;
    private TableRowPainted focusedRow;
    private boolean enableTabViews;
    private String[] tabViewRestriction;
    private boolean tabViewsExpandedByDefault = true;
    protected boolean isDragging;
    private Composite mainComposite;
    private Object heightChangeSync = new Object();
    private int totalHeight = 0;
    private boolean redrawTableScheduled;
    private Font fontHeaderSmall;
    private Font fontHeader;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private Canvas sCanvasImage;
    private RefreshTableRunnable refreshTableRunnable = new RefreshTableRunnable();
    protected boolean isFocused;
    private boolean in_swt_updateCanvasImage = false;
    boolean qdRowHeightChanged = false;

    public TableViewPainted(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        super(pluginDataSourceType, _sTableID, _sPropertiesPrefix, _basicItems);
        this.setRowsSync(this.lock);
        this.sDefaultSortOn = _sDefaultSortOn;
        this.isMultiSelect = (_iTableStyle & 2) != 0;
        this.tvSWTCommon = new TableViewSWT_Common(this){

            public void widgetSelected(SelectionEvent event2) {
            }

            public void mouseUp(TableRowCore clickedRow, TableCellCore cell, int button, int stateMask) {
                super.mouseUp(clickedRow, cell, button, stateMask);
                if (clickedRow == null) {
                    return;
                }
                if (button == 1) {
                    int keyboardModifier = stateMask & SWT.MODIFIER_MASK;
                    if ((keyboardModifier & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(clickedRow);
                        return;
                    }
                    if (keyboardModifier == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{clickedRow});
                        return;
                    }
                }
            }

            public void mouseDown(TableRowSWT clickedRow, TableCellCore cell, int button, int stateMask) {
                if (clickedRow == null) {
                    return;
                }
                int keyboardModifier = stateMask & SWT.MODIFIER_MASK;
                if (button == 1) {
                    if ((keyboardModifier & SWT.MOD1) != 0) {
                        TableViewPainted.this.setRowSelected(clickedRow, !clickedRow.isSelected(), true);
                        return;
                    }
                } else if (button == 3 && !TableViewPainted.this.isSelected(clickedRow) && keyboardModifier == 0) {
                    TableViewPainted.this.setSelectedRows(new TableRowCore[]{clickedRow});
                }
                if (TableViewPainted.this.getSelectedRowsSize() == 0) {
                    TableViewPainted.this.setSelectedRows(new TableRowCore[]{clickedRow});
                }
            }

            public void keyPressed(KeyEvent event2) {
                if (TableViewPainted.this.getComposite() != event2.widget) {
                    super.keyPressed(event2);
                    return;
                }
                boolean updateTable = false;
                if (event2.keyCode == 0x1000001) {
                    TableRowCore rowToSelect = TableViewPainted.this.getPreviousRow(TableViewPainted.this.focusedRow);
                    if ((event2.stateMask & 0x20000) != 0) {
                        if (rowToSelect != null) {
                            boolean select;
                            TableRowCore[] selectedRows = TableViewPainted.this.getSelectedRows();
                            Arrays.sort(selectedRows, new TableRowCoreSorter());
                            boolean bl = select = selectedRows.length == 0 || selectedRows[0] == TableViewPainted.this.focusedRow;
                            if (select) {
                                rowToSelect.setSelected(select);
                            } else {
                                TableViewPainted.this.focusedRow.setSelected(false);
                                TableViewPainted.this.setFocusedRow(rowToSelect);
                            }
                            updateTable = true;
                        }
                    } else if ((event2.stateMask & 0x40000) != 0) {
                        TableRowPainted firstRow = (TableRowPainted)TableViewPainted.this.visibleRows.iterator().next();
                        if (firstRow != null) {
                            int hChange = 0;
                            if (TableViewPainted.this.isRowPartiallyVisible(firstRow)) {
                                hChange = firstRow.getDrawOffset().y - TableViewPainted.this.clientArea.y;
                            } else {
                                TableRowCore prevRow = TableViewPainted.this.getPreviousRow(firstRow);
                                if (prevRow != firstRow && prevRow != null) {
                                    hChange = -prevRow.getHeight();
                                }
                            }
                            TableViewPainted.this.vBar.setSelection(TableViewPainted.this.vBar.getSelection() + hChange);
                            TableViewPainted.this.swt_vBarChanged();
                        }
                    } else {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{rowToSelect});
                        updateTable = true;
                    }
                } else if (event2.keyCode == 0x1000005) {
                    int y;
                    TableRowCore row = TableViewPainted.this.focusedRow;
                    TableRowPainted lastRow = TableViewPainted.this.getLastVisibleRow();
                    int n = y = lastRow == null ? 0 : TableViewPainted.this.clientArea.y + TableViewPainted.this.clientArea.height - lastRow.getDrawOffset().y;
                    while (row != null && y < TableViewPainted.this.clientArea.height) {
                        y += row.getHeight();
                        row = TableViewPainted.this.getPreviousRow(row);
                    }
                    if (row == null) {
                        row = TableViewPainted.this.getRow(0);
                    }
                    if ((event2.stateMask & 0x20000) != 0) {
                        if (row != null) {
                            TableViewPainted.this.selectRowsTo(row);
                        }
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000007) {
                    if ((event2.stateMask & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(TableViewPainted.this.getRow(0));
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{TableViewPainted.this.getRow(0)});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000002) {
                    if ((event2.stateMask & 0x40000) != 0) {
                        TableRowPainted firstRow = (TableRowPainted)TableViewPainted.this.visibleRows.iterator().next();
                        if (firstRow != null) {
                            int hChange = 0;
                            hChange = TableViewPainted.this.isRowPartiallyVisible(firstRow) ? firstRow.getHeight() + (firstRow.getDrawOffset().y - TableViewPainted.this.clientArea.y) : firstRow.getHeight();
                            TableViewPainted.this.vBar.setSelection(TableViewPainted.this.vBar.getSelection() + hChange);
                            TableViewPainted.this.swt_vBarChanged();
                        }
                    } else {
                        TableRowCore rowToSelect = TableViewPainted.this.getNextRow(TableViewPainted.this.focusedRow);
                        if (rowToSelect != null) {
                            if ((event2.stateMask & 0x20000) != 0) {
                                boolean select;
                                TableRowCore[] selectedRows = TableViewPainted.this.getSelectedRows();
                                Arrays.sort(selectedRows, new TableRowCoreSorter());
                                boolean bl = select = selectedRows.length == 0 || selectedRows[selectedRows.length - 1] == TableViewPainted.this.focusedRow;
                                if (select) {
                                    rowToSelect.setSelected(select);
                                } else {
                                    TableViewPainted.this.focusedRow.setSelected(false);
                                    TableViewPainted.this.setFocusedRow(rowToSelect);
                                }
                            } else {
                                TableViewPainted.this.setSelectedRows(new TableRowCore[]{rowToSelect});
                            }
                            updateTable = true;
                        }
                    }
                } else if (event2.keyCode == 0x1000006) {
                    int y;
                    TableRowCore row = TableViewPainted.this.focusedRow;
                    TableRowPainted firstRow = TableViewPainted.this.visibleRows.size() == 0 ? null : (TableRowPainted)TableViewPainted.this.visibleRows.iterator().next();
                    int n = y = firstRow == null ? 0 : firstRow.getHeight() - (TableViewPainted.this.clientArea.y - firstRow.getDrawOffset().y);
                    while (row != null && y < TableViewPainted.this.clientArea.height) {
                        y += row.getHeight();
                        TableRowCore nextRow = TableViewPainted.this.getNextRow(row);
                        if (nextRow == null) break;
                        row = nextRow;
                    }
                    if ((event2.stateMask & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(row);
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000008) {
                    TableRowCore lastRow = TableViewPainted.this.getRow(TableViewPainted.this.getRowCount() - 1);
                    if ((event2.stateMask & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(lastRow);
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{lastRow});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000004 && event2.stateMask == 0) {
                    if (event2.stateMask == 0 && TableViewPainted.this.focusedRow != null && !TableViewPainted.this.focusedRow.isExpanded() && TableViewPainted.this.canHaveSubItems()) {
                        TableViewPainted.this.focusedRow.setExpanded(true);
                    } else if (TableViewPainted.this.hBar.isEnabled()) {
                        TableViewPainted.this.hBar.setSelection(TableViewPainted.this.hBar.getSelection() + 50);
                        TableViewPainted.this.cTable.redraw();
                        updateTable = true;
                    }
                } else if (event2.keyCode == 0x1000003 && event2.stateMask == 0) {
                    if (event2.stateMask == 0 && TableViewPainted.this.focusedRow != null && TableViewPainted.this.focusedRow.isExpanded() && TableViewPainted.this.canHaveSubItems()) {
                        TableViewPainted.this.focusedRow.setExpanded(false);
                    } else if (TableViewPainted.this.hBar.isEnabled()) {
                        TableViewPainted.this.hBar.setSelection(TableViewPainted.this.hBar.getSelection() - 50);
                        TableViewPainted.this.cTable.redraw();
                        updateTable = true;
                    }
                }
                if (updateTable) {
                    TableViewPainted.this.cTable.update();
                }
                super.keyPressed(event2);
            }

            public void keyReleased(KeyEvent e) {
                TableViewPainted.this.swt_calculateClientArea();
                TableViewPainted.this.visibleRowsChanged();
                super.keyReleased(e);
            }
        };
    }

    protected boolean isRowPartiallyVisible(TableRowPainted row) {
        if (row == null) {
            return false;
        }
        Point drawOffset = row.getDrawOffset();
        int height = row.getHeight();
        return drawOffset.y < this.clientArea.y && drawOffset.y + height > this.clientArea.y || drawOffset.y < this.clientArea.y + this.clientArea.height && drawOffset.y + height > this.clientArea.y + this.clientArea.height;
    }

    protected void selectRowsTo(TableRowCore clickedRow) {
        TableRowCore newRow;
        int endPos;
        int startPos;
        TableRowCore firstRow;
        if (!this.isMultiSelect) {
            this.setSelectedRows(new TableRowCore[]{clickedRow});
            return;
        }
        TableRowCore[] selectedRows = this.getSelectedRows();
        TableRowCore parentFirstRow = firstRow = selectedRows.length > 0 ? selectedRows[0] : this.getRow(0);
        while (parentFirstRow.getParentRowCore() != null) {
            parentFirstRow = parentFirstRow.getParentRowCore();
        }
        TableRowCore parentClickedRow = clickedRow;
        while (parentClickedRow.getParentRowCore() != null) {
            parentClickedRow = parentClickedRow.getParentRowCore();
        }
        if (parentFirstRow == parentClickedRow) {
            startPos = parentFirstRow == firstRow ? -1 : firstRow.getIndex();
            endPos = parentClickedRow == clickedRow ? -1 : clickedRow.getIndex();
        } else {
            startPos = this.indexOf(parentFirstRow);
            endPos = this.indexOf(parentClickedRow);
            if (endPos == -1 || startPos == -1) {
                return;
            }
        }
        ArrayList<TableRowCore> rowsToSelect = new ArrayList<TableRowCore>(Arrays.asList(selectedRows));
        TableRowCore curRow = firstRow;
        do {
            if (!rowsToSelect.contains(curRow)) {
                rowsToSelect.add(curRow);
            }
            TableRowCore tableRowCore = newRow = startPos < endPos ? this.getNextRow(curRow) : this.getPreviousRow(curRow);
        } while (newRow != curRow && (curRow = newRow) != clickedRow && curRow != null);
        if (curRow != null && !rowsToSelect.contains(curRow)) {
            rowsToSelect.add(curRow);
        }
        this.setSelectedRows(rowsToSelect.toArray(new TableRowCore[0]));
        this.setFocusedRow(clickedRow);
    }

    protected TableRowCore getPreviousRow(TableRowCore relativeToRow) {
        TableRowCore rowToSelect = null;
        if (relativeToRow != null) {
            int index;
            TableRowCore row;
            TableRowCore parentRow = relativeToRow.getParentRowCore();
            rowToSelect = parentRow == null ? ((row = this.getRow(this.indexOf(relativeToRow) - 1)) != null && row.isExpanded() && row.getSubItemCount() > 0 ? row.getSubRow(row.getSubItemCount() - 1) : row) : ((index = relativeToRow.getIndex()) > 0 ? parentRow.getSubRow(index - 1) : parentRow);
        }
        if (rowToSelect == null) {
            rowToSelect = this.getRow(0);
        }
        return rowToSelect;
    }

    protected TableRowCore getNextRow(TableRowCore relativeToRow) {
        TableRowCore rowToSelect = null;
        if (relativeToRow == null) {
            rowToSelect = this.getRow(0);
        } else if (relativeToRow.isExpanded() && relativeToRow.getSubItemCount() > 0) {
            TableRowCore[] subRowsWithNull;
            for (TableRowCore row : subRowsWithNull = relativeToRow.getSubRowsWithNull()) {
                if (row == null) continue;
                rowToSelect = row;
                break;
            }
            if (rowToSelect == null) {
                rowToSelect = this.getRow(relativeToRow.getIndex() + 1);
            }
        } else {
            TableRowCore parentRow = relativeToRow.getParentRowCore();
            if (parentRow != null) {
                rowToSelect = parentRow.getSubRow(relativeToRow.getIndex() + 1);
                if (rowToSelect == null) {
                    rowToSelect = this.getRow(parentRow.getIndex() + 1);
                }
            } else {
                rowToSelect = this.getRow(relativeToRow.getIndex() + 1);
            }
        }
        return rowToSelect;
    }

    @Override
    public void clipboardSelected() {
        TableRowCore[] rows;
        String sToClipboard = "";
        TableColumnCore[] visibleColumns = this.getVisibleColumns();
        for (int j = 0; j < visibleColumns.length; ++j) {
            if (j != 0) {
                sToClipboard = sToClipboard + "\t";
            }
            String title = MessageText.getString(visibleColumns[j].getTitleLanguageKey());
            sToClipboard = sToClipboard + title;
        }
        for (TableRowCore row : rows = this.getSelectedRows()) {
            sToClipboard = sToClipboard + "\n";
            for (int j = 0; j < visibleColumns.length; ++j) {
                TableCellCore cell;
                TableColumnCore column = visibleColumns[j];
                if (j != 0) {
                    sToClipboard = sToClipboard + "\t";
                }
                if ((cell = row.getTableCellCore(column.getName())) == null) continue;
                sToClipboard = sToClipboard + cell.getClipboardText();
            }
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    @Override
    public boolean isDisposed() {
        return this.cTable == null || this.cTable.isDisposed();
    }

    @Override
    public void refreshTable(boolean bForceSort) {
        this.refreshTableRunnable.setForceSort(bForceSort);
        Utils.getOffOfSWTThread(this.refreshTableRunnable);
    }

    public void __refreshTable(boolean bForceSort) {
        boolean bWillSort;
        long lStart = SystemTime.getCurrentTime();
        super.refreshTable(bForceSort);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewPainted.this.isVisible();
            }
        });
        final boolean bDoGraphics = this.loopFactor % this.graphicsUpdate == 0;
        boolean bl = bWillSort = bForceSort || this.reOrderDelay != 0 && this.loopFactor % this.reOrderDelay == 0;
        if (bWillSort) {
            TableColumnCore sortColumn = this.getSortColumn();
            if (bForceSort && sortColumn != null) {
                this.resetLastSortedOn();
                sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
            }
            this._sortColumn(true, false, false);
        }
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                row.refresh(bDoGraphics, bVisible);
            }
        });
        ++this.loopFactor;
        long diff = SystemTime.getCurrentTime() - lStart;
        if (diff > 0L) {
            // empty if block
        }
        if (this.tvTabsCommon != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (TableViewPainted.this.tvTabsCommon != null) {
                        TableViewPainted.this.tvTabsCommon.swt_refresh();
                    }
                }
            });
        }
    }

    @Override
    public void setEnableTabViews(boolean enableTabViews, boolean expandByDefault, String[] restrictedToIDs) {
        this.enableTabViews = enableTabViews;
        this.tabViewRestriction = restrictedToIDs;
        this.tabViewsExpandedByDefault = expandByDefault;
    }

    @Override
    public boolean isTabViewsEnabled() {
        return this.enableTabViews;
    }

    @Override
    public String[] getTabViewsRestrictedTo() {
        return this.tabViewRestriction;
    }

    @Override
    public boolean getTabViewsExpandedByDefault() {
        return this.tabViewsExpandedByDefault;
    }

    @Override
    public void setFocus() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.isDisposed()) {
                    return;
                }
                TableViewPainted.this.cTable.setFocus();
            }
        });
    }

    @Override
    public void setRowDefaultHeight(int iHeight) {
        if (iHeight > this.defaultRowHeight) {
            this.defaultRowHeight = iHeight;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (TableViewPainted.this.vBar != null && !TableViewPainted.this.vBar.isDisposed()) {
                        TableViewPainted.this.vBar.setIncrement(TableViewPainted.this.defaultRowHeight);
                    }
                }
            });
        }
    }

    @Override
    public TableRowCore getRow(int x, int y) {
        LinkedHashSet<TableRowPainted> visibleRows = this.visibleRows;
        if (visibleRows.size() == 0) {
            return null;
        }
        boolean firstRow = true;
        int curY = 0;
        for (TableRowPainted row : visibleRows) {
            if (firstRow) {
                curY = row.getDrawOffset().y;
            }
            int h = row.getHeight();
            if (y >= curY && y < curY + h) {
                return row;
            }
            curY += h;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRowVisible(TableRowCore row) {
        if (row == null) {
            return false;
        }
        Object object = this.visibleRows_sync;
        synchronized (object) {
            return this.visibleRows.contains(row);
        }
    }

    @Override
    public TableCellCore getTableCellWithCursor() {
        Point pt = this.cTable.getDisplay().getCursorLocation();
        pt = this.cTable.toControl(pt);
        return this.getTableCell(pt.x, this.clientArea.y + pt.y);
    }

    @Override
    public TableRowCore getTableRowWithCursor() {
        Point pt = this.cTable.getDisplay().getCursorLocation();
        pt = this.cTable.toControl(pt);
        return this.getTableRow(pt.x, pt.y, true);
    }

    @Override
    public int getRowDefaultHeight() {
        return this.defaultRowHeight;
    }

    @Override
    public void setEnabled(final boolean enable) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!TableViewPainted.this.isDisposed()) {
                    TableViewPainted.this.cTable.setEnabled(enable);
                }
            }
        });
    }

    @Override
    public boolean canHaveSubItems() {
        return true;
    }

    @Override
    public void setHeaderVisible(final boolean visible) {
        super.setHeaderVisible(visible);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.cHeaderArea != null && !TableViewPainted.this.cHeaderArea.isDisposed()) {
                    TableViewPainted.this.cHeaderArea.setVisible(visible);
                    FormData fd = Utils.getFilledFormData();
                    fd.height = visible ? TableViewPainted.this.headerHeight : 1;
                    fd.bottom = null;
                    TableViewPainted.this.cHeaderArea.setLayoutData((Object)fd);
                    TableViewPainted.this.cHeaderArea.getParent().layout(true);
                }
            }
        });
    }

    @Override
    public int getMaxItemShown() {
        return 0;
    }

    @Override
    public void setMaxItemShown(int newIndex) {
    }

    @Override
    public void localeChanged(Locale old_locale, Locale new_locale) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.tvTabsCommon != null) {
                    TableViewPainted.this.tvTabsCommon.localeChanged();
                }
                TableViewPainted.this.tableInvalidate();
                TableViewPainted.this.refreshTable(true);
                TableViewPainted.this.cHeaderArea.redraw();
            }
        });
    }

    @Override
    public void columnOrderChanged(int[] iPositions) {
    }

    @Override
    public void columnSizeChanged(TableColumnCore tableColumn, int diff) {
        this.columnsWidth += diff;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.cHeaderArea != null && !TableViewPainted.this.cHeaderArea.isDisposed()) {
                    TableViewPainted.this.cHeaderArea.redraw();
                }
                TableViewPainted.this.swt_fixupSize();
                TableViewPainted.this.redrawTable();
            }
        });
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.tvSWTCommon == null) {
            return;
        }
        this.tvSWTCommon.addKeyListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        if (this.tvSWTCommon == null) {
            return;
        }
        this.tvSWTCommon.removeKeyListener(listener);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        if (this.tvSWTCommon == null) {
            return new KeyListener[0];
        }
        return this.tvSWTCommon.getKeyListeners();
    }

    @Override
    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        if (this.tvSWTCommon == null) {
            return;
        }
        this.tvSWTCommon.addMenuFillListener(l);
    }

    @Override
    public DragSource createDragSource(int style) {
        final DragSource dragSource = new DragSource((Control)this.cTable, style);
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event2) {
                TableViewPainted.this.cTable.setCursor(null);
                TableRowSWT row = TableViewPainted.this.getTableRow(event2.x, event2.y, true);
                if (row != null && !row.isSelected()) {
                    TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                }
                TableViewPainted.this.isDragging = true;
            }

            public void dragFinished(DragSourceEvent event2) {
                TableViewPainted.this.isDragging = false;
            }
        });
        this.cTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!dragSource.isDisposed()) {
                    dragSource.dispose();
                }
            }
        });
        return dragSource;
    }

    @Override
    public DropTarget createDropTarget(int style) {
        final DropTarget dropTarget = new DropTarget((Control)this.cTable, style);
        this.cTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!dropTarget.isDisposed()) {
                    dropTarget.dispose();
                }
            }
        });
        return dropTarget;
    }

    @Override
    public Composite getComposite() {
        return this.cTable;
    }

    @Override
    public TableRowCore getRow(DropTargetEvent event2) {
        Point pt = this.cTable.toControl(event2.x, event2.y);
        return this.getRow(pt.x, this.clientArea.y + pt.y);
    }

    @Override
    public TableRowSWT getRowSWT(Object dataSource) {
        return (TableRowSWT)this.getRow(dataSource);
    }

    @Override
    public Composite getTableComposite() {
        return this.cTable;
    }

    @Override
    public Composite createMainPanel(Composite composite) {
        TableViewSWTPanelCreator mainPanelCreator = this.getMainPanelCreator();
        if (mainPanelCreator != null) {
            return mainPanelCreator.createTableViewPanel(composite);
        }
        Composite panel = new Composite(composite, 524288);
        composite.getLayout();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        Layout parentLayout = composite.getLayout();
        if (parentLayout == null || parentLayout instanceof GridLayout) {
            panel.setLayoutData((Object)new GridData(1808));
        }
        return panel;
    }

    @Override
    public void initialize(Composite parent) {
        this.initialize(null, parent);
    }

    @Override
    public void initialize(UISWTView parentView, Composite parent) {
        TableColumnCore tc;
        this.tvTabsCommon = new TableViewSWT_TabsCommon(parentView, this);
        this.shell = parent.getShell();
        this.mainComposite = this.tvTabsCommon.createSashForm(parent);
        this.mainComposite.setData("Name", (Object)this.tableID);
        this.mainComposite.setData("ObfusticateImage", (Object)this);
        Composite cTableComposite = this.tvTabsCommon.tableComposite;
        cTableComposite.setLayout((Layout)new FormLayout());
        Layout layout = parent.getLayout();
        if (layout instanceof FormLayout) {
            FormData fd = Utils.getFilledFormData();
            cTableComposite.setLayoutData((Object)fd);
        }
        this.cHeaderArea = new Canvas(cTableComposite, 0x20000000);
        this.fontHeader = FontUtils.getFontWithHeight(this.cHeaderArea.getFont(), null, 12);
        this.fontHeaderSmall = FontUtils.getFontPercentOf(this.fontHeader, 0.8f);
        this.cHeaderArea.setFont(this.fontHeader);
        this.cTable = new Canvas(cTableComposite, 262912);
        int minRowHeight = FontUtils.getFontHeightInPX(this.cTable.getFont());
        minRowHeight = (int)((double)minRowHeight + Math.ceil((double)minRowHeight * 2.0 / 16.0));
        if (this.defaultRowHeight < minRowHeight) {
            this.defaultRowHeight = minRowHeight;
        }
        this.cTable.setBackground(parent.getDisplay().getSystemColor(25));
        this.headerHeight = configMan.getIntParameter("Table.headerHeight");
        if (this.headerHeight <= 0) {
            this.headerHeight = 27;
        }
        FormData fd = Utils.getFilledFormData();
        fd.height = this.headerHeight;
        fd.bottom = null;
        this.cHeaderArea.setLayoutData((Object)fd);
        fd = Utils.getFilledFormData();
        fd.top = new FormAttachment((Control)this.cHeaderArea);
        this.cTable.setLayoutData((Object)fd);
        this.clientArea = this.cTable.getClientArea();
        TableColumnCore[] tableColumns = this.getAllColumns();
        TableColumnCore[] tmpColumnsOrdered = new TableColumnCore[tableColumns.length];
        int columnOrderPos = 0;
        Arrays.sort(tableColumns, TableColumnManager.getTableColumnOrderComparator());
        for (int i = 0; i < tableColumns.length; ++i) {
            int position = tableColumns[i].getPosition();
            if (position == -1 || !tableColumns[i].isVisible()) continue;
            tmpColumnsOrdered[columnOrderPos++] = tableColumns[i];
        }
        TableColumnCore[] columnsOrdered = new TableColumnCore[columnOrderPos];
        System.arraycopy(tmpColumnsOrdered, 0, columnsOrdered, 0, columnOrderPos);
        this.setColumnsOrdered(columnsOrdered);
        this.cTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableViewPainted.this.swt_paintComposite(e);
            }
        });
        this.menu = this.createMenu();
        this.cTable.setMenu(this.menu);
        this.cHeaderArea.setMenu(this.menu);
        this.setupHeaderArea(this.cHeaderArea);
        this.cTable.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TableViewPainted.this.swt_calculateClientArea();
                TableViewPainted.this.swt_fixupSize();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.hBar = this.cTable.getHorizontalBar();
        if (this.hBar != null) {
            this.hBar.setValues(0, 0, 0, 10, 10, 100);
            this.hBar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewPainted.this.cTable.redraw();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.vBar = this.cTable.getVerticalBar();
        if (this.vBar != null) {
            this.vBar.setValues(0, 0, 0, 50, this.getRowDefaultHeight(), 50);
            this.vBar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewPainted.this.swt_vBarChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.cTable.addMouseListener((MouseListener)this.tvSWTCommon);
        this.cTable.addMouseMoveListener((MouseMoveListener)this.tvSWTCommon);
        this.cTable.addKeyListener((KeyListener)this.tvSWTCommon);
        this.cTable.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                if (TableViewPainted.this.cTable == null || TableViewPainted.this.cTable.isDisposed()) {
                    SelectedContentManager.removeCurrentlySelectedContentListener(this);
                } else {
                    TableViewPainted.this.redrawTable();
                }
            }
        });
        this.cTable.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TableViewPainted.this.isFocused = false;
                TableViewPainted.this.redrawTable();
            }

            public void focusGained(FocusEvent e) {
                TableViewPainted.this.isFocused = true;
                TableViewPainted.this.redrawTable();
            }
        });
        this.isFocused = this.cTable.isFocusControl();
        new TableTooltips(this, this.cTable);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String sSortColumn = tcManager.getDefaultSortColumnName(this.tableID);
        if (sSortColumn == null || sSortColumn.length() == 0) {
            sSortColumn = this.sDefaultSortOn;
        }
        if ((tc = tcManager.getTableColumnCore(this.tableID, sSortColumn)) == null && tableColumns.length > 0) {
            tc = tableColumns[0];
        }
        this.setSortColumn(tc, false);
        this.triggerLifeCycleListener(0);
        configMan.addParameterListener("Graphics Update", this);
        configMan.addParameterListener("ReOrder Delay", this);
        configMan.addParameterListener("Table.extendedErase", this);
        configMan.addParameterListener("Table.headerHeight", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.tableID).addListener(this);
    }

    protected void swt_vBarChanged() {
        this.swt_calculateClientArea();
        this.cTable.update();
    }

    private void setupHeaderArea(final Canvas cHeaderArea) {
        cHeaderArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableViewPainted.this.paintHeader(e);
            }
        });
        Listener l = new Listener(){
            boolean mouseDown = false;
            TableColumnCore columnSizing;
            int columnSizingStart = 0;

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 3: {
                        TableColumnCore[] visibleColumns;
                        if (e.button != 1) {
                            return;
                        }
                        this.mouseDown = true;
                        this.columnSizing = null;
                        int x = -TableViewPainted.this.clientArea.x;
                        for (TableColumnCore column : visibleColumns = TableViewPainted.this.getVisibleColumns()) {
                            int w = column.getWidth();
                            if (e.x < (x += w) - 3 || e.x > x + 3) continue;
                            this.columnSizing = column;
                            this.columnSizingStart = e.x;
                            break block0;
                        }
                        break;
                    }
                    case 4: {
                        TableColumnCore column;
                        if (e.button != 1) {
                            return;
                        }
                        if (this.mouseDown && this.columnSizing == null && (column = TableViewPainted.this.getTableColumnByOffset(e.x)) != null) {
                            TableViewPainted.this.setSortColumn(column, true);
                        }
                        this.columnSizing = null;
                        this.mouseDown = false;
                        break;
                    }
                    case 5: {
                        TableColumnCore[] visibleColumns;
                        if (this.columnSizing != null) {
                            int diff = e.x - this.columnSizingStart;
                            this.columnSizing.setWidth(this.columnSizing.getWidth() + diff);
                            this.columnSizingStart = e.x;
                            break;
                        }
                        int cursorID = 21;
                        int x = -TableViewPainted.this.clientArea.x;
                        for (TableColumnCore column : visibleColumns = TableViewPainted.this.getVisibleColumns()) {
                            int w = column.getWidth();
                            if (e.x < (x += w) - 3 || e.x > x + 3) continue;
                            cursorID = 9;
                            break;
                        }
                        cHeaderArea.setCursor(e.display.getSystemCursor(cursorID));
                        TableColumnCore column = TableViewPainted.this.getTableColumnByOffset(e.x);
                        if (column == null) {
                            cHeaderArea.setToolTipText(null);
                            break;
                        }
                        String info = MessageText.getString(column.getTitleLanguageKey() + ".info", (String)null);
                        if (column.showOnlyImage()) {
                            String tt = MessageText.getString(column.getTitleLanguageKey());
                            if (info != null) {
                                tt = tt + "\n" + info;
                            }
                            cHeaderArea.setToolTipText(tt);
                            break;
                        }
                        cHeaderArea.setToolTipText(info);
                    }
                }
            }
        };
        cHeaderArea.addListener(3, l);
        cHeaderArea.addListener(4, l);
        cHeaderArea.addListener(5, l);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        final DragSource ds = new DragSource((Control)cHeaderArea, 2);
        ds.setTransfer(types);
        ds.addDragListener(new DragSourceListener(){
            private String eventData;

            public void dragStart(DragSourceEvent event2) {
                Cursor cursor = cHeaderArea.getCursor();
                if (cursor != null && cursor.equals((Object)event2.display.getSystemCursor(9))) {
                    event2.doit = false;
                    return;
                }
                cHeaderArea.setCursor(null);
                TableColumnCore tc = TableViewPainted.this.getTableColumnByOffset(event2.x);
                boolean bl = TableViewPainted.this.isHeaderDragging = tc != null;
                if (TableViewPainted.this.isHeaderDragging) {
                    this.eventData = tc.getName();
                }
            }

            public void dragSetData(DragSourceEvent event2) {
                event2.data = this.eventData;
            }

            public void dragFinished(DragSourceEvent event2) {
                TableViewPainted.this.isHeaderDragging = false;
                this.eventData = null;
            }
        });
        final DropTarget dt = new DropTarget((Control)cHeaderArea, 2);
        dt.setTransfer(types);
        dt.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event2) {
            }

            public void drop(final DropTargetEvent event2) {
                if (event2.data instanceof String) {
                    TableColumnCore[] visibleColumns;
                    TableColumn tcOrig = TableViewPainted.this.getTableColumn((String)event2.data);
                    Point pt = TableViewPainted.this.cTable.toControl(event2.x, event2.y);
                    TableColumnCore tcDest = TableViewPainted.this.getTableColumnByOffset(pt.x);
                    if (tcDest == null && (visibleColumns = TableViewPainted.this.getVisibleColumns()) != null && visibleColumns.length > 0) {
                        tcDest = visibleColumns[visibleColumns.length - 1];
                    }
                    if (tcOrig != null && tcDest != null) {
                        int origPos;
                        int destPos = tcDest.getPosition();
                        final boolean moveRight = destPos > (origPos = tcOrig.getPosition());
                        TableColumnCore[] visibleColumns2 = TableViewPainted.this.getVisibleColumns();
                        ((TableColumnCore)tcOrig).setPositionNoShift(destPos);
                        Arrays.sort(visibleColumns2, new Comparator<TableColumnCore>(){

                            @Override
                            public int compare(TableColumnCore o1, TableColumnCore o2) {
                                if (o1 == o2) {
                                    return 0;
                                }
                                int diff = o1.getPosition() - o2.getPosition();
                                if (diff == 0) {
                                    int i;
                                    int n = i = o1.getName().equals(event2.data) ? -1 : 1;
                                    if (moveRight) {
                                        i *= -1;
                                    }
                                    return i;
                                }
                                return diff;
                            }
                        });
                        for (int i = 0; i < visibleColumns2.length; ++i) {
                            TableColumnCore tc = visibleColumns2[i];
                            tc.setPositionNoShift(i);
                        }
                        TableViewPainted.this.setColumnsOrdered(visibleColumns2);
                        TableStructureEventDispatcher.getInstance(TableViewPainted.this.tableID).tableStructureChanged(false, TableViewPainted.this.getDataSourceType());
                    }
                }
            }

            public void dragOver(DropTargetEvent event2) {
            }

            public void dragOperationChanged(DropTargetEvent event2) {
            }

            public void dragLeave(DropTargetEvent event2) {
            }

            public void dragEnter(DropTargetEvent event2) {
            }
        });
        cHeaderArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(new Object[]{ds, dt, TableViewPainted.this.fontHeader, TableViewPainted.this.fontHeaderSmall});
            }
        });
    }

    @Override
    public void tableStructureChanged(final boolean columnAddedOrRemoved, final Class forPluginDataSourceType) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewPainted.super.tableStructureChanged(columnAddedOrRemoved, forPluginDataSourceType);
                if (TableViewPainted.this.cHeaderArea != null && !TableViewPainted.this.cHeaderArea.isDisposed()) {
                    TableViewPainted.this.cHeaderArea.redraw();
                }
                TableViewPainted.this.redrawTable();
            }
        });
    }

    protected void swt_paintComposite(PaintEvent e) {
        this.swt_calculateClientArea();
        if (this.canvasImage == null) {
            return;
        }
        e.gc.drawImage(this.canvasImage, -this.clientArea.x, 0);
    }

    protected void swt_paintCanvasImage(GC gc, Rectangle drawBounds) {
        int h;
        int yDirty;
        if (this.cTable == null || this.cTable.isDisposed()) {
            return;
        }
        int end = drawBounds.y + drawBounds.height;
        gc.setFont(this.cTable.getFont());
        gc.setClipping(drawBounds);
        TableRowPainted oldRow = null;
        int pos = -1;
        LinkedHashSet<TableRowPainted> visibleRows = this.visibleRows;
        Iterator iterator = visibleRows.iterator();
        while (iterator.hasNext()) {
            TableRowPainted row;
            TableRowPainted paintedRow = row = (TableRowPainted)iterator.next();
            pos = pos == -1 ? row.getIndex() : ++pos;
            Point drawOffset = paintedRow.getDrawOffset();
            int rowStartX = 0;
            int rowStartY = drawOffset.y - this.clientArea.y;
            int rowHeight = paintedRow.getHeight();
            if (drawBounds.intersects(rowStartX, rowStartY, 9999, rowHeight)) {
                int diffY2 = rowStartY + rowHeight - (drawBounds.y + drawBounds.height);
                if (diffY2 > 0) {
                    drawBounds.height += diffY2;
                    gc.setClipping(drawBounds);
                }
                paintedRow.swt_paintGC(gc, drawBounds, rowStartX, rowStartY, pos);
            }
            oldRow = row;
        }
        if (oldRow == null) {
            yDirty = drawBounds.y;
            h = drawBounds.height;
        } else {
            yDirty = ((TableRowPainted)oldRow).getDrawOffset().y + ((TableRowPainted)oldRow).getFullHeight();
            h = drawBounds.y + drawBounds.height - yDirty;
        }
        if (h > 0) {
            int rowHeight = this.getRowDefaultHeight();
            if (this.extendedErase) {
                while (yDirty < end) {
                    Color color;
                    if ((color = TableRowPainted.alternatingColors[++pos % 2]) != null) {
                        gc.setBackground(color);
                    }
                    if (color == null) {
                        gc.setBackground(gc.getDevice().getSystemColor(25));
                    }
                    gc.fillRectangle(drawBounds.x, yDirty, drawBounds.width, rowHeight);
                    yDirty += rowHeight;
                }
            } else {
                gc.setBackground(gc.getDevice().getSystemColor(25));
                gc.fillRectangle(drawBounds.x, yDirty, drawBounds.width, h);
            }
        }
        TableColumnCore[] visibleColumns = this.getVisibleColumns();
        int x = 0;
        gc.setAlpha(20);
        for (TableColumnCore column : visibleColumns) {
            gc.drawLine((x += column.getWidth()) - 1, drawBounds.y, x - 1, drawBounds.y + drawBounds.height);
        }
        gc.setAlpha(255);
    }

    private Color getColorLine() {
        if (this.colorLine == null) {
            this.colorLine = this.cTable.getDisplay().getSystemColor(25);
            HSLColor hslColor = new HSLColor();
            hslColor.initHSLbyRGB(this.colorLine.getRed(), this.colorLine.getGreen(), this.colorLine.getBlue());
            int lum = hslColor.getLuminence();
            lum = lum > 127 ? (lum -= 25) : (lum += 40);
            hslColor.setLuminence(lum);
            this.colorLine = new Color((Device)this.cTable.getDisplay(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
        }
        return this.colorLine;
    }

    private void paintHeader(PaintEvent e) {
        TableColumnCore column;
        int w;
        Color c2;
        Rectangle ca = this.cHeaderArea.getClientArea();
        Color c1 = e.display.getSystemColor(25);
        Color line = c2 = e.display.getSystemColor(22);
        Color fg = e.display.getSystemColor(24);
        Pattern patternUp = new Pattern((Device)e.display, 0.0f, 0.0f, 0.0f, (float)ca.height, c1, c2);
        Pattern patternDown = new Pattern((Device)e.display, 0.0f, (float)(-ca.height), 0.0f, 0.0f, c2, c1);
        e.gc.setForeground(line);
        e.gc.drawLine(0, this.headerHeight - 1, this.clientArea.width, this.headerHeight - 1);
        TableColumnCore[] visibleColumns = this.getVisibleColumns();
        TableColumnCore sortColumn = this.getSortColumn();
        int x = -this.clientArea.x;
        TableColumnCore[] tableColumnCoreArray = visibleColumns;
        int n = tableColumnCoreArray.length;
        for (int i = 0; i < n && (x + (w = (column = tableColumnCoreArray[i]).getWidth()) <= ca.width || (w = ca.width - x) > 16); ++i) {
            boolean isSortColumn = column.equals(sortColumn);
            e.gc.setBackgroundPattern(isSortColumn ? patternDown : patternUp);
            e.gc.fillRectangle(x, 1, w, this.headerHeight - 2);
            e.gc.setForeground(line);
            e.gc.drawLine(x + w - 1, 0, x + w - 1, this.headerHeight - 1);
            e.gc.setForeground(fg);
            int yOfs = 0;
            int wText = w;
            if (isSortColumn) {
                int y1;
                int y2;
                int arrowHeight = 6;
                int arrowY = this.headerHeight / 2 - arrowHeight / 2;
                int arrowHalfW = 4;
                int middle = w - arrowHalfW - 4;
                wText = w - arrowHalfW * 2 - 5;
                if (column.isSortAscending()) {
                    y2 = arrowY;
                    y1 = y2 + arrowHeight;
                } else {
                    y1 = arrowY;
                    y2 = y1 + arrowHeight;
                }
                e.gc.setAntialias(1);
                e.gc.setBackground(fg);
                e.gc.fillPolygon(new int[]{x + middle - arrowHalfW, y1, x + middle + arrowHalfW, y1, x + middle, y2});
            }
            int xOfs = x + 2;
            boolean onlyShowImage = column.showOnlyImage();
            String text = "";
            if (!onlyShowImage) {
                text = MessageText.getString(column.getTitleLanguageKey());
            }
            int style = 0x1000040;
            Image image = null;
            String imageID = column.getIconReference();
            if (imageID != null) {
                image = ImageLoader.getInstance().getImage(imageID);
                if (ImageLoader.isRealImage(image)) {
                    if (onlyShowImage) {
                        text = null;
                        Rectangle imageBounds = image.getBounds();
                        e.gc.drawImage(image, (int)((double)x + (double)w / 2.0 - (double)imageBounds.width / 2.0 + 0.5), this.headerHeight / 2 - imageBounds.height / 2);
                    } else {
                        text = "%0 " + text;
                    }
                } else {
                    image = null;
                }
            }
            if (text != null) {
                GCStringPrinter sp = new GCStringPrinter(e.gc, text, new Rectangle(xOfs, yOfs - 1, wText - 4, this.headerHeight - yOfs + 2), true, false, style);
                if (image != null) {
                    sp.setImages(new Image[]{image});
                }
                sp.calculateMetrics();
                if (sp.isWordCut() || sp.isCutoff()) {
                    Font font = e.gc.getFont();
                    e.gc.setFont(this.fontHeaderSmall);
                    sp.printString();
                    e.gc.setFont(font);
                } else {
                    sp.printString();
                }
            }
            if (imageID != null) {
                ImageLoader.getInstance().releaseImage(imageID);
            }
            x += w;
        }
        e.gc.setBackgroundPattern(patternUp);
        e.gc.fillRectangle(x, 1, this.clientArea.width - x, this.headerHeight - 2);
        patternUp.dispose();
        patternDown.dispose();
        e.gc.setBackgroundPattern(null);
    }

    @Override
    public Image obfusticatedImage(Image image) {
        UISWTViewCore view;
        TableRowPainted[] visibleRows;
        TableColumnCore[] visibleColumns = this.getVisibleColumns();
        for (TableRowPainted row : visibleRows = this.visibleRows.toArray(new TableRowPainted[0])) {
            if (row == null || row.isRowDisposed()) continue;
            for (TableColumnCore tc : visibleColumns) {
                int tableWidth;
                String text;
                TableCellPainted cell;
                if (tc == null || !tc.isObfusticated() || (cell = (TableCellPainted)row.getTableCell(tc.getName())) == null || (text = cell.getObfusticatedText()) == null) continue;
                Rectangle cellBounds = cell.getBoundsOnDisplay();
                Point ptDisplay = this.cTable.getShell().getLocation();
                cellBounds.x -= ptDisplay.x;
                cellBounds.y -= ptDisplay.y;
                Rectangle boundsRaw = cell.getBoundsRaw();
                if (boundsRaw.y + cellBounds.height > this.clientArea.y + this.clientArea.height) {
                    cellBounds.height -= boundsRaw.y + cellBounds.height - (this.clientArea.y + this.clientArea.height);
                }
                if (boundsRaw.x + cellBounds.width > this.clientArea.x + (tableWidth = this.cTable.getClientArea().width)) {
                    cellBounds.width -= boundsRaw.x + cellBounds.width - (this.clientArea.x + tableWidth);
                }
                UIDebugGenerator.obfusticateArea(image, cellBounds, text);
            }
        }
        UISWTViewCore uISWTViewCore = view = this.tvTabsCommon == null ? null : this.tvTabsCommon.getActiveSubView();
        if (view instanceof ObfusticateImage) {
            try {
                ((ObfusticateImage)((Object)view)).obfusticatedImage(image);
            }
            catch (Exception e) {
                Debug.out("Obfuscating " + view, e);
            }
        }
        return image;
    }

    protected TableViewSWTPanelCreator getMainPanelCreator() {
        return this.mainPanelCreator;
    }

    @Override
    public void setMainPanelCreator(TableViewSWTPanelCreator mainPanelCreator) {
        this.mainPanelCreator = mainPanelCreator;
    }

    @Override
    public void setRowDefaultIconSize(Point size) {
        this.setRowDefaultHeight(size.y);
    }

    @Override
    public TableCellCore getTableCell(int x, int y) {
        TableRowSWT row = this.getTableRow(x, y, true);
        if (row == null) {
            return null;
        }
        TableColumnCore column = this.getTableColumnByOffset(x);
        if (column == null) {
            return null;
        }
        return row.getTableCellCore(column.getName());
    }

    @Override
    public Point getTableCellMouseOffset(TableCellSWT tableCell) {
        if (tableCell == null) {
            return null;
        }
        Point pt = this.cTable.getDisplay().getCursorLocation();
        pt = this.cTable.toControl(pt);
        Rectangle bounds = tableCell.getBounds();
        int x = pt.x - bounds.x;
        if (x < 0 || x > bounds.width) {
            return null;
        }
        int y = pt.y - bounds.y;
        if (y < 0 || y > bounds.height) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    public void enableFilterCheck(Text txtFilter, TableViewFilterCheck<Object> filterCheck) {
        TableViewSWTFilter<Object> filter2 = this.getSWTFilter();
        if (filter2 != null) {
            if (filter2.widget != null && !filter2.widget.isDisposed()) {
                filter2.widget.removeKeyListener((KeyListener)this.tvSWTCommon);
                filter2.widget.removeModifyListener(filter2.widgetModifyListener);
            }
        } else {
            filter2 = new TableViewSWTFilter();
            this.filter = filter2;
        }
        filter2.widget = txtFilter;
        if (txtFilter != null) {
            txtFilter.addKeyListener((KeyListener)this.tvSWTCommon);
            filter2.widgetModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TableViewPainted.this.setFilterText(((Text)e.widget).getText());
                }
            };
            txtFilter.addModifyListener(filter2.widgetModifyListener);
            if (txtFilter.getText().length() == 0) {
                txtFilter.setText(filter2.text);
            } else {
                filter2.text = filter2.nextText = txtFilter.getText();
            }
        } else {
            filter2.nextText = "";
            filter2.text = "";
        }
        filter2.checker = filterCheck;
        filter2.checker.filterSet(filter2.text);
        this.refilter();
    }

    @Override
    public Text getFilterControl() {
        TableViewSWTFilter<?> filter2 = this.getSWTFilter();
        return filter2 == null ? null : filter2.widget;
    }

    @Override
    public void disableFilterCheck() {
        TableViewSWTFilter<?> filter2 = this.getSWTFilter();
        if (filter2 == null) {
            return;
        }
        if (filter2.widget != null && !filter2.widget.isDisposed()) {
            filter2.widget.removeKeyListener((KeyListener)this.tvSWTCommon);
            filter2.widget.removeModifyListener(filter2.widgetModifyListener);
        }
        filter2 = null;
    }

    @Override
    public void setFilterText(String s) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.setFilterText(s);
        }
    }

    @Override
    public boolean enableSizeSlider(Composite composite, int min, int max) {
        return false;
    }

    @Override
    public void disableSizeSlider() {
    }

    @Override
    public void addRowPaintListener(TableRowSWTPaintListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.addRowPaintListener(listener);
        }
    }

    @Override
    public void removeRowPaintListener(TableRowSWTPaintListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.removeRowPaintListener(listener);
        }
    }

    @Override
    public void invokePaintListeners(GC gc, TableRowCore row, TableColumnCore column, Rectangle cellArea) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.invokePaintListeners(gc, row, column, cellArea);
        }
    }

    @Override
    public void addRowMouseListener(TableRowMouseListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.addRowMouseListener(listener);
        }
    }

    @Override
    public void removeRowMouseListener(TableRowMouseListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.removeRowMouseListener(listener);
        }
    }

    @Override
    public void invokeRowMouseListener(TableRowMouseEvent event2) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.invokeRowMouseListener(event2);
        }
    }

    @Override
    public TableOrTreeSWT getTableOrTreeSWT() {
        return null;
    }

    @Override
    public void packColumns() {
    }

    @Override
    public void parameterChanged(String parameterName) {
        boolean invalidate;
        boolean bl = invalidate = parameterName == null;
        if (parameterName == null || parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = configMan.getIntParameter("Graphics Update");
        }
        if (parameterName == null || parameterName.equals("ReOrder Delay")) {
            this.reOrderDelay = configMan.getIntParameter("ReOrder Delay");
        }
        if (parameterName == null || parameterName.equals("Table.extendedErase")) {
            this.extendedErase = configMan.getBooleanParameter("Table.extendedErase");
            invalidate = true;
        }
        if (parameterName == null || parameterName.equals("Table.headerHeight")) {
            this.headerHeight = configMan.getIntParameter("Table.headerHeight");
            if (this.headerHeight == 0) {
                this.headerHeight = 27;
            }
            this.setHeaderVisible(this.getHeaderVisible());
        }
        if (parameterName == null || parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    @Override
    public TableRowCore createNewRow(Object object) {
        return new TableRowPainted(null, this, object, true);
    }

    @Override
    public void visibleRowsChanged() {
        this.swt_visibleRowsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_visibleRowsChanged() {
        List<TableRowSWT> newVisibleRows;
        Object rows;
        final ArrayList<TableRowSWT> newlyVisibleRows = new ArrayList<TableRowSWT>();
        final ArrayList<TableRowSWT> rowsStayedVisibleButMoved = new ArrayList<TableRowSWT>();
        if (this.isVisible()) {
            rows = this.getRows();
            newVisibleRows = new ArrayList();
            this.recalculateVisibleRows((TableRowCore[])rows, 0, newVisibleRows, rowsStayedVisibleButMoved);
        } else {
            newVisibleRows = Collections.emptyList();
        }
        final ArrayList<TableRowPainted> nowInVisibleRows = new ArrayList<TableRowPainted>(0);
        rows = this.visibleRows_sync;
        synchronized (rows) {
            if (this.visibleRows != null) {
                nowInVisibleRows.addAll(this.visibleRows);
            }
        }
        rows = new LinkedHashSet(newVisibleRows.size());
        for (TableRowSWT row : newVisibleRows) {
            ((HashSet)rows).add((TableRowPainted)row);
            boolean removed = nowInVisibleRows.remove(row);
            if (removed) continue;
            newlyVisibleRows.add(row);
        }
        Object object = this.visibleRows_sync;
        synchronized (object) {
            this.visibleRows = rows;
        }
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                boolean bTableUpdate = false;
                for (TableRowSWT row : newlyVisibleRows) {
                    row.setShown(true, false);
                    rowsStayedVisibleButMoved.remove(row);
                    if (!Constants.isOSX) continue;
                    bTableUpdate = true;
                }
                for (TableRowSWT row : rowsStayedVisibleButMoved) {
                    row.invalidate();
                    TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                }
                for (TableRowSWT row : nowInVisibleRows) {
                    row.setShown(false, false);
                }
                if (bTableUpdate) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (TableViewPainted.this.cTable != null && !TableViewPainted.this.cTable.isDisposed()) {
                                TableViewPainted.this.cTable.update();
                            }
                        }
                    });
                }
            }
        });
    }

    private void recalculateVisibleRows(TableRowCore[] rows, int yStart, List<TableRowSWT> newVisibleRows, List<TableRowSWT> rowsStayedVisibleButMoved) {
        Rectangle bounds = this.clientArea;
        int y = yStart;
        for (TableRowCore row : rows) {
            if (row == null) continue;
            TableRowPainted rowSWT = (TableRowPainted)row;
            int rowHeight = rowSWT.getHeight();
            int rowFullHeight = rowSWT.getFullHeight();
            if (y < bounds.y + bounds.height && y + rowFullHeight > bounds.y) {
                TableRowCore[] subRowsWithNull;
                boolean offsetChanged = rowSWT.setDrawOffset(new Point(bounds.x, y));
                if (y + rowHeight > bounds.y) {
                    if (offsetChanged) {
                        rowsStayedVisibleButMoved.add(rowSWT);
                    }
                    newVisibleRows.add(rowSWT);
                }
                if (row.isExpanded() && (subRowsWithNull = row.getSubRowsWithNull()).length > 0) {
                    this.recalculateVisibleRows(subRowsWithNull, y + rowHeight, newVisibleRows, rowsStayedVisibleButMoved);
                }
            } else if (newVisibleRows.size() > 0) break;
            y += rowFullHeight;
        }
    }

    @Override
    public int uiGuessMaxVisibleRows() {
        return this.clientArea.height / this.defaultRowHeight + 1;
    }

    @Override
    public void uiRemoveRows(TableRowCore[] rows, Integer[] rowIndexes) {
        int bottomIndex;
        if (this.focusedRow != null) {
            for (TableRowCore row : rows) {
                if (row != this.focusedRow) continue;
                this.setFocusedRow(null);
                break;
            }
        }
        if ((bottomIndex = this.getRowCount() - 1) < 0) {
            this.redrawTable();
        } else {
            TableRowCore rowBottom = this.getLastVisibleRow();
            if (rowBottom != null) {
                while (rowBottom.getParentRowCore() != null) {
                    rowBottom = rowBottom.getParentRowCore();
                }
                if (this.indexOf(rowBottom) < 0) {
                    this.redrawTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableRowPainted getLastVisibleRow() {
        Object object = this.visibleRows_sync;
        synchronized (object) {
            if (this.visibleRows == null || this.visibleRows.size() == 0) {
                return null;
            }
            TableRowPainted rowBottom = null;
            Iterator iterator = this.visibleRows.iterator();
            while (iterator.hasNext()) {
                TableRowPainted row;
                rowBottom = row = (TableRowPainted)iterator.next();
            }
            return rowBottom;
        }
    }

    @Override
    public void getOffUIThread(AERunnable runnable) {
        Utils.getOffOfSWTThread(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swt_calculateClientArea() {
        boolean canvasChanged;
        int oldW;
        boolean changedH;
        boolean changedY;
        boolean changedX;
        TableColumnCore[] visibleColumns;
        if (this.cTable == null || this.cTable.isDisposed()) {
            return;
        }
        Rectangle oldClientArea = this.clientArea;
        Rectangle newClientArea = this.cTable.getClientArea();
        newClientArea.x = this.hBar.getSelection();
        newClientArea.y = this.vBar.getSelection();
        int w = 0;
        for (TableColumnCore column : visibleColumns = this.getVisibleColumns()) {
            w += column.getWidth();
        }
        this.columnsWidth = w;
        w = newClientArea.width = Math.max(newClientArea.width, w);
        boolean refreshTable = false;
        if (oldClientArea != null) {
            changedX = oldClientArea.x != newClientArea.x;
            changedY = oldClientArea.y != newClientArea.y;
            changedH = oldClientArea.height != newClientArea.height;
        } else {
            changedH = true;
            changedY = true;
            changedX = true;
        }
        this.clientArea = newClientArea;
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.xAdj = -this.clientArea.x;
        }
        boolean needRedraw = false;
        if (changedY || changedH) {
            LinkedHashSet<TableRowPainted> visibleRows;
            this.visibleRowsChanged();
            if (changedY && oldClientArea != null && (visibleRows = this.visibleRows).size() > 0 && this.canvasImage != null && !this.canvasImage.isDisposed() && !changedH) {
                int yDiff = oldClientArea.y - newClientArea.y;
                if (Math.abs(yDiff) < this.clientArea.height) {
                    boolean wasIn = this.in_swt_updateCanvasImage;
                    this.in_swt_updateCanvasImage = true;
                    try {
                        Object var20_31;
                        try {
                            GC gc = new GC((Drawable)this.canvasImage);
                            try {
                                Rectangle bounds = this.canvasImage.getBounds();
                                if (yDiff > 0) {
                                    gc.copyArea(0, 0, bounds.width, bounds.height, 0, yDiff, false);
                                    this.swt_paintCanvasImage(gc, new Rectangle(0, 0, 9999, yDiff));
                                    gc.setClipping((Rectangle)null);
                                } else {
                                    gc.copyArea(0, -yDiff, bounds.width, bounds.height, 0, 0, false);
                                    int h = -yDiff;
                                    TableRowPainted row = this.getLastVisibleRow();
                                    if (row != null) {
                                        h += row.getHeight();
                                    }
                                    this.swt_paintCanvasImage(gc, new Rectangle(0, bounds.height - h, 9999, h));
                                    gc.setClipping((Rectangle)null);
                                }
                                Object var18_27 = null;
                            }
                            catch (Throwable throwable) {
                                Object var18_28 = null;
                                gc.dispose();
                                throw throwable;
                            }
                            gc.dispose();
                            var20_31 = null;
                            this.in_swt_updateCanvasImage = wasIn;
                        }
                        catch (Throwable e) {
                            refreshTable = true;
                            var20_31 = null;
                            this.in_swt_updateCanvasImage = wasIn;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_32 = null;
                        this.in_swt_updateCanvasImage = wasIn;
                        throw throwable;
                    }
                    needRedraw = true;
                } else {
                    refreshTable = true;
                }
            }
        }
        if (changedX) {
            this.cHeaderArea.redraw();
        }
        Object newImage = this.canvasImage;
        int h = 0;
        Object wasIn = this.visibleRows_sync;
        synchronized (wasIn) {
            TableRowPainted lastRow = this.getLastVisibleRow();
            if (lastRow != null && (h = lastRow.getDrawOffset().y - this.clientArea.y + lastRow.getHeight()) < this.clientArea.height && lastRow.isExpanded()) {
                TableRowCore[] subRows;
                for (TableRowCore subRow : subRows = lastRow.getSubRowsWithNull()) {
                    TableRowPainted subRowP;
                    if (subRow != null && (h += (subRowP = (TableRowPainted)subRow).getFullHeight()) >= this.clientArea.height) break;
                }
            }
        }
        if (h < this.clientArea.height) {
            h = this.clientArea.height;
        }
        int oldH = this.canvasImage == null || this.canvasImage.isDisposed() ? 0 : this.canvasImage.getBounds().height;
        int n = oldW = this.canvasImage == null || this.canvasImage.isDisposed() ? 0 : this.canvasImage.getBounds().width;
        if (this.canvasImage == null || oldW != w || h > oldH) {
            newImage = h <= 0 || this.clientArea.width <= 0 ? null : new Image((Device)this.shell.getDisplay(), w, h);
        }
        boolean bl = canvasChanged = this.canvasImage != newImage;
        if (canvasChanged) {
            Image oldImage = this.canvasImage;
            this.canvasImage = newImage;
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
        if (changedH || canvasChanged || refreshTable) {
            this.__refreshTable(false);
            if (canvasChanged) {
                this.swt_updateCanvasImage(false);
            }
        }
        if (needRedraw) {
            this.cTable.redraw();
        }
    }

    public void swt_updateCanvasImage(boolean immediateRedraw) {
        if (this.canvasImage != null && !this.canvasImage.isDisposed()) {
            this.swt_updateCanvasImage(this.canvasImage.getBounds(), immediateRedraw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swt_updateCanvasImage(final Rectangle bounds, final boolean immediateRedraw) {
        if (this.in_swt_updateCanvasImage) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    TableViewPainted.this.swt_updateCanvasImage(bounds, immediateRedraw);
                }
            });
            return;
        }
        this.in_swt_updateCanvasImage = true;
        try {
            block11: {
                block10: {
                    if (this.canvasImage == null || this.canvasImage.isDisposed()) break block10;
                    if (bounds != null) break block11;
                }
                Object var5_3 = null;
                this.in_swt_updateCanvasImage = false;
                return;
            }
            GC gc = new GC((Drawable)this.canvasImage);
            this.swt_paintCanvasImage(gc, bounds);
            gc.dispose();
            if (this.cTable != null && !this.cTable.isDisposed()) {
                this.cTable.redraw(bounds.x - this.clientArea.x, bounds.y, bounds.width, bounds.height, false);
                if (immediateRedraw) {
                    this.cTable.update();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.in_swt_updateCanvasImage = false;
            throw throwable;
        }
        Object var5_4 = null;
        this.in_swt_updateCanvasImage = false;
    }

    public Rectangle getClientArea() {
        return this.clientArea;
    }

    @Override
    public boolean isVisible() {
        if (!Utils.isThisThreadSWT()) {
            return this.isVisible;
        }
        boolean wasVisible = this.isVisible;
        boolean bl = this.isVisible = this.cTable != null && !this.cTable.isDisposed() && this.cTable.isVisible() && !this.shell.getMinimized();
        if (this.isVisible != wasVisible) {
            UISWTViewCore view;
            this.visibleRowsChanged();
            UISWTViewCore uISWTViewCore = view = this.tvTabsCommon == null ? null : this.tvTabsCommon.getActiveSubView();
            if (this.isVisible) {
                this.loopFactor = 0;
                if (view != null) {
                    view.triggerEvent(3, null);
                }
            } else if (view != null) {
                view.triggerEvent(4, null);
            }
        }
        return this.isVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllTableRows() {
        super.removeAllTableRows();
        Object object = this.visibleRows_sync;
        synchronized (object) {
            this.visibleRows = new LinkedHashSet();
        }
        this.setFocusedRow(null);
        this.totalHeight = 0;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.cTable == null || TableViewPainted.this.cTable.isDisposed()) {
                    return;
                }
                TableViewPainted.this.swt_fixupSize();
                TableViewPainted.this.swt_updateCanvasImage(false);
            }
        });
    }

    protected void swt_fixupSize() {
        int tableSize;
        int max;
        boolean vBarValid;
        boolean bl = vBarValid = this.vBar != null && !this.vBar.isDisposed();
        if (vBarValid) {
            max = this.totalHeight;
            tableSize = this.clientArea.height;
            if (max < tableSize) {
                this.vBar.setSelection(0);
                this.vBar.setEnabled(false);
                this.vBar.setVisible(false);
            } else {
                if (!this.vBar.isVisible()) {
                    this.vBar.setVisible(true);
                    this.vBar.setEnabled(true);
                }
                if (this.vBar.getMaximum() != max) {
                    this.vBar.setMaximum(max);
                    this.swt_vBarChanged();
                }
                this.vBar.setThumb(tableSize);
                this.vBar.setPageIncrement(tableSize);
            }
        }
        if (this.hBar != null && !this.hBar.isDisposed()) {
            tableSize = this.cTable.getSize().x;
            max = this.columnsWidth;
            if (vBarValid && this.vBar.isVisible() && this.getScrollbarsMode() == 0) {
                int vBarW = this.vBar.getSize().x;
                max += vBarW;
            }
            if (max < tableSize) {
                this.hBar.setSelection(0);
                this.hBar.setEnabled(false);
                this.hBar.setVisible(false);
            } else {
                if (!this.hBar.isVisible()) {
                    this.hBar.setVisible(true);
                    this.hBar.setEnabled(true);
                }
                this.hBar.setValues(this.hBar.getSelection(), 0, max, tableSize, 50, tableSize);
            }
            if (vBarValid && this.hBar.isVisible()) {
                int hBarW = this.getScrollbarsMode() == 0 ? this.hBar.getSize().y : 0;
                this.vBar.setThumb(this.clientArea.height - hBarW);
                this.vBar.setMaximum(this.totalHeight - hBarW);
                this.vBar.setPageIncrement(this.vBar.getPageIncrement() - hBarW);
            }
        }
    }

    private int getScrollbarsMode() {
        if (hasGetScrollBarMode) {
            return this.cTable.getScrollbarsMode();
        }
        return 0;
    }

    @Override
    protected void uiChangeColumnIndicator() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.cHeaderArea != null && !TableViewPainted.this.cHeaderArea.isDisposed()) {
                    TableViewPainted.this.cHeaderArea.redraw();
                }
            }
        });
    }

    @Override
    public TableColumnCore getTableColumnByOffset(int mouseX) {
        TableColumnCore[] visibleColumns;
        int x = -this.clientArea.x;
        for (TableColumnCore column : visibleColumns = this.getVisibleColumns()) {
            int w = column.getWidth();
            if (mouseX >= x && mouseX < x + w) {
                return column;
            }
            x += w;
        }
        return null;
    }

    @Override
    public TableRowSWT getTableRow(int x, int y, boolean anyX) {
        return (TableRowSWT)this.getRow(anyX ? 2 : x, this.clientArea.y + y);
    }

    @Override
    public void setSelectedRows(TableRowCore[] newSelectionArray, boolean trigger) {
        super.setSelectedRows(newSelectionArray, trigger);
        boolean focusInSelection = false;
        for (TableRowCore row : newSelectionArray) {
            if (row == null || !row.equals(this.focusedRow)) continue;
            focusInSelection = true;
            break;
        }
        if (!focusInSelection) {
            this.setFocusedRow(newSelectionArray.length == 0 ? null : newSelectionArray[0]);
        }
    }

    @Override
    public void setRowSelected(TableRowCore row, boolean selected, boolean trigger) {
        if (selected && !this.isSelected(row)) {
            this.setFocusedRow(row);
        }
        super.setRowSelected(row, selected, trigger);
        if (row instanceof TableRowSWT) {
            ((TableRowSWT)row).setWidgetSelected(selected);
        }
    }

    @Override
    public void editCell(TableColumnCore column, int row) {
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public TableViewSWTFilter<?> getSWTFilter() {
        return (TableViewSWTFilter)this.filter;
    }

    @Override
    public void openFilterDialog() {
        if (this.filter == null) {
            return;
        }
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setFilter.title", null, "MyTorrentsView.dialog.setFilter.text", new String[]{MessageText.getString(this.getTableID() + "View" + ".header")});
        entryWindow.setPreenteredText(this.filter.text, false);
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return;
        }
        String message = entryWindow.getSubmittedInput();
        if (message == null) {
            message = "";
        }
        this.setFilterText(message);
    }

    @Override
    public boolean isSingleSelection() {
        return !this.isMultiSelect;
    }

    @Override
    public void expandColumns() {
    }

    @Override
    public void triggerTabViewsDataSourceChanged(boolean sendParent) {
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.triggerTabViewsDataSourceChanged(sendParent);
        }
    }

    @Override
    public TableViewSWT_TabsCommon getTabsCommon() {
        return this.tvTabsCommon;
    }

    @Override
    public void uiSelectionChanged(final TableRowCore[] newlySelectedRows, final TableRowCore[] deselectedRows) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                for (TableRowCore row : deselectedRows) {
                    row.invalidate();
                    TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                }
                for (TableRowCore row : newlySelectedRows) {
                    row.invalidate();
                    TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                }
            }
        });
    }

    @Override
    public void delete() {
        this.triggerLifeCycleListener(1);
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.delete();
            this.tvTabsCommon = null;
        }
        TableStructureEventDispatcher.getInstance(this.tableID).removeListener(this);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager != null) {
            tcManager.saveTableColumns(this.getDataSourceType(), this.tableID);
        }
        Utils.disposeSWTObjects(new Object[]{this.cTable});
        this.cTable = null;
        this.removeAllTableRows();
        configMan.removeParameterListener("ReOrder Delay", this);
        configMan.removeParameterListener("Graphics Update", this);
        configMan.removeParameterListener("Table.extendedErase", this);
        configMan.removeParameterListener("Table.headerHeight", this);
        Colors.getInstance().removeColorsChangedListener(this);
        super.delete();
        MessageText.removeListener(this);
    }

    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.generate(writer);
        }
    }

    private Menu createMenu() {
        if (!this.isMenuEnabled()) {
            return null;
        }
        final Menu menu = new Menu((Decorations)this.shell, 8);
        this.cTable.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.widget == TableViewPainted.this.cHeaderArea) {
                    menu.setData("inBlankArea", (Object)false);
                    menu.setData("isHeader", (Object)true);
                } else {
                    boolean noRow = TableViewPainted.this.getTableRowWithCursor() == null;
                    menu.setData("inBlankArea", (Object)noRow);
                    menu.setData("isHeader", (Object)false);
                }
                Point pt = TableViewPainted.this.cHeaderArea.toControl(event2.x, event2.y);
                menu.setData("column", (Object)TableViewPainted.this.getTableColumnByOffset(pt.x));
            }
        });
        this.cHeaderArea.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                menu.setData("inBlankArea", (Object)false);
                menu.setData("isHeader", (Object)true);
                Point pt = TableViewPainted.this.cHeaderArea.toControl(event2.x, event2.y);
                menu.setData("column", (Object)TableViewPainted.this.getTableColumnByOffset(pt.x));
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                Object oIsHeader = menu.getData("isHeader");
                boolean isHeader = oIsHeader instanceof Boolean ? (Boolean)oIsHeader : false;
                Object oInBlankArea = menu.getData("inBlankArea");
                boolean inBlankArea = oInBlankArea instanceof Boolean ? (Boolean)oInBlankArea : false;
                TableColumnCore column = (TableColumnCore)menu.getData("column");
                if (isHeader) {
                    TableViewPainted.this.tvSWTCommon.fillColumnMenu(menu, column, false);
                } else if (inBlankArea) {
                    TableViewPainted.this.tvSWTCommon.fillColumnMenu(menu, column, true);
                } else {
                    TableViewPainted.this.tvSWTCommon.fillMenu(menu, column);
                }
            }
        });
        return menu;
    }

    @Override
    public void showColumnEditor() {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.showColumnEditor();
        }
    }

    @Override
    public TableRowCore getFocusedRow() {
        return this.focusedRow;
    }

    public void setFocusedRow(TableRowCore row) {
        TableRowPainted oldFocusedRow = this.focusedRow;
        if (!(row instanceof TableRowPainted)) {
            row = null;
        }
        this.focusedRow = (TableRowPainted)row;
        if (this.focusedRow != null) {
            if (this.focusedRow.isVisible() && this.focusedRow.getDrawOffset().y + this.focusedRow.getHeight() <= this.clientArea.y + this.clientArea.height && this.focusedRow.getDrawOffset().y >= this.clientArea.y) {
                this.redrawRow(this.focusedRow, false);
            } else {
                this.showRow(this.focusedRow);
            }
        }
        if (oldFocusedRow != null) {
            this.redrawRow(oldFocusedRow, false);
        }
    }

    @Override
    public void showRow(final TableRowCore rowToShow) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewPainted.this.isDisposed()) {
                    return;
                }
                if (rowToShow.isVisible()) {
                    int y = ((TableRowPainted)rowToShow).getDrawOffset().y;
                    if (y + rowToShow.getHeight() > TableViewPainted.this.clientArea.y + TableViewPainted.this.clientArea.height) {
                        y -= TableViewPainted.this.clientArea.height - rowToShow.getHeight();
                    }
                    TableViewPainted.this.vBar.setSelection(y);
                    TableViewPainted.this.swt_vBarChanged();
                } else {
                    TableRowCore parentFocusedRow = rowToShow;
                    while (parentFocusedRow.getParentRowCore() != null) {
                        parentFocusedRow = parentFocusedRow.getParentRowCore();
                    }
                    TableRowCore[] rows = TableViewPainted.this.getRows();
                    int y = 0;
                    for (TableRowCore row : rows) {
                        if (row == parentFocusedRow) {
                            TableRowCore[] subRowsWithNull;
                            if (parentFocusedRow == rowToShow) break;
                            y += row.getHeight();
                            for (TableRowCore subrow : subRowsWithNull = parentFocusedRow.getSubRowsWithNull()) {
                                if (subrow == rowToShow) break;
                                y += ((TableRowPainted)subrow).getFullHeight();
                            }
                            break;
                        }
                        y += ((TableRowPainted)row).getFullHeight();
                    }
                    if (y + rowToShow.getHeight() > TableViewPainted.this.clientArea.y + TableViewPainted.this.clientArea.height) {
                        y -= TableViewPainted.this.clientArea.height - rowToShow.getHeight();
                    }
                    TableViewPainted.this.vBar.setSelection(y);
                    TableViewPainted.this.swt_vBarChanged();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowHeightChanged(TableRowCore row, int oldHeight, int newHeight) {
        Object object = this.heightChangeSync;
        synchronized (object) {
            this.totalHeight += newHeight - oldHeight;
            if (this.qdRowHeightChanged) {
                return;
            }
            this.qdRowHeightChanged = true;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                Object object = TableViewPainted.this.heightChangeSync;
                synchronized (object) {
                    TableViewPainted.this.qdRowHeightChanged = false;
                }
                TableViewPainted.this.visibleRowsChanged();
                TableViewPainted.this.swt_fixupSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawTable() {
        TableViewPainted tableViewPainted = this;
        synchronized (tableViewPainted) {
            if (this.redrawTableScheduled) {
                return;
            }
            this.redrawTableScheduled = true;
        }
        this.visibleRowsChanged();
        Utils.execSWTThreadLater(0, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                TableViewPainted tableViewPainted = TableViewPainted.this;
                synchronized (tableViewPainted) {
                    TableViewPainted.this.redrawTableScheduled = false;
                }
                if (TableViewPainted.this.canvasImage != null && !TableViewPainted.this.canvasImage.isDisposed()) {
                    TableViewPainted.this.canvasImage.dispose();
                    TableViewPainted.this.canvasImage = null;
                }
                TableViewPainted.this.swt_calculateClientArea();
            }
        });
    }

    private String prettyIndex(TableRowCore row) {
        String s = "" + row.getIndex();
        if (row.getParentRowCore() != null) {
            s = row.getParentRowCore().getIndex() + "." + s;
        }
        return s;
    }

    public void redrawRow(final TableRowPainted row, final boolean immediateRedraw) {
        if (row == null) {
            return;
        }
        if (TableRowPainted.DEBUG_ROW_PAINT) {
            System.out.println(SystemTime.getCurrentTime() + "} redraw " + this.prettyIndex(row) + " scheduled via " + Debug.getCompressedStackTrace());
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Composite composite;
                if (!TableViewPainted.this.isVisible || !row.isVisible()) {
                    return;
                }
                Rectangle bounds = row.getDrawBounds();
                if (TableRowPainted.DEBUG_ROW_PAINT) {
                    System.out.println(SystemTime.getCurrentTime() + "] redraw " + TableViewPainted.this.prettyIndex(row) + " @ " + bounds);
                }
                if (bounds != null && (composite = TableViewPainted.this.getComposite()) != null && !composite.isDisposed()) {
                    int h = TableViewPainted.this.isLastRow(row) ? composite.getSize().y - bounds.y : bounds.height;
                    TableViewPainted.this.swt_updateCanvasImage(new Rectangle(bounds.x, bounds.y, bounds.width, h), immediateRedraw);
                }
            }
        });
    }

    public Object getSyncObject() {
        return this.lock;
    }

    @Override
    public boolean isTableSelected() {
        TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
        return tv == this || tv == null && this.isFocused;
    }

    class RefreshTableRunnable
    extends AERunnable {
        private boolean forceSort;

        RefreshTableRunnable() {
        }

        public void runSupport() {
            TableViewPainted.this.__refreshTable(this.isForceSort());
        }

        public boolean isForceSort() {
            return this.forceSort;
        }

        public void setForceSort(boolean forceSort) {
            this.forceSort = forceSort;
        }
    }
}

