/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRSSFeed;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagFeatureRunState;
import com.aelitis.azureus.core.tag.TagFeatureTranscode;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagUIUtils {
    public static final int MAX_TOP_LEVEL_TAGS_IN_MENU = 20;
    private static final AsyncDispatcher move_dispatcher = new AsyncDispatcher("tag:applytocurrent");

    public static String getChatKey(Tag tag) {
        return "Tag: " + tag.getTagName(true);
    }

    public static void setupSideBarMenus(final MenuManager menuManager) {
        org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar.header.transfers", "ConfigView.section.style.TagInSidebar");
        menuItem.setStyle(2);
        menuItem.addListener(new MenuItemListener(){

            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                boolean b = COConfigurationManager.getBooleanParameter("Library.TagInSideBar");
                COConfigurationManager.setParameter("Library.TagInSideBar", !b);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getBooleanParameter("Library.TagInSideBar"));
            }
        });
        menuItem = menuManager.addMenuItem("sidebar.header.transfers", "label.tags");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                menu.removeAllChildItems();
                final TagType manual_tt = TagManagerFactory.getTagManager().getTagType(3);
                org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, manual_tt.getTagTypeName(false));
                menuItem.setStyle(5);
                menuItem.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                        menu.removeAllChildItems();
                        final List<Tag> all_tags = manual_tt.getTags();
                        ArrayList<String> menu_names = new ArrayList<String>();
                        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
                        boolean all_visible = true;
                        boolean all_invisible = true;
                        boolean has_ut = false;
                        for (Tag t : all_tags) {
                            Boolean bl;
                            TagFeatureProperties props;
                            Object prop;
                            String name = t.getTagName(true);
                            menu_names.add(name);
                            menu_name_map.put(name, t);
                            if (t.isVisible()) {
                                all_invisible = false;
                            } else {
                                all_visible = false;
                            }
                            if ((prop = (props = (TagFeatureProperties)((Object)t)).getProperty("untagged")) == null || (bl = prop.getBoolean()) == null || !bl.booleanValue()) continue;
                            has_ut = true;
                        }
                        org.gudy.azureus2.plugins.ui.menus.MenuItem showAllItem = menuManager.addMenuItem(menu, "label.show.all");
                        showAllItem.setStyle(1);
                        showAllItem.addListener(new MenuItemListener(){

                            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                for (Tag t : all_tags) {
                                    t.setVisible(true);
                                }
                            }
                        });
                        org.gudy.azureus2.plugins.ui.menus.MenuItem hideAllItem = menuManager.addMenuItem(menu, "popup.error.hideall");
                        hideAllItem.setStyle(1);
                        hideAllItem.addListener(new MenuItemListener(){

                            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                for (Tag t : all_tags) {
                                    t.setVisible(false);
                                }
                            }
                        });
                        org.gudy.azureus2.plugins.ui.menus.MenuItem sepItem = menuManager.addMenuItem(menu, "sepm");
                        sepItem.setStyle(4);
                        showAllItem.setEnabled(!all_visible);
                        hideAllItem.setEnabled(!all_invisible);
                        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
                        for (Object e : menu_structure) {
                            org.gudy.azureus2.plugins.ui.menus.MenuItem parent_menu;
                            ArrayList<Object> bucket_tags = new ArrayList<Object>();
                            if (e instanceof String) {
                                parent_menu = menu;
                                bucket_tags.add(menu_name_map.get((String)e));
                            } else {
                                Object[] entry = (Object[])e;
                                List list = (List)entry[1];
                                boolean sub_all_visible = true;
                                boolean sub_some_visible = false;
                                for (String name : list) {
                                    Tag tag = (Tag)menu_name_map.get(name);
                                    if (tag.isVisible()) {
                                        sub_some_visible = true;
                                    } else {
                                        sub_all_visible = false;
                                    }
                                    bucket_tags.add(tag);
                                }
                                String mod = sub_all_visible ? " (*)" : (sub_some_visible ? " (+)" : "");
                                parent_menu = menuManager.addMenuItem(menu, "!" + (String)entry[0] + mod + "!");
                                parent_menu.setStyle(5);
                            }
                            for (final Tag tag : bucket_tags) {
                                org.gudy.azureus2.plugins.ui.menus.MenuItem m = menuManager.addMenuItem(parent_menu, tag.getTagName(false));
                                m.setStyle(2);
                                m.setData(new Boolean(tag.isVisible()));
                                m.addListener(new MenuItemListener(){

                                    public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                        tag.setVisible(!tag.isVisible());
                                    }
                                });
                            }
                        }
                        if (!has_ut) {
                            sepItem = menuManager.addMenuItem(menu, "sepu");
                            sepItem.setStyle(4);
                            org.gudy.azureus2.plugins.ui.menus.MenuItem m = menuManager.addMenuItem(menu, "label.untagged");
                            m.setStyle(1);
                            m.addListener(new MenuItemListener(){

                                public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                    try {
                                        String tag_name = MessageText.getString("label.untagged");
                                        Tag ut_tag = manual_tt.getTag(tag_name, true);
                                        if (ut_tag == null) {
                                            ut_tag = manual_tt.createTag(tag_name, true);
                                        }
                                        TagFeatureProperties tp2 = (TagFeatureProperties)((Object)ut_tag);
                                        tp2.getProperty("untagged").setBoolean(true);
                                    }
                                    catch (TagException e) {
                                        Debug.out(e);
                                    }
                                }
                            });
                        }
                    }
                });
                menuItem = menuManager.addMenuItem(menu, "label.add.tag");
                menuItem.addListener(new MenuItemListener(){

                    public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                        TagUIUtils.createManualTag();
                    }
                });
                org.gudy.azureus2.plugins.ui.menus.MenuItem sepItem = menuManager.addMenuItem(menu, "sep1");
                sepItem.setStyle(4);
                menuItem = menuManager.addMenuItem(menu, "wizard.maketorrent.auto");
                menuItem.setStyle(5);
                menuItem.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                        menu.removeAllChildItems();
                        org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, "label.content");
                        menuItem.setStyle(5);
                        menuItem.addFillListener(new MenuItemFillListener(){

                            public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                                String[] tag_ids;
                                menu.removeAllChildItems();
                                for (String id : tag_ids = new String[]{"tag.type.man.vhdn", "tag.type.man.featcon"}) {
                                    final String c_id = id + ".enabled";
                                    org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, id);
                                    menuItem.setStyle(2);
                                    menuItem.addListener(new MenuItemListener(){

                                        public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                            COConfigurationManager.setParameter(c_id, menu.isSelected());
                                        }
                                    });
                                    menuItem.addFillListener(new MenuItemFillListener(){

                                        public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                                            menu.setData(COConfigurationManager.getBooleanParameter(c_id, true));
                                        }
                                    });
                                }
                            }
                        });
                        List<TagType> tag_types = TagManagerFactory.getTagManager().getTagTypes();
                        for (final TagType tag_type : tag_types) {
                            if (tag_type.getTagType() == 1 || !tag_type.isTagTypeAuto() || tag_type.getTags().size() == 0) continue;
                            menuItem = menuManager.addMenuItem(menu, tag_type.getTagTypeName(false));
                            menuItem.setStyle(5);
                            menuItem.addFillListener(new MenuItemFillListener(){

                                public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                                    menu.removeAllChildItems();
                                    final List<Tag> tags = tag_type.getTags();
                                    org.gudy.azureus2.plugins.ui.menus.MenuItem showAllItem = menuManager.addMenuItem(menu, "label.show.all");
                                    showAllItem.setStyle(1);
                                    showAllItem.addListener(new MenuItemListener(){

                                        public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                            for (Tag t : tags) {
                                                t.setVisible(true);
                                            }
                                        }
                                    });
                                    org.gudy.azureus2.plugins.ui.menus.MenuItem hideAllItem = menuManager.addMenuItem(menu, "popup.error.hideall");
                                    hideAllItem.setStyle(1);
                                    hideAllItem.addListener(new MenuItemListener(){

                                        public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                            for (Tag t : tags) {
                                                t.setVisible(false);
                                            }
                                        }
                                    });
                                    boolean all_visible = true;
                                    boolean all_invisible = true;
                                    for (Tag t : tags) {
                                        if (t.isVisible()) {
                                            all_invisible = false;
                                            continue;
                                        }
                                        all_visible = false;
                                    }
                                    showAllItem.setEnabled(!all_visible);
                                    hideAllItem.setEnabled(!all_invisible);
                                    org.gudy.azureus2.plugins.ui.menus.MenuItem sepItem = menuManager.addMenuItem(menu, "sep2");
                                    sepItem.setStyle(4);
                                    for (final Tag t : tags) {
                                        org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menu, t.getTagName(false));
                                        menuItem.setStyle(2);
                                        menuItem.addListener(new MenuItemListener(){

                                            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                                                t.setVisible(menu.isSelected());
                                            }
                                        });
                                        menuItem.addFillListener(new MenuItemFillListener(){

                                            public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                                                menu.setData(t.isVisible());
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                });
                sepItem = menuManager.addMenuItem(menu, "sep3");
                sepItem.setStyle(4);
                menuItem = menuManager.addMenuItem(menu, "tag.show.stats");
                menuItem.addListener(new MenuItemListener(){

                    public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        uiFunctions.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TagStatsView");
                    }
                });
                menuItem = menuManager.addMenuItem(menu, "tag.show.overview");
                menuItem.addListener(new MenuItemListener(){

                    public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        uiFunctions.openView(14, null);
                    }
                });
            }
        });
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                TagUIUtils.checkTagSharing(true);
            }
        });
    }

    public static void checkTagSharing(boolean start_of_day) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            TagManager tm = TagManagerFactory.getTagManager();
            if (start_of_day) {
                if (COConfigurationManager.getBooleanParameter("tag.sharing.default.checked", false)) {
                    return;
                }
                COConfigurationManager.setParameter("tag.sharing.default.checked", true);
                List<TagType> tag_types = tm.getTagTypes();
                boolean prompt_required = false;
                for (TagType tag_type : tag_types) {
                    List<Tag> tags = tag_type.getTags();
                    for (Tag tag : tags) {
                        if (!tag.isPublic()) continue;
                        prompt_required = true;
                    }
                }
                if (!prompt_required) {
                    return;
                }
            }
            String title = MessageText.getString("tag.sharing.enable.title");
            String text = MessageText.getString("tag.sharing.enable.text");
            UIFunctionsUserPrompter prompter = uiFunctions.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            prompter.setRemember("tag.share.default", true, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean share = prompter.waitUntilClosed() == 0;
            tm.setTagPublicDefault(share);
        }
    }

    public static Tag createManualTag() {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("TagAddWindow.title", "TagAddWindow.message");
        entryWindow.prompt();
        if (entryWindow.hasSubmittedInput()) {
            String tag_name = entryWindow.getSubmittedInput().trim();
            TagType tt = TagManagerFactory.getTagManager().getTagType(3);
            Tag existing = tt.getTag(tag_name, true);
            if (existing == null) {
                try {
                    TagUIUtils.checkTagSharing(false);
                    return tt.createTag(tag_name, true);
                }
                catch (TagException e) {
                    Debug.out(e);
                }
            }
        }
        return null;
    }

    public static void createSideBarMenuItems(final Menu menu, final Tag tag) {
        boolean auto;
        AZ3Functions.provider.TranscodeTarget[] tts;
        AZ3Functions.provider provider2;
        TagFeatureTranscode tf_xcode;
        TagFeatureProperties props;
        MenuItem tps;
        TagFeatureFileLocation fl;
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        final TagType tag_type = tag.getTagType();
        boolean needs_separator_next = false;
        if (tag_type.hasTagTypeFeature(1L)) {
            final TagFeatureRateLimit tf_rate_limit = (TagFeatureRateLimit)((Object)tag);
            boolean has_up = tf_rate_limit.supportsTagUploadLimit();
            boolean has_down = tf_rate_limit.supportsTagDownloadLimit();
            if (has_up || has_down) {
                needs_separator_next = true;
                long maxDownload = (long)COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024L;
                long maxUpload = (long)COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024L;
                int down_speed = tf_rate_limit.getTagDownloadLimit();
                int up_speed = tf_rate_limit.getTagUploadLimit();
                HashMap<String, Object> menu_properties = new HashMap<String, Object>();
                if (tag_type.getTagType() == 4 || tag_type.getTagType() == 3) {
                    if (has_up) {
                        menu_properties.put("enable_upload_disable", true);
                    }
                    if (has_down) {
                        menu_properties.put("enable_download_disable", true);
                    }
                }
                ViewUtils.addSpeedMenu(menu.getShell(), menu, has_up, has_down, true, true, down_speed == -1, down_speed == 0, down_speed, down_speed, maxDownload, up_speed == -1, up_speed == 0, up_speed, up_speed, maxUpload, 1, menu_properties, new ViewUtils.SpeedAdapter(){

                    public void setDownSpeed(int val) {
                        tf_rate_limit.setTagDownloadLimit(val);
                    }

                    public void setUpSpeed(int val) {
                        tf_rate_limit.setTagUploadLimit(val);
                    }
                });
            }
            if (userMode > 0) {
                String existing;
                if (tf_rate_limit.getTagUploadPriority() >= 0) {
                    needs_separator_next = true;
                    final MenuItem upPriority = new MenuItem(menu, 32);
                    upPriority.setSelection(tf_rate_limit.getTagUploadPriority() > 0);
                    Messages.setLanguageText((Widget)upPriority, "cat.upload.priority");
                    upPriority.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            boolean set = upPriority.getSelection();
                            tf_rate_limit.setTagUploadPriority(set ? 1 : 0);
                        }
                    });
                }
                if (tf_rate_limit.getTagMinShareRatio() >= 0) {
                    needs_separator_next = true;
                    MenuItem itemSR = new MenuItem(menu, 8);
                    existing = String.valueOf((float)tf_rate_limit.getTagMinShareRatio() / 1000.0f);
                    Messages.setLanguageText((Widget)itemSR, "menu.min.share.ratio", new String[]{existing});
                    itemSR.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            block8: {
                                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("min.sr.window.title", "min.sr.window.message");
                                entryWindow.setPreenteredText(existing, false);
                                entryWindow.selectPreenteredText(true);
                                entryWindow.prompt();
                                if (entryWindow.hasSubmittedInput()) {
                                    try {
                                        String text = entryWindow.getSubmittedInput().trim();
                                        int sr = 0;
                                        if (text.length() <= 0) break block8;
                                        try {
                                            float f = Float.parseFloat(text);
                                            sr = (int)(f * 1000.0f);
                                            if (sr < 0) {
                                                sr = 0;
                                            } else if (sr == 0 && f > 0.0f) {
                                                sr = 1;
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                        tf_rate_limit.setTagMinShareRatio(sr);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        }
                    });
                }
                if (tf_rate_limit.getTagMaxShareRatio() >= 0) {
                    needs_separator_next = true;
                    MenuItem itemSR = new MenuItem(menu, 8);
                    existing = String.valueOf((float)tf_rate_limit.getTagMaxShareRatio() / 1000.0f);
                    Messages.setLanguageText((Widget)itemSR, "menu.max.share.ratio", new String[]{existing});
                    itemSR.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            block8: {
                                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("max.sr.window.title", "max.sr.window.message");
                                entryWindow.setPreenteredText(existing, false);
                                entryWindow.selectPreenteredText(true);
                                entryWindow.prompt();
                                if (entryWindow.hasSubmittedInput()) {
                                    try {
                                        String text = entryWindow.getSubmittedInput().trim();
                                        int sr = 0;
                                        if (text.length() <= 0) break block8;
                                        try {
                                            float f = Float.parseFloat(text);
                                            sr = (int)(f * 1000.0f);
                                            if (sr < 0) {
                                                sr = 0;
                                            } else if (sr == 0 && f > 0.0f) {
                                                sr = 1;
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                        tf_rate_limit.setTagMaxShareRatio(sr);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }
        if (tag_type.hasTagTypeFeature(4L)) {
            MenuItem itemOp;
            final TagFeatureRunState tf_run_state = (TagFeatureRunState)((Object)tag);
            int caps = tf_run_state.getRunStateCapabilities();
            int[] op_set = new int[]{8, 1, 2, 4};
            boolean[] can_ops_set = tf_run_state.getPerformableOperations(op_set);
            if ((caps & 8) != 0) {
                needs_separator_next = true;
                itemOp = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemOp, "MyTorrentsView.menu.queue");
                Utils.setMenuItemImage(itemOp, "start");
                itemOp.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        tf_run_state.performOperation(8);
                    }
                });
                itemOp.setEnabled(can_ops_set[0]);
            }
            if ((caps & 1) != 0) {
                needs_separator_next = true;
                itemOp = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemOp, "MyTorrentsView.menu.stop");
                Utils.setMenuItemImage(itemOp, "stop");
                itemOp.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        tf_run_state.performOperation(1);
                    }
                });
                itemOp.setEnabled(can_ops_set[1]);
            }
            if ((caps & 2) != 0) {
                needs_separator_next = true;
                itemOp = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemOp, "v3.MainWindow.button.pause");
                Utils.setMenuItemImage(itemOp, "pause");
                itemOp.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        tf_run_state.performOperation(2);
                    }
                });
                itemOp.setEnabled(can_ops_set[2]);
            }
            if ((caps & 4) != 0) {
                needs_separator_next = true;
                itemOp = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemOp, "v3.MainWindow.button.resume");
                Utils.setMenuItemImage(itemOp, "start");
                itemOp.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        tf_run_state.performOperation(4);
                    }
                });
                itemOp.setEnabled(can_ops_set[3]);
            }
        }
        if (tag_type.hasTagTypeFeature(16L) && ((fl = (TagFeatureFileLocation)((Object)tag)).supportsTagInitialSaveFolder() || fl.supportsTagMoveOnComplete() || fl.supportsTagCopyOnComplete())) {
            MenuItem moc_item;
            File existing;
            needs_separator_next = true;
            Menu files_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem files_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)files_item, "ConfigView.section.files");
            files_item.setMenu(files_menu);
            if (fl.supportsTagInitialSaveFolder()) {
                final Menu moc_menu = new Menu((Decorations)files_menu.getShell(), 4);
                MenuItem isl_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)isl_item, "label.init.save.loc");
                isl_item.setMenu(moc_menu);
                MenuItem clear_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagInitialSaveFolder(null);
                    }
                });
                existing = fl.getTagInitialSaveFolder();
                MenuItem apply_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)apply_item, "apply.to.current");
                apply_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TagUIUtils.applyLocationToCurrent(tag, existing);
                    }
                });
                new MenuItem(moc_menu, 2);
                if (existing != null) {
                    MenuItem current_item = new MenuItem(moc_menu, 16);
                    current_item.setSelection(true);
                    current_item.setText(existing.getAbsolutePath());
                    new MenuItem(moc_menu, 2);
                } else {
                    apply_item.setEnabled(false);
                    clear_item.setEnabled(false);
                }
                MenuItem set_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)set_item, "label.set");
                set_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(moc_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagInitialSaveFolder(new File(path));
                        }
                    }
                });
            }
            if (fl.supportsTagMoveOnComplete()) {
                final Menu moc_menu = new Menu((Decorations)files_menu.getShell(), 4);
                moc_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)moc_item, "label.move.on.comp");
                moc_item.setMenu(moc_menu);
                MenuItem clear_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagMoveOnCompleteFolder(null);
                    }
                });
                existing = fl.getTagMoveOnCompleteFolder();
                MenuItem apply_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)apply_item, "apply.to.current");
                apply_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TagUIUtils.applyLocationToCurrent(tag, existing);
                    }
                });
                new MenuItem(moc_menu, 2);
                if (existing != null) {
                    MenuItem current_item = new MenuItem(moc_menu, 16);
                    current_item.setSelection(true);
                    current_item.setText(existing.getAbsolutePath());
                    new MenuItem(moc_menu, 2);
                } else {
                    apply_item.setEnabled(false);
                    clear_item.setEnabled(false);
                }
                MenuItem set_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)set_item, "label.set");
                set_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(moc_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagMoveOnCompleteFolder(new File(path));
                        }
                    }
                });
            }
            if (fl.supportsTagCopyOnComplete()) {
                final Menu moc_menu = new Menu((Decorations)files_menu.getShell(), 4);
                moc_item = new MenuItem(files_menu, 64);
                Messages.setLanguageText((Widget)moc_item, "label.copy.on.comp");
                moc_item.setMenu(moc_menu);
                MenuItem clear_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)clear_item, "Button.clear");
                clear_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        fl.setTagCopyOnCompleteFolder(null);
                    }
                });
                new MenuItem(moc_menu, 2);
                existing = fl.getTagCopyOnCompleteFolder();
                if (existing != null) {
                    MenuItem current_item = new MenuItem(moc_menu, 16);
                    current_item.setSelection(true);
                    current_item.setText(existing.getAbsolutePath());
                    new MenuItem(moc_menu, 2);
                } else {
                    clear_item.setEnabled(false);
                }
                MenuItem set_item = new MenuItem(moc_menu, 64);
                Messages.setLanguageText((Widget)set_item, "label.set");
                set_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DirectoryDialog dd = new DirectoryDialog(moc_menu.getShell());
                        dd.setFilterPath(TorrentOpener.getFilterPathData());
                        dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                        String path = dd.open();
                        if (path != null) {
                            TorrentOpener.setFilterPathData(path);
                            fl.setTagCopyOnCompleteFolder(new File(path));
                        }
                    }
                });
            }
        }
        if (tag instanceof TagDownload) {
            needs_separator_next = true;
            MenuItem itemOptions = new MenuItem(menu, 8);
            final Set<DownloadManager> dms = ((TagDownload)tag).getTaggedDownloads();
            Messages.setLanguageText((Widget)itemOptions, "cat.options");
            itemOptions.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    uiFunctions.openView(6, dms.toArray(new DownloadManager[dms.size()]));
                }
            });
            if (dms.size() == 0) {
                itemOptions.setEnabled(false);
            }
        }
        if (userMode > 0 && tag_type.hasTagTypeFeature(32L) && ((TagFeatureProperties.TagProperty[])(tps = (props = (TagFeatureProperties)((Object)tag)).getSupportedProperties())).length > 0) {
            needs_separator_next = true;
            final Menu props_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem props_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)props_item, "label.properties");
            props_item.setMenu(props_menu);
            for (MenuItem tp2 : tps) {
                Object val;
                if (tp2.getType() == 1) {
                    String def_str;
                    String tp_name = tp2.getName(false);
                    if (tp_name.equals("constraint")) {
                        MenuItem const_item = new MenuItem(props_menu, 8);
                        Messages.setLanguageText((Widget)const_item, "label.contraints");
                        const_item.addListener(13, new Listener((TagFeatureProperties.TagProperty)tp2){
                            final /* synthetic */ TagFeatureProperties.TagProperty val$tp;
                            {
                                this.val$tp = tagProperty;
                            }

                            public void handleEvent(Event event2) {
                                String[] val = this.val$tp.getStringList();
                                String def_val = val != null && val.length > 0 ? val[0] : "";
                                String msg = MessageText.getString("UpdateConstraint.message");
                                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UpdateConstraint.title", "!" + msg + "!");
                                entryWindow.setPreenteredText(def_val, false);
                                entryWindow.selectPreenteredText(true);
                                entryWindow.prompt();
                                if (entryWindow.hasSubmittedInput()) {
                                    try {
                                        String text = entryWindow.getSubmittedInput().trim();
                                        if (text.length() == 0) {
                                            this.val$tp.setStringList(null);
                                        } else {
                                            this.val$tp.setStringList(new String[]{text});
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    if (tp_name.equals("tracker_templates")) {
                        String def_str2;
                        final TrackersUtil tut = TrackersUtil.getInstance();
                        ArrayList<String> templates = new ArrayList<String>(tut.getMultiTrackers().keySet());
                        String str_merge = MessageText.getString("label.merge");
                        String str_replace = MessageText.getString("label.replace");
                        String str_remove = MessageText.getString("Button.remove");
                        String[] val2 = tp2.getStringList();
                        final ArrayList<String> selected = new ArrayList<String>();
                        if (val2 == null || val2.length == 0) {
                            String def_str22 = "";
                        } else {
                            def_str2 = "";
                            for (String v : val2) {
                                String tn;
                                String[] bits = v.split(":");
                                if (bits.length != 2 || !templates.contains(tn = bits[1])) continue;
                                String type = bits[0];
                                tn = type.equals("m") ? tn + ": " + (String)str_merge : (type.equals("r") ? tn + ": " + str_replace : tn + ": " + str_remove);
                                selected.add(v);
                                def_str2 = def_str2 + (def_str2.length() == 0 ? "" : ", ") + tn;
                            }
                        }
                        Collections.sort(templates);
                        Menu ttemp_menu = new Menu((Decorations)menu.getShell(), 4);
                        MenuItem menuItem = new MenuItem(menu, 64);
                        menuItem.setText(MessageText.getString("label.tracker.templates") + (def_str2.length() == 0 ? "" : " (" + def_str2 + ")  "));
                        menuItem.setMenu(ttemp_menu);
                        MenuItem new_item = new MenuItem(ttemp_menu, 8);
                        Messages.setLanguageText((Widget)new_item, "wizard.multitracker.new");
                        new_item.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                ArrayList<List<String>> group = new ArrayList<List<String>>();
                                ArrayList tracker = new ArrayList();
                                group.add(tracker);
                                new MultiTrackerEditor(props_menu.getShell(), null, group, new TrackerEditorListener(){

                                    @Override
                                    public void trackersChanged(String oldName, String newName, List<List<String>> trackers) {
                                        if (trackers != null) {
                                            tut.addMultiTracker(newName, trackers);
                                        }
                                    }
                                });
                            }
                        });
                        MenuItem reapply_item = new MenuItem(ttemp_menu, 8);
                        Messages.setLanguageText((Widget)reapply_item, "label.reapply");
                        reapply_item.addListener(13, new Listener((TagFeatureProperties.TagProperty)tp2){
                            final /* synthetic */ TagFeatureProperties.TagProperty val$tp;
                            {
                                this.val$tp = tagProperty;
                            }

                            public void handleEvent(Event event2) {
                                this.val$tp.syncListeners();
                            }
                        });
                        reapply_item.setEnabled(def_str2.length() > 0);
                        if (templates.size() <= 0) continue;
                        new MenuItem(ttemp_menu, 2);
                        for (final String template_name : templates) {
                            Menu t_menu = new Menu((Decorations)ttemp_menu.getShell(), 4);
                            MenuItem t_item = new MenuItem(ttemp_menu, 64);
                            t_item.setText(template_name);
                            t_item.setMenu(t_menu);
                            boolean r_selected = false;
                            for (int i = 0; i < 3; ++i) {
                                final MenuItem sel_item = new MenuItem(t_menu, 32);
                                final String key = (i == 0 ? "m" : (i == 1 ? "r" : "x")) + ":" + template_name;
                                sel_item.setText((String)(i == 0 ? str_merge : (i == 1 ? str_replace : str_remove)));
                                boolean is_sel = selected.contains(key);
                                r_selected |= is_sel;
                                sel_item.setSelection(is_sel);
                                sel_item.addListener(13, new Listener((TagFeatureProperties.TagProperty)tp2){
                                    final /* synthetic */ TagFeatureProperties.TagProperty val$tp;
                                    {
                                        this.val$tp = tagProperty;
                                    }

                                    public void handleEvent(Event event2) {
                                        if (sel_item.getSelection()) {
                                            selected.add(key);
                                        } else {
                                            selected.remove(key);
                                        }
                                        this.val$tp.setStringList(selected.toArray(new String[selected.size()]));
                                    }
                                });
                            }
                            if (r_selected) {
                                Utils.setMenuItemImage(t_item, "graytick");
                            }
                            new MenuItem(t_menu, 2);
                            MenuItem edit_item = new MenuItem(t_menu, 8);
                            Messages.setLanguageText((Widget)edit_item, "wizard.multitracker.edit");
                            edit_item.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    new MultiTrackerEditor(props_menu.getShell(), template_name, tut.getMultiTrackers().get(template_name), new TrackerEditorListener(){

                                        @Override
                                        public void trackersChanged(String oldName, String newName, List<List<String>> trackers) {
                                            if (oldName != null && !oldName.equals(newName)) {
                                                tut.removeMultiTracker(oldName);
                                            }
                                            tut.addMultiTracker(newName, trackers);
                                        }
                                    });
                                }
                            });
                            MenuItem del_item = new MenuItem(t_menu, 8);
                            Messages.setLanguageText((Widget)del_item, "FileItem.delete");
                            Utils.setMenuItemImage(del_item, "delete");
                            del_item.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{template_name}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                                    mb.open(new UserPrompterResultListener(){

                                        public void prompterClosed(int result) {
                                            if (result == 0) {
                                                tut.removeMultiTracker(template_name);
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        continue;
                    }
                    val = tp2.getStringList();
                    if (val == null || ((String[])val).length == 0) {
                        def_str = "";
                    } else {
                        def_str = "";
                        for (Object v : val) {
                            def_str = def_str + (def_str.length() == 0 ? "" : ", ") + (String)v;
                        }
                    }
                    MenuItem set_item = new MenuItem(props_menu, 8);
                    set_item.setText(tp2.getName(true) + (def_str.length() == 0 ? "" : " (" + def_str + ") ") + "...");
                    String f_def_str = def_str;
                    set_item.addListener(13, new Listener((TagFeatureProperties.TagProperty)tp2, f_def_str){
                        final /* synthetic */ TagFeatureProperties.TagProperty val$tp;
                        final /* synthetic */ String val$f_def_str;
                        {
                            this.val$tp = tagProperty;
                            this.val$f_def_str = string;
                        }

                        public void handleEvent(Event event2) {
                            String msg = MessageText.getString("UpdateProperty.list.message", new String[]{this.val$tp.getName(true)});
                            SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UpdateProperty.title", "!" + msg + "!");
                            entryWindow.setPreenteredText(this.val$f_def_str, false);
                            entryWindow.selectPreenteredText(true);
                            entryWindow.prompt();
                            if (entryWindow.hasSubmittedInput()) {
                                try {
                                    String text = entryWindow.getSubmittedInput().trim();
                                    if (text.length() == 0) {
                                        this.val$tp.setStringList(null);
                                    } else {
                                        text = text.replace(';', ',');
                                        text = text.replace(' ', ',');
                                        text = text.replaceAll("[,]+", ",");
                                        String[] bits = text.split(",");
                                        ArrayList<String> vals = new ArrayList<String>();
                                        for (String bit : bits) {
                                            if ((bit = bit.trim()).length() <= 0) continue;
                                            vals.add(bit);
                                        }
                                        if (vals.size() == 0) {
                                            this.val$tp.setStringList(null);
                                        } else {
                                            this.val$tp.setStringList(vals.toArray(new String[vals.size()]));
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                    continue;
                }
                if (tp2.getType() == 2) {
                    MenuItem set_item = new MenuItem(props_menu, 32);
                    set_item.setText(tp2.getName(true));
                    val = tp2.getBoolean();
                    set_item.setSelection(val != null && ((Boolean)val).booleanValue());
                    set_item.addListener(13, new Listener((TagFeatureProperties.TagProperty)tp2, set_item){
                        final /* synthetic */ TagFeatureProperties.TagProperty val$tp;
                        final /* synthetic */ MenuItem val$set_item;
                        {
                            this.val$tp = tagProperty;
                            this.val$set_item = menuItem;
                        }

                        public void handleEvent(Event event2) {
                            this.val$tp.setBoolean(this.val$set_item.getSelection());
                        }
                    });
                    continue;
                }
                Debug.out("Unknown property");
            }
        }
        if (needs_separator_next) {
            new MenuItem(menu, 2);
            needs_separator_next = false;
        }
        if (tag.canBePublic()) {
            needs_separator_next = true;
            final MenuItem itemPublic = new MenuItem(menu, 32);
            itemPublic.setSelection(tag.isPublic());
            Messages.setLanguageText((Widget)itemPublic, "tag.share");
            itemPublic.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tag.setPublic(itemPublic.getSelection());
                }
            });
        }
        PluginInterface bpi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(BuddyPlugin.class);
        if (tag_type.getTagType() == 3 && bpi != null) {
            BuddyPlugin buddy_plugin;
            Boolean is_ut;
            TagFeatureProperties props2 = (TagFeatureProperties)((Object)tag);
            TagFeatureProperties.TagProperty tp3 = props2.getProperty("untagged");
            Boolean bl = is_ut = tp3 == null ? null : tp3.getBoolean();
            if ((is_ut == null || !is_ut.booleanValue()) && (buddy_plugin = (BuddyPlugin)bpi.getPlugin()).isClassicEnabled()) {
                Menu share_menu = new Menu((Decorations)menu.getShell(), 4);
                MenuItem share_item = new MenuItem(menu, 64);
                Messages.setLanguageText((Widget)share_item, "azbuddy.ui.menu.cat.share");
                share_item.setText(share_item.getText() + "  ");
                share_item.setMenu(share_menu);
                List<BuddyPluginBuddy> buddies = buddy_plugin.getBuddies();
                if (buddies.size() == 0) {
                    MenuItem item = new MenuItem(share_menu, 32);
                    item.setText(MessageText.getString("general.add.friends"));
                    item.setEnabled(false);
                } else {
                    final String tag_name = tag.getTagName(true);
                    final boolean is_public = buddy_plugin.isPublicTagOrCategory(tag_name);
                    MenuItem itemPubCat = new MenuItem(share_menu, 32);
                    Messages.setLanguageText((Widget)itemPubCat, "general.all.friends");
                    itemPubCat.setSelection(is_public);
                    itemPubCat.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            if (is_public) {
                                buddy_plugin.removePublicTagOrCategory(tag_name);
                            } else {
                                buddy_plugin.addPublicTagOrCategory(tag_name);
                            }
                        }
                    });
                    new MenuItem(share_menu, 2);
                    for (final BuddyPluginBuddy buddy : buddies) {
                        if (buddy.getNickName() == null) continue;
                        final boolean auth = buddy.isLocalRSSTagOrCategoryAuthorised(tag_name);
                        MenuItem itemShare = new MenuItem(share_menu, 32);
                        itemShare.setText(buddy.getName());
                        itemShare.setSelection(auth || is_public);
                        if (is_public) {
                            itemShare.setEnabled(false);
                        }
                        itemShare.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                if (auth) {
                                    buddy.removeLocalAuthorisedRSSTagOrCategory(tag_name);
                                } else {
                                    buddy.addLocalAuthorisedRSSTagOrCategory(tag_name);
                                }
                            }
                        });
                    }
                }
            }
        }
        if (tag_type.hasTagTypeFeature(2L)) {
            final TagFeatureRSSFeed tfrss = (TagFeatureRSSFeed)((Object)tag);
            final MenuItem rssOption = new MenuItem(menu, 32);
            rssOption.setSelection(tfrss.isTagRSSFeedEnabled());
            Messages.setLanguageText((Widget)rssOption, "cat.rss.gen");
            rssOption.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    boolean set = rssOption.getSelection();
                    tfrss.setTagRSSFeedEnabled(set);
                }
            });
        }
        if (tag_type.hasTagTypeFeature(8L) && (tf_xcode = (TagFeatureTranscode)((Object)tag)).supportsTagTranscode() && (provider2 = AZ3Functions.getProvider()) != null && (tts = provider2.getTranscodeTargets()).length > 0) {
            Menu t_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem t_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)t_item, "cat.autoxcode");
            t_item.setMenu(t_menu);
            String[] existing = tf_xcode.getTagTranscodeTarget();
            for (final AZ3Functions.provider.TranscodeTarget tt : tts) {
                boolean selected;
                MenuItem profiles = tt.getProfiles();
                if (((AZ3Functions.provider.TranscodeProfile[])profiles).length <= 0) continue;
                Menu tt_menu = new Menu((Decorations)t_menu.getShell(), 4);
                MenuItem tt_item = new MenuItem(t_menu, 64);
                tt_item.setText(tt.getName());
                tt_item.setMenu(tt_menu);
                for (final AZ3Functions.provider.TranscodeProfile tp4 : profiles) {
                    boolean selected2;
                    final MenuItem menuItem = new MenuItem(tt_menu, 32);
                    menuItem.setText(tp4.getName());
                    boolean bl = selected2 = existing != null && existing[0].equals(tp4.getUID());
                    if (selected2) {
                        Utils.setMenuItemImage(tt_item, "graytick");
                    }
                    menuItem.setSelection(selected2);
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            String name = tt.getName() + " - " + tp4.getName();
                            if (menuItem.getSelection()) {
                                tf_xcode.setTagTranscodeTarget(tp4.getUID(), name);
                            } else {
                                tf_xcode.setTagTranscodeTarget(null, null);
                            }
                        }
                    });
                }
                new MenuItem(tt_menu, 2);
                final MenuItem no_xcode_item = new MenuItem(tt_menu, 32);
                final String never_str = MessageText.getString("v3.menu.device.defaultprofile.never");
                no_xcode_item.setText(never_str);
                final String never_uid = tt.getID() + "/blank";
                boolean bl = selected = existing != null && existing[0].equals(never_uid);
                if (selected) {
                    Utils.setMenuItemImage(tt_item, "graytick");
                }
                no_xcode_item.setSelection(selected);
                no_xcode_item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        String name = tt.getName() + " - " + never_str;
                        if (no_xcode_item.getSelection()) {
                            tf_xcode.setTagTranscodeTarget(never_uid, name);
                        } else {
                            tf_xcode.setTagTranscodeTarget(null, null);
                        }
                    }
                });
            }
        }
        needs_separator_next = true;
        if (tag_type.getTagType() == 3) {
            MenuBuildUtils.addChatMenu(menu, "label.chat", TagUIUtils.getChatKey(tag));
        }
        MenuItem itemShowStats = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemShowStats, "tag.show.stats");
        itemShowStats.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                uiFunctions.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TagStatsView");
            }
        });
        if (needs_separator_next) {
            new MenuItem(menu, 2);
            needs_separator_next = false;
        }
        boolean closable = auto = tag_type.isTagTypeAuto();
        if (tag.getTaggableTypes() == 2) {
            closable = true;
        }
        Menu menuShowHide = null;
        if (closable) {
            final List<Tag> tags = tag_type.getTags();
            int visible_count = 0;
            int invisible_count = 0;
            for (Tag t : tags) {
                if (t.isVisible()) {
                    ++visible_count;
                    continue;
                }
                ++invisible_count;
            }
            menuShowHide = new Menu((Decorations)menu.getShell(), 4);
            MenuItem showhideitem = new MenuItem(menu, 64);
            showhideitem.setText(MessageText.getString("label.showhide.tag"));
            showhideitem.setMenu(menuShowHide);
            MenuItem title = new MenuItem(menuShowHide, 8);
            title.setText("[" + tag_type.getTagTypeName(true) + "]");
            title.setEnabled(false);
            new MenuItem(menuShowHide, 2);
            if (invisible_count > 0) {
                MenuItem showAll = new MenuItem(menuShowHide, 8);
                Messages.setLanguageText((Widget)showAll, "label.show.all");
                showAll.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        for (Tag t : tags) {
                            if (t.isVisible()) continue;
                            t.setVisible(true);
                        }
                    }
                });
                needs_separator_next = true;
            }
            if (visible_count > 0) {
                MenuItem hideAll = new MenuItem(menuShowHide, 8);
                Messages.setLanguageText((Widget)hideAll, "popup.error.hideall");
                hideAll.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        for (Tag t : tags) {
                            if (!t.isVisible()) continue;
                            t.setVisible(false);
                        }
                    }
                });
                needs_separator_next = true;
            }
            if (tags.size() > 0) {
                if (needs_separator_next) {
                    new MenuItem(menuShowHide, 2);
                    needs_separator_next = false;
                }
                ArrayList<String> menu_names = new ArrayList<String>();
                IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
                for (Tag t : tags) {
                    String name = t.getTagName(true);
                    menu_names.add(name);
                    menu_name_map.put(name, t);
                }
                List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
                for (Object obj : menu_structure) {
                    Menu parent_menu;
                    ArrayList<Object> bucket_tags = new ArrayList<Object>();
                    if (obj instanceof String) {
                        parent_menu = menuShowHide;
                        bucket_tags.add(menu_name_map.get((String)obj));
                    } else {
                        Object[] entry = (Object[])obj;
                        List list = (List)entry[1];
                        boolean sub_all_visible = true;
                        boolean sub_some_visible = false;
                        for (String name : list) {
                            Tag sub_tag = (Tag)menu_name_map.get(name);
                            if (sub_tag.isVisible()) {
                                sub_some_visible = true;
                            } else {
                                sub_all_visible = false;
                            }
                            bucket_tags.add(sub_tag);
                        }
                        String mod = sub_all_visible ? " (*)" : (sub_some_visible ? " (+)" : "");
                        Menu menu_bucket = new Menu((Decorations)menuShowHide.getShell(), 4);
                        MenuItem bucket_item = new MenuItem(menuShowHide, 64);
                        bucket_item.setText((String)entry[0] + mod);
                        bucket_item.setMenu(menu_bucket);
                        parent_menu = menu_bucket;
                    }
                    for (final Tag tag2 : bucket_tags) {
                        MenuItem showTag = new MenuItem(parent_menu, 32);
                        showTag.setSelection(tag2.isVisible());
                        Messages.setLanguageText((Widget)showTag, tag2.getTagName(false));
                        showTag.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                tag2.setVisible(!tag2.isVisible());
                            }
                        });
                    }
                }
            }
            showhideitem.setEnabled(true);
        }
        if (!auto) {
            if (tag_type.hasTagTypeFeature(32L)) {
                boolean has_ut;
                TagFeatureProperties props3 = (TagFeatureProperties)((Object)tag);
                boolean bl = has_ut = props3.getProperty("untagged") != null;
                if (has_ut) {
                    has_ut = false;
                    for (Tag t : tag_type.getTags()) {
                        Boolean b;
                        props3 = (TagFeatureProperties)((Object)t);
                        TagFeatureProperties.TagProperty prop = props3.getProperty("untagged");
                        if (prop == null || (b = prop.getBoolean()) == null || !b.booleanValue()) continue;
                        has_ut = true;
                        break;
                    }
                    if (!has_ut) {
                        if (menuShowHide == null) {
                            menuShowHide = new Menu((Decorations)menu.getShell(), 4);
                            MenuItem showhideitem = new MenuItem(menu, 64);
                            showhideitem.setText(MessageText.getString("label.showhide.tag"));
                            showhideitem.setMenu(menuShowHide);
                        } else {
                            new MenuItem(menuShowHide, 2);
                        }
                        MenuItem showAll = new MenuItem(menuShowHide, 8);
                        Messages.setLanguageText((Widget)showAll, "label.untagged");
                        showAll.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                try {
                                    String tag_name = MessageText.getString("label.untagged");
                                    Tag ut_tag = tag_type.getTag(tag_name, true);
                                    if (ut_tag == null) {
                                        ut_tag = tag_type.createTag(tag_name, true);
                                    }
                                    TagFeatureProperties tp2 = (TagFeatureProperties)((Object)ut_tag);
                                    tp2.getProperty("untagged").setBoolean(true);
                                }
                                catch (TagException e) {
                                    Debug.out(e);
                                }
                            }
                        });
                    }
                }
            }
            MenuItem item_create = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)item_create, "label.add.tag");
            item_create.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TagUIUtils.createManualTag();
                }
            });
            MenuItem itemSetColor = new MenuItem(menu, 8);
            itemSetColor.setText(MessageText.getString("label.color") + "...");
            itemSetColor.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int[] existing = tag.getColor();
                    RGB e_rg = existing == null ? null : new RGB(existing[0], existing[1], existing[2]);
                    RGB rgb = Utils.showColorDialog(menu.getShell(), e_rg);
                    if (rgb != null) {
                        tag.setColor(new int[]{rgb.red, rgb.green, rgb.blue});
                    }
                }
            });
            MenuItem itemGroup = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemGroup, "MyTorrentsView.menu.group");
            itemGroup.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("TagGroupWindow.title", "TagGroupWindow.message");
                    String group = tag.getGroup();
                    if (group == null) {
                        group = "";
                    }
                    entryWindow.setPreenteredText(group, false);
                    entryWindow.selectPreenteredText(true);
                    entryWindow.prompt();
                    if (entryWindow.hasSubmittedInput()) {
                        try {
                            group = entryWindow.getSubmittedInput().trim();
                            if (group.length() == 0) {
                                group = null;
                            }
                            tag.setGroup(group);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
            MenuItem itemRename = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemRename, "MyTorrentsView.menu.rename");
            itemRename.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("TagRenameWindow.title", "TagRenameWindow.message");
                    entryWindow.setPreenteredText(tag.getTagName(true), false);
                    entryWindow.selectPreenteredText(true);
                    entryWindow.prompt();
                    if (entryWindow.hasSubmittedInput()) {
                        try {
                            tag.setTagName(entryWindow.getSubmittedInput().trim());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
            MenuItem itemDelete = new MenuItem(menu, 8);
            Utils.setMenuItemImage(itemDelete, "delete");
            Messages.setLanguageText((Widget)itemDelete, "FileItem.delete");
            itemDelete.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    tag.removeTag();
                }
            });
        }
    }

    public static void createSideBarMenuItems(Menu menu, List<Tag> _tags) {
        final ArrayList<Tag> tags = new ArrayList<Tag>(_tags);
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            if (tag.getTagType().getTagType() == 3) continue;
            it.remove();
        }
        if (tags.size() == 0) {
            return;
        }
        MenuItem itemGroup = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemGroup, "MyTorrentsView.menu.group");
        itemGroup.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("TagGroupWindow.title", "TagGroupWindow.message");
                String group = "";
                entryWindow.setPreenteredText(group, false);
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt();
                if (entryWindow.hasSubmittedInput()) {
                    try {
                        group = entryWindow.getSubmittedInput().trim();
                        if (group.length() == 0) {
                            group = null;
                        }
                        for (Tag tag : tags) {
                            tag.setGroup(group);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    private static void applyLocationToCurrent(final Tag tag, final File location) {
        move_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                Set<DownloadManager> downloads = ((TagDownload)tag).getTaggedDownloads();
                for (DownloadManager download : downloads) {
                    try {
                        download.moveDataFilesLive(location);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void addLibraryViewTagsSubMenu(final DownloadManager[] dms, Menu menu_tags, Composite composite) {
        List<Tag> manual_t;
        MenuItem[] items;
        for (MenuItem item : items = menu_tags.getItems()) {
            item.dispose();
        }
        TagManager tm = TagManagerFactory.getTagManager();
        HashMap<TagType, ArrayList<Tag>> auto_map = new HashMap<TagType, ArrayList<Tag>>();
        TagType manual_tt = tm.getTagType(3);
        HashMap<Tag, Integer> manual_map = new HashMap<Tag, Integer>();
        for (DownloadManager downloadManager : dms) {
            List<Tag> tags = tm.getTagsForTaggable(downloadManager);
            for (Tag t : tags) {
                TagType tt = t.getTagType();
                if (tt == manual_tt) {
                    Integer i = (Integer)manual_map.get(t);
                    manual_map.put(t, i == null ? 1 : i + 1);
                    continue;
                }
                if (!tt.isTagTypeAuto()) continue;
                ArrayList<Tag> x = (ArrayList<Tag>)auto_map.get(tt);
                if (x == null) {
                    x = new ArrayList<Tag>();
                    auto_map.put(tt, x);
                }
                x.add(t);
            }
        }
        if (auto_map.size() > 0) {
            Menu menuAuto = new Menu((Decorations)menu_tags.getShell(), 4);
            MenuItem autoItem = new MenuItem(menu_tags, 64);
            Messages.setLanguageText((Widget)autoItem, "wizard.maketorrent.auto");
            autoItem.setMenu(menuAuto);
            List<TagType> auto_tags = TagUIUtils.sortTagTypes(auto_map.keySet());
            for (TagType tt : auto_tags) {
                Object t;
                MenuItem tt_i = new MenuItem(menuAuto, Constants.isOSX ? 32 : 8);
                String tt_str = tt.getTagTypeName(true) + ": ";
                List<Tag> tags = (List<Tag>)auto_map.get(tt);
                HashMap<Object, Integer> tag_counts = new HashMap<Object, Integer>();
                Iterator iterator = tags.iterator();
                while (iterator.hasNext()) {
                    Integer i = (Integer)tag_counts.get(t = (Tag)iterator.next());
                    tag_counts.put(t, i == null ? 1 : i + 1);
                }
                tags = TagUIUtils.sortTags(tag_counts.keySet());
                boolean bl = false;
                t = tags.iterator();
                while (t.hasNext()) {
                    void var17_28;
                    Tag t2 = (Tag)t.next();
                    tt_str = tt_str + (var17_28 == false ? "" : ", ") + t2.getTagName(true);
                    ++var17_28;
                    if (dms.length <= 1) continue;
                    tt_str = tt_str + " (" + tag_counts.get(t2) + ")";
                }
                tt_i.setText(tt_str);
                if (Constants.isOSX) {
                    tt_i.setSelection(true);
                    continue;
                }
                Utils.setMenuItemImage(tt_i, "graytick");
            }
        }
        if ((manual_t = manual_tt.getTags()).size() > 0) {
            if (auto_map.size() > 0) {
                new MenuItem(menu_tags, 2);
            }
            ArrayList<String> menu_names = new ArrayList<String>();
            IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
            for (Tag t : manual_t) {
                if (t.isTagAuto()) continue;
                String name = t.getTagName(true);
                menu_names.add(name);
                menu_name_map.put(name, t);
            }
            List<Object> list = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
            for (Object obj : list) {
                Menu parent_menu;
                ArrayList<Object> bucket_tags = new ArrayList<Object>();
                if (obj instanceof String) {
                    parent_menu = menu_tags;
                    bucket_tags.add(menu_name_map.get((String)obj));
                } else {
                    Object[] entry = (Object[])obj;
                    List list2 = (List)entry[1];
                    boolean sub_all_selected = true;
                    boolean sub_some_selected = false;
                    for (String name : list2) {
                        Tag sub_tag = (Tag)menu_name_map.get(name);
                        Integer c = (Integer)manual_map.get(sub_tag);
                        if (c != null && c == dms.length) {
                            sub_some_selected = true;
                        } else {
                            sub_all_selected = false;
                        }
                        bucket_tags.add(sub_tag);
                    }
                    String mod = sub_all_selected ? " (*)" : (sub_some_selected ? " (+)" : "");
                    Menu menu_bucket = new Menu((Decorations)menu_tags.getShell(), 4);
                    MenuItem bucket_item = new MenuItem(menu_tags, 64);
                    bucket_item.setText((String)entry[0] + mod);
                    bucket_item.setMenu(menu_bucket);
                    parent_menu = menu_bucket;
                }
                for (final Tag tag : bucket_tags) {
                    final MenuItem t_i = new MenuItem(parent_menu, 32);
                    String tag_name = tag.getTagName(true);
                    Integer c = (Integer)manual_map.get(tag);
                    if (c != null) {
                        if (c == dms.length) {
                            t_i.setSelection(true);
                            t_i.setText(tag_name);
                        } else {
                            t_i.setText(tag_name + " (" + c + ")");
                        }
                    } else {
                        t_i.setText(tag_name);
                    }
                    t_i.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            boolean selected = t_i.getSelection();
                            for (DownloadManager dm : dms) {
                                if (selected) {
                                    tag.addTaggable(dm);
                                    continue;
                                }
                                tag.removeTaggable(dm);
                            }
                        }
                    });
                }
            }
        }
        new MenuItem(menu_tags, 2);
        MenuItem item_create = new MenuItem(menu_tags, 8);
        Messages.setLanguageText((Widget)item_create, "label.add.tag");
        item_create.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Tag new_tag = TagUIUtils.createManualTag();
                if (new_tag != null) {
                    for (DownloadManager dm : dms) {
                        new_tag.addTaggable(dm);
                    }
                    COConfigurationManager.setParameter("Library.TagInSideBar", true);
                }
            }
        });
    }

    public static List<TagType> sortTagTypes(Collection<TagType> _tag_types) {
        ArrayList<TagType> tag_types = new ArrayList<TagType>(_tag_types);
        Collections.sort(tag_types, new Comparator<TagType>(){
            final Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(TagType o1, TagType o2) {
                return this.comp.compare(o1.getTagTypeName(true), o2.getTagTypeName(true));
            }
        });
        return tag_types;
    }

    public static List<Tag> sortTags(Collection<Tag> _tags) {
        ArrayList<Tag> tags = new ArrayList<Tag>(_tags);
        Collections.sort(tags, TagUIUtils.getTagComparator());
        return tags;
    }

    public static Comparator<Tag> getTagComparator() {
        return new Comparator<Tag>(){
            final Comparator<String> comp = new FormattersImpl().getAlphanumericComparator(true);

            @Override
            public int compare(Tag o1, Tag o2) {
                String g2;
                String g1 = o1.getGroup();
                if (g1 != (g2 = o2.getGroup())) {
                    if (g1 == null) {
                        return 1;
                    }
                    if (g2 == null) {
                        return -1;
                    }
                    int res = this.comp.compare(g1, g2);
                    if (res != 0) {
                        return res;
                    }
                }
                return this.comp.compare(o1.getTagName(true), o2.getTagName(true));
            }
        };
    }

    public static String getTagTooltip(Tag tag) {
        return TagUIUtils.getTagTooltip(tag, false);
    }

    public static String getTagTooltip(Tag tag, boolean skip_name) {
        String str;
        TagType tag_type = tag.getTagType();
        String string = str = skip_name ? "" : tag_type.getTagTypeName(true) + ": " + tag.getTagName(true);
        if (tag_type.hasTagTypeFeature(1L)) {
            int up_pri;
            int current_down;
            int limit_down;
            int current_up;
            TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
            String up_str = "";
            String down_str = "";
            int limit_up = rl.getTagUploadLimit();
            if (limit_up > 0) {
                up_str = up_str + MessageText.getString("label.limit") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(limit_up);
            }
            if ((current_up = rl.getTagCurrentUploadRate()) >= 0) {
                up_str = up_str + (up_str.length() == 0 ? "" : ", ") + MessageText.getString("label.current") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(current_up);
            }
            if ((limit_down = rl.getTagDownloadLimit()) > 0) {
                down_str = down_str + MessageText.getString("label.limit") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(limit_down);
            }
            if ((current_down = rl.getTagCurrentDownloadRate()) >= 0) {
                down_str = down_str + (down_str.length() == 0 ? "" : ", ") + MessageText.getString("label.current") + "=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(current_down);
            }
            if (up_str.length() > 0) {
                str = str + "\r\n    " + MessageText.getString("iconBar.up") + ": " + up_str;
            }
            if (down_str.length() > 0) {
                str = str + "\r\n    " + MessageText.getString("iconBar.down") + ": " + down_str;
            }
            if ((up_pri = rl.getTagUploadPriority()) > 0) {
                str = str + "\r\n    " + MessageText.getString("cat.upload.priority");
            }
        }
        if (tag_type.hasTagTypeFeature(16L)) {
            File copy_on_comp;
            File move_on_comp;
            File init_loc;
            TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
            if (fl.supportsTagInitialSaveFolder() && (init_loc = fl.getTagInitialSaveFolder()) != null) {
                str = str + "\r\n    " + MessageText.getString("label.init.save.loc") + "=" + init_loc.getAbsolutePath();
            }
            if (fl.supportsTagMoveOnComplete() && (move_on_comp = fl.getTagMoveOnCompleteFolder()) != null) {
                str = str + "\r\n    " + MessageText.getString("label.move.on.comp") + "=" + move_on_comp.getAbsolutePath();
            }
            if (fl.supportsTagCopyOnComplete() && (copy_on_comp = fl.getTagCopyOnCompleteFolder()) != null) {
                str = str + "\r\n    " + MessageText.getString("label.copy.on.comp") + "=" + copy_on_comp.getAbsolutePath();
            }
        }
        if (str.startsWith("\r\n")) {
            str = str.substring(2);
        }
        return str;
    }
}

