/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.control.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.control.impl.DHTControlContactImpl;
import com.aelitis.azureus.core.dht.control.impl.DHTControlStatsImpl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBFactory;
import com.aelitis.azureus.core.dht.db.DHTDBLookupResult;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.DHTRouterFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTControlImpl
implements DHTControl,
DHTTransportRequestHandler {
    private static final boolean DISABLE_REPLICATE_ON_JOIN = true;
    public static int EXTERNAL_LOOKUP_CONCURRENCY = 16;
    private static final int EXTERNAL_PUT_CONCURRENCY = 8;
    private static final int EXTERNAL_SLEEPING_PUT_CONCURRENCY = 4;
    private static final int RANDOM_QUERY_PERIOD = 300000;
    private static final int INTEGRATION_TIME_MAX = 15000;
    private DHTControlAdapter adapter;
    private DHTTransport transport;
    private DHTTransportContact local_contact;
    private DHTRouter router;
    private DHTDB database;
    private DHTControlStatsImpl stats;
    private DHTLogger logger;
    private int node_id_byte_count;
    private int search_concurrency;
    private int lookup_concurrency;
    private int cache_at_closest_n;
    private int K;
    private int B;
    private int max_rep_per_node;
    private final boolean encode_keys;
    private final boolean enable_random_poking;
    private long router_start_time;
    private int router_count;
    private ThreadPool internal_lookup_pool;
    private ThreadPool external_lookup_pool;
    private ThreadPool internal_put_pool;
    private ThreadPool external_put_pool;
    private Map imported_state = new HashMap();
    private volatile boolean seeded;
    private long last_lookup;
    private ListenerManager<DHTControlListener> listeners = ListenerManager.createAsyncManager("DHTControl:listenDispatcher", new ListenerManagerDispatcher<DHTControlListener>(){

        @Override
        public void dispatch(DHTControlListener listener, int type, Object value) {
            listener.activityChanged((DHTControlActivity)value, type);
        }
    });
    private List activities = new ArrayList();
    private AEMonitor activity_mon = new AEMonitor("DHTControl:activities");
    protected AEMonitor estimate_mon = new AEMonitor("DHTControl:estimate");
    private long last_dht_estimate_time;
    private long local_dht_estimate;
    private long combined_dht_estimate;
    private int combined_dht_estimate_mag;
    private static final int LOCAL_ESTIMATE_HISTORY = 32;
    private Map local_estimate_values = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private static final int REMOTE_ESTIMATE_HISTORY = 128;
    private List remote_estimate_values = new LinkedList();
    protected AEMonitor spoof_mon = new AEMonitor("DHTControl:spoof");
    MessageDigest spoof_digest;
    byte[] spoof_key;
    private static final int SPOOF_GEN_HISTORY_SIZE = 256;
    private Map<InetAddress, Integer> spoof_gen_history = new LinkedHashMap<InetAddress, Integer>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetAddress, Integer> eldest) {
            return this.size() > 256;
        }
    };
    private Map<HashWrapper, byte[]> spoof_gen_history2 = new LinkedHashMap<HashWrapper, byte[]>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashWrapper, byte[]> eldest) {
            return this.size() > 256;
        }
    };
    private static final int SPOOF_ID2_SIZE = 8;
    private long last_node_add_check;
    private byte[] node_add_check_uninteresting_limit;
    private long rbs_time;
    private byte[] rbs_id = new byte[0];
    private boolean sleeping;
    private boolean suspended;
    private volatile boolean destroyed;

    public DHTControlImpl(DHTControlAdapter _adapter, DHTTransport _transport, int _K, int _B, int _max_rep_per_node, int _search_concurrency, int _lookup_concurrency, int _original_republish_interval, int _cache_republish_interval, int _cache_at_closest_n, boolean _encode_keys, boolean _enable_random_poking, DHTLogger _logger) {
        this.adapter = _adapter;
        this.transport = _transport;
        this.logger = _logger;
        this.K = _K;
        this.B = _B;
        this.max_rep_per_node = _max_rep_per_node;
        this.search_concurrency = _search_concurrency;
        this.lookup_concurrency = _lookup_concurrency;
        this.cache_at_closest_n = _cache_at_closest_n;
        this.encode_keys = _encode_keys;
        this.enable_random_poking = _enable_random_poking;
        this.last_dht_estimate_time = SystemTime.getCurrentTime();
        this.database = DHTDBFactory.create(this.adapter.getStorageAdapter(), _original_republish_interval, _cache_republish_interval, this.transport.getProtocolVersion(), this.logger);
        this.internal_lookup_pool = new ThreadPool("DHTControl:internallookups", this.lookup_concurrency);
        this.internal_put_pool = new ThreadPool("DHTControl:internalputs", this.lookup_concurrency);
        this.external_lookup_pool = new ThreadPool("DHTControl:externallookups", EXTERNAL_LOOKUP_CONCURRENCY, true);
        this.external_put_pool = new ThreadPool("DHTControl:puts", 8, true);
        this.createRouter(this.transport.getLocalContact());
        this.node_id_byte_count = this.router.getID().length;
        this.stats = new DHTControlStatsImpl(this);
        if (this.transport.supportsStorage()) {
            try {
                this.spoof_digest = MessageDigest.getInstance("MD5");
                this.spoof_key = new byte[16];
                RandomUtils.nextSecureBytes(this.spoof_key);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.logger.log(e);
            }
        }
        this.transport.setRequestHandler(this);
        this.transport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact new_local_contact) {
                DHTTransportContact t_contact;
                DHTRouterContact contact;
                int i;
                DHTControlImpl.this.logger.log("Transport ID changed, recreating router");
                List<DHTRouterContact> old_contacts = DHTControlImpl.this.router.findBestContacts(0);
                byte[] old_router_id = DHTControlImpl.this.router.getID();
                DHTControlImpl.this.createRouter(new_local_contact);
                Set<DHTTransportContact> sorted_contacts = new sortedTransportContactSet(DHTControlImpl.this.router.getID(), true).getSet();
                for (i = 0; i < old_contacts.size(); ++i) {
                    contact = old_contacts.get(i);
                    if (Arrays.equals(old_router_id, contact.getID()) || !contact.isAlive()) continue;
                    t_contact = ((DHTControlContact)((Object)contact.getAttachment())).getTransportContact();
                    sorted_contacts.add(t_contact);
                }
                for (i = 0; sorted_contacts.size() < 32 && i < old_contacts.size(); ++i) {
                    contact = old_contacts.get(i);
                    if (Arrays.equals(old_router_id, contact.getID()) || contact.isAlive()) continue;
                    t_contact = ((DHTControlContact)((Object)contact.getAttachment())).getTransportContact();
                    sorted_contacts.add(t_contact);
                }
                Iterator<DHTTransportContact> it = sorted_contacts.iterator();
                for (int added = 0; it.hasNext() && added < 128; ++added) {
                    DHTTransportContact contact2 = it.next();
                    DHTControlImpl.this.router.contactAlive(contact2.getID(), new DHTControlContactImpl(contact2));
                }
                DHTControlImpl.this.seed(false);
            }

            public void resetNetworkPositions() {
                List<DHTRouterContact> contacts = DHTControlImpl.this.router.getAllContacts();
                for (int i = 0; i < contacts.size(); ++i) {
                    DHTRouterContact rc = contacts.get(i);
                    if (DHTControlImpl.this.router.isID(rc.getID())) continue;
                    ((DHTControlContact)((Object)rc.getAttachment())).getTransportContact().createNetworkPositions(false);
                }
            }

            public void currentAddress(String address) {
            }

            public void reachabilityChanged(boolean reacheable) {
            }
        });
    }

    public DHTControlImpl(DHTControlAdapter _adapter, DHTTransport _transport, DHTRouter _router, DHTDB _database, int _K, int _B, int _max_rep_per_node, int _search_concurrency, int _lookup_concurrency, int _original_republish_interval, int _cache_republish_interval, int _cache_at_closest_n, boolean _encode_keys, boolean _enable_random_poking, DHTLogger _logger) {
        this.adapter = _adapter;
        this.transport = _transport;
        this.logger = _logger;
        this.K = _K;
        this.B = _B;
        this.max_rep_per_node = _max_rep_per_node;
        this.search_concurrency = _search_concurrency;
        this.lookup_concurrency = _lookup_concurrency;
        this.cache_at_closest_n = _cache_at_closest_n;
        this.encode_keys = _encode_keys;
        this.enable_random_poking = _enable_random_poking;
        this.last_dht_estimate_time = SystemTime.getCurrentTime();
        this.database = _database;
        this.internal_lookup_pool = new ThreadPool("DHTControl:internallookups", this.lookup_concurrency);
        this.internal_put_pool = new ThreadPool("DHTControl:internalputs", this.lookup_concurrency);
        this.external_lookup_pool = new ThreadPool("DHTControl:externallookups", EXTERNAL_LOOKUP_CONCURRENCY, true);
        this.external_put_pool = new ThreadPool("DHTControl:puts", 8, true);
        this.router = _router;
        this.local_contact = this.transport.getLocalContact();
        this.database.setControl(this);
        this.node_id_byte_count = this.router.getID().length;
        this.stats = new DHTControlStatsImpl(this);
        if (this.transport.supportsStorage()) {
            try {
                this.spoof_digest = MessageDigest.getInstance("MD5");
                this.spoof_key = new byte[16];
                RandomUtils.nextSecureBytes(this.spoof_key);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.logger.log(e);
            }
        }
        this.transport.setRequestHandler(this);
    }

    protected void createRouter(DHTTransportContact _local_contact) {
        this.router_start_time = SystemTime.getCurrentTime();
        ++this.router_count;
        this.local_contact = _local_contact;
        if (this.router != null) {
            this.router.destroy();
        }
        this.router = DHTRouterFactory.create(this.K, this.B, this.max_rep_per_node, this.local_contact.getID(), new DHTControlContactImpl(this.local_contact), this.logger);
        this.router.setSleeping(this.sleeping);
        if (this.suspended) {
            this.router.setSuspended(true);
        }
        this.router.setAdapter(new DHTRouterAdapter(){

            public void requestPing(DHTRouterContact contact) {
                DHTControlImpl.this.requestPing(contact);
            }

            public void requestLookup(byte[] id, String description) {
                DHTControlImpl.this.lookup(DHTControlImpl.this.internal_lookup_pool, false, id, description, (short)0, false, 300000L, DHTControlImpl.this.search_concurrency, 1, DHTControlImpl.this.router.getK() / 2, new lookupResultHandler(new DHTOperationAdapter()){

                    public void diversify(DHTTransportContact cause, byte diversification_type) {
                    }

                    public void closest(List res) {
                    }
                });
            }

            public void requestAdd(DHTRouterContact contact) {
                DHTControlImpl.this.nodeAddedToRouter(contact);
            }
        });
        this.database.setControl(this);
    }

    public long getRouterUptime() {
        long now = SystemTime.getCurrentTime();
        if (now < this.router_start_time) {
            this.router_start_time = now;
        }
        return now - this.router_start_time;
    }

    public int getRouterCount() {
        return this.router_count;
    }

    @Override
    public void setSleeping(boolean asleep) {
        if (asleep != this.sleeping) {
            this.logger.log("Sleep mode changed to " + asleep);
        }
        this.sleeping = asleep;
        DHTRouter current_router = this.router;
        if (current_router != null) {
            current_router.setSleeping(asleep);
        }
        this.transport.setGenericFlag((byte)1, asleep);
        if (asleep) {
            this.external_put_pool.setMaxThreads(4);
        } else {
            this.external_put_pool.setMaxThreads(8);
        }
        this.database.setSleeping(asleep);
    }

    @Override
    public void setSuspended(boolean susp) {
        this.suspended = susp;
        if (susp) {
            this.transport.setSuspended(true);
            DHTRouter current_router = this.router;
            if (current_router != null) {
                current_router.setSuspended(true);
            }
            this.database.setSuspended(true);
        } else {
            this.database.setSuspended(false);
            DHTRouter current_router = this.router;
            if (current_router != null) {
                current_router.setSuspended(false);
            }
            this.transport.setSuspended(false);
        }
    }

    @Override
    public DHTControlStats getStats() {
        return this.stats;
    }

    @Override
    public DHTTransport getTransport() {
        return this.transport;
    }

    @Override
    public DHTRouter getRouter() {
        return this.router;
    }

    @Override
    public DHTDB getDataBase() {
        return this.database;
    }

    @Override
    public void contactImported(DHTTransportContact contact, boolean is_bootstrap) {
        this.router.contactKnown(contact.getID(), new DHTControlContactImpl(contact), is_bootstrap);
    }

    @Override
    public void contactRemoved(DHTTransportContact contact) {
        if (!this.router.isID(contact.getID())) {
            this.router.contactDead(contact.getID(), true);
        }
    }

    @Override
    public void exportState(DataOutputStream daos, int max) throws IOException {
        DHTRouterContact contact;
        int i;
        List<DHTRouterContact> contacts = this.router.findBestContacts(0);
        ArrayList<DHTRouterContact> to_save = new ArrayList<DHTRouterContact>();
        ArrayList<DHTRouterContact> reserves = new ArrayList<DHTRouterContact>();
        for (i = 0; i < contacts.size(); ++i) {
            contact = contacts.get(i);
            Object[] imported = (Object[])this.imported_state.get(new HashWrapper(contact.getID()));
            if (imported == null) continue;
            if (contact.isAlive()) {
                to_save.add(contact);
                continue;
            }
            if (contact.isFailing()) continue;
            reserves.add(contact);
        }
        for (i = 0; i < contacts.size(); ++i) {
            contact = contacts.get(i);
            if (!contact.isAlive() || to_save.contains(contact)) continue;
            to_save.add(contact);
        }
        for (i = 0; i < reserves.size(); ++i) {
            contact = (DHTRouterContact)reserves.get(i);
            if (to_save.contains(contact)) continue;
            to_save.add(contact);
        }
        for (i = 0; i < contacts.size(); ++i) {
            contact = contacts.get(i);
            if (to_save.contains(contact)) continue;
            to_save.add(contact);
        }
        Iterator it = to_save.iterator();
        while (it.hasNext()) {
            contact = (DHTRouterContact)it.next();
            DHTTransportContact t_contact = ((DHTControlContact)((Object)contact.getAttachment())).getTransportContact();
            if (t_contact.isValid()) continue;
            it.remove();
        }
        int num_to_write = Math.min(max, to_save.size());
        daos.writeInt(num_to_write);
        for (int i2 = 0; i2 < num_to_write; ++i2) {
            DHTRouterContact contact2 = (DHTRouterContact)to_save.get(i2);
            daos.writeLong(contact2.getTimeAlive());
            DHTTransportContact t_contact = ((DHTControlContact)((Object)contact2.getAttachment())).getTransportContact();
            try {
                t_contact.exportContact(daos);
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        }
        daos.flush();
    }

    @Override
    public void importState(DataInputStream dais) throws IOException {
        int num = dais.readInt();
        for (int i = 0; i < num; ++i) {
            try {
                long time_alive = dais.readLong();
                DHTTransportContact contact = this.transport.importContact(dais, false);
                this.imported_state.put(new HashWrapper(contact.getID()), new Object[]{new Long(time_alive), contact});
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void seed(final boolean full_wait) {
        long remaining;
        final AESemaphore sem = new AESemaphore("DHTControl:seed");
        this.lookup(this.internal_lookup_pool, false, this.router.getID(), "Seeding DHT", (short)0, false, 0L, this.search_concurrency * 4, 1, this.router.getK(), new lookupResultHandler(new DHTOperationAdapter()){

            public void diversify(DHTTransportContact cause, byte diversification_type) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closest(List res) {
                if (!full_wait) {
                    sem.release();
                }
                DHTControlImpl.this.seeded = true;
                try {
                    DHTControlImpl.this.router.seed();
                    Object var3_2 = null;
                    if (full_wait) {
                        sem.release();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (full_wait) {
                        sem.release();
                    }
                    throw throwable;
                }
            }
        });
        long start = SystemTime.getCurrentTime();
        sem.reserve(15000L);
        long now = SystemTime.getCurrentTime();
        if (now < start) {
            start = now;
        }
        if ((remaining = 15000L - (now - start)) > 500L && !full_wait) {
            this.logger.log("Initial integration completed, waiting " + remaining + " ms for second phase to start");
            try {
                Thread.sleep(remaining);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public boolean isSeeded() {
        return this.seeded;
    }

    @Override
    public void setSeeded() {
        this.seeded = true;
        this.router.seed();
    }

    protected void poke() {
        if (!this.enable_random_poking) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.last_lookup || now - this.last_lookup > 300000L) {
            this.last_lookup = now;
            this.external_lookup_pool.run(new DhtTask(this.external_lookup_pool){
                private byte[] target;
                {
                    this.target = new byte[0];
                }

                public void runSupport() {
                    this.target = DHTControlImpl.this.router.refreshRandom();
                }

                protected void cancel() {
                }

                public byte[] getTarget() {
                    return this.target;
                }

                public DHTControlActivity.ActivityState getCurrentState() {
                    return null;
                }

                public String getDescription() {
                    return "Random Query";
                }
            });
        }
    }

    @Override
    public void put(byte[] _unencoded_key, String _description, byte[] _value, short _flags, byte _life_hours, byte _replication_control, boolean _high_priority, DHTOperationListener _listener) {
        if (_value.length == 0) {
            throw new RuntimeException("zero length values not supported");
        }
        byte[] encoded_key = this.encodeKey(_unencoded_key);
        if (DHTLog.isOn()) {
            DHTLog.log("put for " + DHTLog.getString(encoded_key));
        }
        DHTDBValue value = this.database.store(new HashWrapper(encoded_key), _value, _flags, _life_hours, _replication_control);
        this.put(this.external_put_pool, _high_priority, encoded_key, _description, value, _flags, 0L, true, new HashSet(), 1, _listener instanceof DHTOperationListenerDemuxer ? (DHTOperationListenerDemuxer)_listener : new DHTOperationListenerDemuxer(_listener));
    }

    @Override
    public void putEncodedKey(byte[] encoded_key, String description, DHTTransportValue value, long timeout, boolean original_mappings) {
        this.put(this.internal_put_pool, false, encoded_key, description, value, (short)0, timeout, original_mappings, new HashSet(), 1, new DHTOperationListenerDemuxer(new DHTOperationAdapter()));
    }

    protected void put(ThreadPool thread_pool, boolean high_priority, byte[] initial_encoded_key, String description, DHTTransportValue value, short flags, long timeout, boolean original_mappings, Set things_written, int put_level, DHTOperationListenerDemuxer listener) {
        this.put(thread_pool, high_priority, initial_encoded_key, description, new DHTTransportValue[]{value}, flags, timeout, original_mappings, things_written, put_level, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(final ThreadPool thread_pool, final boolean high_priority, byte[] initial_encoded_key, String description, final DHTTransportValue[] values, final short flags, final long timeout, boolean original_mappings, final Set things_written, final int put_level, final DHTOperationListenerDemuxer listener) {
        byte[][] encoded_keys = this.adapter.diversify(description, null, true, true, initial_encoded_key, (byte)1, original_mappings, this.getMaxDivDepth());
        if (encoded_keys.length == 0) {
            listener.diversified("Over-diversification of [" + description + "]");
            listener.complete(false);
            return;
        }
        for (int i = 0; i < encoded_keys.length; ++i) {
            final byte[] encoded_key = encoded_keys[i];
            HashWrapper hw = new HashWrapper(encoded_key);
            Set set = things_written;
            synchronized (set) {
                if (things_written.contains(hw)) {
                    continue;
                }
                things_written.add(hw);
            }
            final String this_description = Arrays.equals(encoded_key, initial_encoded_key) ? description : "Diversification of [" + description + "]";
            this.lookup(thread_pool, high_priority, encoded_key, this_description, (short)(flags | 0x100), false, timeout, this.search_concurrency, 1, this.router.getK(), new lookupResultHandler(listener){

                public void diversify(DHTTransportContact cause, byte diversification_type) {
                    Debug.out("Shouldn't get a diversify on a lookup-node");
                }

                public void closest(List _closest) {
                    DHTControlImpl.this.put(thread_pool, high_priority, new byte[][]{encoded_key}, "Store of [" + this_description + "]", new DHTTransportValue[][]{values}, flags, _closest, timeout, listener, true, things_written, put_level, false);
                }
            });
        }
    }

    public void putDirectEncodedKeys(byte[][] encoded_keys, String description, DHTTransportValue[][] value_sets, List contacts) {
        this.put(this.internal_put_pool, false, encoded_keys, description, value_sets, (short)0, contacts, 0L, new DHTOperationListenerDemuxer(new DHTOperationAdapter()), false, new HashSet(), 1, false);
    }

    @Override
    public void putDirectEncodedKeys(byte[][] encoded_keys, String description, DHTTransportValue[][] value_sets, DHTTransportContact contact, DHTOperationListener listener) {
        ArrayList<DHTTransportContact> contacts = new ArrayList<DHTTransportContact>(1);
        contacts.add(contact);
        this.put(this.internal_put_pool, false, encoded_keys, description, value_sets, (short)0, contacts, 0L, new DHTOperationListenerDemuxer(listener), false, new HashSet(), 1, false);
    }

    @Override
    public byte[] getObfuscatedKey(byte[] plain_key) {
        int length = plain_key.length;
        byte[] obs_key = new byte[length];
        System.arraycopy(plain_key, 0, obs_key, 0, 5);
        for (int i = 6; i < length; ++i) {
            if (plain_key[i] != 0) continue;
            obs_key[i] = 1;
        }
        obs_key[length - 2] = plain_key[length - 2];
        obs_key[length - 1] = plain_key[length - 1];
        return obs_key;
    }

    protected byte[] getObfuscatedValue(byte[] plain_key) {
        RC4Engine engine = new RC4Engine();
        KeyParameter params = new KeyParameter(new SHA1Simple().calculateHash(plain_key));
        engine.init(true, params);
        byte[] temp = new byte[1024];
        engine.processBytes(temp, 0, 1024, temp, 0);
        byte[] obs_value = new byte[plain_key.length];
        engine.processBytes(plain_key, 0, plain_key.length, obs_value, 0);
        return obs_value;
    }

    protected DHTTransportValue getObfuscatedValue(final DHTTransportValue basis, byte[] plain_key) {
        final byte[] obs_value = this.getObfuscatedValue(plain_key);
        return new DHTTransportValue(){

            public boolean isLocal() {
                return basis.isLocal();
            }

            public long getCreationTime() {
                return basis.getCreationTime();
            }

            public byte[] getValue() {
                return obs_value;
            }

            public int getVersion() {
                return basis.getVersion();
            }

            public DHTTransportContact getOriginator() {
                return basis.getOriginator();
            }

            public int getFlags() {
                return basis.getFlags();
            }

            public int getLifeTimeHours() {
                return basis.getLifeTimeHours();
            }

            public byte getReplicationControl() {
                return basis.getReplicationControl();
            }

            public byte getReplicationFactor() {
                return basis.getReplicationFactor();
            }

            public byte getReplicationFrequencyHours() {
                return basis.getReplicationFrequencyHours();
            }

            public String getString() {
                return "obs: " + basis.getString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(final ThreadPool thread_pool, final boolean high_priority, byte[][] initial_encoded_keys, final String description, DHTTransportValue[][] initial_value_sets, final short flags, List contacts, final long timeout, final DHTOperationListenerDemuxer listener, final boolean consider_diversification, final Set things_written, final int put_level, boolean immediate) {
        DHTTransportValue[][] obs_vals;
        Object obs_keys;
        DHTTransportValue[][] value_sets;
        int max_depth = this.getMaxDivDepth();
        if (put_level > max_depth) {
            Debug.out("Put level exceeded, terminating diversification (level=" + put_level + ",max=" + max_depth + ")");
            listener.incrementCompletes();
            listener.complete(false);
            return;
        }
        boolean[] ok = new boolean[initial_encoded_keys.length];
        int failed = 0;
        for (int i = 0; i < initial_encoded_keys.length; ++i) {
            ok[i] = !this.database.isKeyBlocked(initial_encoded_keys[i]);
            if (ok[i]) continue;
            ++failed;
        }
        if (failed == ok.length) {
            listener.incrementCompletes();
            listener.complete(false);
            return;
        }
        final byte[][] encoded_keys = failed == 0 ? initial_encoded_keys : (byte[][])new byte[ok.length - failed][];
        Object object = value_sets = failed == 0 ? initial_value_sets : new DHTTransportValue[ok.length - failed][];
        if (failed > 0) {
            int pos = 0;
            for (int i = 0; i < ok.length; ++i) {
                if (!ok[i]) continue;
                encoded_keys[pos] = initial_encoded_keys[i];
                value_sets[pos] = initial_value_sets[i];
                ++pos;
            }
        }
        if ((flags & 0x80) != 0) {
            if (encoded_keys.length != 1) {
                Debug.out("inconsistent - expected one key");
            }
            if (value_sets[0].length != 1) {
                Debug.out("inconsistent - expected one value");
            }
            obs_keys = new byte[1][];
            obs_vals = new DHTTransportValue[1][1];
            obs_keys[0] = this.getObfuscatedKey(encoded_keys[0]);
            obs_vals[0][0] = this.getObfuscatedValue(value_sets[0][0], encoded_keys[0]);
        } else {
            obs_keys = null;
            obs_vals = null;
        }
        final boolean[] diversified = new boolean[encoded_keys.length];
        int skipped = 0;
        for (int i = 0; i < contacts.size(); ++i) {
            DHTTransportContact contact = (DHTTransportContact)contacts.get(i);
            if (this.router.isID(contact.getID())) {
                ++skipped;
                continue;
            }
            boolean skip_this = false;
            Set set = things_written;
            synchronized (set) {
                if (things_written.contains(contact)) {
                    ++skipped;
                    skip_this = true;
                } else {
                    things_written.add(contact);
                }
            }
            if (skip_this) continue;
            try {
                for (int j = 0; j < value_sets.length; ++j) {
                    for (int k = 0; k < value_sets[j].length; ++k) {
                        listener.wrote(contact, value_sets[j][k]);
                    }
                }
                listener.incrementCompletes();
                contact.sendStore(new DHTTransportReplyHandlerAdapter((byte[][])obs_keys, contact, obs_vals, immediate){
                    final /* synthetic */ byte[][] val$obs_keys;
                    final /* synthetic */ DHTTransportContact val$contact;
                    final /* synthetic */ DHTTransportValue[][] val$obs_vals;
                    final /* synthetic */ boolean val$immediate;
                    {
                        this.val$obs_keys = byArray2;
                        this.val$contact = dHTTransportContact;
                        this.val$obs_vals = dHTTransportValueArray2;
                        this.val$immediate = bl3;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void storeReply(DHTTransportContact _contact, byte[] _diversifications) {
                        boolean complete_is_async = false;
                        try {
                            if (DHTLog.isOn()) {
                                DHTLog.log("Store OK " + DHTLog.getString(_contact));
                            }
                            DHTControlImpl.this.router.contactAlive(_contact.getID(), new DHTControlContactImpl(_contact));
                            boolean div_done = false;
                            if (consider_diversification && _diversifications != null) {
                                for (int j = 0; j < _diversifications.length; ++j) {
                                    if (_diversifications[j] == 1 || diversified[j]) continue;
                                    div_done = true;
                                    diversified[j] = true;
                                    byte[][] diversified_keys = DHTControlImpl.this.adapter.diversify(description, _contact, true, false, encoded_keys[j], _diversifications[j], false, DHTControlImpl.this.getMaxDivDepth());
                                    DHTControlImpl.this.logDiversification(_contact, encoded_keys, diversified_keys);
                                    for (int k = 0; k < diversified_keys.length; ++k) {
                                        DHTControlImpl.this.put(thread_pool, high_priority, diversified_keys[k], "Diversification of [" + description + "]", value_sets[j], flags, timeout, false, things_written, put_level + 1, listener);
                                    }
                                }
                            }
                            if (!div_done && this.val$obs_keys != null) {
                                this.val$contact.sendStore(new DHTTransportReplyHandlerAdapter(){

                                    public void storeReply(DHTTransportContact _contact, byte[] _diversifications) {
                                        if (DHTLog.isOn()) {
                                            DHTLog.log("Obs store OK " + DHTLog.getString(_contact));
                                        }
                                        listener.complete(false);
                                    }

                                    public void failed(DHTTransportContact _contact, Throwable _error) {
                                        if (DHTLog.isOn()) {
                                            DHTLog.log("Obs store failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                                        }
                                        listener.complete(true);
                                    }
                                }, this.val$obs_keys, this.val$obs_vals, this.val$immediate);
                                complete_is_async = true;
                            }
                            Object var9_8 = null;
                            if (!complete_is_async) {
                                listener.complete(false);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (!complete_is_async) {
                                listener.complete(false);
                            }
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact _contact, Throwable _error) {
                        try {
                            if (DHTLog.isOn()) {
                                DHTLog.log("Store failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            }
                            DHTControlImpl.this.router.contactDead(_contact.getID(), false);
                            Object var4_3 = null;
                            listener.complete(true);
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            listener.complete(true);
                            throw throwable;
                        }
                    }

                    public void keyBlockRequest(DHTTransportContact contact, byte[] request2, byte[] key_signature) {
                        DHTStorageBlock key_block = DHTControlImpl.this.database.keyBlockRequest(null, request2, key_signature);
                        if (key_block != null) {
                            for (int i = 0; i < encoded_keys.length; ++i) {
                                if (!Arrays.equals(encoded_keys[i], key_block.getKey())) continue;
                                byte[] dummy = new byte[encoded_keys[i].length];
                                RandomUtils.nextBytes(dummy);
                                encoded_keys[i] = dummy;
                            }
                        }
                    }
                }, encoded_keys, value_sets, immediate);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (skipped == contacts.size()) {
            listener.incrementCompletes();
            listener.complete(false);
        }
    }

    protected int getMaxDivDepth() {
        if (this.combined_dht_estimate == 0L) {
            this.getEstimatedDHTSize();
        }
        int max = Math.max(2, this.combined_dht_estimate_mag);
        return max;
    }

    protected void logDiversification(DHTTransportContact contact, byte[][] keys, byte[][] div) {
    }

    @Override
    public DHTTransportValue getLocalValue(byte[] unencoded_key) {
        DHTDBValue res;
        byte[] encoded_key = this.encodeKey(unencoded_key);
        if (DHTLog.isOn()) {
            DHTLog.log("getLocalValue for " + DHTLog.getString(encoded_key));
        }
        if ((res = this.database.get(new HashWrapper(encoded_key))) == null) {
            return null;
        }
        return res;
    }

    @Override
    public void get(byte[] unencoded_key, String description, short flags, int max_values, long timeout, boolean exhaustive, boolean high_priority, final DHTOperationListener get_listener) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        if (DHTLog.isOn()) {
            DHTLog.log("get for " + DHTLog.getString(encoded_key));
        }
        final DhtTaskSet[] task_set = new DhtTaskSet[]{null};
        DHTOperationListenerDemuxer demuxer = new DHTOperationListenerDemuxer(new DHTOperationListener(){

            public void searching(DHTTransportContact contact, int level, int active_searches) {
                get_listener.searching(contact, level, active_searches);
            }

            public boolean diversified(String desc) {
                return get_listener.diversified(desc);
            }

            public void found(DHTTransportContact contact, boolean is_closest) {
                get_listener.found(contact, is_closest);
            }

            public void read(DHTTransportContact contact, DHTTransportValue value) {
                get_listener.read(contact, value);
            }

            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                get_listener.wrote(contact, value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void complete(boolean timeout) {
                try {
                    try {
                        get_listener.complete(timeout);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        Object var4_3 = null;
                        if (task_set[0] == null) return;
                        task_set[0].cancel();
                        return;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (task_set[0] == null) throw throwable;
                    task_set[0].cancel();
                    throw throwable;
                }
                if (task_set[0] == null) return;
                task_set[0].cancel();
            }
        });
        task_set[0] = this.getSupport(encoded_key, description, flags, max_values, timeout, exhaustive, high_priority, demuxer);
    }

    @Override
    public boolean isDiversified(byte[] unencoded_key) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        return this.adapter.isDiversified(encoded_key);
    }

    @Override
    public boolean lookup(byte[] unencoded_key, String description, long timeout, DHTOperationListener lookup_listener) {
        return this.lookupEncoded(this.encodeKey(unencoded_key), description, timeout, false, lookup_listener);
    }

    @Override
    public boolean lookupEncoded(byte[] encoded_key, String description, long timeout, boolean high_priority, final DHTOperationListener lookup_listener) {
        if (DHTLog.isOn()) {
            DHTLog.log("lookup for " + DHTLog.getString(encoded_key));
        }
        final AESemaphore sem = new AESemaphore("DHTControl:lookup");
        final boolean[] diversified = new boolean[]{false};
        DHTOperationListener delegate = new DHTOperationListener(){

            public void searching(DHTTransportContact contact, int level, int active_searches) {
                lookup_listener.searching(contact, level, active_searches);
            }

            public void found(DHTTransportContact contact, boolean is_closest) {
            }

            public boolean diversified(String desc) {
                return lookup_listener.diversified(desc);
            }

            public void read(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void complete(boolean timeout) {
                lookup_listener.complete(timeout);
                sem.release();
            }
        };
        this.lookup(this.external_lookup_pool, high_priority, encoded_key, description, (short)0, false, timeout, this.search_concurrency, 1, this.router.getK(), new lookupResultHandler(delegate){

            public void diversify(DHTTransportContact cause, byte diversification_type) {
                this.diversified("Diversification of [lookup]");
                diversified[0] = true;
            }

            public void closest(List closest) {
                for (int i = 0; i < closest.size(); ++i) {
                    lookup_listener.found((DHTTransportContact)closest.get(i), true);
                }
            }
        });
        sem.reserve();
        return diversified[0];
    }

    protected DhtTaskSet getSupport(byte[] initial_encoded_key, final String description, final short flags, final int max_values, final long timeout, final boolean exhaustive, final boolean high_priority, final DHTOperationListenerDemuxer get_listener) {
        final DhtTaskSet result = new DhtTaskSet();
        byte[][] encoded_keys = this.adapter.diversify(description, null, false, true, initial_encoded_key, (byte)1, exhaustive, this.getMaxDivDepth());
        if (encoded_keys.length == 0) {
            get_listener.diversified("Over-diversification of [" + description + "]");
            get_listener.complete(false);
            return result;
        }
        for (int i = 0; i < encoded_keys.length; ++i) {
            String this_description;
            final boolean[] diversified = new boolean[]{false};
            final byte[] encoded_key = encoded_keys[i];
            boolean div = !Arrays.equals(encoded_key, initial_encoded_key);
            String string = this_description = div ? "Diversification of [" + description + "]" : description;
            if (div && !get_listener.diversified(this_description)) continue;
            boolean is_stats_query = (flags & 8) != 0;
            result.add(this.lookup(this.external_lookup_pool, high_priority, encoded_key, this_description, flags, true, timeout, is_stats_query ? this.search_concurrency * 2 : this.search_concurrency, max_values, this.router.getK(), new lookupResultHandler(get_listener){
                private List found_values;
                {
                    super(x0);
                    this.found_values = new ArrayList();
                }

                public void diversify(DHTTransportContact cause, byte diversification_type) {
                    boolean ok_to_div = this.diversified("Diversification of [" + this_description + "]");
                    if (ok_to_div && !diversified[0]) {
                        byte[][] diversified_keys;
                        int rem;
                        diversified[0] = true;
                        int n = rem = max_values == 0 ? 0 : max_values - this.found_values.size();
                        if ((max_values == 0 || rem > 0) && (diversified_keys = DHTControlImpl.this.adapter.diversify(description, cause, false, false, encoded_key, diversification_type, exhaustive, DHTControlImpl.this.getMaxDivDepth())).length > 0) {
                            for (int j = 0; j < diversified_keys.length; ++j) {
                                if (result.isCancelled()) continue;
                                result.add(DHTControlImpl.this.getSupport(diversified_keys[j], "Diversification of [" + this_description + "]", flags, rem, timeout, exhaustive, high_priority, get_listener));
                            }
                        }
                    }
                }

                public void read(DHTTransportContact contact, DHTTransportValue value) {
                    this.found_values.add(value);
                    super.read(contact, value);
                }

                public void closest(List closest) {
                }
            }));
        }
        return result;
    }

    @Override
    public byte[] remove(byte[] unencoded_key, String description, DHTOperationListener listener) {
        DHTDBValue res;
        byte[] encoded_key = this.encodeKey(unencoded_key);
        if (DHTLog.isOn()) {
            DHTLog.log("remove for " + DHTLog.getString(encoded_key));
        }
        if ((res = this.database.remove(this.local_contact, new HashWrapper(encoded_key))) == null) {
            return null;
        }
        this.put(this.external_put_pool, false, encoded_key, description, res, (short)((byte)res.getFlags()), 0L, true, new HashSet(), 1, new DHTOperationListenerDemuxer(listener));
        return res.getValue();
    }

    @Override
    public byte[] remove(DHTTransportContact[] contacts, byte[] unencoded_key, String description, DHTOperationListener listener) {
        DHTDBValue res;
        byte[] encoded_key = this.encodeKey(unencoded_key);
        if (DHTLog.isOn()) {
            DHTLog.log("remove for " + DHTLog.getString(encoded_key));
        }
        if ((res = this.database.remove(this.local_contact, new HashWrapper(encoded_key))) == null) {
            return null;
        }
        ArrayList<DHTTransportContact> contacts_l = new ArrayList<DHTTransportContact>(contacts.length);
        for (int i = 0; i < contacts.length; ++i) {
            contacts_l.add(contacts[i]);
        }
        this.put(this.external_put_pool, true, new byte[][]{encoded_key}, "Store of [" + description + "]", new DHTTransportValue[][]{{res}}, (byte)res.getFlags(), contacts_l, 0L, new DHTOperationListenerDemuxer(listener), true, new HashSet(), 1, true);
        return res.getValue();
    }

    protected DhtTask lookup(final ThreadPool thread_pool, boolean high_priority, final byte[] _lookup_id, final String description, final short flags, final boolean value_search, final long timeout, final int concurrency, final int max_values, final int search_accuracy, final lookupResultHandler handler) {
        byte[] obs_value;
        byte[] lookup_id;
        if ((flags & 0x80) != 0) {
            lookup_id = this.getObfuscatedKey(_lookup_id);
            obs_value = this.getObfuscatedValue(_lookup_id);
        } else {
            lookup_id = _lookup_id;
            obs_value = null;
        }
        DhtTask task2 = new DhtTask(thread_pool){
            boolean timeout_occurred;
            Set contacts_to_query;
            AEMonitor contacts_to_query_mon;
            Map<DHTTransportContact, Object[]> level_map;
            ByteArrayHashMap<DHTTransportContact> contacts_queried;
            Set ok_contacts;
            int idle_searches;
            int active_searches;
            int values_found;
            int value_replies;
            Set values_found_set;
            boolean key_blocked;
            long start;
            TimerEvent timeoutEvent;
            private int runningState;
            private int freeTasksCount;
            private boolean cancelled;
            {
                super(x0);
                this.timeout_occurred = false;
                this.runningState = 1;
                this.freeTasksCount = concurrency;
            }

            public void runSupport() {
                this.startLookup();
            }

            private void startLookup() {
                this.contacts_to_query_mon = new AEMonitor("DHTControl:ctq");
                this.contacts_to_query = DHTControlImpl.this.getClosestContactsSet(lookup_id, DHTControlImpl.this.K, false);
                this.level_map = new LightHashMap<DHTTransportContact, Object[]>();
                this.contacts_queried = new ByteArrayHashMap();
                this.ok_contacts = new sortedTransportContactSet(lookup_id, false).getSet();
                this.values_found_set = new HashSet();
                this.start = SystemTime.getMonotonousTime();
                DHTControlImpl.this.last_lookup = SystemTime.getCurrentTime();
                handler.incrementCompletes();
                for (DHTTransportContact contact : this.contacts_to_query) {
                    handler.found(contact, false);
                    this.level_map.put(contact, new Object[]{new Integer(0), null});
                }
                if (DHTLog.isOn()) {
                    DHTLog.log("lookup for " + DHTLog.getString(lookup_id));
                }
                if (value_search && DHTControlImpl.this.database.isKeyBlocked(lookup_id)) {
                    DHTLog.log("lookup: terminates - key blocked");
                    this.terminateLookup(false);
                    return;
                }
                if (timeout > 0L) {
                    this.timeoutEvent = SimpleTimer.addEvent("DHT lookup timeout", SystemTime.getCurrentTime() + timeout, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            if (DHTLog.isOn()) {
                                DHTLog.log("lookup: terminates - timeout");
                            }
                            timeout_occurred = true;
                            this.terminateLookup(false);
                        }
                    });
                }
                this.lookupSteps();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void terminateLookup(boolean error) {
                if (this.timeoutEvent != null) {
                    this.timeoutEvent.cancel();
                }
                16 var2_2 = this;
                synchronized (var2_2) {
                    if (this.runningState == -1) {
                        return;
                    }
                    this.runningState = -1;
                }
                try {
                    if (!error) {
                        ArrayList closest_res = null;
                        try {
                            this.contacts_to_query_mon.enter();
                            if (DHTLog.isOn()) {
                                DHTLog.log("lookup complete for " + DHTLog.getString(lookup_id));
                                DHTLog.log("    queried = " + DHTLog.getString(this.contacts_queried));
                                DHTLog.log("    to query = " + DHTLog.getString(this.contacts_to_query));
                                DHTLog.log("    ok = " + DHTLog.getString(this.ok_contacts));
                            }
                            closest_res = new ArrayList(this.ok_contacts);
                            Collections.reverse(closest_res);
                            if (timeout <= 0L && !value_search) {
                                DHTControlImpl.this.estimateDHTSize(lookup_id, this.contacts_queried.values(), search_accuracy);
                            }
                            Object var5_4 = null;
                            this.contacts_to_query_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            this.contacts_to_query_mon.exit();
                            throw throwable;
                        }
                        handler.closest(closest_res);
                    }
                    handler.complete(this.timeout_occurred);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.releaseToPool();
                    throw throwable;
                }
                this.releaseToPool();
            }

            private synchronized boolean reserve() {
                if (this.freeTasksCount <= 0 || this.runningState == -1) {
                    if (this.runningState == 1) {
                        this.runningState = 0;
                    }
                    return false;
                }
                --this.freeTasksCount;
                return true;
            }

            private synchronized void release() {
                ++this.freeTasksCount;
                if (this.runningState == 0) {
                    this.runningState = 1;
                    new AEThread2("DHT lookup runner", true){

                        public void run() {
                            thread_pool.registerThreadAsChild(worker);
                            this.lookupSteps();
                            thread_pool.deregisterThreadAsChild(worker);
                        }
                    }.start();
                }
            }

            protected synchronized void cancel() {
                if (this.runningState != -1) {
                    // empty if block
                }
                this.cancelled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void lookupSteps() {
                try {
                    boolean terminate = false;
                    while (!this.cancelled) {
                        Object var13_17;
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            if (timeout > 0L) {
                                                long now = SystemTime.getMonotonousTime();
                                                long remaining = timeout - (now - this.start);
                                                if (remaining <= 0L) {
                                                    if (DHTLog.isOn()) {
                                                        DHTLog.log("lookup: terminates - timeout");
                                                    }
                                                    this.timeout_occurred = true;
                                                    terminate = true;
                                                    break;
                                                }
                                                if (!this.reserve()) {
                                                    break;
                                                }
                                            } else if (!this.reserve()) break;
                                            try {
                                                DHTTransportContact furthest_ok;
                                                int distance;
                                                this.contacts_to_query_mon.enter();
                                                if (this.values_found >= max_values || (flags & 8) == 0 && this.value_replies >= 2) {
                                                    terminate = true;
                                                    var13_17 = null;
                                                    this.contacts_to_query_mon.exit();
                                                    break;
                                                }
                                                if (this.key_blocked) {
                                                    this.contacts_to_query.clear();
                                                }
                                                if (this.contacts_to_query.size() == 0) {
                                                    if (this.active_searches == 0) {
                                                        if (DHTLog.isOn()) {
                                                            DHTLog.log("lookup: terminates - no contacts left to query");
                                                        }
                                                        terminate = true;
                                                        break block25;
                                                    }
                                                    ++this.idle_searches;
                                                    break block26;
                                                }
                                                DHTTransportContact closest = (DHTTransportContact)this.contacts_to_query.iterator().next();
                                                if (this.ok_contacts.size() == search_accuracy && (distance = DHTControlImpl.this.computeAndCompareDistances((furthest_ok = (DHTTransportContact)this.ok_contacts.iterator().next()).getID(), closest.getID(), lookup_id)) <= 0) {
                                                    if (DHTLog.isOn()) {
                                                        DHTLog.log("lookup: terminates - we've searched the closest " + search_accuracy + " contacts");
                                                    }
                                                    terminate = true;
                                                    break block27;
                                                }
                                                if (this.contacts_queried.size() < concurrency) {
                                                    DHTNetworkPosition[] loc_nps = DHTControlImpl.this.local_contact.getNetworkPositions();
                                                    DHTTransportContact vp_closest = null;
                                                    Iterator vp_it = this.contacts_to_query.iterator();
                                                    int vp_count_limit = concurrency * 2 - this.contacts_queried.size();
                                                    int vp_count = 0;
                                                    float best_dist = Float.MAX_VALUE;
                                                    while (vp_it.hasNext() && vp_count < vp_count_limit) {
                                                        ++vp_count;
                                                        DHTTransportContact entry = (DHTTransportContact)vp_it.next();
                                                        DHTNetworkPosition[] rem_nps = entry.getNetworkPositions();
                                                        float dist = DHTNetworkPositionManager.estimateRTT(loc_nps, rem_nps);
                                                        if (!Float.isNaN(dist) && dist < best_dist) {
                                                            best_dist = dist;
                                                            vp_closest = entry;
                                                        }
                                                        if (vp_closest == null) continue;
                                                        closest = vp_closest;
                                                    }
                                                }
                                                final DHTTransportContact f_closest = closest;
                                                this.contacts_to_query.remove(closest);
                                                this.contacts_queried.put(closest.getID(), closest);
                                                if (DHTControlImpl.this.router.isID(closest.getID())) {
                                                    this.release();
                                                    break block28;
                                                }
                                                final int search_level = (Integer)this.level_map.get(closest)[0];
                                                ++this.active_searches;
                                                handler.searching(closest, search_level, this.active_searches);
                                                DHTTransportReplyHandlerAdapter replyHandler = new DHTTransportReplyHandlerAdapter(){
                                                    private boolean value_reply_received = false;

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public void findNodeReply(DHTTransportContact target_contact, DHTTransportContact[] reply_contacts) {
                                                        Object v1;
                                                        block12: {
                                                            try {
                                                                DHTTransportContact contact;
                                                                if (DHTLog.isOn()) {
                                                                    DHTLog.log("findNodeReply: " + DHTLog.getString(reply_contacts));
                                                                }
                                                                DHTControlImpl.this.router.contactAlive(target_contact.getID(), new DHTControlContactImpl(target_contact));
                                                                for (int i = 0; i < reply_contacts.length; ++i) {
                                                                    contact = reply_contacts[i];
                                                                    if (DHTControlImpl.this.compareDistances(DHTControlImpl.this.router.getID(), contact.getID()) == 0) continue;
                                                                    DHTControlImpl.this.router.contactKnown(contact.getID(), new DHTControlContactImpl(contact), false);
                                                                }
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    ok_contacts.add(target_contact);
                                                                    if (ok_contacts.size() > search_accuracy) {
                                                                        Iterator ok_it = ok_contacts.iterator();
                                                                        ok_it.next();
                                                                        ok_it.remove();
                                                                    }
                                                                    for (int i = 0; i < reply_contacts.length; ++i) {
                                                                        contact = reply_contacts[i];
                                                                        if (DHTControlImpl.this.compareDistances(DHTControlImpl.this.router.getID(), contact.getID()) == 0 || contacts_queried.get(contact.getID()) != null || contacts_to_query.contains(contact)) continue;
                                                                        if (DHTLog.isOn()) {
                                                                            DHTLog.log("    new contact for query: " + DHTLog.getString(contact));
                                                                        }
                                                                        contacts_to_query.add(contact);
                                                                        handler.found(contact, false);
                                                                        level_map.put(contact, new Object[]{new Integer(search_level + 1), target_contact});
                                                                        if (idle_searches <= 0) continue;
                                                                        --idle_searches;
                                                                        this.release();
                                                                    }
                                                                    Object var6_7 = null;
                                                                    contacts_to_query_mon.exit();
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var6_8 = null;
                                                                    contacts_to_query_mon.exit();
                                                                    throw throwable;
                                                                }
                                                                Object var8_10 = null;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object v0;
                                                                Object var8_11 = null;
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    --active_searches;
                                                                    v0 = null;
                                                                }
                                                                catch (Throwable throwable2) {
                                                                    v0 = null;
                                                                }
                                                                Object var10_15 = v0;
                                                                contacts_to_query_mon.exit();
                                                                throw throwable;
                                                            }
                                                            try {
                                                                contacts_to_query_mon.enter();
                                                                --active_searches;
                                                                v1 = null;
                                                                break block12;
                                                            }
                                                            catch (Throwable throwable) {
                                                                v1 = null;
                                                            }
                                                            {
                                                            }
                                                        }
                                                        Object var10_14 = v1;
                                                        contacts_to_query_mon.exit();
                                                    }

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public void findValueReply(DHTTransportContact contact, DHTTransportValue[] values, byte diversification_type, boolean more_to_come) {
                                                        block15: {
                                                            if (DHTLog.isOn()) {
                                                                DHTLog.log("findValueReply: " + DHTLog.getString(values) + ",mtc=" + more_to_come + ", dt=" + diversification_type);
                                                            }
                                                            boolean obs_recurse = false;
                                                            if (diversification_type == 99) {
                                                                obs_recurse = true;
                                                                diversification_type = 1;
                                                            }
                                                            try {
                                                                if (!key_blocked && diversification_type != 1 && (flags & 8) == 0) {
                                                                    handler.diversify(contact, diversification_type);
                                                                }
                                                                this.value_reply_received = true;
                                                                DHTControlImpl.this.router.contactAlive(contact.getID(), new DHTControlContactImpl(contact));
                                                                int new_values = 0;
                                                                if (!key_blocked) {
                                                                    for (int i = 0; i < values.length; ++i) {
                                                                        DHTTransportValue value = values[i];
                                                                        DHTTransportContact originator = value.getOriginator();
                                                                        byte[] originator_id = originator.getID();
                                                                        byte[] value_bytes = value.getValue();
                                                                        byte[] value_id = new byte[originator_id.length + value_bytes.length];
                                                                        System.arraycopy(originator_id, 0, value_id, 0, originator_id.length);
                                                                        System.arraycopy(value_bytes, 0, value_id, originator_id.length, value_bytes.length);
                                                                        HashWrapper x = new HashWrapper(value_id);
                                                                        if (values_found_set.contains(x)) continue;
                                                                        if (obs_value != null && !obs_recurse) {
                                                                            if (!Arrays.equals(obs_value, value_bytes)) continue;
                                                                            more_to_come = true;
                                                                            final 3 f_outer = this;
                                                                            f_closest.sendFindValue(new DHTTransportReplyHandlerAdapter(){

                                                                                public void findValueReply(DHTTransportContact contact, DHTTransportValue[] values, byte diversification_type, boolean more_to_come) {
                                                                                    if (diversification_type == 1) {
                                                                                        f_outer.findValueReply(contact, values, (byte)99, false);
                                                                                    }
                                                                                }

                                                                                public void failed(DHTTransportContact contact, Throwable error) {
                                                                                    f_outer.failed(contact, error);
                                                                                }
                                                                            }, _lookup_id, 1, flags);
                                                                            break;
                                                                        }
                                                                        ++new_values;
                                                                        values_found_set.add(x);
                                                                        handler.read(contact, values[i]);
                                                                    }
                                                                }
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    if (!more_to_come) {
                                                                        ++value_replies;
                                                                    }
                                                                    values_found += new_values;
                                                                    Object var16_15 = null;
                                                                    contacts_to_query_mon.exit();
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var16_16 = null;
                                                                    contacts_to_query_mon.exit();
                                                                    throw throwable;
                                                                }
                                                                Object var18_18 = null;
                                                                if (more_to_come) break block15;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object var18_19 = null;
                                                                if (!more_to_come) {
                                                                    try {
                                                                        contacts_to_query_mon.enter();
                                                                        --active_searches;
                                                                        Object var20_22 = null;
                                                                        contacts_to_query_mon.exit();
                                                                    }
                                                                    catch (Throwable throwable2) {
                                                                        Object var20_23 = null;
                                                                        contacts_to_query_mon.exit();
                                                                        throw throwable2;
                                                                    }
                                                                    this.release();
                                                                }
                                                                throw throwable;
                                                            }
                                                            try {
                                                                contacts_to_query_mon.enter();
                                                                --active_searches;
                                                                Object var20_20 = null;
                                                                contacts_to_query_mon.exit();
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object var20_21 = null;
                                                                contacts_to_query_mon.exit();
                                                                throw throwable;
                                                            }
                                                            this.release();
                                                            {
                                                            }
                                                        }
                                                    }

                                                    public void findValueReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                                                        this.findNodeReply(contact, contacts);
                                                    }

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public void failed(DHTTransportContact target_contact, Throwable error) {
                                                        try {
                                                            if (!this.value_reply_received) {
                                                                if (DHTLog.isOn()) {
                                                                    DHTLog.log("findNode/findValue " + DHTLog.getString(target_contact) + " -> failed: " + error.getMessage());
                                                                }
                                                                DHTControlImpl.this.router.contactDead(target_contact.getID(), false);
                                                            }
                                                            Object var4_3 = null;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var4_4 = null;
                                                            try {
                                                                contacts_to_query_mon.enter();
                                                                --active_searches;
                                                                Object var6_7 = null;
                                                                contacts_to_query_mon.exit();
                                                            }
                                                            catch (Throwable throwable2) {
                                                                Object var6_8 = null;
                                                                contacts_to_query_mon.exit();
                                                                throw throwable2;
                                                            }
                                                            this.release();
                                                            throw throwable;
                                                        }
                                                        try {
                                                            contacts_to_query_mon.enter();
                                                            --active_searches;
                                                            Object var6_5 = null;
                                                            contacts_to_query_mon.exit();
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var6_6 = null;
                                                            contacts_to_query_mon.exit();
                                                            throw throwable;
                                                        }
                                                        this.release();
                                                    }

                                                    public void keyBlockRequest(DHTTransportContact contact, byte[] request2, byte[] key_signature) {
                                                        if (DHTControlImpl.this.database.keyBlockRequest(null, request2, key_signature) != null) {
                                                            key_blocked = true;
                                                        }
                                                    }
                                                };
                                                DHTControlImpl.this.router.recordLookup(lookup_id);
                                                if (value_search) {
                                                    int rem = max_values - this.values_found;
                                                    if (rem <= 0) {
                                                        Debug.out("eh?");
                                                        rem = 1;
                                                    }
                                                    closest.sendFindValue(replyHandler, lookup_id, rem, flags);
                                                    break block29;
                                                } else {
                                                    closest.sendFindNode(replyHandler, lookup_id, flags);
                                                }
                                                break block29;
                                            }
                                            catch (Throwable throwable) {
                                                var13_17 = null;
                                                this.contacts_to_query_mon.exit();
                                                throw throwable;
                                            }
                                        }
                                        var13_17 = null;
                                        this.contacts_to_query_mon.exit();
                                        break;
                                    }
                                    var13_17 = null;
                                    this.contacts_to_query_mon.exit();
                                    continue;
                                }
                                var13_17 = null;
                                this.contacts_to_query_mon.exit();
                                break;
                            }
                            var13_17 = null;
                            this.contacts_to_query_mon.exit();
                            continue;
                        }
                        var13_17 = null;
                        this.contacts_to_query_mon.exit();
                    }
                    if (terminate) {
                        this.terminateLookup(false);
                        return;
                    }
                    if (!this.cancelled) return;
                    this.terminateLookup(true);
                    return;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.terminateLookup(true);
                }
            }

            public byte[] getTarget() {
                return lookup_id;
            }

            public String getDescription() {
                return description;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DHTControlActivity.ActivityState getCurrentState() {
                String result_str;
                DHTTransportContact local = DHTControlImpl.this.local_contact;
                ANImpl root_node = new ANImpl(local);
                if (this.timeout_occurred) {
                    result_str = "Timeout";
                } else {
                    long elapsed = SystemTime.getMonotonousTime() - this.start;
                    String elapsed_str = elapsed < 1000L ? elapsed + "ms" : elapsed / 1000L + "s";
                    result_str = value_search ? this.values_found + " hits, time=" + elapsed_str : "time=" + elapsed_str;
                }
                ASImpl result = new ASImpl(root_node, result_str);
                if (this.contacts_to_query_mon != null) {
                    this.contacts_to_query_mon.enter();
                    try {
                        if (this.contacts_queried != null && this.level_map != null) {
                            ArrayList<Map.Entry<DHTTransportContact, Object[]>> lm_entries = new ArrayList<Map.Entry<DHTTransportContact, Object[]>>(this.level_map.entrySet());
                            Collections.sort(lm_entries, new Comparator<Map.Entry<DHTTransportContact, Object[]>>(){

                                @Override
                                public int compare(Map.Entry<DHTTransportContact, Object[]> o1, Map.Entry<DHTTransportContact, Object[]> o2) {
                                    int l1 = (Integer)o1.getValue()[0];
                                    int l2 = (Integer)o2.getValue()[0];
                                    return l1 - l2;
                                }
                            });
                            HashSet<DHTTransportContact> qd = new HashSet<DHTTransportContact>(this.contacts_queried.values());
                            HashMap<DHTTransportContact, ANImpl> node_map = new HashMap<DHTTransportContact, ANImpl>();
                            node_map.put(local, root_node);
                            for (Map.Entry entry : lm_entries) {
                                ANImpl p_node;
                                DHTTransportContact contact = (DHTTransportContact)entry.getKey();
                                if (!qd.contains(contact)) continue;
                                Object[] entry2 = (Object[])entry.getValue();
                                DHTTransportContact parent = (DHTTransportContact)entry2[1];
                                if (parent == null) {
                                    parent = local;
                                }
                                if ((p_node = (ANImpl)node_map.get(parent)) == null) {
                                    Debug.out("eh");
                                    continue;
                                }
                                ANImpl new_node = new ANImpl(contact);
                                node_map.put(contact, new_node);
                                p_node.add(new_node);
                            }
                        }
                        Object var16_16 = null;
                        this.contacts_to_query_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        this.contacts_to_query_mon.exit();
                        throw throwable;
                    }
                }
                return result;
            }
        };
        thread_pool.run(task2, high_priority, true);
        return task2;
    }

    @Override
    public void pingRequest(DHTTransportContact originating_contact) {
        if (DHTLog.isOn()) {
            DHTLog.log("pingRequest from " + DHTLog.getString(originating_contact.getID()));
        }
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
    }

    @Override
    public void keyBlockRequest(DHTTransportContact originating_contact, byte[] request2, byte[] sig) {
        if (DHTLog.isOn()) {
            DHTLog.log("keyBlockRequest from " + DHTLog.getString(originating_contact.getID()));
        }
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
        this.database.keyBlockRequest(originating_contact, request2, sig);
    }

    @Override
    public DHTTransportStoreReply storeRequest(DHTTransportContact originating_contact, byte[][] keys, DHTTransportValue[][] value_sets) {
        byte[] originator_id = originating_contact.getID();
        this.router.contactAlive(originator_id, new DHTControlContactImpl(originating_contact));
        if (DHTLog.isOn()) {
            DHTLog.log("storeRequest from " + DHTLog.getString(originating_contact) + ", keys = " + keys.length);
        }
        byte[] diverse_res = new byte[keys.length];
        Arrays.fill(diverse_res, (byte)1);
        if (keys.length != value_sets.length) {
            Debug.out("DHTControl:storeRequest - invalid request received from " + originating_contact.getString() + ", keys and values length mismatch");
            return new DHTTransportStoreReplyImpl(diverse_res);
        }
        DHTStorageBlock blocked_details = null;
        if (keys.length > 0) {
            boolean cache_forward = false;
            DHTTransportValue[][] arr$ = value_sets;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                DHTTransportValue[] values;
                for (DHTTransportValue value : values = arr$[i$]) {
                    if (Arrays.equals(originator_id, value.getOriginator().getID())) continue;
                    cache_forward = true;
                    break;
                }
                if (cache_forward) break;
            }
            if (cache_forward && !this.isSeeded()) {
                if (DHTLog.isOn()) {
                    DHTLog.log("Not storing keys as not yet seeded");
                }
            } else if (!this.verifyContact(originating_contact, !cache_forward)) {
                this.logger.log("Verification of contact '" + originating_contact.getName() + "' failed for store operation");
            } else {
                byte[] my_id = this.local_contact.getID();
                int c_factor = this.router.getK();
                DHTStorageAdapter sad = this.adapter.getStorageAdapter();
                if (sad != null && sad.getNetwork() != 1) {
                    c_factor += c_factor / 2;
                }
                boolean store_it = true;
                if (cache_forward) {
                    long now = SystemTime.getMonotonousTime();
                    if (now - this.rbs_time < 10000L && Arrays.equals(originator_id, this.rbs_id)) {
                        store_it = false;
                    } else {
                        List<DHTTransportContact> closest_contacts = this.getClosestContactsList(my_id, c_factor, true);
                        DHTTransportContact furthest = closest_contacts.get(closest_contacts.size() - 1);
                        if (this.computeAndCompareDistances(furthest.getID(), originator_id, my_id) < 0) {
                            this.rbs_id = originator_id;
                            this.rbs_time = now;
                            if (DHTLog.isOn()) {
                                DHTLog.log("Not storing keys as cache forward and sender too far away");
                            }
                            store_it = false;
                        }
                    }
                }
                if (store_it) {
                    for (int i = 0; i < keys.length; ++i) {
                        byte[] key = keys[i];
                        HashWrapper hw_key = new HashWrapper(key);
                        DHTTransportValue[] values = value_sets[i];
                        if (DHTLog.isOn()) {
                            DHTLog.log("    key=" + DHTLog.getString(key) + ", value=" + DHTLog.getString(values));
                        }
                        if (!this.database.hasKey(hw_key) && !this.isIDInClosestContacts(my_id, key, c_factor, true)) {
                            if (!DHTLog.isOn()) continue;
                            DHTLog.log("Not storing keys as cache forward and sender too far away");
                            continue;
                        }
                        diverse_res[i] = this.database.store(originating_contact, hw_key, values);
                        if (blocked_details != null) continue;
                        blocked_details = this.database.getKeyBlockDetails(key);
                    }
                }
            }
        }
        if (blocked_details == null) {
            return new DHTTransportStoreReplyImpl(diverse_res);
        }
        return new DHTTransportStoreReplyImpl(blocked_details.getRequest(), blocked_details.getCertificate());
    }

    @Override
    public DHTTransportQueryStoreReply queryStoreRequest(DHTTransportContact originating_contact, int header_len, List<Object[]> keys) {
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
        if (DHTLog.isOn()) {
            DHTLog.log("queryStoreRequest from " + DHTLog.getString(originating_contact) + ", header_len=" + header_len + ", keys=" + keys.size());
        }
        if (originating_contact.getRandomIDType() == 1) {
            int rand = this.generateSpoofID(originating_contact);
            originating_contact.setRandomID(rand);
        } else {
            byte[] rand = this.generateSpoofID2(originating_contact);
            originating_contact.setRandomID2(rand);
        }
        return this.database.queryStore(originating_contact, header_len, keys);
    }

    @Override
    public DHTTransportContact[] findNodeRequest(DHTTransportContact originating_contact, byte[] id) {
        return this.findNodeRequest(originating_contact, id, false);
    }

    private DHTTransportContact[] findNodeRequest(DHTTransportContact originating_contact, byte[] id, boolean already_logged) {
        if (!already_logged && DHTLog.isOn()) {
            DHTLog.log("findNodeRequest from " + DHTLog.getString(originating_contact.getID()));
        }
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
        List<Object> l = id.length == this.router.getID().length ? this.getClosestKContactsList(id, true) : new ArrayList();
        DHTTransportContact[] res = new DHTTransportContact[l.size()];
        l.toArray(res);
        if (originating_contact.getRandomIDType() == 1) {
            int rand = this.generateSpoofID(originating_contact);
            originating_contact.setRandomID(rand);
        } else {
            byte[] rand = this.generateSpoofID2(originating_contact);
            originating_contact.setRandomID2(rand);
        }
        return res;
    }

    @Override
    public DHTTransportFindValueReply findValueRequest(DHTTransportContact originating_contact, byte[] key, int max_values, short flags) {
        DHTDBLookupResult result;
        if (DHTLog.isOn()) {
            DHTLog.log("findValueRequest from " + DHTLog.getString(originating_contact.getID()));
        }
        if ((result = this.database.get(originating_contact, new HashWrapper(key), max_values, flags, true)) != null) {
            if (originating_contact.getRandomIDType() == 2) {
                byte[] rand = this.generateSpoofID2(originating_contact);
                originating_contact.setRandomID2(rand);
            }
            this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
            DHTStorageBlock block_details = this.database.getKeyBlockDetails(key);
            if (block_details == null) {
                return new DHTTransportFindValueReplyImpl(result.getDiversificationType(), result.getValues());
            }
            return new DHTTransportFindValueReplyImpl(block_details.getRequest(), block_details.getCertificate());
        }
        return new DHTTransportFindValueReplyImpl(this.findNodeRequest(originating_contact, key, true));
    }

    @Override
    public DHTTransportFullStats statsRequest(DHTTransportContact contact) {
        return this.stats;
    }

    protected void requestPing(DHTRouterContact contact) {
        ((DHTControlContact)((Object)contact.getAttachment())).getTransportContact().sendPing(new DHTTransportReplyHandlerAdapter(){

            public void pingReply(DHTTransportContact _contact) {
                if (DHTLog.isOn()) {
                    DHTLog.log("ping OK " + DHTLog.getString(_contact));
                }
                DHTControlImpl.this.router.contactAlive(_contact.getID(), new DHTControlContactImpl(_contact));
            }

            public void failed(DHTTransportContact _contact, Throwable _error) {
                if (DHTLog.isOn()) {
                    DHTLog.log("ping " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                }
                DHTControlImpl.this.router.contactDead(_contact.getID(), false);
            }
        });
    }

    protected void nodeAddedToRouter(DHTRouterContact new_contact) {
        if (!new_contact.hasBeenAlive()) {
            this.requestPing(new_contact);
        }
    }

    protected Set<DHTTransportContact> getClosestContactsSet(byte[] id, int num_to_return, boolean live_only) {
        List<DHTRouterContact> l = this.router.findClosestContacts(id, num_to_return, live_only);
        Set<DHTTransportContact> sorted_set = new sortedTransportContactSet(id, true).getSet();
        long size = l.size();
        int i = 0;
        while ((long)i < size) {
            sorted_set.add(((DHTControlContact)((Object)l.get(i).getAttachment())).getTransportContact());
            ++i;
        }
        return sorted_set;
    }

    @Override
    public List<DHTTransportContact> getClosestKContactsList(byte[] id, boolean live_only) {
        return this.getClosestContactsList(id, this.K, live_only);
    }

    @Override
    public List<DHTTransportContact> getClosestContactsList(byte[] id, int num_to_return, boolean live_only) {
        Set<DHTTransportContact> sorted_set = this.getClosestContactsSet(id, num_to_return, live_only);
        ArrayList<DHTTransportContact> res = new ArrayList<DHTTransportContact>(num_to_return);
        Iterator<DHTTransportContact> it = sorted_set.iterator();
        while (it.hasNext() && res.size() < num_to_return) {
            res.add(it.next());
        }
        return res;
    }

    protected boolean isIDInClosestContacts(byte[] test_id, byte[] target_id, int num_to_consider, boolean live_only) {
        List<DHTRouterContact> l = this.router.findClosestContacts(target_id, num_to_consider, live_only);
        boolean found = false;
        int num_closer = 0;
        for (DHTRouterContact c : l) {
            byte[] c_id = c.getID();
            if (Arrays.equals(test_id, c_id)) {
                found = true;
                continue;
            }
            if (this.computeAndCompareDistances(c_id, test_id, target_id) >= 0) continue;
            ++num_closer;
        }
        return found && num_closer < num_to_consider;
    }

    protected byte[] encodeKey(byte[] key) {
        if (this.encode_keys) {
            byte[] temp = new SHA1Simple().calculateHash(key);
            byte[] result = new byte[this.node_id_byte_count];
            System.arraycopy(temp, 0, result, 0, this.node_id_byte_count);
            return result;
        }
        if (key.length == this.node_id_byte_count) {
            return key;
        }
        byte[] result = new byte[this.node_id_byte_count];
        System.arraycopy(key, 0, result, 0, Math.min(this.node_id_byte_count, key.length));
        return result;
    }

    @Override
    public int computeAndCompareDistances(byte[] t1, byte[] t2, byte[] pivot) {
        return DHTControlImpl.computeAndCompareDistances2(t1, t2, pivot);
    }

    protected static int computeAndCompareDistances2(byte[] t1, byte[] t2, byte[] pivot) {
        for (int i = 0; i < t1.length; ++i) {
            byte d1 = (byte)(t1[i] ^ pivot[i]);
            byte d2 = (byte)(t2[i] ^ pivot[i]);
            int diff = (d1 & 0xFF) - (d2 & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Override
    public byte[] computeDistance(byte[] n1, byte[] n2) {
        return DHTControlImpl.computeDistance2(n1, n2);
    }

    protected static byte[] computeDistance2(byte[] n1, byte[] n2) {
        byte[] res = new byte[n1.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(n1[i] ^ n2[i]);
        }
        return res;
    }

    @Override
    public int compareDistances(byte[] n1, byte[] n2) {
        return DHTControlImpl.compareDistances2(n1, n2);
    }

    protected static int compareDistances2(byte[] n1, byte[] n2) {
        for (int i = 0; i < n1.length; ++i) {
            int diff = (n1[i] & 0xFF) - (n2[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DHTControlListener l) {
        try {
            this.activity_mon.enter();
            this.listeners.addListener(l);
            for (int i = 0; i < this.activities.size(); ++i) {
                this.listeners.dispatch(1, this.activities.get(i));
            }
            Object var4_3 = null;
            this.activity_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.activity_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void removeListener(DHTControlListener l) {
        this.listeners.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTControlActivity[] getActivities() {
        ArrayList res;
        try {
            this.activity_mon.enter();
            res = new ArrayList(this.activities);
            Object var3_2 = null;
            this.activity_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.activity_mon.exit();
            throw throwable;
        }
        DHTControlActivity[] x = new DHTControlActivity[res.size()];
        res.toArray(x);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransportEstimatedDHTSize(int size) {
        if (size > 0) {
            try {
                this.estimate_mon.enter();
                this.remote_estimate_values.add(new Integer(size));
                if (this.remote_estimate_values.size() > 128) {
                    this.remote_estimate_values.remove(0);
                }
                Object var3_2 = null;
                this.estimate_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.estimate_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public int getTransportEstimatedDHTSize() {
        return (int)this.local_dht_estimate;
    }

    public int getEstimatedDHTSize() {
        int percent;
        long now = SystemTime.getCurrentTime();
        long diff = now - this.last_dht_estimate_time;
        if (diff < 0L || diff > 60000L) {
            this.estimateDHTSize(this.router.getID(), null, this.router.getK());
        }
        if ((percent = this.transport.getStats().getRouteablePercentage()) < 25) {
            return (int)this.combined_dht_estimate;
        }
        double mult = 100.0 / (double)percent;
        return (int)(mult * (double)this.combined_dht_estimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void estimateDHTSize(byte[] id, List<DHTTransportContact> contacts, int contacts_to_use) {
        long now = SystemTime.getCurrentTime();
        long diff = now - this.last_dht_estimate_time;
        if (diff < 0L || diff > 5000L) {
            try {
                List<DHTTransportContact> l;
                this.estimate_mon.enter();
                this.last_dht_estimate_time = now;
                if (contacts == null) {
                    l = this.getClosestKContactsList(id, false);
                } else {
                    Set<DHTTransportContact> sorted_set = new sortedTransportContactSet(id, true).getSet();
                    sorted_set.addAll(contacts);
                    l = new ArrayList<DHTTransportContact>(sorted_set);
                    if (l.size() > 0) {
                        id = l.get(0).getID();
                    }
                }
                if (l.size() > 2) {
                    BigInteger sum1 = new BigInteger("0");
                    BigInteger sum2 = new BigInteger("0");
                    for (int i = 1; i < Math.min(l.size(), contacts_to_use); ++i) {
                        DHTTransportContact node = l.get(i);
                        byte[] dist = this.computeDistance(id, node.getID());
                        BigInteger b_dist = this.IDToBigInteger(dist);
                        BigInteger b_i = new BigInteger("" + i);
                        sum1 = sum1.add(b_i.multiply(b_dist));
                        sum2 = sum2.add(b_i.multiply(b_i));
                    }
                    byte[] max = new byte[id.length + 1];
                    max[0] = 1;
                    long this_estimate = sum1.compareTo(new BigInteger("0")) == 0 ? 0L : this.IDToBigInteger(max).multiply(sum2).divide(sum1).longValue();
                    if (this_estimate < 1L) {
                        this_estimate = 1L;
                    }
                    this.local_estimate_values.put(new HashWrapper(id), new Long(this_estimate));
                    long new_estimate = 0L;
                    Iterator it = this.local_estimate_values.values().iterator();
                    String sizes = "";
                    while (it.hasNext()) {
                        long estimate = (Long)it.next();
                        sizes = sizes + (sizes.length() == 0 ? "" : ",") + estimate;
                        new_estimate += estimate;
                    }
                    this.local_dht_estimate = new_estimate / (long)this.local_estimate_values.size();
                }
                ArrayList rems = new ArrayList(new TreeSet(this.remote_estimate_values));
                long rem_average = this.local_dht_estimate;
                int rem_vals = 1;
                for (int i = 3; i < rems.size() - 3; ++i) {
                    rem_average += (long)((Integer)rems.get(i)).intValue();
                    ++rem_vals;
                }
                long[] router_stats = this.router.getStats().getStats();
                long router_contacts = router_stats[2] + router_stats[3];
                this.combined_dht_estimate = Math.max(rem_average / (long)rem_vals, router_contacts);
                long test_val = 10L;
                int test_mag = 1;
                while (test_val < this.combined_dht_estimate) {
                    test_val *= 10L;
                    ++test_mag;
                }
                this.combined_dht_estimate_mag = test_mag + 1;
                Object var21_26 = null;
                this.estimate_mon.exit();
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                this.estimate_mon.exit();
                throw throwable;
            }
        }
    }

    protected BigInteger IDToBigInteger(byte[] data) {
        StringBuilder str_key = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i] & 0xFF);
            if (hex.length() < 2) {
                str_key.append("0");
            }
            str_key.append(hex);
        }
        BigInteger res = new BigInteger(str_key.toString(), 16);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateSpoofID(DHTTransportContact contact) {
        InetAddress iad;
        block7: {
            if (this.spoof_digest == null) {
                return 0;
            }
            iad = contact.getAddress().getAddress();
            this.spoof_mon.enter();
            Integer existing = this.spoof_gen_history.get(iad);
            if (existing == null) break block7;
            int n = existing;
            Object var10_7 = null;
            this.spoof_mon.exit();
            return n;
        }
        try {
            byte[] address = iad.getAddress();
            byte[] data_in = (byte[])this.spoof_key.clone();
            for (int i = 0; i < address.length; ++i) {
                int n = i;
                data_in[n] = (byte)(data_in[n] ^ address[i]);
            }
            byte[] data_out = this.spoof_digest.digest(data_in);
            int res = data_out[0] << 24 & 0xFF000000 | data_out[1] << 16 & 0xFF0000 | data_out[2] << 8 & 0xFF00 | data_out[3] & 0xFF;
            this.spoof_gen_history.put(iad, res);
            int n = res;
            Object var10_8 = null;
            this.spoof_mon.exit();
            return n;
        }
        catch (Throwable e) {
            try {
                this.logger.log(e);
                Object var10_9 = null;
                this.spoof_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.spoof_mon.exit();
                throw throwable;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateSpoofID2(DHTTransportContact contact) {
        HashWrapper cid;
        block7: {
            if (this.spoof_digest == null) {
                return new byte[8];
            }
            cid = new HashWrapper(contact.getID());
            this.spoof_mon.enter();
            byte[] existing = this.spoof_gen_history2.get(cid);
            if (existing == null) break block7;
            byte[] byArray = existing;
            Object var11_7 = null;
            this.spoof_mon.exit();
            return byArray;
        }
        try {
            byte[] cid_bytes = cid.getBytes();
            byte[] data_in = (byte[])this.spoof_key.clone();
            int byte_count = Math.min(cid_bytes.length, data_in.length);
            for (int i = 0; i < byte_count; ++i) {
                int n = i;
                data_in[n] = (byte)(data_in[n] ^ cid_bytes[i]);
            }
            byte[] data_out = this.spoof_digest.digest(data_in);
            byte[] res = new byte[8];
            System.arraycopy(data_out, 0, res, 0, 8);
            this.spoof_gen_history2.put(cid, res);
            byte[] byArray = res;
            Object var11_8 = null;
            this.spoof_mon.exit();
            return byArray;
        }
        catch (Throwable e) {
            try {
                this.logger.log(e);
                Object var11_9 = null;
                this.spoof_mon.exit();
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                this.spoof_mon.exit();
                throw throwable;
            }
        }
        return new byte[8];
    }

    @Override
    public boolean verifyContact(DHTTransportContact c, boolean direct) {
        boolean ok;
        if (c.getRandomIDType() == 1) {
            ok = c.getRandomID() == this.generateSpoofID(c);
        } else {
            byte[] r1 = c.getRandomID2();
            byte[] r2 = this.generateSpoofID2(c);
            ok = r1 == null && r2 == null ? true : (r1 == null || r2 == null ? false : Arrays.equals(r1, r2));
        }
        return ok;
    }

    public List getContacts() {
        List<DHTRouterContact> contacts = this.router.getAllContacts();
        ArrayList<DHTRouterContactAttachment> res = new ArrayList<DHTRouterContactAttachment>(contacts.size());
        for (int i = 0; i < contacts.size(); ++i) {
            DHTRouterContact rc = contacts.get(i);
            res.add(rc.getAttachment());
        }
        return res;
    }

    @Override
    public void pingAll() {
        List<DHTRouterContact> contacts = this.router.getAllContacts();
        final AESemaphore sem = new AESemaphore("pingAll", 32);
        final int[] results = new int[]{0, 0};
        for (int i = 0; i < contacts.size(); ++i) {
            sem.reserve();
            DHTRouterContact rc = contacts.get(i);
            ((DHTControlContact)((Object)rc.getAttachment())).getTransportContact().sendPing(new DHTTransportReplyHandlerAdapter(){

                public void pingReply(DHTTransportContact _contact) {
                    results[0] = results[0] + 1;
                    this.print();
                    sem.release();
                }

                public void failed(DHTTransportContact _contact, Throwable _error) {
                    results[1] = results[1] + 1;
                    this.print();
                    sem.release();
                }

                protected void print() {
                    System.out.println("ok=" + results[0] + ",bad=" + results[1]);
                }
            });
        }
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        if (this.router != null) {
            this.router.destroy();
        }
        if (this.database != null) {
            this.database.destroy();
        }
    }

    @Override
    public void print(boolean full) {
        DHTNetworkPosition[] nps = this.transport.getLocalContact().getNetworkPositions();
        String np_str = "";
        for (int j = 0; j < nps.length; ++j) {
            np_str = np_str + (j == 0 ? "" : ",") + nps[j];
        }
        this.logger.log("DHT Details: external address=" + this.transport.getLocalContact().getAddress() + ", network=" + this.transport.getNetwork() + ", protocol=V" + this.transport.getProtocolVersion() + ", nps=" + np_str + ", est_size=" + this.getTransportEstimatedDHTSize());
        this.router.print();
        this.database.print(full);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ANImpl
    implements DHTControlActivity.ActivityNode {
        private final DHTTransportContact contact;
        private final List<DHTControlActivity.ActivityNode> kids = new ArrayList<DHTControlActivity.ActivityNode>();

        private ANImpl(DHTTransportContact _contact) {
            this.contact = _contact;
        }

        @Override
        public DHTTransportContact getContact() {
            return this.contact;
        }

        @Override
        public List<DHTControlActivity.ActivityNode> getChildren() {
            return this.kids;
        }

        private int getMaxDepth() {
            int max = 0;
            for (DHTControlActivity.ActivityNode n : this.kids) {
                max = Math.max(max, ((ANImpl)n).getMaxDepth());
            }
            return max + 1;
        }

        private void add(DHTControlActivity.ActivityNode n) {
            this.kids.add(n);
        }

        private String getString() {
            String str = "";
            if (this.kids.size() > 0) {
                for (DHTControlActivity.ActivityNode k : this.kids) {
                    ANImpl a = (ANImpl)k;
                    str = str + (str.length() == 0 ? "" : ",") + a.getString();
                }
                str = "[" + str + "]";
            }
            return AddressUtils.getHostAddress(this.contact.getAddress()) + " - " + str;
        }
    }

    private static class ASImpl
    implements DHTControlActivity.ActivityState {
        private final ANImpl root;
        private int depth = -1;
        private String result;

        private ASImpl(ANImpl _root, String _result) {
            this.root = _root;
            this.result = _result;
        }

        public DHTControlActivity.ActivityNode getRootNode() {
            return this.root;
        }

        public String getResult() {
            return this.result;
        }

        public int getDepth() {
            if (this.depth == -1) {
                this.depth = this.root.getMaxDepth() - 1;
                if (this.depth == 0) {
                    this.depth = 1;
                }
            }
            return this.depth;
        }

        public String getString() {
            return this.root.getString();
        }
    }

    protected static class DHTOperationListenerDemuxer
    implements DHTOperationListener {
        private AEMonitor this_mon = new AEMonitor("DHTOperationListenerDemuxer");
        private DHTOperationListener delegate;
        private boolean complete_fired;
        private boolean complete_included_ok;
        private int complete_count = 0;

        protected DHTOperationListenerDemuxer(DHTOperationListener _delegate) {
            this.delegate = _delegate;
            if (this.delegate == null) {
                Debug.out("invalid: null delegate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementCompletes() {
            try {
                this.this_mon.enter();
                ++this.complete_count;
                Object var2_1 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }

        public void searching(DHTTransportContact contact, int level, int active_searches) {
            this.delegate.searching(contact, level, active_searches);
        }

        public boolean diversified(String desc) {
            return this.delegate.diversified(desc);
        }

        public void found(DHTTransportContact contact, boolean is_closest) {
            this.delegate.found(contact, is_closest);
        }

        public void read(DHTTransportContact contact, DHTTransportValue value) {
            this.delegate.read(contact, value);
        }

        public void wrote(DHTTransportContact contact, DHTTransportValue value) {
            this.delegate.wrote(contact, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(boolean timeout) {
            boolean fire = false;
            try {
                this.this_mon.enter();
                if (!timeout) {
                    this.complete_included_ok = true;
                }
                --this.complete_count;
                if (this.complete_count <= 0 && !this.complete_fired) {
                    this.complete_fired = true;
                    fire = true;
                }
                Object var4_3 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (fire) {
                this.delegate.complete(!this.complete_included_ok);
            }
        }
    }

    protected static class DHTTransportFindValueReplyImpl
    implements DHTTransportFindValueReply {
        private byte dt = 1;
        private DHTTransportValue[] values;
        private DHTTransportContact[] contacts;
        private byte[] blocked_key;
        private byte[] blocked_sig;

        protected DHTTransportFindValueReplyImpl(byte _dt, DHTTransportValue[] _values) {
            this.dt = _dt;
            this.values = _values;
            boolean copied = false;
            for (int i = 0; i < this.values.length; ++i) {
                DHTTransportValue value = this.values[i];
                if ((value.getFlags() & 0x10) == 0) continue;
                if (!copied) {
                    this.values = new DHTTransportValue[_values.length];
                    System.arraycopy(_values, 0, this.values, 0, this.values.length);
                    copied = true;
                }
                this.values[i] = new anonValue(value);
            }
        }

        protected DHTTransportFindValueReplyImpl(DHTTransportContact[] _contacts) {
            this.contacts = _contacts;
        }

        protected DHTTransportFindValueReplyImpl(byte[] _blocked_key, byte[] _blocked_sig) {
            this.blocked_key = _blocked_key;
            this.blocked_sig = _blocked_sig;
        }

        public byte getDiversificationType() {
            return this.dt;
        }

        public boolean hit() {
            return this.values != null;
        }

        public boolean blocked() {
            return this.blocked_key != null;
        }

        public DHTTransportValue[] getValues() {
            return this.values;
        }

        public DHTTransportContact[] getContacts() {
            return this.contacts;
        }

        public byte[] getBlockedKey() {
            return this.blocked_key;
        }

        public byte[] getBlockedSignature() {
            return this.blocked_sig;
        }
    }

    protected static class DHTTransportStoreReplyImpl
    implements DHTTransportStoreReply {
        private byte[] divs;
        private byte[] block_request;
        private byte[] block_sig;

        protected DHTTransportStoreReplyImpl(byte[] _divs) {
            this.divs = _divs;
        }

        protected DHTTransportStoreReplyImpl(byte[] _bk, byte[] _bs) {
            this.block_request = _bk;
            this.block_sig = _bs;
        }

        public byte[] getDiversificationTypes() {
            return this.divs;
        }

        public boolean blocked() {
            return this.block_request != null;
        }

        public byte[] getBlockRequest() {
            return this.block_request;
        }

        public byte[] getBlockSignature() {
            return this.block_sig;
        }
    }

    protected abstract class DhtTask
    extends ThreadPoolTask {
        private controlActivity activity;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DhtTask(ThreadPool thread_pool) {
            this.activity = new controlActivity(thread_pool, this);
            try {
                DHTControlImpl.this.activity_mon.enter();
                DHTControlImpl.this.activities.add(this.activity);
                DHTControlImpl.this.listeners.dispatch(1, this.activity);
                Object var4_3 = null;
                DHTControlImpl.this.activity_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                DHTControlImpl.this.activity_mon.exit();
                throw throwable;
            }
        }

        public void taskStarted() {
            DHTControlImpl.this.listeners.dispatch(2, this.activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskCompleted() {
            try {
                DHTControlImpl.this.activity_mon.enter();
                DHTControlImpl.this.activities.remove(this.activity);
                DHTControlImpl.this.listeners.dispatch(3, this.activity);
                Object var2_1 = null;
                DHTControlImpl.this.activity_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DHTControlImpl.this.activity_mon.exit();
                throw throwable;
            }
        }

        public void interruptTask() {
        }

        protected abstract void cancel();

        public abstract byte[] getTarget();

        public abstract String getDescription();

        public abstract DHTControlActivity.ActivityState getCurrentState();
    }

    protected static class DhtTaskSet {
        private boolean cancelled;
        private Object things;

        protected DhtTaskSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(DhtTask task2) {
            DhtTaskSet dhtTaskSet = this;
            synchronized (dhtTaskSet) {
                if (this.cancelled) {
                    task2.cancel();
                    return;
                }
                this.addToThings(task2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(DhtTaskSet task_set) {
            DhtTaskSet dhtTaskSet = this;
            synchronized (dhtTaskSet) {
                if (this.cancelled) {
                    task_set.cancel();
                    return;
                }
                this.addToThings(task_set);
            }
        }

        private void addToThings(Object obj) {
            if (this.things == null) {
                this.things = obj;
            } else if (this.things instanceof List) {
                ((List)this.things).add(obj);
            } else {
                ArrayList<Object> l = new ArrayList<Object>(2);
                l.add(this.things);
                l.add(obj);
                this.things = l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object to_cancel;
            DhtTaskSet dhtTaskSet = this;
            synchronized (dhtTaskSet) {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                to_cancel = this.things;
                this.things = null;
            }
            if (to_cancel != null) {
                if (to_cancel instanceof DhtTask) {
                    ((DhtTask)to_cancel).cancel();
                } else if (to_cancel instanceof DhtTaskSet) {
                    ((DhtTaskSet)to_cancel).cancel();
                } else {
                    List l = (List)to_cancel;
                    for (int i = 0; i < l.size(); ++i) {
                        Object o = l.get(i);
                        if (o instanceof DhtTask) {
                            ((DhtTask)o).cancel();
                            continue;
                        }
                        ((DhtTaskSet)o).cancel();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCancelled() {
            DhtTaskSet dhtTaskSet = this;
            synchronized (dhtTaskSet) {
                return this.cancelled;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class anonContact
    implements DHTTransportContact {
        private static InetSocketAddress anon_address;
        private DHTTransportContact delegate;

        protected anonContact(DHTTransportContact c) {
            this.delegate = c;
        }

        @Override
        public int getMaxFailForLiveCount() {
            return this.delegate.getMaxFailForLiveCount();
        }

        @Override
        public int getMaxFailForUnknownCount() {
            return this.delegate.getMaxFailForUnknownCount();
        }

        @Override
        public int getInstanceID() {
            return this.delegate.getInstanceID();
        }

        @Override
        public byte[] getID() {
            Debug.out("hmm");
            return this.delegate.getID();
        }

        @Override
        public byte getProtocolVersion() {
            return this.delegate.getProtocolVersion();
        }

        @Override
        public long getClockSkew() {
            return this.delegate.getClockSkew();
        }

        @Override
        public int getRandomIDType() {
            return this.delegate.getRandomIDType();
        }

        @Override
        public void setRandomID(int id) {
            this.delegate.setRandomID(id);
        }

        @Override
        public int getRandomID() {
            return this.delegate.getRandomID();
        }

        @Override
        public void setRandomID2(byte[] id) {
            this.delegate.setRandomID2(id);
        }

        @Override
        public byte[] getRandomID2() {
            return this.delegate.getRandomID2();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public byte[] getBloomKey() {
            return this.delegate.getBloomKey();
        }

        @Override
        public InetSocketAddress getAddress() {
            return anon_address;
        }

        @Override
        public InetSocketAddress getTransportAddress() {
            return this.getAddress();
        }

        @Override
        public InetSocketAddress getExternalAddress() {
            return this.getAddress();
        }

        @Override
        public Map<String, Object> exportContactToMap() {
            return this.delegate.exportContactToMap();
        }

        @Override
        public boolean isAlive(long timeout) {
            return this.delegate.isAlive(timeout);
        }

        @Override
        public void isAlive(DHTTransportReplyHandler handler, long timeout) {
            this.delegate.isAlive(handler, timeout);
        }

        @Override
        public boolean isValid() {
            return this.delegate.isValid();
        }

        @Override
        public boolean isSleeping() {
            return this.delegate.isSleeping();
        }

        @Override
        public void sendPing(DHTTransportReplyHandler handler) {
            this.delegate.sendPing(handler);
        }

        @Override
        public void sendImmediatePing(DHTTransportReplyHandler handler, long timeout) {
            this.delegate.sendImmediatePing(handler, timeout);
        }

        @Override
        public void sendStats(DHTTransportReplyHandler handler) {
            this.delegate.sendStats(handler);
        }

        @Override
        public void sendStore(DHTTransportReplyHandler handler, byte[][] keys, DHTTransportValue[][] value_sets, boolean immediate) {
            this.delegate.sendStore(handler, keys, value_sets, immediate);
        }

        @Override
        public void sendQueryStore(DHTTransportReplyHandler handler, int header_length, List<Object[]> key_details) {
            this.delegate.sendQueryStore(handler, header_length, key_details);
        }

        @Override
        public void sendFindNode(DHTTransportReplyHandler handler, byte[] id, short flags) {
            this.delegate.sendFindNode(handler, id, flags);
        }

        @Override
        public void sendFindValue(DHTTransportReplyHandler handler, byte[] key, int max_values, short flags) {
            this.delegate.sendFindValue(handler, key, max_values, flags);
        }

        @Override
        public void sendKeyBlock(DHTTransportReplyHandler handler, byte[] key_block_request, byte[] key_block_signature) {
            this.delegate.sendKeyBlock(handler, key_block_request, key_block_signature);
        }

        @Override
        public DHTTransportFullStats getStats() {
            return this.delegate.getStats();
        }

        @Override
        public void exportContact(DataOutputStream os) throws IOException, DHTTransportException {
            this.delegate.exportContact(os);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void createNetworkPositions(boolean is_local) {
            this.delegate.createNetworkPositions(is_local);
        }

        @Override
        public DHTNetworkPosition[] getNetworkPositions() {
            return this.delegate.getNetworkPositions();
        }

        @Override
        public DHTNetworkPosition getNetworkPosition(byte position_type) {
            return this.delegate.getNetworkPosition(position_type);
        }

        @Override
        public DHTTransport getTransport() {
            return this.delegate.getTransport();
        }

        @Override
        public String getString() {
            return this.delegate.getString();
        }

        static {
            try {
                anon_address = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected static class anonValue
    implements DHTTransportValue {
        private DHTTransportValue delegate;

        protected anonValue(DHTTransportValue v) {
            this.delegate = v;
        }

        public boolean isLocal() {
            return this.delegate.isLocal();
        }

        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public byte[] getValue() {
            return this.delegate.getValue();
        }

        public int getVersion() {
            return this.delegate.getVersion();
        }

        public DHTTransportContact getOriginator() {
            return new anonContact(this.delegate.getOriginator());
        }

        public int getFlags() {
            return this.delegate.getFlags();
        }

        public int getLifeTimeHours() {
            return this.delegate.getLifeTimeHours();
        }

        public byte getReplicationControl() {
            return this.delegate.getReplicationControl();
        }

        public byte getReplicationFactor() {
            return this.delegate.getReplicationFactor();
        }

        public byte getReplicationFrequencyHours() {
            return this.delegate.getReplicationFrequencyHours();
        }

        public String getString() {
            return this.delegate.getString();
        }
    }

    protected class controlActivity
    implements DHTControlActivity {
        protected ThreadPool tp;
        protected DhtTask task;
        protected int type;

        protected controlActivity(ThreadPool _tp, DhtTask _task) {
            this.tp = _tp;
            this.task = _task;
            this.type = _tp == DHTControlImpl.this.internal_lookup_pool ? 1 : (_tp == DHTControlImpl.this.external_lookup_pool ? 2 : (_tp == DHTControlImpl.this.internal_put_pool ? 3 : 4));
        }

        public byte[] getTarget() {
            return this.task.getTarget();
        }

        public String getDescription() {
            return this.task.getDescription();
        }

        public int getType() {
            return this.type;
        }

        public boolean isQueued() {
            return this.tp.isQueued(this.task);
        }

        public DHTControlActivity.ActivityState getCurrentState() {
            return this.task.getCurrentState();
        }

        public String getString() {
            return this.type + ":" + DHTLog.getString(this.getTarget()) + "/" + this.getDescription() + ", q = " + this.isQueued();
        }
    }

    static abstract class lookupResultHandler
    extends DHTOperationListenerDemuxer {
        protected lookupResultHandler(DHTOperationListener delegate) {
            super(delegate);
        }

        public abstract void closest(List var1);

        public abstract void diversify(DHTTransportContact var1, byte var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class sortedTransportContactSet {
        private TreeSet<DHTTransportContact> tree_set;
        private byte[] pivot;
        private boolean ascending;

        protected sortedTransportContactSet(byte[] _pivot, boolean _ascending) {
            this.pivot = _pivot;
            this.ascending = _ascending;
            this.tree_set = new TreeSet<DHTTransportContact>(new Comparator<DHTTransportContact>(){

                @Override
                public int compare(DHTTransportContact t1, DHTTransportContact t2) {
                    int distance = DHTControlImpl.computeAndCompareDistances2(t1.getID(), t2.getID(), sortedTransportContactSet.this.pivot);
                    if (sortedTransportContactSet.this.ascending) {
                        return distance;
                    }
                    return -distance;
                }
            });
        }

        public Set<DHTTransportContact> getSet() {
            return this.tree_set;
        }
    }
}

