/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionView;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

public class SubscriptionMDIEntry
implements SubscriptionListener,
ViewTitleInfo {
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String AUTH_IMAGE_ID = "image.sidebar.vitality.auth";
    private final MdiEntry mdiEntry;
    MdiEntryVitalityImage spinnerImage;
    private MdiEntryVitalityImage warningImage;
    private final Subscription subs;
    private String key;

    public SubscriptionMDIEntry(Subscription subs, MdiEntry entry) {
        this.subs = subs;
        this.mdiEntry = entry;
        this.key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        this.setupMdiEntry();
    }

    private void setupMdiEntry() {
        if (this.mdiEntry == null) {
            return;
        }
        this.mdiEntry.setViewTitleInfo(this);
        this.mdiEntry.setImageLeftID("image.sidebar.subscriptions");
        this.warningImage = this.mdiEntry.addVitalityImage(ALERT_IMAGE_ID);
        this.spinnerImage = this.mdiEntry.addVitalityImage("image.sidebar.vitality.dots");
        if (this.spinnerImage != null) {
            this.spinnerImage.setVisible(false);
        }
        this.setWarning();
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menu_manager = uim.getMenuManager();
        SubscriptionManagerUI.MenuCreator menu_creator = new SubscriptionManagerUI.MenuCreator(){

            public MenuItem createMenu(String resource_id) {
                return menu_manager.addMenuItem("sidebar." + SubscriptionMDIEntry.this.key, resource_id);
            }

            public void refreshView() {
                SubscriptionMDIEntry.this.refreshView();
            }
        };
        SubscriptionManagerUI.createMenus(menu_manager, menu_creator, this.subs);
        this.subs.addListener(this);
    }

    public void subscriptionDownloaded(Subscription subs, boolean auto) {
    }

    public void subscriptionChanged(Subscription subs) {
        this.mdiEntry.redraw();
        ViewTitleInfoManager.refreshTitleInfo(this.mdiEntry.getViewTitleInfo());
    }

    protected void refreshView() {
        if (!(this.mdiEntry instanceof BaseMdiEntry)) {
            return;
        }
        UISWTViewEventListener eventListener = ((BaseMdiEntry)this.mdiEntry).getEventListener();
        if (eventListener instanceof SubscriptionView) {
            SubscriptionView subsView = (SubscriptionView)eventListener;
            subsView.refreshView();
        }
    }

    protected void setWarning() {
        boolean trouble;
        if (this.warningImage == null) {
            return;
        }
        SubscriptionHistory history = this.subs.getHistory();
        String last_error = history.getLastError();
        boolean auth_fail = history.isAuthFail();
        if (history.getConsecFails() < 3 && !auth_fail) {
            last_error = null;
        }
        boolean bl = trouble = last_error != null;
        if (trouble) {
            this.warningImage.setToolTip(last_error);
            this.warningImage.setImageID(auth_fail ? AUTH_IMAGE_ID : ALERT_IMAGE_ID);
            this.warningImage.setVisible(true);
        } else {
            this.warningImage.setVisible(false);
            this.warningImage.setToolTip("");
        }
    }

    public Object getTitleInfoProperty(int propertyID) {
        switch (propertyID) {
            case 5: {
                return this.subs.getName();
            }
            case 1: {
                long pop = this.subs.getCachedPopularity();
                String res = this.subs.getName();
                if (pop > 1L) {
                    res = res + " (" + MessageText.getString("subscriptions.listwindow.popularity").toLowerCase() + "=" + pop + ")";
                }
                return res;
            }
            case 0: {
                SubscriptionMDIEntry mdi = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
                if (mdi != null) {
                    mdi.setWarning();
                }
                if (this.subs.getHistory().getNumUnread() > 0) {
                    return "" + this.subs.getHistory().getNumUnread();
                }
                return null;
            }
        }
        return null;
    }

    protected void removeWithConfirm() {
        SubscriptionManagerUI.removeWithConfirm(this.subs);
    }
}

