/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class ConfigurationChecker {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static boolean system_properties_set = false;
    private static boolean checked = false;
    private static boolean new_install = false;
    private static AEMonitor class_mon = new AEMonitor("ConfigChecker");
    private static boolean new_version = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setSystemProperties() {
        try {
            class_mon.enter();
            if (system_properties_set) {
                Object var9 = null;
                class_mon.exit();
                return;
            }
            COConfigurationManager.preInitialise();
            String app_path = SystemProperties.getApplicationPath();
            String user_path = SystemProperties.getUserPath();
            ConfigurationChecker.loadProperties(app_path);
            if (!app_path.equals(user_path)) {
                ConfigurationChecker.loadProperties(user_path);
            }
            COConfigurationManager.addAndFireParameterListener("IPV6 Prefer Addresses", new ParameterListener(){
                private boolean done_something = false;

                public void parameterChanged(String name) {
                    boolean existing;
                    boolean prefer_ipv6 = COConfigurationManager.getBooleanParameter(name);
                    boolean bl = existing = !System.getProperty("java.net.preferIPv6Addresses", "false").equalsIgnoreCase("false");
                    if (existing && !this.done_something) {
                        return;
                    }
                    if (existing != prefer_ipv6) {
                        this.done_something = true;
                        System.setProperty("java.net.preferIPv6Addresses", prefer_ipv6 ? "true" : "false");
                        try {
                            Field field = InetAddress.class.getDeclaredField("preferIPv6Address");
                            field.setAccessible(true);
                            field.setBoolean(null, prefer_ipv6);
                        }
                        catch (Throwable e) {
                            Debug.out("Failed to update 'preferIPv6Address'", e);
                        }
                    }
                }
            });
            if (Constants.isWindowsVistaOrHigher && Constants.isJava7OrHigher) {
                COConfigurationManager.addAndFireParameterListener("IPV4 Prefer Stack", new ParameterListener(){
                    private boolean done_something = false;

                    public void parameterChanged(String name) {
                        boolean existing;
                        boolean prefer_ipv4 = COConfigurationManager.getBooleanParameter(name);
                        boolean bl = existing = !System.getProperty("java.net.preferIPv4Stack", "false").equalsIgnoreCase("false");
                        if (existing && !this.done_something) {
                            return;
                        }
                        if (existing != prefer_ipv4) {
                            this.done_something = true;
                            System.setProperty("java.net.preferIPv4Stack", prefer_ipv4 ? "true" : "false");
                            try {
                                this.getClass();
                                Class<?> plainSocketImpl = Class.forName("java.net.PlainSocketImpl");
                                Field pref_field = plainSocketImpl.getDeclaredField("preferIPv4Stack");
                                pref_field.setAccessible(true);
                                pref_field.setBoolean(null, prefer_ipv4);
                                Field dual_field = plainSocketImpl.getDeclaredField("useDualStackImpl");
                                dual_field.setAccessible(true);
                                dual_field.setBoolean(null, !prefer_ipv4);
                            }
                            catch (Throwable e) {
                                Debug.out("Failed to update 'preferIPv4Stack'", e);
                            }
                        }
                    }
                });
            }
            int connect_timeout = COConfigurationManager.getIntParameter("Tracker Client Connect Timeout");
            int read_timeout = COConfigurationManager.getIntParameter("Tracker Client Read Timeout");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerClient: connect timeout = " + connect_timeout + ", read timeout = " + read_timeout));
            }
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(connect_timeout * 1000));
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(read_timeout * 1000));
            if (COConfigurationManager.getBooleanParameter("Enable.Proxy")) {
                String host = COConfigurationManager.getStringParameter("Proxy.Host");
                String port = COConfigurationManager.getStringParameter("Proxy.Port");
                String user = COConfigurationManager.getStringParameter("Proxy.Username");
                String pass = COConfigurationManager.getStringParameter("Proxy.Password");
                if (user.trim().equalsIgnoreCase("<none>")) {
                    user = "";
                }
                if (COConfigurationManager.getBooleanParameter("Enable.SOCKS")) {
                    System.setProperty("socksProxyHost", host);
                    System.setProperty("socksProxyPort", port);
                    if (user.length() > 0) {
                        System.setProperty("java.net.socks.username", user);
                        System.setProperty("java.net.socks.password", pass);
                    }
                } else {
                    System.setProperty("http.proxyHost", host);
                    System.setProperty("http.proxyPort", port);
                    System.setProperty("https.proxyHost", host);
                    System.setProperty("https.proxyPort", port);
                    if (user.length() > 0) {
                        System.setProperty("http.proxyUser", user);
                        System.setProperty("http.proxyPassword", pass);
                    }
                }
            }
            SESecurityManager.initialise();
        }
        catch (Throwable throwable) {
            Object var9_2 = null;
            class_mon.exit();
            throw throwable;
        }
        Object var9_1 = null;
        class_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadProperties(String dir) {
        block5: {
            try {
                File prop_file = new File(dir, "azureus.properties");
                if (!prop_file.exists()) break block5;
                Logger.log(new LogEvent(LOGID, "Loading properties file from " + prop_file.getAbsolutePath()));
                Properties props = new Properties();
                FileInputStream is = new FileInputStream(prop_file);
                try {
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        Logger.log(new LogEvent(LOGID, "    " + key + "=" + value));
                        System.setProperty(key, value);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConfiguration() {
        try {
            int check_level;
            int cache_max;
            String uniqueId;
            int iIgnoreSPRatio;
            int iDLMin;
            int iSeedingMin;
            int minQueueingShareRatio;
            int peersRatio;
            int tcp_port;
            boolean randomize_ports;
            int udp2;
            int udp1;
            String this_version;
            class_mon.enter();
            if (checked) {
                Object var24 = null;
                class_mon.exit();
                return;
            }
            checked = true;
            boolean changed = CustomizationManagerFactory.getSingleton().preInitialize();
            String last_version = COConfigurationManager.getStringParameter("azureus.version", "");
            if (!last_version.equals(this_version = "5.5.0.1_B33")) {
                if (!Constants.getBaseVersion(last_version).equals(Constants.getBaseVersion())) {
                    COConfigurationManager.setParameter("Last Version", last_version);
                    new_version = true;
                }
                if (!COConfigurationManager.hasParameter("First Recorded Version", true)) {
                    COConfigurationManager.setParameter("First Recorded Version", last_version.length() == 0 ? this_version : last_version);
                } else {
                    String sMinVersion;
                    String sFirstVersion = COConfigurationManager.getStringParameter("First Recorded Version");
                    String string = sMinVersion = Constants.compareVersions(sFirstVersion, this_version) > 0 ? this_version : sFirstVersion;
                    if (last_version.length() > 0) {
                        sMinVersion = Constants.compareVersions(sMinVersion, last_version) > 0 ? last_version : sMinVersion;
                    }
                    COConfigurationManager.setParameter("First Recorded Version", sMinVersion);
                }
                COConfigurationManager.setParameter("azureus.version", this_version);
                changed = true;
            }
            if (last_version.length() == 0) {
                new_install = true;
                if (COConfigurationManager.doesParameterNonDefaultExist("diagnostics.tidy_close") && !COConfigurationManager.doesParameterNonDefaultExist("Tracker Port Enable")) {
                    COConfigurationManager.setParameter("Tracker Port Enable", true);
                    changed = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("User Mode")) {
                    COConfigurationManager.setParameter("User Mode", 0);
                    changed = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("TCP.Listen.Port")) {
                    int rand_port = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter("TCP.Listen.Port", rand_port);
                    COConfigurationManager.setParameter("UDP.Listen.Port", rand_port);
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", rand_port);
                    changed = true;
                }
            } else {
                if (COConfigurationManager.getBooleanParameter("network.tcp.enable_safe_selector_mode") && (!Constants.isWindows || !Constants.JAVA_VERSION.startsWith("1.4") && !Constants.JAVA_VERSION.startsWith("1.5"))) {
                    COConfigurationManager.removeParameter("network.tcp.enable_safe_selector_mode");
                    changed = true;
                }
                if (COConfigurationManager.doesParameterNonDefaultExist("TCP.Announce.Port")) {
                    COConfigurationManager.setParameter("TCP.Listen.Port.Override", COConfigurationManager.getStringParameter("TCP.Announce.Port", ""));
                    COConfigurationManager.removeParameter("TCP.Announce.Port");
                    changed = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("User Mode")) {
                    COConfigurationManager.setParameter("User Mode", 2);
                    changed = true;
                }
            }
            if (!COConfigurationManager.doesParameterNonDefaultExist("UDP.Listen.Port")) {
                COConfigurationManager.setParameter("UDP.Listen.Port", COConfigurationManager.getIntParameter("TCP.Listen.Port"));
                changed = true;
            }
            if (!COConfigurationManager.getBooleanParameter("Plugin.DHT.dht.portdefault", true)) {
                COConfigurationManager.removeParameter("Plugin.DHT.dht.portdefault");
                int tcp_port2 = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                int udp_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                int dht_port = COConfigurationManager.getIntParameter("Plugin.DHT.dht.port", udp_port);
                if (dht_port != udp_port && tcp_port2 == udp_port) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", dht_port);
                }
                changed = true;
            }
            if (!COConfigurationManager.doesParameterNonDefaultExist("UDP.NonData.Listen.Port")) {
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", COConfigurationManager.getIntParameter("UDP.Listen.Port"));
                changed = true;
            }
            if ((udp1 = COConfigurationManager.getIntParameter("UDP.Listen.Port")) != (udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port"))) {
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp1);
                changed = true;
            }
            if (randomize_ports = COConfigurationManager.getBooleanParameter("Listen.Port.Randomize.Enable")) {
                boolean valid;
                String random_range = COConfigurationManager.getStringParameter("Listen.Port.Randomize.Range");
                random_range = random_range == null || random_range.trim().length() == 0 ? "10000-65535" : random_range.trim();
                int min_port = 10000;
                int max_port = 65535;
                String[] bits = random_range.split("-");
                boolean bl = valid = bits.length == 2;
                if (!valid) {
                    char[] chars = random_range.toCharArray();
                    for (int i = 0; i < chars.length - 1; ++i) {
                        if (Character.isDigit(chars[i])) continue;
                        bits = new String[]{random_range.substring(0, i), random_range.substring(i + 1)};
                        valid = true;
                        break;
                    }
                }
                if (valid) {
                    String rhs;
                    String lhs = bits[0].trim();
                    if (lhs.length() > 0) {
                        try {
                            min_port = Integer.parseInt(lhs);
                            valid = min_port > 0 && min_port < 65536;
                        }
                        catch (Throwable e) {
                            valid = false;
                        }
                    }
                    if ((rhs = bits[1].trim()).length() > 0) {
                        try {
                            max_port = Integer.parseInt(rhs);
                            valid = max_port > 0 && max_port < 65536;
                        }
                        catch (Throwable e) {
                            valid = false;
                        }
                    }
                }
                if (valid) {
                    boolean randomize_together = COConfigurationManager.getBooleanParameter("Listen.Port.Randomize.Together");
                    if (randomize_together) {
                        int port = RandomUtils.generateRandomNetworkListenPort(min_port, max_port);
                        COConfigurationManager.setParameter("TCP.Listen.Port", port);
                        COConfigurationManager.setParameter("UDP.Listen.Port", port);
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", port);
                    } else {
                        int old_udp1 = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                        int old_udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
                        int port1 = RandomUtils.generateRandomNetworkListenPort(min_port, max_port);
                        COConfigurationManager.setParameter("TCP.Listen.Port", port1);
                        int port2 = RandomUtils.generateRandomNetworkListenPort(min_port, max_port);
                        COConfigurationManager.setParameter("UDP.Listen.Port", port2);
                        if (old_udp1 == old_udp2) {
                            COConfigurationManager.setParameter("UDP.NonData.Listen.Port", port2);
                        } else {
                            int port3 = RandomUtils.generateRandomNetworkListenPort(min_port, max_port);
                            COConfigurationManager.setParameter("UDP.NonData.Listen.Port", port3);
                        }
                    }
                }
            }
            if ((tcp_port = COConfigurationManager.getIntParameter("TCP.Listen.Port")) == Constants.INSTANCE_PORT || tcp_port >= 45100 && tcp_port <= 45103) {
                int new_tcp_port = RandomUtils.generateRandomNetworkListenPort();
                COConfigurationManager.setParameter("TCP.Listen.Port", new_tcp_port);
                if (COConfigurationManager.getIntParameter("UDP.Listen.Port") == tcp_port) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", new_tcp_port);
                }
                if (COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port") == tcp_port) {
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", new_tcp_port);
                }
                changed = true;
            }
            if (!COConfigurationManager.doesParameterDefaultExist("Tracker Key Enable Client")) {
                boolean old_value = COConfigurationManager.getBooleanParameter("Tracker Key Enable");
                COConfigurationManager.setParameter("Tracker Key Enable Client", old_value);
                COConfigurationManager.setParameter("Tracker Key Enable Server", old_value);
                changed = true;
            }
            int maxUpSpeed = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0);
            int maxDownSpeed = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0);
            if (maxUpSpeed > 0 && maxUpSpeed < 5 && (maxDownSpeed == 0 || maxDownSpeed > 2 * maxUpSpeed)) {
                changed = true;
                COConfigurationManager.setParameter("Max Upload Speed KBs", 5);
            }
            if ((peersRatio = COConfigurationManager.getIntParameter("Stop Peers Ratio", 0)) > 14) {
                COConfigurationManager.setParameter("Stop Peers Ratio", 14);
                changed = true;
            }
            if ((minQueueingShareRatio = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ShareRatio")) < 500) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ShareRatio", 500);
                changed = true;
            }
            if ((iSeedingMin = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_SeedingMinutes")) < 90 && iSeedingMin != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_SeedingMinutes", 90);
                changed = true;
            }
            if ((iDLMin = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_DLMinutes")) < 180 && iDLMin != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_DLMinutes", 180);
                changed = true;
            }
            if ((iIgnoreSPRatio = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio")) < 10 && iIgnoreSPRatio != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ignoreSPRatio", 10);
                changed = true;
            }
            if ((uniqueId = COConfigurationManager.getStringParameter("ID", null)) == null || uniqueId.length() != 20) {
                uniqueId = RandomUtils.generateRandomAlphanumerics(20);
                COConfigurationManager.setParameter("ID", uniqueId);
                changed = true;
            }
            if ((cache_max = COConfigurationManager.getIntParameter("diskmanager.perf.cache.size")) > COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB) {
                COConfigurationManager.setParameter("diskmanager.perf.cache.size", COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB);
                changed = true;
            }
            if (cache_max < 1) {
                COConfigurationManager.setParameter("diskmanager.perf.cache.size", 4);
                changed = true;
            }
            if (Constants.isOSX) {
                boolean sound = COConfigurationManager.getBooleanParameter("Play Download Finished", true);
                boolean confirmExit = COConfigurationManager.getBooleanParameter("confirmationOnExit");
                if (sound || confirmExit) {
                    COConfigurationManager.setParameter("Play Download Finished", false);
                    COConfigurationManager.setParameter("confirmationOnExit", false);
                    changed = true;
                }
            }
            if (Constants.isOSX) {
                if (COConfigurationManager.getBooleanParameter("enable_small_osx_fonts")) {
                    System.setProperty("org.eclipse.swt.internal.carbon.smallFonts", "1");
                } else {
                    System.getProperties().remove("org.eclipse.swt.internal.carbon.smallFonts");
                }
                System.setProperty("org.eclipse.swt.internal.carbon.noFocusRing", "1");
            }
            String[] path_params = new String[]{"Default save path", "General_sDefaultTorrent_Directory", "Watch Torrent Folder Path", "Completed Files Directory"};
            for (int i = 0; i < path_params.length; ++i) {
                if (!path_params[i].endsWith(SystemProperties.SEP)) continue;
                String new_path = path_params[i].substring(0, path_params[i].length() - 1);
                COConfigurationManager.setParameter(path_params[i], new_path);
                changed = true;
            }
            if (ConfigurationManager.getInstance().doesParameterNonDefaultExist("General_bEnableLanguageUpdate")) {
                File user_dir = new File(SystemProperties.getUserPath());
                File[] files = user_dir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("MessagesBundle") && name.endsWith(".properties");
                    }
                });
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (!file.exists()) continue;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "ConfigurationChecker:: removing old language file: " + file.getAbsolutePath()));
                        }
                        file.renameTo(new File(file.getParentFile(), "delme" + file.getName()));
                    }
                }
                ConfigurationManager.getInstance().removeParameter("General_bEnableLanguageUpdate");
                changed = true;
            }
            String CFG_CONFIRM_DELETE_CONTENT = "confirm.delete.content";
            if (ConfigurationManager.getInstance().doesParameterNonDefaultExist("confirm.delete.content")) {
                boolean confirm = COConfigurationManager.getBooleanParameter("confirm.delete.content");
                if (!confirm && !ConfigurationManager.getInstance().doesParameterNonDefaultExist("tb.confirm.delete.content")) {
                    COConfigurationManager.setParameter("tb.confirm.delete.content", 1);
                }
                COConfigurationManager.removeParameter("confirm.delete.content");
                changed = true;
            }
            if (FeatureAvailability.isAutoSpeedDefaultClassic()) {
                ConfigurationDefaults.getInstance().addParameter("Auto Upload Speed Version", 1);
            }
            if ((check_level = COConfigurationManager.getIntParameter("config.checker.level", 0)) < 1) {
                COConfigurationManager.setParameter("config.checker.level", 1);
                changed = true;
                String[] params = new String[]{"Max Uploads", "enable.seedingonly.maxuploads", "Max Uploads Seeding", "Max.Peer.Connections.Per.Torrent", "Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", "Max.Peer.Connections.Per.Torrent.When.Seeding", "Max.Peer.Connections.Total", "Max Seeds Per Torrent"};
                boolean has_been_set = false;
                for (String param : params) {
                    if (!COConfigurationManager.doesParameterNonDefaultExist(param)) continue;
                    has_been_set = true;
                    break;
                }
                if (has_been_set) {
                    COConfigurationManager.setParameter("Auto Adjust Transfer Defaults", false);
                }
            }
            if (Constants.isOSX && check_level < 2) {
                COConfigurationManager.setParameter("config.checker.level", 2);
                changed = true;
                if (!COConfigurationManager.getBooleanParameter("Zero New")) {
                    COConfigurationManager.setParameter("Enable reorder storage mode", true);
                }
            }
            if (COConfigurationManager.doesParameterNonDefaultExist("Watch Torrent Folder Interval")) {
                long mins = COConfigurationManager.getIntParameter("Watch Torrent Folder Interval");
                COConfigurationManager.removeParameter("Watch Torrent Folder Interval");
                COConfigurationManager.setParameter("Watch Torrent Folder Interval Secs", 60L * mins);
                changed = true;
            }
            if (changed) {
                COConfigurationManager.save();
            }
            ConfigurationChecker.setupVerifier();
        }
        catch (Throwable throwable) {
            Object var24_2 = null;
            class_mon.exit();
            throw throwable;
        }
        Object var24_1 = null;
        class_mon.exit();
        ConfigurationDefaults.getInstance().runVerifiers();
    }

    private static void setupVerifier() {
        SimpleTimer.addEvent("ConfigCheck:ver", SystemTime.getOffsetTime(10000L), new TimerEventPerformer(){
            private TimerEventPeriodic event;

            public void perform(TimerEvent ev) {
                long freq;
                ConfigurationChecker.runVerifier();
                if (this.event == null && (freq = COConfigurationManager.getLongParameter("Config Verify Frequency")) > 0L) {
                    freq = Math.max(freq, 300000L);
                    this.event = SimpleTimer.addPeriodicEvent("ConfigCheck:ver", freq, this);
                }
            }
        });
    }

    private static void runVerifier() {
        try {
            boolean auto_reg;
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            if (pm.hasCapability(PlatformManagerCapabilities.RunAtLogin)) {
                boolean start_on_login = COConfigurationManager.getBooleanParameter("Start On Login");
                if (pm.getRunAtLogin() != start_on_login) {
                    pm.setRunAtLogin(start_on_login);
                }
            }
            if (pm.hasCapability(PlatformManagerCapabilities.RegisterFileAssociations) && (auto_reg = COConfigurationManager.getBooleanParameter("Auto Register App"))) {
                pm.registerApplication();
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public static final boolean isNewInstall() {
        return new_install;
    }

    public static final boolean isNewVersion() {
        return new_version;
    }
}

