/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging;

import java.io.PrintStream;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.logging.impl.LoggerImpl;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class Logger {
    private static final LogIDs LOGID = LogIDs.LOGGER;
    private static LoggerImpl loggerImpl = null;
    private static FileLogging fileLogging = new FileLogging();

    public static boolean isEnabled() {
        return loggerImpl.isEnabled();
    }

    public static void log(LogEvent event2) {
        loggerImpl.log(event2);
    }

    public static void log(LogAlert alert) {
        loggerImpl.log(alert);
    }

    public static void logTextResource(LogEvent event2) {
        loggerImpl.logTextResource(event2);
    }

    public static void logTextResource(LogEvent event2, String[] params) {
        loggerImpl.logTextResource(event2, params);
    }

    public static void logTextResource(LogAlert alert) {
        loggerImpl.logTextResource(alert);
    }

    public static void logTextResource(LogAlert alert, String[] params) {
        loggerImpl.logTextResource(alert, params);
    }

    public static void doRedirects() {
        loggerImpl.doRedirects();
    }

    public static void addListener(ILogEventListener aListener) {
        loggerImpl.addListener(aListener);
    }

    public static void addListener(ILogAlertListener aListener) {
        loggerImpl.addListener(aListener);
    }

    public static void removeListener(ILogEventListener aListener) {
        loggerImpl.removeListener(aListener);
    }

    public static void removeListener(ILogAlertListener aListener) {
        loggerImpl.removeListener(aListener);
    }

    public static PrintStream getOldStdErr() {
        return loggerImpl.getOldStdErr();
    }

    public static FileLogging getFileLoggingInstance() {
        return fileLogging;
    }

    public static void allowLoggingToStdErr(boolean allowed) {
        loggerImpl.allowLoggingToStdErr(allowed);
    }

    static {
        try {
            loggerImpl = new LoggerImpl();
            loggerImpl.init();
            fileLogging.initialize();
            if (loggerImpl.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "**** Logging starts: " + Constants.APP_NAME + " " + "5.5.0.1_B33" + " ****"));
                Logger.log(new LogEvent(LOGID, "java.home=" + System.getProperty("java.home")));
                Logger.log(new LogEvent(LOGID, "java.version=" + Constants.JAVA_VERSION));
                Logger.log(new LogEvent(LOGID, "os=" + System.getProperty("os.arch") + "/" + System.getProperty("os.name") + "/" + System.getProperty("os.version")));
                Logger.log(new LogEvent(LOGID, "user.dir=" + System.getProperty("user.dir")));
                Logger.log(new LogEvent(LOGID, "user.home=" + System.getProperty("user.home")));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Debug.out("Error initializing Logger", t);
        }
    }
}

