/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadStubImpl
implements DownloadStub {
    private final DownloadManagerImpl manager;
    private final String name;
    private final byte[] hash;
    private final long size;
    private final String save_path;
    private final DownloadStubFileImpl[] files;
    private final Map<String, Object> gm_map;
    private DownloadImpl temp_download;
    private Map<String, Object> attributes;

    protected DownloadStubImpl(DownloadManagerImpl _manager, DownloadImpl _download, Map<String, Object> _gm_map) {
        this.manager = _manager;
        this.temp_download = _download;
        this.name = this.temp_download.getName();
        Torrent torrent = this.temp_download.getTorrent();
        this.hash = torrent.getHash();
        this.size = torrent.getSize();
        this.save_path = this.temp_download.getSavePath();
        DownloadStub.DownloadStubFile[] _files = this.temp_download.getStubFiles();
        this.gm_map = _gm_map;
        this.files = new DownloadStubFileImpl[_files.length];
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = new DownloadStubFileImpl(_files[i]);
        }
    }

    protected DownloadStubImpl(DownloadManagerImpl _manager, Map<String, Object> _map) {
        this.manager = _manager;
        this.hash = (byte[])_map.get("hash");
        this.name = MapUtils.getMapString(_map, "name", null);
        this.size = MapUtils.getMapLong(_map, "s", 0L);
        this.save_path = MapUtils.getMapString(_map, "l", null);
        this.gm_map = (Map)_map.get("gm");
        List file_list = (List)_map.get("files");
        if (file_list == null) {
            this.files = new DownloadStubFileImpl[0];
        } else {
            this.files = new DownloadStubFileImpl[file_list.size()];
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i] = new DownloadStubFileImpl((Map)file_list.get(i));
            }
        }
        this.attributes = (Map)_map.get("attr");
    }

    public Map<String, Object> exportToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hash", this.hash);
        map.put("s", this.size);
        MapUtils.setMapString(map, "name", this.name);
        MapUtils.setMapString(map, "l", this.save_path);
        map.put("gm", this.gm_map);
        ArrayList<Map> file_list = new ArrayList<Map>();
        map.put("files", file_list);
        for (DownloadStubFileImpl file : this.files) {
            file_list.add(file.exportToMap());
        }
        if (this.attributes != null) {
            map.put("attr", this.attributes);
        }
        return map;
    }

    @Override
    public boolean isStub() {
        return true;
    }

    protected void setStubbified() {
        this.temp_download = null;
    }

    @Override
    public Download destubbify() throws DownloadException {
        if (this.temp_download != null) {
            return this.temp_download;
        }
        return this.manager.destubbify(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getTorrentHash() {
        return this.hash;
    }

    @Override
    public long getTorrentSize() {
        return this.size;
    }

    @Override
    public String getSavePath() {
        return this.save_path;
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        return this.files;
    }

    @Override
    public long getLongAttribute(TorrentAttribute attribute) {
        if (this.attributes == null) {
            return 0L;
        }
        Long l = (Long)this.attributes.get(attribute.getName());
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Override
    public void setLongAttribute(TorrentAttribute attribute, long value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(attribute.getName(), value);
        if (this.temp_download == null) {
            this.manager.updated(this);
        }
    }

    public Map getGMMap() {
        return this.gm_map;
    }

    @Override
    public void remove() {
        this.manager.remove(this);
    }

    protected static class DownloadStubFileImpl
    implements DownloadStub.DownloadStubFile {
        private final File file;
        private final long length;

        protected DownloadStubFileImpl(DownloadStub.DownloadStubFile stub_file) {
            this.file = stub_file.getFile();
            this.length = stub_file.getLength();
        }

        protected DownloadStubFileImpl(Map map) {
            this.file = new File(MapUtils.getMapString(map, "file", null));
            this.length = (Long)map.get("len");
        }

        protected Map exportToMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("file", this.file.getAbsolutePath());
            map.put("len", this.length);
            return map;
        }

        public File getFile() {
            return this.file;
        }

        public long getLength() {
            return this.length;
        }
    }
}

