/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;

public class PlatformDevicesMessenger {
    public static final String CFG_SEND_QOS = "devices.sendQOS";
    public static final String LISTENER_ID = "devices";
    private static final String OP_QOS_TURN_ON = "qos-turn-on";
    private static final String OP_QOS_FOUND_DEVICE = "qos-found-device";
    private static final String OP_REPORT_DEVICES = "report-devices";

    public static void qosTurnOn(boolean withITunes, boolean bugFix) {
        if (!COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_TURN_ON, new Object[]{"itunes", withITunes, "os-name", Constants.OSName + (bugFix ? ":BF" : "")}, 5000L);
        message.setSendAZID(false);
        PlatformMessenger.queueMessage(message, null);
    }

    public static void qosFoundDevice(final Device device) {
        if (device == null || !COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        if ("ms_wmp.generic".equals(device.getClassification())) {
            return;
        }
        SimpleTimer.addEvent("qosFoundDevice", SystemTime.getOffsetTime(1000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                PlatformDevicesMessenger._qosFoundDevice(device);
            }
        });
    }

    private static void _qosFoundDevice(Device device) {
        if (device == null || !COConfigurationManager.getBooleanParameter(CFG_SEND_QOS, false)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PlatformDevicesMessenger.addPluginVersionsToMap(map);
        map.put("device-name", PlatformDevicesMessenger.getDeviceName(device));
        map.put("device-type", new Integer(device.getType()));
        if (device instanceof DeviceMediaRenderer) {
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)device;
            map.put("renderer-species", renderer.getRendererSpecies());
        }
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_QOS_FOUND_DEVICE, map, 5000L);
        message.setSendAZID(false);
        PlatformMessenger.queueMessage(message, null);
    }

    private static void addPluginVersionsToMap(Map map) {
        if (AzureusCoreFactory.isCoreRunning()) {
            PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface pi = pm.getPluginInterfaceByID("vuzexcode");
            if (pi != null) {
                map.put("xcode-plugin-version", pi.getPluginVersion());
            }
            if ((pi = pm.getPluginInterfaceByID("azitunes")) != null) {
                map.put("itunes-plugin-version", pi.getPluginVersion());
            }
        }
        map.put("os-name", Constants.OSName);
    }

    private static String getDeviceName(Device device) {
        return device.getClassification();
    }
}

