/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeFile;
import java.util.Locale;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTJ_CopiedToDevice
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "copied";
    private String na_text;

    public ColumnTJ_CopiedToDevice(final TableColumn column) {
        column.initialize(3, -2, 50);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            public void localeChanged(Locale old_locale, Locale new_locale) {
                ColumnTJ_CopiedToDevice.this.na_text = MessageText.getString("general.na.short");
                column.invalidateCells();
            }
        });
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        DeviceMediaRenderer dmr;
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null) {
            return;
        }
        Device d = tf.getDevice();
        String value = null;
        if (d instanceof DeviceMediaRenderer && !(dmr = (DeviceMediaRenderer)d).canCopyToDevice() && !dmr.canCopyToFolder()) {
            value = this.na_text;
        }
        if (value == null) {
            value = DisplayFormatters.getYesNo(tf.isCopiedToDevice());
        }
        if (cell.setSortValue((Comparable)((Object)value)) || !cell.isValid()) {
            cell.setText(value);
        }
    }
}

