/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.proxy.AEProxySelector;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import com.aelitis.net.udp.uc.PRUDPRequestHandler;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerImpl;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class PRUDPPacketHandlerSocks
implements PRUDPPacketHandler,
PRUDPPacketHandlerImpl.PacketTransformer {
    private static String socks_host;
    private static int socks_port;
    private static String socks_user;
    private static String socks_password;
    private final InetSocketAddress target;
    private Socket control_socket;
    private InetSocketAddress relay;
    private PRUDPPacketHandler delegate;
    private byte[] packet_out_header;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected PRUDPPacketHandlerSocks(InetSocketAddress _target) throws PRUDPPacketHandlerException {
        this.target = _target;
        boolean ok = false;
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        Proxy proxy = proxy_selector.getSOCKSProxy(socks_host, socks_port, this.target);
        boolean proxy_connected = false;
        Throwable error = null;
        try {
            block31: {
                try {
                    InetAddress relay_address;
                    this.delegate = new PRUDPPacketHandlerImpl(0, null, this);
                    this.control_socket = new Socket(Proxy.NO_PROXY);
                    InetSocketAddress proxy_address = (InetSocketAddress)proxy.address();
                    this.control_socket.connect(proxy_address);
                    proxy_connected = true;
                    DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(this.control_socket.getOutputStream(), 256));
                    DataInputStream dis = new DataInputStream(this.control_socket.getInputStream());
                    dos.writeByte(5);
                    dos.writeByte(2);
                    dos.writeByte(0);
                    dos.writeByte(2);
                    dos.flush();
                    dis.readByte();
                    byte method = dis.readByte();
                    if (method != 0 && method != 2) {
                        throw new IOException("SOCKS 5: no valid method [" + method + "]");
                    }
                    if (method == 2) {
                        dos.writeByte(1);
                        dos.writeByte((byte)socks_user.length());
                        dos.write(socks_user.getBytes());
                        dos.writeByte((byte)socks_password.length());
                        dos.write(socks_password.getBytes());
                        dos.flush();
                        dis.readByte();
                        byte status = dis.readByte();
                        if (status != 0) {
                            throw new IOException("SOCKS 5: authentication fails [status=" + status + "]");
                        }
                    }
                    String mapped_ip = this.target.isUnresolved() || this.target.getAddress() == null ? AEProxyFactory.getAddressMapper().internalise(this.target.getHostName()) : AddressUtils.getHostNameNoResolve(this.target);
                    dos.writeByte(5);
                    dos.writeByte(3);
                    dos.writeByte(0);
                    dos.writeByte(1);
                    dos.write(new byte[4]);
                    dos.writeShort((short)this.delegate.getPort());
                    dos.flush();
                    dis.readByte();
                    byte reply = dis.readByte();
                    if (reply != 0) {
                        block30: {
                            if (reply != 69) throw new IOException("SOCKS 5: udp association fails [reply=" + reply + "]");
                            if (!proxy_address.getAddress().isLoopbackAddress()) throw new IOException("SOCKS 5: udp association fails [reply=" + reply + "]");
                            this.control_socket.close();
                            this.control_socket = null;
                            ok = true;
                            Object var20_15 = null;
                            if (!proxy_connected) {
                                proxy_selector.connectFailed(proxy, error);
                            }
                            if (ok) return;
                            try {
                                try {
                                    this.control_socket.close();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    Object var23_19 = null;
                                    this.control_socket = null;
                                    break block30;
                                }
                                Object var23_18 = null;
                                this.control_socket = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_20 = null;
                                this.control_socket = null;
                                throw throwable;
                            }
                        }
                        if (this.delegate == null) return;
                        try {
                            this.delegate.destroy();
                            Object var25_33 = null;
                            this.delegate = null;
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var25_34 = null;
                            this.delegate = null;
                            throw throwable;
                        }
                    }
                    dis.readByte();
                    byte atype = dis.readByte();
                    if (atype == 1) {
                        byte[] bytes = new byte[4];
                        dis.readFully(bytes);
                        relay_address = InetAddress.getByAddress(bytes);
                    } else if (atype == 3) {
                        byte len = dis.readByte();
                        byte[] bytes = new byte[len & 0xFF];
                        dis.readFully(bytes);
                        relay_address = InetAddress.getByName(new String(bytes));
                    } else {
                        byte[] bytes = new byte[16];
                        dis.readFully(bytes);
                        relay_address = InetAddress.getByAddress(bytes);
                    }
                    int relay_port = dis.readByte() << 8 & 0xFF00 | dis.readByte() & 0xFF;
                    if (relay_address.isAnyLocalAddress()) {
                        relay_address = this.control_socket.getInetAddress();
                    }
                    this.relay = new InetSocketAddress(relay_address, relay_port);
                    ByteArrayOutputStream baos_temp = new ByteArrayOutputStream();
                    DataOutputStream dos_temp = new DataOutputStream(baos_temp);
                    dos_temp.writeByte(0);
                    dos_temp.writeByte(0);
                    dos_temp.writeByte(0);
                    try {
                        byte[] ip_bytes = HostNameToIPResolver.syncResolve(mapped_ip).getAddress();
                        dos_temp.writeByte(ip_bytes.length == 4 ? 1 : 4);
                        dos_temp.write(ip_bytes);
                    }
                    catch (Throwable e) {
                        dos_temp.writeByte(3);
                        dos_temp.writeByte((byte)mapped_ip.length());
                        dos_temp.write(mapped_ip.getBytes());
                    }
                    dos_temp.writeShort((short)this.target.getPort());
                    dos_temp.flush();
                    this.packet_out_header = baos_temp.toByteArray();
                    ok = true;
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    error = e;
                    throw new PRUDPPacketHandlerException("socks setup failed: " + Debug.getNestedExceptionMessage(e), e);
                }
                Object var20_16 = null;
                if (!proxy_connected) {
                    proxy_selector.connectFailed(proxy, error);
                }
                if (ok) return;
                try {}
                catch (Throwable throwable) {
                    Object var23_23 = null;
                    this.control_socket = null;
                    throw throwable;
                }
                try {}
                catch (Throwable e) {
                    Debug.out(e);
                    Object var23_22 = null;
                    this.control_socket = null;
                    break block31;
                }
                this.control_socket.close();
                Object var23_21 = null;
                this.control_socket = null;
            }
            if (this.delegate == null) return;
            try {}
            catch (Throwable throwable) {
                Object var25_36 = null;
                this.delegate = null;
                throw throwable;
            }
            this.delegate.destroy();
            Object var25_35 = null;
            this.delegate = null;
            return;
        }
        catch (Throwable throwable) {
            block32: {
                Object var20_17 = null;
                if (!proxy_connected) {
                    proxy_selector.connectFailed(proxy, error);
                }
                if (ok) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var23_26 = null;
                    this.control_socket = null;
                    throw throwable2;
                }
                try {}
                catch (Throwable e) {
                    Debug.out(e);
                    Object var23_25 = null;
                    this.control_socket = null;
                    break block32;
                }
                this.control_socket.close();
                Object var23_24 = null;
                this.control_socket = null;
            }
            if (this.delegate == null) throw throwable;
            try {}
            catch (Throwable throwable3) {
                Object var25_38 = null;
                this.delegate = null;
                throw throwable3;
            }
            this.delegate.destroy();
            Object var25_37 = null;
            this.delegate = null;
            throw throwable;
        }
    }

    public void transformSend(DatagramPacket packet) {
        if (this.relay == null) {
            return;
        }
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        byte[] new_data = new byte[data_len + this.packet_out_header.length];
        System.arraycopy(this.packet_out_header, 0, new_data, 0, this.packet_out_header.length);
        System.arraycopy(data, 0, new_data, this.packet_out_header.length, data_len);
        packet.setData(new_data);
    }

    public void transformReceive(DatagramPacket packet) {
        if (this.relay == null) {
            return;
        }
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, 0, data_len));
        try {
            dis.readByte();
            dis.readByte();
            dis.readByte();
            byte atype = dis.readByte();
            int encap_len = 4;
            encap_len = atype == 1 ? (encap_len += 4) : (atype == 3 ? (encap_len += 1 + (dis.readByte() & 0xFF)) : (encap_len += 16));
            byte[] new_data = new byte[data_len - (encap_len += 2)];
            System.arraycopy(data, encap_len, new_data, 0, data_len - encap_len);
            packet.setData(new_data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void checkAddress(InetSocketAddress destination) throws PRUDPPacketHandlerException {
        if (!destination.equals(this.target)) {
            throw new PRUDPPacketHandlerException("Destination mismatch");
        }
    }

    public void sendAndReceive(PRUDPPacket request_packet, InetSocketAddress destination_address, PRUDPPacketReceiver receiver, long timeout, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        this.delegate.sendAndReceive(request_packet, destination_address, receiver, timeout, priority);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address, timeout_millis);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address, timeout_millis, priority);
    }

    public void send(PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        this.delegate.send(request_packet, destination_address);
    }

    public PRUDPRequestHandler getRequestHandler() {
        return this.delegate.getRequestHandler();
    }

    public void setRequestHandler(PRUDPRequestHandler request_handler) {
        this.delegate.setRequestHandler(request_handler);
    }

    public void primordialSend(byte[] data, InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not imp");
    }

    public boolean hasPrimordialHandler() {
        return this.delegate.hasPrimordialHandler();
    }

    public void addPrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    public void removePrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public InetAddress getBindIP() {
        return this.delegate.getBindIP();
    }

    public void setDelays(int send_delay, int receive_delay, int queued_request_timeout) {
        this.delegate.setDelays(send_delay, receive_delay, queued_request_timeout);
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.delegate.setExplicitBindAddress(address);
    }

    public PRUDPPacketHandlerStats getStats() {
        return this.delegate.getStats();
    }

    public PRUDPPacketHandler openSession(InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not supported");
    }

    public void closeSession() throws PRUDPPacketHandlerException {
        if (this.control_socket != null) {
            try {
                this.control_socket.close();
                this.control_socket = null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    public void destroy() {
        try {
            this.closeSession();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Host", "Proxy.Port", "Proxy.Username", "Proxy.Password"}, new ParameterListener(){

            public void parameterChanged(String parameter_name) {
                socks_host = COConfigurationManager.getStringParameter("Proxy.Host").trim();
                socks_port = Integer.parseInt(COConfigurationManager.getStringParameter("Proxy.Port").trim());
                socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                socks_password = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    socks_user = "";
                }
            }
        });
    }
}

