/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSFeedImpl;

public class RSSUtils {
    public static Date parseRSSDate(String date_str) {
        if ((date_str = date_str.trim()).length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat format = date_str.indexOf(",") == -1 ? new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.US) : new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            return format.parse(date_str);
        }
        catch (ParseException e) {
            String[] fallbacks = new String[]{"dd MMM yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm z yyyy", "EEE MMM dd HH z yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"};
            date_str = date_str.replace(',', ' ');
            date_str = date_str.replaceAll("(\\s)+", " ");
            for (int i = 0; i < fallbacks.length; ++i) {
                try {
                    return new SimpleDateFormat(fallbacks[i], Locale.US).parse(date_str);
                }
                catch (ParseException f) {
                    continue;
                }
            }
            Debug.outNoStack("RSSUtils: failed to parse RSS date: " + date_str);
            return null;
        }
    }

    public static Date parseAtomDate(String date_str) {
        if ((date_str = date_str.trim()).length() == 0) {
            return null;
        }
        String[] formats = new String[]{"yyyy-MM-dd'T'kk:mm:ss'Z'", "yyyy-MM-dd'T'kk:mm:ssz", "yyyy-MM-dd'T'kk:mm:ssZ", "yyyy-MM-dd'T'kk:mm:ss", "yyyy-MM-dd'T'kk:mm'Z'", "yyyy-MM-dd'T'kk:mmz", "yyyy-MM-dd'T'kk:mmZ", "yyyy-MM-dd'T'kk:mm", "yyyy-MM-dd-hh:mm:ss a"};
        for (int i = 0; i < formats.length; ++i) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(formats[i], Locale.US);
                return format.parse(date_str);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        Debug.outNoStack("RSSUtils: failed to parse Atom date: " + date_str);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRSSFeed(File file) {
        try {
            boolean bl;
            String str = FileUtil.readFileAsString(file, 512).toLowerCase();
            str = str.trim().toLowerCase(Locale.US);
            if (!str.startsWith("<?xml")) return false;
            if (!str.contains("<feed")) {
                if (!str.contains("<rss")) return false;
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                new RSSFeedImpl((Utilities)new UtilitiesImpl(null, null), null, is);
                bl = true;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(RSSUtils.parseRSSDate("2013-08-11T18:30:00.000Z"));
    }
}

