/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedLimitHandler;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuItemImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.ListenerDMTask;
import org.gudy.azureus2.ui.swt.ListenerGetOffSWT;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.shells.AdvRenameWindow;
import org.gudy.azureus2.ui.swt.views.table.TableSelectedRowsListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentMenuFancy {
    protected static final boolean DEBUG_MENU = false;
    private static final int SHELL_MARGIN = 1;
    private Map<Object, FancyRowInfo> mapRowInfos = new HashMap<Object, FancyRowInfo>();
    private Map<String, HeaderInfo> mapHeaderRunnables = new HashMap<String, HeaderInfo>();
    private Composite topArea;
    private Composite detailArea;
    private Listener headerListener;
    private TableViewSWT<?> tv;
    private boolean isSeedingView;
    private Shell parentShell;
    private DownloadManager[] dms;
    private String tableID;
    private boolean hasSelection;
    private Map<String, String[]> mapMovedPluginMenus = new HashMap<String, String[]>();
    private Map<String, Integer> mapMovedPluginMenuUserMode = new HashMap<String, Integer>();
    private List<String> listMovedPluginIDs = new ArrayList<String>();
    private Shell shell;
    private Listener listenerForTrigger;
    private Listener listenerRow;
    private PaintListener listenerRowPaint;
    private TableColumnCore column;
    private HeaderInfo activatedHeader;
    private Point originalShellLocation;
    private boolean subMenuVisible;
    private PaintListener paintListenerArrow;

    public TorrentMenuFancy(TableViewSWT<?> tv, boolean isSeedingView, Shell parentShell, DownloadManager[] dms, String tableID) {
        this.tv = tv;
        this.isSeedingView = isSeedingView;
        this.parentShell = parentShell;
        this.dms = dms;
        this.tableID = tableID;
        this.hasSelection = dms.length > 0;
        String[] ids_control = new String[]{"azpeerinjector.contextmenu.inject", "tablemenu.main.item", "StartStopRules.menu.viewDebug", "MyTorrentsView.menu.rename.displayed"};
        this.mapMovedPluginMenuUserMode.put("tablemenu.main.item", 3);
        this.mapMovedPluginMenuUserMode.put("azpeerinjector.contextmenu.inject", 3);
        this.mapMovedPluginMenus.put("Control", ids_control);
        this.listMovedPluginIDs.addAll(Arrays.asList(ids_control));
        String[] ids_social = new String[]{"azsubs.contextmenu.lookupassoc", "rcm.contextmenu.lookupassoc", "rcm.contextmenu.lookupsize", "MagnetPlugin.contextmenu.exporturi", "azbuddy.contextmenu", "RatingPlugin.contextmenu.manageRating", "label.chat"};
        this.mapMovedPluginMenus.put("Social", ids_social);
        this.listMovedPluginIDs.addAll(Arrays.asList(ids_social));
        String[] ids_content = new String[]{"upnpmediaserver.contextmenu", "devices.contextmenu.xcode", "antivirus.ui.contextmenu.scan", "vuzexcode.transcode", "burn.menu.addtodvd"};
        this.mapMovedPluginMenus.put("Content", ids_content);
        this.listMovedPluginIDs.addAll(Arrays.asList(ids_content));
        this.listenerForTrigger = new Listener(){

            public void handleEvent(Event event2) {
                FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                if (rowInfo != null) {
                    if (!rowInfo.keepMenu()) {
                        TorrentMenuFancy.this.shell.dispose();
                    }
                    if (rowInfo.getListener() != null) {
                        rowInfo.getListener().handleEvent(event2);
                    }
                } else {
                    TorrentMenuFancy.this.shell.dispose();
                }
            }
        };
        this.paintListenerArrow = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control c = (Control)e.widget;
                Point size = c.getSize();
                int arrowSize = 8;
                int xStart = size.x - arrowSize;
                int yStart = size.y - (size.y + arrowSize) / 2;
                e.gc.setBackground(e.display.getSystemColor(21));
                e.gc.setAntialias(1);
                e.gc.fillPolygon(new int[]{xStart, yStart, xStart + arrowSize, yStart + 4, xStart, yStart + 8});
            }
        };
        this.listenerRow = new Listener(){

            public void handleEvent(Event event2) {
                Composite parent = TorrentMenuFancy.this.detailArea;
                Rectangle bounds = parent.getBounds();
                if (event2.type == 7) {
                    parent.redraw(0, 0, bounds.width, bounds.height, true);
                } else if (event2.type == 6) {
                    parent.redraw(0, 0, bounds.width, bounds.height, true);
                }
            }
        };
        this.listenerRowPaint = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = ((Control)e.widget).getBounds();
                Point cursorLocation = e.display.getCursorLocation();
                Point cursorLocationRel = ((Control)e.widget).getParent().toControl(cursorLocation);
                if (!bounds.contains(cursorLocationRel)) {
                    for (Control control : ((Composite)e.widget).getChildren()) {
                        control.setBackground(null);
                        control.setForeground(null);
                    }
                    return;
                }
                Color bg = e.display.getSystemColor(25);
                int arc = bounds.height / 3;
                e.gc.setBackground(bg);
                e.gc.setForeground(e.display.getSystemColor(17));
                e.gc.setAntialias(1);
                e.gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, arc, arc);
                e.gc.setAlpha(100);
                e.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, arc, arc);
                Color fg = e.display.getSystemColor(24);
                for (Control control : ((Composite)e.widget).getChildren()) {
                    control.setBackground(bg);
                    control.setForeground(fg);
                }
            }
        };
        Collections.sort(this.listMovedPluginIDs);
    }

    public void showMenu(TableColumnCore acolumn) {
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items;
        TableContextMenuItem[] items;
        this.column = acolumn;
        Display d = this.parentShell.getDisplay();
        this.shell = new Shell(this.parentShell, 0x20000008){

            protected void checkSubclass() {
            }

            public void dispose() {
                super.dispose();
            }
        };
        RowLayout shellLayout = new RowLayout(512);
        shellLayout.fill = true;
        shellLayout.marginTop = 0;
        shellLayout.marginRight = 0;
        shellLayout.marginLeft = 0;
        shellLayout.marginBottom = 0;
        shellLayout.marginHeight = 1;
        shellLayout.marginWidth = 1;
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setBackgroundMode(2);
        this.topArea = new Composite((Composite)this.shell, 0x20000000);
        this.detailArea = new Composite((Composite)this.shell, 0x20000000);
        this.topArea.setBackground(d.getSystemColor(25));
        this.topArea.setForeground(d.getSystemColor(24));
        FormData fd = Utils.getFilledFormData();
        fd.bottom = null;
        RowLayout topLayout = new RowLayout(256);
        topLayout.spacing = 0;
        topLayout.pack = true;
        topLayout.marginRight = 0;
        topLayout.marginLeft = 0;
        topLayout.marginTop = 0;
        topLayout.marginBottom = 0;
        this.topArea.setLayout((Layout)topLayout);
        fd = Utils.getFilledFormData();
        fd.top = new FormAttachment((Control)this.topArea, 0, 1024);
        FormLayout layoutDetailsArea = new FormLayout();
        layoutDetailsArea.marginWidth = 2;
        layoutDetailsArea.marginBottom = 2;
        this.detailArea.setLayout((Layout)layoutDetailsArea);
        this.headerListener = new Listener(){

            public void handleEvent(Event e) {
                Control control = (Control)e.widget;
                if (e.type == 9) {
                    Rectangle bounds = control.getBounds();
                    int y = bounds.height - 2;
                    e.gc.drawLine(0, y, bounds.width, y);
                } else if (e.type == 6) {
                    Object data = e.widget.getData("ID");
                    HeaderInfo header = (HeaderInfo)TorrentMenuFancy.this.mapHeaderRunnables.get(data);
                    TorrentMenuFancy.this.activateHeader(header);
                }
            }
        };
        HeaderInfo firstHeader = this.addHeader("Control", "Control", new AERunnable(){

            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Control(TorrentMenuFancy.this.detailArea, TorrentMenuFancy.this.dms);
            }
        });
        this.addHeader("Content", "Content", new AERunnable(){

            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Content(TorrentMenuFancy.this.detailArea, TorrentMenuFancy.this.dms);
            }
        });
        this.addHeader("Organize", "Organize", new AERunnable(){

            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Organize(TorrentMenuFancy.this.detailArea, TorrentMenuFancy.this.dms);
            }
        });
        this.addHeader("Social", "Social", new AERunnable(){

            public void runSupport() {
                TorrentMenuFancy.this.buildTorrentCustomMenu_Social(TorrentMenuFancy.this.detailArea);
            }
        });
        final ArrayList<org.gudy.azureus2.plugins.ui.menus.MenuItem> listOtherItems = new ArrayList<org.gudy.azureus2.plugins.ui.menus.MenuItem>();
        for (TableContextMenuItem item : items = TableContextMenuManager.getInstance().getAllAsArray(this.tableID)) {
            if (Collections.binarySearch(this.listMovedPluginIDs, item.getResourceKey()) >= 0) continue;
            listOtherItems.add(item);
        }
        for (org.gudy.azureus2.plugins.ui.menus.MenuItem item : menu_items = MenuItemManager.getInstance().getAllAsArray("download_context")) {
            if (Collections.binarySearch(this.listMovedPluginIDs, item.getResourceKey()) >= 0) continue;
            listOtherItems.add(item);
        }
        if (this.column != null) {
            TableContextMenuItem[] columnItems;
            for (TableContextMenuItem item : columnItems = this.column.getContextMenuItems(2)) {
                if (Collections.binarySearch(this.listMovedPluginIDs, item.getResourceKey()) >= 0) continue;
                listOtherItems.add(item);
            }
        }
        if (listOtherItems.size() > 0) {
            this.addHeader("Other", "Other", new AERunnable(){

                public void runSupport() {
                    TorrentMenuFancy.this.buildTorrentCustomMenu_Other(TorrentMenuFancy.this.detailArea, listOtherItems);
                }
            });
        }
        this.originalShellLocation = d.getCursorLocation();
        this.originalShellLocation.x -= 5;
        this.originalShellLocation.y -= 16;
        this.shell.setLocation(this.originalShellLocation);
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(e.display.getSystemColor(23));
                Rectangle clientArea = TorrentMenuFancy.this.shell.getClientArea();
                e.gc.drawRectangle(0, 0, clientArea.width - 1, clientArea.height - 1);
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    TorrentMenuFancy.this.shell.dispose();
                } else if (e.detail == 4) {
                    TorrentMenuFancy.this.shell.dispose();
                }
            }
        });
        this.shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        if (TorrentMenuFancy.this.subMenuVisible) {
                            return;
                        }
                        if (TorrentMenuFancy.this.shell.isDisposed()) {
                            return;
                        }
                        Shell[] shells = TorrentMenuFancy.this.shell.getShells();
                        if (shells != null && shells.length > 0) {
                            for (Shell aShell : shells) {
                                if (aShell.isDisposed()) continue;
                                return;
                            }
                        }
                        TorrentMenuFancy.this.shell.dispose();
                    }
                });
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.activateHeader(firstHeader);
        this.shell.open();
    }

    protected void activateHeader(HeaderInfo header) {
        String[] ids;
        if (header == null || this.activatedHeader == header) {
            return;
        }
        Display d = header.composite.getDisplay();
        header.composite.setBackground(d.getSystemColor(22));
        header.composite.setForeground(d.getSystemColor(21));
        Utils.disposeSWTObjects(this.detailArea.getChildren());
        if (header.runnable != null) {
            header.runnable.run();
        }
        if ((ids = this.mapMovedPluginMenus.get(header.id)) != null) {
            this.addTableItemsWithID(this.detailArea, this.tableID, ids);
            this.addMenuItemsWithID(this.detailArea, "download_context", ids);
            if (this.column != null) {
                org.gudy.azureus2.plugins.ui.menus.MenuItem[] columnItems = this.column.getContextMenuItems(2);
                this.addItemsArray(this.detailArea, columnItems, ids);
            }
        }
        Control lastControl = null;
        for (Control child : this.detailArea.getChildren()) {
            FormData fd = new FormData();
            fd.top = lastControl == null ? new FormAttachment(0) : new FormAttachment(lastControl);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            child.setLayoutData((Object)fd);
            lastControl = child;
        }
        this.shell.pack(true);
        this.detailArea.layout(true, true);
        Point shellSize = this.shell.getSize();
        Point ptBottomRight = this.shell.toDisplay(shellSize);
        Rectangle monitorArea = this.shell.getMonitor().getClientArea();
        if (ptBottomRight.x > monitorArea.x + monitorArea.width) {
            this.shell.setLocation(monitorArea.x + monitorArea.width - shellSize.x, this.shell.getLocation().y);
        }
        if (ptBottomRight.y > monitorArea.y + monitorArea.height) {
            if (this.shell.getChildren()[0] != this.detailArea) {
                System.out.println("detailArea.getSize()=" + this.detailArea.getSize() + "/" + this.detailArea.getBounds());
                this.shell.setLocation(this.shell.getLocation().x, this.originalShellLocation.y - this.detailArea.getSize().y - 3);
                this.detailArea.moveAbove(null);
                lastControl = null;
                Control[] children = this.detailArea.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Control child = children[children.length - i - 1];
                    FormData fd = new FormData();
                    fd.top = lastControl == null ? new FormAttachment(0) : new FormAttachment(lastControl);
                    fd.left = new FormAttachment(0, 0);
                    fd.right = new FormAttachment(100, 0);
                    child.setLayoutData((Object)fd);
                    lastControl = child;
                }
                this.shell.layout(true, true);
            }
        } else if (this.shell.getChildren()[0] == this.detailArea) {
            this.shell.setLocation(this.shell.getLocation().x, this.originalShellLocation.y);
            this.detailArea.moveBelow(null);
            this.shell.layout(true, true);
        }
        if (this.activatedHeader != null) {
            this.activatedHeader.composite.setBackground(d.getSystemColor(25));
            this.activatedHeader.composite.setForeground(d.getSystemColor(24));
        }
        this.activatedHeader = header;
    }

    public void buildTorrentCustomMenu_Control(Composite cParent, final DownloadManager[] dms) {
        AzureusCore azureus_core;
        SpeedLimitHandler slh;
        DownloadManager dm;
        final int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean start = false;
        boolean stop = false;
        boolean recheck = false;
        boolean barsOpened = true;
        boolean bChangeDir = this.hasSelection;
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm2 = dms[i];
            if (barsOpened && !DownloadBar.getManager().isOpen(dm2)) {
                barsOpened = false;
            }
            stop = stop || ManagerUtils.isStopable(dm2);
            start = start || ManagerUtils.isStartable(dm2);
            recheck = recheck || dm2.canForceRecheck();
            boolean stopped = ManagerUtils.isStopped(dm2);
            int state = dm2.getState();
            if (!(bChangeDir &= state == 100 || state == 70 || state == 75) || dms.length != 1) continue;
            bChangeDir = dm2.isDataAlreadyAllocated();
            bChangeDir = bChangeDir && state == 100 ? !dm2.filesExist(true) : false;
        }
        Composite cQuickCommands = new Composite(cParent, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.justify = true;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        cQuickCommands.setLayout((Layout)rowLayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        cQuickCommands.setLayoutData((Object)gd);
        this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.queue", "start", start, new ListenerGetOffSWT(){

            void handleEventOffSWT(Event event2) {
                TorrentUtil.queueDataSources(dms, true);
            }
        });
        if (userMode > 0) {
            boolean forceStart = false;
            boolean forceStartEnabled = false;
            for (int i = 0; i < dms.length; ++i) {
                dm = dms[i];
                forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                forceStart = forceStart || dm.isForceStart();
            }
            final boolean newForceStart = !forceStart;
            this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.forceStart", "forcestart", forceStartEnabled, forceStart ? 2048 : 8, new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    if (ManagerUtils.isForceStartable(dm)) {
                        dm.setForceStart(newForceStart);
                    }
                }
            });
        }
        if (userMode > 0) {
            this.createActionButton(dms, cQuickCommands, "v3.MainWindow.button.pause", "pause", stop, new ListenerGetOffSWT(){

                public void handleEventOffSWT(Event event2) {
                    TorrentUtil.pauseDataSources(dms);
                }
            });
        }
        this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.stop", "stop", stop, new ListenerGetOffSWT(){

            public void handleEventOffSWT(Event event2) {
                TorrentUtil.stopDataSources(dms);
            }
        });
        this.createActionButton(dms, cQuickCommands, "MyTorrentsView.menu.recheck", "recheck", recheck, new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
        this.createActionButton(dms, cQuickCommands, "menu.delete.options", "delete", this.hasSelection, new Listener(){

            public void handleEvent(Event event2) {
                TorrentUtil.removeDownloads(dms, null, true);
            }
        });
        if (bChangeDir) {
            this.createRow(cParent, "MyTorrentsView.menu.changeDirectory", null, new Listener(){

                public void handleEvent(Event e) {
                    TorrentUtil.changeDirSelectedTorrents(dms, TorrentMenuFancy.this.parentShell);
                }
            });
        }
        if (this.hasSelection) {
            this.createRow(cParent, "MyTorrentsView.menu.showdetails", "details", new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.openView(5, dm);
                    }
                }
            });
        }
        if (this.hasSelection) {
            FancyRowInfo row = this.createRow(cParent, "MyTorrentsView.menu.showdownloadbar", "downloadBar", new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    if (DownloadBar.getManager().isOpen(dm)) {
                        DownloadBar.close(dm);
                    } else {
                        DownloadBar.open(dm, TorrentMenuFancy.this.parentShell);
                    }
                }
            });
            row.setSelection(barsOpened);
        }
        if (this.hasSelection) {
            FancyRowInfo rowSpeedDL = this.createRow(cParent, "MyTorrentsView.menu.downSpeedLimit", "image.torrentspeed.down", false, new Listener(){

                public void handleEvent(Event e) {
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.display.post(event2);
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    SelectableSpeedMenu.invokeSlider((Control)event2.widget, core, dms, false, TorrentMenuFancy.this.shell);
                    if (e.display.getActiveShell() != TorrentMenuFancy.this.shell) {
                        if (!TorrentMenuFancy.this.shell.isDisposed()) {
                            TorrentMenuFancy.this.shell.dispose();
                        }
                        return;
                    }
                    FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                    if (rowInfo != null) {
                        TorrentMenuFancy.this.updateRowSpeed(rowInfo, false);
                    }
                }
            });
            rowSpeedDL.keepMenu = true;
            this.updateRowSpeed(rowSpeedDL, false);
        }
        if (this.hasSelection) {
            FancyRowInfo rowSpeedUL = this.createRow(cParent, "MyTorrentsView.menu.upSpeedLimit", "image.torrentspeed.up", false, new Listener(){

                public void handleEvent(Event e) {
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.display.post(event2);
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    SelectableSpeedMenu.invokeSlider((Control)e.widget, core, dms, true, TorrentMenuFancy.this.shell);
                    if (e.display.getActiveShell() != TorrentMenuFancy.this.shell) {
                        if (!TorrentMenuFancy.this.shell.isDisposed()) {
                            TorrentMenuFancy.this.shell.dispose();
                        }
                        return;
                    }
                    FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                    if (rowInfo != null) {
                        TorrentMenuFancy.this.updateRowSpeed(rowInfo, true);
                    }
                }
            });
            rowSpeedUL.keepMenu = true;
            this.updateRowSpeed(rowSpeedUL, true);
        }
        if (this.hasSelection && userMode > 0) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.tracker", null, new FancyMenuRowInfoListener(){

                public void buildMenu(Menu menu) {
                    boolean changeUrl = TorrentMenuFancy.this.hasSelection;
                    boolean manualUpdate = true;
                    boolean allStopped = true;
                    int userMode = COConfigurationManager.getIntParameter("User Mode");
                    boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
                    for (DownloadManager dm : dms) {
                        TRTrackerAnnouncer trackerClient;
                        boolean stopped = ManagerUtils.isStopped(dm);
                        allStopped &= stopped;
                        if (userMode >= 2 || (trackerClient = dm.getTrackerClient()) == null) continue;
                        boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                        manualUpdate &= update_state;
                    }
                    TorrentUtil.addTrackerTorrentMenu(menu, dms, changeUrl, manualUpdate, allStopped, use_open_containing_folder);
                }
            });
        }
        if (this.hasSelection && (slh = SpeedLimitHandler.getSingleton(azureus_core = AzureusCoreFactory.getSingleton())).hasAnyProfiles()) {
            List<String> profileNames = slh.getProfileNames();
            this.createMenuRow(cParent, "MainWindow.menu.speed_limits", null, new FancyMenuRowInfoListener(){

                public void buildMenu(Menu menu) {
                    TorrentUtil.addSpeedLimitsMenu(dms, menu);
                }
            });
        }
        if (userMode > 0 && this.hasSelection) {
            boolean can_pause = false;
            for (int i = 0; i < dms.length; ++i) {
                DownloadManager dm3 = dms[i];
                if (!ManagerUtils.isPauseable(dm3)) continue;
                can_pause = true;
                break;
            }
            this.createRow(this.detailArea, "MainWindow.menu.transfers.pausetransfersfor", null, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.pauseDownloadsFor(dms);
                }
            });
        }
        if (userMode > 0 && dms.length > 1) {
            this.createRow(cParent, "label.options.and.info", null, new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    uiFunctions.openView(6, dms);
                }
            });
        }
        if (userMode > 0) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.peersource", null, new FancyMenuRowInfoListener(){

                public void buildMenu(Menu menu) {
                    TorrentUtil.addPeerSourceSubMenu(dms, menu);
                }
            });
        }
        if (userMode > 0 && IpFilterManagerFactory.getSingleton().getIPFilter().isEnabled()) {
            boolean allEnabled = true;
            boolean allDisabled = true;
            for (int j = 0; j < dms.length; ++j) {
                dm = dms[j];
                boolean filterDisabled = dm.getDownloadState().getFlag(256L);
                if (filterDisabled) {
                    allEnabled = false;
                    continue;
                }
                allDisabled = false;
            }
            boolean bChecked = allEnabled ? true : (allDisabled ? false : false);
            final boolean newDisable = bChecked;
            FancyRowInfo row = this.createRow(cParent, "MyTorrentsView.menu.ipf_enable", null, new ListenerDMTask(dms){

                public void run(DownloadManager dm) {
                    dm.getDownloadState().setFlag(256L, newDisable);
                }
            });
            row.setSelection(bChecked);
        }
        if (userMode > 1) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.networks", null, new FancyMenuRowInfoListener(){

                public void buildMenu(Menu menu) {
                    TorrentUtil.addNetworksSubMenu(dms, menu);
                }
            });
        }
        if (userMode > 0) {
            this.createMenuRow(cParent, "MyTorrentsView.menu.advancedmenu", null, new FancyMenuRowInfoListener(){

                public void buildMenu(Menu menu) {
                    boolean allStopped = true;
                    boolean allScanSelected = true;
                    boolean allScanNotSelected = true;
                    boolean fileMove = true;
                    for (DownloadManager dm : dms) {
                        boolean stopped = ManagerUtils.isStopped(dm);
                        allStopped &= stopped;
                        fileMove = fileMove && dm.canMoveDataFiles();
                        boolean scan = dm.getDownloadState().getFlag(2L);
                        boolean incomplete = !dm.isDownloadComplete(true);
                        allScanSelected = incomplete && allScanSelected && scan;
                        allScanNotSelected = incomplete && allScanNotSelected && !scan;
                    }
                    boolean fileRescan = allScanSelected || allScanNotSelected;
                    MenuItem itemFileMoveTorrent = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileMoveTorrent, "MyTorrentsView.menu.movetorrent");
                    itemFileMoveTorrent.addListener(13, (Listener)new ListenerDMTask(dms){

                        public void run(DownloadManager[] dms) {
                            TorrentUtil.moveTorrentFile(TorrentMenuFancy.this.parentShell, dms);
                        }
                    });
                    itemFileMoveTorrent.setEnabled(fileMove);
                    final MenuItem itemFileRescan = new MenuItem(menu, 32);
                    Messages.setLanguageText((Widget)itemFileRescan, "MyTorrentsView.menu.rescanfile");
                    itemFileRescan.addListener(13, (Listener)new ListenerDMTask(dms){

                        public void run(DownloadManager dm) {
                            dm.getDownloadState().setFlag(2L, itemFileRescan.getSelection());
                        }
                    });
                    itemFileRescan.setSelection(allScanSelected);
                    itemFileRescan.setEnabled(fileRescan);
                    MenuItem itemFileClearAlloc = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileClearAlloc, "MyTorrentsView.menu.clear_alloc_data");
                    itemFileClearAlloc.addListener(13, (Listener)new ListenerDMTask(dms){

                        public void run(DownloadManager dm) {
                            dm.setDataAlreadyAllocated(false);
                        }
                    });
                    itemFileClearAlloc.setEnabled(allStopped);
                    MenuItem itemFileClearResume = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemFileClearResume, "MyTorrentsView.menu.clear_resume_data");
                    itemFileClearResume.addListener(13, (Listener)new ListenerDMTask(dms){

                        public void run(DownloadManager dm) {
                            dm.getDownloadState().clearResumeData();
                        }
                    });
                    itemFileClearResume.setEnabled(allStopped);
                    if (userMode > 1 && TorrentMenuFancy.this.isSeedingView) {
                        boolean canSetSuperSeed = false;
                        boolean superSeedAllYes = true;
                        boolean superSeedAllNo = true;
                        for (DownloadManager dm : dms) {
                            PEPeerManager pm = dm.getPeerManager();
                            if (pm != null) {
                                if (pm.canToggleSuperSeedMode()) {
                                    canSetSuperSeed = true;
                                }
                                if (pm.isSuperSeedMode()) {
                                    superSeedAllYes = false;
                                    continue;
                                }
                                superSeedAllNo = false;
                                continue;
                            }
                            superSeedAllYes = false;
                            superSeedAllNo = false;
                        }
                        MenuItem itemSuperSeed = new MenuItem(menu, 32);
                        Messages.setLanguageText((Widget)itemSuperSeed, "ManagerItem.superseeding");
                        boolean enabled = canSetSuperSeed && (superSeedAllNo || superSeedAllYes);
                        itemSuperSeed.setEnabled(enabled);
                        final boolean selected = superSeedAllNo;
                        if (enabled) {
                            itemSuperSeed.setSelection(selected);
                            itemSuperSeed.addListener(13, (Listener)new ListenerDMTask(dms){

                                public void run(DownloadManager dm) {
                                    PEPeerManager pm = dm.getPeerManager();
                                    if (pm != null && pm.isSuperSeedMode() == selected && pm.canToggleSuperSeedMode()) {
                                        pm.setSuperSeedMode(!selected);
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private void updateRowSpeed(FancyRowInfo row, boolean isUpload) {
        int dlRate = isUpload ? this.dms[0].getStats().getUploadRateLimitBytesPerSecond() : this.dms[0].getStats().getDownloadRateLimitBytesPerSecond();
        for (DownloadManager dm : this.dms) {
            int dlRate2;
            int n = dlRate2 = isUpload ? dm.getStats().getUploadRateLimitBytesPerSecond() : dm.getStats().getDownloadRateLimitBytesPerSecond();
            if (dlRate == dlRate2) continue;
            dlRate = -2;
            break;
        }
        if (dlRate != -2) {
            String currentSpeed = dlRate == 0 ? MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited") : (dlRate < 0 ? MessageText.getString("MyTorrentsView.menu.setSpeed.disabled") : DisplayFormatters.formatByteCountToKiBEtcPerSec(dlRate));
            row.setRightLabelText(currentSpeed);
            row.cRow.layout();
        }
    }

    private FancyMenuRowInfo createMenuRow(Composite cParent, String keyTitle, String keyImage, final FancyMenuRowInfoListener listener) {
        Listener showSWTMenuListener = new Listener(){

            public void handleEvent(Event event2) {
                Control cursorControl;
                FancyRowInfo findRowInfo = TorrentMenuFancy.this.findRowInfo(event2.widget);
                if (!(findRowInfo instanceof FancyMenuRowInfo)) {
                    return;
                }
                FancyMenuRowInfo rowInfo = (FancyMenuRowInfo)findRowInfo;
                Menu menu = rowInfo.getMenu();
                if (menu != null && !menu.isDisposed()) {
                    return;
                }
                menu = new Menu((Decorations)TorrentMenuFancy.this.parentShell, 8);
                rowInfo.setMenu(menu);
                menu.addMenuListener(new MenuListener(){

                    public void menuShown(MenuEvent arg0) {
                        TorrentMenuFancy.this.subMenuVisible = true;
                    }

                    public void menuHidden(MenuEvent arg0) {
                        TorrentMenuFancy.this.subMenuVisible = false;
                    }
                });
                listener.buildMenu(menu);
                for (cursorControl = event2.display.getCursorControl(); cursorControl != null && cursorControl.getData("ID") == null; cursorControl = cursorControl.getParent()) {
                }
                if (cursorControl != null) {
                    Point size = cursorControl.getSize();
                    Point menuLocation = cursorControl.toDisplay(size.x - 3, -3);
                    menu.setLocation(menuLocation);
                }
                if (menu.getItemCount() > 0) {
                    menu.setVisible(true);
                    TorrentMenuFancy.this.addMenuItemListener(menu, TorrentMenuFancy.this.listenerForTrigger);
                    final FancyMenuRowInfo currentRow = rowInfo;
                    Utils.execSWTThreadLater(300, new Runnable(){

                        public void run() {
                            Menu menu = currentRow.getMenu();
                            if (menu == null || menu.isDisposed() || !menu.isVisible()) {
                                return;
                            }
                            Control control = Utils.getCursorControl();
                            FancyRowInfo rowInfo = TorrentMenuFancy.this.findRowInfo((Widget)control);
                            if (rowInfo != null && rowInfo != currentRow) {
                                menu.setVisible(false);
                                menu.dispose();
                                return;
                            }
                            Utils.execSWTThreadLater(300, this);
                        }
                    });
                }
            }
        };
        FancyMenuRowInfo row = new FancyMenuRowInfo();
        this.createRow(cParent, keyTitle, keyImage, true, showSWTMenuListener, row);
        Composite cRow = row.getRow();
        Utils.addListenerAndChildren(cRow, 32, showSWTMenuListener);
        row.setKeepMenu(true);
        Label rightLabel = row.getRightLabel();
        GridData gd = new GridData(12, -1);
        rightLabel.setLayoutData((Object)gd);
        row.getRightLabel().addPaintListener(this.paintListenerArrow);
        return row;
    }

    protected void addMenuItemListener(Menu menu, Listener l) {
        for (MenuItem item : menu.getItems()) {
            if (item.getStyle() == 64) {
                this.addMenuItemListener(item.getMenu(), l);
                continue;
            }
            item.addListener(13, l);
        }
    }

    private FancyRowInfo createRow(Composite cParent, String keyTitle, String keyImage, Listener triggerListener) {
        return this.createRow(cParent, keyTitle, keyImage, true, triggerListener, new FancyRowInfo());
    }

    private FancyRowInfo createRow(Composite cParent, String keyTitle, String keyImage, boolean triggerOnUp, Listener triggerListener) {
        return this.createRow(cParent, keyTitle, keyImage, triggerOnUp, triggerListener, new FancyRowInfo());
    }

    private FancyRowInfo createRow(Composite cParent, String keyTitle, String keyImage, boolean triggerOnUp, Listener triggerListener, FancyRowInfo rowInfo) {
        int id = keyTitle == null ? (int)(2.147483647E9 * Math.random()) : (int)((double)keyTitle.hashCode() * Math.random());
        Composite cRow = new Composite(cParent, 0);
        cRow.setData("ID", (Object)id);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 3;
        gridLayout.marginRight = 4;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        cRow.setLayout((Layout)gridLayout);
        Label lblIcon = new Label(cRow, 0x1000000);
        GridData gridData = new GridData();
        gridData.widthHint = 20;
        lblIcon.setLayoutData((Object)gridData);
        if (keyImage != null) {
            ImageLoader.getInstance().setLabelImage(lblIcon, keyImage);
        }
        Label item = new Label(cRow, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 2;
        item.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)item, keyTitle);
        if (triggerListener != null) {
            Utils.addListenerAndChildren(cRow, triggerOnUp ? 4 : 3, this.listenerForTrigger);
        }
        Utils.addListenerAndChildren(cRow, 6, this.listenerRow);
        Utils.addListenerAndChildren(cRow, 7, this.listenerRow);
        cRow.addPaintListener(this.listenerRowPaint);
        Label lblCheck = new Label(cRow, 0x1000000);
        gridData = new GridData();
        gridData.widthHint = 13;
        lblCheck.setLayoutData((Object)gridData);
        rowInfo.setListener(triggerListener);
        rowInfo.setRow(cRow);
        rowInfo.setIconLabel(lblIcon);
        rowInfo.setText(item);
        rowInfo.setRightLabel(null);
        rowInfo.setCheckLabel(lblCheck);
        this.mapRowInfos.put(id, rowInfo);
        return rowInfo;
    }

    private FancyRowInfo findRowInfo(Widget widget) {
        Object data = this.findData(widget, "ID");
        return this.mapRowInfos.get(data);
    }

    protected Object findData(Widget widget, String id) {
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        Object o = widget.getData(id);
        if (o != null) {
            return o;
        }
        if (widget instanceof Control) {
            for (Composite control = ((Control)widget).getParent(); control != null; control = control.getParent()) {
                o = control.getData(id);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    private Control createActionButton(DownloadManager[] dms, Composite cParent, String keyToolTip, String keyImage, boolean enable, Listener listener) {
        return this.createActionButton(dms, cParent, keyToolTip, keyImage, enable, 2048, listener);
    }

    private Control createActionButton(DownloadManager[] dms, Composite cParent, String keyToolTip, final String keyImage, boolean enable, int style, final Listener listener) {
        Canvas item = new Canvas(cParent, 0x20040000);
        Listener l = new Listener(){
            private boolean inWidget;

            public void handleEvent(Event e) {
                Control c = (Control)e.widget;
                if (e.type == 9) {
                    Point size = c.getSize();
                    if (this.inWidget) {
                        e.gc.setBackground(e.display.getSystemColor(20));
                    } else {
                        e.gc.setBackground(e.display.getSystemColor(19));
                    }
                    e.gc.setAdvanced(true);
                    e.gc.setAntialias(1);
                    e.gc.fillRoundRectangle(0, 0, size.x - 1, size.y - 1, 6, 6);
                    e.gc.setForeground(e.display.getSystemColor(17));
                    e.gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, 6, 6);
                    e.gc.setForeground(e.display.getSystemColor(20));
                    e.gc.drawRoundRectangle(1, 1, size.x - 3, size.y - 3, 6, 6);
                    Image image = ImageLoader.getInstance().getImage(c.isEnabled() ? keyImage : keyImage + "-disabled");
                    Rectangle bounds = image.getBounds();
                    int x = size.x / 2 - bounds.width / 2;
                    int y = size.y / 2 - bounds.height / 2;
                    e.gc.drawImage(image, x, y);
                } else if (e.type == 6) {
                    this.inWidget = true;
                    c.redraw();
                } else if (e.type == 7) {
                    this.inWidget = false;
                    c.redraw();
                }
            }
        };
        item.addListener(6, l);
        item.addListener(7, l);
        item.addListener(9, l);
        Messages.setLanguageTooltip((Widget)item, keyToolTip);
        item.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                listener.handleEvent(event2);
                TorrentMenuFancy.this.shell.dispose();
            }
        });
        item.setEnabled(enable);
        RowData rowData = new RowData(30, 21);
        item.setLayoutData((Object)rowData);
        return item;
    }

    public void buildTorrentCustomMenu_Organize(final Composite detailArea, final DownloadManager[] dms) {
        if (!this.hasSelection) {
            return;
        }
        this.createMenuRow(detailArea, "label.tags", "image.sidebar.tag-overview", new FancyMenuRowInfoListener(){

            public void buildMenu(Menu menu) {
                TagUIUtils.addLibraryViewTagsSubMenu(dms, menu, detailArea);
            }
        });
        this.createMenuRow(detailArea, "MyTorrentsView.menu.setCategory", "image.sidebar.library", new FancyMenuRowInfoListener(){

            public void buildMenu(Menu menu) {
                TorrentUtil.addCategorySubMenu(dms, menu, detailArea);
            }
        });
        if (this.tv.getSWTFilter() != null) {
            this.createRow(detailArea, "MyTorrentsView.menu.filter", null, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentMenuFancy.this.tv.openFilterDialog();
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.rename", null, new Listener(){

            public void handleEvent(Event event2) {
                for (DownloadManager dm : dms) {
                    AdvRenameWindow window = new AdvRenameWindow();
                    window.open(dm);
                }
            }
        });
        this.createRow(detailArea, "MyTorrentsView.menu.reposition.manual", null, new Listener(){

            public void handleEvent(Event event2) {
                TorrentUtil.repositionManual(TorrentMenuFancy.this.tv, dms, detailArea.getShell(), TorrentMenuFancy.this.isSeedingView);
            }
        });
    }

    public void buildTorrentCustomMenu_Social(Composite detailArea) {
        boolean isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (this.hasSelection) {
            this.createMenuRow(detailArea, "ConfigView.section.interface.alerts", null, new FancyMenuRowInfoListener(){

                public void buildMenu(Menu menu) {
                    MenuFactory.addAlertsMenu(menu, false, TorrentMenuFancy.this.dms);
                }
            });
        }
        if (userMode > 0 && isTrackerOn && this.hasSelection) {
            this.createRow(detailArea, "MyTorrentsView.menu.host", "host", new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.hostTorrents(TorrentMenuFancy.this.dms);
                }
            });
            this.createRow(detailArea, "MyTorrentsView.menu.publish", "publish", new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.publishTorrents(TorrentMenuFancy.this.dms);
                }
            });
        }
        if (userMode > 0) {
            FancyRowInfo row;
            String title;
            if (this.dms.length == 1) {
                title = MessageText.getString("MyTorrentsView.menu.exportmenu") + ": " + MessageText.getString("MyTorrentsView.menu.export");
                row = this.createRow(detailArea, null, null, new ListenerDMTask(this.dms){

                    public void run(DownloadManager dm) {
                        if (dm != null) {
                            new ExportTorrentWizard(TorrentMenuFancy.this.parentShell.getDisplay(), dm);
                        }
                    }
                });
                row.getText().setText(title);
            }
            title = MessageText.getString("MyTorrentsView.menu.exportmenu") + ": " + MessageText.getString("MyTorrentsView.menu.exporttorrent");
            row = this.createRow(detailArea, null, null, new ListenerDMTask(this.dms){

                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportTorrent(dms, TorrentMenuFancy.this.parentShell);
                }
            });
            row.getText().setText(title);
            this.createRow(detailArea, "MyTorrentsView.menu.exporthttpseeds", null, new ListenerDMTask(this.dms){

                public void run(DownloadManager[] dms) {
                    TorrentUtil.exportHTTPSeeds(dms);
                }
            });
        }
        if (this.isSeedingView) {
            this.createRow(detailArea, "MyTorrentsView.menu.create_personal_share", null, new ListenerDMTask(this.dms, false){

                public void run(DownloadManager dm) {
                    File file = dm.getSaveLocation();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("personal", "true");
                    if (file.isFile()) {
                        ShareUtils.shareFile(file.getAbsolutePath(), properties);
                    } else if (file.isDirectory()) {
                        ShareUtils.shareDir(file.getAbsolutePath(), properties);
                    }
                }
            });
        }
    }

    public void addTableItemsWithID(Composite detailArea, String menuID, String[] ids) {
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(menuID);
        this.addItemsArray(detailArea, items, ids);
    }

    public void addMenuItemsWithID(Composite detailArea, String menuID, String[] ids) {
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = MenuItemManager.getInstance().getAllAsArray(menuID);
        this.addItemsArray(detailArea, items, ids);
    }

    public void addItemsArray(Composite detailArea, org.gudy.azureus2.plugins.ui.menus.MenuItem[] items, String[] onlyIDs) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        block0: for (int i = 0; i < onlyIDs.length; ++i) {
            String id = onlyIDs[i];
            Integer requiredUserMode = this.mapMovedPluginMenuUserMode.get(id);
            if (requiredUserMode != null && userMode < requiredUserMode) continue;
            for (org.gudy.azureus2.plugins.ui.menus.MenuItem item : items) {
                String key = item.getResourceKey();
                if (!id.equals(key)) continue;
                this.addPluginItem(detailArea, item);
                continue block0;
            }
        }
    }

    public void buildTorrentCustomMenu_Other(Composite detailArea, List<org.gudy.azureus2.plugins.ui.menus.MenuItem> items) {
        for (org.gudy.azureus2.plugins.ui.menus.MenuItem item : items) {
            this.addPluginItem(detailArea, item);
        }
    }

    private Object[] getTarget(org.gudy.azureus2.plugins.ui.menus.MenuItem item) {
        if ("table".equals(item.getMenuID())) {
            return this.tv.getSelectedRows();
        }
        Object[] dataSources = this.tv.getSelectedDataSources(false);
        Object[] downloads = new Download[dataSources.length];
        System.arraycopy(dataSources, 0, downloads, 0, dataSources.length);
        return downloads;
    }

    private void addPluginItem(Composite detailArea, final org.gudy.azureus2.plugins.ui.menus.MenuItem item) {
        MenuItemImpl menuImpl = (MenuItemImpl)item;
        menuImpl.invokeMenuWillBeShownListeners(this.getTarget(item));
        if (!item.isVisible()) {
            return;
        }
        Graphic graphic = item.getGraphic();
        FancyRowInfo row = item.getStyle() == 5 ? this.createMenuRow(detailArea, item.getResourceKey(), null, new FancyMenuRowInfoListener(){

            public void buildMenu(Menu menu) {
                if (TorrentMenuFancy.this.dms.length != 0) {
                    MenuBuildUtils.addPluginMenuItems((Composite)TorrentMenuFancy.this.parentShell, item.getItems(), menu, false, true, new MenuBuildUtils.PluginMenuController(){

                        public Listener makeSelectionListener(final org.gudy.azureus2.plugins.ui.menus.MenuItem plugin_menu_item) {
                            return new TableSelectedRowsListener(TorrentMenuFancy.this.tv, false){

                                public boolean run(TableRowCore[] rows) {
                                    if (rows.length != 0) {
                                        ((MenuItemImpl)plugin_menu_item).invokeListenersMulti(TorrentMenuFancy.this.getTarget(item));
                                    }
                                    return true;
                                }
                            };
                        }

                        public void notifyFillListeners(org.gudy.azureus2.plugins.ui.menus.MenuItem menu_item) {
                            ((MenuItemImpl)menu_item).invokeMenuWillBeShownListeners(TorrentMenuFancy.this.getTarget(item));
                        }
                    });
                }
            }
        }) : this.createRow(detailArea, item.getResourceKey(), null, new TableSelectedRowsListener(this.tv, false){

            public boolean run(TableRowCore[] rows) {
                if (rows.length != 0) {
                    ((MenuItemImpl)item).invokeListenersMulti(TorrentMenuFancy.this.getTarget(item));
                }
                return true;
            }
        });
        row.setEnabled(item.isEnabled());
        if (graphic instanceof UISWTGraphic) {
            row.getIconLabel().setImage(((UISWTGraphic)graphic).getImage());
        }
    }

    protected void buildTorrentCustomMenu_Content(Composite detailArea, DownloadManager[] dms) {
        if (this.hasSelection) {
            this.createRow(detailArea, "MyTorrentsView.menu.open", "run", new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    TorrentUtil.runDataSources(dms);
                }
            });
        }
        if (this.hasSelection) {
            final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            this.createRow(detailArea, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"), null, new ListenerDMTask(dms, false){

                public void run(DownloadManager dm) {
                    ManagerUtils.open(dm, use_open_containing_folder);
                }
            });
        }
        boolean fileMove = true;
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            if (dm.canMoveDataFiles()) continue;
            fileMove = false;
            break;
        }
        if (fileMove) {
            this.createRow(detailArea, "MyTorrentsView.menu.movedata", null, new ListenerDMTask(dms){

                public void run(DownloadManager[] dms) {
                    TorrentUtil.moveDataFiles(TorrentMenuFancy.this.parentShell, dms);
                }
            });
        }
        this.createRow(detailArea, "MyTorrentsView.menu.checkfilesexist", null, new ListenerDMTask(dms){

            public void run(DownloadManager dm) {
                dm.filesExist(true);
            }
        });
        this.createRow(detailArea, "MyTorrentsView.menu.thisColumn.toClipboard", null, new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore[] rows;
                String sToClipboard = "";
                if (TorrentMenuFancy.this.column == null) {
                    return;
                }
                String columnName = TorrentMenuFancy.this.column.getName();
                if (columnName == null) {
                    return;
                }
                for (TableRowCore row : rows = TorrentMenuFancy.this.tv.getSelectedRows()) {
                    TableCellCore cell;
                    if (row != rows[0]) {
                        sToClipboard = sToClipboard + "\n";
                    }
                    if ((cell = row.getTableCellCore(columnName)) == null) continue;
                    sToClipboard = sToClipboard + cell.getClipboardText();
                }
                if (sToClipboard.length() == 0) {
                    return;
                }
                new Clipboard(Display.getDefault()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
    }

    private HeaderInfo addHeader(String title, String id, AERunnable runnable) {
        Composite composite = new Composite(this.topArea, 0);
        composite.setBackgroundMode(2);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 6;
        fillLayout.marginHeight = 2;
        composite.setLayout((Layout)fillLayout);
        Display d = composite.getDisplay();
        composite.setBackground(d.getSystemColor(25));
        composite.setForeground(d.getSystemColor(24));
        Label control = new Label(composite, 0);
        control.setText(title);
        control.setData("ID", (Object)id);
        control.addListener(6, this.headerListener);
        control.addListener(7, this.headerListener);
        control.addListener(9, this.headerListener);
        HeaderInfo headerInfo = new HeaderInfo(id, runnable, composite);
        this.mapHeaderRunnables.put(id, headerInfo);
        return headerInfo;
    }

    private static class FancyMenuRowInfo
    extends FancyRowInfo {
        private Menu menu;

        private FancyMenuRowInfo() {
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            this.menu = menu;
        }
    }

    private static interface FancyMenuRowInfoListener {
        public void buildMenu(Menu var1);
    }

    private static class FancyRowInfo {
        private Listener listener;
        private Label lblText;
        private Label lblRight;
        private Label lblIcon;
        private Label lblCheck;
        private Composite cRow;
        private boolean keepMenu;
        private boolean isSelected;

        private FancyRowInfo() {
        }

        public void setEnabled(boolean enabled) {
            this.cRow.setEnabled(enabled);
        }

        public Label getRightLabel() {
            if (this.lblRight == null) {
                this.lblRight = new Label(this.cRow, 0);
                GridData gd = new GridData();
                gd.horizontalIndent = 10;
                this.lblRight.setLayoutData((Object)gd);
                this.lblRight.setEnabled(false);
            }
            return this.lblRight;
        }

        public Listener getListener() {
            return this.listener;
        }

        public void setListener(Listener listener) {
            this.listener = listener;
        }

        public Label getText() {
            return this.lblText;
        }

        public void setText(Label lblText) {
            this.lblText = lblText;
        }

        public void setRightLabel(Label lblRight) {
            this.lblRight = lblRight;
        }

        public void setRightLabelText(String s) {
            this.getRightLabel().setText(s);
        }

        public Label getIconLabel() {
            return this.lblIcon;
        }

        public void setIconLabel(Label lblIcon) {
            this.lblIcon = lblIcon;
        }

        public Composite getRow() {
            return this.cRow;
        }

        public void setRow(Composite cRow) {
            this.cRow = cRow;
        }

        public boolean keepMenu() {
            return this.keepMenu;
        }

        public void setKeepMenu(boolean keepMenu) {
            this.keepMenu = keepMenu;
        }

        public void setSelection(boolean isSelected) {
            this.isSelected = isSelected;
            ImageLoader.getInstance().setLabelImage(this.lblCheck, isSelected ? "check_yes" : "check_no");
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setCheckLabel(Label lblCheck) {
            this.lblCheck = lblCheck;
        }
    }

    private static class HeaderInfo {
        Runnable runnable;
        Composite composite;
        String id;

        public HeaderInfo(String id, Runnable runnable, Composite composite) {
            this.runnable = runnable;
            this.composite = composite;
            this.id = id;
        }
    }
}

