/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.help;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.update.CorePatchLevel;

public class AboutWindow {
    private static final String IMG_SPLASH = "azureus_splash";
    static Image image;
    static AEMonitor class_mon;
    private static Shell instance;
    private static Image imgSrc;
    private static int paintColorTo;

    public static void show() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                AboutWindow._show();
            }
        });
    }

    private static void _show() {
        if (instance != null) {
            instance.open();
            return;
        }
        paintColorTo = 0;
        final Shell window = ShellFactory.createMainShell(2144);
        Utils.setShellIcon(window);
        final Display display = window.getDisplay();
        window.setText(MessageText.getString("MainWindow.about.title") + " " + Constants.getCurrentVersion());
        window.setLayout((Layout)new GridLayout(2, false));
        ImageLoader imageLoader = ImageLoader.getInstance();
        imgSrc = imageLoader.getImage(IMG_SPLASH);
        if (imgSrc != null) {
            int w;
            int ow = w = AboutWindow.imgSrc.getBounds().width;
            if (w > 350) {
                w = 350;
            }
            int h = AboutWindow.imgSrc.getBounds().height;
            Image imgGray = new Image((Device)display, imageLoader.getImage(IMG_SPLASH), 2);
            imageLoader.releaseImage(IMG_SPLASH);
            GC gc = new GC((Drawable)imgGray);
            if (Constants.isOSX) {
                gc.drawImage(imgGray, (w - ow) / 2, 0);
            } else {
                gc.copyArea(0, 0, ow, h, (w - ow) / 2, 0);
            }
            gc.dispose();
            Image image2 = new Image((Device)display, w, h);
            gc = new GC((Drawable)image2);
            gc.setBackground(window.getBackground());
            gc.fillRectangle(image2.getBounds());
            gc.dispose();
            image = Utils.renderTransparency(display, image2, imgGray, new Point(0, 0), 180);
            image2.dispose();
            imgGray.dispose();
        }
        final Canvas labelImage = new Canvas((Composite)window, 0x20000000);
        GridData gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 0;
        Rectangle imgBounds = image.getBounds();
        gridData.widthHint = 300;
        gridData.heightHint = imgBounds.height + imgBounds.y + 20;
        labelImage.setLayoutData((Object)gridData);
        labelImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    Rectangle boundsColor = imgSrc.getBounds();
                    int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                    if (paintColorTo > 0) {
                        e.gc.drawImage(imgSrc, 0, 0, paintColorTo, boundsColor.height, ofs, 10, paintColorTo, boundsColor.height);
                    }
                    Rectangle imgBounds = image.getBounds();
                    if (imgBounds.width - paintColorTo - 1 > 0) {
                        e.gc.drawImage(image, paintColorTo + 1, 0, imgBounds.width - paintColorTo - 1, imgBounds.height, paintColorTo + 1 + ofs, 10, imgBounds.width - paintColorTo - 1, imgBounds.height);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Group gInternet = new Group((Composite)window, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gInternet.setLayout((Layout)gridLayout);
        Messages.setLanguageText((Widget)gInternet, "MainWindow.about.section.internet");
        gridData = new GridData(272);
        gInternet.setLayoutData((Object)gridData);
        Group gSys = new Group((Composite)window, 0);
        gSys.setLayout((Layout)new GridLayout());
        Messages.setLanguageText((Widget)gSys, "MainWindow.about.section.system");
        gridData = new GridData(272);
        gridData.verticalSpan = 1;
        gSys.setLayoutData((Object)gridData);
        Text txtSysInfo = new Text((Composite)gSys, 74);
        txtSysInfo.setBackground(display.getSystemColor(22));
        txtSysInfo.setText("Java " + System.getProperty("java.version") + "\n " + System.getProperty("java.vendor") + "\n" + "SWT v" + SWT.getVersion() + ", " + SWT.getPlatform() + "\n" + System.getProperty("os.name") + " v" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "\n" + Constants.APP_NAME.charAt(0) + Constants.getCurrentVersion() + ("".length() == 0 ? "" : "-") + "/" + CorePatchLevel.getCurrentPatchLevel() + " " + COConfigurationManager.getStringParameter("ui"));
        gridData = new GridData(1808);
        txtSysInfo.setLayoutData((Object)gridData);
        if (window.getCaret() != null) {
            window.getCaret().setVisible(false);
        }
        String[][] link = new String[][]{{"homepage", "sourceforge", "bugreports", "forumdiscussion", "wiki", "!Vuze Wiki Hidden Service (I2P)", "contributors", "!EULA", "!Privacy Policy"}, {"http://www.vuze.com", "http://sourceforge.net/projects/azureus", "http://forum.vuze.com/forum.jspa?forumID=124", "http://forum.vuze.com", "http://wiki.vuze.com/w/", "http://que23xpe7o3lzq6auv6stb4bha7ddavrlgqdv2cuhgd36fgfmp6q.b32.i2p/", "http://wiki.vuze.com/w/Contributors", "http://www.vuze.com/corp/terms.php", "http://www.vuze.com/corp/privacy.php"}};
        for (int i = 0; i < link[0].length; ++i) {
            CLabel linkLabel = new CLabel((Composite)gInternet, 0);
            if (link[0][i].startsWith("!")) {
                linkLabel.setText(link[0][i].substring(1));
            } else {
                linkLabel.setText(MessageText.getString("MainWindow.about.internet." + link[0][i]));
            }
            linkLabel.setData((Object)link[1][i]);
            linkLabel.setCursor(display.getSystemCursor(21));
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }

                public void mouseUp(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }
            });
            ClipboardCopy.addCopyToClipMenu((Control)linkLabel);
        }
        Label labelOwner = new Label((Composite)window, 0x1000040);
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 0;
        labelOwner.setLayoutData((Object)gridData);
        labelOwner.setText("Vuze is a product of Azureus Software, Inc.");
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        };
        window.addListener(2, keyListener);
        window.pack();
        txtSysInfo.setFocus();
        Utils.centreWindow(window);
        window.open();
        instance = window;
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                instance = null;
                AboutWindow.disposeImage();
            }
        });
        AEThread2 updater = new AEThread2("Splash Screen Updater", true){

            public void run() {
                if (image == null || image.isDisposed()) {
                    return;
                }
                int maxX = AboutWindow.image.getBounds().width;
                final int maxY = AboutWindow.image.getBounds().height;
                while (paintColorTo < maxX) {
                    if (image == null || image.isDisposed()) {
                        paintColorTo = maxX;
                        break;
                    }
                    if (display.isDisposed()) {
                        paintColorTo = maxX;
                        break;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (labelImage.isDisposed()) {
                                return;
                            }
                            paintColorTo++;
                            Rectangle boundsColor = imgSrc.getBounds();
                            int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                            labelImage.redraw(paintColorTo - 1 + ofs, 10, 2, maxY, true);
                        }
                    });
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        };
        updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeImage() {
        try {
            class_mon.enter();
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.releaseImage(IMG_SPLASH);
            image = null;
            imgSrc = null;
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        try {
            Display display = new Display();
            Colors.getInstance();
            SWTThread.createInstance(null);
            AboutWindow.show();
            while (!display.isDisposed() && instance != null && !instance.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!display.isDisposed()) {
                display.dispose();
            }
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            e.printStackTrace();
        }
    }

    static {
        class_mon = new AEMonitor("AboutWindow");
        paintColorTo = 0;
    }
}

