/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.backup.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.backup.BackupManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.UpdateInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupManagerImpl
implements BackupManager {
    private static BackupManagerImpl singleton;
    private AzureusCore core;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean first_schedule_check = true;
    private TimerEvent backup_event;
    private long last_auto_backup;
    private volatile boolean closing;

    public static synchronized BackupManager getSingleton(AzureusCore core) {
        if (singleton == null) {
            singleton = new BackupManagerImpl(core);
        }
        return singleton;
    }

    private BackupManagerImpl(AzureusCore _core) {
        this.core = _core;
        COConfigurationManager.addParameterListener(new String[]{"br.backup.auto.enable", "br.backup.auto.everydays", "br.backup.auto.retain"}, new ParameterListener(){
            private COConfigurationListener save_listener;
            private Object lock = this;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String parameter) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.save_listener == null) {
                        this.save_listener = new COConfigurationListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void configurationSaved() {
                                BackupManagerImpl.this.checkSchedule();
                                COConfigurationManager.removeListener(this);
                                Object object = lock;
                                synchronized (object) {
                                    if (save_listener == this) {
                                        save_listener = null;
                                    }
                                }
                            }
                        };
                        COConfigurationManager.addListener(this.save_listener);
                    }
                }
            }
        });
        this.checkSchedule();
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void stopping(AzureusCore core) {
                BackupManagerImpl.this.closing = true;
            }
        });
    }

    @Override
    public long getLastBackupTime() {
        return COConfigurationManager.getLongParameter("br.backup.last.time", 0L);
    }

    @Override
    public String getLastBackupError() {
        return COConfigurationManager.getStringParameter("br.backup.last.error", "");
    }

    private void checkSchedule() {
        this.checkSchedule(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSchedule(final BackupManager.BackupListener listener, boolean force) {
        boolean enabled = COConfigurationManager.getBooleanParameter("br.backup.auto.enable");
        boolean do_backup = false;
        BackupManagerImpl backupManagerImpl = this;
        synchronized (backupManagerImpl) {
            if (this.backup_event != null) {
                this.backup_event.cancel();
                this.backup_event = null;
            }
            if (this.first_schedule_check) {
                String current_ver;
                String last_ver;
                if (!enabled && !(last_ver = COConfigurationManager.getStringParameter("br.backup.config.info.ver", "")).equals(current_ver = "5.5.0.1_B36")) {
                    COConfigurationManager.setParameter("br.backup.config.info.ver", current_ver);
                    Logger.log(new LogAlert(false, 0, MessageText.getString("br.backup.setup.info")));
                }
                this.first_schedule_check = false;
                if (!force) {
                    if (enabled) {
                        this.backup_event = SimpleTimer.addEvent("BM:startup", SystemTime.getCurrentTime() + 300000L, new TimerEventPerformer(){

                            public void perform(TimerEvent event2) {
                                BackupManagerImpl.this.checkSchedule();
                            }
                        });
                    }
                    return;
                }
            }
            if (!enabled) {
                System.out.println("Auto backup is disabled");
                if (listener != null) {
                    listener.reportError(new Exception("Auto-backup not enabled"));
                }
                return;
            }
            long now_utc = SystemTime.getCurrentTime();
            int offset = TimeZone.getDefault().getOffset(now_utc);
            long now_local = now_utc + (long)offset;
            long DAY = 86400000L;
            long local_day_index = now_local / DAY;
            long last_auto_backup_day = COConfigurationManager.getLongParameter("br.backup.auto.last_backup_day", 0L);
            if (last_auto_backup_day > local_day_index) {
                last_auto_backup_day = local_day_index;
            }
            long backup_every_days = COConfigurationManager.getLongParameter("br.backup.auto.everydays");
            long utc_next_backup = (last_auto_backup_day + (backup_every_days = Math.max(1L, backup_every_days))) * DAY;
            long time_to_next_backup = utc_next_backup - now_local;
            if (time_to_next_backup <= 0L || force) {
                if (now_utc - this.last_auto_backup >= 14400000L || force) {
                    do_backup = true;
                    this.last_auto_backup = now_utc;
                    COConfigurationManager.setParameter("br.backup.auto.last_backup_day", local_day_index);
                } else {
                    time_to_next_backup = 14400000L;
                }
            }
            if (!do_backup) {
                time_to_next_backup = Math.max(time_to_next_backup, 60000L);
                System.out.println("Scheduling next backup in " + TimeFormatter.format(time_to_next_backup / 1000L));
                this.backup_event = SimpleTimer.addEvent("BM:auto", now_utc + time_to_next_backup, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        BackupManagerImpl.this.checkSchedule();
                    }
                });
            }
        }
        if (do_backup) {
            String backup_dir = COConfigurationManager.getStringParameter("br.backup.auto.dir", "");
            System.out.println("Auto backup starting: folder=" + backup_dir);
            final File target_dir = new File(backup_dir);
            this.backup(target_dir, new BackupManager.BackupListener(){

                public boolean reportProgress(String str) {
                    if (listener != null) {
                        try {
                            return listener.reportProgress(str);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void reportComplete() {
                    try {
                        System.out.println("Auto backup completed");
                        COConfigurationManager.save();
                        if (COConfigurationManager.getBooleanParameter("br.backup.notify")) {
                            Logger.log(new LogAlert(true, 0, "Backup completed at " + new Date()));
                        }
                        int backup_retain = COConfigurationManager.getIntParameter("br.backup.auto.retain");
                        backup_retain = Math.max(1, backup_retain);
                        File[] backups = target_dir.listFiles();
                        ArrayList<File> backup_dirs = new ArrayList<File>();
                        for (File f : backups) {
                            File test_file;
                            if (!f.isDirectory() || BackupManagerImpl.this.getBackupDirTime(f) <= 0L || !(test_file = new File(f, "azureus.config")).exists()) continue;
                            backup_dirs.add(f);
                        }
                        Collections.sort(backup_dirs, new Comparator<File>(){

                            @Override
                            public int compare(File o1, File o2) {
                                long t1 = BackupManagerImpl.this.getBackupDirTime(o1);
                                long t2 = BackupManagerImpl.this.getBackupDirTime(o2);
                                long res = t2 - t1;
                                if (res < 0L) {
                                    return -1;
                                }
                                if (res > 0L) {
                                    return 1;
                                }
                                Debug.out("hmm: " + o1 + "/" + o2);
                                return 0;
                            }
                        });
                        for (int i = backup_retain; i < backup_dirs.size(); ++i) {
                            File f = (File)backup_dirs.get(i);
                            System.out.println("Deleting old backup: " + f);
                            FileUtil.recursiveDeleteNoCheck(f);
                        }
                    }
                    finally {
                        if (listener != null) {
                            try {
                                listener.reportComplete();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        BackupManagerImpl.this.checkSchedule();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void reportError(Throwable error) {
                    try {
                        System.out.println("Auto backup failed");
                        Logger.log(new LogAlert(true, 3, "Backup failed at " + new Date(), error));
                    }
                    finally {
                        if (listener != null) {
                            try {
                                listener.reportError(error);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        BackupManagerImpl.this.checkSchedule();
                    }
                }
            });
        } else if (listener != null) {
            listener.reportError(new Exception("Backup not scheduled to run now"));
        }
    }

    @Override
    public void runAutoBackup(BackupManager.BackupListener listener) {
        this.checkSchedule(listener, true);
    }

    @Override
    public void backup(final File parent_folder, final BackupManager.BackupListener _listener) {
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                BackupManager.BackupListener listener = new BackupManager.BackupListener(){

                    public boolean reportProgress(String str) {
                        return _listener.reportProgress(str);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void reportComplete() {
                        try {
                            this.setStatus("");
                        }
                        finally {
                            _listener.reportComplete();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void reportError(Throwable error) {
                        try {
                            this.setStatus(Debug.getNestedExceptionMessage(error));
                        }
                        finally {
                            _listener.reportError(error);
                        }
                    }
                };
                BackupManagerImpl.this.backupSupport(parent_folder, listener);
            }

            private void setStatus(String error) {
                COConfigurationManager.setParameter("br.backup.last.time", SystemTime.getCurrentTime());
                COConfigurationManager.setParameter("br.backup.last.error", error);
            }
        });
    }

    private void checkClosing() throws Exception {
        if (this.closing) {
            throw new Exception("operation cancelled, app is closing");
        }
    }

    private long[] copyFiles(File from_file, File to_file) throws Exception {
        return this.copyFilesSupport(from_file, to_file, 1);
    }

    private long[] copyFilesSupport(File from_file, File to_file, int depth) throws Exception {
        long total_files = 0L;
        long total_copied = 0L;
        if (depth > 16) {
            throw new Exception("Loop detected in backup path, abandoning");
        }
        if (from_file.isDirectory()) {
            File[] files;
            if (!to_file.mkdirs()) {
                throw new Exception("Failed to create '" + to_file.getAbsolutePath() + "'");
            }
            for (File f : files = from_file.listFiles()) {
                this.checkClosing();
                long[] temp = this.copyFilesSupport(f, new File(to_file, f.getName()), depth + 1);
                total_files += temp[0];
                total_copied += temp[1];
            }
        } else {
            if (!FileUtil.copyFile(from_file, to_file)) {
                String name = from_file.getName().toLowerCase();
                if (name.equals(".lock") || name.equals("lock") || name.equals("stats.lck")) {
                    return new long[]{total_files, total_copied};
                }
                throw new Exception("Failed to copy file '" + from_file + "'");
            }
            total_copied = from_file.length();
        }
        return new long[]{++total_files, total_copied};
    }

    private long getBackupDirTime(File file) {
        String name = file.getName();
        int pos = name.indexOf(".");
        long suffix = 0L;
        if (pos != -1) {
            try {
                suffix = Integer.parseInt(name.substring(pos + 1));
                name = name.substring(0, pos);
            }
            catch (Throwable e) {
                return -1L;
            }
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(name).getTime() + suffix;
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void backupSupport(File parent_folder, final BackupManager.BackupListener _listener) {
        try {
            String date_dir = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            File backup_folder = null;
            boolean ok = false;
            try {
                File[] user_files;
                this.checkClosing();
                if (parent_folder.getName().length() == 0) throw new Exception("Backup folder '" + parent_folder + "' is invalid");
                if (!parent_folder.isDirectory()) {
                    throw new Exception("Backup folder '" + parent_folder + "' is invalid");
                }
                BackupManager.BackupListener listener = new BackupManager.BackupListener(){

                    public boolean reportProgress(String str) {
                        if (!_listener.reportProgress(str)) {
                            throw new RuntimeException("Operation abandoned by listener");
                        }
                        return true;
                    }

                    public void reportComplete() {
                        _listener.reportComplete();
                    }

                    public void reportError(Throwable error) {
                        _listener.reportError(error);
                    }
                };
                for (int i = 0; i < 100; ++i) {
                    File test_file;
                    String test_dir = date_dir;
                    if (i > 0) {
                        test_dir = test_dir + "." + i;
                    }
                    if ((test_file = new File(parent_folder, test_dir)).exists()) continue;
                    backup_folder = test_file;
                    backup_folder.mkdirs();
                    break;
                }
                if (backup_folder == null) {
                    backup_folder = new File(parent_folder, date_dir);
                }
                File user_dir = new File(SystemProperties.getUserPath());
                for (File temp_dir = backup_folder; temp_dir != null; temp_dir = temp_dir.getParentFile()) {
                    if (!temp_dir.equals(user_dir)) continue;
                    throw new Exception("Backup folder '" + backup_folder + "' is not permitted to be within the configuration folder '" + user_dir + "'.\r\nSelect an alternative location.");
                }
                listener.reportProgress("Writing to " + backup_folder.getAbsolutePath());
                if (!backup_folder.exists() && !backup_folder.mkdirs()) {
                    throw new Exception("Failed to create '" + backup_folder.getAbsolutePath() + "'");
                }
                listener.reportProgress("Syncing current state");
                this.core.saveState();
                listener.reportProgress("Reading configuration data from " + user_dir.getAbsolutePath());
                for (File f : user_files = user_dir.listFiles()) {
                    this.checkClosing();
                    String name = f.getName();
                    if (f.isDirectory() ? name.equals("cache") || name.equals("tmp") || name.equals("logs") || name.equals("updates") || name.equals("debug") : name.equals(".lock") || name.equals("update.properties") || name.endsWith(".log")) continue;
                    File dest_file = new File(backup_folder, name);
                    listener.reportProgress("Copying '" + name + "' ...");
                    long[] result = this.copyFiles(f, dest_file);
                    String result_str = DisplayFormatters.formatByteCountToKiBEtc(result[1]);
                    if (result[0] > 1L) {
                        result_str = result[0] + " files, " + result_str;
                    }
                    listener.reportProgress(result_str);
                }
                listener.reportComplete();
                return;
            }
            catch (Throwable throwable) {
                if (ok) throw throwable;
                if (backup_folder == null) throw throwable;
                FileUtil.recursiveDeleteNoCheck(backup_folder);
                throw throwable;
            }
        }
        catch (Throwable e) {
            _listener.reportError(e);
        }
    }

    @Override
    public void restore(final File backup_folder, final BackupManager.BackupListener listener) {
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                BackupManagerImpl.this.restoreSupport(backup_folder, listener);
            }
        });
    }

    private void addActions(UpdateInstaller installer, File source, File target) throws Exception {
        if (source.isDirectory()) {
            File[] files;
            for (File f : files = source.listFiles()) {
                this.addActions(installer, f, new File(target, f.getName()));
            }
        } else {
            installer.addMoveAction(source.getAbsolutePath(), target.getAbsolutePath());
        }
    }

    private int patch(Map<String, Object> map, String from, String to) {
        int mods = 0;
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        while (it.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            Object new_value = value = entry.getValue();
            if (value instanceof Map) {
                mods += this.patch((Map)value, from, to);
            } else if (value instanceof List) {
                mods += this.patch((List)value, from, to);
            } else if (value instanceof byte[]) {
                try {
                    String str = new String((byte[])value, "UTF-8");
                    if (str.startsWith(from)) {
                        new_value = to + str.substring(from.length());
                        ++mods;
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (key.startsWith(from)) {
                String new_key = to + key.substring(from.length());
                ++mods;
                it.remove();
                replacements.put(new_key, new_value);
                continue;
            }
            if (value == new_value) continue;
            entry.setValue(new_value);
        }
        map.putAll(replacements);
        return mods;
    }

    private int patch(List list, String from, String to) {
        int mods = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object entry = list.get(i);
            if (entry instanceof Map) {
                mods += this.patch((Map)entry, from, to);
                continue;
            }
            if (entry instanceof List) {
                mods += this.patch((List)entry, from, to);
                continue;
            }
            if (!(entry instanceof byte[])) continue;
            try {
                String str = new String((byte[])entry, "UTF-8");
                if (!str.startsWith(from)) continue;
                list.set(i, to + str.substring(from.length()));
                ++mods;
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return mods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreSupport(File backup_folder, BackupManager.BackupListener listener) {
        try {
            UpdateInstaller installer = null;
            File temp_dir = null;
            boolean ok = false;
            try {
                listener.reportProgress("Reading from " + backup_folder.getAbsolutePath());
                if (!backup_folder.isDirectory()) {
                    throw new Exception("Location '" + backup_folder.getAbsolutePath() + "' must be a directory");
                }
                listener.reportProgress("Analysing backup");
                File config = new File(backup_folder, "azureus.config");
                if (!config.exists()) {
                    throw new Exception("Invalid backup: azureus.config not found");
                }
                Map<String, Object> config_map = BDecoder.decode(FileUtil.readFileAsByteArray(config));
                byte[] temp = (byte[])config_map.get("azureus.user.directory");
                if (temp == null) {
                    throw new Exception("Invalid backup: azureus.config doesn't contain user directory details");
                }
                File current_user_dir = new File(SystemProperties.getUserPath());
                File backup_user_dir = new File(new String(temp, "UTF-8"));
                listener.reportProgress("Current user directory:\t" + current_user_dir.getAbsolutePath());
                listener.reportProgress("Backup's user directory:\t" + backup_user_dir.getAbsolutePath());
                temp_dir = AETemporaryFileHandler.createTempDir();
                PluginInterface pi = this.core.getPluginManager().getDefaultPluginInterface();
                installer = pi.getUpdateManager().createInstaller();
                File[] files = backup_folder.listFiles();
                if (current_user_dir.equals(backup_user_dir)) {
                    listener.reportProgress("Directories are the same, no patching required");
                    for (File f : files) {
                        File source = new File(temp_dir, f.getName());
                        listener.reportProgress("Creating restore action for '" + f.getName() + "'");
                        this.copyFiles(f, source);
                        File target = new File(current_user_dir, f.getName());
                        this.addActions(installer, source, target);
                    }
                } else {
                    listener.reportProgress("Directories are different, backup requires patching");
                    for (File f : files) {
                        File source = new File(temp_dir, f.getName());
                        listener.reportProgress("Creating restore action for '" + f.getName() + "'");
                        if (f.isDirectory() || !f.getName().contains(".config")) {
                            this.copyFiles(f, source);
                        } else {
                            boolean patched = false;
                            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f), 0x100000);
                            try {
                                int applied;
                                Map<String, Object> m = BDecoder.decode(bis);
                                bis.close();
                                bis = null;
                                if (m.size() > 0 && (applied = this.patch(m, backup_user_dir.getAbsolutePath(), current_user_dir.getAbsolutePath())) > 0) {
                                    listener.reportProgress("    Applied " + applied + " patches");
                                    patched = FileUtil.writeBytesAsFile2(source.getAbsolutePath(), BEncoder.encode(m));
                                    if (!patched) {
                                        throw new Exception("Failed to write " + source);
                                    }
                                }
                            }
                            finally {
                                if (bis != null) {
                                    try {
                                        bis.close();
                                    }
                                    catch (Throwable e) {}
                                }
                            }
                            if (!patched) {
                                this.copyFiles(f, source);
                            }
                        }
                        File target = new File(current_user_dir, f.getName());
                        this.addActions(installer, source, target);
                    }
                }
                listener.reportProgress("Restore action creation complete, restart required to complete the operation");
                listener.reportComplete();
                return;
            }
            catch (Throwable throwable) {
                if (ok) throw throwable;
                if (installer != null) {
                    installer.destroy();
                }
                if (temp_dir == null) throw throwable;
                FileUtil.recursiveDeleteNoCheck(temp_dir);
                throw throwable;
            }
        }
        catch (Throwable e) {
            listener.reportError(e);
        }
    }
}

