/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peer.cache.cachelogic;

import com.aelitis.azureus.core.peer.cache.CacheDiscoverer;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.peer.cache.CachePeer;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class CLCacheDiscovery
implements CacheDiscoverer {
    public static final String CDPDomainName = ".find-cache.com";
    public static final String CDPServerName = "cls.find-cache.com";
    public static final int CDPPort = 19523;
    public static final int CDPVersion = 0;
    public static final int CDPTimeout = 5000;
    static CDPResponse Response;

    private String byteArrayToHex(byte[] Bytes, int Max) {
        int Length = Bytes.length;
        if (Length > Max) {
            Length = Max;
        }
        String Result2 = new String();
        for (int Index = 0; Index < Length; ++Index) {
            int Value = Bytes[Index] & 0xFF;
            if (Value < 16) {
                Result2 = Result2 + "0";
            }
            Result2 = Result2 + Integer.toHexString(Value);
        }
        return Result2;
    }

    private String lookupFarm() {
        if (Response != null) {
            if (Response.isStillValid()) {
                return Response.getFarmID();
            }
            Response = null;
        }
        try {
            InetAddress CDPServer = InetAddress.getByName(CDPServerName);
            DatagramSocket Socket2 = new DatagramSocket();
            Socket2.setSoTimeout(5000);
            CDPQuery Query = new CDPQuery("Azureus 5.5.0.1_B36");
            byte[] Buffer2 = Query.getBytes();
            DatagramPacket Packet2 = new DatagramPacket(Buffer2, Buffer2.length, CDPServer, 19523);
            Socket2.send(Packet2);
            Buffer2 = new byte[262];
            Packet2.setData(Buffer2);
            Socket2.receive(Packet2);
            if (Packet2.getAddress() != CDPServer || Packet2.getPort() != 19523) {
                throw new Exception("CDP server address mismatch on response");
            }
            Response = new CDPResponse(Packet2.getData());
            return Response.getFarmID();
        }
        catch (Throwable Excpt) {
            if (!(Excpt instanceof UnknownHostException)) {
                Excpt.printStackTrace();
            }
            return "default";
        }
    }

    private String hashAnnounceURL(URL announce_url) {
        byte[] Digest2 = new SHA1Hasher().calculateHash(announce_url.getHost().getBytes());
        return this.byteArrayToHex(Digest2, 16);
    }

    public InetAddress[] findCache(URL announce_url, String hex_hash) {
        InetAddress[] Caches2;
        String Hostname = "bt-" + hex_hash.substring(0, 4) + ".bt-" + this.hashAnnounceURL(announce_url) + "-" + this.lookupFarm() + CDPDomainName;
        try {
            Caches2 = InetAddress.getAllByName(Hostname);
        }
        catch (UnknownHostException NoCache) {
            Caches2 = new InetAddress[]{};
        }
        return Caches2;
    }

    public InetAddress[] findCache(URL announce_url, byte[] hash) {
        return this.findCache(announce_url, this.byteArrayToHex(hash, 4));
    }

    public CachePeer[] lookup(TOTorrent torrent) {
        try {
            InetAddress[] addresses = this.findCache(torrent.getAnnounceURL(), torrent.getHash());
            CachePeer[] result = new CachePeer[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                result[i] = new CacheDiscovery.CachePeerImpl(2, addresses[i], 6881);
            }
            return result;
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return new CachePeer[0];
        }
    }

    public CachePeer lookup(byte[] peer_id, InetAddress ip, int port) {
        if (PeerClassifier.getClientDescription(peer_id).startsWith("CacheLogic")) {
            return new CacheDiscovery.CachePeerImpl(2, ip, port);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(new File("C:\\temp\\test.torrent"));
            CachePeer[] peers = new CLCacheDiscovery().lookup(torrent);
            System.out.println("peers=" + peers.length);
            for (int i = 0; i < peers.length; ++i) {
                System.out.println("    cache: " + peers[i].getAddress() + ":" + peers[i].getPort());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class CDPQuery {
        private String Client;

        public CDPQuery(String _Client) {
            this.Client = _Client;
        }

        byte[] getBytes() {
            String Temp = "@@@" + this.Client;
            byte[] Bytes = Temp.getBytes();
            Bytes[0] = 0;
            Bytes[1] = 0;
            Bytes[2] = (byte)this.Client.length();
            return Bytes;
        }
    }

    class CDPResponse {
        public static final int MinSize = 7;
        public static final int MaxSize = 262;
        String farmID;
        long validUntil;

        public CDPResponse(byte[] Bytes) throws Exception {
            int Index;
            if (Bytes.length < 7 || 7 + Bytes[6] > Bytes.length) {
                throw new Exception("CDP response too short");
            }
            if (Bytes[0] != 0) {
                throw new Exception("Unsupported CDP version");
            }
            this.farmID = new String();
            for (Index = 0; Index < Bytes[6]; ++Index) {
                this.farmID = this.farmID + (char)Bytes[7 + Index];
            }
            long Timeout = 0L;
            for (Index = 2; Index < 6; ++Index) {
                Timeout = (Timeout << 8) + (long)(Bytes[Index] & 0xFF);
            }
            this.validUntil = System.currentTimeMillis() + Timeout * 1000L;
        }

        public String getFarmID() {
            return this.farmID;
        }

        public boolean isStillValid() {
            return System.currentTimeMillis() < this.validUntil;
        }
    }
}

