/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.util.FeatureAvailability;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SpeedTokenDispenserPrioritised
implements SpeedTokenDispenser {
    private int rateKiB;
    private long threshold;
    private long bucket;
    private long lastTime;
    private long currentTime;
    private static final int BUCKET_THRESHOLD_LOWER_BOUND = 32768;
    private static final int BUCKET_RESPONSE_TIME = 1;
    private static final int BUCKET_THRESHOLD_FACTOR = 1024;

    public SpeedTokenDispenserPrioritised() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Max Download Speed KBs", "Use Request Limiting"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                SpeedTokenDispenserPrioritised.this.rateKiB = COConfigurationManager.getIntParameter("Max Download Speed KBs");
                if (!COConfigurationManager.getBooleanParameter("Use Request Limiting") || !FeatureAvailability.isRequestLimitingEnabled()) {
                    SpeedTokenDispenserPrioritised.this.rateKiB = 0;
                }
                if (SpeedTokenDispenserPrioritised.this.rateKiB < 0) {
                    SpeedTokenDispenserPrioritised.this.rateKiB = 0;
                }
                SpeedTokenDispenserPrioritised.this.threshold = Math.max(1024 * SpeedTokenDispenserPrioritised.this.rateKiB, 32768);
                SpeedTokenDispenserPrioritised.this.lastTime = SpeedTokenDispenserPrioritised.this.currentTime - 1L;
                SpeedTokenDispenserPrioritised.this.refill();
            }
        });
        this.bucket = 0L;
        this.lastTime = SystemTime.getCurrentTime();
    }

    public void update(long newTime) {
        this.currentTime = newTime;
    }

    public void refill() {
        if (this.lastTime == this.currentTime || this.rateKiB == 0) {
            return;
        }
        if (this.lastTime > this.currentTime) {
            this.lastTime = this.currentTime;
            return;
        }
        if (this.bucket < 0L) {
            Debug.out("Bucket is more than empty! - " + this.bucket);
            this.bucket = 0L;
        }
        long delta = this.currentTime - this.lastTime;
        this.lastTime = this.currentTime;
        long tickDelta = (long)this.rateKiB * 1024L * delta / 1000L;
        this.bucket += tickDelta;
        if (this.bucket > this.threshold) {
            this.bucket = this.threshold;
        }
    }

    public int dispense(int numberOfChunks, int chunkSize) {
        if (this.rateKiB == 0) {
            return numberOfChunks;
        }
        if ((long)chunkSize > this.bucket) {
            return 0;
        }
        if ((long)(chunkSize * numberOfChunks) <= this.bucket) {
            this.bucket -= (long)(chunkSize * numberOfChunks);
            return numberOfChunks;
        }
        int availableChunks = (int)(this.bucket / (long)chunkSize);
        this.bucket -= (long)(chunkSize * availableChunks);
        return availableChunks;
    }

    public void returnUnusedChunks(int unused, int chunkSize) {
        this.bucket += (long)(unused * chunkSize);
    }

    public int peek(int chunkSize) {
        if (this.rateKiB != 0) {
            return (int)(this.bucket / (long)chunkSize);
        }
        return Integer.MAX_VALUE;
    }
}

