/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.versioncheck;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.DNSUtils;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientListener;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPCodecs;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPReply;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPRequest;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPReleasablePacketHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionCheckClient {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String REASON_UPDATE_CHECK_START = "us";
    public static final String REASON_UPDATE_CHECK_PERIODIC = "up";
    public static final String REASON_CHECK_SWT = "sw";
    public static final String REASON_DHT_FLAGS = "df";
    public static final String REASON_DHT_EXTENDED_ALLOWED = "dx";
    public static final String REASON_DHT_ENABLE_ALLOWED = "de";
    public static final String REASON_EXTERNAL_IP = "ip";
    public static final String REASON_RECOMMENDED_PLUGINS = "rp";
    public static final String REASON_SECONDARY_CHECK = "sc";
    public static final String REASON_PLUGIN_UPDATE = "pu";
    public static final String REASON_DHT_BOOTSTRAP = "db";
    private static final String AZ_MSG_SERVER_ADDRESS_V4 = "version.vuze.com";
    private static final int AZ_MSG_SERVER_PORT = 27001;
    private static final String MESSAGE_TYPE_ID = "AZVER";
    public static final String HTTP_SERVER_ADDRESS_V4 = "version.vuze.com";
    public static final int HTTP_SERVER_PORT = 80;
    public static final String TCP_SERVER_ADDRESS_V4 = "version.vuze.com";
    public static final int TCP_SERVER_PORT = 80;
    public static final String UDP_SERVER_ADDRESS_V4 = "version.vuze.com";
    public static final int UDP_SERVER_PORT = 2080;
    public static final String AZ_MSG_SERVER_ADDRESS_V6 = "version6.vuze.com";
    public static final String HTTP_SERVER_ADDRESS_V6 = "version6.vuze.com";
    public static final String TCP_SERVER_ADDRESS_V6 = "version6.vuze.com";
    public static final String UDP_SERVER_ADDRESS_V6 = "version6.vuze.com";
    private static final long CACHE_PERIOD = 300000L;
    private static boolean secondary_check_done;
    private final List<VersionCheckClientListener> listeners = new ArrayList<VersionCheckClientListener>(1);
    private boolean startCheckRan = false;
    private static final int AT_V4 = 1;
    private static final int AT_V6 = 2;
    private static final int AT_EITHER = 3;
    private static VersionCheckClient instance;
    private boolean enable_v6;
    private boolean prefer_v6;
    private Map last_check_data_v4 = null;
    private Map last_check_data_v6 = null;
    private final AEMonitor check_mon = new AEMonitor("versioncheckclient");
    private long last_check_time_v4 = 0L;
    private long last_check_time_v6 = 0L;
    private long last_feature_flag_cache;
    private long last_feature_flag_cache_time;

    public static synchronized VersionCheckClient getSingleton() {
        if (instance == null) {
            instance = new VersionCheckClient();
        }
        return instance;
    }

    private VersionCheckClient() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"IPV6 Prefer Addresses", "IPV6 Enable Support"}, new ParameterListener(){

            public void parameterChanged(String name) {
                VersionCheckClient.this.enable_v6 = COConfigurationManager.getBooleanParameter("IPV6 Enable Support");
                VersionCheckClient.this.prefer_v6 = COConfigurationManager.getBooleanParameter("IPV6 Prefer Addresses");
            }
        });
    }

    public void initialise() {
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("VersionCheck", new Runnable(){

            public void run() {
                final AESemaphore sem = new AESemaphore("VCC:init");
                new AEThread2("VCC:init", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            VersionCheckClient.this.getVersionCheckInfo(VersionCheckClient.REASON_UPDATE_CHECK_START);
                            Object var2_1 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                }.start();
                if (!sem.reserve(5000L)) {
                    Debug.out("Timeout waiting for version check to complete");
                }
            }
        });
        delayed_task.queue();
    }

    public Map getVersionCheckInfo(String reason) {
        return this.getVersionCheckInfo(reason, 3);
    }

    public Map getVersionCheckInfo(String reason, int address_type) {
        if (address_type == 1) {
            return this.getVersionCheckInfoSupport(reason, false, false, false);
        }
        if (address_type == 2) {
            return this.getVersionCheckInfoSupport(reason, false, false, true);
        }
        Map reply = this.getVersionCheckInfoSupport(reason, false, false, this.prefer_v6);
        if (reply == null || reply.size() == 0) {
            reply = this.getVersionCheckInfoSupport(reason, false, false, !this.prefer_v6);
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getVersionCheckInfoSupport(String reason, boolean only_if_cached, boolean force, boolean v6) {
        block34: {
            try {
                List<VersionCheckClientListener> list = this.listeners;
                synchronized (list) {
                    if (REASON_UPDATE_CHECK_START.equals(reason)) {
                        this.startCheckRan = true;
                    }
                    for (VersionCheckClientListener versionCheckClientListener : this.listeners) {
                        versionCheckClientListener.versionCheckStarted(reason);
                    }
                }
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            if (v6) {
                if (this.enable_v6) {
                    block33: {
                        try {
                            this.check_mon.enter();
                            long time_diff = SystemTime.getCurrentTime() - this.last_check_time_v6;
                            boolean bl = force = force || time_diff > 300000L || time_diff < 0L;
                            if (this.last_check_data_v6 == null || this.last_check_data_v6.size() == 0 || force) {
                                if (only_if_cached && this.last_check_data_v6 != null) {
                                    HashMap hashMap = new HashMap();
                                    Object var10_21 = null;
                                    this.check_mon.exit();
                                    return hashMap;
                                }
                                try {
                                    this.last_check_data_v6 = this.performVersionCheck(VersionCheckClient.constructVersionCheckMessage(reason), true, true, true);
                                    if (this.last_check_data_v6 != null && this.last_check_data_v6.size() > 0) {
                                        COConfigurationManager.setParameter("versioncheck.cache.v6", this.last_check_data_v6);
                                    }
                                    break block33;
                                }
                                catch (SocketException socketException) {
                                }
                                catch (UnknownHostException unknownHostException) {
                                }
                                catch (Throwable throwable) {
                                    Debug.out(throwable);
                                    this.last_check_data_v6 = new HashMap();
                                }
                                break block33;
                            }
                            Logger.log(new LogEvent(LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data_v6.size() + " reply keys."));
                        }
                        catch (Throwable throwable) {
                            Object var10_23 = null;
                            this.check_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var10_22 = null;
                    this.check_mon.exit();
                }
                if (this.last_check_data_v6 == null) {
                    this.last_check_data_v6 = new HashMap();
                }
                return this.last_check_data_v6;
            }
            try {
                this.check_mon.enter();
                long time_diff = SystemTime.getCurrentTime() - this.last_check_time_v4;
                boolean bl = force = force || time_diff > 300000L || time_diff < 0L;
                if (this.last_check_data_v4 == null || this.last_check_data_v4.size() == 0 || force) {
                    if (only_if_cached && this.last_check_data_v4 != null) {
                        HashMap hashMap = new HashMap();
                        Object var12_27 = null;
                        this.check_mon.exit();
                        return hashMap;
                    }
                    try {
                        this.last_check_data_v4 = this.performVersionCheck(VersionCheckClient.constructVersionCheckMessage(reason), true, true, false);
                        if (this.last_check_data_v4 != null && this.last_check_data_v4.size() > 0) {
                            COConfigurationManager.setParameter("versioncheck.cache.v4", this.last_check_data_v4);
                        }
                        try {
                            if (AzureusCoreFactory.isCoreAvailable() && AzureusCoreFactory.getSingleton().getPluginManager().isInitialized()) {
                                PluginInterface[] pluginInterfaceArray = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                                for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                                    PluginInterface plugin = pluginInterfaceArray[i];
                                    Map data = plugin.getPluginconfig().getPluginMapParameter("plugin.versionserver.data", null);
                                    if (data == null) continue;
                                    plugin.getPluginconfig().setPluginMapParameter("plugin.versionserver.data", new HashMap());
                                }
                            }
                            break block34;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        Debug.outNoStack("VersionCheckClient - " + unknownHostException.getClass().getName() + ": " + unknownHostException.getMessage());
                    }
                    catch (IOException iOException) {
                        Debug.outNoStack("VersionCheckClient - " + iOException.getClass().getName() + ": " + iOException.getMessage());
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                        this.last_check_data_v4 = new HashMap();
                    }
                    break block34;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data_v4.size() + " reply keys."));
                }
            }
            catch (Throwable throwable) {
                Object var12_29 = null;
                this.check_mon.exit();
                throw throwable;
            }
        }
        Object var12_28 = null;
        this.check_mon.exit();
        if (this.last_check_data_v4 == null) {
            this.last_check_data_v4 = new HashMap();
        }
        this.last_feature_flag_cache_time = 0L;
        return this.last_check_data_v4;
    }

    public Map getMostRecentVersionCheckData() {
        if (this.last_check_data_v4 != null) {
            return this.last_check_data_v4;
        }
        Map res = COConfigurationManager.getMapParameter("versioncheck.cache.v4", null);
        if (res != null) {
            return res;
        }
        if (this.last_check_data_v6 != null) {
            return this.last_check_data_v6;
        }
        res = COConfigurationManager.getMapParameter("versioncheck.cache.v6", null);
        return res;
    }

    private boolean isVersionCheckDataValid(int address_type) {
        boolean v4_ok;
        boolean v6_ok = this.last_check_data_v6 != null && this.last_check_data_v6.size() > 0;
        boolean bl = v4_ok = this.last_check_data_v4 != null && this.last_check_data_v4.size() > 0;
        if (address_type == 1) {
            return v4_ok;
        }
        if (address_type == 2) {
            return v6_ok;
        }
        return v4_ok | v6_ok;
    }

    public long getCacheTime(boolean v6) {
        return v6 ? this.last_check_time_v6 : this.last_check_time_v4;
    }

    public void clearCache() {
        this.last_check_time_v6 = 0L;
        this.last_check_time_v4 = 0L;
    }

    public long getFeatureFlags() {
        long result;
        long now = SystemTime.getCurrentTime();
        if (now > this.last_feature_flag_cache_time && now - this.last_feature_flag_cache_time < 60000L) {
            return this.last_feature_flag_cache;
        }
        Map m = this.getMostRecentVersionCheckData();
        if (m == null) {
            result = 0L;
        } else {
            byte[] b_feat_flags = (byte[])m.get("feat_flags");
            if (b_feat_flags != null) {
                try {
                    result = Long.parseLong(new String(b_feat_flags));
                }
                catch (Throwable e) {
                    result = 0L;
                }
            } else {
                result = 0L;
            }
        }
        this.last_feature_flag_cache = result;
        this.last_feature_flag_cache_time = now;
        return result;
    }

    public Set<String> getDisabledPluginIDs() {
        byte[] x;
        HashSet<String> result = new HashSet<String>();
        Map m = this.getMostRecentVersionCheckData();
        if (m != null && (x = (byte[])m.get("disabled_pids")) != null) {
            String[] bits;
            String str = new String(x);
            String latest = COConfigurationManager.getStringParameter("vc.disabled_pids.latest", "");
            if (!str.equals(latest)) {
                byte[] sig = (byte[])m.get("disabled_pids_sig");
                if (sig == null) {
                    Debug.out("disabled plugins sig missing");
                    return result;
                }
                try {
                    AEVerifier.verifyData(str, sig);
                    COConfigurationManager.setParameter("vc.disabled_pids.latest", str);
                }
                catch (Throwable e) {
                    return result;
                }
            }
            for (String b : bits = str.split(",")) {
                if ((b = b.trim()).length() <= 0) continue;
                result.add(b);
            }
        }
        return result;
    }

    public Set<String> getAutoInstallPluginIDs() {
        byte[] x;
        HashSet<String> result = new HashSet<String>();
        Map m = this.getMostRecentVersionCheckData();
        if (m != null && (x = (byte[])m.get("autoinstall_pids")) != null) {
            String[] bits;
            String str = new String(x);
            String latest = COConfigurationManager.getStringParameter("vc.autoinstall_pids.latest", "");
            if (!str.equals(latest)) {
                byte[] sig = (byte[])m.get("autoinstall_pids_sig");
                if (sig == null) {
                    Debug.out("autoinstall plugins sig missing");
                    return result;
                }
                try {
                    AEVerifier.verifyData(str, sig);
                    COConfigurationManager.setParameter("vc.autoinstall_pids.latest", str);
                }
                catch (Throwable e) {
                    return result;
                }
            }
            for (String b : bits = str.split(",")) {
                if ((b = b.trim()).length() <= 0) continue;
                result.add(b);
            }
        }
        return result;
    }

    public String getExternalIpAddress(boolean only_if_cached, boolean v6) {
        return this.getExternalIpAddress(only_if_cached, v6, false);
    }

    public String getExternalIpAddress(boolean only_if_cached, boolean v6, boolean force) {
        Map reply = this.getVersionCheckInfoSupport(REASON_EXTERNAL_IP, only_if_cached, force, v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        if (address != null) {
            return new String(address);
        }
        return null;
    }

    public boolean DHTEnableAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_ENABLE_ALLOWED, 3);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid(3);
        }
        return res;
    }

    public boolean DHTExtendedUseAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_EXTENDED_ALLOWED, 3);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht_extended_use");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid(3);
        }
        return res;
    }

    public byte getDHTFlags() {
        byte[] b_flags;
        Map map = this.getMostRecentVersionCheckData();
        if (map != null && (b_flags = (byte[])map.get("dht_flags")) != null) {
            return new Integer(new String(b_flags)).byteValue();
        }
        return -1;
    }

    public String[] getRecommendedPlugins() {
        Map reply = this.getVersionCheckInfo(REASON_RECOMMENDED_PLUGINS, 3);
        List l = (List)reply.get("recommended_plugins");
        if (l == null) {
            return new String[0];
        }
        String[] res = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            res[i] = new String((byte[])l.get(i));
        }
        return res;
    }

    public List<InetSocketAddress> getDHTBootstrap(boolean ipv4) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        try {
            Map reply = this.getVersionCheckInfo(REASON_DHT_BOOTSTRAP, ipv4 ? 1 : 2);
            List l = (List)reply.get("dht_boot");
            if (l != null) {
                for (Map m : l) {
                    InetAddress iaddress;
                    byte[] address = (byte[])m.get("a");
                    int port = ((Long)m.get("p")).intValue();
                    if ((!ipv4 || address.length != 4) && (ipv4 || address.length != 16) || (iaddress = InetAddress.getByAddress(address)).isLoopbackAddress() || iaddress.isLinkLocalAddress() || iaddress.isSiteLocalAddress()) continue;
                    result.add(new InetSocketAddress(iaddress, port));
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return result;
    }

    public Map<String, Object> getCountryInfo() {
        Map reply = this.getVersionCheckInfo(REASON_EXTERNAL_IP, 3);
        Map info = (Map)reply.get("source_info");
        if (info == null) {
            return new HashMap<String, Object>();
        }
        return BDecoder.decodeStrings(info);
    }

    private Map performVersionCheck(Map data_to_send, boolean use_az_message, boolean use_http, boolean v6) throws Exception {
        Exception error = null;
        Map reply = null;
        if (use_http) {
            try {
                reply = this.executeHTTP(data_to_send, v6);
                reply.put("protocol_used", "HTTP");
                error = null;
            }
            catch (IOException e) {
                error = e;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                error = e;
            }
        }
        if (reply == null && use_az_message) {
            try {
                reply = this.executeAZMessage(data_to_send, v6);
                reply.put("protocol_used", "AZMSG");
                error = null;
            }
            catch (IOException e) {
                error = e;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient server version check successful. Received " + (reply == null ? "null" : Integer.valueOf(reply.size())) + " reply keys."));
        }
        if (v6) {
            this.last_check_time_v6 = SystemTime.getCurrentTime();
        } else {
            this.last_check_time_v4 = SystemTime.getCurrentTime();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeAZMessage(Map data_to_send, boolean v6) throws Exception {
        if (v6 && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String host = this.getHost(v6, "version6.vuze.com", "version.vuze.com");
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + host + ":" + 27001));
        }
        ClientMessageService msg_service = null;
        Map reply = null;
        try {
            msg_service = ClientMessageServiceClient.getServerService(host, 27001, 20, MESSAGE_TYPE_ID);
            msg_service.sendMessage(data_to_send);
            reply = msg_service.receiveMessage();
            this.preProcessReply(reply, v6);
            Object var7_6 = null;
            if (msg_service != null) {
                msg_service.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (msg_service != null) {
                msg_service.close();
            }
            throw throwable;
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map executeHTTP(Map data_to_send, boolean v6) throws Exception {
        if (v6 && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String host = this.getHost(v6, "version6.vuze.com", "version.vuze.com");
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + host + ":" + 80 + " via HTTP"));
        }
        String url_str = "http://" + (v6 ? UrlUtils.convertIPV6Host(host) : host) + "" + "/version?";
        url_str = url_str + URLEncoder.encode(new String(BEncoder.encode(data_to_send), "ISO-8859-1"), "ISO-8859-1");
        URL url = new URL(url_str);
        try {
            HttpURLConnection url_connection = (HttpURLConnection)url.openConnection();
            url_connection.setConnectTimeout(10000);
            url_connection.setReadTimeout(10000);
            url_connection.connect();
            try {
                InputStream is = url_connection.getInputStream();
                Map<String, Object> reply = BDecoder.decode(new BufferedInputStream(is));
                this.preProcessReply(reply, v6);
                Map<String, Object> map = reply;
                Object var11_14 = null;
                url_connection.disconnect();
                return map;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                url_connection.disconnect();
                throw throwable;
            }
        }
        catch (Exception e) {
            AEProxyFactory.PluginProxy proxy;
            if (!v6 && (proxy = AEProxyFactory.getPluginProxy("Vuze version check", url)) != null) {
                boolean worked = false;
                try {
                    Map<String, Object> map;
                    HttpURLConnection url_connection2 = (HttpURLConnection)proxy.getURL().openConnection(proxy.getProxy());
                    url_connection2.setConnectTimeout(30000);
                    url_connection2.setReadTimeout(30000);
                    url_connection2.connect();
                    try {
                        InputStream is = url_connection2.getInputStream();
                        Map<String, Object> reply = BDecoder.decode(new BufferedInputStream(is));
                        this.preProcessReply(reply, v6);
                        worked = true;
                        map = reply;
                        Object var14_20 = null;
                        url_connection2.disconnect();
                    }
                    catch (Throwable throwable2) {
                        Object var14_21 = null;
                        url_connection2.disconnect();
                        throw throwable2;
                    }
                    Object var16_22 = null;
                    proxy.setOK(worked);
                    return map;
                }
                catch (Throwable throwable3) {
                    Object var16_23 = null;
                    proxy.setOK(worked);
                    throw throwable3;
                }
            }
            throw e;
        }
    }

    public String getHTTPGetString(boolean for_proxy, boolean v6) {
        return this.getHTTPGetString(new HashMap(), for_proxy, v6);
    }

    private String getHTTPGetString(Map content, boolean for_proxy, boolean v6) {
        String host = this.getHost(v6, "version6.vuze.com", "version.vuze.com");
        String get_str = "GET " + (for_proxy ? "http://" + (v6 ? UrlUtils.convertIPV6Host(host) : host) + ":" + 80 : "") + "/version?";
        try {
            get_str = get_str + URLEncoder.encode(new String(BEncoder.encode(content), "ISO-8859-1"), "ISO-8859-1");
        }
        catch (Throwable e) {
            // empty catch block
        }
        get_str = get_str + " HTTP/1.1\r\n\r\n";
        return get_str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeTCP(Map data_to_send, InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        Map<String, Object> map;
        block15: {
            if (v6 && !this.enable_v6) {
                throw new Exception("IPv6 is disabled");
            }
            String host = this.getHost(v6, "version6.vuze.com", "version.vuze.com");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from " + host + ":" + 80 + " via TCP"));
            }
            String get_str = this.getHTTPGetString(data_to_send, false, v6);
            Socket socket = null;
            try {
                int len;
                int len2;
                socket = new Socket();
                if (bind_ip != null) {
                    socket.bind(new InetSocketAddress(bind_ip, bind_port));
                } else if (bind_port != 0) {
                    socket.bind(new InetSocketAddress(bind_port));
                }
                socket.setSoTimeout(10000);
                socket.connect(new InetSocketAddress(host, 80), 10000);
                OutputStream os = socket.getOutputStream();
                os.write(get_str.getBytes("ISO-8859-1"));
                os.flush();
                InputStream is = socket.getInputStream();
                byte[] buffer = new byte[1];
                String header = "";
                int content_length = -1;
                while ((len2 = is.read(buffer)) > 0) {
                    if ((header = header + (char)buffer[0]).endsWith("\r\n\r\n")) {
                        int pos = (header = header.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("content-length:");
                        if (pos == -1) {
                            throw new IOException("content length missing");
                        }
                        header = header.substring(pos + 15);
                        pos = header.indexOf(13);
                        content_length = Integer.parseInt(header = header.substring(0, pos).trim());
                        if (content_length <= 10000) break;
                        throw new IOException("content length too large");
                    }
                    if (header.length() <= 2048) continue;
                    throw new IOException("header too large");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(content_length);
                buffer = new byte[content_length];
                while (content_length > 0 && (len = is.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                    content_length -= len;
                }
                if (content_length != 0) {
                    throw new IOException("error reading reply");
                }
                byte[] reply_bytes = baos.toByteArray();
                Map<String, Object> reply = BDecoder.decode(new BufferedInputStream(new ByteArrayInputStream(reply_bytes)));
                this.preProcessReply(reply, v6);
                map = reply;
                Object var18_19 = null;
                if (socket == null) break block15;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var18_20 = null;
                    if (socket == null) break block16;
                    try {
                        socket.close();
                    }
                    catch (Throwable e) {}
                }
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map executeUDP(Map data_to_send, InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        if (v6 && !this.enable_v6) {
            throw new Exception("IPv6 is disabled");
        }
        String host = this.getHost(v6, "version6.vuze.com", "version.vuze.com");
        PRUDPReleasablePacketHandler handler = PRUDPPacketHandlerFactory.getReleasableHandler(bind_port);
        PRUDPPacketHandler packet_handler = handler.getHandler();
        long timeout = 5L;
        Random random = new Random();
        try {
            Map<String, Object> map;
            Exception last_error = null;
            packet_handler.setExplicitBindAddress(bind_ip);
            int i = 0;
            while (true) {
                if (i >= 3) {
                    if (last_error == null) throw new Exception("Timeout");
                    throw last_error;
                }
                try {
                    long connection_id = Long.MIN_VALUE | random.nextLong();
                    VersionCheckClientUDPRequest request_packet = new VersionCheckClientUDPRequest(connection_id);
                    request_packet.setPayload(data_to_send);
                    VersionCheckClientUDPReply reply_packet = (VersionCheckClientUDPReply)packet_handler.sendAndReceive(null, request_packet, new InetSocketAddress(host, 2080), timeout);
                    Map<String, Object> reply = reply_packet.getPayload();
                    this.preProcessReply(reply, v6);
                    map = reply;
                }
                catch (Exception e) {
                    last_error = e;
                    timeout *= 2L;
                    ++i;
                    continue;
                }
                break;
            }
            Object var20_18 = null;
            packet_handler.setExplicitBindAddress(null);
            handler.release();
            return map;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            packet_handler.setExplicitBindAddress(null);
            handler.release();
            throw throwable;
        }
    }

    protected void preProcessReply(Map reply, final boolean v6) {
        Long lEnabledUISwitcher;
        String done_asn;
        long advice;
        NetworkAdminASN current_asn;
        String asn;
        NetworkAdmin admin;
        block9: {
            admin = NetworkAdmin.getSingleton();
            try {
                byte[] address = (byte[])reply.get("source_ip_address");
                if (address != null) {
                    InetAddress my_ip = InetAddress.getByName(new String(address));
                    NetworkAdminASN old_asn = admin.getCurrentASN();
                    NetworkAdminASN new_asn = admin.lookupCurrentASN(my_ip);
                    if (!new_asn.sameAs(old_asn) && !secondary_check_done) {
                        secondary_check_done = true;
                        new AEThread("Secondary version check", true){

                            public void runSupport() {
                                VersionCheckClient.this.getVersionCheckInfoSupport(VersionCheckClient.REASON_SECONDARY_CHECK, false, true, v6);
                            }
                        }.start();
                    }
                }
            }
            catch (Throwable e) {
                if (Debug.containsException(e, UnknownHostException.class)) break block9;
                Debug.printStackTrace(e);
            }
        }
        Long as_advice = (Long)reply.get("as_advice");
        if (as_advice != null && (asn = (current_asn = admin.getCurrentASN()).getASName()) != null && (advice = as_advice.longValue()) != 0L && !(done_asn = COConfigurationManager.getStringParameter("ASN Advice Followed", "")).equals(asn)) {
            boolean alert;
            COConfigurationManager.setParameter("ASN Advice Followed", asn);
            boolean change = advice == 1L || advice == 2L;
            boolean bl = alert = advice == 1L || advice == 3L;
            if (!COConfigurationManager.getBooleanParameter("network.transport.encrypted.require")) {
                if (change) {
                    COConfigurationManager.setParameter("network.transport.encrypted.require", true);
                }
                if (alert) {
                    String msg = MessageText.getString("crypto.alert.as.warning", new String[]{asn});
                    Logger.log(new LogAlert(false, 1, msg));
                }
            }
        }
        if ((lEnabledUISwitcher = (Long)reply.get("ui.toolbar.uiswitcher")) != null) {
            COConfigurationManager.setBooleanDefault("ui.toolbar.uiswitcher", lEnabledUISwitcher == 1L);
        }
    }

    public InetAddress getExternalIpAddressHTTP(boolean v6) throws Exception {
        Map reply = this.executeHTTP(new HashMap(), v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        return address == null ? null : InetAddress.getByName(new String(address));
    }

    public InetAddress getExternalIpAddressTCP(InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        Map reply = this.executeTCP(new HashMap(), bind_ip, bind_port, v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        return address == null ? null : InetAddress.getByName(new String(address));
    }

    public InetAddress getExternalIpAddressUDP(InetAddress bind_ip, int bind_port, boolean v6) throws Exception {
        Map reply = this.executeUDP(new HashMap(), bind_ip, bind_port, v6);
        byte[] address = (byte[])reply.get("source_ip_address");
        return address == null ? null : InetAddress.getByName(new String(address));
    }

    protected String getHost(boolean v6, String v6_address, String v4_address) {
        if (v6) {
            v6_address = this.getTestAddress(true, v6_address);
            try {
                return InetAddress.getByName(v6_address).getHostAddress();
            }
            catch (UnknownHostException e) {
                DNSUtils.DNSUtilsIntf dns_utils = DNSUtils.getSingleton();
                if (dns_utils != null) {
                    try {
                        return dns_utils.getIPV6ByName(v6_address).getHostAddress();
                    }
                    catch (UnknownHostException f) {
                        // empty catch block
                    }
                }
                return v6_address;
            }
        }
        v4_address = this.getTestAddress(false, v4_address);
        return v4_address;
    }

    private String getTestAddress(boolean v6, String address) {
        return COConfigurationManager.getStringParameter("versioncheck.test.address." + v6, address);
    }

    public static Map<String, Object> constructVersionCheckMessage(String reason) {
        boolean send_info = COConfigurationManager.getBooleanParameter("Send Version Info");
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("appid", SystemProperties.getApplicationIdentifier());
        message.put("appname", SystemProperties.getApplicationName());
        message.put("version", "5.5.0.1_B36");
        message.put("first_version", COConfigurationManager.getStringParameter("First Recorded Version", ""));
        String sub_ver = "";
        if (sub_ver.length() > 0) {
            message.put("subver", sub_ver);
        }
        if (COConfigurationManager.getBooleanParameter("Beta Programme Enabled")) {
            message.put("beta_prog", "true");
        }
        message.put("ui", COConfigurationManager.getStringParameter("ui", "unknown"));
        message.put("os", Constants.OSName);
        message.put("os_version", System.getProperty("os.version"));
        message.put("os_arch", System.getProperty("os.arch"));
        message.put("os_arch_dm", System.getProperty("sun.arch.data.model"));
        boolean using_phe = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
        message.put("using_phe", using_phe ? new Long(1L) : new Long(0L));
        message.put("imode", COConfigurationManager.getStringParameter("installer.mode", ""));
        try {
            Class<?> c = Class.forName("org.eclipse.swt.SWT");
            String swt_platform = (String)c.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
            message.put("swt_platform", swt_platform);
            Integer swt_version = (Integer)c.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
            message.put("swt_version", new Long(swt_version.longValue()));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError er) {
        }
        catch (InvocationTargetException err) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        int last_send_time = COConfigurationManager.getIntParameter("Send Version Info Last Time", -1);
        int current_send_time = (int)(SystemTime.getCurrentTime() / 1000L);
        COConfigurationManager.setParameter("Send Version Info Last Time", current_send_time);
        String id = COConfigurationManager.getStringParameter("ID", null);
        if (id != null && send_info) {
            OverallStats stats2;
            String java_rt_version;
            message.put("id", id);
            try {
                byte[] id2 = CryptoManagerFactory.getSingleton().getSecureID();
                message.put("id2", id2);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (last_send_time != -1 && last_send_time < current_send_time) {
                message.put("tsl", new Long(current_send_time - last_send_time));
            }
            message.put("reason", reason);
            String java_version = Constants.JAVA_VERSION;
            if (java_version == null) {
                java_version = "unknown";
            }
            message.put("java", java_version);
            String java_vendor = System.getProperty("java.vm.vendor");
            if (java_vendor == null) {
                java_vendor = "unknown";
            }
            message.put("javavendor", java_vendor);
            int api_level = Constants.API_LEVEL;
            if (api_level > 0) {
                message.put("api_level", api_level);
            }
            long max_mem = Runtime.getRuntime().maxMemory() / 0x100000L;
            message.put("javamx", new Long(max_mem));
            String java_rt_name = System.getProperty("java.runtime.name");
            if (java_rt_name != null) {
                message.put("java_rt_name", java_rt_name);
            }
            if ((java_rt_version = System.getProperty("java.runtime.version")) != null) {
                message.put("java_rt_version", java_rt_version);
            }
            if ((stats2 = StatsFactory.getStats()) != null) {
                long total_uptime = stats2.getTotalUpTime();
                message.put("total_uptime", new Long(total_uptime));
            }
            try {
                int port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
                message.put("dht", port);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            try {
                NetworkAdminASN current_asn = NetworkAdmin.getSingleton().getCurrentASN();
                message.put("ip_as", current_asn.getAS());
                String asn = current_asn.getASName();
                if (asn.length() > 64) {
                    asn = asn.substring(0, 64);
                }
                message.put("ip_asn", asn);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            message.put("locale", Locale.getDefault().toString());
            String originalLocale = System.getProperty("user.language") + "_" + System.getProperty("user.country");
            String variant = System.getProperty("user.variant");
            if (variant != null && variant.length() > 0) {
                originalLocale = originalLocale + "_" + variant;
            }
            message.put("orig_locale", originalLocale);
            message.put("user_mode", COConfigurationManager.getIntParameter("User Mode", -1));
            Set<String> features = UtilitiesImpl.getFeaturesInstalled();
            if (features.size() > 0) {
                String str = "";
                for (String f : features) {
                    str = str + (str.length() == 0 ? "" : ",") + f;
                }
                message.put("vzfeatures", str);
            }
            try {
                if (AzureusCoreFactory.isCoreAvailable() && AzureusCoreFactory.getSingleton().getPluginManager().isInitialized()) {
                    PluginInterface[] plugins = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                    ArrayList<String> pids = new ArrayList<String>();
                    ArrayList vs_data = new ArrayList();
                    for (int i = 0; i < plugins.length; ++i) {
                        Map data;
                        PluginInterface plugin = plugins[i];
                        String pid = plugin.getPluginID();
                        String info = plugin.getPluginconfig().getPluginStringParameter("plugin.info");
                        if (info != null && info.length() > 0 || !pid.startsWith("<") && !pid.startsWith("azbp") && !pid.startsWith("azupdater") && !pid.startsWith("azplatform") && !pids.contains(pid)) {
                            if (info != null && info.length() > 0) {
                                if (info.length() < 256) {
                                    pid = pid + ":" + info;
                                } else {
                                    Debug.out("Plugin '" + pid + "' reported excessive info string '" + info + "'");
                                }
                            }
                            pids.add(pid);
                        }
                        if ((data = plugin.getPluginconfig().getPluginMapParameter("plugin.versionserver.data", null)) == null) continue;
                        HashMap<String, Object> payload = new HashMap<String, Object>();
                        byte[] data_bytes = BEncoder.encode(data);
                        if (data_bytes.length > 16384) {
                            Debug.out("Plugin '" + pid + "' reported excessive version server data (length=" + data_bytes.length + ")");
                            payload.put("error", "data too long: " + data_bytes.length);
                        } else {
                            payload.put("data", data_bytes);
                        }
                        payload.put("id", pid);
                        payload.put("version", plugin.getPluginVersion());
                        vs_data.add(payload);
                    }
                    message.put("plugins", pids);
                    if (vs_data.size() > 0) {
                        message.put("plugin_data", vs_data);
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVersionCheckClientListener(boolean triggerStartListener, VersionCheckClientListener l) {
        List<VersionCheckClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
            if (triggerStartListener && this.startCheckRan) {
                try {
                    l.versionCheckStarted(REASON_UPDATE_CHECK_START);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVersionCheckClientListener(VersionCheckClientListener l) {
        List<VersionCheckClientListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public static void main(String[] args) {
        try {
            COConfigurationManager.initialise();
            COConfigurationManager.setParameter("IPV6 Enable Support", true);
            boolean v6 = true;
            System.out.println("HTTP: " + VersionCheckClient.getSingleton().getExternalIpAddressHTTP(v6));
            Map<String, Object> data = VersionCheckClient.constructVersionCheckMessage(REASON_UPDATE_CHECK_START);
            System.out.println("Sending (pre-initialisation):");
            VersionCheckClient.printDataMap(data);
            System.out.println("-----------");
            System.out.println("Receiving (pre-initialisation):");
            VersionCheckClient.printDataMap(VersionCheckClient.getSingleton().getVersionCheckInfo(REASON_UPDATE_CHECK_START));
            System.out.println("-----------");
            System.out.println();
            System.out.print("Initialising core... ");
            AzureusCoreImpl.SUPPRESS_CLASSLOADER_ERRORS = true;
            DownloadManagerStateImpl.SUPPRESS_FIXUP_ERRORS = true;
            AzureusCore core = AzureusCoreFactory.create();
            core.start();
            System.out.println("done.");
            System.out.println();
            System.out.println("-----------");
            data = VersionCheckClient.constructVersionCheckMessage(REASON_UPDATE_CHECK_START);
            System.out.println("Sending (post-initialisation):");
            VersionCheckClient.printDataMap(data);
            System.out.println("-----------");
            System.out.println("Receiving (post-initialisation):");
            VersionCheckClient.printDataMap(VersionCheckClient.getSingleton().getVersionCheckInfo(REASON_UPDATE_CHECK_START));
            System.out.println("-----------");
            System.out.println();
            System.out.print("Shutting down core... ");
            core.stop();
            System.out.println("done.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void printDataMap(Map map) throws Exception {
        TreeMap res = new TreeMap(map);
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (!(val instanceof byte[])) continue;
            String as_bytes = ByteFormatter.nicePrint((byte[])val);
            String as_text = new String((byte[])val, "ISO-8859-1");
            res.put(key, as_text + " [" + as_bytes + "]");
        }
        for (Map.Entry entry : res.entrySet()) {
            System.out.print("  ");
            System.out.print(entry.getKey());
            System.out.print(": ");
            System.out.print(entry.getValue());
            System.out.println();
        }
    }

    static {
        VersionCheckClientUDPCodecs.registerCodecs();
    }
}

