/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryDatasourceListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLogIdListener;
import com.aelitis.azureus.ui.mdi.MdiEntryOpenListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.ui.UIPluginView;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarEnablerBase;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMdiEntry
implements MdiEntrySWT,
ViewTitleInfoListener {
    protected final MultipleDocumentInterface mdi;
    protected final String id;
    protected String logID;
    protected Object datasource;
    protected Class<? extends UIPluginView> viewClass;
    protected UISWTViewCore view;
    private String skinRef;
    private List<MdiCloseListener> listCloseListeners = null;
    private List<MdiChildCloseListener> listChildCloseListeners = null;
    private List<MdiEntryLogIdListener> listLogIDListeners = null;
    private List<MdiEntryOpenListener> listOpenListeners = null;
    private List<MdiEntryDropListener> listDropListeners = null;
    private List<MdiEntryDatasourceListener> listDatasourceListeners = null;
    protected ViewTitleInfo viewTitleInfo;
    private SWTSkinObject skinObject;
    private String title;
    private String titleID;
    private UISWTViewEventListener eventListener;
    private String parentID;
    private boolean pullTitleFromView;
    private boolean closeable;
    private Boolean isExpanded = null;
    private boolean disposed = false;
    private boolean added = false;
    private String imageLeftID;
    private Image imageLeft;
    private boolean collapseDisabled = false;
    private SWTSkinObject soMaster;
    private Set<UIToolBarEnablerBase> setToolBarEnablers = new HashSet<UIToolBarEnablerBase>(1);
    private String preferredAfterID;
    private Map<Object, Object> user_data;

    private BaseMdiEntry() {
        this.mdi = null;
        this.id = null;
        this.setDefaultExpanded(false);
    }

    public BaseMdiEntry(MultipleDocumentInterface mdi, String id) {
        int i;
        this.mdi = mdi;
        this.id = id;
        this.pullTitleFromView = true;
        this.logID = id == null ? "null" : ((i = id.indexOf(95)) > 0 ? id.substring(0, i) : id);
        this.setDefaultExpanded(false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MdiEntryVitalityImage addVitalityImage(String imageID) {
        return null;
    }

    @Override
    public boolean close(boolean forceClose) {
        if (!forceClose && this.view instanceof UISWTViewImpl && !((UISWTViewImpl)this.view).requestClose()) {
            return false;
        }
        this.setCloseable(this.closeable);
        this.disposed = true;
        ViewTitleInfoManager.removeListener(this);
        return true;
    }

    public Object getDatasourceCore() {
        return this.datasource;
    }

    @Override
    public String getExportableDatasource() {
        Object ds;
        if (this.viewTitleInfo != null && (ds = this.viewTitleInfo.getTitleInfoProperty(10)) != null) {
            return ds.toString();
        }
        return null;
    }

    @Override
    public Object getDatasource() {
        return PluginCoreUtils.convert(this.datasource, false);
    }

    @Override
    public void setDatasource(Object datasource) {
        this.datasource = datasource;
        this.triggerDatasourceListeners();
        if (this.view != null) {
            this.view.triggerEvent(1, datasource);
        }
        if (this.isAdded() && this.skinObject != null) {
            this.skinObject.triggerListeners(7, datasource);
        }
    }

    @Override
    public UIPluginView getView() {
        return this.view;
    }

    @Override
    public UISWTViewCore getCoreView() {
        return this.view;
    }

    @Override
    public Class<? extends UIPluginView> getViewClass() {
        return this.viewClass;
    }

    public void setViewClass(Class<? extends UIPluginView> viewClass) {
        this.viewClass = viewClass;
    }

    @Override
    public String getLogID() {
        return this.logID;
    }

    @Override
    public MultipleDocumentInterface getMDI() {
        return this.mdi;
    }

    @Override
    public String getParentID() {
        return this.parentID;
    }

    @Override
    public void setParentID(String id) {
        if (id == null || "Tools".equals(id)) {
            id = this.getId().equals("header.dvd") && id == null ? "" : "header.plugins";
        }
        if (id.equals(this.getId())) {
            Debug.out("Setting Parent to same ID as child! " + id);
            return;
        }
        this.parentID = id;
        this.mdi.loadEntryByID(this.parentID, false);
    }

    @Override
    public MdiEntryVitalityImage[] getVitalityImages() {
        return null;
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isCollapseDisabled() {
        return this.collapseDisabled;
    }

    @Override
    public void setCollapseDisabled(boolean collapseDisabled) {
        this.collapseDisabled = collapseDisabled;
        this.setExpanded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners == null) {
                this.listCloseListeners = new ArrayList<MdiCloseListener>(1);
            }
            this.listCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners != null) {
                this.listCloseListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCloseListeners(boolean user) {
        Object[] list = new Object[]{};
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listCloseListeners != null) {
                list = this.listCloseListeners.toArray();
            }
        }
        for (int i = 0; i < list.length; ++i) {
            MdiCloseListener l = (MdiCloseListener)list[i];
            try {
                l.mdiEntryClosed(this, user);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        MdiEntry parentEntry = this.mdi.getEntry(this.parentID);
        if (parentEntry instanceof BaseMdiEntry) {
            ((BaseMdiEntry)parentEntry).triggerChildCloseListeners(this, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiChildCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners == null) {
                this.listChildCloseListeners = new ArrayList<MdiChildCloseListener>(1);
            }
            this.listChildCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiChildCloseListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners != null) {
                this.listChildCloseListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerChildCloseListeners(MdiEntry child, boolean user) {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listChildCloseListeners == null) {
                return;
            }
            list = this.listChildCloseListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiChildCloseListener l = (MdiChildCloseListener)list[i];
            try {
                l.mdiChildEntryClosed(this, child, user);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLogIdListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners == null) {
                this.listLogIDListeners = new ArrayList<MdiEntryLogIdListener>(1);
            }
            this.listLogIDListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLogIdListener sideBarLogIdListener) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners != null) {
                this.listLogIDListeners.remove(sideBarLogIdListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerLogIDListeners(String oldID) {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listLogIDListeners == null) {
                return;
            }
            list = this.listLogIDListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryLogIdListener l = (MdiEntryLogIdListener)list[i];
            l.mdiEntryLogIdChanged(this, oldID, this.logID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryOpenListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners == null) {
                this.listOpenListeners = new ArrayList<MdiEntryOpenListener>(1);
            }
            this.listOpenListeners.add(l);
        }
        if (this.view != null) {
            l.mdiEntryOpen(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryOpenListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners != null) {
                this.listOpenListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerOpenListeners() {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listOpenListeners == null) {
                return;
            }
            list = this.listOpenListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryOpenListener l = (MdiEntryOpenListener)list[i];
            try {
                l.mdiEntryOpen(this);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryDatasourceListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDatasourceListeners == null) {
                this.listDatasourceListeners = new ArrayList<MdiEntryDatasourceListener>(1);
            }
            this.listDatasourceListeners.add(l);
        }
        l.mdiEntryDatasourceChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryDatasourceListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDatasourceListeners != null) {
                this.listDatasourceListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerDatasourceListeners() {
        Object[] list;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDatasourceListeners == null) {
                return;
            }
            list = this.listDatasourceListeners.toArray();
        }
        for (int i = 0; i < list.length; ++i) {
            MdiEntryDatasourceListener l = (MdiEntryDatasourceListener)list[i];
            try {
                l.mdiEntryDatasourceChanged(this);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryDropListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners == null) {
                this.listDropListeners = new ArrayList<MdiEntryDropListener>(1);
            }
            this.listDropListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryDropListener l) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners != null) {
                this.listDropListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDropListeners() {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            return this.listDropListeners != null && this.listDropListeners.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerDropListeners(Object o) {
        MdiEntryDropListener l;
        Object[] list;
        boolean handled = false;
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.listDropListeners == null) {
                return handled;
            }
            list = this.listDropListeners.toArray();
        }
        for (int i = 0; i < list.length && !(handled = (l = (MdiEntryDropListener)list[i]).mdiEntryDrop(this, o)); ++i) {
        }
        return handled;
    }

    @Override
    public void setLogID(String logID) {
        if (logID == null || logID.equals("" + this.logID)) {
            return;
        }
        String oldID = this.logID;
        this.logID = logID;
        this.triggerLogIDListeners(oldID);
    }

    @Override
    public ViewTitleInfo getViewTitleInfo() {
        return this.viewTitleInfo;
    }

    @Override
    public void setViewTitleInfo(ViewTitleInfo viewTitleInfo) {
        if (this.viewTitleInfo == viewTitleInfo) {
            return;
        }
        this.viewTitleInfo = viewTitleInfo;
        if (viewTitleInfo != null) {
            String imageID;
            String newTitle;
            if (viewTitleInfo instanceof ViewTitleInfo2) {
                ViewTitleInfo2 vti2 = (ViewTitleInfo2)viewTitleInfo;
                try {
                    vti2.titleInfoLinked(this.mdi, this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            if ((newTitle = (String)viewTitleInfo.getTitleInfoProperty(5)) != null) {
                this.setPullTitleFromView(false);
                this.setTitle(newTitle);
            }
            if ((imageID = (String)viewTitleInfo.getTitleInfoProperty(2)) != null) {
                this.setImageLeftID(imageID.length() == 0 ? null : imageID);
            }
            ViewTitleInfoManager.addListener(this);
        }
    }

    @Override
    public void addToolbarEnabler(ToolBarEnabler enabler) {
        this.addToolbarEnabler((UIToolBarEnablerBase)enabler);
    }

    @Override
    public void addToolbarEnabler(UIToolBarEnablerBase enabler) {
        this.setToolBarEnablers.add(enabler);
        this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
    }

    protected void setToolbarVisibility(boolean visible) {
    }

    @Override
    public void removeToolbarEnabler(UIToolBarEnablerBase enabler) {
        this.setToolBarEnablers.remove(enabler);
        this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
    }

    @Override
    public UIToolBarEnablerBase[] getToolbarEnablers() {
        UIPluginViewToolBarListener listener;
        if (this.view != null && (listener = this.view.getToolBarListener()) != null) {
            return new UIToolBarEnablerBase[]{listener};
        }
        return this.setToolBarEnablers.toArray(new UIToolBarEnablerBase[0]);
    }

    public void setCoreView(UISWTViewCore view) {
        if (this.view != null && view == null) {
            this.view.triggerEvent(7, null);
        }
        this.view = view;
        if (view == null) {
            return;
        }
        UISWTViewEventListener eventListener = view.getEventListener();
        if (view instanceof ViewTitleInfo) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)view));
        } else if (eventListener instanceof ViewTitleInfo) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)eventListener));
        }
        if (view instanceof UIToolBarEnablerBase) {
            this.addToolbarEnabler((UIToolBarEnablerBase)((Object)view));
        } else if (eventListener instanceof UIToolBarEnablerBase) {
            this.addToolbarEnabler((UIToolBarEnablerBase)((Object)eventListener));
        }
        if (this.datasource != null) {
            view.triggerEvent(1, this.datasource);
        }
    }

    public SWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setSkinObject(SWTSkinObject skinObject, SWTSkinObject soMaster) {
        this.skinObject = skinObject;
        this.soMaster = soMaster;
        if (this.datasource != null) {
            if (skinObject != null) {
                skinObject.triggerListeners(7, this.datasource);
            }
            if (this.view != null) {
                this.view.triggerEvent(1, this.datasource);
            }
        }
        if (skinObject != null) {
            this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
        }
    }

    public SWTSkinObject getSkinObjectMaster() {
        if (this.soMaster == null) {
            return this.skinObject;
        }
        return this.soMaster;
    }

    public void setSkinRef(String configID, Object params) {
        this.skinRef = configID;
        if (params != null) {
            this.setDatasource(params);
        }
    }

    public String getSkinRef() {
        return this.skinRef;
    }

    @Override
    public String getTitle() {
        if (this.title != null && !this.isPullTitleFromView()) {
            return this.title;
        }
        if (this.view != null) {
            return this.view.getFullTitle();
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        if (title.startsWith("{") && title.endsWith("}") && title.length() > 2) {
            this.setTitleID(title.substring(1, title.length() - 1));
            return;
        }
        if (title.equals(this.title)) {
            return;
        }
        this.title = title;
        this.titleID = null;
        this.redraw();
    }

    @Override
    public void setTitleID(String titleID) {
        String title = MessageText.getString(titleID);
        this.setTitle(title.startsWith("{") ? title.substring(1) : title);
        this.titleID = titleID;
    }

    public void updateLanguage() {
        if (this.view != null) {
            this.view.triggerEvent(6, null);
        }
        if (this.titleID != null) {
            this.setTitleID(this.titleID);
        } else {
            if (this.viewTitleInfo != null) {
                this.viewTitleInfoRefresh(this.viewTitleInfo);
            }
            this.updateUI();
        }
    }

    public void show() {
        SWTSkinObjectContainer container;
        Composite composite;
        if (this.skinObject == null) {
            return;
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uif != null) {
            uif.refreshTorrentMenu();
        }
        SWTSkinObject skinObject = this.getSkinObjectMaster();
        skinObject.setVisible(true);
        if (skinObject instanceof SWTSkinObjectContainer && (composite = (container = (SWTSkinObjectContainer)skinObject).getComposite()) != null && !composite.isDisposed()) {
            composite.setVisible(true);
            composite.moveAbove(null);
            composite.getParent().layout();
        }
        if (this.view != null) {
            Composite c = this.view.getComposite();
            if (c != null && !c.isDisposed()) {
                c.setData("BaseMDIEntry", (Object)this);
                c.setVisible(true);
                c.getParent().layout();
            }
            try {
                this.view.triggerEvent(3, null);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void hide() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                BaseMdiEntry.this.swt_hide();
            }
        });
    }

    @Override
    public void requestAttention() {
    }

    protected void swt_hide() {
        SWTSkinObject skinObjectMaster = this.getSkinObjectMaster();
        if (skinObjectMaster instanceof SWTSkinObjectContainer) {
            SWTSkinObjectContainer container = (SWTSkinObjectContainer)skinObjectMaster;
            Control oldComposite = container.getControl();
            container.setVisible(false);
            if (oldComposite != null && !oldComposite.isDisposed()) {
                oldComposite.getShell().update();
            }
        }
        if (this.view != null) {
            Composite oldComposite = this.view.getComposite();
            if (oldComposite != null && !oldComposite.isDisposed()) {
                oldComposite.setVisible(false);
                oldComposite.getShell().update();
            }
            try {
                this.view.triggerEvent(4, null);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(UISWTViewEventListener _eventListener) {
        UISWTViewEventListenerHolder h;
        UISWTViewEventListener delegatedEventListener;
        this.eventListener = _eventListener;
        if (this.view != null) {
            return;
        }
        try {
            this.setCoreView(new UISWTViewImpl(this.parentID, this.id, _eventListener, this.datasource));
        }
        catch (Exception e) {
            Debug.out(e);
        }
        if (_eventListener instanceof UISWTViewEventListenerHolder && (delegatedEventListener = (h = (UISWTViewEventListenerHolder)_eventListener).getDelegatedEventListener(this.view)) != null) {
            this.eventListener = delegatedEventListener;
        }
        if (this.eventListener instanceof UIToolBarEnablerBase) {
            this.addToolbarEnabler((UIToolBarEnablerBase)((Object)this.eventListener));
        }
        if (this.eventListener instanceof ViewTitleInfo && this.viewTitleInfo == null) {
            this.setViewTitleInfo((ViewTitleInfo)((Object)this.eventListener));
        }
        if (this.eventListener instanceof BasicPluginViewImpl && "image.sidebar.plugin".equals(this.getImageLeftID())) {
            this.setImageLeftID("image.sidebar.logview");
        }
    }

    public boolean isPullTitleFromView() {
        return this.pullTitleFromView;
    }

    public void setPullTitleFromView(boolean pullTitleFromView) {
        this.pullTitleFromView = pullTitleFromView;
    }

    @Override
    public void updateUI() {
        if (this.view == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BaseMdiEntry.this.view != null && !BaseMdiEntry.this.isDisposed()) {
                    BaseMdiEntry.this.view.triggerEvent(5, null);
                }
                if (BaseMdiEntry.this.isPullTitleFromView() && BaseMdiEntry.this.isAdded()) {
                    BaseMdiEntry.this.setTitle(BaseMdiEntry.this.view.getFullTitle());
                }
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public Map<String, Object> getAutoOpenInfo() {
        String eds;
        UISWTViewEventListener eventListener;
        LightHashMap<String, Object> autoOpenInfo = new LightHashMap<String, Object>();
        if (this.getParentID() != null) {
            autoOpenInfo.put("parentID", this.getParentID());
        }
        if ((eventListener = this.getEventListener()) != null) {
            autoOpenInfo.put("eventListenerClass", eventListener.getClass().getName());
        }
        autoOpenInfo.put("title", this.getTitle());
        Object datasource = this.getDatasourceCore();
        if (datasource instanceof DownloadManager) {
            try {
                autoOpenInfo.put("dm", ((DownloadManager)datasource).getTorrent().getHashWrapper().toBase32String());
            }
            catch (Throwable t) {}
        } else if (datasource instanceof DownloadManager[]) {
            DownloadManager[] dms = (DownloadManager[])datasource;
            ArrayList<String> list = new ArrayList<String>();
            for (DownloadManager dm : dms) {
                try {
                    list.add(dm.getTorrent().getHashWrapper().toBase32String());
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            autoOpenInfo.put("dms", list);
        }
        if ((eds = this.getExportableDatasource()) != null) {
            autoOpenInfo.put("datasource", eds.toString());
        }
        return autoOpenInfo;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        if (closeable) {
            this.mdi.informAutoOpenSet(this, this.getAutoOpenInfo());
            COConfigurationManager.setParameter("SideBar.AutoOpen." + this.id, true);
        } else {
            COConfigurationManager.removeParameter("SideBar.AutoOpen." + this.id);
        }
    }

    @Override
    public void setDefaultExpanded(boolean defaultExpanded) {
        COConfigurationManager.setBooleanDefault("SideBar.Expanded." + this.id, defaultExpanded);
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded == null ? COConfigurationManager.getBooleanParameter("SideBar.Expanded." + this.id) : this.isExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        boolean defExpanded = true;
        try {
            defExpanded = ConfigurationDefaults.getInstance().getBooleanParameter("SideBar.Expanded." + this.id);
        }
        catch (ConfigurationParameterNotFoundException configurationParameterNotFoundException) {
            // empty catch block
        }
        if (this.isExpanded == defExpanded) {
            COConfigurationManager.removeParameter("SideBar.Expanded." + this.id);
        } else {
            COConfigurationManager.setParameter("SideBar.Expanded." + this.id, this.isExpanded);
        }
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    public void setDisposed(boolean b) {
        this.disposed = b;
        this.added = !b;
    }

    @Override
    public void setImageLeftID(String id) {
        this.imageLeftID = id;
        this.imageLeft = null;
        this.redraw();
    }

    @Override
    public String getImageLeftID() {
        return this.imageLeftID;
    }

    @Override
    public void setImageLeft(Image imageLeft) {
        this.imageLeft = imageLeft;
        this.imageLeftID = null;
        this.redraw();
    }

    public Image getImageLeft(String suffix) {
        if (this.imageLeft != null) {
            return this.imageLeft;
        }
        if (this.imageLeftID == null) {
            return null;
        }
        Image img = null;
        img = suffix == null ? ImageLoader.getInstance().getImage(this.imageLeftID) : ImageLoader.getInstance().getImage(this.imageLeftID + suffix);
        if (ImageLoader.isRealImage(img)) {
            return img;
        }
        return null;
    }

    public void releaseImageLeft(String suffix) {
        if (this.imageLeft != null) {
            ImageLoader.getInstance().releaseImage(this.imageLeftID + (suffix == null ? "" : suffix));
        }
    }

    @Override
    public void viewTitleInfoRefresh(ViewTitleInfo titleInfoToRefresh) {
        String imageID;
        if (titleInfoToRefresh == null || this.viewTitleInfo != titleInfoToRefresh) {
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        String newText = (String)this.viewTitleInfo.getTitleInfoProperty(5);
        if (newText != null) {
            this.setPullTitleFromView(false);
            this.setTitle(newText);
        }
        if ((imageID = (String)this.viewTitleInfo.getTitleInfoProperty(2)) != null) {
            this.setImageLeftID(imageID.length() == 0 ? null : imageID);
        }
        this.redraw();
        String logID = (String)this.viewTitleInfo.getTitleInfoProperty(7);
        if (logID != null) {
            this.setLogID(logID);
        }
    }

    public void build() {
    }

    @Override
    public void setPreferredAfterID(String preferredAfterID) {
        this.preferredAfterID = preferredAfterID;
    }

    @Override
    public String getPreferredAfterID() {
        return this.preferredAfterID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.user_data == null) {
                this.user_data = new LightHashMap<Object, Object>();
            }
            this.user_data.put(key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        BaseMdiEntry baseMdiEntry = this;
        synchronized (baseMdiEntry) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(key);
        }
    }
}

