/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class ViewUpSpeedGraph
implements UISWTViewCoreEventListener {
    GlobalManager manager = null;
    GlobalManagerStats stats = null;
    Canvas upSpeedCanvas;
    SpeedGraphic upSpeedGraphic;
    TimerEventPeriodic timerEvent;
    private boolean everRefreshed = false;
    private UISWTView swtView;

    public ViewUpSpeedGraph() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                ViewUpSpeedGraph.this.manager = core.getGlobalManager();
                ViewUpSpeedGraph.this.stats = ViewUpSpeedGraph.this.manager.getStats();
            }
        });
    }

    private void initialize(Composite composite) {
        this.upSpeedCanvas = new Canvas(composite, 0x20000000);
        GridData gridData = new GridData(1808);
        this.upSpeedCanvas.setLayoutData((Object)gridData);
        this.upSpeedGraphic = SpeedGraphic.getInstance();
        this.upSpeedGraphic.initialize(this.upSpeedCanvas);
    }

    private void periodicUpdate() {
        if (this.stats == null || this.manager == null) {
            return;
        }
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.upSpeedGraphic.addIntsValue(new int[]{this.stats.getDataSendRate() + this.stats.getProtocolSendRate(), this.stats.getProtocolSendRate(), COConfigurationManager.getIntParameter(TransferSpeedValidator.getActiveUploadParameter(this.manager)) * 1024, swarms_peer_speed});
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.upSpeedCanvas);
        this.upSpeedGraphic.dispose();
    }

    private String getFullTitle() {
        return "UL Speed";
    }

    private Composite getComposite() {
        return this.upSpeedCanvas;
    }

    private void refresh() {
        if (!this.everRefreshed) {
            this.everRefreshed = true;
            this.timerEvent = SimpleTimer.addPeriodicEvent("TopBarSpeedGraphicView", 1000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    if (ViewUpSpeedGraph.this.upSpeedCanvas.isDisposed()) {
                        ViewUpSpeedGraph.this.timerEvent.cancel();
                    } else {
                        ViewUpSpeedGraph.this.periodicUpdate();
                    }
                }
            });
        }
        this.upSpeedGraphic.refresh(false);
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

