/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetUtils {
    private static final int MIN_NI_CHECK_MILLIS = 30000;
    private static final int INC1_NI_CHECK_MILLIS = 120000;
    private static final int INC2_NI_CHECK_MILLIS = 900000;
    private static int current_check_millis = 30000;
    private static long last_ni_check = -1L;
    private static volatile List<NetworkInterface> current_interfaces = new ArrayList<NetworkInterface>();
    private static boolean first_check = true;
    private static boolean check_in_progress;
    private static AESemaphore ni_sem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        long now = SystemTime.getMonotonousTime();
        boolean do_check = false;
        boolean is_first = false;
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (!(check_in_progress || last_ni_check >= 0L && now - last_ni_check <= (long)current_check_millis)) {
                do_check = true;
                check_in_progress = true;
                if (first_check) {
                    first_check = false;
                    is_first = true;
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (do_check) {
                final UtilitiesImpl.runnableWithException<SocketException> do_it = new UtilitiesImpl.runnableWithException<SocketException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws SocketException {
                        ArrayList<NetworkInterface> result = new ArrayList<NetworkInterface>();
                        try {
                            long start = SystemTime.getHighPrecisionCounter();
                            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                            long elapsed_millis = (SystemTime.getHighPrecisionCounter() - start) / 1000000L;
                            long old_period = current_check_millis;
                            if (elapsed_millis > (long)(Constants.isAndroid ? 5000 : 1000) && current_check_millis < 900000) {
                                current_check_millis = 900000;
                            } else if (elapsed_millis > (long)(Constants.isAndroid ? 1000 : 250) && current_check_millis < 120000) {
                                current_check_millis = 120000;
                            }
                            if (old_period != (long)current_check_millis) {
                                Debug.out("Network interface enumeration took " + elapsed_millis + ": decreased refresh frequency to " + current_check_millis + "ms");
                            }
                            if (nis != null) {
                                while (nis.hasMoreElements()) {
                                    result.add(nis.nextElement());
                                }
                            }
                            Object var10_6 = null;
                            Class<NetUtils> clazz = NetUtils.class;
                        }
                        catch (Throwable throwable) {
                            Object var10_7 = null;
                            Class<NetUtils> clazz = NetUtils.class;
                            synchronized (NetUtils.class) {
                                check_in_progress = false;
                                current_interfaces = result;
                                last_ni_check = SystemTime.getMonotonousTime();
                                // ** MonitorExit[var11_9] (shouldn't be in output)
                                ni_sem.releaseForever();
                                throw throwable;
                            }
                        }
                        synchronized (NetUtils.class) {
                            check_in_progress = false;
                            current_interfaces = result;
                            last_ni_check = SystemTime.getMonotonousTime();
                            // ** MonitorExit[var11_8] (shouldn't be in output)
                            ni_sem.releaseForever();
                            return;
                        }
                    }
                };
                if (is_first) {
                    final AESemaphore do_it_sem = new AESemaphore("getNIs");
                    final SocketException[] error = new SocketException[]{null};
                    new AEThread2("getNIAsync"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                try {
                                    do_it.run();
                                }
                                catch (SocketException e) {
                                    error[0] = e;
                                    Object var3_2 = null;
                                    do_it_sem.release();
                                }
                                Object var3_1 = null;
                                do_it_sem.release();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                do_it_sem.release();
                                throw throwable;
                            }
                        }
                    }.start();
                    if (!do_it_sem.reserve(15000L)) {
                        Debug.out("Timeout obtaining network interfaces");
                        ni_sem.releaseForever();
                    } else if (error[0] != null) {
                        throw error[0];
                    }
                } else {
                    do_it.run();
                }
            }
            ni_sem.reserve();
            return current_interfaces;
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Throwable e) {
            try {
                List<NetworkInterface> nis = NetUtils.getNetworkInterfaces();
                for (NetworkInterface ni : nis) {
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                        return address;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return InetAddress.getByName("127.0.0.1");
        }
    }

    static {
        ni_sem = new AESemaphore("NetUtils:ni");
    }
}

