/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.DataSourceUtils;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_TorrentDetailsView
extends SkinView
implements DownloadManagerListener,
ObfusticateTab,
UIUpdatable,
UIPluginViewToolBarListener,
SelectedContentListener {
    private DownloadManager manager;
    private CTabFolder folder;
    private ArrayList<UISWTViewCore> tabViews = new ArrayList();
    int lastCompleted = -1;
    private GlobalManagerAdapter gmListener;
    private Composite parent;
    protected UISWTViewCore activeView;
    private FilterCheckHandler filter_check_handler;
    private volatile int selection_count = 0;
    private volatile long selection_size;
    private volatile long selection_done;
    private SWTSkinObjectTextbox soFilterTextBox;
    private SWTSkinObjectText soInfoArea;
    private MdiEntrySWT mdi_entry;

    public SBC_TorrentDetailsView() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                SBC_TorrentDetailsView.this.gmListener = new GlobalManagerAdapter(){

                    public void downloadManagerRemoved(DownloadManager dm) {
                        if (dm.equals(SBC_TorrentDetailsView.this.manager)) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    SBC_TorrentDetailsView.this.getMainSkinObject().dispose();
                                }
                            });
                        }
                    }
                };
                gm.addListener(SBC_TorrentDetailsView.this.gmListener, false);
            }
        });
    }

    public static DownloadManager dataSourceToDownloadManager(Object ds) {
        DownloadManager dm = null;
        if (ds instanceof DownloadImpl) {
            DownloadImpl dataSourcePlugin = (DownloadImpl)ds;
            dm = dataSourcePlugin.getDownload();
        } else if (ds instanceof DownloadManager) {
            dm = (DownloadManager)ds;
        } else if (ds instanceof Object[] && ((Object[])ds)[0] instanceof DownloadManager) {
            Object[] o = (Object[])ds;
            dm = (DownloadManager)o[0];
        } else if (ds instanceof String) {
            String s = (String)ds;
            dm = DataSourceUtils.getDM(s);
        } else {
            dm = null;
        }
        return dm;
    }

    private void dataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        this.manager = SBC_TorrentDetailsView.dataSourceToDownloadManager(newDataSource);
        if (newDataSource instanceof Object[] && ((Object[])newDataSource)[1] instanceof PEPeer) {
            Object[] o = (Object[])newDataSource;
            PeersView pv = (PeersView)this.showView(PeersView.class);
            if (pv != null) {
                pv.selectPeer((PEPeer)o[1]);
            }
        }
        if (this.manager != null) {
            this.manager.addListener(this);
        }
        for (int i = 0; i < this.tabViews.size(); ++i) {
            UISWTViewCore view = this.tabViews.get(i);
            if (view == null) continue;
            view.triggerEvent(1, newDataSource);
        }
        this.refreshTitle();
    }

    private void delete() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.getUIUpdater().removeUpdater(this);
        }
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        try {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this.gmListener);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        if (this.folder != null && !this.folder.isDisposed()) {
            this.folder.setSelection(0);
        }
        if (Utils.isCarbon && this.folder != null && !this.folder.isDisposed()) {
            Utils.disposeSWTObjects(this.folder.getItems());
        }
        for (int i = 0; i < this.tabViews.size(); ++i) {
            UISWTViewCore view = this.tabViews.get(i);
            try {
                if (view == null) continue;
                view.triggerEvent(7, null);
                continue;
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        this.tabViews.clear();
        Utils.disposeSWTObjects(new Object[]{this.folder, this.parent});
    }

    private void initialize(Composite composite) {
        UISWTInstance pluginUI;
        Composite main_area = new Composite(composite, 0);
        main_area.setLayout((Layout)new FormLayout());
        this.parent = composite;
        if (this.folder == null) {
            this.folder = new CTabFolder(main_area, 16384);
            this.folder.setBorderVisible(true);
        } else {
            System.out.println("ManagerView::initialize : folder isn't null !!!");
        }
        FormData formData = Utils.getFilledFormData();
        this.folder.setLayoutData((Object)formData);
        if (composite.getLayout() instanceof FormLayout) {
            main_area.setLayoutData((Object)Utils.getFilledFormData());
        } else if (composite.getLayout() instanceof GridLayout) {
            main_area.setLayoutData((Object)new GridData(1808));
        }
        this.folder.setTabHeight(20);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null) {
            MyTorrentsView.registerPluginViews(pluginUI);
            for (String id : new String[]{"MyTorrents", "TorrentDetailsView"}) {
                UISWTInstance.UISWTViewEventListenerWrapper[] pluginViews;
                for (UISWTInstance.UISWTViewEventListenerWrapper l : pluginViews = pluginUI.getViewListeners(id)) {
                    if (id == "MyTorrents" && l.getViewID() == "PieceInfoView" || l == null) continue;
                    try {
                        UISWTViewImpl view = new UISWTViewImpl("TorrentDetailsView", l.getViewID(), l, null);
                        this.addSection(view);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        Menu menu = new Menu((Control)this.folder);
        menu.setData("downloads", (Object)new DownloadManager[]{this.manager});
        menu.setData("is_detailed_view", (Object)true);
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu root_menu, MenuEvent menuEvent) {
                MenuFactory.buildTorrentMenu(root_menu);
            }
        });
        this.folder.setMenu(menu);
        if (Constants.isOSX) {
            this.folder.addListener(35, new Listener(){

                public void handleEvent(Event event2) {
                    Display display = SBC_TorrentDetailsView.this.folder.getDisplay();
                    Point pp_rel = display.map(null, (Control)SBC_TorrentDetailsView.this.folder, event2.x, event2.y);
                    Control hit = Utils.findChild((Composite)SBC_TorrentDetailsView.this.folder, pp_rel.x, pp_rel.y);
                    event2.doit = hit == SBC_TorrentDetailsView.this.folder;
                }
            });
        }
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                SBC_TorrentDetailsView.this.selectView(item);
            }
        });
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (!SBC_TorrentDetailsView.this.folder.isDisposed() && SBC_TorrentDetailsView.this.folder.getItemCount() > 0) {
                    SBC_TorrentDetailsView.this.selectView(SBC_TorrentDetailsView.this.folder.getItem(0));
                }
            }
        });
        Utils.relayout((Control)this.folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectView(CTabItem item) {
        if (item == null) {
            return;
        }
        if (this.folder.getSelection() != item) {
            this.folder.setSelection(item);
        }
        this.folder.getShell().setCursor(this.folder.getDisplay().getSystemCursor(1));
        try {
            block20: {
                try {
                    UISWTViewEventListener listener;
                    UISWTViewCore view;
                    this.refresh();
                    if (this.activeView != null) {
                        this.activeView.triggerEvent(4, null);
                        UISWTViewEventListener listener2 = this.activeView.getEventListener();
                        if (listener2 instanceof UISWTViewEventListenerHolder) {
                            listener2 = ((UISWTViewEventListenerHolder)listener2).getDelegatedEventListener(this.activeView);
                        }
                        if (listener2 instanceof TableViewTab && listener2 instanceof TableViewFilterCheck) {
                            TableViewTab tvt = (TableViewTab)listener2;
                            TableViewSWT tv = tvt.getTableView();
                            tv.disableFilterCheck();
                        }
                    }
                    if ((view = (UISWTViewCore)item.getData("IView")) == null) {
                        Class cla = (Class)item.getData("claEventListener");
                        UISWTViewEventListener l = (UISWTViewEventListener)cla.newInstance();
                        view = new UISWTViewImpl("Main", cla.getSimpleName(), l, this.manager);
                        item.setData("IView", (Object)view);
                    }
                    if (this.mdi_entry != null) {
                        String id = "";
                        if (this.activeView instanceof UISWTViewImpl) {
                            id = "" + ((UISWTViewImpl)this.activeView).getViewID();
                            id = id.substring(id.lastIndexOf(".") + 1);
                        } else if (this.activeView != null) {
                            String simpleName = this.activeView.getClass().getName();
                            id = simpleName.substring(simpleName.lastIndexOf(".") + 1);
                        } else {
                            id = "??";
                        }
                        this.mdi_entry.setLogID("DMDetails-" + id);
                    }
                    this.activeView = view;
                    if (item.getControl() == null) {
                        view.triggerEvent(1, this.manager);
                        view.initialize((Composite)this.folder);
                        item.setControl((Control)view.getComposite());
                    }
                    if ((listener = view.getEventListener()) instanceof UISWTViewEventListenerHolder) {
                        listener = ((UISWTViewEventListenerHolder)listener).getDelegatedEventListener(view);
                    }
                    if (listener instanceof TableViewTab && listener instanceof TableViewFilterCheck) {
                        TableViewTab tvt = (TableViewTab)listener;
                        TableViewFilterCheck delegate = (TableViewFilterCheck)((Object)tvt);
                        this.soFilterTextBox.setVisible(true);
                        this.filter_check_handler = new FilterCheckHandler(tvt, delegate);
                        tvt.getTableView().enableFilterCheck(this.soFilterTextBox.getTextControl(), this.filter_check_handler);
                    } else {
                        this.filter_check_handler = null;
                        this.soFilterTextBox.setVisible(false);
                    }
                    item.getControl().setFocus();
                    SelectedContentManager.clearCurrentlySelectedContent();
                    view.triggerEvent(3, null);
                    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uiFunctions != null) {
                        uiFunctions.refreshIconBar();
                    }
                    this.refresh();
                    if (this.mdi_entry == null) break block20;
                    this.mdi_entry.redraw();
                    ViewTitleInfoManager.refreshTitleInfo(this.mdi_entry.getViewTitleInfo());
                }
                catch (Exception e) {
                    Debug.out(e);
                    Object var7_8 = null;
                    this.folder.getShell().setCursor(null);
                    return;
                }
            }
            Object var7_7 = null;
            this.folder.getShell().setCursor(null);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.folder.getShell().setCursor(null);
            throw throwable;
        }
    }

    @Override
    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
        this.selection_count = currentContent.length;
        long total_size = 0L;
        long total_done = 0L;
        for (ISelectedContent sc : currentContent) {
            DownloadManager dm = sc.getDownloadManager();
            if (dm == null) continue;
            int file_index = sc.getFileIndex();
            if (file_index == -1) {
                DiskManagerFileInfo[] file_infos;
                for (DiskManagerFileInfo file_info : file_infos = dm.getDiskManagerFileInfoSet().getFiles()) {
                    if (file_info.isSkipped()) continue;
                    total_size += file_info.getLength();
                    total_done += file_info.getDownloaded();
                }
                continue;
            }
            DiskManagerFileInfo file_info = dm.getDiskManagerFileInfoSet().getFiles()[file_index];
            if (file_info.isSkipped()) continue;
            total_size += file_info.getLength();
            total_done += file_info.getDownloaded();
        }
        this.selection_size = total_size;
        this.selection_done = total_done;
        if (this.filter_check_handler != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SBC_TorrentDetailsView.this.filter_check_handler.updateHeader();
                }
            });
        } else if (this.soInfoArea != null) {
            TableView view = SelectedContentManager.getCurrentlySelectedTableView();
            String s = "";
            if (view != null) {
                int total = view.size(false);
                s = MessageText.getString("library.unopened.header" + (total > 1 ? ".p" : ""), new String[]{String.valueOf(total)});
                if (this.selection_count > 1) {
                    s = s + this.getSelectionText();
                }
            }
            this.soInfoArea.setText(s);
        }
    }

    private String getSelectionText() {
        String str = ", " + MessageText.getString("label.num_selected", new String[]{String.valueOf(this.selection_count)});
        if (this.selection_size > 0L) {
            str = this.selection_size == this.selection_done ? str + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + ")" : str + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_done) + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + ")";
        }
        return str;
    }

    protected Object showView(Class view_class) {
        CTabItem[] items = this.folder.getItems();
        for (int i = 0; i < items.length; ++i) {
            UISWTViewEventListenerHolder lh;
            UISWTViewEventListener delegated_listener;
            CTabItem item = items[i];
            UISWTViewCore view = (UISWTViewCore)item.getData("IView");
            UISWTViewEventListener listener = view.getEventListener();
            if (!(listener instanceof UISWTViewEventListenerHolder) || !view_class.isInstance(delegated_listener = (lh = (UISWTViewEventListenerHolder)listener).getDelegatedEventListener(view))) continue;
            this.selectView(item);
            return delegated_listener;
        }
        return null;
    }

    private UISWTViewCore getActiveView() {
        return this.activeView;
    }

    private void refresh() {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        try {
            UISWTViewCore view = this.getActiveView();
            if (view != null) {
                view.triggerEvent(5, null);
            }
            CTabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                CTabItem item = items[i];
                view = (UISWTViewCore)item.getData("IView");
                try {
                    if (item.isDisposed() || view == null) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getFullTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(SBC_TorrentDetailsView.escapeAccelerators(newTitle));
                    }
                    String lastToolTip = item.getToolTipText();
                    String newToolTip = view.getFullTitle();
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    item.setToolTipText(newToolTip);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void refreshTitle() {
        int completed;
        int n = completed = this.manager == null ? -1 : this.manager.getStats().getCompleted();
        if (this.lastCompleted != completed) {
            if (this.mdi_entry != null) {
                ViewTitleInfoManager.refreshTitleInfo(this.mdi_entry.getViewTitleInfo());
            }
            this.lastCompleted = completed;
        }
    }

    protected static String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        UIPluginViewToolBarListener l;
        UISWTViewCore active_view = this.getActiveView();
        if (active_view != null && (l = active_view.getToolBarListener()) != null) {
            l.refreshToolBarItems(list);
            return;
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        UIPluginViewToolBarListener l;
        UISWTViewCore active_view = this.getActiveView();
        if (active_view != null && (l = active_view.getToolBarListener()) != null && l.toolBarItemActivated(item, activationType, datasource)) {
            return true;
        }
        String itemKey = item.getID();
        if (itemKey.equals("editcolumns") && active_view instanceof ToolBarEnabler) {
            return ((ToolBarEnabler)((Object)active_view)).toolBarItemActivated(itemKey);
        }
        return false;
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        Display display = this.folder.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        });
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void addSection(UISWTViewImpl view) {
        DownloadImpl pluginDataSource = null;
        try {
            pluginDataSource = DownloadManagerImpl.getDownloadStatic(this.manager);
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
        this.addSection(view, pluginDataSource);
    }

    private void addSection(UISWTViewCore view, Object dataSource) {
        if (view == null) {
            return;
        }
        view.triggerEvent(1, dataSource);
        CTabItem item = new CTabItem(this.folder, 0);
        Messages.setLanguageText((Widget)item, view.getTitleID());
        item.setData("IView", (Object)view);
        this.tabViews.add(view);
    }

    @Override
    public String getObfusticatedHeader() {
        int completed = this.manager.getStats().getCompleted();
        return DisplayFormatters.formatPercentFromThousands(completed) + " : " + this.manager;
    }

    public DownloadManager getDownload() {
        return this.manager;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    @Override
    public String getUpdateUIName() {
        return "DMDetails";
    }

    @Override
    public void updateUI() {
        this.refreshTitle();
        this.refresh();
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soListArea = this.getSkinObject("torrentdetails-list-area");
        this.soFilterTextBox = (SWTSkinObjectTextbox)this.getSkinObject("torrentdetails-filter");
        this.soInfoArea = (SWTSkinObjectText)this.getSkinObject("torrentdetails-info");
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            this.mdi_entry = mdi.getEntryFromSkinObject(skinObject);
            if (this.mdi_entry == null) {
                Debug.out("Failed to get MDI entry from skin object, reverting to using 'current'");
                this.mdi_entry = mdi.getCurrentEntrySWT();
            }
            this.mdi_entry.addToolbarEnabler(this);
        }
        this.initialize((Composite)soListArea.getControl());
        return null;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        UISWTViewCore view = this.getActiveView();
        if (view != null) {
            view.triggerEvent(3, null);
        }
        this.refresh();
        return super.skinObjectShown(skinObject, params);
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        UISWTViewCore view = this.getActiveView();
        if (view != null) {
            view.triggerEvent(4, null);
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.delete();
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public Object updateLanguage(SWTSkinObject skinObject, Object params) {
        Messages.updateLanguageForControl((Widget)this.folder);
        return super.updateLanguage(skinObject, params);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        this.dataSourceChanged(params);
        return super.dataSourceChanged(skinObject, params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterCheckHandler
    implements TableViewFilterCheck.TableViewFilterCheckEx<Object> {
        private TableViewTab<Object> tvt;
        private TableViewFilterCheck delegate;
        boolean enabled;
        int value;

        private FilterCheckHandler(TableViewTab<Object> _tvt, TableViewFilterCheck _delegate) {
            this.tvt = _tvt;
            this.delegate = _delegate;
            this.updateHeader();
        }

        @Override
        public boolean filterCheck(Object ds, String filter2, boolean regex) {
            return this.delegate.filterCheck(ds, filter2, regex);
        }

        @Override
        public void filterSet(String filter2) {
            boolean was_enabled = this.enabled;
            this.enabled = filter2 != null && filter2.length() > 0;
            this.delegate.filterSet(filter2);
            if (this.enabled != was_enabled) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FilterCheckHandler.this.updateHeader();
                    }
                });
            }
        }

        @Override
        public void viewChanged(TableView<Object> view) {
            this.value = view.size(false);
            if (this.enabled) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FilterCheckHandler.this.updateHeader();
                    }
                });
            }
        }

        private void updateHeader() {
            int total = SBC_TorrentDetailsView.this.manager.getNumFileInfos();
            String s = MessageText.getString("library.unopened.header" + (total > 1 ? ".p" : ""), new String[]{String.valueOf(total)});
            if (this.enabled) {
                String extra = MessageText.getString("filter.header.matches1", new String[]{String.valueOf(this.value)});
                s = s + " " + extra;
            }
            if (SBC_TorrentDetailsView.this.selection_count > 1) {
                s = s + SBC_TorrentDetailsView.this.getSelectionText();
            }
            if (SBC_TorrentDetailsView.this.soInfoArea != null) {
                SBC_TorrentDetailsView.this.soInfoArea.setText(s);
            }
        }
    }
}

